/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.report.chart.core.series;

import com.stimulsoft.base.context.chart.StiContext;
import com.stimulsoft.base.drawing.StiBrush;
import com.stimulsoft.base.drawing.StiColor;
import com.stimulsoft.base.drawing.StiGlareBrush;
import com.stimulsoft.base.drawing.StiGradientBrush;
import com.stimulsoft.base.serializing.annotations.StiSerializable;
import com.stimulsoft.base.serializing.annotations.StiSerializeTypesEnum;
import com.stimulsoft.base.system.geometry.StiRectangle;
import com.stimulsoft.report.chart.core.series.doughnut.StiDoughnutSeriesCoreXF;
import com.stimulsoft.report.chart.core.styles.StiStyleCoreXF;
import com.stimulsoft.report.chart.core.styles.StiStyleCoreXF01;
import com.stimulsoft.report.chart.enums.StiShowSeriesLabels;
import com.stimulsoft.report.chart.geoms.StiCellGeom;
import com.stimulsoft.report.chart.geoms.areas.StiAreaGeom;
import com.stimulsoft.report.chart.geoms.seriesLabels.StiSeriesLabelsGeom;
import com.stimulsoft.report.chart.interfaces.IStiApplyStyleSeries;
import com.stimulsoft.report.chart.interfaces.IStiSeriesInteraction;
import com.stimulsoft.report.chart.interfaces.areas.clusteredBar.IStiClusteredBarArea;
import com.stimulsoft.report.chart.interfaces.series.IStiSeries;
import com.stimulsoft.report.chart.interfaces.seriesLabels.IStiSeriesLabels;
import com.stimulsoft.report.chart.interfaces.seriesLabels.axis.IStiAxisSeriesLabels;
import com.stimulsoft.report.chart.interfaces.styles.IStiChartStyle;
import java.util.ArrayList;
import java.util.Hashtable;

public abstract class StiSeriesCoreXF
implements Cloneable,
IStiApplyStyleSeries {
    private static Object FalseObject = new Object();
    private static Object TrueObject = new Object();
    private Hashtable isMouseOverSeriesElementHashtable = null;
    private boolean isMouseOver = false;
    private boolean isDateTimeValues = false;
    private IStiSeries series;

    public final Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void ApplyStyle(IStiChartStyle style, StiColor color) {
        if (this.getSeries().getAllowApplyStyle()) {
            this.getSeries().setShowShadow(style.getCore().isSeriesShowShadow());
            if (this.getSeries().getSeriesLabels() != null) {
                this.getSeries().getSeriesLabels().getCore().applyStyle(style);
            }
        }
    }

    protected final StiRectangle CheckLabelsRect(IStiSeriesLabels labels, StiAreaGeom geom, StiRectangle labelsRect) {
        if (labels != null && labels.getPreventIntersection()) {
            if (labelsRect.x < 0.0) {
                labelsRect.x = 0.0;
            }
            if (labelsRect.y < 0.0) {
                labelsRect.y = 0.0;
            }
            if (labelsRect.getRight() > geom.getClientRectangle().width) {
                labelsRect.x = geom.getClientRectangle().width - labelsRect.width;
            }
            if (labelsRect.getBottom() > geom.getClientRectangle().height) {
                labelsRect.y = geom.getClientRectangle().height - labelsRect.height;
            }
        }
        return labelsRect;
    }

    protected final void CheckIntersectionLabels(StiAreaGeom geom) {
        ArrayList<StiCellGeom> childGeoms = geom.getChildGeoms();
        ArrayList<StiSeriesLabelsGeom> labelGeoms = new ArrayList<StiSeriesLabelsGeom>();
        for (StiCellGeom cellGeom : childGeoms) {
            if (!(cellGeom instanceof StiSeriesLabelsGeom)) continue;
            labelGeoms.add((StiSeriesLabelsGeom)cellGeom);
        }
        int count = labelGeoms.size();
        boolean intersection = true;
        int indexCheck = 0;
        while (intersection && indexCheck < 20) {
            ++indexCheck;
            for (int index1 = 0; index1 < count; ++index1) {
                for (int index2 = 0; index2 < count; ++index2) {
                    if (index2 == index1 || !((StiSeriesLabelsGeom)labelGeoms.get(index1)).getClientRectangle().intersectsWith(((StiSeriesLabelsGeom)labelGeoms.get(index2)).getClientRectangle()).booleanValue()) continue;
                    StiRectangle rect1 = ((StiSeriesLabelsGeom)labelGeoms.get(index1)).getClientRectangle();
                    StiRectangle rect2 = ((StiSeriesLabelsGeom)labelGeoms.get(index2)).getClientRectangle();
                    double overlay = rect1.height - Math.abs(((StiSeriesLabelsGeom)labelGeoms.get((int)index2)).getClientRectangle().y - ((StiSeriesLabelsGeom)labelGeoms.get((int)index1)).getClientRectangle().y);
                    if (rect1.y > rect2.y) {
                        rect1.y += overlay / 2.0;
                        rect2.y -= overlay / 2.0;
                    } else {
                        rect1.y -= overlay / 2.0;
                        rect2.y += overlay / 2.0;
                    }
                    if (rect1.y < 0.0) {
                        rect1.y = 0.0;
                    }
                    if (rect2.y < 0.0) {
                        rect2.y = 0.0;
                    }
                    ((StiSeriesLabelsGeom)labelGeoms.get(index1)).setClientRectangle(rect1);
                    ((StiSeriesLabelsGeom)labelGeoms.get(index2)).setClientRectangle(rect2);
                }
            }
        }
    }

    public void RenderSeries(StiContext context, StiRectangle rect, StiAreaGeom geom, IStiSeries[] seriesArray) {
    }

    public StiBrush GetSeriesBrush(int colorIndex, int colorCount) {
        if (this.getSeries().getChart() == null || this.getSeries().getChart().getArea() == null) {
            return null;
        }
        if (this.getSeries().getChart().getArea().getColorEach() || this instanceof StiDoughnutSeriesCoreXF) {
            StiStyleCoreXF01 styleCore = this.getSeries().getChart().getStyle() != null ? this.getSeries().getChart().getStyle().getCore() : new StiStyleCoreXF01();
            StiColor color = styleCore.GetColorByIndex(colorIndex, colorCount);
            StiBrush seriesBrush = ((StiStyleCoreXF)styleCore).GetColumnBrush(color);
            if (this.getSeries().getChart().getArea() instanceof IStiClusteredBarArea) {
                if (seriesBrush instanceof StiGradientBrush) {
                    ((StiGradientBrush)seriesBrush).angle += 90.0;
                }
                if (seriesBrush instanceof StiGlareBrush) {
                    ((StiGlareBrush)seriesBrush).angle += 90.0;
                }
            }
            return seriesBrush;
        }
        return null;
    }

    public Object GetSeriesBorderColor(int colorIndex, int colorCount) {
        if (this.getSeries().getChart() == null || this.getSeries().getChart().getArea() == null) {
            return null;
        }
        if (this.getSeries().getChart().getArea().getColorEach() || this instanceof StiDoughnutSeriesCoreXF) {
            StiStyleCoreXF01 styleCore = this.getSeries().getChart().getStyle() != null ? this.getSeries().getChart().getStyle().getCore() : new StiStyleCoreXF01();
            StiColor color = styleCore.GetColorByIndex(colorIndex, colorCount);
            return styleCore.GetColumnBorder(color);
        }
        return null;
    }

    public final IStiAxisSeriesLabels GetSeriesLabels() {
        if (this.getSeries().getShowSeriesLabels() == StiShowSeriesLabels.FromChart) {
            IStiSeriesLabels tempVar = this.getSeries().getChart().getSeriesLabels();
            return (IStiAxisSeriesLabels)(tempVar instanceof IStiAxisSeriesLabels ? tempVar : null);
        }
        if (this.getSeries().getShowSeriesLabels() == StiShowSeriesLabels.FromSeries) {
            IStiSeriesLabels tempVar2 = this.getSeries().getSeriesLabels();
            return (IStiAxisSeriesLabels)(tempVar2 instanceof IStiAxisSeriesLabels ? tempVar2 : null);
        }
        return null;
    }

    public final String GetTag(int tagIndex) {
        if (this.series.getTags() != null && tagIndex < this.series.getTags().length && this.series.getTags()[tagIndex] != null) {
            return this.series.getTags()[tagIndex].toString();
        }
        return "";
    }

    public final boolean GetIsMouseOverSeriesElement(int seriesIndex) {
        if (this.isMouseOverSeriesElementHashtable == null) {
            return false;
        }
        return this.isMouseOverSeriesElementHashtable.get(seriesIndex) == TrueObject;
    }

    public final void SetIsMouseOverSeriesElement(int seriesIndex, boolean value) {
        if (this.isMouseOverSeriesElementHashtable == null) {
            this.isMouseOverSeriesElementHashtable = new Hashtable();
        }
        this.isMouseOverSeriesElementHashtable.put(seriesIndex, value ? TrueObject : FalseObject);
    }

    public final boolean getIsMouseOver() {
        return this.isMouseOver;
    }

    public final void setIsMouseOver(boolean value) {
        this.isMouseOver = value;
    }

    public abstract String getLocalizedName();

    @StiSerializable(type=StiSerializeTypesEnum.SerializeToDocument)
    public final boolean getIsDateTimeValues() {
        return this.isDateTimeValues;
    }

    public final void setIsDateTimeValues(boolean value) {
        this.isDateTimeValues = value;
    }

    public final IStiSeries getSeries() {
        return this.series;
    }

    public final void setSeries(IStiSeries value) {
        this.series = value;
    }

    public final IStiSeriesInteraction getInteraction() {
        return this.getSeries().getInteraction();
    }

    public final void setInteraction(IStiSeriesInteraction value) {
        this.getSeries().setInteraction(value);
    }

    public StiSeriesCoreXF(IStiSeries series) {
        this.series = series;
    }
}

