/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.report.chart.core.series.clusteredColumn;

import com.stimulsoft.base.context.chart.StiContext;
import com.stimulsoft.base.context.chart.animation.StiAnimation;
import com.stimulsoft.base.context.chart.animation.StiColumnAnimation;
import com.stimulsoft.base.context.chart.animation.StiLabelAnimation;
import com.stimulsoft.base.drawing.StiBrush;
import com.stimulsoft.base.drawing.StiColor;
import com.stimulsoft.base.localization.StiLocalization;
import com.stimulsoft.base.system.geometry.StiPoint;
import com.stimulsoft.base.system.geometry.StiRectangle;
import com.stimulsoft.report.chart.StiChart;
import com.stimulsoft.report.chart.StiChartHelper;
import com.stimulsoft.report.chart.core.area.StiAxisAreaCoreXF;
import com.stimulsoft.report.chart.core.axis.stripLines.StiStripLineXF;
import com.stimulsoft.report.chart.core.series.StiSeriesCoreXF;
import com.stimulsoft.report.chart.core.seriesLabels.axis.StiAxisSeriesLabelsCoreXF;
import com.stimulsoft.report.chart.enums.StiSeriesYAxis;
import com.stimulsoft.report.chart.geoms.areas.StiAreaGeom;
import com.stimulsoft.report.chart.geoms.areas.StiAxisAreaGeom;
import com.stimulsoft.report.chart.geoms.series.clusteredColumn.StiClusteredColumnSeriesElementGeom;
import com.stimulsoft.report.chart.geoms.seriesLabels.StiSeriesLabelsGeom;
import com.stimulsoft.report.chart.interfaces.areas.IStiArea;
import com.stimulsoft.report.chart.interfaces.areas.IStiAxisArea;
import com.stimulsoft.report.chart.interfaces.series.IStiSeries;
import com.stimulsoft.report.chart.interfaces.series.clusteredColumn.IStiClusteredColumnSeries;
import com.stimulsoft.report.chart.interfaces.seriesLabels.axis.IStiAxisSeriesLabels;
import com.stimulsoft.report.chart.interfaces.styles.IStiChartStyle;
import com.stimulsoft.report.chart.interfaces.trendLines.IStiTrendLine;
import com.stimulsoft.report.chart.interfaces.trendLines.IStiTrendLineNone;
import com.stimulsoft.report.chart.view.series.StiSeries;
import com.stimulsoft.report.chart.view.series.StiSeriesInteractionData;
import java.util.ArrayList;

public class StiClusteredColumnSeriesCoreXF
extends StiSeriesCoreXF {
    @Override
    public void ApplyStyle(IStiChartStyle style, StiColor color) {
        super.ApplyStyle(style, color);
        if (this.getSeries().getAllowApplyStyle()) {
            ((IStiClusteredColumnSeries)this.getSeries()).setBrush(style.getCore().GetColumnBrush(color));
            ((IStiClusteredColumnSeries)this.getSeries()).setBorderColor(style.getCore().GetColumnBorder(color));
        }
    }

    @Override
    public void RenderSeries(StiContext context, StiRectangle rect, StiAreaGeom geom, IStiSeries[] series) {
        ArrayList<StiSeriesLabelsGeom> seriesLabelsList = new ArrayList<StiSeriesLabelsGeom>();
        IStiArea area = geom.getArea();
        if (series == null || series.length == 0 || this.getSeries().getChart() == null) {
            return;
        }
        boolean isAnimationChangingValues = ((StiChart)this.getSeries().getChart()).isAnimationChangingValues();
        IStiAxisArea axisArea = (IStiAxisArea)(area instanceof IStiAxisArea ? area : null);
        IStiSeries tempVar = this.getSeries();
        IStiClusteredColumnSeries columnSeries = (IStiClusteredColumnSeries)(tempVar instanceof IStiClusteredColumnSeries ? tempVar : null);
        double posY = axisArea.getAxisCore().GetDividerY();
        double posRightY = axisArea.getAxisCore().GetDividerRightY();
        int colorIndex = 0;
        int colorCount = axisArea.getAxisCore().ValuesCount * series.length;
        ArrayList pointsLists = new ArrayList();
        for (int index = 0; index < series.length; ++index) {
            pointsLists.add(new ArrayList());
        }
        for (int pointIndex = 0; pointIndex < axisArea.getAxisCore().ValuesCount; ++pointIndex) {
            double posX = axisArea.getXAxis().getCore().GetStartFromZero() ? axisArea.getXAxis().getInfo().StripPositions[pointIndex + 1] : axisArea.getXAxis().getInfo().StripPositions[pointIndex];
            posX -= (double)(axisArea.getXAxis().getInfo().Step / 2.0f);
            double sumSeriesWidth = 0.0;
            for (IStiSeries ser : series) {
                sumSeriesWidth += (double)(axisArea.getXAxis().getInfo().Step / (float)series.length * ((IStiClusteredColumnSeries)ser).getWidth());
            }
            double seriesLeftPos = posX + ((double)axisArea.getXAxis().getInfo().Step - sumSeriesWidth) / 2.0;
            int seriesIndex = 0;
            if (axisArea.getReverseHor()) {
                seriesIndex = series.length - 1;
            }
            while (seriesIndex < series.length && !axisArea.getReverseHor() || seriesIndex >= 0 && axisArea.getReverseHor()) {
                IStiClusteredColumnSeries currentSeries = (IStiClusteredColumnSeries)(series[seriesIndex] instanceof IStiClusteredColumnSeries ? series[seriesIndex] : null);
                double seriesWidth = axisArea.getXAxis().getInfo().Step / (float)series.length * currentSeries.getWidth();
                if (pointIndex < currentSeries.getValues().length) {
                    Double value;
                    Double d = value = axisArea.getReverseHor() ? currentSeries.getValues()[currentSeries.getValues().length - pointIndex - 1] : currentSeries.getValues()[pointIndex];
                    if (axisArea.getReverseVert() && value != null) {
                        value = -value.doubleValue();
                    }
                    StiRectangle columnRect = this.GetColumnRect(context, currentSeries, value, seriesLeftPos, seriesWidth);
                    StiRectangle rectFrom = StiRectangle.empty();
                    Double valueFrom = null;
                    if (isAnimationChangingValues) {
                        if (currentSeries.getValuesStart().length > pointIndex) {
                            Double d2 = valueFrom = axisArea.getReverseHor() ? currentSeries.getValuesStart()[currentSeries.getValuesStart().length - pointIndex - 1] : currentSeries.getValuesStart()[pointIndex];
                        }
                        if (axisArea.getReverseVert() && valueFrom != null) {
                            valueFrom = -valueFrom.doubleValue();
                        }
                        rectFrom = this.GetColumnRect(context, currentSeries, valueFrom, seriesLeftPos, seriesWidth);
                    }
                    if (!(((StiSeries)((Object)currentSeries)).getTrendLine() instanceof IStiTrendLineNone)) {
                        ((ArrayList)pointsLists.get(seriesIndex)).add(new StiPoint(seriesLeftPos + seriesWidth / 2.0, columnRect.y));
                    }
                    StiRectangle clipRect = ((StiAxisAreaGeom)geom).getView().getClientRectangle();
                    clipRect.x = 0.0;
                    clipRect.y = 0.0;
                    StiRectangle columnRectCheck = columnRect;
                    columnRectCheck.x += geom.getClientRectangle().x;
                    columnRectCheck.y += geom.getClientRectangle().y;
                    if (columnRectCheck.getRight() > clipRect.x && columnRectCheck.x < clipRect.getRight() || ((IStiAxisArea)this.getSeries().getChart().getArea()).getXAxis().getRange().getAuto()) {
                        IStiAxisSeriesLabels labels;
                        StiBrush seriesBrush = currentSeries.getCore().GetSeriesBrush(colorIndex, colorCount);
                        if (currentSeries.getAllowApplyBrushNegative() && value != null && value < 0.0) {
                            seriesBrush = currentSeries.getBrushNegative();
                        }
                        seriesBrush = currentSeries.ProcessSeriesColors(pointIndex, seriesBrush);
                        StiColor seriesBorderColor = (StiColor)currentSeries.getCore().GetSeriesBorderColor(colorIndex, colorCount);
                        Integer time = StiChartHelper.GlobalBeginTimeElement;
                        if (this.getSeries().getChart() != null && this.getSeries().getChart().getStyle() != null && columnRect.height > 0.0) {
                            Integer beginTime = isAnimationChangingValues ? 0 : time / ((StiAxisAreaCoreXF)axisArea.getCore()).ValuesCount * pointIndex;
                            StiColumnAnimation animation = new StiColumnAnimation(Double.valueOf(valueFrom != null ? valueFrom : 0.0), rectFrom, StiChartHelper.GlobalDurationElement, beginTime);
                            StiClusteredColumnSeriesElementGeom seriesColumnGeom = new StiClusteredColumnSeriesElementGeom(geom, value == null ? 0.0 : value, pointIndex, seriesBrush, seriesBorderColor, currentSeries, columnRect, (StiAnimation)animation);
                            if (currentSeries.getCore().getInteraction() != null) {
                                StiSeriesInteractionData data = new StiSeriesInteractionData();
                                data.Fill(axisArea, currentSeries, pointIndex);
                                seriesColumnGeom.setInteraction(data);
                            }
                            geom.CreateChildGeoms();
                            geom.getChildGeoms().add(seriesColumnGeom);
                        }
                        if ((labels = currentSeries.getCore().GetSeriesLabels()) != null && labels.getVisible()) {
                            StiSeriesLabelsGeom seriesLabelsGeom;
                            StiPoint endPoint = this.GetPointEnd(currentSeries, value, seriesLeftPos, seriesWidth);
                            Double seriesValue = 0.0;
                            if (value != null) {
                                seriesValue = axisArea.getReverseVert() ? -value.doubleValue() : value;
                            }
                            StiLabelAnimation animation = null;
                            if (isAnimationChangingValues) {
                                StiPoint endPointFrom = this.GetPointEnd(currentSeries, valueFrom, seriesLeftPos, seriesWidth);
                                animation = new StiLabelAnimation(valueFrom, value, new StiPoint(endPointFrom.getX().doubleValue(), endPointFrom.getY().doubleValue()), new StiPoint(endPoint.x, endPoint.y), time, Integer.valueOf(0));
                            }
                            if ((labels.getStep() == 0 || pointIndex % labels.getStep() == 0) && (seriesLabelsGeom = ((StiAxisSeriesLabelsCoreXF)labels.getCore()).RenderLabel(currentSeries, context, this.CorrectPoint(endPoint, rect), this.CorrectPoint(new StiPoint(endPoint.x, posY), rect), pointIndex, value, seriesValue, axisArea.getAxisCore().GetArgumentLabel((StiStripLineXF)axisArea.getXAxis().getInfo().StripLines.get(pointIndex), currentSeries), this.GetTag(pointIndex), colorIndex, colorCount, rect, (StiAnimation)animation)) != null) {
                                seriesLabelsList.add(seriesLabelsGeom);
                                seriesLabelsGeom.setClientRectangle(this.CheckLabelsRect(labels, geom, seriesLabelsGeom.getClientRectangle()));
                            }
                        }
                    }
                }
                seriesLeftPos += seriesWidth;
                ++colorIndex;
                if (axisArea.getReverseHor()) {
                    --seriesIndex;
                    continue;
                }
                ++seriesIndex;
            }
        }
        for (int indexSeries = 0; indexSeries < series.length; ++indexSeries) {
            IStiTrendLine trendLine = ((StiSeries)series[indexSeries]).getTrendLine();
            if (trendLine instanceof IStiTrendLineNone) continue;
            ArrayList pointsList = (ArrayList)pointsLists.get(indexSeries);
            if (trendLine == null) continue;
            trendLine.getCore().RenderTrendLine(geom, pointsList.toArray(new StiPoint[0]), axisArea.getAxisCore().GetDividerY());
        }
        for (StiSeriesLabelsGeom seriesLabelsGeom : seriesLabelsList) {
            geom.CreateChildGeoms();
            geom.getChildGeoms().add(seriesLabelsGeom);
        }
    }

    private StiPoint CorrectPoint(StiPoint point, StiRectangle rect) {
        if (point.y < 0.0) {
            return new StiPoint(point.x, 0.0);
        }
        if (point.y > rect.height) {
            return new StiPoint(point.x, rect.height);
        }
        return point;
    }

    @Override
    public StiBrush GetSeriesBrush(int colorIndex, int colorCount) {
        StiBrush brush = super.GetSeriesBrush(colorIndex, colorCount);
        if (brush == null) {
            return ((IStiClusteredColumnSeries)this.getSeries()).getBrush();
        }
        return brush;
    }

    @Override
    public Object GetSeriesBorderColor(int colorIndex, int colorCount) {
        Object color = super.GetSeriesBorderColor(colorIndex, colorCount);
        if (color == null) {
            return ((IStiClusteredColumnSeries)this.getSeries()).getBorderColor();
        }
        return color;
    }

    @Override
    public String getLocalizedName() {
        return StiLocalization.Get((String)"Chart", (String)"ClusteredColumn");
    }

    public StiClusteredColumnSeriesCoreXF(IStiSeries series) {
        super(series);
    }

    private StiRectangle GetColumnRect(StiContext context, IStiClusteredColumnSeries currentSeries, Double value, double seriesLeftPos, double seriesWidth) {
        IStiAxisArea axisArea = (IStiAxisArea)currentSeries.getChart().getArea();
        double seriesHeight = 0.0;
        double seriesTopPos = 0.0;
        double posY = axisArea.getAxisCore().GetDividerY();
        double posRightY = axisArea.getAxisCore().GetDividerRightY();
        if (currentSeries.getYAxis() == StiSeriesYAxis.LeftYAxis) {
            seriesHeight = (float)((value == null ? 0.0 : value) * axisArea.getYAxis().getInfo().Dpi);
            seriesTopPos = -seriesHeight + posY;
        } else {
            seriesHeight = (float)((value == null ? 0.0 : value) * axisArea.getYRightAxis().getInfo().Dpi);
            seriesTopPos = -seriesHeight + posRightY;
        }
        if (currentSeries.getShowZeros() && (value == null || value == 0.0)) {
            seriesHeight = Math.max(context.Options.zoom, 2);
            if (!axisArea.getReverseVert()) {
                seriesTopPos -= seriesHeight;
            }
        }
        if (value != null && value < 0.0) {
            seriesTopPos = currentSeries.getYAxis() == StiSeriesYAxis.LeftYAxis ? posY : posRightY;
            seriesHeight = -seriesHeight;
        }
        return new StiRectangle(seriesLeftPos, seriesTopPos, seriesWidth, seriesHeight);
    }

    private StiPoint GetPointEnd(IStiClusteredColumnSeries currentSeries, Double value, double seriesLeftPos, double seriesWidth) {
        IStiAxisArea axisArea = (IStiAxisArea)currentSeries.getChart().getArea();
        double posY = axisArea.getAxisCore().GetDividerY();
        double posRightY = axisArea.getAxisCore().GetDividerRightY();
        StiPoint endPoint = currentSeries.getYAxis() == StiSeriesYAxis.LeftYAxis ? new StiPoint(seriesLeftPos + seriesWidth / 2.0, (double)(-((float)((value == null ? 0.0 : value) * axisArea.getYAxis().getInfo().Dpi))) + posY) : new StiPoint(seriesLeftPos + seriesWidth / 2.0, (double)(-((float)((value == null ? 0.0 : value) * axisArea.getYRightAxis().getInfo().Dpi))) + posRightY);
        return endPoint;
    }
}

