/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.report.chart.core.series.doughnut;

import com.stimulsoft.base.context.chart.StiContext;
import com.stimulsoft.base.context.chart.animation.StiAnimation;
import com.stimulsoft.base.context.chart.animation.StiOpacityAnimation;
import com.stimulsoft.base.context.chart.geoms.StiArcSegmentGeom;
import com.stimulsoft.base.context.chart.geoms.StiLineSegmentGeom;
import com.stimulsoft.base.context.chart.geoms.StiSegmentGeom;
import com.stimulsoft.base.drawing.StiBrush;
import com.stimulsoft.base.drawing.StiColor;
import com.stimulsoft.base.drawing.StiGlareBrush;
import com.stimulsoft.base.drawing.StiGradientBrush;
import com.stimulsoft.base.drawing.StiSolidBrush;
import com.stimulsoft.base.localization.StiLocalization;
import com.stimulsoft.base.system.StiRefObject;
import com.stimulsoft.base.system.geometry.StiPoint;
import com.stimulsoft.base.system.geometry.StiRectangle;
import com.stimulsoft.report.chart.StiChart;
import com.stimulsoft.report.chart.StiChartHelper;
import com.stimulsoft.report.chart.core.area.doughnut.StiDoughnutAreaCoreXF;
import com.stimulsoft.report.chart.core.series.pie.StiPieSeriesCoreXF;
import com.stimulsoft.report.chart.core.seriesLabels.pie.StiPieSeriesLabelsCoreXF;
import com.stimulsoft.report.chart.enums.StiShowSeriesLabels;
import com.stimulsoft.report.chart.geoms.areas.StiAreaGeom;
import com.stimulsoft.report.chart.geoms.series.doughnut.StiDoughnutSeriesElementGeom;
import com.stimulsoft.report.chart.geoms.series.pie.StiPieSeriesShadowElementGeom;
import com.stimulsoft.report.chart.geoms.seriesLabels.StiSeriesLabelsGeom;
import com.stimulsoft.report.chart.interfaces.areas.doughnut.IStiDoughnutArea;
import com.stimulsoft.report.chart.interfaces.series.IStiSeries;
import com.stimulsoft.report.chart.interfaces.series.doughnut.IStiDoughnutSeries;
import com.stimulsoft.report.chart.interfaces.series.pie.IStiPieSeries;
import com.stimulsoft.report.chart.interfaces.seriesLabels.IStiSeriesLabels;
import com.stimulsoft.report.chart.interfaces.seriesLabels.pie.IStiPieSeriesLabels;
import java.util.ArrayList;

public class StiDoughnutSeriesCoreXF
extends StiPieSeriesCoreXF {
    private StiDoughnutSeriesElementGeom RenderPieElement(StiContext context, StiPoint center, double radius, double radiusDt, StiColor borderColor, StiBrush brush, double start, double angle, Double value, int index, IStiDoughnutSeries currentSeries, boolean shadow, StiAreaGeom areaGeom, Integer beginTime) {
        if (angle == 0.0 || Double.isNaN(angle)) {
            return null;
        }
        StiRectangle rectPie = new StiRectangle(center.x - radius, center.y - radius, radius * 2.0, radius * 2.0);
        StiRectangle rectPieDt = new StiRectangle(center.x - radiusDt, center.y - radiusDt, radiusDt * 2.0, radiusDt * 2.0);
        if (rectPie.width <= 0.0 && rectPie.height <= 0.0) {
            return null;
        }
        if (!shadow) {
            Object tempVar2;
            Object tempVar;
            if (brush instanceof StiGradientBrush && (brush = (StiGradientBrush)((tempVar = brush.clone()) instanceof StiGradientBrush ? tempVar : null)) != null) {
                ((StiGradientBrush)brush).angle = -45.0;
            }
            if (brush instanceof StiGlareBrush && (brush = (StiGlareBrush)((tempVar2 = brush.clone()) instanceof StiGlareBrush ? tempVar2 : null)) != null) {
                ((StiGlareBrush)brush).angle = -45.0;
            }
        }
        ArrayList<StiSegmentGeom> path = new ArrayList<StiSegmentGeom>();
        StiGradientBrush brLight = null;
        StiGradientBrush brDark = null;
        ArrayList<StiSegmentGeom> pathLight = null;
        ArrayList<StiSegmentGeom> pathDark = null;
        double lightWidth = 0.0;
        if (currentSeries.getLighting() && !shadow) {
            pathLight = new ArrayList<StiSegmentGeom>();
            pathDark = new ArrayList<StiSegmentGeom>();
            lightWidth = radius * (double)0.02f;
            brLight = new StiGradientBrush(StiColor.FromArgb((int)100, (StiColor)StiColor.White), StiColor.FromArgb((int)50, (StiColor)StiColor.Black), 45.0);
            brDark = new StiGradientBrush(StiColor.FromArgb((int)50, (StiColor)StiColor.Black), StiColor.FromArgb((int)100, (StiColor)StiColor.White), 45.0);
        }
        StiChart chart = (StiChart)this.getSeries().getChart();
        path.add((StiSegmentGeom)new StiArcSegmentGeom(rectPie, start, angle));
        if (angle - start != 360.0) {
            path.add((StiSegmentGeom)new StiLineSegmentGeom(this.GetPoint(center, radius, start + angle), this.GetPoint(center, radiusDt, start + angle)));
        }
        path.add((StiSegmentGeom)new StiArcSegmentGeom(rectPieDt, start + angle, -angle));
        if (angle - start != 360.0) {
            path.add((StiSegmentGeom)new StiLineSegmentGeom(this.GetPoint(center, radiusDt, start), this.GetPoint(center, radius, start)));
        }
        if (shadow) {
            if (chart.isAnimation) {
                StiOpacityAnimation animation = new StiOpacityAnimation(Integer.valueOf(1000), beginTime);
                context.FillDrawAnimationPath((Object)brush, null, path, (Object)rectPie, null, (StiAnimation)animation, null);
            } else {
                context.FillPath((Object)brush, path, (Object)rectPie, null);
            }
        }
        if (brLight != null && !shadow) {
            pathLight.add((StiSegmentGeom)new StiLineSegmentGeom(this.GetPoint(center, radius - lightWidth, start), this.GetPoint(center, radius, start)));
            pathLight.add((StiSegmentGeom)new StiArcSegmentGeom(rectPie, start, angle));
            pathLight.add((StiSegmentGeom)new StiLineSegmentGeom(this.GetPoint(center, radius, start + angle), this.GetPoint(center, radius - lightWidth, start + angle)));
            pathLight.add((StiSegmentGeom)new StiArcSegmentGeom(new StiRectangle(rectPie.x + lightWidth, rectPie.y + lightWidth, rectPie.width - lightWidth * 2.0, rectPie.height - lightWidth * 2.0), start + angle, -angle));
            pathDark.add((StiSegmentGeom)new StiLineSegmentGeom(this.GetPoint(center, radiusDt + lightWidth, start), this.GetPoint(center, radiusDt, start)));
            pathDark.add((StiSegmentGeom)new StiArcSegmentGeom(rectPieDt, start, angle));
            pathDark.add((StiSegmentGeom)new StiLineSegmentGeom(this.GetPoint(center, radiusDt, start + angle), this.GetPoint(center, radiusDt + lightWidth, start + angle)));
            pathDark.add((StiSegmentGeom)new StiArcSegmentGeom(new StiRectangle(rectPieDt.x - lightWidth, rectPieDt.y - lightWidth, rectPieDt.width + lightWidth * 2.0, rectPieDt.height + lightWidth * 2.0), start + angle, -angle));
        }
        if (!shadow) {
            StiDoughnutSeriesElementGeom seriesGeom = new StiDoughnutSeriesElementGeom(areaGeom, value == null ? 0.0 : value, index, currentSeries, rectPie, path, pathLight, pathDark, borderColor, brush, (StiBrush)brLight, (StiBrush)brDark, start, start + angle, radius, radiusDt, beginTime);
            return seriesGeom;
        }
        return null;
    }

    @Override
    public void RenderSeries(StiContext context, StiRectangle rect, StiAreaGeom geom, IStiSeries[] seriesArray) {
        StiRectangle bounds;
        Integer duration = StiChartHelper.GlobalDurationElement;
        Integer beginTime = StiChartHelper.GlobalBeginTimeElement;
        if (seriesArray == null || seriesArray.length == 0 || this.getSeries().getChart() == null) {
            return;
        }
        int colorCount = 0;
        for (IStiSeries ser : seriesArray) {
            if (ser.getValues() == null) continue;
            colorCount += ser.getValues().length;
        }
        if (colorCount == 0) {
            return;
        }
        double radius = this.GetRadius(context, rect);
        StiPoint pointCenter = this.GetPointCenter(rect);
        IStiPieSeries currentSeries = (IStiPieSeries)(seriesArray[0] instanceof IStiPieSeries ? seriesArray[0] : null);
        int colorIndex = 0;
        double step = radius / (double)(seriesArray.length + 1);
        StiRectangle rectPie2 = bounds = new StiRectangle((double)(10 * context.Options.zoom), (double)(10 * context.Options.zoom), rect.width - (double)(20 * context.Options.zoom), rect.height - (double)(20 * context.Options.zoom));
        float angle = 0.0f;
        double radiusDt = radius;
        for (IStiSeries ser1 : seriesArray) {
            IStiDoughnutSeries ser = (IStiDoughnutSeries)ser1;
            int index = 0;
            angle = ser.getStartAngle();
            float gradPerValue = this.GetGradPerValue(ser);
            for (Double value : ser.getValues()) {
                IStiSeriesLabels tempVar;
                IStiPieSeriesLabels labels;
                float percentPerValue = this.GetPercentPerValue(ser);
                float arcWidth = (float)((double)gradPerValue * (value == null ? 0.0 : value));
                if (this.getSeries().getChart() != null && this.getSeries().getChart().getSeriesLabels() != null && this.getSeries().getChart().getSeriesLabels().getVisible() && (labels = (IStiPieSeriesLabels)((tempVar = this.getSeries().getChart().getSeriesLabels()) instanceof IStiPieSeriesLabels ? tempVar : null)) != null && labels.getVisible()) {
                    double radiusDt2 = radiusDt - step;
                    StiRectangle measureRect = null;
                    StiRefObject tempRef_measureRect = new StiRefObject(measureRect);
                    ((StiPieSeriesLabelsCoreXF)labels.getCore()).RenderLabel(ser, context, pointCenter, radiusDt, radiusDt2, angle + arcWidth / 2.0f, index, value, value, this.GetArgumentText(ser, index), this.GetTag(index), true, colorIndex, colorCount, percentPerValue, (StiRefObject<StiRectangle>)tempRef_measureRect, false, 0.0);
                    measureRect = (StiRectangle)tempRef_measureRect.argvalue;
                    if (!measureRect.isEmpty().booleanValue()) {
                        bounds = StiRectangle.union((StiRectangle)bounds, (StiRectangle)measureRect);
                    }
                }
                ++colorIndex;
                angle += arcWidth;
                ++index;
            }
            radiusDt -= step * (double)1.2f;
        }
        double dist = 0.0;
        dist = Math.min(dist, bounds.getLeft() - rectPie2.getLeft());
        dist = Math.min(dist, rectPie2.getRight() - bounds.getRight());
        dist = Math.min(dist, bounds.getTop() - rectPie2.getTop());
        dist = Math.min(dist, rectPie2.getBottom() - bounds.getBottom());
        radiusDt = (radius += dist) - step;
        StiChart chart = (StiChart)this.getSeries().getChart();
        if (currentSeries.getShowShadow() && !chart.isAnimation) {
            StiRectangle rectPie = new StiRectangle(pointCenter.x - radius, pointCenter.y - radius, radius * 2.0, radius * 2.0);
            StiContext shadowContext = context.CreateShadowGraphics();
            StiSolidBrush shadowBrush = new StiSolidBrush(StiColor.FromArgb((int)100, (StiColor)StiColor.Black));
            step = radius / (double)(seriesArray.length + 1);
            colorIndex = 0;
            radiusDt = radius;
            for (IStiSeries ser1 : seriesArray) {
                IStiDoughnutSeries ser = (IStiDoughnutSeries)ser1;
                angle = ser.getStartAngle();
                float gradPerValue = this.GetGradPerValue(ser);
                int index = 0;
                for (Double value : ser.getValues()) {
                    float arcWidth = (float)((double)gradPerValue * (value == null ? 0.0 : value));
                    this.RenderPieElement(shadowContext, new StiPoint(rectPie.getWidth() / 2.0, rectPie.getHeight() / 2.0), radiusDt, radiusDt - step, StiColor.Black, (StiBrush)shadowBrush, angle, arcWidth, value, index, ser, true, geom, beginTime);
                    angle += arcWidth;
                    ++index;
                }
                radiusDt -= step * (double)1.2f;
            }
            StiPieSeriesShadowElementGeom shadowGeom = new StiPieSeriesShadowElementGeom(currentSeries, rectPie, radius * (double)0.01f + (double)(2 * context.Options.zoom), shadowContext, duration, beginTime);
            geom.CreateChildGeoms();
            geom.getChildGeoms().add(shadowGeom);
        }
        step = radius / (double)(seriesArray.length + 1);
        colorIndex = 0;
        radiusDt = radius;
        for (IStiSeries ser1 : seriesArray) {
            IStiDoughnutSeries ser = (IStiDoughnutSeries)ser1;
            angle = ser.getStartAngle();
            float gradPerValue = this.GetGradPerValue(ser);
            int nonZeroValuesCount = 0;
            int firstNonZeroValueIndex = -1;
            for (IStiSeries ser2 : seriesArray) {
                int index = 0;
                for (Double value : ser2.getValues()) {
                    if (value != null && !value.equals(0.0) && !Double.isNaN(value) && ++nonZeroValuesCount == 1) {
                        firstNonZeroValueIndex = index;
                    }
                    ++index;
                }
            }
            if (nonZeroValuesCount != 0) {
                if (nonZeroValuesCount == 1) {
                    colorIndex = firstNonZeroValueIndex != -1 ? firstNonZeroValueIndex : 0;
                    StiBrush seriesBrush = ser.getBrush();
                    if (ser.getAllowApplyBrush()) {
                        seriesBrush = ser.getCore().GetSeriesBrush(colorIndex, colorCount);
                        seriesBrush = ser.ProcessSeriesColors(colorIndex, seriesBrush);
                    }
                    StiRectangle rect2 = new StiRectangle(pointCenter.x - radius, pointCenter.y - radius, radius * 2.0, radius * 2.0);
                    StiColor borderColor = (StiColor)currentSeries.getCore().GetSeriesBorderColor(colorIndex, colorCount);
                    StiDoughnutSeriesElementGeom doughnutElementGeom = this.RenderPieElement(context, pointCenter, radiusDt, radiusDt - step, borderColor, seriesBrush, 0.0, 360.0, ser.getValues()[firstNonZeroValueIndex], firstNonZeroValueIndex, ser, false, geom, beginTime);
                    if (doughnutElementGeom == null) break;
                    geom.CreateChildGeoms();
                    geom.getChildGeoms().add(doughnutElementGeom);
                    break;
                }
                int valueIndex = 0;
                for (Double value : ser.getValues()) {
                    float arcWidth = (float)((double)gradPerValue * (value == null ? 0.0 : value));
                    int index = colorIndex;
                    int count = colorCount;
                    if (value != null && value != 0.0) {
                        StiDoughnutSeriesElementGeom doughnutElementGeom;
                        if (!this.getSeries().getChart().getArea().getColorEach()) {
                            index = valueIndex;
                            if (this.getSeries().getChart().getArea() instanceof IStiDoughnutArea) {
                                count = ((StiDoughnutAreaCoreXF)this.getSeries().getChart().getArea().getCore()).ValuesCount;
                            }
                        }
                        StiBrush seriesBrush = ser.getBrush();
                        if (ser.getAllowApplyBrush()) {
                            seriesBrush = ser.getCore().GetSeriesBrush(colorIndex, colorCount);
                            seriesBrush = ser.ProcessSeriesColors(colorIndex, seriesBrush);
                        }
                        StiColor borderColor = ser.getBorderColor().clone();
                        if (ser.getAllowApplyBorderColor()) {
                            borderColor = (StiColor)ser.getCore().GetSeriesBorderColor(colorIndex, colorCount);
                        }
                        if ((doughnutElementGeom = this.RenderPieElement(context, pointCenter, radiusDt, radiusDt - step, borderColor, seriesBrush, angle, arcWidth, value, valueIndex, ser, false, geom, beginTime / ser.getValues().length * colorIndex)) != null) {
                            geom.CreateChildGeoms();
                            geom.getChildGeoms().add(doughnutElementGeom);
                        }
                        angle += arcWidth;
                    }
                    ++colorIndex;
                    ++valueIndex;
                }
            }
            radiusDt -= step * (double)1.2f;
        }
        colorIndex = 0;
        radiusDt = radius;
        for (IStiSeries ser1 : seriesArray) {
            IStiDoughnutSeries ser = (IStiDoughnutSeries)ser1;
            int index = 0;
            angle = ser.getStartAngle();
            float gradPerValue = this.GetGradPerValue(ser);
            for (Double value : ser.getValues()) {
                IStiPieSeriesLabels labels;
                float percentPerValue = this.GetPercentPerValue(ser);
                float arcWidth = (float)((double)gradPerValue * (value == null ? 0.0 : value));
                IStiSeriesLabels seriesLabels = null;
                if (ser.getShowSeriesLabels() == StiShowSeriesLabels.FromChart) {
                    IStiSeriesLabels tempVar2 = this.getSeries().getChart().getSeriesLabels();
                    IStiSeriesLabels iStiSeriesLabels = seriesLabels = tempVar2 instanceof IStiSeriesLabels ? tempVar2 : null;
                }
                if (ser.getShowSeriesLabels() == StiShowSeriesLabels.FromSeries) {
                    IStiSeriesLabels tempVar3 = currentSeries.getSeriesLabels();
                    IStiSeriesLabels iStiSeriesLabels = seriesLabels = tempVar3 instanceof IStiSeriesLabels ? tempVar3 : null;
                }
                if (this.getSeries().getChart() != null && seriesLabels != null && seriesLabels.getVisible() && (labels = (IStiPieSeriesLabels)(seriesLabels instanceof IStiPieSeriesLabels ? seriesLabels : null)) != null && labels.getVisible() && (labels.getStep() == 0 || index % labels.getStep() == 0)) {
                    StiRectangle measureRect = null;
                    double radiusDt2 = radiusDt - step;
                    StiRefObject tempRef_measureRect2 = new StiRefObject(measureRect);
                    StiSeriesLabelsGeom seriesLabelsGeom = ((StiPieSeriesLabelsCoreXF)labels.getCore()).RenderLabel(ser, context, pointCenter, radiusDt, radiusDt2, angle + arcWidth / 2.0f, index, value, value, this.GetArgumentText(ser, index), this.GetTag(index), false, colorIndex, colorCount, percentPerValue, (StiRefObject<StiRectangle>)tempRef_measureRect2, false, 0.0);
                    measureRect = (StiRectangle)tempRef_measureRect2.argvalue;
                    if (seriesLabelsGeom != null) {
                        seriesLabelsGeom.setDuration(duration);
                        seriesLabelsGeom.setBeginTime(beginTime / ser.getValues().length * colorIndex);
                        geom.CreateChildGeoms();
                        geom.getChildGeoms().add(seriesLabelsGeom);
                    }
                }
                ++colorIndex;
                angle += arcWidth;
                ++index;
            }
            radiusDt -= step * (double)1.2f;
        }
    }

    private float GetGradPerValue(IStiSeries series) {
        double totals = 0.0;
        for (Double value : series.getValues()) {
            totals += value == null ? 0.0 : value;
        }
        return (float)(360.0 / totals);
    }

    private float GetPercentPerValue(IStiSeries series) {
        double totals = 0.0;
        for (Double value : series.getValues()) {
            totals += value == null ? 0.0 : value;
        }
        return (float)(1.0 / totals * 100.0);
    }

    private String GetArgumentText(IStiSeries series, int index) {
        if (series.getArguments().length > index) {
            return series.getArguments()[index].toString();
        }
        return "";
    }

    @Override
    public String getLocalizedName() {
        return StiLocalization.Get((String)"Chart", (String)"Doughnut");
    }

    public StiDoughnutSeriesCoreXF(IStiSeries series) {
        super(series);
    }
}

