/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.report.chart.core.series.pie;

import com.stimulsoft.base.context.chart.StiContext;
import com.stimulsoft.base.context.chart.animation.StiAnimation;
import com.stimulsoft.base.context.chart.animation.StiOpacityAnimation;
import com.stimulsoft.base.context.chart.animation.StiPieLabelAnimation;
import com.stimulsoft.base.context.chart.animation.StiPieSegmentAnimation;
import com.stimulsoft.base.context.chart.geoms.StiArcSegmentGeom;
import com.stimulsoft.base.context.chart.geoms.StiGeom;
import com.stimulsoft.base.context.chart.geoms.StiLineSegmentGeom;
import com.stimulsoft.base.context.chart.geoms.StiPieSegmentGeom;
import com.stimulsoft.base.context.chart.geoms.StiSegmentGeom;
import com.stimulsoft.base.drawing.StiBrush;
import com.stimulsoft.base.drawing.StiColor;
import com.stimulsoft.base.drawing.StiGlareBrush;
import com.stimulsoft.base.drawing.StiGradientBrush;
import com.stimulsoft.base.drawing.StiSolidBrush;
import com.stimulsoft.base.localization.StiLocalization;
import com.stimulsoft.base.system.StiRefObject;
import com.stimulsoft.base.system.geometry.StiPoint;
import com.stimulsoft.base.system.geometry.StiRectangle;
import com.stimulsoft.report.chart.StiChart;
import com.stimulsoft.report.chart.StiChartHelper;
import com.stimulsoft.report.chart.core.series.StiSeriesCoreXF;
import com.stimulsoft.report.chart.core.seriesLabels.pie.StiOutsidePieLabelsCoreXF;
import com.stimulsoft.report.chart.core.seriesLabels.pie.StiPieSeriesLabelsCoreXF;
import com.stimulsoft.report.chart.enums.StiShowSeriesLabels;
import com.stimulsoft.report.chart.geoms.StiCellGeom;
import com.stimulsoft.report.chart.geoms.areas.StiAreaGeom;
import com.stimulsoft.report.chart.geoms.series.pie.StiPieSeriesElementGeom;
import com.stimulsoft.report.chart.geoms.series.pie.StiPieSeriesFullElementGeom;
import com.stimulsoft.report.chart.geoms.series.pie.StiPieSeriesShadowElementGeom;
import com.stimulsoft.report.chart.geoms.seriesLabels.StiSeriesLabelsGeom;
import com.stimulsoft.report.chart.geoms.seriesLabels.pie.StiCenterPieLabelsGeom;
import com.stimulsoft.report.chart.geoms.seriesLabels.pie.StiTwoColumnsPieLabelsGeom;
import com.stimulsoft.report.chart.interfaces.series.IStiSeries;
import com.stimulsoft.report.chart.interfaces.series.pie.IStiPieSeries;
import com.stimulsoft.report.chart.interfaces.seriesLabels.IStiSeriesLabels;
import com.stimulsoft.report.chart.interfaces.seriesLabels.pie.IStiOutsidePieLabels;
import com.stimulsoft.report.chart.interfaces.seriesLabels.pie.IStiPieSeriesLabels;
import com.stimulsoft.report.chart.interfaces.seriesLabels.pie.IStiTwoColumnsPieLabels;
import com.stimulsoft.report.chart.interfaces.styles.IStiChartStyle;
import com.stimulsoft.report.chart.view.series.StiSeriesInteractionData;
import com.stimulsoft.report.chart.view.seriesLabels.pie.StiPieSeriesLabels;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public class StiPieSeriesCoreXF
extends StiSeriesCoreXF {
    @Override
    public void ApplyStyle(IStiChartStyle style, StiColor color) {
        super.ApplyStyle(style, color);
        IStiSeries tempVar = this.getSeries();
        IStiPieSeries pieSeries = (IStiPieSeries)(tempVar instanceof IStiPieSeries ? tempVar : null);
        if (pieSeries.getAllowApplyStyle()) {
            pieSeries.setLighting(style.getCore().isSeriesLighting());
            if (pieSeries.getAllowApplyBrush()) {
                pieSeries.setBrush(style.getCore().GetColumnBrush(color));
            }
            if (pieSeries.getAllowApplyBorderColor()) {
                pieSeries.setBorderColor(style.getCore().GetColumnBorder(color));
            }
        }
    }

    private StiBrush CorrectBrush(StiBrush brush) {
        Object tempVar2;
        Object tempVar;
        if (brush instanceof StiGradientBrush && (brush = (StiGradientBrush)((tempVar = brush.clone()) instanceof StiGradientBrush ? tempVar : null)) != null) {
            ((StiGradientBrush)brush).angle = -45.0;
        }
        if (brush instanceof StiGlareBrush && (brush = (StiGlareBrush)((tempVar2 = brush.clone()) instanceof StiGlareBrush ? tempVar2 : null)) != null) {
            ((StiGlareBrush)brush).angle = -45.0;
        }
        return brush;
    }

    private StiPieSeriesElementGeom RenderPieElement(StiContext context, StiPoint center, double radius, StiColor borderColor, StiBrush brush, double start, double angle, Double value, int index, IStiPieSeries currentSeries, double distance, StiAreaGeom geom, Integer beginTime) {
        ArrayList path = null;
        ArrayList pathLight = null;
        StiRectangle rectPie = StiRectangle.getEmpty();
        brush = this.CorrectBrush(brush);
        StiRefObject tempRef_path = new StiRefObject(path);
        StiRefObject tempRef_pathLight = new StiRefObject(pathLight);
        StiRefObject tempRef_rectPie = new StiRefObject((Object)rectPie);
        StiRectangle clientRectangle = this.MeasurePieElementCore(context, center, radius, start, angle, value, currentSeries, distance, (StiRefObject<ArrayList<StiSegmentGeom>>)tempRef_path, (StiRefObject<ArrayList<StiSegmentGeom>>)tempRef_pathLight, (StiRefObject<StiRectangle>)tempRef_rectPie);
        path = (ArrayList)tempRef_path.argvalue;
        pathLight = (ArrayList)tempRef_pathLight.argvalue;
        rectPie = (StiRectangle)tempRef_rectPie.argvalue;
        if (clientRectangle.isEmpty().booleanValue()) {
            return null;
        }
        return new StiPieSeriesElementGeom(geom, value == null ? 0.0 : value, index, currentSeries instanceof IStiPieSeries ? currentSeries : null, rectPie, path, pathLight, borderColor, brush, start, start + angle, radius, null);
    }

    private void RenderPieElementShadow(StiContext context, StiPoint center, double radius, StiBrush brush, double start, double angle, Double value, IStiPieSeries currentSeries, double distance) {
        if (((StiChart)this.getSeries().getChart()).isAnimation) {
            return;
        }
        ArrayList path = null;
        ArrayList pathLight = null;
        StiRectangle rectPie = StiRectangle.getEmpty();
        brush = this.CorrectBrush(brush);
        StiRefObject tempRef_path = new StiRefObject(path);
        StiRefObject tempRef_pathLight = new StiRefObject(pathLight);
        StiRefObject tempRef_rectPie = new StiRefObject((Object)rectPie);
        StiRectangle clientRectangle = this.MeasurePieElementCore(context, center, radius, start, angle, value, currentSeries, distance, (StiRefObject<ArrayList<StiSegmentGeom>>)tempRef_path, (StiRefObject<ArrayList<StiSegmentGeom>>)tempRef_pathLight, (StiRefObject<StiRectangle>)tempRef_rectPie);
        path = (ArrayList)tempRef_path.argvalue;
        pathLight = (ArrayList)tempRef_pathLight.argvalue;
        rectPie = (StiRectangle)tempRef_rectPie.argvalue;
        if (clientRectangle.isEmpty().booleanValue()) {
            return;
        }
        context.PushSmoothingModeToAntiAlias();
        context.FillPath((Object)brush, (List)path, (Object)rectPie, null);
        if (pathLight != null) {
            StiGradientBrush brLight = new StiGradientBrush(StiColor.FromArgb((int)100, (StiColor)StiColor.White), StiColor.FromArgb((int)50, (StiColor)StiColor.Black), 45.0);
            context.FillPath((Object)brLight, (List)pathLight, (Object)rectPie, null);
        }
        context.PopSmoothingMode();
    }

    private StiRectangle MeasurePieElement(StiContext context, StiPoint center, double radius, double start, double angle, Double value, IStiPieSeries currentSeries, double distance) {
        ArrayList path = null;
        ArrayList pathLight = null;
        StiRectangle rectPie = StiRectangle.getEmpty();
        StiRefObject tempRef_path = new StiRefObject(path);
        StiRefObject tempRef_pathLight = new StiRefObject(pathLight);
        StiRefObject tempRef_rectPie = new StiRefObject((Object)rectPie);
        StiRectangle tempVar = this.MeasurePieElementCore(context, center, radius, start, angle, value, currentSeries, distance, (StiRefObject<ArrayList<StiSegmentGeom>>)tempRef_path, (StiRefObject<ArrayList<StiSegmentGeom>>)tempRef_pathLight, (StiRefObject<StiRectangle>)tempRef_rectPie);
        path = (ArrayList)tempRef_path.argvalue;
        pathLight = (ArrayList)tempRef_pathLight.argvalue;
        rectPie = (StiRectangle)tempRef_rectPie.argvalue;
        return tempVar;
    }

    private StiRectangle MeasurePieElementCore(StiContext context, StiPoint center, double radius, double start, double angle, Double value, IStiPieSeries currentSeries, double distance, StiRefObject<ArrayList<StiSegmentGeom>> path, StiRefObject<ArrayList<StiSegmentGeom>> pathLight, StiRefObject<StiRectangle> rectPie) {
        path.argvalue = new ArrayList();
        pathLight.argvalue = null;
        rectPie.argvalue = StiRectangle.getEmpty();
        if (angle == 0.0 || Double.isNaN(angle)) {
            return StiRectangle.getEmpty();
        }
        if (distance > 0.0) {
            center = this.GetPoint(center, distance * (double)context.Options.zoom, start + angle / 2.0);
        }
        rectPie.argvalue = new StiRectangle(center.x - radius, center.y - radius, radius * 2.0, radius * 2.0);
        if (((StiRectangle)rectPie.argvalue).width <= 0.0 && ((StiRectangle)rectPie.argvalue).height <= 0.0) {
            return StiRectangle.getEmpty();
        }
        ((ArrayList)path.argvalue).add(new StiPieSegmentGeom(new StiRectangle(((StiRectangle)rectPie.argvalue).x, ((StiRectangle)rectPie.argvalue).y, ((StiRectangle)rectPie.argvalue).width, ((StiRectangle)rectPie.argvalue).height), start, angle, null));
        if (currentSeries.getLighting() && !StiColor.Transparent.equals(currentSeries.getBorderColor())) {
            double lightWidth = 0.0;
            pathLight.argvalue = new ArrayList();
            lightWidth = radius * (double)0.02f;
            ((ArrayList)pathLight.argvalue).add(new StiArcSegmentGeom((StiRectangle)rectPie.argvalue, start, angle));
            ((ArrayList)pathLight.argvalue).add(new StiLineSegmentGeom(this.GetPoint(center, radius - lightWidth, start + angle), this.GetPoint(center, radius - lightWidth, start + angle)));
            ((ArrayList)pathLight.argvalue).add(new StiArcSegmentGeom(new StiRectangle(((StiRectangle)rectPie.argvalue).x + lightWidth, ((StiRectangle)rectPie.argvalue).y + lightWidth, ((StiRectangle)rectPie.argvalue).width - lightWidth * 2.0, ((StiRectangle)rectPie.argvalue).height - lightWidth * 2.0), start + angle, -angle));
            ((ArrayList)pathLight.argvalue).add(new StiLineSegmentGeom(this.GetPoint(center, radius - lightWidth, start), this.GetPoint(center, radius - lightWidth, start)));
        }
        return context.GetPathBounds((List)path.argvalue);
    }

    @Override
    public void RenderSeries(StiContext context, StiRectangle rect, StiAreaGeom geom, IStiSeries[] seriesArray) {
        IStiSeriesLabels tempVar3;
        IStiTwoColumnsPieLabels twoColumnsLabels;
        StiRectangle measureRect;
        float currAngle;
        double labelRadius;
        IStiPieSeriesLabels labels;
        float arcWidth;
        int index;
        IStiPieSeries pieSer;
        if (seriesArray == null || seriesArray.length == 0 || this.getSeries().getChart() == null) {
            return;
        }
        Integer duration = StiChartHelper.GlobalDurationElement;
        Integer beginTime = StiChartHelper.GlobalBeginTimeElement;
        StiChart chart = (StiChart)this.getSeries().getChart();
        int colorCount = 0;
        for (IStiSeries ser : seriesArray) {
            if (ser.getValues() == null) continue;
            colorCount += ser.getValues().length;
        }
        if (colorCount == 0) {
            return;
        }
        int nonZeroValuesCount = 0;
        int firstNonZeroValueIndex = -1;
        for (IStiSeries ser : seriesArray) {
            int index2 = 0;
            for (Double value : ser.getValues()) {
                if (!value.equals(0) && value != null && !Double.isNaN(value) && ++nonZeroValuesCount == 1) {
                    firstNonZeroValueIndex = index2;
                }
                ++index2;
            }
        }
        float gradPerValue = this.GetGradPerValue(seriesArray, false);
        float percentPerValue = this.GetPercentPerValue(seriesArray, false);
        double radius = this.GetRadius(context, rect);
        StiPoint pointCenter = this.GetPointCenter(rect);
        IStiPieSeries currentSeries = (IStiPieSeries)(seriesArray[0] instanceof IStiPieSeries ? seriesArray[0] : null);
        float angle = currentSeries.getStartAngle();
        StiRectangle bounds = new StiRectangle(0.0, 0.0, rect.width, rect.height);
        for (IStiSeries ser : seriesArray) {
            if (nonZeroValuesCount <= 1) continue;
            IStiPieSeries pieSeries = (IStiPieSeries)(ser instanceof IStiPieSeries ? ser : null);
            int index3 = 0;
            for (Double value : ser.getValues()) {
                float arcWidth2 = (float)((double)gradPerValue * (value == null ? 0.0 : value));
                StiSolidBrush seriesBrush = new StiSolidBrush(StiColor.Transparent);
                StiRectangle measureRect2 = this.MeasurePieElement(context, pointCenter, radius, angle, arcWidth2, value, pieSeries, this.GetPieDistance(index3));
                if (!value.equals(0)) {
                    bounds = StiRectangle.union((StiRectangle)bounds, (StiRectangle)measureRect2);
                }
                angle += arcWidth2;
                ++index3;
            }
        }
        double maximumDeltaX = Math.max(-bounds.getLeft(), bounds.getRight() - rect.width);
        double maximumDeltaY = Math.max(-bounds.getTop(), bounds.getBottom() - rect.height);
        double maximumDelta = Math.max(maximumDeltaX, maximumDeltaY);
        radius -= maximumDelta * (double)1.2f;
        StiRectangle[] labelsRect = new StiRectangle[colorCount];
        double[] deltaY = new double[colorCount];
        int[] quarterCounts = new int[4];
        angle = currentSeries.getStartAngle();
        bounds = new StiRectangle((double)(10 * context.Options.zoom), (double)(10 * context.Options.zoom), rect.width - (double)(20 * context.Options.zoom), rect.height - (double)(20 * context.Options.zoom));
        StiRectangle rectPie2 = bounds.clone();
        int labelIndex = 0;
        for (IStiSeries ser : seriesArray) {
            pieSer = (IStiPieSeries)(ser instanceof IStiPieSeries ? ser : null);
            index = 0;
            for (Double value : ser.getValues()) {
                IStiSeriesLabels tempVar;
                arcWidth = (float)((double)gradPerValue * (value == null ? 0.0 : value));
                if (this.getSeries().getChart() != null && this.getSeries().getChart().getSeriesLabels() != null && this.getSeries().getChart().getSeriesLabels().getVisible() && (labels = (IStiPieSeriesLabels)((tempVar = this.getSeries().getChart().getSeriesLabels()) instanceof IStiPieSeriesLabels ? tempVar : null)) != null && labels.getVisible()) {
                    labelRadius = radius;
                    if (this.GetPieDistance(index) > 0.0f) {
                        labelRadius += (double)(pieSer.getDistance() * (float)context.Options.zoom);
                    }
                    currAngle = angle + arcWidth / 2.0f;
                    measureRect = null;
                    StiRefObject tempRef_measureRect = new StiRefObject(measureRect);
                    ((StiPieSeriesLabelsCoreXF)labels.getCore()).RenderLabel(pieSer, context, pointCenter, labelRadius, 0.0, currAngle, index, value, value, this.GetArgumentText(ser, index), this.GetTag(index), true, index, colorCount, percentPerValue, (StiRefObject<StiRectangle>)tempRef_measureRect, false, 0.0);
                    measureRect = (StiRectangle)tempRef_measureRect.argvalue;
                    if (!measureRect.isEmpty().booleanValue()) {
                        bounds = StiRectangle.union((StiRectangle)bounds, (StiRectangle)measureRect);
                    }
                    if (!value.equals(0) || labels.getShowZeros()) {
                        labelsRect[labelIndex] = measureRect;
                        deltaY[labelIndex] = measureRect.y;
                        if (currAngle >= 0.0f && currAngle <= 90.0f) {
                            quarterCounts[0] = quarterCounts[0] + 1;
                        }
                        if (currAngle > 90.0f && currAngle <= 180.0f) {
                            quarterCounts[1] = quarterCounts[1] + 1;
                        }
                        if (currAngle > 180.0f && currAngle <= 270.0f) {
                            quarterCounts[2] = quarterCounts[2] + 1;
                        }
                        if (currAngle > 270.0f && currAngle <= 360.0f) {
                            quarterCounts[3] = quarterCounts[3] + 1;
                        }
                    }
                }
                angle += arcWidth;
                ++index;
                if (value.equals(0) && !this.getSeries().getChart().getSeriesLabels().getShowZeros()) continue;
                ++labelIndex;
            }
        }
        if (currentSeries.getDiameter() == 0.0f) {
            double dist = 0.0;
            dist = Math.min(dist, bounds.getLeft() - rectPie2.getLeft());
            dist = Math.min(dist, rectPie2.getRight() - bounds.getRight());
            dist = Math.min(dist, bounds.getTop() - rectPie2.getTop());
            dist = Math.min(dist, rectPie2.getBottom() - bounds.getBottom());
            radius += dist;
        }
        labelIndex = 0;
        for (IStiSeries ser : seriesArray) {
            pieSer = (IStiPieSeries)(ser instanceof IStiPieSeries ? ser : null);
            index = 0;
            for (Double value : ser.getValues()) {
                IStiSeriesLabels tempVar2;
                arcWidth = (float)((double)gradPerValue * (value == null ? 0.0 : value));
                if (this.getSeries().getChart() != null && this.getSeries().getChart().getSeriesLabels() != null && this.getSeries().getChart().getSeriesLabels().getVisible() && (labels = (IStiPieSeriesLabels)((tempVar2 = this.getSeries().getChart().getSeriesLabels()) instanceof IStiPieSeriesLabels ? tempVar2 : null)) != null && labels.getVisible()) {
                    labelRadius = radius;
                    if (this.GetPieDistance(index) > 0.0f) {
                        labelRadius += (double)(pieSer.getDistance() * (float)context.Options.zoom);
                    }
                    currAngle = angle + arcWidth / 2.0f;
                    measureRect = null;
                    StiRefObject tempRef_measureRect2 = new StiRefObject(measureRect);
                    ((StiPieSeriesLabelsCoreXF)labels.getCore()).RenderLabel(this.getSeries(), context, pointCenter, labelRadius, 0.0, currAngle, index, value, value, this.GetArgumentText(ser, index), this.GetTag(index), true, index, colorCount, percentPerValue, (StiRefObject<StiRectangle>)tempRef_measureRect2, false, 0.0);
                    measureRect = (StiRectangle)tempRef_measureRect2.argvalue;
                    if (!value.equals(0) || labels.getShowZeros()) {
                        labelsRect[labelIndex] = measureRect;
                        deltaY[labelIndex] = measureRect.y;
                    }
                }
                angle += arcWidth;
                ++index;
                if (value.equals(0) && !this.getSeries().getChart().getSeriesLabels().getShowZeros()) continue;
                ++labelIndex;
            }
        }
        if (this.getSeries().getChart() != null && this.getSeries().getChart().getSeriesLabels() != null && (twoColumnsLabels = (IStiTwoColumnsPieLabels)((tempVar3 = this.getSeries().getChart().getSeriesLabels()) instanceof IStiTwoColumnsPieLabels ? tempVar3 : null)) != null && twoColumnsLabels.getPreventIntersection()) {
            int i;
            double calcedHeight = 0.0;
            if (quarterCounts[0] > 0) {
                calcedHeight = bounds.height / 2.0 / (double)quarterCounts[0];
                labelsRect[0].y = bounds.y + bounds.height / 2.0 + calcedHeight / 2.0 - labelsRect[0].height / 2.0;
                for (int i2 = 1; i2 < quarterCounts[0]; ++i2) {
                    labelsRect[i2].y = labelsRect[i2 - 1].y + calcedHeight;
                }
            }
            int startIndex = quarterCounts[0];
            if (quarterCounts[1] > 0) {
                calcedHeight = bounds.height / 2.0 / (double)quarterCounts[1];
                labelsRect[startIndex].y = bounds.y + bounds.height - calcedHeight / 2.0 - labelsRect[startIndex].height / 2.0;
                for (i = startIndex + 1; i < startIndex + quarterCounts[1]; ++i) {
                    labelsRect[i].y = labelsRect[i - 1].y - calcedHeight;
                }
            }
            startIndex += quarterCounts[1];
            if (quarterCounts[2] > 0) {
                calcedHeight = bounds.height / 2.0 / (double)quarterCounts[2];
                labelsRect[startIndex].y = bounds.y + bounds.height / 2.0 - calcedHeight / 2.0 - labelsRect[startIndex].height / 2.0;
                for (i = startIndex + 1; i < startIndex + quarterCounts[2]; ++i) {
                    labelsRect[i].y = labelsRect[i - 1].y - calcedHeight;
                }
            }
            startIndex += quarterCounts[2];
            if (quarterCounts[3] > 0) {
                calcedHeight = bounds.height / 2.0 / (double)quarterCounts[3];
                labelsRect[startIndex].y = bounds.y + calcedHeight / 2.0 - labelsRect[startIndex].height / 2.0;
                for (i = startIndex + 1; i < startIndex + quarterCounts[3]; ++i) {
                    labelsRect[i].y = labelsRect[i - 1].y + calcedHeight;
                }
            }
            for (i = 0; i < labelIndex; ++i) {
                deltaY[i] = labelsRect[i].y - deltaY[i];
            }
        }
        if (radius <= 5.0) {
            return;
        }
        if (currentSeries.getShowShadow()) {
            angle = currentSeries.getStartAngle();
            for (IStiSeries ser : seriesArray) {
                if (nonZeroValuesCount == 1) {
                    StiRectangle rectPie = new StiRectangle(pointCenter.x - radius, pointCenter.y - radius, radius * 2.0, radius * 2.0);
                    StiRectangle shadowRect = new StiRectangle(0.0, 0.0, radius * 2.0, radius * 2.0);
                    StiContext shadowContext = context.CreateShadowGraphics();
                    shadowContext.FillEllipse((Object)StiColor.FromArgb((int)50, (StiColor)StiColor.Black), shadowRect, null);
                    StiPieSeriesShadowElementGeom shadowGeom = new StiPieSeriesShadowElementGeom(currentSeries instanceof IStiPieSeries ? currentSeries : null, rectPie, radius * (double)0.01f + (double)(2 * context.Options.zoom), shadowContext, duration, beginTime);
                    geom.CreateChildGeoms();
                    geom.getChildGeoms().add(shadowGeom);
                    break;
                }
                IStiPieSeries pieSeries = (IStiPieSeries)(ser instanceof IStiPieSeries ? ser : null);
                index = 0;
                for (Double value : ser.getValues()) {
                    arcWidth = (float)((double)gradPerValue * (value == null ? 0.0 : value));
                    StiPoint shadowPointCenter = pointCenter.clone();
                    StiSolidBrush shadowBrush = new StiSolidBrush(StiColor.FromArgb((int)100, (StiColor)StiColor.Black));
                    StiContext shadowContext = context.CreateShadowGraphics();
                    StiRectangle shadowRect = rect.clone();
                    shadowRect.x = 0.0;
                    shadowRect.y = 0.0;
                    if (chart.isAnimation) {
                        shadowRect.x = pointCenter.x - radius;
                        shadowRect.y = pointCenter.y - radius;
                        shadowRect.height = radius * 2.0;
                        shadowRect.width = radius * 2.0;
                    }
                    this.RenderPieElementShadow(shadowContext, shadowPointCenter, radius, (StiBrush)shadowBrush, angle, arcWidth, value, pieSeries, this.GetPieDistance(index));
                    StiPieSeriesShadowElementGeom shadowGeom = new StiPieSeriesShadowElementGeom(currentSeries instanceof IStiPieSeries ? currentSeries : null, shadowRect, radius * (double)0.01f + 2.0, shadowContext, duration, beginTime);
                    geom.CreateChildGeoms();
                    geom.getChildGeoms().add(shadowGeom);
                    angle += arcWidth;
                    ++index;
                }
            }
        }
        List<StiCellGeom> listPieElementsGeom = this.GetPieElementGeoms(context, geom, radius, rect, seriesArray, false);
        List<StiCellGeom> listPieElementsFromGeom = this.GetPieElementGeoms(context, geom, radius, rect, seriesArray, chart.isAnimationChangingValues());
        for (int indexGeom = 0; indexGeom < listPieElementsGeom.size(); ++indexGeom) {
            StiPieSeriesElementGeom pieElementGeom;
            StiCellGeom elementGeom = listPieElementsGeom.get(indexGeom);
            StiPieSeriesElementGeom stiPieSeriesElementGeom = pieElementGeom = elementGeom instanceof StiPieSeriesElementGeom ? (StiPieSeriesElementGeom)elementGeom : null;
            if (elementGeom instanceof StiPieSeriesFullElementGeom) {
                geom.CreateChildGeoms();
                geom.getChildGeoms().add(elementGeom);
                continue;
            }
            if (pieElementGeom == null) continue;
            if (chart.isAnimationChangingValues() && indexGeom < listPieElementsFromGeom.size()) {
                StiPieSeriesElementGeom pieElementFromGeom;
                StiPieSeriesElementGeom stiPieSeriesElementGeom2 = pieElementFromGeom = listPieElementsFromGeom.get(indexGeom) instanceof StiPieSeriesElementGeom ? (StiPieSeriesElementGeom)listPieElementsFromGeom.get(indexGeom) : null;
                if (pieElementFromGeom != null && pieElementFromGeom.getPath().size() > 0 && pieElementGeom.getPath().size() > 0) {
                    StiPieSegmentGeom segmentFromGeom;
                    StiPieSegmentGeom segmentGeom = pieElementGeom.getPath().get(0) instanceof StiPieSegmentGeom ? (StiPieSegmentGeom)pieElementGeom.getPath().get(0) : null;
                    StiPieSegmentGeom stiPieSegmentGeom = segmentFromGeom = pieElementFromGeom.getPath().get(0) instanceof StiPieSegmentGeom ? (StiPieSegmentGeom)pieElementFromGeom.getPath().get(0) : null;
                    if (segmentGeom != null && segmentFromGeom != null) {
                        StiPieSegmentAnimation animation = new StiPieSegmentAnimation(segmentFromGeom.getRect(), segmentFromGeom.getStartAngle(), segmentFromGeom.getSweepAngle(), duration, Integer.valueOf(beginTime / listPieElementsGeom.size() * indexGeom));
                        segmentGeom.setAnimation((StiAnimation)animation);
                    }
                }
            } else {
                Integer beginTimeAnimationOpacity = beginTime / listPieElementsGeom.size() * (indexGeom + 2);
                pieElementGeom.setAnimation((StiAnimation)new StiOpacityAnimation(duration, beginTimeAnimationOpacity));
            }
            if (pieElementGeom.getSeries().getCore().getInteraction() != null) {
                StiSeriesInteractionData data = new StiSeriesInteractionData();
                data.Fill(geom.getArea(), pieElementGeom.getSeries(), pieElementGeom.getIndex());
                pieElementGeom.setInteraction(data);
            }
            geom.CreateChildGeoms();
            geom.getChildGeoms().add(pieElementGeom);
        }
        angle = currentSeries.getStartAngle();
        List<StiGeom> listPieLabelsGeom = this.GetPieLabelGeoms(context, radius, rect, seriesArray, deltaY, false);
        List<StiGeom> listPieLabelsFromGeom = this.GetPieLabelGeoms(context, radius, rect, seriesArray, deltaY, chart.isAnimationChangingValues());
        if (chart.isAnimationChangingValues()) {
            double labelRadius2 = radius / 1.75;
            StiRectangle labelClientRect = new StiRectangle(pointCenter.x - labelRadius2, pointCenter.y - labelRadius2, 2.0 * labelRadius2, 2.0 * labelRadius2);
            for (int indexGeom = 0; indexGeom < listPieElementsGeom.size(); ++indexGeom) {
                StiCenterPieLabelsGeom labelGeomFrom;
                StiCenterPieLabelsGeom labelGeom;
                StiCenterPieLabelsGeom stiCenterPieLabelsGeom = labelGeom = listPieLabelsGeom.get(indexGeom) instanceof StiCenterPieLabelsGeom ? (StiCenterPieLabelsGeom)listPieLabelsGeom.get(indexGeom) : null;
                StiCenterPieLabelsGeom stiCenterPieLabelsGeom2 = listPieLabelsFromGeom.size() > indexGeom ? (listPieLabelsFromGeom.get(indexGeom) instanceof StiCenterPieLabelsGeom ? (StiCenterPieLabelsGeom)listPieLabelsFromGeom.get(indexGeom) : null) : (labelGeomFrom = null);
                if (labelGeom != null && labelGeomFrom != null) {
                    StiPieSeriesElementGeom pieElement;
                    StiPieSeriesElementGeom pieElementFrom;
                    Integer pointIndex = labelGeom.getIndex();
                    double angleLabelFrom = 0.0;
                    double angleLabel = 0.0;
                    StiPieSeriesElementGeom stiPieSeriesElementGeom = listPieElementsFromGeom.size() > pointIndex ? (listPieElementsFromGeom.get(pointIndex) instanceof StiPieSeriesElementGeom ? (StiPieSeriesElementGeom)listPieElementsFromGeom.get(pointIndex) : null) : (pieElementFrom = null);
                    StiPieSeriesElementGeom stiPieSeriesElementGeom3 = listPieElementsGeom.size() > pointIndex ? (listPieElementsGeom.get(pointIndex) instanceof StiPieSeriesElementGeom ? (StiPieSeriesElementGeom)listPieElementsGeom.get(pointIndex) : null) : (pieElement = null);
                    if (pieElement != null && pieElementFrom != null) {
                        angleLabelFrom = (pieElementFrom.getStartAngle() + pieElementFrom.getEndAngle()) / 2.0;
                        angleLabel = (pieElement.getStartAngle() + pieElement.getEndAngle()) / 2.0;
                        StiPieLabelAnimation labelAnimation = new StiPieLabelAnimation(Double.valueOf(labelGeomFrom.getValue()), Double.valueOf(labelGeom.getValue()), angleLabelFrom, angleLabel, labelClientRect, labelGeomFrom.getLabelRect(), labelGeom.getLabelRect(), StiChartHelper.GlobalBeginTimeElement, Integer.valueOf(0));
                        labelGeom.setAnimation((StiAnimation)labelAnimation);
                    }
                }
                geom.CreateChildGeoms();
                geom.getChildGeoms().add(labelGeom);
            }
        } else {
            for (StiGeom labelGeom_ : listPieLabelsGeom) {
                StiCellGeom labelGeom = (StiCellGeom)labelGeom_;
                geom.CreateChildGeoms();
                geom.getChildGeoms().add(labelGeom);
            }
        }
        if (geom.getArea().getChart().getSeriesLabels().getPreventIntersection() && geom.getArea().getChart().getSeriesLabels() instanceof IStiTwoColumnsPieLabels) {
            this.CheckIntersectionTwoColumnsLabels(geom, rectPie2);
        }
    }

    private List<StiGeom> GetPieLabelGeoms(StiContext context, double radius, StiRectangle rect, IStiSeries[] seriesArray, double[] deltaY, boolean isForValueFrom) {
        ArrayList<StiGeom> resault = new ArrayList<StiGeom>();
        int colorIndex = 0;
        int labelIndex = 0;
        IStiPieSeries currentSeries = (IStiPieSeries)seriesArray[0];
        float gradPerValue = this.GetGradPerValue(seriesArray, isForValueFrom);
        float percentPerValue = this.GetPercentPerValue(seriesArray, isForValueFrom);
        StiPoint pointCenter = this.GetPointCenter(rect);
        float angle = currentSeries.getStartAngle();
        int colorCount = this.GetColorCount(seriesArray, isForValueFrom);
        for (IStiSeries ser : seriesArray) {
            Double[] values;
            IStiPieSeries pieSeries = (IStiPieSeries)(ser instanceof IStiPieSeries ? ser : null);
            int index = 0;
            for (Double value : values = isForValueFrom ? ser.getValuesStart() : ser.getValues()) {
                float arcWidth = (float)((double)gradPerValue * (value == null ? 0.0 : value));
                IStiPieSeriesLabels seriesLabels = ((StiPieSeriesCoreXF)pieSeries.getCore()).GetPieSeriesLabels();
                if (this.getSeries().getChart() != null && seriesLabels != null && seriesLabels.getVisible()) {
                    IStiPieSeriesLabels labels = seriesLabels instanceof IStiPieSeriesLabels ? seriesLabels : null;
                    IStiTwoColumnsPieLabels twoColumnsLabels = (IStiTwoColumnsPieLabels)(seriesLabels instanceof IStiTwoColumnsPieLabels ? seriesLabels : null);
                    if (labels != null) {
                        double labelRadius = radius;
                        if (this.GetPieDistance(index) > 0.0f) {
                            labelRadius += (double)(pieSeries.getDistance() * (float)context.Options.zoom);
                        }
                        float currAngle = angle + arcWidth / 2.0f;
                        float currDeltaY = 0.0f;
                        if (twoColumnsLabels != null && twoColumnsLabels.getPreventIntersection()) {
                            currDeltaY = (float)((double)currDeltaY + deltaY[labelIndex]);
                        }
                        if (labels.getStep() == 0 || index % labels.getStep() == 0) {
                            StiRectangle measureRect = null;
                            StiRefObject tempRef_measureRect3 = new StiRefObject(measureRect);
                            StiSeriesLabelsGeom seriesLabelsGeom = ((StiPieSeriesLabelsCoreXF)labels.getCore()).RenderLabel(pieSeries, context, pointCenter, labelRadius, 0.0, currAngle, index, value, value, this.GetArgumentText(ser, index), this.GetTag(index), false, colorIndex, colorCount, percentPerValue, (StiRefObject<StiRectangle>)tempRef_measureRect3, false, currDeltaY);
                            measureRect = (StiRectangle)tempRef_measureRect3.argvalue;
                            if (seriesLabelsGeom != null) {
                                resault.add(seriesLabelsGeom);
                            }
                            if (labels instanceof IStiOutsidePieLabels && ((IStiOutsidePieLabels)labels).getShowValue()) {
                                StiRefObject tempRef_measureRect4 = new StiRefObject((Object)measureRect);
                                seriesLabelsGeom = ((StiOutsidePieLabelsCoreXF)labels.getCore()).RenderLabel(pieSeries, context, pointCenter, labelRadius, 0.0, currAngle, index, value, value, this.GetArgumentText(ser, index), this.GetTag(index), false, colorIndex, colorCount, percentPerValue, (StiRefObject<StiRectangle>)tempRef_measureRect4, true, 0.0);
                                measureRect = (StiRectangle)tempRef_measureRect4.argvalue;
                                if (seriesLabelsGeom != null) {
                                    resault.add(seriesLabelsGeom);
                                }
                            }
                        }
                    }
                }
                ++colorIndex;
                angle += arcWidth;
                ++index;
                if (value.equals(0) && (!(this.getSeries().getChart().getSeriesLabels() instanceof StiPieSeriesLabels) || !((IStiPieSeriesLabels)this.getSeries().getChart().getSeriesLabels()).getShowZeros())) continue;
                ++labelIndex;
            }
        }
        return resault;
    }

    public IStiPieSeriesLabels GetPieSeriesLabels() {
        if (this.getSeries().getShowSeriesLabels() == StiShowSeriesLabels.FromChart) {
            return this.getSeries().getChart().getSeriesLabels() instanceof IStiPieSeriesLabels ? (IStiPieSeriesLabels)this.getSeries().getChart().getSeriesLabels() : null;
        }
        if (this.getSeries().getShowSeriesLabels() == StiShowSeriesLabels.FromSeries) {
            return this.getSeries().getSeriesLabels() instanceof IStiPieSeriesLabels ? (IStiPieSeriesLabels)this.getSeries().getSeriesLabels() : null;
        }
        return null;
    }

    private float GetGradPerValue(IStiSeries[] series, boolean isForValueFrom) {
        double totals = 0.0;
        int count = 0;
        for (IStiSeries sr : series) {
            Double[] values;
            for (Double value : values = isForValueFrom ? sr.getValuesStart() : sr.getValues()) {
                totals += value == null ? 0.0 : value;
                ++count;
            }
        }
        if (count == 0) {
            count = 1;
        }
        if (totals > 0.0) {
            return (float)(360.0 / totals);
        }
        return 360 / count;
    }

    public final float GetPercentPerValue(IStiSeries[] series, boolean isForValueFrom) {
        double totals = 0.0;
        for (IStiSeries sr : series) {
            Double[] values;
            for (Double value : values = isForValueFrom ? sr.getValuesStart() : sr.getValues()) {
                totals += value == null ? 0.0 : value;
            }
        }
        return (float)(1.0 / totals * 100.0);
    }

    protected final StiPoint GetPointCenter(StiRectangle rect) {
        return new StiPoint(rect.width / 2.0, rect.height / 2.0);
    }

    protected final double GetRadius(StiContext context, StiRectangle rect) {
        IStiSeries tempVar = this.getSeries();
        IStiPieSeries pieSeries = (IStiPieSeries)(tempVar instanceof IStiPieSeries ? tempVar : null);
        if (pieSeries.getDiameter() > 0.0f) {
            return pieSeries.getDiameter() / 2.0f * (float)context.Options.zoom;
        }
        return Math.min(rect.width / 2.0, rect.height / 2.0) * (double)0.95f;
    }

    protected final StiPoint GetPoint(StiPoint centerPie, double radius, double angle) {
        float angleRad = (float)(Math.PI * angle / 180.0);
        return new StiPoint(centerPie.x + (double)((float)Math.cos(angleRad)) * radius, centerPie.y + (double)((float)Math.sin(angleRad)) * radius);
    }

    private String GetArgumentText(IStiSeries series, int index) {
        if (series.getArguments().length > index && series.getArguments()[index] != null) {
            return series.getArguments()[index].toString();
        }
        return "";
    }

    public final float GetPieDistance(int pieIndex) {
        IStiSeries tempVar = this.getSeries();
        return this.GetPieDistance((IStiPieSeries)(tempVar instanceof IStiPieSeries ? tempVar : null), pieIndex);
    }

    public final float GetPieDistance(IStiPieSeries series, int pieIndex) {
        if (series.getDistance() == 0.0f) {
            return 0.0f;
        }
        if (series.getCutPieListValues().size() == 0) {
            return series.getDistance();
        }
        for (double index : series.getCutPieListValues()) {
            if (index != (double)(pieIndex + 1)) continue;
            return series.getDistance();
        }
        return 0.0f;
    }

    @Override
    public StiBrush GetSeriesBrush(int colorIndex, int colorCount) {
        StiBrush brush = super.GetSeriesBrush(colorIndex, colorCount);
        if (brush == null) {
            return ((IStiPieSeries)this.getSeries()).getBrush();
        }
        return brush;
    }

    @Override
    public Object GetSeriesBorderColor(int colorIndex, int colorCount) {
        Object color = super.GetSeriesBorderColor(colorIndex, colorCount);
        if (color == null) {
            return ((IStiPieSeries)this.getSeries()).getBorderColor();
        }
        return color;
    }

    @Override
    public String getLocalizedName() {
        return StiLocalization.Get((String)"Chart", (String)"Pie");
    }

    public StiPieSeriesCoreXF(IStiSeries series) {
        super(series);
    }

    private int GetColorCount(IStiSeries[] seriesArray, boolean isForValueFrom) {
        int colorCount = 0;
        for (IStiSeries ser : seriesArray) {
            if (isForValueFrom && ser.getValuesStart() != null) {
                colorCount += ser.getValuesStart().length;
            }
            if (isForValueFrom || ser.getValues() == null) continue;
            colorCount += ser.getValues().length;
        }
        return colorCount;
    }

    private List<StiCellGeom> GetPieElementGeoms(StiContext context, StiAreaGeom geom, double radius, StiRectangle rect, IStiSeries[] seriesArray, boolean isForValueFrom) {
        ArrayList<StiCellGeom> resaultList = new ArrayList<StiCellGeom>();
        IStiPieSeries currentSeries = (IStiPieSeries)seriesArray[0];
        float gradPerValue = this.GetGradPerValue(seriesArray, isForValueFrom);
        float percentPerValue = this.GetPercentPerValue(seriesArray, isForValueFrom);
        StiPoint pointCenter = this.GetPointCenter(rect);
        double angle = currentSeries.getStartAngle();
        int colorCount = this.GetColorCount(seriesArray, isForValueFrom);
        int nonZeroValuesCount = 0;
        int firstNonZeroValueIndex = -1;
        StiRefObject nonZeroValuesCountRef = new StiRefObject((Object)0);
        StiRefObject firstNonZeroValueIndexRef = new StiRefObject((Object)-1);
        this.CheckNonZerovalue(seriesArray, (StiRefObject<Integer>)nonZeroValuesCountRef, (StiRefObject<Integer>)firstNonZeroValueIndexRef, isForValueFrom);
        nonZeroValuesCount = (Integer)nonZeroValuesCountRef.argvalue;
        firstNonZeroValueIndex = (Integer)firstNonZeroValueIndexRef.argvalue;
        angle = currentSeries.getStartAngle();
        int colorIndex = 0;
        for (IStiSeries ser_ : seriesArray) {
            IStiPieSeries ser = (IStiPieSeries)ser_;
            if (nonZeroValuesCount == 0) break;
            if (nonZeroValuesCount == 1) {
                StiBrush seriesBrush = ser.getBrush();
                if (ser.getAllowApplyBrush()) {
                    seriesBrush = ser.getCore().GetSeriesBrush(firstNonZeroValueIndex, colorCount);
                    seriesBrush = ser.ProcessSeriesBrushes(firstNonZeroValueIndex, seriesBrush);
                }
                StiRectangle rect2 = new StiRectangle(pointCenter.x - radius, pointCenter.y - radius, radius * 2.0, radius * 2.0);
                StiColor borderColor = ser.getBorderColor();
                if (ser.getAllowApplyBorderColor()) {
                    borderColor = (StiColor)ser.getCore().GetSeriesBorderColor(firstNonZeroValueIndex, colorCount);
                }
                StiPieSeriesFullElementGeom pieGeom = new StiPieSeriesFullElementGeom(ser, rect2, seriesBrush, borderColor);
                resaultList.add(pieGeom);
                break;
            }
            Double[] values = isForValueFrom ? ser.getValuesStart() : ser.getValues();
            for (int index = 0; index < values.length; ++index) {
                Double value = values[index];
                if (value != 0.0) {
                    StiPieSeriesElementGeom pieElementGeom;
                    double arcWidth = (double)gradPerValue * Math.abs(value != null ? value : 0.0);
                    StiBrush seriesBrush = ser.getBrush();
                    if (ser.getAllowApplyBrush()) {
                        seriesBrush = ser.getCore().GetSeriesBrush(colorIndex, colorCount);
                        seriesBrush = ser.ProcessSeriesBrushes(colorIndex, seriesBrush);
                    }
                    StiColor borderColor = ser.getBorderColor();
                    if (ser.getAllowApplyBorderColor()) {
                        borderColor = (StiColor)ser.getCore().GetSeriesBorderColor(colorIndex, colorCount);
                    }
                    if ((pieElementGeom = this.RenderPieElement(context, pointCenter, radius, borderColor, seriesBrush, angle, arcWidth, Math.abs(value != null ? value : 0.0), index, ser, this.GetPieDistance(ser, index), geom, StiChartHelper.GlobalBeginTimeElement / ser.getValues().length * index)) != null) {
                        resaultList.add(pieElementGeom);
                    }
                    angle += arcWidth;
                }
                ++colorIndex;
            }
        }
        return resaultList;
    }

    private void CheckNonZerovalue(IStiSeries[] seriesArray, StiRefObject<Integer> nonZeroValuesCount, StiRefObject<Integer> firstNonZeroValueIndex, boolean isForValueFrom) {
        int nonZeroValuesCountTemp = 0;
        int firstNonZeroValueIndexTemp = 0;
        int firstNonZeroValueIndexTemp1 = 0;
        for (IStiSeries ser : seriesArray) {
            Double[] values;
            for (Double value : values = isForValueFrom ? ser.getValuesStart() : ser.getValues()) {
                if (value != 0.0 && value != null && !Double.isNaN(value) && ++nonZeroValuesCountTemp == 1) {
                    firstNonZeroValueIndexTemp1 = firstNonZeroValueIndexTemp;
                }
                ++firstNonZeroValueIndexTemp;
            }
        }
        firstNonZeroValueIndex.argvalue = firstNonZeroValueIndexTemp1;
        nonZeroValuesCount.argvalue = nonZeroValuesCountTemp;
    }

    private void CheckIntersectionTwoColumnsLabels(StiAreaGeom geom, StiRectangle rect) {
        ArrayList<StiCellGeom> childGeoms = geom.getChildGeoms();
        StiPoint centerPoint = this.GetPointCenter(rect);
        ArrayList<StiTwoColumnsPieLabelsGeom> labelLeftGeoms = new ArrayList<StiTwoColumnsPieLabelsGeom>();
        ArrayList<StiTwoColumnsPieLabelsGeom> labelRightGeoms = new ArrayList<StiTwoColumnsPieLabelsGeom>();
        for (StiCellGeom cellGeom : childGeoms) {
            if (!(cellGeom instanceof StiSeriesLabelsGeom)) continue;
            if (cellGeom.getClientRectangle().x < centerPoint.x) {
                labelLeftGeoms.add((StiTwoColumnsPieLabelsGeom)cellGeom);
                continue;
            }
            labelRightGeoms.add((StiTwoColumnsPieLabelsGeom)cellGeom);
        }
        this.CheckLabelPosition(labelLeftGeoms, rect);
        this.CheckLabelPosition(labelRightGeoms, rect);
    }

    private void CheckLabelPosition(List<StiTwoColumnsPieLabelsGeom> labels, StiRectangle rect) {
        double freeHeight = rect.height;
        Collections.sort(labels, new Comparator<StiTwoColumnsPieLabelsGeom>(){

            @Override
            public int compare(StiTwoColumnsPieLabelsGeom o1, StiTwoColumnsPieLabelsGeom o2) {
                return Double.compare(o1.getClientRectangle().y, o2.getClientRectangle().y);
            }
        });
        for (StiTwoColumnsPieLabelsGeom label : labels) {
            freeHeight -= label.getClientRectangle().height;
        }
        double stepFreeHeight = freeHeight / (double)(labels.size() + 1);
        double y0 = rect.y;
        for (StiTwoColumnsPieLabelsGeom label : labels) {
            label.setClientRectangle(new StiRectangle(label.getClientRectangle().x, y0 + stepFreeHeight, label.getClientRectangle().width, label.getClientRectangle().height));
            label.setEndPoint(new StiPoint(label.getEndPoint().x, label.getClientRectangle().y + label.getClientRectangle().height / 2.0));
            y0 = label.getClientRectangle().y + label.getClientRectangle().height;
        }
    }
}

