/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.report.chart.core.seriesLabels.funnel;

import com.stimulsoft.base.context.chart.StiContext;
import com.stimulsoft.base.context.chart.geoms.StiFontGeom;
import com.stimulsoft.base.context.chart.geoms.StiStringFormatGeom;
import com.stimulsoft.base.drawing.StiBrush;
import com.stimulsoft.base.drawing.StiColor;
import com.stimulsoft.base.drawing.StiSolidBrush;
import com.stimulsoft.base.drawing.enums.StiRotationMode;
import com.stimulsoft.base.localization.StiLocalization;
import com.stimulsoft.base.system.StiFont;
import com.stimulsoft.base.system.StiRefObject;
import com.stimulsoft.base.system.StiSize;
import com.stimulsoft.base.system.geometry.StiPoint;
import com.stimulsoft.base.system.geometry.StiRectangle;
import com.stimulsoft.report.chart.core.seriesLabels.funnel.StiFunnelSeriesLabelsCoreXF;
import com.stimulsoft.report.chart.enums.StiSeriesLabelsPosition;
import com.stimulsoft.report.chart.enums.StiSeriesLabelsType;
import com.stimulsoft.report.chart.geoms.seriesLabels.StiSeriesLabelsGeom;
import com.stimulsoft.report.chart.geoms.seriesLabels.funnel.StiOutsideFunnelLabelsGeom;
import com.stimulsoft.report.chart.interfaces.series.IStiSeries;
import com.stimulsoft.report.chart.interfaces.seriesLabels.IStiSeriesLabels;

public class StiOutsideLeftFunnelLabelsCoreXF
extends StiFunnelSeriesLabelsCoreXF {
    @Override
    public StiSeriesLabelsGeom RenderLabel(IStiSeries series, StiContext context, int pointIndex, double value, double valueNext, String argumentText, String tag, int colorIndex, int colorCount, StiRectangle rect, double singleValueHeight, double singleValueWidth, double centerAxis, StiRefObject<StiRectangle> measureRect) {
        measureRect.argvalue = rect.clone();
        String labelText = this.GetLabelText(series, value, argumentText, tag, series.getCoreTitle());
        StiSolidBrush labelBrush = new StiSolidBrush(this.GetLabelColor(series, colorIndex, colorCount));
        StiColor labelBorderColor = this.GetBorderColor(series, colorIndex, colorCount);
        StiStringFormatGeom sf = context.GetDefaultStringFormat();
        StiFontGeom font = StiFontGeom.ChangeFontSize((StiFont)this.getSeriesLabels().getFont(), (double)(this.getSeriesLabels().getFont().size * (double)context.Options.zoom));
        StiColor seriesBorderColor = (StiColor)series.getCore().GetSeriesBorderColor(colorIndex, colorCount);
        StiBrush seriesBrush = series.getCore().GetSeriesBrush(colorIndex, colorCount);
        StiBrush seriesLabelsBrush = this.ProcessSeriesColors(pointIndex, this.getSeriesLabels().getBrush(), series);
        StiSize labelSize = context.MeasureString(labelText, font).round();
        ((StiRectangle)measureRect.argvalue).width -= labelSize.width;
        ((StiRectangle)measureRect.argvalue).x += labelSize.width;
        StiPoint startPoint = new StiPoint(centerAxis - (double)((float)(value + valueNext)) * singleValueWidth / 4.0, singleValueHeight * (double)pointIndex + singleValueHeight / 2.0 + rect.height * (double)0.05f);
        StiPoint endPoint = new StiPoint(rect.width * (double)0.05f + labelSize.width, singleValueHeight * (double)pointIndex + singleValueHeight / 2.0 + rect.height * (double)0.05f);
        StiRectangle labelRect = context.MeasureRotatedString(labelText, font, endPoint, sf, StiRotationMode.RightCenter, 0.0f);
        return new StiOutsideFunnelLabelsGeom(this.getSeriesLabels(), series, pointIndex, value, labelRect, labelText, seriesBrush, (StiBrush)labelBrush, labelBorderColor, seriesBorderColor, labelRect, startPoint, endPoint);
    }

    @Override
    public StiSeriesLabelsType getSeriesLabelsType() {
        return StiSeriesLabelsType.Funnel;
    }

    @Override
    public int getPosition() {
        return StiSeriesLabelsPosition.OutsideLeftFunnel.getValue();
    }

    @Override
    public String getLocalizedName() {
        return StiLocalization.Get((String)"PropertyMain", (String)"Left");
    }

    public StiOutsideLeftFunnelLabelsCoreXF(IStiSeriesLabels seriesLabels) {
        super(seriesLabels);
    }
}

