/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.report.chart.core.seriesLabels.pie;

import com.stimulsoft.base.IStiEnum;
import com.stimulsoft.base.context.chart.StiContext;
import com.stimulsoft.base.context.chart.geoms.StiFontGeom;
import com.stimulsoft.base.context.chart.geoms.StiStringFormatGeom;
import com.stimulsoft.base.drawing.StiBrush;
import com.stimulsoft.base.drawing.StiColor;
import com.stimulsoft.base.drawing.StiSolidBrush;
import com.stimulsoft.base.drawing.enums.StiRotationMode;
import com.stimulsoft.base.drawing.enums.StiStringFormatFlags;
import com.stimulsoft.base.drawing.enums.StiStringTrimming;
import com.stimulsoft.base.localization.StiLocalization;
import com.stimulsoft.base.system.StiFont;
import com.stimulsoft.base.system.StiRefObject;
import com.stimulsoft.base.system.geometry.StiPoint;
import com.stimulsoft.base.system.geometry.StiRectangle;
import com.stimulsoft.report.chart.core.seriesLabels.pie.StiInsideEndPieLabelsCoreXF;
import com.stimulsoft.report.chart.core.seriesLabels.pie.StiOutsidePieLabelsCoreXF;
import com.stimulsoft.report.chart.core.seriesLabels.pie.StiPieSeriesLabelsCoreXF;
import com.stimulsoft.report.chart.enums.StiSeriesLabelsPosition;
import com.stimulsoft.report.chart.enums.StiSeriesLabelsType;
import com.stimulsoft.report.chart.geoms.seriesLabels.StiSeriesLabelsGeom;
import com.stimulsoft.report.chart.geoms.seriesLabels.pie.StiCenterPieLabelsGeom;
import com.stimulsoft.report.chart.geoms.seriesLabels.pie.StiOutsidePieLabelsGeom;
import com.stimulsoft.report.chart.interfaces.series.IStiSeries;
import com.stimulsoft.report.chart.interfaces.seriesLabels.IStiSeriesLabels;
import com.stimulsoft.report.chart.interfaces.seriesLabels.pie.IStiCenterPieLabels;
import com.stimulsoft.report.chart.interfaces.seriesLabels.pie.IStiOutsidePieLabels;

public class StiCenterPieLabelsCoreXF
extends StiPieSeriesLabelsCoreXF {
    @Override
    public StiSeriesLabelsGeom RenderLabel(IStiSeries series, StiContext context, StiPoint centerPie, double radius, double radius2, double pieAngle, int pointIndex, Double value, Double labelValue, String argumentText, String tag, boolean measure, int colorIndex, int colorCount, double percentPerValue, StiRefObject<StiRectangle> measureRect, boolean drawValue, double deltaY) {
        measureRect.argvalue = StiRectangle.getEmpty();
        this.percentPerValue = percentPerValue;
        if (labelValue == null && !this.getSeriesLabels().getShowNulls()) {
            return null;
        }
        if (labelValue != null && labelValue == 0.0 && !this.getSeriesLabels().getShowZeros()) {
            return null;
        }
        if (value == null) {
            value = 0.0;
        }
        if (labelValue == null) {
            labelValue = 0.0;
        }
        if (Double.isNaN(radius) || Double.isNaN(radius2)) {
            return null;
        }
        String labelText = null;
        labelText = drawValue ? this.GetFormattedValue(series, labelValue) : this.GetLabelText(series, labelValue, argumentText, tag, series.getCoreTitle());
        float angleRad = (float)(Math.PI * pieAngle / 180.0);
        StiPoint labelPoint = this.GetLabelPoint(centerPie, (radius - radius2) / 1.75 + radius2, angleRad);
        if (!drawValue) {
            if (this instanceof StiOutsidePieLabelsCoreXF) {
                labelPoint = this.GetLabelPoint(centerPie, radius + (double)(((IStiOutsidePieLabels)this.getSeriesLabels()).getLineLength() * (float)context.Options.zoom), angleRad);
            }
            if (this instanceof StiInsideEndPieLabelsCoreXF) {
                labelPoint = this.GetLabelPoint(centerPie, (radius - radius2) / (double)1.2f + radius2, angleRad);
            }
        }
        StiFontGeom font = StiFontGeom.ChangeFontSize((StiFont)this.getSeriesLabels().getFont(), (double)(this.getSeriesLabels().getFont().size * (double)context.Options.zoom));
        StiStringFormatGeom sf = context.GetGenericStringFormat();
        sf.setTrimming(StiStringTrimming.None);
        sf.getFormatFlags().OR((IStiEnum)StiStringFormatFlags.MeasureTrailingSpaces);
        sf.getFormatFlags().OR((IStiEnum)StiStringFormatFlags.NoWrap);
        StiRectangle labelRect = StiRectangle.round((StiRectangle)this.GetLabelRect(context, labelPoint, labelText, font, sf));
        double angleToUse = this.getSeriesLabels().getAngle();
        StiRotationMode mode = StiRotationMode.CenterCenter;
        StiRectangle rect = labelRect.clone();
        rect.x = -rect.width / 2.0;
        rect.y = -rect.height / 2.0;
        if (((IStiCenterPieLabels)this.getSeriesLabels()).getAutoRotate()) {
            angleToUse = pieAngle;
            if (angleToUse > 0.0 && angleToUse < 90.0 || angleToUse > 270.0) {
                if (this.getSeriesLabels() instanceof IStiOutsidePieLabels) {
                    mode = StiRotationMode.LeftCenter;
                }
                rect.x = 0.0;
            } else {
                if (this.getSeriesLabels() instanceof IStiOutsidePieLabels) {
                    mode = StiRotationMode.RightCenter;
                }
                angleToUse += 180.0;
                rect.x = -rect.width;
            }
        }
        if (this instanceof StiOutsidePieLabelsCoreXF) {
            if (!((IStiCenterPieLabels)this.getSeriesLabels()).getAutoRotate()) {
                if (pieAngle > 337.5 || pieAngle < 22.5) {
                    rect.x = 0.0;
                    rect.y = -rect.height / 2.0;
                    mode = StiRotationMode.LeftCenter;
                } else if (pieAngle >= 22.5 && pieAngle < 67.5) {
                    rect.x = 0.0;
                    rect.y = 0.0;
                    mode = StiRotationMode.LeftTop;
                } else if (pieAngle >= 67.5 && pieAngle < 112.5) {
                    rect.x = -rect.width / 2.0;
                    rect.y = 0.0;
                    mode = StiRotationMode.CenterTop;
                } else if (pieAngle >= 112.5 && pieAngle < 157.5) {
                    rect.x = -rect.width;
                    rect.y = 0.0;
                    mode = StiRotationMode.RightTop;
                } else if (pieAngle >= 157.5 && pieAngle < 202.5) {
                    rect.x = -rect.width;
                    rect.y = -rect.height / 2.0;
                    mode = StiRotationMode.RightCenter;
                } else if (pieAngle >= 202.5 && pieAngle < 247.5) {
                    rect.x = -rect.width;
                    rect.y = -rect.height;
                    mode = StiRotationMode.RightBottom;
                } else if (pieAngle >= 247.5 && pieAngle < 292.5) {
                    rect.x = -rect.width / 2.0;
                    rect.y = -rect.height;
                    mode = StiRotationMode.CenterBottom;
                } else if (pieAngle >= 292.5) {
                    rect.x = 0.0;
                    rect.y = -rect.height;
                    mode = StiRotationMode.LeftBottom;
                }
            }
        } else {
            rect.x = -rect.width / 2.0;
            rect.y = -rect.height / 2.0;
        }
        if (measure) {
            measureRect.argvalue = context.MeasureRotatedString(labelText, font, labelRect, sf, mode, angleToUse);
            return null;
        }
        StiColor borderColor = this.GetBorderColor(series, colorIndex, colorCount);
        StiColor seriesBorderColor = (StiColor)series.getCore().GetSeriesBorderColor(colorIndex, colorCount);
        StiBrush seriesBrush = series.getCore().GetSeriesBrush(colorIndex, colorCount);
        StiSolidBrush labelBrush = new StiSolidBrush(this.GetLabelColor(series, colorIndex, colorCount));
        seriesBrush = this.ProcessSeriesColors(pointIndex, seriesBrush, series);
        StiBrush seriesLabelsBrush = this.ProcessSeriesColors(pointIndex, this.getSeriesLabels().getBrush(), series);
        measureRect.argvalue = StiRectangle.getEmpty();
        if (this.getSeriesLabels() instanceof IStiOutsidePieLabels) {
            StiOutsidePieLabelsCoreXF outsidePieLabels = (StiOutsidePieLabelsCoreXF)(this instanceof StiOutsidePieLabelsCoreXF ? this : null);
            StiColor lineColor = outsidePieLabels.GetLineColor(series, colorIndex, colorCount);
            labelPoint = this.GetLabelPoint(centerPie, radius + (double)(((IStiOutsidePieLabels)outsidePieLabels.getSeriesLabels()).getLineLength() * (float)context.Options.zoom), angleRad);
            StiPoint startPoint = this.GetLabelPoint(centerPie, radius, angleRad);
            return new StiOutsidePieLabelsGeom(this.getSeriesLabels(), series, pointIndex, value, rect, labelText, seriesBrush, (StiBrush)labelBrush, seriesLabelsBrush, borderColor, seriesBorderColor, mode, labelRect, angleToUse, lineColor, labelPoint, startPoint);
        }
        return new StiCenterPieLabelsGeom(this.getSeriesLabels(), series, pointIndex, value, rect, labelText, seriesBrush, (StiBrush)labelBrush, seriesLabelsBrush, borderColor, seriesBorderColor, mode, labelRect, angleToUse, null);
    }

    public final StiPoint GetLabelPoint(StiPoint centerPie, double radius, double angleRad) {
        return new StiPoint(centerPie.x + (double)((float)Math.cos(angleRad)) * radius, centerPie.y + (double)((float)Math.sin(angleRad)) * radius);
    }

    public StiRectangle GetLabelRect(StiContext context, StiPoint labelPoint, String labelText, StiFontGeom font, StiStringFormatGeom sf) {
        return context.MeasureRotatedString(labelText, font, labelPoint, sf, StiRotationMode.CenterCenter, 0.0f);
    }

    @Override
    public StiSeriesLabelsType getSeriesLabelsType() {
        return StiSeriesLabelsType.Pie;
    }

    @Override
    public int getPosition() {
        return StiSeriesLabelsPosition.CenterPie.getValue();
    }

    @Override
    public String getLocalizedName() {
        return StiLocalization.Get((String)"Chart", (String)"LabelsCenter");
    }

    public StiCenterPieLabelsCoreXF(IStiSeriesLabels seriesLabels) {
        super(seriesLabels);
    }
}

