/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.report.chart.core.styles;

import com.stimulsoft.base.context.chart.StiContext;
import com.stimulsoft.base.context.chart.animation.StiInteractionDataGeom;
import com.stimulsoft.base.drawing.StiBrush;
import com.stimulsoft.base.drawing.StiColor;
import com.stimulsoft.base.drawing.StiColorUtils;
import com.stimulsoft.base.drawing.StiGradientBrush;
import com.stimulsoft.base.drawing.StiSolidBrush;
import com.stimulsoft.base.system.StiFont;
import com.stimulsoft.base.system.geometry.StiRectangle;
import com.stimulsoft.report.chart.interfaces.IStiChart;
import com.stimulsoft.report.chart.interfaces.series.IStiSeries;

public abstract class StiStyleCoreXF {
    private IStiChart chart = null;

    public abstract String getLocalizedName();

    public StiBrush getChartBrush() {
        return new StiSolidBrush(StiColorUtils.light((StiColor)this.getBasicStyleColor(), (int)100));
    }

    public StiBrush getChartAreaBrush() {
        return new StiGradientBrush(StiColorUtils.light((StiColor)this.getBasicStyleColor(), (int)80), StiColorUtils.light((StiColor)this.getBasicStyleColor(), (int)40), 90.0);
    }

    public StiColor getChartAreaBorderColor() {
        return StiColorUtils.dark((StiColor)this.getBasicStyleColor(), (int)150);
    }

    public final IStiChart getChart() {
        return this.chart;
    }

    public final void setChart(IStiChart value) {
        this.chart = value;
    }

    public StiBrush getSeriesLabelsBrush() {
        return new StiSolidBrush(this.getBasicStyleColor());
    }

    public StiColor getSeriesLabelsColor() {
        return StiColorUtils.dark((StiColor)this.getBasicStyleColor(), (int)150);
    }

    public StiColor getSeriesLabelsBorderColor() {
        return StiColorUtils.dark((StiColor)this.getBasicStyleColor(), (int)150);
    }

    public StiColor getSeriesLabelsLineColor() {
        return StiColorUtils.dark((StiColor)this.getBasicStyleColor(), (int)150);
    }

    public StiFont getSeriesLabelsFont() {
        return new StiFont("Arial", 7.0);
    }

    public StiBrush getLegendBrush() {
        return new StiGradientBrush(StiColorUtils.light((StiColor)this.getBasicStyleColor(), (int)80), StiColorUtils.light((StiColor)this.getBasicStyleColor(), (int)20), 90.0);
    }

    public StiColor getLegendLabelsColor() {
        return StiColorUtils.dark((StiColor)this.getBasicStyleColor(), (int)150);
    }

    public StiColor getLegendBorderColor() {
        return StiColorUtils.dark((StiColor)this.getBasicStyleColor(), (int)150);
    }

    public StiColor getLegendTitleColor() {
        return StiColorUtils.dark((StiColor)this.getBasicStyleColor(), (int)150);
    }

    public boolean isLegendShowShadow() {
        return false;
    }

    public StiFont getLegendFont() {
        return new StiFont("Arial", 8.0);
    }

    public boolean isSeriesLighting() {
        return true;
    }

    public boolean isSeriesShowShadow() {
        return false;
    }

    public StiColor getAxisTitleColor() {
        return StiColorUtils.dark((StiColor)this.getBasicStyleColor(), (int)150);
    }

    public StiColor getAxisLineColor() {
        return StiColorUtils.dark((StiColor)this.getBasicStyleColor(), (int)150);
    }

    public StiColor getAxisLabelsColor() {
        return StiColorUtils.dark((StiColor)this.getBasicStyleColor(), (int)150);
    }

    public StiBrush getInterlacingHorBrush() {
        return new StiSolidBrush(StiColor.FromArgb((int)10, (StiColor)StiColorUtils.dark((StiColor)this.getBasicStyleColor(), (int)100)));
    }

    public StiBrush getInterlacingVertBrush() {
        return new StiSolidBrush(StiColor.FromArgb((int)10, (StiColor)StiColorUtils.dark((StiColor)this.getBasicStyleColor(), (int)100)));
    }

    public StiColor getGridLinesHorColor() {
        return StiColor.FromArgb((int)100, (StiColor)StiColorUtils.dark((StiColor)this.getBasicStyleColor(), (int)150));
    }

    public StiColor getGridLinesVertColor() {
        return StiColor.FromArgb((int)100, (StiColor)StiColorUtils.dark((StiColor)this.getBasicStyleColor(), (int)150));
    }

    public StiColor getFirstStyleColor() {
        return this.getStyleColors()[0];
    }

    public StiColor getLastStyleColor() {
        return this.getStyleColors()[this.getStyleColors().length - 1];
    }

    public boolean getChartAreaShowShadow() {
        return false;
    }

    public StiColor getTrendLineColor() {
        return StiColorUtils.dark((StiColor)this.getBasicStyleColor(), (int)150);
    }

    public boolean getTrendLineShowShadow() {
        return false;
    }

    public abstract StiColor[] getStyleColors();

    public abstract StiColor getBasicStyleColor();

    public void FillColumn(StiContext context, StiRectangle rect, StiBrush brush, StiInteractionDataGeom interaction) {
        this.FillColumn(context, rect, brush, interaction, -1);
    }

    public void FillColumn(StiContext context, StiRectangle rect, StiBrush brush, StiInteractionDataGeom interaction, int elementIndex) {
        context.FillRectangle((Object)brush, rect.x, rect.y, rect.width, rect.height, interaction, elementIndex);
    }

    public StiBrush GetAreaBrush(StiColor color) {
        return new StiSolidBrush(StiColor.FromArgb((int)200, (StiColor)color));
    }

    public StiBrush GetColumnBrush(StiColor color) {
        return new StiGradientBrush(color, StiColorUtils.dark((StiColor)color, (int)50), 0.0);
    }

    public StiColor GetColumnBorder(StiColor color) {
        return StiColorUtils.dark((StiColor)color, (int)100);
    }

    public StiColor[] GetColors(int seriesCount) {
        StiColor[] colors = new StiColor[seriesCount];
        StiColor[] styleColors = this.getStyleColors();
        int styleColorIndex = 0;
        int dist = 0;
        for (int colorIndex = 0; colorIndex < seriesCount; ++colorIndex) {
            if (dist != 0) {
                StiColor color = styleColors[styleColorIndex];
                int a = Math.min(color.getA() + dist, 255);
                int r = Math.min(color.getR() + dist, 255);
                int g = Math.min(color.getG() + dist, 255);
                int b = Math.min(color.getB() + dist, 255);
                colors[colorIndex] = StiColor.fromArgb((int)a, (int)r, (int)g, (int)b);
            } else {
                colors[colorIndex] = styleColors[styleColorIndex].clone();
            }
            if (++styleColorIndex != styleColors.length) continue;
            styleColorIndex = 0;
            dist = 50;
        }
        return colors;
    }

    public final StiColor GetColorByIndex(int index, int count) {
        return this.GetColors(count)[index];
    }

    public final StiColor GetColorBySeries(IStiSeries series) {
        return this.GetColors(series.getChart().getSeries().size())[series.getChart().getSeries().indexOf(series)];
    }
}

