/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.report.chart.core.trendLines;

import com.stimulsoft.base.localization.StiLocalization;
import com.stimulsoft.base.system.geometry.StiPoint;
import com.stimulsoft.report.chart.core.trendLines.StiTrendLineCoreXF;
import com.stimulsoft.report.chart.geoms.areas.StiAreaGeom;
import com.stimulsoft.report.chart.geoms.trendLines.StiTrendLineGeom;
import com.stimulsoft.report.chart.interfaces.trendLines.IStiTrendLine;

public class StiTrendLineLinearCoreXF
extends StiTrendLineCoreXF {
    @Override
    public String getLocalizedName() {
        return StiLocalization.Get((String)"PropertyMain", (String)"Linear");
    }

    @Override
    public void RenderTrendLine(StiAreaGeom geom, StiPoint[] points, double posY) {
        if (points.length > 0) {
            double[] valuesX = new double[points.length];
            double[] valuesY = new double[points.length];
            double maxValue = points[0].getValue().x;
            double minValue = points[0].getValue().x;
            for (int pointIndex = 0; pointIndex < points.length; ++pointIndex) {
                valuesX[pointIndex] = points[pointIndex].getValue().x;
                valuesY[pointIndex] = points[pointIndex].getValue().y;
                if (maxValue < valuesX[pointIndex]) {
                    maxValue = valuesX[pointIndex];
                }
                if (!(minValue > valuesX[pointIndex])) continue;
                minValue = valuesX[pointIndex];
            }
            int countPoints = points.length;
            float sumX = this.Sum(valuesX);
            float sumY = this.Sum(valuesY);
            float sumX2 = this.SumSqr(valuesX);
            float sumProductionsXY = this.SumProductions(valuesX, valuesY);
            float c = sumX * sumX - sumX2 * (float)countPoints;
            float a = (sumY * sumX - sumProductionsXY * (float)countPoints) / c;
            float b = (sumX * sumProductionsXY - sumX2 * sumY) / c;
            StiTrendLineGeom line = new StiTrendLineGeom(new StiPoint(minValue, (double)a * minValue + (double)b), new StiPoint(maxValue, (double)a * maxValue + (double)b), this.getTrendLine());
            geom.CreateChildGeoms();
            geom.getChildGeoms().add(line);
        }
    }

    public StiTrendLineLinearCoreXF(IStiTrendLine trendLine) {
        super(trendLine);
    }
}

