/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.report.chart.geoms.axis;

import com.stimulsoft.base.context.chart.StiContext;
import com.stimulsoft.base.context.chart.geoms.StiArcSegmentGeom;
import com.stimulsoft.base.context.chart.geoms.StiLineSegmentGeom;
import com.stimulsoft.base.context.chart.geoms.StiPathGeom;
import com.stimulsoft.base.context.chart.geoms.StiPenGeom;
import com.stimulsoft.base.drawing.StiSolidBrush;
import com.stimulsoft.base.system.geometry.StiPoint;
import com.stimulsoft.base.system.geometry.StiRectangle;
import com.stimulsoft.report.chart.core.area.StiAxisAreaCoreXF;
import com.stimulsoft.report.chart.core.axis.StiYAxisCoreXF;
import com.stimulsoft.report.chart.core.axis.stripLines.StiStripPositionXF;
import com.stimulsoft.report.chart.enums.StiArrowStyle;
import com.stimulsoft.report.chart.enums.StiShowYAxis;
import com.stimulsoft.report.chart.geoms.StiCellGeom;
import com.stimulsoft.report.chart.geoms.axis.StiAxisLabelGeom;
import com.stimulsoft.report.chart.geoms.axis.StiYAxisViewGeom;
import com.stimulsoft.report.chart.interfaces.axis.IStiAxisTicks;
import com.stimulsoft.report.chart.interfaces.axis.IStiYAxis;
import java.util.ArrayList;

public class StiYAxisGeom
extends StiCellGeom {
    private final IStiYAxis axis;
    private final boolean isCenterAxis;
    private StiYAxisViewGeom view;

    public final IStiYAxis getAxis() {
        return this.axis;
    }

    public final boolean getIsCenterAxis() {
        return this.isCenterAxis;
    }

    public final StiYAxisViewGeom getView() {
        return this.view;
    }

    public final void setView(StiYAxisViewGeom value) {
        this.view = value;
    }

    protected final void DrawArrow(StiContext context, StiRectangle rect) {
        float zoom = context.Options.zoom;
        StiPenGeom penLine = new StiPenGeom((Object)this.getAxis().getLineColor());
        StiSolidBrush brushLine = new StiSolidBrush(this.getAxis().getLineColor());
        StiPenGeom penArrow = new StiPenGeom((Object)this.getAxis().getLineColor());
        if (!this.getAxis().getVisible()) {
            this.DrawAxisLine(context, rect);
        }
        StiPoint arrowStart = StiPoint.getEmpty();
        arrowStart = !this.getAxis().getArea().getReverseVert() ? new StiPoint(rect.getRight(), rect.y) : new StiPoint(rect.getRight(), rect.getBottom());
        if (((StiYAxisCoreXF)this.getAxis().getCore()).getIsRightSide()) {
            arrowStart.x = rect.x;
        }
        switch (this.getAxis().getArrowStyle()) {
            case Triangle: {
                context.DrawLine(penLine, arrowStart.x, arrowStart.y, arrowStart.x, arrowStart.y - (double)(this.getAxis().getCore().getArrowHeight() * zoom));
                context.PushSmoothingModeToAntiAlias();
                ArrayList<StiLineSegmentGeom> path = new ArrayList<StiLineSegmentGeom>();
                path.add(new StiLineSegmentGeom(arrowStart.x - (double)(this.getAxis().getCore().getArrowWidth() * zoom), arrowStart.y - (double)(this.getAxis().getCore().getArrowHeight() * zoom), arrowStart.x + (double)(this.getAxis().getCore().getArrowWidth() * zoom), arrowStart.y - (double)(this.getAxis().getCore().getArrowHeight() * zoom)));
                path.add(new StiLineSegmentGeom(arrowStart.x + (double)(this.getAxis().getCore().getArrowWidth() * zoom), arrowStart.y - (double)(this.getAxis().getCore().getArrowHeight() * zoom), arrowStart.x, arrowStart.y - (double)(this.getAxis().getCore().getArrowHeight() * 4.0f * zoom)));
                context.FillPath((Object)brushLine, path, StiPathGeom.GetBoundsState, null);
                context.PopSmoothingMode();
                break;
            }
            case Lines: {
                context.DrawLine(penLine, arrowStart.x, arrowStart.y, arrowStart.x, arrowStart.y - (double)(this.getAxis().getCore().getArrowHeight() * 4.0f * zoom));
                context.PushSmoothingModeToAntiAlias();
                context.DrawLine(penArrow, arrowStart.x - (double)(this.getAxis().getCore().getArrowWidth() * zoom), arrowStart.y - (double)(this.getAxis().getCore().getArrowHeight() * zoom), arrowStart.x, arrowStart.y - (double)(this.getAxis().getCore().getArrowHeight() * 4.0f * zoom));
                context.DrawLine(penArrow, arrowStart.x + (double)(this.getAxis().getCore().getArrowWidth() * zoom), arrowStart.y - (double)(this.getAxis().getCore().getArrowHeight() * zoom), arrowStart.x, arrowStart.y - (double)(this.getAxis().getCore().getArrowHeight() * 4.0f * zoom));
                context.PopSmoothingMode();
                break;
            }
            case Circle: {
                context.DrawLine(penLine, arrowStart.x, arrowStart.y, arrowStart.x, arrowStart.y - (double)(this.getAxis().getCore().getArrowHeight() * zoom * 2.0f));
                float armCircle = this.getAxis().getCore().getArrowHeight() * zoom;
                StiPoint pointCircle = new StiPoint(arrowStart.x - (double)(armCircle / 2.0f), arrowStart.y - (double)(armCircle * 3.0f));
                context.PushSmoothingModeToAntiAlias();
                StiRectangle rectCircle = new StiRectangle(pointCircle.x, pointCircle.y, (double)(this.getAxis().getCore().getArrowHeight() * zoom), (double)(this.getAxis().getCore().getArrowHeight() * zoom));
                context.DrawEllipse(penLine, rectCircle);
                context.PopSmoothingMode();
                break;
            }
            case Arc: 
            case ArcAndCircle: {
                StiRectangle rectArc;
                StiPoint pointArc;
                float armArc = this.getAxis().getCore().getArrowHeight() * zoom;
                context.DrawLine(penLine, arrowStart.x, arrowStart.y, arrowStart.x, arrowStart.y - (double)(armArc * 2.0f));
                context.PushSmoothingModeToAntiAlias();
                ArrayList<StiArcSegmentGeom> pathArc = new ArrayList<StiArcSegmentGeom>();
                if (this.getAxis().getArea().getReverseVert()) {
                    pointArc = new StiPoint(arrowStart.x + (double)(armArc / 2.0f), arrowStart.y - (double)(armArc * 2.0f));
                    rectArc = new StiRectangle(pointArc.x, pointArc.y, (double)Math.abs(armArc), (double)Math.abs(armArc));
                    if (this.getAxis().getArrowStyle() == StiArrowStyle.ArcAndCircle) {
                        rectArc.y += (double)zoom;
                        rectArc.inflate(1, 1);
                    }
                    pathArc.add(new StiArcSegmentGeom(rectArc, 180.0f, 180.0f));
                } else {
                    pointArc = new StiPoint(arrowStart.x - (double)(armArc / 2.0f), arrowStart.y - (double)(armArc * 3.0f));
                    rectArc = new StiRectangle(pointArc.x, pointArc.y, (double)armArc, (double)armArc);
                    if (this.getAxis().getArrowStyle() == StiArrowStyle.ArcAndCircle) {
                        rectArc.y -= (double)zoom;
                        rectArc.inflate(1, 1);
                    }
                    pathArc.add(new StiArcSegmentGeom(rectArc, 0.0f, 180.0f));
                }
                context.DrawPath(penLine, pathArc, StiPathGeom.GetBoundsState);
                if (this.getAxis().getArrowStyle() == StiArrowStyle.ArcAndCircle) {
                    float armAC = this.getAxis().getCore().getArrowHeight() * zoom;
                    StiPoint pointAC = new StiPoint(arrowStart.x - (double)(armAC / 2.0f), arrowStart.y - (double)(armAC * 3.0f) - (double)zoom);
                    StiRectangle rectAC = new StiRectangle(pointAC.x, pointAC.y, (double)armAC, (double)armAC);
                    if (this.getAxis().getArea().getReverseVert()) {
                        rectAC.inflate(Double.valueOf(0.5 * (double)zoom), Double.valueOf(0.5 * (double)zoom));
                        rectAC.y += (double)(zoom * 3.0f);
                    } else {
                        rectAC.inflate(Double.valueOf(-0.5 * (double)zoom), Double.valueOf(-0.5 * (double)zoom));
                        rectAC.y -= (double)zoom;
                    }
                    context.FillEllipse((Object)brushLine, rectAC, null);
                }
                context.PopSmoothingMode();
            }
        }
    }

    private void DrawAxisLine(StiContext context, StiRectangle rect) {
        double posX = rect.getRight();
        if (((StiYAxisCoreXF)this.getAxis().getCore()).getIsRightSide()) {
            posX = rect.getLeft();
        }
        if (this.getIsCenterAxis() && this.getAxis().getArea().getReverseHor()) {
            posX = rect.getRight();
        }
        StiPenGeom penLine = new StiPenGeom((Object)this.getAxis().getLineColor(), this.getAxis().getLineWidth());
        if (this.getAxis().getShowYAxis() == StiShowYAxis.Both || this.getAxis().getShowYAxis() == StiShowYAxis.Left) {
            context.DrawLine(penLine, posX, rect.y, posX, rect.getBottom());
        }
    }

    private void DrawMinorTicks(StiContext context, StiPenGeom pen, double posX, double posY1, double posY2, IStiAxisTicks ticks) {
        double step = posY2 - posY1;
        double minorStep = step / (double)(ticks.getMinorCount() + 1);
        float minorLength = ticks.getMinorLength() * (float)context.Options.zoom;
        for (int minorIndex = 1; minorIndex <= ticks.getMinorCount(); ++minorIndex) {
            double posX2;
            double posY = posY1 + minorStep * (double)minorIndex;
            double d = posX2 = ((StiYAxisCoreXF)this.getAxis().getCore()).getIsLeftSide() || this.getIsCenterAxis() ? posX - (double)minorLength : posX + (double)minorLength;
            if (this.getAxis().getArea().getReverseHor() && this.getIsCenterAxis()) {
                posX2 = posX + (double)minorLength;
            }
            context.DrawLine(pen, posX, posY, posX2, posY);
        }
    }

    private void DrawTicks(StiContext context, StiRectangle rect, IStiAxisTicks ticks, StiPenGeom penLine) {
        double posX2;
        if (!ticks.getVisible()) {
            return;
        }
        float ticksLength = ticks.getLength() * (float)context.Options.zoom;
        double posX1 = ((StiYAxisCoreXF)this.getAxis().getCore()).getIsLeftSide() ? rect.getRight() : rect.getLeft();
        double d = posX2 = ((StiYAxisCoreXF)this.getAxis().getCore()).getIsLeftSide() ? posX1 - (double)ticksLength : posX1 + (double)ticksLength;
        if (this.getIsCenterAxis() && this.getAxis().getArea().getReverseHor()) {
            posX1 = rect.getRight();
            posX2 = rect.getRight() + (double)ticksLength;
        }
        int index = 0;
        for (StiStripPositionXF strip : this.getAxis().getInfo().TicksCollection) {
            double posY = strip.Position;
            context.DrawLine(penLine, posX1, posY, posX2, posY);
            if (ticks.getMinorVisible() && index != this.getAxis().getInfo().TicksCollection.size() - 1) {
                double posY2 = this.getAxis().getInfo().TicksCollection.get((int)(index + 1)).Position;
                this.DrawMinorTicks(context, penLine, posX1, posY, posY2, ticks);
            }
            ++index;
        }
    }

    private void DrawAxis(StiContext context, StiRectangle rect) {
        StiPenGeom penLine = new StiPenGeom((Object)this.getAxis().getLineColor(), this.getAxis().getLineWidth());
        penLine.setPenStyle(this.getAxis().getLineStyle());
        if (((StiYAxisCoreXF)this.getAxis().getCore()).getIsLeftSide() && (this.getAxis().getShowYAxis() == StiShowYAxis.Both || this.getAxis().getShowYAxis() == StiShowYAxis.Left)) {
            this.DrawTicks(context, rect, this.getAxis().getArea().getYAxis().getTicks(), penLine);
        }
        if (((StiYAxisCoreXF)this.getAxis().getCore()).getIsRightSide()) {
            this.DrawTicks(context, rect, this.getAxis().getArea().getYRightAxis().getTicks(), penLine);
        }
        this.DrawAxisLine(context, rect);
    }

    private StiRectangle GetViewClipRect() {
        StiRectangle clipRect = this.getView().getClientRectangle();
        clipRect.x = 0.0;
        clipRect.y = (float)((StiAxisAreaCoreXF)this.getAxis().getArea().getCore()).getScrollDistanceY();
        clipRect.inflate(1, 1);
        if (this.getIsCenterAxis()) {
            clipRect.inflate(2, 0);
        }
        return clipRect;
    }

    @Override
    protected boolean AllowChildDrawing(StiCellGeom cellGeom) {
        StiAxisLabelGeom geom = (StiAxisLabelGeom)(cellGeom instanceof StiAxisLabelGeom ? cellGeom : null);
        if (geom == null) {
            return true;
        }
        if (this.getView() == null) {
            return true;
        }
        StiRectangle clipRect = this.GetViewClipRect();
        StiRectangle geomRect = geom.getClientRectangle();
        return !(geomRect.getBottom() < clipRect.getY()) && !(geomRect.y > clipRect.getBottom());
    }

    @Override
    public void Draw(StiContext context) {
        StiRectangle rect = this.getClientRectangle();
        if (rect.getWidth() <= 0.0 || rect.getHeight() <= 0.0) {
            return;
        }
        if (this.getView() != null) {
            StiRectangle clipRect = this.GetViewClipRect();
            context.PushClip(clipRect);
        }
        this.DrawAxis(context, rect);
        if (this.getView() != null) {
            context.PopClip();
        }
    }

    public StiYAxisGeom(IStiYAxis axis, StiRectangle clientRectangle, boolean isCenterAxis) {
        super(clientRectangle);
        this.axis = axis;
        this.isCenterAxis = isCenterAxis;
    }
}

