/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.report.chart.geoms.legend;

import com.stimulsoft.base.StiEnumSet;
import com.stimulsoft.base.context.chart.StiContext;
import com.stimulsoft.base.context.chart.geoms.StiFontGeom;
import com.stimulsoft.base.context.chart.geoms.StiStringFormatGeom;
import com.stimulsoft.base.drawing.StiSolidBrush;
import com.stimulsoft.base.drawing.enums.StiStringAlignment;
import com.stimulsoft.base.drawing.enums.StiStringFormatFlags;
import com.stimulsoft.base.system.StiFont;
import com.stimulsoft.base.system.geometry.StiRectangle;
import com.stimulsoft.report.chart.StiInteractionOptions;
import com.stimulsoft.report.chart.core.legend.StiLegendItemCoreXF;
import com.stimulsoft.report.chart.enums.StiMarkerAlignment;
import com.stimulsoft.report.chart.geoms.StiCellGeom;
import com.stimulsoft.report.chart.geoms.marker.StiMarkerLegendFactory;
import com.stimulsoft.report.chart.interfaces.legend.IStiLegend;
import com.stimulsoft.report.chart.interfaces.legend.IStiLegendMarker;
import com.stimulsoft.report.chart.view.series.StiSeriesInteractionData;

public class StiLegendItemGeom
extends StiCellGeom {
    private final IStiLegend legend;
    private final StiLegendItemCoreXF item;
    private final int colorIndex;
    private final int legendItemsCount;
    private int legendItemIndex;

    @Override
    public void InvokeMouseEnter(StiInteractionOptions options) {
        if (!this.getAllowMouseOver()) {
            return;
        }
        if (!this.getIsMouseOver()) {
            this.setIsMouseOver(true);
            options.setUpdateContext(true);
        }
    }

    @Override
    public void InvokeMouseLeave(StiInteractionOptions options) {
        if (!this.getAllowMouseOver()) {
            return;
        }
        if (this.getIsMouseOver()) {
            this.setIsMouseOver(false);
            options.setUpdateContext(true);
        }
    }

    @Override
    public void InvokeClick(StiInteractionOptions options) {
        if (this.getItem().getSeries().getInteraction() != null && this.getItem().getSeries().getInteraction().getDrillDownEnabled() && this.getItem().getSeries().getInteraction().getAllowSeries()) {
            StiSeriesInteractionData data = new StiSeriesInteractionData();
            if (this.getIsColorEach()) {
                data.Fill(this.getItem().getSeries().getChart().getArea(), this.getItem().getSeries(), this.getItem().getIndex());
                data.setIsElements(true);
            } else {
                data.setSeries(this.getItem().getSeries());
                data.setIsElements(false);
            }
            this.setIsMouseOver(false);
            options.setUpdateContext(true);
            options.setSeriesInteractionData(data);
        }
    }

    public boolean getAllowMouseOver() {
        return this.getItem() != null && this.getItem().getSeries() != null && this.getItem().getSeries().getInteraction() != null && this.getItem().getSeries().getInteraction().getAllowSeries() && this.getItem().getSeries().getInteraction().getDrillDownEnabled();
    }

    private boolean getIsColorEach() {
        return this.getItem().getSeries().getChart().getArea().getColorEach();
    }

    public boolean getIsMouseOver() {
        if (this.getIsColorEach()) {
            if (this.getItem().getIndex() == -1) {
                return false;
            }
            return this.getItem().getSeries().getCore().GetIsMouseOverSeriesElement(this.getItem().getIndex());
        }
        return this.getItem().getSeries().getCore().getIsMouseOver();
    }

    public void setIsMouseOver(boolean value) {
        if (this.getIsColorEach()) {
            if (this.getItem().getIndex() != -1) {
                this.getItem().getSeries().getCore().SetIsMouseOverSeriesElement(this.getItem().getIndex(), value);
            }
        } else {
            this.getItem().getSeries().getCore().setIsMouseOver(value);
        }
    }

    public final IStiLegend getLegend() {
        return this.legend;
    }

    public final StiLegendItemCoreXF getItem() {
        return this.item;
    }

    public final int getColorIndex() {
        return this.colorIndex;
    }

    public final int getLegendItemsCount() {
        return this.legendItemsCount;
    }

    @Override
    public void Draw(StiContext context) {
        StiRectangle textRect = this.getClientRectangle();
        if (this.legend.getMarkerVisible()) {
            StiRectangle markerRect = new StiRectangle(this.getClientRectangle().x, this.getClientRectangle().y + (this.getClientRectangle().height - this.legend.getMarkerSize().height * (double)context.Options.zoom) / 2.0, this.legend.getMarkerSize().width * (double)context.Options.zoom, this.legend.getMarkerSize().height * (double)context.Options.zoom);
            if (this.legend.getMarkerAlignment() == StiMarkerAlignment.Right) {
                markerRect.x = this.getClientRectangle().getRight() - markerRect.width;
            }
            IStiLegendMarker legendMarker = StiMarkerLegendFactory.CreateMarker(this.getItem().getSeries());
            legendMarker.Draw(context, this.getItem().getSeries(), markerRect, this.getColorIndex(), this.getLegendItemsCount(), this.legendItemIndex);
            if (this.legend.getMarkerAlignment() == StiMarkerAlignment.Left) {
                textRect.x += this.legend.getMarkerSize().width * (double)context.Options.zoom;
            }
            textRect.width -= this.legend.getMarkerSize().width * (double)context.Options.zoom;
        }
        textRect.x += 8.0;
        textRect.width += 4.0;
        StiSolidBrush brush = new StiSolidBrush(this.getLegend().getLabelsColor());
        StiFontGeom newFont = StiFontGeom.ChangeFontSize((StiFont)this.getLegend().getFont(), (double)(this.getLegend().getFont().size * (double)context.Options.zoom));
        StiStringFormatGeom sf = context.GetDefaultStringFormat();
        sf.setAlignment(StiStringAlignment.Near);
        sf.setLineAlignment(StiStringAlignment.Center);
        sf.setFormatFlags(StiEnumSet.of((Enum)StiStringFormatFlags.None));
        if (this.legend.getMarkerAlignment() == StiMarkerAlignment.Right) {
            sf.setFormatFlags(StiEnumSet.of((Enum)StiStringFormatFlags.NoWrap));
        }
        context.DrawString(this.getItem().getText(), newFont, (Object)brush, textRect, sf, this.legendItemIndex);
    }

    public StiLegendItemGeom(IStiLegend legend, StiLegendItemCoreXF item, StiRectangle clientRectangle, int colorIndex, int legendItemsCount, int legendItemIndex) {
        super(clientRectangle);
        this.legend = legend;
        this.item = item;
        this.colorIndex = colorIndex;
        this.legendItemsCount = legendItemsCount;
        this.legendItemIndex = legendItemIndex;
    }
}

