/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.report.chart.geoms.marker;

import com.stimulsoft.base.context.chart.StiContext;
import com.stimulsoft.base.context.chart.geoms.StiPenGeom;
import com.stimulsoft.base.drawing.StiColor;
import com.stimulsoft.base.drawing.StiColorEnum;
import com.stimulsoft.base.drawing.StiColorUtils;
import com.stimulsoft.base.drawing.enums.StiPenStyle;
import com.stimulsoft.base.system.geometry.StiPoint;
import com.stimulsoft.base.system.geometry.StiRectangle;
import com.stimulsoft.report.chart.interfaces.legend.IStiLegendMarker;
import com.stimulsoft.report.chart.interfaces.marker.IStiLineMarker;
import com.stimulsoft.report.chart.interfaces.marker.IStiMarker;
import com.stimulsoft.report.chart.interfaces.series.IStiSeries;
import com.stimulsoft.report.chart.interfaces.series.clusteredColumn.IStiBaseLineSeries;
import com.stimulsoft.report.chart.interfaces.series.radar.IStiRadarLineSeries;
import com.stimulsoft.report.chart.interfaces.series.radar.IStiRadarSeries;
import com.stimulsoft.report.chart.interfaces.series.scatter.IStiScatterLineSeries;
import com.stimulsoft.report.chart.interfaces.series.scatter.IStiScatterSeries;
import com.stimulsoft.report.chart.interfaces.series.stackedColumn.IStiStackedBaseLineSeries;

public class StiLegendLineMarker
implements IStiLegendMarker {
    @Override
    public void Draw(StiContext context, IStiSeries serie, StiRectangle rect, int colorIndex, int colorCount, int elementIndex) {
        int index;
        int i;
        IStiScatterLineSeries scatterLineSeries;
        IStiScatterSeries scatterSeries;
        IStiStackedBaseLineSeries stackedLineSeries;
        IStiBaseLineSeries lineSeries;
        IStiRadarLineSeries radarLineSeries;
        IStiRadarSeries radarSeries;
        IStiSeries series = serie;
        IStiMarker marker = null;
        IStiLineMarker lineMarker = null;
        StiPenStyle lineStyle = StiPenStyle.Solid;
        float lineWidth = 1.0f;
        StiColor lineColor = StiColorEnum.Black.color();
        boolean lighting = false;
        IStiRadarSeries iStiRadarSeries = radarSeries = serie instanceof IStiRadarSeries ? (IStiRadarSeries)serie : null;
        if (radarSeries != null) {
            marker = radarSeries.getMarker();
            lineWidth = 0.0f;
            lineColor = StiColorEnum.Transparent.color();
        }
        IStiRadarLineSeries iStiRadarLineSeries = radarLineSeries = serie instanceof IStiRadarLineSeries ? (IStiRadarLineSeries)serie : null;
        if (radarLineSeries != null) {
            lineColor = radarLineSeries.getLineColor().clone();
            lineStyle = radarLineSeries.getLineStyle();
            lineWidth = radarLineSeries.getLineWidth();
            lighting = radarLineSeries.getLighting();
        }
        IStiBaseLineSeries iStiBaseLineSeries = lineSeries = serie instanceof IStiBaseLineSeries ? (IStiBaseLineSeries)serie : null;
        if (lineSeries != null) {
            marker = lineSeries.getMarker();
            lineStyle = lineSeries.getLineStyle();
            lineMarker = lineSeries.getLineMarker();
            lineWidth = lineSeries.getLineWidth();
            lineColor = lineSeries.getLineColor().clone();
            lighting = lineSeries.getLighting();
        }
        IStiStackedBaseLineSeries iStiStackedBaseLineSeries = stackedLineSeries = serie instanceof IStiStackedBaseLineSeries ? (IStiStackedBaseLineSeries)serie : null;
        if (stackedLineSeries != null) {
            marker = stackedLineSeries.getMarker();
            lineStyle = stackedLineSeries.getLineStyle();
            lineMarker = stackedLineSeries.getLineMarker();
            lineWidth = stackedLineSeries.getLineWidth();
            lineColor = stackedLineSeries.getLineColor().clone();
            lighting = stackedLineSeries.getLighting();
        }
        IStiScatterSeries iStiScatterSeries = scatterSeries = serie instanceof IStiScatterSeries ? (IStiScatterSeries)serie : null;
        if (scatterSeries != null) {
            marker = scatterSeries.getMarker();
            lineWidth = 0.0f;
            lineColor = StiColorEnum.Transparent.color();
        }
        IStiScatterLineSeries iStiScatterLineSeries = scatterLineSeries = serie instanceof IStiScatterLineSeries ? (IStiScatterLineSeries)serie : null;
        if (scatterLineSeries != null) {
            lineColor = scatterLineSeries.getLineColor().clone();
            lineStyle = scatterLineSeries.getLineStyle();
            lineWidth = scatterLineSeries.getLineWidth();
            lighting = scatterLineSeries.getLighting();
        }
        float chartZoom = context.Options.zoom;
        double realWidth = (float)rect.width / chartZoom;
        StiPoint center = new StiPoint(rect.x + (rect.width - 1.0) / 2.0, rect.y + (rect.height - 1.0) / 2.0);
        StiPoint[] points = new StiPoint[]{new StiPoint(rect.x, center.y), new StiPoint(rect.getRight(), center.y)};
        context.PushSmoothingModeToAntiAlias();
        StiPenStyle dashStyle = lineStyle;
        float scaledLineWidth = lineWidth;
        StiPenGeom pen = new StiPenGeom((Object)lineColor, scaledLineWidth);
        pen.setPenStyle(dashStyle);
        if (serie.getShowShadow() && lineWidth > 0.0f) {
            StiPenGeom penShadow = new StiPenGeom((Object)StiColor.fromArgb((int)35, (int)0, (int)0, (int)0), scaledLineWidth + 0.3f * chartZoom);
            penShadow.setPenStyle(dashStyle);
            StiPoint[] shadowPoints = new StiPoint[points.length];
            for (i = 0; i < points.length; ++i) {
                shadowPoints[i] = points[i].clone();
            }
            for (index = 0; index < shadowPoints.length; ++index) {
                shadowPoints[index].x += (double)scaledLineWidth;
                shadowPoints[index].y += (double)scaledLineWidth;
                shadowPoints[index].x = Math.min(shadowPoints[index].x, rect.getRight());
            }
            context.DrawLines(penShadow, shadowPoints, true);
        }
        context.DrawLines(pen, points, true);
        if (scaledLineWidth >= 2.0f && lighting) {
            float step = 0.5f * chartZoom;
            StiPoint[] lightPoints = new StiPoint[points.length];
            for (i = 0; i < points.length; ++i) {
                lightPoints[i] = points[i].clone();
            }
            for (index = 0; index < lightPoints.length; ++index) {
                lightPoints[index].x -= (double)step;
                lightPoints[index].y -= (double)step;
                lightPoints[index].x = Math.max(lightPoints[index].x, rect.getLeft());
            }
            StiPenGeom penLight = new StiPenGeom((Object)StiColorUtils.light((StiColor)lineColor, (int)70), scaledLineWidth);
            penLight.setPenStyle(dashStyle);
            context.DrawLines(penLight, lightPoints, true);
        }
        if (lineMarker != null && lineMarker.getVisible() && lineMarker.getShowInLegend()) {
            StiPoint pointLeft = new StiPoint(rect.x + rect.width / 4.0, center.y);
            StiPoint pointRight = new StiPoint(rect.x + rect.width - rect.width / 4.0, center.y);
            StiPenGeom borderPen = new StiPenGeom((Object)lineMarker.getBorderColor().clone());
            lineMarker.getCore().DrawPoint(context, pointLeft.x, pointLeft.y, chartZoom, lineMarker.getBrush(), borderPen, lineMarker.getType(), lineMarker.getSize(), lineMarker.getAngle(), false, false, "", null, null);
            lineMarker.getCore().DrawPoint(context, pointRight.x, pointRight.y, chartZoom, lineMarker.getBrush(), borderPen, lineMarker.getType(), lineMarker.getSize(), lineMarker.getAngle(), false, false, "", null, null);
        }
        if (marker != null && marker.getShowInLegend()) {
            marker.getCore().DrawMarkers(context, new StiPoint[]{center}, serie.getShowShadow());
        }
        context.PopSmoothingMode();
        Object color = series.getCore().GetSeriesBorderColor(colorIndex, colorCount);
        if (color != null && serie.getChart() != null && serie.getChart().getLegend().getMarkerBorder()) {
            StiPenGeom pen3 = new StiPenGeom(color);
            context.DrawRectangle(pen3, rect.x, rect.y, rect.width, rect.height);
        }
    }
}

