/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.report.chart.geoms.radarAxis;

import com.stimulsoft.base.IStiEnum;
import com.stimulsoft.base.context.chart.StiContext;
import com.stimulsoft.base.context.chart.geoms.StiFontGeom;
import com.stimulsoft.base.context.chart.geoms.StiPenGeom;
import com.stimulsoft.base.context.chart.geoms.StiStringFormatGeom;
import com.stimulsoft.base.drawing.StiBrush;
import com.stimulsoft.base.drawing.StiColor;
import com.stimulsoft.base.drawing.enums.StiRotationMode;
import com.stimulsoft.base.drawing.enums.StiStringFormatFlags;
import com.stimulsoft.base.drawing.enums.StiStringTrimming;
import com.stimulsoft.base.system.StiFont;
import com.stimulsoft.base.system.geometry.StiPoint;
import com.stimulsoft.base.system.geometry.StiRectangle;
import com.stimulsoft.report.chart.geoms.StiCellGeom;
import com.stimulsoft.report.chart.interfaces.radarAxis.IStiXRadarAxis;

public class StiXRadarAxisLabelGeom
extends StiCellGeom {
    private final StiColor borderColor;
    private final StiBrush labelBrush;
    private final String text;
    private final float angle;
    private final StiPoint point;
    private final StiRectangle labelRect;
    private final IStiXRadarAxis axis;

    public final StiColor getBorderColor() {
        return this.borderColor;
    }

    public final StiBrush getLabelBrush() {
        return this.labelBrush;
    }

    public final String getText() {
        return this.text;
    }

    public final float getAngle() {
        return this.angle;
    }

    public final StiPoint getPoint() {
        return this.point;
    }

    public final StiRectangle getLabelRect() {
        return this.labelRect;
    }

    public final IStiXRadarAxis getAxis() {
        return this.axis;
    }

    @Override
    public void Draw(StiContext context) {
        StiRectangle rect = StiRectangle.round((StiRectangle)this.getClientRectangle());
        StiPenGeom borderPen = new StiPenGeom((Object)this.getBorderColor());
        StiFontGeom font = StiFontGeom.ChangeFontSize((StiFont)this.getAxis().getLabels().getFont(), (float)((float)(this.getAxis().getLabels().getFont().getSize() * (double)context.Options.zoom)));
        StiStringFormatGeom sf = context.GetGenericStringFormat();
        sf.setTrimming(StiStringTrimming.None);
        sf.getFormatFlags().OR((IStiEnum)StiStringFormatFlags.MeasureTrailingSpaces);
        sf.getFormatFlags().OR((IStiEnum)StiStringFormatFlags.NoWrap);
        if (this.getAxis().getLabels().getAntialiasing()) {
            context.PushSmoothingModeToAntiAlias();
        }
        int distX = (int)((double)Math.round((this.labelRect.x + this.labelRect.width / 2.0) * Math.pow(10.0, 0.0)) / Math.pow(10.0, 0.0));
        int distY = (int)((double)Math.round((this.labelRect.y + this.labelRect.height / 2.0) * Math.pow(10.0, 0.0)) / Math.pow(10.0, 0.0));
        context.PushTranslateTransform((double)distX, (double)distY);
        context.PushRotateTransform(this.getAngle());
        if (!rect.isEmpty().booleanValue()) {
            context.FillRectangle((Object)this.getAxis().getLabels().getBrush(), rect, null);
            if (this.getAxis().getLabels().getDrawBorder()) {
                context.DrawRectangle(borderPen, rect.x, rect.y, rect.width, rect.height);
            }
        }
        context.PopTransform();
        context.PopTransform();
        if (this.getAxis().getLabels().getAntialiasing()) {
            context.PopSmoothingMode();
        }
        StiRotationMode mode = StiRotationMode.CenterBottom;
        float textAngle = this.getAngle();
        if (this.getAngle() >= 90.0f && this.getAngle() <= 270.0f) {
            textAngle = this.getAngle() + 180.0f;
            mode = StiRotationMode.CenterTop;
        }
        if (!this.getAxis().getLabels().getRotationLabels()) {
            if (this.getAngle() > 0.0f && this.getAngle() < 180.0f) {
                mode = StiRotationMode.LeftCenter;
            } else if (this.getAngle() < 360.0f && this.getAngle() > 180.0f) {
                mode = StiRotationMode.RightCenter;
            } else if (this.getAngle() == 0.0f) {
                mode = StiRotationMode.CenterBottom;
            } else if (this.getAngle() == 180.0f) {
                mode = StiRotationMode.CenterTop;
            }
            textAngle = 0.0f;
        }
        context.DrawRotatedString(this.getText(), font, (Object)this.labelBrush, this.point, sf, mode, textAngle, this.getAxis().getLabels().getAntialiasing());
    }

    public StiXRadarAxisLabelGeom(IStiXRadarAxis axis, String text, StiBrush labelBrush, StiColor borderColor, float angle, StiRectangle clientRectangle, StiRectangle labelRect, StiPoint point) {
        super(clientRectangle);
        this.axis = axis;
        this.labelRect = labelRect;
        this.text = text;
        this.angle = angle;
        this.point = point;
        this.labelBrush = labelBrush;
        this.borderColor = borderColor;
    }
}

