/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.report.chart.geoms.series.stackedColumn;

import com.stimulsoft.base.context.chart.StiContext;
import com.stimulsoft.base.context.chart.animation.StiAnimation;
import com.stimulsoft.base.context.chart.animation.StiOpacityAnimation;
import com.stimulsoft.base.context.chart.geoms.StiPenGeom;
import com.stimulsoft.base.drawing.StiBrush;
import com.stimulsoft.base.drawing.StiColor;
import com.stimulsoft.base.system.geometry.StiPoint;
import com.stimulsoft.base.system.geometry.StiRectangle;
import com.stimulsoft.report.chart.StiChart;
import com.stimulsoft.report.chart.StiChartHelper;
import com.stimulsoft.report.chart.geoms.areas.StiAreaGeom;
import com.stimulsoft.report.chart.geoms.series.StiMouseOverHelper;
import com.stimulsoft.report.chart.geoms.series.StiSeriesElementGeom;
import com.stimulsoft.report.chart.interfaces.series.IStiSeries;

public class StiStackedColumnSeriesElementGeom
extends StiSeriesElementGeom {
    private StiBrush seriesBrush;
    private StiColor seriesBorderColor;
    private Integer beginTime;

    public final StiBrush getSeriesBrush() {
        return this.seriesBrush;
    }

    public final StiColor getSeriesBorderColor() {
        return this.seriesBorderColor;
    }

    @Override
    public void Draw(StiContext context) {
        StiRectangle columnRect = this.getClientRectangle();
        StiPenGeom pen = new StiPenGeom((Object)this.getSeriesBorderColor(), 1.0f);
        StiChart chart = (StiChart)this.getSeries().getChart();
        if (chart.isAnimation) {
            Double valueOld = this.getSeries().getValuesStart().length > this.getIndex() ? this.getSeries().getValuesStart()[this.getIndex()] : 0.0;
            if (this.getSeries().getShowShadow()) {
                StiOpacityAnimation animationOpacityShadow = new StiOpacityAnimation(StiChartHelper.GlobalDurationElement, Integer.valueOf(this.beginTime + StiChartHelper.GlobalDurationElement));
                context.DrawShadowRect(columnRect, 5, (StiAnimation)animationOpacityShadow);
            }
            StiOpacityAnimation animationOpacity = new StiOpacityAnimation(StiChartHelper.GlobalDurationElement, this.beginTime);
            context.DrawAnimationColumn((Object)this.seriesBrush, pen, (Object)columnRect, Double.valueOf(this.getValue()), this.GetToolTip(), (Object)this, (StiAnimation)animationOpacity, this.getInteractionData());
        } else {
            this.getSeries().getChart().getStyle().getCore().FillColumn(context, columnRect, this.seriesBrush, this.getInteractionData());
            if (this.getIsMouseOver() || this.getSeries().getCore().getIsMouseOver()) {
                context.FillRectangle((Object)StiMouseOverHelper.GetMouseOverColor(), columnRect.x, columnRect.y, columnRect.width, columnRect.height, null);
            }
            StiPoint[] points = null;
            points = this.getValue() > 0.0 ? new StiPoint[]{new StiPoint(columnRect.x, columnRect.getBottom()), new StiPoint(columnRect.x, columnRect.y), new StiPoint(columnRect.getRight(), columnRect.y), new StiPoint(columnRect.getRight(), columnRect.getBottom())} : new StiPoint[]{new StiPoint(columnRect.x, columnRect.y), new StiPoint(columnRect.x, columnRect.getBottom()), new StiPoint(columnRect.getRight(), columnRect.getBottom()), new StiPoint(columnRect.getRight(), columnRect.y)};
            context.DrawLines(pen, points);
        }
    }

    public StiStackedColumnSeriesElementGeom(StiAreaGeom areaGeom, double value, int index, StiBrush seriesBrush, StiColor seriesBorderColor, IStiSeries series, StiRectangle clientRectangle, Integer beginTime) {
        super(areaGeom, value, index, series, clientRectangle);
        this.seriesBrush = seriesBrush;
        this.seriesBorderColor = seriesBorderColor;
        this.beginTime = beginTime;
    }
}

