/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.report.chart.geoms.seriesLabels;

import com.stimulsoft.base.context.chart.StiContext;
import com.stimulsoft.base.context.chart.animation.StiAnimation;
import com.stimulsoft.base.context.chart.animation.StiOpacityAnimation;
import com.stimulsoft.base.context.chart.geoms.StiPenGeom;
import com.stimulsoft.base.drawing.StiBrush;
import com.stimulsoft.base.drawing.StiColor;
import com.stimulsoft.base.drawing.StiColorEnum;
import com.stimulsoft.base.system.geometry.StiRectangle;
import com.stimulsoft.report.chart.StiChart;
import com.stimulsoft.report.chart.StiChartHelper;
import com.stimulsoft.report.chart.StiInteractionOptions;
import com.stimulsoft.report.chart.enums.StiMarkerAlignment;
import com.stimulsoft.report.chart.geoms.StiCellGeom;
import com.stimulsoft.report.chart.interfaces.areas.IStiAxisArea;
import com.stimulsoft.report.chart.interfaces.series.IStiSeries;
import com.stimulsoft.report.chart.interfaces.series.clusteredBar.IStiClusteredBarSeries;
import com.stimulsoft.report.chart.interfaces.series.fullStackedBar.IStiFullStackedBarSeries;
import com.stimulsoft.report.chart.interfaces.series.stackedBar.IStiStackedBarSeries;
import com.stimulsoft.report.chart.interfaces.seriesLabels.IStiSeriesLabels;

public class StiSeriesLabelsGeom
extends StiCellGeom {
    private Integer beginTime = 0;
    private Integer duration = 0;
    private final double value;
    private final int index;
    private final IStiSeries series;
    private final IStiSeriesLabels seriesLabels;

    public Integer getBeginTime() {
        return this.beginTime;
    }

    public void setBeginTime(Integer beginTime) {
        this.beginTime = beginTime;
    }

    public Integer getDuration() {
        return this.duration;
    }

    public void setDuration(Integer duration) {
        this.duration = duration;
    }

    @Override
    public void InvokeMouseEnter(StiInteractionOptions options) {
        if (!this.getAllowMouseOver()) {
            return;
        }
        if (!this.getIsMouseOver()) {
            this.setIsMouseOver(true);
            options.setUpdateContext(true);
        }
    }

    @Override
    public void InvokeMouseLeave(StiInteractionOptions options) {
        if (!this.getAllowMouseOver()) {
            return;
        }
        if (this.getIsMouseOver()) {
            this.setIsMouseOver(false);
            options.setUpdateContext(true);
        }
    }

    private int GetValueIndex() {
        int valueIndex = this.getIndex();
        if (this.getSeries() instanceof IStiClusteredBarSeries || this.getSeries() instanceof IStiStackedBarSeries || this.getSeries() instanceof IStiFullStackedBarSeries) {
            if (this.getSeries().getChart().getArea() instanceof IStiAxisArea && !((IStiAxisArea)this.getSeries().getChart().getArea()).getReverseVert()) {
                valueIndex = this.getSeries().getValues().length - valueIndex - 1;
            }
        } else if (this.getSeries().getChart().getArea() instanceof IStiAxisArea && ((IStiAxisArea)this.getSeries().getChart().getArea()).getReverseHor()) {
            valueIndex = this.getSeries().getValues().length - valueIndex - 1;
        }
        return valueIndex;
    }

    private String GetHyperlink(int valueIndex) {
        if (this.getSeries().getHyperlinks() != null && valueIndex < this.getSeries().getHyperlinks().length) {
            return this.series.getHyperlinks()[valueIndex];
        }
        return null;
    }

    private String GetToolTip(int valueIndex) {
        if (this.getSeries().getToolTips() != null && valueIndex < this.getSeries().getToolTips().length) {
            return this.series.getHyperlinks()[valueIndex];
        }
        return null;
    }

    public boolean getAllowMouseOver() {
        return this.GetHyperlink(this.GetValueIndex()) != null || this.getSeries().getInteraction().getDrillDownEnabled();
    }

    public boolean getIsMouseOver() {
        if (this.getSeries() == null) {
            return false;
        }
        return this.getSeries().getCore().GetIsMouseOverSeriesElement(this.getIndex());
    }

    public void setIsMouseOver(boolean value) {
        if (this.getSeries() != null) {
            this.getSeries().getCore().SetIsMouseOverSeriesElement(this.getIndex(), value);
        }
    }

    public final double getValue() {
        return this.value;
    }

    public final int getIndex() {
        return this.index;
    }

    public final IStiSeries getSeries() {
        return this.series;
    }

    public final IStiSeriesLabels getSeriesLabels() {
        return this.seriesLabels;
    }

    protected void DrawMarker(StiContext context, StiRectangle itemRect, Object markerColor, StiBrush markerBrush) {
        if (this.getSeriesLabels().getMarkerVisible()) {
            StiChart chart = (StiChart)this.series.getChart();
            StiRectangle markerRect = StiRectangle.getEmpty();
            markerRect.x = this.getSeriesLabels().getMarkerAlignment() == StiMarkerAlignment.Right ? (double)((int)(itemRect.getRight() + (double)(2 * context.Options.zoom))) : (double)((int)(itemRect.getLeft() - (2.0 + this.getSeriesLabels().getMarkerSize().width) * (double)context.Options.zoom));
            markerRect.y = (int)(itemRect.y + (itemRect.height - this.getSeriesLabels().getMarkerSize().height * (double)context.Options.zoom) / 2.0);
            markerRect.width = this.getSeriesLabels().getMarkerSize().width * (double)context.Options.zoom;
            markerRect.height = this.getSeriesLabels().getMarkerSize().height * (double)context.Options.zoom;
            StiColor color = markerColor instanceof StiColor ? (StiColor)markerColor : StiColorEnum.Black.color();
            StiPenGeom pen = new StiPenGeom((Object)color, 1.0f);
            if (chart.isAnimation) {
                StiOpacityAnimation animation = new StiOpacityAnimation(StiChartHelper.GlobalBeginTimeElement, StiChartHelper.GlobalBeginTimeElement);
                context.DrawAnimationRectangle((Object)markerBrush, pen, markerRect, (StiAnimation)animation, null, this.getToolTip(this.getValueIndex()));
            } else {
                context.FillRectangle((Object)markerBrush, markerRect.x, markerRect.y, markerRect.width, markerRect.height, null);
                context.DrawRectangle(pen, markerRect.x, markerRect.y, markerRect.width, markerRect.height);
            }
        }
    }

    private String getToolTip(int valueIndex) {
        if (this.series.getToolTips() != null && valueIndex < this.series.getToolTips().length) {
            return this.series.getHyperlinks()[valueIndex];
        }
        return null;
    }

    private int getValueIndex() {
        int valueIndex = this.getIndex();
        if (this.series instanceof IStiClusteredBarSeries || this.series instanceof IStiStackedBarSeries || this.series instanceof IStiFullStackedBarSeries) {
            if (this.series.getChart().getArea() instanceof IStiAxisArea && !((IStiAxisArea)this.series.getChart().getArea()).getReverseVert()) {
                valueIndex = this.series.getValues().length - valueIndex - 1;
            }
        } else if (this.series.getChart().getArea() instanceof IStiAxisArea && ((IStiAxisArea)this.series.getChart().getArea()).getReverseHor()) {
            valueIndex = this.series.getValues().length - valueIndex - 1;
        }
        return valueIndex;
    }

    @Override
    public void Draw(StiContext context) {
    }

    public StiSeriesLabelsGeom(IStiSeriesLabels seriesLabels, IStiSeries series, int index, double value, StiRectangle clientRectangle) {
        super(StiRectangle.round((StiRectangle)clientRectangle));
        this.seriesLabels = seriesLabels;
        this.series = series;
        this.index = index;
        this.value = value;
    }
}

