/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.report.chart.geoms.seriesLabels.pie;

import com.stimulsoft.base.IStiEnum;
import com.stimulsoft.base.context.chart.StiContext;
import com.stimulsoft.base.context.chart.geoms.StiFontGeom;
import com.stimulsoft.base.context.chart.geoms.StiPenGeom;
import com.stimulsoft.base.context.chart.geoms.StiStringFormatGeom;
import com.stimulsoft.base.drawing.StiBrush;
import com.stimulsoft.base.drawing.StiColor;
import com.stimulsoft.base.drawing.enums.StiRotationMode;
import com.stimulsoft.base.drawing.enums.StiStringAlignment;
import com.stimulsoft.base.drawing.enums.StiStringFormatFlags;
import com.stimulsoft.base.drawing.enums.StiStringTrimming;
import com.stimulsoft.base.system.StiFont;
import com.stimulsoft.base.system.geometry.StiPoint;
import com.stimulsoft.base.system.geometry.StiRectangle;
import com.stimulsoft.report.chart.geoms.series.StiMouseOverHelper;
import com.stimulsoft.report.chart.geoms.seriesLabels.StiSeriesLabelsGeom;
import com.stimulsoft.report.chart.interfaces.series.IStiSeries;
import com.stimulsoft.report.chart.interfaces.seriesLabels.IStiSeriesLabels;
import com.stimulsoft.report.chart.interfaces.seriesLabels.pie.IStiOutsidePieLabels;

public class StiTwoColumnsPieLabelsGeom
extends StiSeriesLabelsGeom {
    private final StiBrush seriesBrush;
    private final StiColor borderColor;
    private final StiColor seriesBorderColor;
    private final StiBrush labelBrush;
    private final String text;
    private final StiRectangle labelRect;
    private final StiColor lineColor;
    private StiPoint startPoint;
    private StiPoint endPoint;
    private final StiPoint arcPoint;
    private StiBrush seriesLabelsBrush;

    public final StiBrush getSeriesBrush() {
        return this.seriesBrush;
    }

    public final StiColor getBorderColor() {
        return this.borderColor;
    }

    public final StiColor getSeriesBorderColor() {
        return this.seriesBorderColor;
    }

    public final StiBrush getLabelBrush() {
        return this.labelBrush;
    }

    public final String getText() {
        return this.text;
    }

    public final StiRectangle getLabelRect() {
        return this.labelRect;
    }

    public final StiColor getLineColor() {
        return this.lineColor;
    }

    public StiPoint getStartPoint() {
        return this.startPoint;
    }

    public StiPoint getEndPoint() {
        return this.endPoint;
    }

    public void setEndPoint(StiPoint endPoint) {
        this.endPoint = endPoint;
    }

    public void setSeriesLabelsBrush(StiBrush seriesLabelsBrush) {
        this.seriesLabelsBrush = seriesLabelsBrush;
    }

    public final StiPoint getArcPoint() {
        return this.arcPoint;
    }

    public StiBrush getSeriesLabelsBrush() {
        return this.seriesLabelsBrush;
    }

    @Override
    public void Draw(StiContext context) {
        StiRectangle labelRect = StiRectangle.round((StiRectangle)this.getClientRectangle());
        IStiSeriesLabels tempVar = this.getSeriesLabels();
        IStiOutsidePieLabels outsidePieLabels = (IStiOutsidePieLabels)(tempVar instanceof IStiOutsidePieLabels ? tempVar : null);
        StiPenGeom borderPen = new StiPenGeom((Object)this.getBorderColor(), 1.0f);
        StiFontGeom font = StiFontGeom.ChangeFontSize((StiFont)this.getSeriesLabels().getFont(), (float)((float)(this.getSeriesLabels().getFont().size * (double)context.Options.zoom)));
        StiStringFormatGeom sf = context.GetGenericStringFormat();
        if (this.getSeriesLabels().getDrawBorder()) {
            StiPenGeom linePen = new StiPenGeom((Object)this.getLineColor(), 1.0f);
            context.DrawLines(linePen, new StiPoint[]{this.endPoint, this.startPoint, this.arcPoint});
        }
        this.DrawMarker(context, StiRectangle.round((StiRectangle)labelRect), this.getSeriesBorderColor(), this.getSeriesBrush());
        if (!(Double.isNaN(labelRect.getX()) || Double.isNaN(labelRect.getY()) || Double.isNaN(labelRect.getWidth()) || Double.isNaN(labelRect.getHeight()))) {
            context.FillRectangle((Object)this.getSeriesLabelsBrush(), labelRect, null);
            if (this.getSeriesLabels().getDrawBorder()) {
                context.DrawRectangle(borderPen, labelRect.getX(), labelRect.getY(), labelRect.getWidth(), labelRect.getHeight());
            }
        }
        sf.setAlignment(StiStringAlignment.Center);
        sf.setLineAlignment(StiStringAlignment.Center);
        sf.setTrimming(StiStringTrimming.None);
        sf.getFormatFlags().OR((IStiEnum)StiStringFormatFlags.MeasureTrailingSpaces);
        sf.getFormatFlags().OR((IStiEnum)StiStringFormatFlags.NoWrap);
        context.DrawRotatedString(this.getText(), font, (Object)this.labelBrush, labelRect, sf, StiRotationMode.CenterCenter, 0.0f, this.getSeriesLabels().getAntialiasing());
        if (this.getIsMouseOver()) {
            context.FillRectangle((Object)StiMouseOverHelper.GetLineMouseOverColor(), labelRect, null);
        }
    }

    public StiTwoColumnsPieLabelsGeom(IStiSeriesLabels seriesLabels, IStiSeries series, int index, double value, StiRectangle clientRectangle, String text, StiBrush seriesBrush, StiBrush labelBrush, StiBrush seriesLabelsBrush, StiColor borderColor, StiColor seriesBorderColor, StiRectangle labelRect, StiColor lineColor, StiPoint startPoint, StiPoint endPoint, StiPoint arcPoint) {
        super(seriesLabels, series, index, value, clientRectangle);
        this.text = text;
        this.labelBrush = labelBrush;
        this.lineColor = lineColor;
        this.borderColor = borderColor;
        this.seriesBorderColor = seriesBorderColor;
        this.seriesBrush = seriesBrush;
        this.labelRect = labelRect;
        this.startPoint = startPoint.clone();
        this.endPoint = endPoint.clone();
        this.arcPoint = arcPoint.clone();
        this.seriesLabelsBrush = seriesLabelsBrush;
    }
}

