/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.report.chart.geoms.table;

import com.stimulsoft.base.context.chart.StiContext;
import com.stimulsoft.base.context.chart.geoms.StiFontGeom;
import com.stimulsoft.base.context.chart.geoms.StiPenGeom;
import com.stimulsoft.base.context.chart.geoms.StiStringFormatGeom;
import com.stimulsoft.base.drawing.StiBrush;
import com.stimulsoft.base.drawing.StiSolidBrush;
import com.stimulsoft.base.drawing.enums.StiStringAlignment;
import com.stimulsoft.base.system.StiFont;
import com.stimulsoft.base.system.geometry.StiRectangle;
import com.stimulsoft.report.chart.geoms.StiCellGeom;
import com.stimulsoft.report.chart.geoms.marker.StiMarkerLegendFactory;
import com.stimulsoft.report.chart.interfaces.legend.IStiLegendMarker;
import com.stimulsoft.report.chart.interfaces.series.IStiSeries;
import com.stimulsoft.report.chart.interfaces.table.IStiChartTable;
import com.stimulsoft.report.chart.view.areas.StiAxisArea;
import java.util.ArrayList;
import java.util.List;

public class StiChartTableGeom
extends StiCellGeom {
    private String[][] table;
    private double widthCellLegendTableChart;
    private IStiChartTable chartTable;
    private StiPenGeom pen;
    private StiFontGeom font;
    private StiBrush labelBrush;
    private StiStringFormatGeom sf;

    @Override
    public void Draw(StiContext context) {
        this.font = StiFontGeom.ChangeFontSize((StiFont)this.chartTable.getFont(), (double)(this.chartTable.getFont().getSize() * (double)context.Options.zoom));
        this.sf = context.GetDefaultStringFormat();
        this.sf.setAlignment(StiStringAlignment.Center);
        this.sf.setLineAlignment(StiStringAlignment.Center);
        StiRectangle rect = this.getClientRectangle();
        int rowCount = this.table.length;
        int columnCount = this.table[0].length;
        double cellWidth = (rect.width - this.widthCellLegendTableChart) / (double)columnCount;
        double cellHeight = rect.height / (double)rowCount;
        StiAxisArea area = (StiAxisArea)this.chartTable.getChart().getArea();
        double xTA = area.getReverseHor() ? rect.x : rect.x + this.widthCellLegendTableChart;
        double yTA = rect.y;
        double widthTA = rect.width - this.widthCellLegendTableChart;
        double heightTA = cellHeight;
        StiRectangle rectTitleArgument = new StiRectangle(xTA, yTA, widthTA, heightTA);
        ArrayList<String> listArgument = new ArrayList<String>();
        for (int index = 1; index < this.table[0].length; ++index) {
            listArgument.add(this.table[0][index]);
        }
        this.DrawTitleArgument(context, rectTitleArgument, listArgument, area.getXAxis().getStartFromZero());
        double xTL = area.getReverseHor() ? rect.getRight() - this.widthCellLegendTableChart : rect.x;
        double yTL = rect.y + cellHeight;
        double widthTL = this.widthCellLegendTableChart;
        double heightTL = rect.height - cellHeight;
        StiRectangle rectTitleLegend = new StiRectangle(xTL, yTL, widthTL, heightTL);
        ArrayList<String> listTitleLegend = new ArrayList<String>();
        for (int index = 1; index < this.table.length; ++index) {
            listTitleLegend.add(this.table[index][0]);
        }
        this.DrawTitleLegend(context, rectTitleLegend, listTitleLegend);
        double xRT = area.getReverseHor() ? rect.x : rect.x + this.widthCellLegendTableChart;
        double yRT = rect.y + cellHeight;
        double widthRT = rect.width - this.widthCellLegendTableChart;
        double heightRT = rect.height - cellHeight;
        StiRectangle rectRootTable = new StiRectangle(xRT, yRT, widthRT, heightRT);
        this.DrawRootTable(context, rectRootTable, area.getXAxis().getStartFromZero());
    }

    private void DrawTitleArgument(StiContext context, StiRectangle rect, List<String> listArgument, boolean startFromZero) {
        if (this.chartTable.isGridOutline()) {
            context.DrawRectangle(this.pen, rect.x, rect.y, rect.width, rect.height);
        }
        int count = startFromZero ? listArgument.size() + 1 : listArgument.size() - 1;
        double cellWidth = rect.width / (double)count;
        for (int indexColumn = 0; indexColumn < listArgument.size(); ++indexColumn) {
            double deltaX;
            double deltaWidth = 0.0;
            if (indexColumn == 0 || indexColumn == listArgument.size() - 1) {
                deltaWidth = startFromZero ? cellWidth / 2.0 : -cellWidth / 2.0;
            }
            double d = deltaX = startFromZero ? cellWidth / 2.0 : -cellWidth / 2.0;
            if (indexColumn == 0) {
                deltaX = 0.0;
            }
            StiRectangle rectangle = new StiRectangle(rect.x + (double)indexColumn * cellWidth + deltaX, rect.y, cellWidth + deltaWidth, rect.height);
            context.DrawString(listArgument.get(indexColumn), this.font, (Object)this.labelBrush, StiRectangle.round((StiRectangle)rectangle), this.sf);
            if (!this.chartTable.isGridLinesVert() || indexColumn == listArgument.size() - 1) continue;
            double x = startFromZero ? rect.x + (double)(indexColumn + 1) * cellWidth + cellWidth / 2.0 : rect.x + (double)(indexColumn + 1) * cellWidth - cellWidth / 2.0;
            context.DrawLine(this.pen, x, rect.y, x, rect.getBottom());
        }
    }

    private void DrawTitleLegend(StiContext context, StiRectangle rect, List<String> list) {
        if (this.chartTable.isGridOutline()) {
            context.DrawRectangle(this.pen, rect.x, rect.y, rect.width, rect.height);
        }
        double cellHeight = rect.height / (double)list.size();
        for (int indexRow = 0; indexRow < list.size(); ++indexRow) {
            double x = rect.x;
            double y = rect.y;
            double width = rect.width;
            if (this.chartTable.isGridLinesHor() && indexRow != 0) {
                context.DrawLine(this.pen, x, y + cellHeight * (double)indexRow, x + width, y + cellHeight * (double)indexRow);
            }
            if (this.chartTable.isMarkerVisible()) {
                StiRectangle rectMarker = new StiRectangle(x + 2.0, y + 2.0 + cellHeight * (double)indexRow, cellHeight - 4.0, cellHeight - 4.0);
                IStiLegendMarker legendMarker = StiMarkerLegendFactory.CreateMarker((IStiSeries)this.chartTable.getChart().getSeries().get(indexRow));
                legendMarker.Draw(context, (IStiSeries)this.chartTable.getChart().getSeries().get(indexRow), rectMarker, indexRow, list.size(), -1);
                x += cellHeight;
                width -= cellHeight;
            }
            StiRectangle rectangle = new StiRectangle(x, y + cellHeight * (double)indexRow, width, cellHeight);
            context.DrawString(list.get(indexRow), this.font, (Object)this.labelBrush, StiRectangle.round((StiRectangle)rectangle), this.sf);
        }
    }

    private void DrawRootTable(StiContext context, StiRectangle rect, boolean startFromZero) {
        if (this.chartTable.isGridOutline()) {
            context.DrawRectangle(this.pen, rect.x, rect.y, rect.width, rect.height);
        }
        int countRow = this.table.length;
        int countColumn = this.table[0].length;
        int count = startFromZero ? this.table[0].length : this.table[0].length - 2;
        double cellWidth = rect.width / (double)count;
        double cellHeight = rect.height / (double)(countRow - 1);
        for (int indexRow = 1; indexRow < countRow; ++indexRow) {
            if (this.chartTable.isGridLinesHor() && indexRow != countRow - 1) {
                context.DrawLine(this.pen, rect.x, rect.y + (double)indexRow * cellHeight, rect.getRight(), rect.y + (double)indexRow * cellHeight);
            }
            for (int indexColumn = 1; indexColumn < countColumn; ++indexColumn) {
                double deltaX;
                double deltaWidth = 0.0;
                if (indexColumn == 1 || indexColumn == countColumn - 1) {
                    deltaWidth = startFromZero ? cellWidth / 2.0 : -cellWidth / 2.0;
                }
                double d = deltaX = startFromZero ? cellWidth / 2.0 : -cellWidth / 2.0;
                if (indexColumn == 1) {
                    deltaX = 0.0;
                }
                StiRectangle rectangle = new StiRectangle(rect.x + (double)(indexColumn - 1) * cellWidth + deltaX, rect.y + (double)(indexRow - 1) * cellHeight, cellWidth + deltaWidth, cellHeight);
                context.DrawString(this.table[indexRow][indexColumn], this.font, (Object)this.labelBrush, StiRectangle.round((StiRectangle)rectangle), this.sf);
                if (!this.chartTable.isGridLinesVert() || indexColumn >= countColumn - 1) continue;
                double x = startFromZero ? rect.x + (double)indexColumn * cellWidth + cellWidth / 2.0 : rect.x + (double)indexColumn * cellWidth - cellWidth / 2.0;
                context.DrawLine(this.pen, x, rect.y, x, rect.getBottom());
            }
        }
    }

    public StiChartTableGeom(StiRectangle clientRectangle, String[][] table, double widthCellLegendTableChart, IStiChartTable chartTable) {
        super(clientRectangle);
        this.widthCellLegendTableChart = widthCellLegendTableChart;
        this.table = table;
        this.chartTable = chartTable;
        this.pen = new StiPenGeom((Object)chartTable.getGridLineColor());
        this.labelBrush = new StiSolidBrush(chartTable.getTextColor());
    }
}

