/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.report.chart.view.series;

import com.stimulsoft.base.IStiJsonReportObject;
import com.stimulsoft.base.StiJsonSaveMode;
import com.stimulsoft.base.drawing.StiBrush;
import com.stimulsoft.base.drawing.StiGlareBrush;
import com.stimulsoft.base.drawing.StiGradientBrush;
import com.stimulsoft.base.drawing.StiSolidBrush;
import com.stimulsoft.base.json.JProperty;
import com.stimulsoft.base.json.JSONException;
import com.stimulsoft.base.json.JSONObject;
import com.stimulsoft.base.serializing.annotations.StiDefaulValue;
import com.stimulsoft.base.serializing.annotations.StiSerializable;
import com.stimulsoft.base.serializing.annotations.StiSerializeTypesEnum;
import com.stimulsoft.base.serializing.utils.StiSerializTypeConverter;
import com.stimulsoft.base.serializing.utils.StiXMLConvert;
import com.stimulsoft.base.services.StiService;
import com.stimulsoft.base.system.StiGuid;
import com.stimulsoft.lib.utils.StiValidationUtil;
import com.stimulsoft.report.StiOptions;
import com.stimulsoft.report.chart.StiChart;
import com.stimulsoft.report.chart.StiChartHelper;
import com.stimulsoft.report.chart.core.series.StiSeriesCoreXF;
import com.stimulsoft.report.chart.enums.StiSeriesSortDirection;
import com.stimulsoft.report.chart.enums.StiSeriesSortType;
import com.stimulsoft.report.chart.enums.StiSeriesYAxis;
import com.stimulsoft.report.chart.enums.StiShowSeriesLabels;
import com.stimulsoft.report.chart.interfaces.IStiChart;
import com.stimulsoft.report.chart.interfaces.IStiFinancialSeries;
import com.stimulsoft.report.chart.interfaces.IStiSeriesInteraction;
import com.stimulsoft.report.chart.interfaces.areas.IStiAxisArea;
import com.stimulsoft.report.chart.interfaces.areas.clusteredBar.IStiClusteredBarArea;
import com.stimulsoft.report.chart.interfaces.series.IStiSeries;
import com.stimulsoft.report.chart.interfaces.series.candlestick.IStiCandlestickSeries;
import com.stimulsoft.report.chart.interfaces.series.doughnut.IStiDoughnutSeries;
import com.stimulsoft.report.chart.interfaces.series.funnel.IStiFunnelSeries;
import com.stimulsoft.report.chart.interfaces.series.gantt.IStiGanttSeries;
import com.stimulsoft.report.chart.interfaces.series.pie.IStiPieSeries;
import com.stimulsoft.report.chart.interfaces.series.range.IStiRangeBarSeries;
import com.stimulsoft.report.chart.interfaces.series.range.IStiRangeSeries;
import com.stimulsoft.report.chart.interfaces.series.scatter.IStiScatterLineSeries;
import com.stimulsoft.report.chart.interfaces.series.scatter.IStiScatterSeries;
import com.stimulsoft.report.chart.interfaces.series.scatter.IStiScatterSplineSeries;
import com.stimulsoft.report.chart.interfaces.seriesLabels.IStiSeriesLabels;
import com.stimulsoft.report.chart.interfaces.topN.IStiSeriesTopN;
import com.stimulsoft.report.chart.interfaces.trendLines.IStiTrendLine;
import com.stimulsoft.report.chart.view.conditions.StiChartCondition;
import com.stimulsoft.report.chart.view.conditions.StiChartConditionsCollection;
import com.stimulsoft.report.chart.view.events.StiGetListOfArgumentsEvent;
import com.stimulsoft.report.chart.view.events.StiGetListOfHyperlinksEvent;
import com.stimulsoft.report.chart.view.events.StiGetListOfTagsEvent;
import com.stimulsoft.report.chart.view.events.StiGetListOfToolTipsEvent;
import com.stimulsoft.report.chart.view.events.StiGetListOfValuesEvent;
import com.stimulsoft.report.chart.view.events.StiGetTitleEvent;
import com.stimulsoft.report.chart.view.events.StiGetTitleEventArgs;
import com.stimulsoft.report.chart.view.events.StiNewAutoSeriesEvent;
import com.stimulsoft.report.chart.view.events.StiNewAutoSeriesEventArgs;
import com.stimulsoft.report.chart.view.expressions.StiListOfArgumentsExpression;
import com.stimulsoft.report.chart.view.expressions.StiListOfHyperlinksExpression;
import com.stimulsoft.report.chart.view.expressions.StiListOfTagsExpression;
import com.stimulsoft.report.chart.view.expressions.StiListOfToolTipsExpression;
import com.stimulsoft.report.chart.view.expressions.StiListOfValuesExpression;
import com.stimulsoft.report.chart.view.expressions.StiTitleExpression;
import com.stimulsoft.report.chart.view.filter.StiChartFiltersCollection;
import com.stimulsoft.report.chart.view.series.StiSeriesInteraction;
import com.stimulsoft.report.chart.view.series.radar.StiRadarSeries;
import com.stimulsoft.report.chart.view.seriesLabels.StiSeriesLabels;
import com.stimulsoft.report.chart.view.seriesLabels.axis.StiCenterAxisLabels;
import com.stimulsoft.report.chart.view.topN.StiSeriesTopN;
import com.stimulsoft.report.chart.view.trendLines.StiTrendLine;
import com.stimulsoft.report.chart.view.trendLines.StiTrendLineNone;
import com.stimulsoft.report.components.StiComponent;
import com.stimulsoft.report.components.StiPage;
import com.stimulsoft.report.components.enums.StiFilterMode;
import com.stimulsoft.report.components.interfaces.IStiSeriesParent;
import com.stimulsoft.report.components.simplecomponents.StiText;
import com.stimulsoft.report.engine.parser.StiParser;
import com.stimulsoft.report.enums.StiCalculationMode;
import com.stimulsoft.report.events.StiGetArgumentEvent;
import com.stimulsoft.report.events.StiGetHyperlinkEvent;
import com.stimulsoft.report.events.StiGetTagEvent;
import com.stimulsoft.report.events.StiGetToolTipEvent;
import com.stimulsoft.report.events.StiGetValueEvent;
import com.stimulsoft.report.events.StiGetValueEventArgs;
import com.stimulsoft.report.events.StiValueEventArgs;
import com.stimulsoft.report.expressions.StiArgumentExpression;
import com.stimulsoft.report.expressions.StiExpression;
import com.stimulsoft.report.expressions.StiHyperlinkExpression;
import com.stimulsoft.report.expressions.StiTagExpression;
import com.stimulsoft.report.expressions.StiToolTipExpression;
import java.util.ArrayList;
import java.util.Calendar;

public abstract class StiSeries
extends StiService
implements IStiSeriesParent,
IStiSeries,
IStiJsonReportObject {
    private StiSeriesCoreXF core;
    private boolean allowApplyStyle = true;
    private String format = "";
    private StiSeriesSortType sortBy = StiSeriesSortType.None;
    private StiSeriesSortDirection sortDirection = StiSeriesSortDirection.Ascending;
    private boolean showInLegend = true;
    private StiShowSeriesLabels showSeriesLabels = StiShowSeriesLabels.FromChart;
    private boolean showShadow = true;
    private StiFilterMode filterMode = StiFilterMode.And;
    private StiChartFiltersCollection filters = new StiChartFiltersCollection();
    private StiChartConditionsCollection conditions = new StiChartConditionsCollection();
    private IStiSeriesTopN topN = new StiSeriesTopN();
    private StiSeriesYAxis yAxis = StiSeriesYAxis.LeftYAxis;
    private IStiSeriesLabels seriesLabels;
    private IStiTrendLine trendLine;
    private IStiChart chart;
    private Double[] values = new Double[]{1.0, 3.0, 2.0};
    private String valueDataColumn = "";
    private Object[] arguments = new Object[0];
    private String argumentDataColumn = "";
    private String autoSeriesTitleDataColumn = "";
    private String autoSeriesKeyDataColumn = "";
    private String autoSeriesColorDataColumn = "";
    private String[] toolTips = new String[0];
    private String toolTipDataColumn = "";
    private Object[] tags = new Object[0];
    private String tagDataColumn = "";
    private String[] hyperlinks = new String[0];
    private String hyperlinkDataColumn = "";
    private boolean drillDownEnabled = false;
    private String drillDownReport = "";
    private String drillDownPageGuid = null;
    private boolean allowSeries = true;
    private boolean allowSeriesElements = true;
    private IStiSeriesInteraction interaction;
    private StiNewAutoSeriesEvent newAutoSeriesEvent = new StiNewAutoSeriesEvent();
    private StiGetValueEvent getValueEvent = new StiGetValueEvent();
    private StiGetListOfValuesEvent getListOfValuesEvent = new StiGetListOfValuesEvent();
    private StiGetArgumentEvent getArgumentEvent = new StiGetArgumentEvent();
    private StiGetListOfArgumentsEvent getListOfArgumentsEvent = new StiGetListOfArgumentsEvent();
    private StiGetTitleEvent getTitleEvent = new StiGetTitleEvent();
    private static final Object EventGetToolTip = new Object();
    private StiGetToolTipEvent getToolTipEvent = new StiGetToolTipEvent();
    private StiGetListOfToolTipsEvent getListOfToolTipsEvent = new StiGetListOfToolTipsEvent();
    private static final Object EventGetTag = new Object();
    private StiGetTagEvent getTagEvent = new StiGetTagEvent();
    private StiGetListOfTagsEvent getListOfTagsEvent = new StiGetListOfTagsEvent();
    private static final Object EventGetHyperlink = new Object();
    private StiGetHyperlinkEvent getHyperlinkEvent = new StiGetHyperlinkEvent();
    private StiGetListOfHyperlinksEvent getListOfHyperlinksEvent = new StiGetListOfHyperlinksEvent();
    private StiExpression valueObj = new StiExpression();
    private Double[] valuesOld = null;
    private StiListOfValuesExpression listOfValues = new StiListOfValuesExpression();
    private StiArgumentExpression argument = new StiArgumentExpression();
    private StiListOfArgumentsExpression listOfArguments = new StiListOfArgumentsExpression();
    private String titleValue = null;
    private StiTitleExpression title = new StiTitleExpression();
    private StiToolTipExpression toolTip = new StiToolTipExpression();
    private StiListOfToolTipsExpression listOfToolTips = new StiListOfToolTipsExpression();
    private StiTagExpression tag = new StiTagExpression();
    private StiListOfTagsExpression listOfTags = new StiListOfTagsExpression();
    private StiHyperlinkExpression hyperlink = new StiHyperlinkExpression();
    private StiListOfHyperlinksExpression listOfHyperlinks = new StiListOfHyperlinksExpression();

    @Override
    public IStiSeries clone() {
        Object tempVar = super.clone();
        StiSeries series = (StiSeries)(tempVar instanceof StiSeries ? tempVar : null);
        Object tempVar2 = this.getTitle().clone();
        series.setTitle((StiTitleExpression)(tempVar2 instanceof StiTitleExpression ? tempVar2 : null));
        Object tempVar3 = this.getValues().clone();
        series.setValues((Double[])(tempVar3 instanceof Double[] ? tempVar3 : null));
        Object tempVar4 = this.getArguments().clone();
        series.setArguments((Object[])(tempVar4 instanceof Object[] ? tempVar4 : null));
        Object tempVar5 = this.getTags().clone();
        series.setTags((Object[])(tempVar5 instanceof Object[] ? tempVar5 : null));
        Object tempVar6 = this.getToolTips().clone();
        series.setToolTips((String[])(tempVar6 instanceof String[] ? tempVar6 : null));
        Object tempVar7 = this.getHyperlinks().clone();
        series.setHyperlinks((String[])(tempVar7 instanceof String[] ? tempVar7 : null));
        if (this.getCore() != null) {
            Object tempVar8 = this.getCore().clone();
            series.setCore((StiSeriesCoreXF)(tempVar8 instanceof StiSeriesCoreXF ? tempVar8 : null));
            series.getCore().setSeries(series);
        }
        return series;
    }

    protected void BaseTransform(Object context, float x, float y, float angle, float dx, float dy) {
    }

    @Override
    public final StiComponent getParent() {
        IStiChart tempVar = this.getChart();
        return (StiComponent)((Object)(tempVar instanceof StiComponent ? tempVar : null));
    }

    public String getServiceName() {
        return this.getCore().getLocalizedName();
    }

    public final String getServiceCategory() {
        return "Chart";
    }

    public final Class getServiceType() {
        return StiSeries.class;
    }

    @Override
    public final StiSeriesCoreXF getCore() {
        return this.core;
    }

    @Override
    public final void setCore(StiSeriesCoreXF value) {
        this.core = value;
    }

    @Override
    @StiSerializable
    @StiDefaulValue(value="true")
    public final boolean getAllowApplyStyle() {
        return this.allowApplyStyle;
    }

    @Override
    public final void setAllowApplyStyle(boolean value) {
        if (this.allowApplyStyle != value) {
            this.allowApplyStyle = value;
        }
    }

    @Override
    @StiDefaulValue(value="")
    @StiSerializable
    public final String getFormat() {
        return this.format;
    }

    @Override
    public final void setFormat(String value) {
        this.format = value;
    }

    @Override
    @StiDefaulValue(value="None")
    @StiSerializable
    public final StiSeriesSortType getSortBy() {
        return this.sortBy;
    }

    @Override
    public final void setSortBy(StiSeriesSortType value) {
        this.sortBy = value;
    }

    @Override
    @StiDefaulValue(value="Ascending")
    @StiSerializable
    public final StiSeriesSortDirection getSortDirection() {
        return this.sortDirection;
    }

    @Override
    public final void setSortDirection(StiSeriesSortDirection value) {
        this.sortDirection = value;
    }

    @Override
    @StiDefaulValue(value="true")
    @StiSerializable
    public final boolean getShowInLegend() {
        return this.showInLegend;
    }

    @Override
    public final void setShowInLegend(boolean value) {
        this.showInLegend = value;
    }

    @Deprecated
    public final boolean getShowLabels() {
        return this.getShowSeriesLabels() != StiShowSeriesLabels.None;
    }

    @Deprecated
    public final void setShowLabels(boolean value) {
        if (value) {
            this.setShowSeriesLabels(StiShowSeriesLabels.FromChart);
        } else if (value) {
            this.setShowSeriesLabels(StiShowSeriesLabels.None);
        }
    }

    @Override
    @StiDefaulValue(value="FromChart")
    @StiSerializable
    public final StiShowSeriesLabels getShowSeriesLabels() {
        return this.showSeriesLabels;
    }

    @Override
    public final void setShowSeriesLabels(StiShowSeriesLabels value) {
        this.showSeriesLabels = value;
    }

    @Override
    @StiDefaulValue(value="true")
    @StiSerializable
    public final boolean getShowShadow() {
        return this.showShadow;
    }

    @Override
    public final void setShowShadow(boolean value) {
        this.showShadow = value;
    }

    @StiDefaulValue(value="And")
    @StiSerializable
    public final StiFilterMode getFilterMode() {
        return this.filterMode;
    }

    public final void setFilterMode(StiFilterMode value) {
        this.filterMode = value;
    }

    @Override
    @StiSerializable
    public final StiChartFiltersCollection getFilters() {
        return this.filters;
    }

    @Override
    public final void setFilters(StiChartFiltersCollection value) {
        this.filters = value;
    }

    @Override
    @StiSerializable
    public StiChartConditionsCollection getConditions() {
        return this.conditions;
    }

    @Override
    public void setConditions(StiChartConditionsCollection value) {
        this.conditions = value;
    }

    @Override
    @StiSerializable
    public IStiSeriesTopN getTopN() {
        return this.topN;
    }

    @Override
    public void setTopN(IStiSeriesTopN value) {
        this.topN = value;
    }

    @Override
    @StiDefaulValue(value="LeftYAxis")
    @StiSerializable
    public final StiSeriesYAxis getYAxis() {
        return this.yAxis;
    }

    @Override
    public final void setYAxis(StiSeriesYAxis value) {
        this.yAxis = value;
    }

    @Override
    @StiSerializable
    public final IStiSeriesLabels getSeriesLabels() {
        return this.seriesLabels;
    }

    @Override
    public final void setSeriesLabels(IStiSeriesLabels value) {
        this.seriesLabels = value;
        if (value != null) {
            this.seriesLabels.setChart(this.getChart());
        }
    }

    @StiSerializable
    public IStiTrendLine getTrendLine() {
        return this.trendLine;
    }

    public void setTrendLine(IStiTrendLine value) {
        this.trendLine = value;
    }

    @Override
    @StiSerializable(isRef=true)
    public final IStiChart getChart() {
        return this.chart;
    }

    @Override
    public final void setChart(IStiChart value) {
        if (this.chart != value) {
            this.chart = value;
            if (value != null && this.getSeriesLabels() != null) {
                this.getSeriesLabels().setChart(value);
            }
        }
    }

    @Override
    public final Double[] getValues() {
        if (this.getChart() != null && this.getChart().getIsDesigning()) {
            if (this.getListOfValues().getValue() != null && this.getListOfValues().getValue().length() > 0) {
                return StiSeries.GetNullableValuesFromString(this.getListOfValues().getValue());
            }
            int serIndex = this.getChart().getSeries().indexOf(this);
            if (this instanceof IStiFunnelSeries) {
                return new Double[]{3.0, 2.0, 1.0};
            }
            if (this instanceof IStiGanttSeries) {
                return new Double[]{1.0 + (double)(serIndex * 3), 3.0 + (double)(serIndex * 4), 7.0 + (double)(serIndex * 3)};
            }
            if (this instanceof IStiScatterSeries || this instanceof IStiScatterLineSeries || this instanceof IStiScatterSplineSeries) {
                return new Double[]{1.0 + (double)serIndex, 6.0 + (double)serIndex, 2.0 + (double)serIndex};
            }
            if (this instanceof IStiPieSeries || this instanceof IStiDoughnutSeries) {
                if (serIndex == 0) {
                    return new Double[]{1.0, 3.0, 2.0};
                }
                return new Double[]{1.0 + (double)serIndex, 3.0 + (double)serIndex, 4.0 + (double)serIndex};
            }
            if (this instanceof StiRadarSeries) {
                return new Double[]{1.0 + (double)serIndex, 2.0 + (double)serIndex, 3.0 + (double)serIndex, 4.0 + (double)serIndex, 5.0 + (double)serIndex};
            }
            if (serIndex == 0) {
                return this.values;
            }
            return new Double[]{1.0 + (double)serIndex, 3.0 + (double)serIndex, 2.5 + (double)serIndex};
        }
        return this.values;
    }

    @Override
    public final void setValues(Double[] value) {
        this.valuesOld = this.values;
        this.values = value;
    }

    @StiDefaulValue(value="")
    @StiSerializable
    public String getValueDataColumn() {
        return this.valueDataColumn;
    }

    public void setValueDataColumn(String value) {
        this.valueDataColumn = value;
    }

    @StiSerializable(type=StiSerializeTypesEnum.SerializeToDocument)
    public final String getValuesString() {
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        for (Double value : this.values) {
            if (first) {
                sb.append(String.format("%1$s", value == null ? 0.0 : value));
            } else {
                sb.append(String.format(";%1$s", value == null ? 0.0 : value));
            }
            first = false;
        }
        return sb.toString();
    }

    public final void setValuesString(String value) {
        if (value == null || value.trim().length() == 0) {
            this.values = new Double[0];
        } else {
            String[] strs = value.split("[;]", -1);
            this.values = new Double[strs.length];
            int index = 0;
            for (String str : strs) {
                this.values[index++] = Double.parseDouble(str);
            }
        }
    }

    @Override
    public Object[] getArguments() {
        if (this.getChart() != null && this.getChart().getIsDesigning()) {
            if (this.getListOfArguments().getValue() != null && this.getListOfArguments().getValue().length() > 0) {
                return StiSeries.GetArgumentsFromString(this.getListOfArguments().getValue());
            }
            if ((this instanceof IStiGanttSeries || this instanceof IStiRangeBarSeries || this instanceof IStiCandlestickSeries) && (this.arguments == null || this.arguments.length == 0)) {
                return new Object[]{"A", "B", "C"};
            }
            if ((this instanceof IStiScatterSeries || this instanceof IStiScatterLineSeries || this instanceof IStiScatterSplineSeries) && (this.arguments == null || this.arguments.length == 0)) {
                return new Object[]{"1", "5", "4"};
            }
        }
        return this.arguments;
    }

    @Override
    public void setArguments(Object[] value) {
        this.arguments = value;
    }

    @StiSerializable
    @StiDefaulValue(value="")
    public final String getArgumentDataColumn() {
        return this.argumentDataColumn;
    }

    public final void setArgumentDataColumn(String value) {
        this.argumentDataColumn = value;
    }

    @StiSerializable(type=StiSerializeTypesEnum.SerializeToDocument)
    public final String getArgumentsString() {
        StringBuilder sb = new StringBuilder();
        String delimiter = ";";
        for (int i = 0; i < this.arguments.length; ++i) {
            Object argument = this.arguments[i];
            String value = argument instanceof Calendar ? StiSerializTypeConverter.calendarToString((Object)argument) : argument.toString();
            String valueEn = StiXMLConvert.encodeName((String)value);
            sb.append(valueEn + delimiter);
        }
        return sb.length() > 0 ? sb.toString().substring(0, sb.length() - 1) : "";
    }

    public final void setArgumentsString(String value) {
        if (value == null || value.trim().length() == 0) {
            this.arguments = new Object[0];
        } else {
            String[] strs = value.split("[;]", -1);
            this.arguments = new Object[strs.length];
            int index = 0;
            for (String str : strs) {
                this.arguments[index++] = StiXMLConvert.DecodeName((String)str);
            }
        }
    }

    @StiSerializable
    @StiDefaulValue(value="")
    public final String getAutoSeriesTitleDataColumn() {
        return this.autoSeriesTitleDataColumn;
    }

    public final void setAutoSeriesTitleDataColumn(String value) {
        this.autoSeriesTitleDataColumn = value;
    }

    @StiSerializable
    @StiDefaulValue(value="")
    public final String getAutoSeriesKeyDataColumn() {
        return this.autoSeriesKeyDataColumn;
    }

    public final void setAutoSeriesKeyDataColumn(String value) {
        this.autoSeriesKeyDataColumn = value;
    }

    @StiSerializable
    @StiDefaulValue(value="")
    public final String getAutoSeriesColorDataColumn() {
        return this.autoSeriesColorDataColumn;
    }

    public final void setAutoSeriesColorDataColumn(String value) {
        this.autoSeriesColorDataColumn = value;
    }

    @Override
    public String[] getToolTips() {
        if (this.getChart() != null && this.getChart().getIsDesigning() && this.getListOfToolTips().getValue() != null && this.getListOfToolTips().getValue().length() > 0) {
            return StiSeries.GetStringsFromString(this.getListOfToolTips().getValue());
        }
        return this.toolTips;
    }

    @Override
    public void setToolTips(String[] value) {
        this.toolTips = value;
    }

    @StiSerializable
    @StiDefaulValue(value="")
    public final String getToolTipDataColumn() {
        return this.toolTipDataColumn;
    }

    public final void setToolTipDataColumn(String value) {
        this.toolTipDataColumn = value;
    }

    @StiSerializable(type=StiSerializeTypesEnum.SerializeToDocument)
    public final String getToolTipsString() {
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        for (String arg : this.toolTips) {
            if (arg == null) continue;
            if (first) {
                sb.append(String.format("%1$s", StiXMLConvert.EncodeName((String)arg.toString())));
            } else {
                sb.append(String.format(";%1$s", StiXMLConvert.EncodeName((String)arg.toString())));
            }
            first = false;
        }
        return sb.toString();
    }

    public final void setToolTipsString(String value) {
        if (value == null || value.trim().length() == 0) {
            this.toolTips = new String[0];
        } else {
            String[] strs = value.split("[;]", -1);
            this.toolTips = new String[strs.length];
            int index = 0;
            for (String str : strs) {
                this.toolTips[index++] = StiXMLConvert.DecodeName((String)str);
            }
        }
    }

    @Override
    public Object[] getTags() {
        if (this.getChart() != null && this.getChart().getIsDesigning() && this.getListOfTags().getValue() != null && this.getListOfTags().getValue().length() > 0) {
            return StiSeries.GetArgumentsFromString(this.getListOfTags().getValue());
        }
        return this.tags;
    }

    @Override
    public void setTags(Object[] value) {
        this.tags = value;
    }

    @StiSerializable
    @StiDefaulValue(value="")
    public final String getTagDataColumn() {
        return this.tagDataColumn;
    }

    public final void setTagDataColumn(String value) {
        this.tagDataColumn = value;
    }

    @StiSerializable(type=StiSerializeTypesEnum.SerializeToDocument)
    public final String getTagString() {
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        for (Object arg : this.tags) {
            if (arg == null) continue;
            if (first) {
                sb.append(String.format("%1$s", StiXMLConvert.EncodeName((String)arg.toString())));
            } else {
                sb.append(String.format(";%1$s", StiXMLConvert.EncodeName((String)arg.toString())));
            }
            first = false;
        }
        return sb.toString();
    }

    public final void setTagString(String value) {
        if (value == null || value.trim().length() == 0) {
            this.tags = new Object[0];
        } else {
            String[] strs = value.split("[;]", -1);
            this.tags = new Object[strs.length];
            int index = 0;
            for (String str : strs) {
                this.tags[index++] = StiXMLConvert.DecodeName((String)str);
            }
        }
    }

    @Override
    public String[] getHyperlinks() {
        if (this.getChart() != null && this.getChart().getIsDesigning() && this.getListOfHyperlinks().getValue() != null && this.getListOfHyperlinks().getValue().length() > 0) {
            return StiSeries.GetStringsFromString(this.getListOfHyperlinks().getValue());
        }
        return this.hyperlinks;
    }

    @Override
    public void setHyperlinks(String[] value) {
        this.hyperlinks = value;
    }

    @StiSerializable
    @StiDefaulValue(value="")
    public final String getHyperlinkDataColumn() {
        return this.hyperlinkDataColumn;
    }

    public final void setHyperlinkDataColumn(String value) {
        this.hyperlinkDataColumn = value;
    }

    @StiSerializable(type=StiSerializeTypesEnum.SerializeToDocument)
    public final String getHyperlinkString() {
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        for (String arg : this.hyperlinks) {
            if (arg == null) continue;
            if (first) {
                sb.append(String.format("%1$s", StiXMLConvert.EncodeName((String)arg.toString())));
            } else {
                sb.append(String.format(";%1$s", StiXMLConvert.EncodeName((String)arg.toString())));
            }
            first = false;
        }
        return sb.toString();
    }

    public final void setHyperlinkString(String value) {
        if (value == null || value.trim().length() == 0) {
            this.hyperlinks = new String[0];
        } else {
            String[] strs = value.split("[;]", -1);
            this.hyperlinks = new String[strs.length];
            int index = 0;
            for (String str : strs) {
                this.hyperlinks[index++] = StiXMLConvert.DecodeName((String)str);
            }
        }
    }

    @StiDefaulValue(value="false")
    @StiSerializable
    public boolean getDrillDownEnabled() {
        return this.drillDownEnabled;
    }

    public void setDrillDownEnabled(boolean value) {
        this.drillDownEnabled = value;
    }

    @StiDefaulValue(value="")
    @StiSerializable
    public String getDrillDownReport() {
        return this.drillDownReport;
    }

    public void setDrillDownReport(String value) {
        this.drillDownReport = value;
    }

    @StiSerializable(need=false)
    public StiPage getDrillDownPage() {
        if (this.getChart() == null || ((StiChart)this.getChart()).getReport() == null) {
            return null;
        }
        for (StiPage page : ((StiChart)this.getChart()).getReport().pages) {
            if (!page.getGuid().equals(this.getDrillDownPageGuid())) continue;
            return page;
        }
        return null;
    }

    public void setDrillDownPage(StiPage value) {
        if (value == null) {
            this.drillDownPageGuid = null;
        } else {
            if (value.getGuid() == null) {
                value.setGuid(StiGuid.newGuidString());
            }
            this.drillDownPageGuid = value.getGuid();
        }
    }

    @StiSerializable
    public final String getDrillDownPageGuid() {
        return this.drillDownPageGuid;
    }

    public final void setDrillDownPageGuid(String value) {
        this.drillDownPageGuid = value;
    }

    @StiDefaulValue(value="true")
    @StiSerializable
    public final boolean getAllowSeries() {
        return this.allowSeries;
    }

    public final void setAllowSeries(boolean value) {
        this.allowSeries = value;
    }

    @StiDefaulValue(value="true")
    @StiSerializable
    public final boolean getAllowSeriesElements() {
        return this.allowSeriesElements;
    }

    public final void setAllowSeriesElements(boolean value) {
        this.allowSeriesElements = value;
    }

    @Override
    public final String getCoreTitle() {
        String value = null;
        value = this.getChart() != null && this.getChart().getIsDesigning() ? this.getTitle().getValue() : this.getTitleValue();
        if (value == null) {
            value = "";
        }
        return value;
    }

    @Override
    public final void setCoreTitle(String value) {
        this.getTitle().setValue(value);
        this.setTitleValue(value);
    }

    @Override
    public IStiSeriesInteraction getInteraction() {
        return this.interaction;
    }

    @Override
    public void setInteraction(IStiSeriesInteraction value) {
        if (this.interaction != value) {
            this.interaction = value;
            if (value != null) {
                ((StiSeriesInteraction)this.interaction).ParentSeries = this;
            }
        }
    }

    @Override
    public final StiBrush ProcessSeriesColors(int pointIndex, StiBrush seriesBrush) {
        for (StiChartCondition condition : this.getConditions()) {
            Object data;
            if (this.getValues() == null || this.getValues().length <= pointIndex) continue;
            Double itemValue = null;
            Object itemArgument = null;
            if (this.chart.getArea() instanceof IStiAxisArea && (((IStiAxisArea)this.chart.getArea()).getReverseHor() && !(this.getChart().getArea() instanceof IStiClusteredBarArea) || this.getChart().getArea() instanceof IStiClusteredBarArea && ((IStiAxisArea)this.chart.getArea()).getReverseVert())) {
                itemValue = this.getValues()[this.getValues().length - pointIndex - 1];
                if (this.getArguments() != null && pointIndex < this.getArguments().length) {
                    itemArgument = this.getArguments()[this.getArguments().length - pointIndex - 1];
                }
            } else {
                itemValue = this.getValues()[pointIndex];
                if (this.getArguments() != null && pointIndex < this.getArguments().length) {
                    itemArgument = this.getArguments()[pointIndex];
                }
            }
            if (!StiChartHelper.GetFilterResult(condition, itemArgument, itemValue, null, null, null, null, null, data = StiChartHelper.GetFilterData(null, condition, null))) continue;
            seriesBrush = this.getAllowApplyStyle() && this.getChart().getStyle() != null ? this.getChart().getStyle().getCore().GetColumnBrush(condition.getColor()) : new StiSolidBrush(condition.getColor());
            if (this.getChart().getArea() instanceof IStiClusteredBarArea) {
                if (seriesBrush instanceof StiGradientBrush) {
                    ((StiGradientBrush)seriesBrush).angle += 90.0;
                }
                if (seriesBrush instanceof StiGlareBrush) {
                    ((StiGlareBrush)seriesBrush).angle += 90.0;
                }
            }
            return seriesBrush;
        }
        return seriesBrush;
    }

    public String toString() {
        return this.getServiceName();
    }

    public static Double[] GetNullableValuesFromString(String list) {
        String[] points;
        ArrayList<Double> alValue = new ArrayList<Double>();
        for (String point : points = list.split("[;]", -1)) {
            if (point == null || point.trim().length() <= 0) continue;
            Double value = 0.0;
            try {
                value = Double.valueOf(point.toString().replace(",", "."));
            }
            catch (Exception e) {
                // empty catch block
            }
            alValue.add(value);
        }
        return alValue.toArray(new Double[0]);
    }

    public static ArrayList<Double> GetValuesFromString(String list) {
        String[] points;
        ArrayList<Double> alValue = new ArrayList<Double>();
        for (String point : points = list.split("[;]", -1)) {
            if (point == null || point.trim().length() <= 0) continue;
            double value = 0.0;
            try {
                value = Double.valueOf(point.toString());
            }
            catch (Exception e) {
                // empty catch block
            }
            alValue.add(value);
        }
        return (ArrayList)alValue.clone();
    }

    public static String[] GetStringsFromString(String list) {
        String[] points;
        ArrayList<String> alValue = new ArrayList<String>();
        for (String point : points = list.split("[;]", -1)) {
            if (point == null || point.trim().length() <= 0) continue;
            alValue.add(point);
        }
        String[] pointValues = new String[alValue.size()];
        pointValues = alValue.toArray(pointValues);
        return pointValues;
    }

    public static Object[] GetArgumentsFromString(String list) {
        return list.split("[;]", -1);
    }

    @Override
    public abstract Class GetDefaultAreaType();

    public final void InvokeNewAutoSeries(StiNewAutoSeriesEventArgs e) {
        if (this.getNewAutoSeries() != null) {
            this.setNewAutoSeries(e.getSeries(), e);
        }
    }

    private void setNewAutoSeries(IStiSeries series, StiNewAutoSeriesEventArgs e) {
    }

    private Object getNewAutoSeries() {
        return null;
    }

    @StiSerializable
    public final StiNewAutoSeriesEvent getNewAutoSeriesEvent() {
        return this.newAutoSeriesEvent;
    }

    public final void setNewAutoSeriesEvent(StiNewAutoSeriesEvent value) {
        this.newAutoSeriesEvent = value;
    }

    protected void OnGetValue(StiGetValueEventArgs e) {
    }

    public void InvokeGetValue(StiComponent sender, StiGetValueEventArgs e) {
        block3: {
            try {
                this.OnGetValue(e);
                if (sender.getReport().isInterpretation()) {
                    StiText tempText = new StiText();
                    tempText.setName("**ChartSeriesValue**");
                    tempText.setPage(sender.getReport().pages.get(0));
                    Object parserResult = StiParser.ParseTextValue(this.getValue().getValue(), (StiComponent)tempText);
                    e.setValue(sender.getReport().ToString(parserResult));
                }
            }
            catch (Exception e1) {
                if (StiOptions.Engine.logLevel < 10) break block3;
                e1.printStackTrace();
            }
        }
    }

    @StiSerializable
    public final StiGetValueEvent getGetValueEvent() {
        return this.getValueEvent;
    }

    public final void setGetValueEvent(StiGetValueEvent value) {
        this.getValueEvent = value;
    }

    protected void OnGetListOfValues(StiGetValueEventArgs e) {
    }

    public final void InvokeGetListOfValues(StiComponent sender, StiGetValueEventArgs e) {
        block3: {
            try {
                this.OnGetListOfValues(e);
                if (sender.getReport().getCalculationMode() == StiCalculationMode.Interpretation) {
                    StiText tempText = new StiText();
                    tempText.setName("**ChartSeriesListOfValues**");
                    tempText.setPage(sender.getReport().getPages().get(0));
                    Object parserResult = StiParser.ParseTextValue(this.listOfValues.getValue(), (StiComponent)tempText);
                    e.setValue(sender.getReport().ToString(parserResult));
                }
            }
            catch (Exception e1) {
                if (StiOptions.Engine.logLevel < 10) break block3;
                e1.printStackTrace();
            }
        }
    }

    @StiSerializable
    public final StiGetListOfValuesEvent getGetListOfValuesEvent() {
        return this.getListOfValuesEvent;
    }

    public final void setGetListOfValuesEvent(StiGetListOfValuesEvent value) {
        this.getListOfValuesEvent = value;
    }

    protected void OnGetArgument(StiValueEventArgs e) {
    }

    public void InvokeGetArgument(StiComponent sender, StiValueEventArgs e) {
        block3: {
            try {
                this.OnGetArgument(e);
                if (sender.getReport().isInterpretation()) {
                    StiText tempText = new StiText();
                    tempText.setName("**ChartSeriesArgument**");
                    tempText.setPage(sender.getReport().getPages().get(0));
                    Object parserResult = StiParser.ParseTextValue(this.getArgument().getValue(), (StiComponent)tempText);
                    e.setValue(sender.getReport().ToString(parserResult));
                }
            }
            catch (Exception e1) {
                if (StiOptions.Engine.logLevel < 10) break block3;
                e1.printStackTrace();
            }
        }
    }

    @StiSerializable
    public final StiGetArgumentEvent getGetArgumentEvent() {
        return this.getArgumentEvent;
    }

    public final void setGetArgumentEvent(StiGetArgumentEvent value) {
        this.getArgumentEvent = value;
    }

    protected void OnGetListOfArguments(StiGetValueEventArgs e) {
    }

    public final void InvokeGetListOfArguments(StiComponent sender, StiGetValueEventArgs e) {
        block3: {
            try {
                this.OnGetListOfArguments(e);
                if (sender.getReport().getCalculationMode() == StiCalculationMode.Interpretation) {
                    StiText tempText = new StiText();
                    tempText.setName("**ChartSeriesListOfArguments**");
                    tempText.setPage(sender.getReport().getPages().get(0));
                    Object parserResult = StiParser.ParseTextValue(this.listOfArguments, tempText);
                    e.setValue(sender.getReport().ToString(parserResult));
                }
            }
            catch (Exception e1) {
                if (StiOptions.Engine.logLevel < 10) break block3;
                e1.printStackTrace();
            }
        }
    }

    @StiSerializable
    public final StiGetListOfArgumentsEvent getGetListOfArgumentsEvent() {
        return this.getListOfArgumentsEvent;
    }

    public final void setGetListOfArgumentsEvent(StiGetListOfArgumentsEvent value) {
        this.getListOfArgumentsEvent = value;
    }

    protected void OnGetTitle(StiGetTitleEventArgs e) {
    }

    public void InvokeGetTitle(StiComponent sender, StiGetTitleEventArgs e) {
        block3: {
            try {
                this.OnGetTitle(e);
                if (sender.getReport().getCalculationMode() == StiCalculationMode.Interpretation) {
                    StiText tempText = new StiText();
                    tempText.setName("**ChartSeriesTitle**");
                    tempText.setPage(sender.getReport().getPages().get(0));
                    Object parserResult = StiParser.ParseTextValue(this.getTitle().getValue(), (StiComponent)tempText);
                    e.setValue(sender.getReport().ToString(parserResult));
                }
            }
            catch (Exception e1) {
                if (StiOptions.Engine.logLevel < 10) break block3;
                e1.printStackTrace();
            }
        }
    }

    @StiSerializable
    public final StiGetTitleEvent getGetTitleEvent() {
        return this.getTitleEvent;
    }

    public final void setGetTitleEvent(StiGetTitleEvent value) {
        this.getTitleEvent = value;
    }

    protected void OnGetToolTip(StiValueEventArgs e) {
    }

    public final void InvokeGetToolTip(Object sender, StiValueEventArgs e) {
        this.OnGetToolTip(e);
    }

    @StiSerializable
    public StiGetToolTipEvent getGetToolTipEvent() {
        return this.getToolTipEvent;
    }

    public void setGetToolTipEvent(StiGetToolTipEvent value) {
        this.getToolTipEvent = value;
    }

    protected void OnGetListOfToolTips(StiGetValueEventArgs e) {
    }

    public final void InvokeGetListOfToolTips(StiComponent sender, StiGetValueEventArgs e) {
        this.OnGetListOfToolTips(e);
    }

    @StiSerializable
    public final StiGetListOfToolTipsEvent getGetListOfToolTipsEvent() {
        return this.getListOfToolTipsEvent;
    }

    public final void setGetListOfToolTipsEvent(StiGetListOfToolTipsEvent value) {
        this.getListOfToolTipsEvent = value;
    }

    protected void OnGetTag(StiValueEventArgs e) {
    }

    public final void InvokeGetTag(StiComponent sender, StiValueEventArgs e) {
        block2: {
            try {
                this.OnGetTag(e);
                StiText tempText = new StiText();
                tempText.setName("**ChartSeriesTag**");
                tempText.setPage(sender.getReport().getPages().get(0));
                Object parserResult = StiParser.ParseTextValue(this.getTag().getValue(), (StiComponent)tempText);
                e.setValue(sender.getReport().ToString(parserResult));
            }
            catch (Exception ee) {
                ee.printStackTrace();
                if (this.chart == null || ((StiChart)this.chart).getReport() == null) break block2;
                ((StiChart)this.chart).getReport().WriteToReportRenderingMessages(StiValidationUtil.isNotNullOrEmpty((String)ee.getMessage()) ? ee.getMessage() : ee.getStackTrace()[0].toString());
            }
        }
    }

    @StiSerializable
    public StiGetTagEvent getGetTagEvent() {
        return this.getTagEvent;
    }

    public void setGetTagEvent(StiGetTagEvent value) {
        this.getTagEvent = value;
    }

    protected void OnGetListOfTags(StiGetValueEventArgs e) {
    }

    public final void InvokeGetListOfTags(StiComponent sender, StiGetValueEventArgs e) {
        this.OnGetListOfTags(e);
    }

    @StiSerializable
    public final StiGetListOfTagsEvent getGetListOfTagsEvent() {
        return this.getListOfTagsEvent;
    }

    public final void setGetListOfTagsEvent(StiGetListOfTagsEvent value) {
        this.getListOfTagsEvent = value;
    }

    protected void OnGetHyperlink(StiValueEventArgs e) {
    }

    public final void InvokeGetHyperlink(Object sender, StiValueEventArgs e) {
        this.OnGetHyperlink(e);
    }

    @StiSerializable
    public StiGetHyperlinkEvent getGetHyperlinkEvent() {
        return this.getHyperlinkEvent;
    }

    public void setGetHyperlinkEvent(StiGetHyperlinkEvent value) {
        this.getHyperlinkEvent = value;
    }

    protected void OnGetListOfHyperlinks(StiGetValueEventArgs e) {
    }

    public final void InvokeGetListOfHyperlinks(StiComponent sender, StiGetValueEventArgs e) {
        this.OnGetListOfHyperlinks(e);
    }

    @StiSerializable
    public final StiGetListOfHyperlinksEvent getGetListOfHyperlinksEvent() {
        return this.getListOfHyperlinksEvent;
    }

    public final void setGetListOfHyperlinksEvent(StiGetListOfHyperlinksEvent value) {
        this.getListOfHyperlinksEvent = value;
    }

    @Override
    public Double[] getValuesStart() {
        return this.valuesOld;
    }

    @StiSerializable
    public StiExpression getValue() {
        return this.valueObj;
    }

    public void setValue(StiExpression value) {
        this.valueObj = value;
    }

    @StiSerializable(type=StiSerializeTypesEnum.SerializeToSaveLoad)
    public StiListOfValuesExpression getListOfValues() {
        return this.listOfValues;
    }

    public void setListOfValues(StiListOfValuesExpression value) {
        this.listOfValues = value;
    }

    @StiSerializable
    public StiArgumentExpression getArgument() {
        return this.argument;
    }

    public void setArgument(StiArgumentExpression value) {
        this.argument = value;
    }

    @StiSerializable(type=StiSerializeTypesEnum.SerializeToSaveLoad)
    public StiListOfArgumentsExpression getListOfArguments() {
        return this.listOfArguments;
    }

    public void setListOfArguments(StiListOfArgumentsExpression value) {
        this.listOfArguments = value;
    }

    @StiSerializable(type=StiSerializeTypesEnum.SerializeToDocument)
    public String getTitleValue() {
        return this.titleValue;
    }

    public void setTitleValue(String value) {
        this.titleValue = value;
    }

    @StiSerializable(type=StiSerializeTypesEnum.SerializeToSaveLoad)
    public StiTitleExpression getTitle() {
        return this.title;
    }

    public void setTitle(StiTitleExpression value) {
        this.title = value;
    }

    @StiSerializable(type=StiSerializeTypesEnum.SerializeToSaveLoad)
    public StiToolTipExpression getToolTip() {
        return this.toolTip;
    }

    public void setToolTip(StiToolTipExpression value) {
        this.toolTip = value;
    }

    @StiSerializable(type=StiSerializeTypesEnum.SerializeToSaveLoad)
    public StiListOfToolTipsExpression getListOfToolTips() {
        return this.listOfToolTips;
    }

    public void setListOfToolTips(StiListOfToolTipsExpression value) {
        this.listOfToolTips = value;
    }

    @StiSerializable(type=StiSerializeTypesEnum.SerializeToSaveLoad)
    public StiTagExpression getTag() {
        return this.tag;
    }

    public void setTag(StiTagExpression value) {
        this.tag = value;
    }

    @StiSerializable(type=StiSerializeTypesEnum.SerializeToSaveLoad)
    public StiListOfTagsExpression getListOfTags() {
        return this.listOfTags;
    }

    public void setListOfTags(StiListOfTagsExpression value) {
        this.listOfTags = value;
    }

    @StiSerializable(type=StiSerializeTypesEnum.SerializeToSaveLoad)
    public StiHyperlinkExpression getHyperlink() {
        return this.hyperlink;
    }

    public void setHyperlink(StiHyperlinkExpression value) {
        this.hyperlink = value;
    }

    @StiSerializable(type=StiSerializeTypesEnum.SerializeToSaveLoad)
    public StiListOfHyperlinksExpression getListOfHyperlinks() {
        return this.listOfHyperlinks;
    }

    public void setListOfHyperlinks(StiListOfHyperlinksExpression value) {
        this.listOfHyperlinks = value;
    }

    public StiSeries() {
        this.setSeriesLabels(new StiCenterAxisLabels());
        this.setTrendLine(new StiTrendLineNone());
        this.setInteraction(new StiSeriesInteraction());
    }

    public JSONObject SaveToJsonObject(StiJsonSaveMode mode) throws JSONException {
        JSONObject jObject = new JSONObject();
        jObject.AddPropertyIdent("Ident", this.getClass().getName());
        jObject.AddPropertyBool("AllowApplyStyle", this.getAllowApplyStyle(), true);
        jObject.AddPropertyStringNullOfEmpty("Format", this.format);
        jObject.AddPropertyEnum("SortBy", (Enum)this.sortBy, (Enum)StiSeriesSortType.None);
        jObject.AddPropertyEnum("SortDirection", (Enum)this.sortDirection, (Enum)StiSeriesSortDirection.Ascending);
        jObject.AddPropertyBool("ShowInLegend", this.showInLegend, true);
        jObject.AddPropertyEnum("ShowSeriesLabels", (Enum)this.showSeriesLabels, (Enum)StiShowSeriesLabels.FromChart);
        jObject.AddPropertyBool("ShowShadow", this.showShadow, true);
        jObject.AddPropertyEnum("FilterMode", (Enum)this.filterMode, (Enum)StiFilterMode.And);
        jObject.AddPropertyJObject("Filters", this.filters.SaveToJsonObject(mode));
        jObject.AddPropertyJObject("Conditions", this.conditions.SaveToJsonObject(mode));
        jObject.AddPropertyJObject("TopN", this.getTopN().SaveToJsonObject(mode));
        jObject.AddPropertyEnum("YAxis", (Enum)this.yAxis, (Enum)StiSeriesYAxis.LeftYAxis);
        jObject.AddPropertyJObject("SeriesLabels", this.seriesLabels.SaveToJsonObject(mode));
        jObject.AddPropertyJObject("TrendLine", this.getTrendLine().SaveToJsonObject(mode));
        jObject.AddPropertyStringNullOfEmpty("ValueDataColumn", this.getValueDataColumn());
        jObject.AddPropertyStringNullOfEmpty("ArgumentDataColumn", this.argumentDataColumn);
        jObject.AddPropertyStringNullOfEmpty("AutoSeriesTitleDataColumn", this.autoSeriesTitleDataColumn);
        jObject.AddPropertyStringNullOfEmpty("AutoSeriesKeyDataColumn", this.autoSeriesKeyDataColumn);
        jObject.AddPropertyStringNullOfEmpty("AutoSeriesColorDataColumn", this.autoSeriesColorDataColumn);
        jObject.AddPropertyStringNullOfEmpty("ToolTipDataColumn", this.toolTipDataColumn);
        jObject.AddPropertyStringNullOfEmpty("TagDataColumn", this.tagDataColumn);
        jObject.AddPropertyStringNullOfEmpty("HyperlinkDataColumn", this.hyperlinkDataColumn);
        jObject.AddPropertyBool("DrillDownEnabled", this.getDrillDownEnabled());
        jObject.AddPropertyStringNullOfEmpty("DrillDownReport", this.getDrillDownReport());
        jObject.AddPropertyStringNullOfEmpty("DrillDownPageGuid", this.drillDownPageGuid);
        jObject.AddPropertyBool("AllowSeries", this.allowSeries, true);
        jObject.AddPropertyBool("AllowSeriesElements", this.allowSeriesElements, true);
        jObject.AddPropertyJObject("Interaction", this.getInteraction().SaveToJsonObject(mode));
        jObject.AddPropertyJObject("NewAutoSeriesEvent", this.newAutoSeriesEvent.SaveToJsonObject(mode));
        jObject.AddPropertyJObject("GetValueEvent", this.getValueEvent.SaveToJsonObject(mode));
        jObject.AddPropertyJObject("GetListOfValuesEvent", this.getListOfValuesEvent.SaveToJsonObject(mode));
        jObject.AddPropertyJObject("GetArgumentEvent", this.getArgumentEvent.SaveToJsonObject(mode));
        jObject.AddPropertyJObject("GetListOfArgumentsEvent", this.getListOfArgumentsEvent.SaveToJsonObject(mode));
        jObject.AddPropertyJObject("GetTitleEvent", this.getTitleEvent.SaveToJsonObject(mode));
        jObject.AddPropertyJObject("GetToolTipEvent", this.getToolTipEvent.SaveToJsonObject(mode));
        jObject.AddPropertyJObject("GetListOfToolTipsEvent", this.getListOfToolTipsEvent.SaveToJsonObject(mode));
        jObject.AddPropertyJObject("GetTagEvent", this.getTagEvent.SaveToJsonObject(mode));
        jObject.AddPropertyJObject("GetListOfTagsEvent", this.getListOfTagsEvent.SaveToJsonObject(mode));
        jObject.AddPropertyJObject("GetHyperlinkEvent", this.getGetHyperlinkEvent().SaveToJsonObject(mode));
        jObject.AddPropertyJObject("GetListOfHyperlinksEvent", this.getListOfHyperlinksEvent.SaveToJsonObject(mode));
        jObject.AddPropertyJObject("Value", this.getValue().SaveToJsonObject(mode));
        jObject.AddPropertyJObject("ListOfValues", this.getListOfValues().SaveToJsonObject(mode));
        jObject.AddPropertyJObject("Argument", this.getArgument().SaveToJsonObject(mode));
        jObject.AddPropertyJObject("ListOfArguments", this.getListOfArguments().SaveToJsonObject(mode));
        jObject.AddPropertyJObject("Title", this.getTitle().SaveToJsonObject(mode));
        jObject.AddPropertyJObject("ToolTip", this.getToolTip().SaveToJsonObject(mode));
        jObject.AddPropertyJObject("ListOfToolTips", this.getListOfToolTips().SaveToJsonObject(mode));
        jObject.AddPropertyJObject("Tag", this.getTag().SaveToJsonObject(mode));
        jObject.AddPropertyJObject("ListOfTags", this.getListOfTags().SaveToJsonObject(mode));
        jObject.AddPropertyJObject("Hyperlink", this.getHyperlink().SaveToJsonObject(mode));
        jObject.AddPropertyJObject("ListOfHyperlinks", this.getListOfHyperlinks().SaveToJsonObject(mode));
        return jObject;
    }

    public void LoadFromJsonObject(JSONObject jObject) throws JSONException {
        for (JProperty property : jObject.Properties()) {
            StiExpression _expression;
            if (property.Name.equals("AllowApplyStyle")) {
                this.setAllowApplyStyle((Boolean)property.Value);
                continue;
            }
            if (property.Name.equals("Format")) {
                this.format = (String)property.Value;
                continue;
            }
            if (property.Name.equals("SortBy")) {
                this.sortBy = StiSeriesSortType.valueOf((String)property.Value);
                continue;
            }
            if (property.Name.equals("SortDirection")) {
                this.sortDirection = StiSeriesSortDirection.valueOf((String)property.Value);
                continue;
            }
            if (property.Name.equals("ShowInLegend")) {
                this.showInLegend = (Boolean)property.Value;
                continue;
            }
            if (property.Name.equals("ShowSeriesLabels")) {
                this.showSeriesLabels = StiShowSeriesLabels.valueOf((String)property.Value);
                continue;
            }
            if (property.Name.equals("ShowShadow")) {
                this.showShadow = (Boolean)property.Value;
                continue;
            }
            if (property.Name.equals("FilterMode")) {
                this.filterMode = StiFilterMode.valueOf((String)property.Value);
                continue;
            }
            if (property.Name.equals("Filters")) {
                this.filters.LoadFromJsonObject((JSONObject)property.Value);
                continue;
            }
            if (property.Name.equals("Conditions")) {
                this.conditions.LoadFromJsonObject((JSONObject)property.Value);
                continue;
            }
            if (property.Name.equals("TopN")) {
                this.getTopN().LoadFromJsonObject((JSONObject)property.Value);
                continue;
            }
            if (property.Name.equals("YAxis")) {
                this.yAxis = StiSeriesYAxis.valueOf((String)property.Value);
                continue;
            }
            if (property.Name.equals("SeriesLabels")) {
                this.seriesLabels = StiSeriesLabels.LoadFromJsonObjectInternal((JSONObject)property.Value, (StiChart)this.chart);
                continue;
            }
            if (property.Name.equals("TrendLine")) {
                this.setTrendLine(StiTrendLine.LoadFromJsonObjectInternal((JSONObject)property.Value));
                continue;
            }
            if (property.Name.equals("ValueDataColumn")) {
                this.setValueDataColumn((String)property.Value);
                continue;
            }
            if (property.Name.equals("ArgumentDataColumn")) {
                this.argumentDataColumn = (String)property.Value;
                continue;
            }
            if (property.Name.equals("AutoSeriesTitleDataColumn")) {
                this.autoSeriesTitleDataColumn = (String)property.Value;
                continue;
            }
            if (property.Name.equals("AutoSeriesKeyDataColumn")) {
                this.autoSeriesKeyDataColumn = (String)property.Value;
                continue;
            }
            if (property.Name.equals("AutoSeriesColorDataColumn")) {
                this.autoSeriesColorDataColumn = (String)property.Value;
                continue;
            }
            if (property.Name.equals("ToolTipDataColumn")) {
                this.toolTipDataColumn = (String)property.Value;
                continue;
            }
            if (property.Name.equals("TagDataColumn")) {
                this.tagDataColumn = (String)property.Value;
                continue;
            }
            if (property.Name.equals("HyperlinkDataColumn")) {
                this.hyperlinkDataColumn = (String)property.Value;
                continue;
            }
            if (property.Name.equals("DrillDownEnabled")) {
                this.setDrillDownEnabled((Boolean)property.Value);
                continue;
            }
            if (property.Name.equals("DrillDownReport")) {
                this.setDrillDownReport((String)property.Value);
                continue;
            }
            if (property.Name.equals("DrillDownPageGuid")) {
                this.drillDownPageGuid = (String)property.Value;
                continue;
            }
            if (property.Name.equals("AllowSeries")) {
                this.allowSeries = (Boolean)property.Value;
                continue;
            }
            if (property.Name.equals("AllowSeriesElements")) {
                this.allowSeriesElements = (Boolean)property.Value;
                continue;
            }
            if (property.Name.equals("Interaction")) {
                this.getInteraction().LoadFromJsonObject((JSONObject)property.Value);
                continue;
            }
            if (property.Name.equals("NewAutoSeriesEvent")) {
                StiNewAutoSeriesEvent _newAutoSeriesEvent = new StiNewAutoSeriesEvent();
                _newAutoSeriesEvent.LoadFromJsonObject((JSONObject)property.Value);
                this.newAutoSeriesEvent = _newAutoSeriesEvent;
                continue;
            }
            if (property.Name.equals("GetValueEvent")) {
                StiGetValueEvent _getValueEvent = new StiGetValueEvent();
                _getValueEvent.LoadFromJsonObject((JSONObject)property.Value);
                this.getValueEvent = _getValueEvent;
                continue;
            }
            if (property.Name.equals("GetListOfValuesEvent")) {
                StiGetListOfValuesEvent _getListOfValuesEvent = new StiGetListOfValuesEvent();
                _getListOfValuesEvent.LoadFromJsonObject((JSONObject)property.Value);
                this.getListOfValuesEvent = _getListOfValuesEvent;
                continue;
            }
            if (property.Name.equals("GetArgumentEvent")) {
                StiGetArgumentEvent _getArgumentEvent = new StiGetArgumentEvent();
                _getArgumentEvent.LoadFromJsonObject((JSONObject)property.Value);
                this.getArgumentEvent = _getArgumentEvent;
                continue;
            }
            if (property.Name.equals("GetListOfArgumentsEvent")) {
                StiGetListOfArgumentsEvent _getListOfArgumentsEvent = new StiGetListOfArgumentsEvent();
                _getListOfArgumentsEvent.LoadFromJsonObject((JSONObject)property.Value);
                this.getListOfArgumentsEvent = _getListOfArgumentsEvent;
                continue;
            }
            if (property.Name.equals("GetTitleEvent")) {
                StiGetTitleEvent _getTitleEvent = new StiGetTitleEvent();
                _getTitleEvent.LoadFromJsonObject((JSONObject)property.Value);
                this.getTitleEvent = _getTitleEvent;
                continue;
            }
            if (property.Name.equals("GetToolTipEvent")) {
                StiGetToolTipEvent _getToolTipEvent = new StiGetToolTipEvent();
                _getToolTipEvent.LoadFromJsonObject((JSONObject)property.Value);
                this.getToolTipEvent = _getToolTipEvent;
                continue;
            }
            if (property.Name.equals("GetListOfToolTipsEvent")) {
                StiGetListOfToolTipsEvent _getListOfToolTipsEvent = new StiGetListOfToolTipsEvent();
                _getListOfToolTipsEvent.LoadFromJsonObject((JSONObject)property.Value);
                this.getListOfToolTipsEvent = _getListOfToolTipsEvent;
                continue;
            }
            if (property.Name.equals("GetTagEvent")) {
                StiGetTagEvent _getTagEvent = new StiGetTagEvent();
                _getTagEvent.LoadFromJsonObject((JSONObject)property.Value);
                this.getTagEvent = _getTagEvent;
                continue;
            }
            if (property.Name.equals("GetListOfTagsEvent")) {
                StiGetListOfTagsEvent _getListOfTagsEvent = new StiGetListOfTagsEvent();
                _getListOfTagsEvent.LoadFromJsonObject((JSONObject)property.Value);
                this.getListOfTagsEvent = _getListOfTagsEvent;
                continue;
            }
            if (property.Name.equals("GetHyperlinkEvent")) {
                StiGetHyperlinkEvent _getHyperlinkEvent = new StiGetHyperlinkEvent();
                _getHyperlinkEvent.LoadFromJsonObject((JSONObject)property.Value);
                this.setGetHyperlinkEvent(_getHyperlinkEvent);
                continue;
            }
            if (property.Name.equals("GetListOfHyperlinksEvent")) {
                StiGetListOfHyperlinksEvent _getListOfHyperlinksEvent = new StiGetListOfHyperlinksEvent();
                _getListOfHyperlinksEvent.LoadFromJsonObject((JSONObject)property.Value);
                this.getListOfHyperlinksEvent = _getListOfHyperlinksEvent;
                continue;
            }
            if (property.Name.equals("Value")) {
                StiExpression _valueObj = new StiExpression();
                _valueObj.LoadFromJsonObject((JSONObject)property.Value);
                this.setValue(_valueObj);
                continue;
            }
            if (property.Name.equals("ListOfValues")) {
                _expression = new StiListOfValuesExpression();
                _expression.LoadFromJsonObject((JSONObject)property.Value);
                this.setListOfValues((StiListOfValuesExpression)_expression);
                continue;
            }
            if (property.Name.equals("Argument")) {
                StiArgumentExpression _argument = new StiArgumentExpression();
                _argument.LoadFromJsonObject((JSONObject)property.Value);
                this.setArgument(_argument);
                continue;
            }
            if (property.Name.equals("ListOfArguments")) {
                StiListOfArgumentsExpression _listOfArguments = new StiListOfArgumentsExpression();
                _listOfArguments.LoadFromJsonObject((JSONObject)property.Value);
                this.setListOfArguments(_listOfArguments);
                continue;
            }
            if (property.Name.equals("Title")) {
                StiTitleExpression _title = new StiTitleExpression();
                _title.LoadFromJsonObject((JSONObject)property.Value);
                this.setTitle(_title);
                continue;
            }
            if (property.Name.equals("ToolTip")) {
                StiToolTipExpression _toolTip = new StiToolTipExpression();
                _toolTip.LoadFromJsonObject((JSONObject)property.Value);
                this.setToolTip(_toolTip);
                continue;
            }
            if (property.Name.equals("ListOfToolTips")) {
                StiListOfToolTipsExpression _listOfToolTips = new StiListOfToolTipsExpression();
                _listOfToolTips.LoadFromJsonObject((JSONObject)property.Value);
                this.setListOfToolTips(_listOfToolTips);
                continue;
            }
            if (property.Name.equals("Tag")) {
                StiTagExpression _tag = new StiTagExpression();
                _tag.LoadFromJsonObject((JSONObject)property.Value);
                this.setTag(_tag);
                continue;
            }
            if (property.Name.equals("ListOfTags")) {
                StiListOfTagsExpression _listOfTags = new StiListOfTagsExpression();
                _listOfTags.LoadFromJsonObject((JSONObject)property.Value);
                this.setListOfTags(_listOfTags);
                continue;
            }
            if (property.Name.equals("Hyperlink")) {
                StiHyperlinkExpression _hyperlink = new StiHyperlinkExpression();
                _hyperlink.LoadFromJsonObject((JSONObject)property.Value);
                this.setHyperlink(_hyperlink);
                continue;
            }
            if (!property.Name.equals("ListOfHyperlinks")) continue;
            _expression = new StiListOfHyperlinksExpression();
            _expression.LoadFromJsonObject((JSONObject)property.Value);
            this.setListOfHyperlinks((StiListOfHyperlinksExpression)_expression);
        }
    }

    @Override
    public StiBrush ProcessSeriesBrushes(int pointIndex, StiBrush seriesBrush) {
        for (StiChartCondition condition : this.getConditions()) {
            if (!this.GetConditionResult(pointIndex, condition)) continue;
            seriesBrush = this.getAllowApplyStyle() && this.getChart().getStyle() != null ? this.getChart().getStyle().getCore().GetColumnBrush(condition.getColor()) : new StiSolidBrush(condition.getColor());
            if (this.getChart().getArea() instanceof IStiClusteredBarArea) {
                if (seriesBrush instanceof StiGradientBrush) {
                    ((StiGradientBrush)seriesBrush).angle += 90.0;
                }
                if (seriesBrush instanceof StiGlareBrush) {
                    ((StiGlareBrush)seriesBrush).angle += 90.0;
                }
            }
            return seriesBrush;
        }
        return seriesBrush;
    }

    private boolean GetConditionResult(int pointIndex, StiChartCondition condition) {
        if (!(this.getValues() != null && this.getValues().length > pointIndex || this instanceof IStiFinancialSeries)) {
            return false;
        }
        Double itemValue = null;
        Double itemValueEnd = null;
        Double itemValueOpen = null;
        Double itemValueClose = null;
        Double itemValueLow = null;
        Double itemValueHigh = null;
        Object itemArgument = null;
        if (this.chart.getArea() instanceof IStiAxisArea && ((IStiAxisArea)this.chart.getArea()).getReverseHor() && !(this.getChart().getArea() instanceof IStiClusteredBarArea) || this.getChart().getArea() instanceof IStiClusteredBarArea && ((IStiAxisArea)this.chart.getArea()).getReverseVert()) {
            if (this.getValues() != null && pointIndex < this.getValues().length) {
                itemValue = this.getValues()[this.getValues().length - pointIndex - 1];
            }
            if (this instanceof IStiRangeSeries && pointIndex < ((IStiRangeSeries)((Object)this)).getValuesEnd().length) {
                itemValueEnd = ((IStiRangeSeries)((Object)this)).getValuesEnd()[((IStiRangeSeries)((Object)this)).getValuesEnd().length - pointIndex - 1];
            }
            if (this instanceof IStiFinancialSeries) {
                if (pointIndex < ((IStiFinancialSeries)((Object)this)).getValuesOpen().length) {
                    itemValueOpen = ((IStiFinancialSeries)((Object)this)).getValuesOpen()[((IStiFinancialSeries)((Object)this)).getValuesOpen().length - pointIndex - 1];
                }
                if (pointIndex < ((IStiFinancialSeries)((Object)this)).getValuesClose().length) {
                    itemValueClose = ((IStiFinancialSeries)((Object)this)).getValuesClose()[((IStiFinancialSeries)((Object)this)).getValuesClose().length - pointIndex - 1];
                }
                if (pointIndex < ((IStiFinancialSeries)((Object)this)).getValuesLow().length) {
                    itemValueLow = ((IStiFinancialSeries)((Object)this)).getValuesLow()[((IStiFinancialSeries)((Object)this)).getValuesLow().length - pointIndex - 1];
                }
                if (pointIndex < ((IStiFinancialSeries)((Object)this)).getValuesHigh().length) {
                    itemValueHigh = ((IStiFinancialSeries)((Object)this)).getValuesHigh()[((IStiFinancialSeries)((Object)this)).getValuesHigh().length - pointIndex - 1];
                }
            }
            if (this.getArguments() != null && pointIndex < this.getArguments().length) {
                itemArgument = this.getArguments()[this.getArguments().length - pointIndex - 1];
            }
        } else {
            if (this.getValues() != null && pointIndex < this.getValues().length) {
                itemValue = this.getValues()[pointIndex];
            }
            if (this instanceof IStiRangeSeries && pointIndex < ((IStiRangeSeries)((Object)this)).getValuesEnd().length) {
                itemValueEnd = ((IStiRangeSeries)((Object)this)).getValuesEnd()[pointIndex];
            }
            if (this instanceof IStiFinancialSeries) {
                if (pointIndex < ((IStiFinancialSeries)((Object)this)).getValuesOpen().length) {
                    itemValueOpen = ((IStiFinancialSeries)((Object)this)).getValuesOpen()[pointIndex];
                }
                if (pointIndex < ((IStiFinancialSeries)((Object)this)).getValuesClose().length) {
                    itemValueClose = ((IStiFinancialSeries)((Object)this)).getValuesClose()[pointIndex];
                }
                if (pointIndex < ((IStiFinancialSeries)((Object)this)).getValuesLow().length) {
                    itemValueLow = ((IStiFinancialSeries)((Object)this)).getValuesLow()[pointIndex];
                }
                if (pointIndex < ((IStiFinancialSeries)((Object)this)).getValuesHigh().length) {
                    itemValueHigh = ((IStiFinancialSeries)((Object)this)).getValuesHigh()[pointIndex];
                }
            }
            if (this.getArguments() != null && pointIndex < this.getArguments().length) {
                itemArgument = this.getArguments()[pointIndex];
            }
        }
        Object data = StiChartHelper.GetFilterData(null, condition, null);
        return StiChartHelper.GetFilterResult(condition, itemArgument, itemValue, itemValueEnd, itemValueOpen, itemValueClose, itemValueLow, itemValueHigh, data);
    }
}

