/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.report.chart.view.series.stock;

import com.stimulsoft.base.StiJsonReportObjectHelper;
import com.stimulsoft.base.StiJsonSaveMode;
import com.stimulsoft.base.drawing.StiBrush;
import com.stimulsoft.base.drawing.StiColor;
import com.stimulsoft.base.drawing.StiColorEnum;
import com.stimulsoft.base.drawing.enums.StiPenStyle;
import com.stimulsoft.base.json.JProperty;
import com.stimulsoft.base.json.JSONException;
import com.stimulsoft.base.json.JSONObject;
import com.stimulsoft.base.serializing.annotations.StiDefaulValue;
import com.stimulsoft.base.serializing.annotations.StiSerializable;
import com.stimulsoft.report.chart.core.series.stock.StiStockSeriesCoreXF;
import com.stimulsoft.report.chart.interfaces.series.IStiSeries;
import com.stimulsoft.report.chart.interfaces.series.stock.IStiStockSeries;
import com.stimulsoft.report.chart.view.areas.stock.StiStockArea;
import com.stimulsoft.report.chart.view.series.candlestick.StiCandlestickSeries;

public class StiStockSeries
extends StiCandlestickSeries
implements IStiStockSeries {
    private StiColor lineColor = StiColor.Black;
    private StiPenStyle lineStyle = StiPenStyle.Solid;
    private float lineWidth = 2.0f;
    private StiColor lineColorNegative = StiColorEnum.Firebrick.color();
    private boolean allowApplyColorNegative = false;

    @Override
    public IStiSeries clone() {
        IStiSeries tempVar = super.clone();
        IStiStockSeries series = (IStiStockSeries)(tempVar instanceof IStiStockSeries ? tempVar : null);
        return series;
    }

    @Override
    public Class GetDefaultAreaType() {
        return StiStockArea.class;
    }

    @Override
    @StiSerializable(need=false)
    public StiColor getBorderColor() {
        return super.getBorderColor();
    }

    @Override
    public void setBorderColor(StiColor value) {
        super.setBorderColor(value);
    }

    @Override
    @StiSerializable(need=false)
    public float getBorderWidth() {
        return super.getBorderWidth();
    }

    @Override
    public void setBorderWidth(float value) {
        if (value > 0.0f) {
            super.setBorderWidth(value);
        }
    }

    @Override
    @StiSerializable(need=false)
    public StiBrush getBrush() {
        return super.getBrush();
    }

    @Override
    public void setBrush(StiBrush value) {
        super.setBrush(value);
    }

    @Override
    @StiSerializable(need=false)
    public StiBrush getBrushNegative() {
        return super.getBrushNegative();
    }

    @Override
    public void setBrushNegative(StiBrush value) {
        super.setBrushNegative(value);
    }

    @Override
    @StiSerializable
    public StiColor getLineColor() {
        return this.lineColor;
    }

    @Override
    public void setLineColor(StiColor value) {
        this.lineColor = value;
    }

    @Override
    @StiDefaulValue(value="Solid")
    @StiSerializable
    public StiPenStyle getLineStyle() {
        return this.lineStyle;
    }

    @Override
    public void setLineStyle(StiPenStyle value) {
        this.lineStyle = value;
    }

    @Override
    @StiDefaulValue(value="2.0")
    @StiSerializable
    public float getLineWidth() {
        return this.lineWidth;
    }

    @Override
    public void setLineWidth(float value) {
        if (value > 0.0f) {
            this.lineWidth = value;
        }
    }

    @Override
    @StiSerializable
    public StiColor getLineColorNegative() {
        return this.lineColorNegative;
    }

    @Override
    public void setLineColorNegative(StiColor value) {
        this.lineColorNegative = value;
    }

    @Override
    @StiSerializable
    @StiDefaulValue(value="false")
    public boolean getAllowApplyColorNegative() {
        return this.allowApplyColorNegative;
    }

    @Override
    public void setAllowApplyColorNegative(boolean value) {
        this.allowApplyColorNegative = value;
    }

    public StiStockSeries() {
        this.setCore(new StiStockSeriesCoreXF(this));
    }

    @Override
    public JSONObject SaveToJsonObject(StiJsonSaveMode mode) throws JSONException {
        JSONObject jObject = super.SaveToJsonObject(mode);
        jObject.RemoveProperty("BorderColor");
        jObject.RemoveProperty("BorderWidth");
        jObject.RemoveProperty("Brush");
        jObject.RemoveProperty("BrushNegative");
        jObject.AddPropertyStringNullOfEmpty("LineColor", StiJsonReportObjectHelper.Serialize.JColor((StiColor)this.getLineColor(), (StiColorEnum)StiColorEnum.Black));
        jObject.AddPropertyEnum("LineStyle", (Enum)this.getLineStyle(), (Enum)StiPenStyle.Solid);
        jObject.AddPropertyFloat("LineWidth", (double)this.getLineWidth(), 2.0);
        jObject.AddPropertyStringNullOfEmpty("LineColorNegative", StiJsonReportObjectHelper.Serialize.JColor((StiColor)this.getLineColorNegative(), (StiColorEnum)StiColorEnum.Firebrick));
        jObject.AddPropertyBool("AllowApplyColorNegative", this.getAllowApplyColorNegative());
        return jObject;
    }

    @Override
    public void LoadFromJsonObject(JSONObject jObject) throws JSONException {
        super.LoadFromJsonObject(jObject);
        for (JProperty property : jObject.Properties()) {
            if (property.Name.equals("LineColor")) {
                this.setLineColor(StiJsonReportObjectHelper.Deserialize.Color((String)((String)property.Value)));
                continue;
            }
            if (property.Name.equals("LineStyle")) {
                this.setLineStyle(StiPenStyle.valueOf((String)((String)property.Value)));
                continue;
            }
            if (property.Name.equals("LineWidth")) {
                this.setLineWidth(property.floatValue().floatValue());
                continue;
            }
            if (property.Name.equals("LineColorNegative")) {
                this.setLineColorNegative(StiJsonReportObjectHelper.Deserialize.Color((String)((String)property.Value)));
                continue;
            }
            if (!property.Name.equals("AllowApplyColorNegative")) continue;
            this.setAllowApplyColorNegative((Boolean)property.Value);
        }
    }
}

