/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.report.check;

import com.stimulsoft.base.settings.StiSettings;
import com.stimulsoft.base.system.geometry.StiRectangle;
import com.stimulsoft.report.StiReport;
import com.stimulsoft.report.check.StiCheckObjectType;
import com.stimulsoft.report.check.StiCheckStatus;
import com.stimulsoft.report.check.actions.StiAction;
import com.stimulsoft.report.components.StiComponent;
import com.stimulsoft.report.components.StiPage;
import com.stimulsoft.report.enums.StiExportFormat;
import com.stimulsoft.report.painters.StiPainter;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public abstract class StiCheck {
    private Object element = null;
    private List<StiAction> actions = new ArrayList<StiAction>();

    public boolean isDefaultStateEnabled() {
        return true;
    }

    public abstract String getElementName();

    public boolean getEnabled() {
        StiSettings.Load();
        String str = this.getClass().getName().substring(this.getClass().getName().lastIndexOf(46) + 1);
        return StiSettings.getBoolValue((String)"ReportChecks", (String)str, (Boolean)this.isDefaultStateEnabled());
    }

    public void setEnabled(boolean value) {
        if (value != this.getEnabled()) {
            StiSettings.Load();
            String str = this.getClass().getName().substring(this.getClass().getName().lastIndexOf(46) + 1);
            if (!value) {
                StiSettings.setBoolValue((String)"ReportChecks", (String)str, (Boolean)value);
            }
            StiSettings.Save();
        }
    }

    public abstract String getLongMessage();

    public abstract StiCheckObjectType getObjectType();

    public boolean getPreviewVisible() {
        return false;
    }

    public abstract String getShortMessage();

    public abstract StiCheckStatus getStatus();

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    public Map<String, BufferedImage> createPreviewImage() {
        StiComponent comp;
        BufferedImage elementImage = null;
        HashMap<String, BufferedImage> result = new HashMap<String, BufferedImage>();
        StiComponent stiComponent = comp = this.getElement() instanceof StiComponent ? (StiComponent)this.getElement() : null;
        if (comp != null) {
            StiPainter painter;
            double zoom = Math.max(comp.getPage().getDisplayRectangle().getWidth(), comp.getPage().getDisplayRectangle().getHeight());
            zoom = comp.getPage().ConvertToHInches(comp.getPage().getUnit(), zoom);
            zoom = 500.0 / zoom;
            if (this.getElement() instanceof StiPage) {
                painter = StiPainter.getPainter(comp);
                elementImage = painter.getImage(comp, zoom, StiExportFormat.Pdf);
            } else {
                painter = StiPainter.getPainter(comp.getPage());
                elementImage = painter.getImage(comp.getPage(), zoom, StiExportFormat.Pdf);
            }
            result.put("elementImage", elementImage);
            if (!(this.getElement() instanceof StiPage)) {
                painter = StiPainter.getPainter(comp.getPage());
                BufferedImage image = painter.getImage(comp.getPage(), zoom, StiExportFormat.Pdf);
                StiPage page = comp.getPage();
                StiRectangle rect = comp.getPaintRectangle(false, false);
                rect.y += page.getMargins().getTop();
                rect.x += page.getMargins().getLeft();
                StiRectangle pageRect = page.getDisplayRectangle();
                double factorX = (double)image.getWidth() / pageRect.getWidth();
                double factorY = (double)image.getHeight() / pageRect.getHeight();
                rect.x *= factorX;
                rect.y *= factorY;
                rect.width *= factorX;
                rect.height *= factorY;
                image.getGraphics().setColor(new Color(119, 255, 0));
                ((Graphics2D)image.getGraphics()).setStroke(new BasicStroke(3.0f, 0, 0));
                image.getGraphics().drawRect((int)Math.round(rect.x - 2.0), (int)Math.round(rect.y - 2.0), (int)Math.round(rect.width + 3.0), (int)Math.round(rect.height + 3.0));
                result.put("highlightedElementImage", image);
            }
        }
        return result;
    }

    public Object getElement() {
        return this.element;
    }

    public void setElement(Object element) {
        this.element = element;
    }

    public List<StiAction> getActions() {
        return this.actions;
    }

    public void setActions(List<StiAction> actions) {
        this.actions = actions;
    }

    public abstract Object processCheck(StiReport var1, Object var2);

    protected StiCheck() {
    }
}

