/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.report.components.bands;

import com.stimulsoft.base.StiJsonSaveMode;
import com.stimulsoft.base.drawing.StiColor;
import com.stimulsoft.base.drawing.StiColorEnum;
import com.stimulsoft.base.json.JProperty;
import com.stimulsoft.base.json.JSONException;
import com.stimulsoft.base.json.JSONObject;
import com.stimulsoft.base.localization.StiLocalization;
import com.stimulsoft.base.serializing.annotations.StiDefaulValue;
import com.stimulsoft.base.serializing.annotations.StiSerializable;
import com.stimulsoft.base.serializing.annotations.StiSerializeTypesEnum;
import com.stimulsoft.base.system.StiEventHandlerArgs;
import com.stimulsoft.base.system.geometry.StiRectangle;
import com.stimulsoft.lib.utils.StiValidationUtil;
import com.stimulsoft.report.StiOptions;
import com.stimulsoft.report.components.StiComponent;
import com.stimulsoft.report.components.bands.StiDataBand;
import com.stimulsoft.report.components.bands.StiDynamicBand;
import com.stimulsoft.report.components.bands.StiGroupHeaderBandInfoV1;
import com.stimulsoft.report.components.bands.StiGroupHeaderBandInfoV2;
import com.stimulsoft.report.components.complexcomponents.StiContainer;
import com.stimulsoft.report.components.enums.StiComponentPriority;
import com.stimulsoft.report.components.enums.StiComponentToolboxPosition;
import com.stimulsoft.report.components.enums.StiComponentType;
import com.stimulsoft.report.components.enums.StiGroupSortDirection;
import com.stimulsoft.report.components.enums.StiGroupSummaryType;
import com.stimulsoft.report.components.interfaces.IStiGroup;
import com.stimulsoft.report.components.interfaces.IStiKeepGroupTogether;
import com.stimulsoft.report.components.interfaces.IStiPrintOnAllPages;
import com.stimulsoft.report.components.interfaces.IStiStartNewPage;
import com.stimulsoft.report.engine.StiEngineVersion;
import com.stimulsoft.report.engine.engineV2.builders.StiGroupHeaderBandV2Builder;
import com.stimulsoft.report.engine.parser.StiParser;
import com.stimulsoft.report.events.StiBeginRenderEvent;
import com.stimulsoft.report.events.StiEndRenderEvent;
import com.stimulsoft.report.events.StiEvent;
import com.stimulsoft.report.events.StiEventsCollection;
import com.stimulsoft.report.events.StiGetCollapsedEvent;
import com.stimulsoft.report.events.StiGetGroupConditionEvent;
import com.stimulsoft.report.events.StiGetSummaryExpressionEvent;
import com.stimulsoft.report.events.StiRenderingEvent;
import com.stimulsoft.report.events.StiValueEventArgs;
import com.stimulsoft.report.expressions.StiCollapsedExpression;
import com.stimulsoft.report.expressions.StiGroupConditionExpression;
import com.stimulsoft.report.expressions.StiGroupSummaryExpression;
import com.stimulsoft.report.expressions.StiUnifiedExpression;

public class StiGroupHeaderBand
extends StiDynamicBand
implements IStiGroup,
IStiPrintOnAllPages,
IStiKeepGroupTogether,
IStiStartNewPage {
    private boolean keepGroupHeaderTogether = true;
    private boolean keepGroupTogether;
    private boolean startNewPage;
    private StiGroupSortDirection sortDirection = StiGroupSortDirection.Ascending;
    private StiGroupSortDirection summarySortDirection = StiGroupSortDirection.None;
    private StiGroupSummaryType summaryType = StiGroupSummaryType.Sum;
    private boolean printOnAllPages;
    private StiGroupHeaderBandInfoV1 groupHeaderBandInfoV1;
    private StiGroupHeaderBandInfoV2 groupHeaderBandInfoV2;
    public int line = 0;
    private static final Object EventGetSummaryExpression = new Object();
    private static final Object EventGetValue = new Object();
    private static final Object EventGetCollapsed = new Object();
    private static final Object EventBeginRender = new Object();
    private static final Object EventRendering = new Object();
    private static final Object EventEndRender = new Object();

    public StiGroupHeaderBand() {
        this(StiRectangle.empty());
    }

    public StiGroupHeaderBand(StiRectangle rect) {
        super(rect);
        this.setPlaceOnToolbox(true);
    }

    @Override
    @StiDefaulValue(value="false")
    @StiSerializable
    public boolean getCanBreak() {
        return super.getCanBreak();
    }

    @Override
    public void setCanBreak(boolean value) {
        super.setCanBreak(value);
        this.getGroupHeaderBandInfoV1().ForceCanBreak = value;
    }

    @Override
    public boolean getResetPageNumber() {
        return super.getResetPageNumber();
    }

    @Override
    public void setResetPageNumber(boolean value) {
        super.setResetPageNumber(value);
    }

    @StiDefaulValue(value="true")
    @StiSerializable
    public boolean getKeepGroupHeaderTogether() {
        return this.keepGroupHeaderTogether;
    }

    public void setKeepGroupHeaderTogether(boolean value) {
        if (this.keepGroupHeaderTogether != value) {
            this.CheckBlockedException("KeepGroupHeaderTogether");
            this.keepGroupHeaderTogether = value;
        }
    }

    @Override
    @StiDefaulValue(value="false")
    @StiSerializable
    public boolean getKeepGroupTogether() {
        return this.keepGroupTogether;
    }

    @Override
    public void setKeepGroupTogether(boolean value) {
        this.keepGroupTogether = value;
    }

    @Override
    @StiDefaulValue(value="false")
    @StiSerializable
    public boolean getStartNewPage() {
        return this.startNewPage;
    }

    @Override
    public void setStartNewPage(boolean value) {
        this.startNewPage = value;
    }

    @Override
    @StiDefaulValue(value="100.0")
    @StiSerializable
    public float getStartNewPageIfLessThan() {
        return this.getBreakIfLessThan();
    }

    @Override
    public void setStartNewPageIfLessThan(float value) {
        this.setBreakIfLessThan(value);
    }

    @Override
    public void saveState(String stateName) {
        super.saveState(stateName);
        super.getStates().PushInt(stateName, this, "lastPositionRendering", this.getGroupHeaderBandInfoV1().LastPositionRendering);
        super.getStates().PushInt(stateName, this, "lastPositionLineRendering", this.getGroupHeaderBandInfoV1().LastPositionLineRendering);
        super.getStates().PushInt(stateName, this, "line", this.line);
    }

    @Override
    public void RestoreState(String stateName) {
        if (this.getStates().IsExist(stateName, this)) {
            this.getGroupHeaderBandInfoV1().LastPositionRendering = this.getStates().PopInt(stateName, this, "lastPositionRendering");
            this.getGroupHeaderBandInfoV1().LastPositionLineRendering = this.getStates().PopInt(stateName, this, "lastPositionLineRendering");
            this.line = this.getStates().PopInt(stateName, this, "line");
        }
        super.RestoreState(stateName);
    }

    @Override
    @StiDefaulValue(value="Ascending")
    @StiSerializable
    public final StiGroupSortDirection getSortDirection() {
        return this.sortDirection;
    }

    @Override
    public final void setSortDirection(StiGroupSortDirection value) {
        this.sortDirection = value;
    }

    @StiDefaulValue(value="None")
    @StiSerializable
    public final StiGroupSortDirection getSummarySortDirection() {
        if (this.getReport() == null || this.getReport().getEngineVersion() == StiEngineVersion.EngineV1) {
            return StiGroupSortDirection.None;
        }
        return this.summarySortDirection;
    }

    public final void setSummarySortDirection(StiGroupSortDirection value) {
        this.summarySortDirection = value;
    }

    @StiDefaulValue(value="Sum")
    @StiSerializable
    public final StiGroupSummaryType getSummaryType() {
        return this.summaryType;
    }

    public final void setSummaryType(StiGroupSummaryType value) {
        this.summaryType = value;
    }

    @Override
    @StiDefaulValue(value="false")
    @StiSerializable
    public boolean getPrintOnAllPages() {
        return this.printOnAllPages;
    }

    @Override
    public void setPrintOnAllPages(boolean value) {
        this.printOnAllPages = value;
    }

    public final StiGroupHeaderBandInfoV1 getGroupHeaderBandInfoV1() {
        if (this.groupHeaderBandInfoV1 == null) {
            this.groupHeaderBandInfoV1 = new StiGroupHeaderBandInfoV1();
        }
        return this.groupHeaderBandInfoV1;
    }

    public final StiGroupHeaderBandInfoV2 getGroupHeaderBandInfoV2() {
        if (this.groupHeaderBandInfoV2 == null) {
            this.groupHeaderBandInfoV2 = new StiGroupHeaderBandInfoV2();
        }
        return this.groupHeaderBandInfoV2;
    }

    @Override
    public StiDataBand getDataBand() {
        int groupIndex;
        StiContainer obj = this.getParent();
        if (obj == null) {
            return null;
        }
        for (int index = groupIndex = this.getParent().getComponents().indexOf(this) + 1; index < this.getParent().getComponents().size(); ++index) {
            if (!(this.getParent().getComponents().get(index) instanceof StiDataBand)) continue;
            return (StiDataBand)(this.getParent().getComponents().get(index) instanceof StiDataBand ? (StiComponent)this.getParent().getComponents().get(index) : null);
        }
        return null;
    }

    public final int getLine() {
        return this.line;
    }

    public final void setLine(int value) {
        this.line = value;
    }

    @Override
    public StiEventsCollection getEvents() {
        StiEventsCollection events = super.getEvents();
        if (this.getBeginRenderEvent() != null) {
            events.add(this.getBeginRenderEvent());
        }
        if (this.getRenderingEvent() != null) {
            events.add(this.getRenderingEvent());
        }
        if (this.getEndRenderEvent() != null) {
            events.add(this.getEndRenderEvent());
        }
        if (this.getGetValueEvent() != null) {
            events.add(this.getGetValueEvent());
        }
        return events;
    }

    @Override
    public int getToolboxPosition() {
        return StiComponentToolboxPosition.GroupHeaderBand.getValue();
    }

    @Override
    public StiComponentType getComponentType() {
        return StiComponentType.Detail;
    }

    @Override
    public String getLocalizedName() {
        return StiLocalization.Get((String)"Components", (String)"StiGroupHeaderBand");
    }

    @Override
    public int getPriority() {
        return StiComponentPriority.GroupHeaderBand.getValue();
    }

    @Override
    @StiSerializable
    public final StiGroupConditionExpression getCondition() {
        return new StiGroupConditionExpression(this, "Condition");
    }

    @Override
    public final void setCondition(StiGroupConditionExpression value) {
        if (value != null) {
            value.Set(this, "Condition", value.getValue());
        }
    }

    @StiSerializable
    public final StiGroupSummaryExpression getSummaryExpression() {
        return new StiGroupSummaryExpression(this, "SummaryExpression");
    }

    public final void setSummaryExpression(StiGroupSummaryExpression value) {
        if (value != null) {
            value.Set(this, "SummaryExpression", value.getValue());
        }
    }

    @StiSerializable(type=StiSerializeTypesEnum.SerializeToSaveLoad)
    public StiCollapsedExpression getCollapsed() {
        return new StiCollapsedExpression(this, "Collapsed");
    }

    public void setCollapsed(StiCollapsedExpression value) {
        if (value != null) {
            value.Set(this, "Collapsed", value.getValue());
        }
    }

    protected void OnGetSummaryExpression(StiValueEventArgs e) {
    }

    @StiSerializable
    public final StiGetSummaryExpressionEvent getGetSummaryExpressionEvent() {
        return new StiGetSummaryExpressionEvent(this);
    }

    public final void setGetSummaryExpressionEvent(StiGetSummaryExpressionEvent value) {
        if (value != null) {
            value.set(this, value.getScript());
        }
    }

    protected void OnGetValue(StiValueEventArgs e) {
    }

    @StiSerializable
    public final StiGetGroupConditionEvent getGetValueEvent() {
        return new StiGetGroupConditionEvent(this);
    }

    public final void setGetValueEvent(StiGetGroupConditionEvent value) {
        if (value != null) {
            value.set(this, value.getScript());
        }
    }

    protected void OnGetCollapsed(StiValueEventArgs e) {
    }

    @StiSerializable
    public final StiGetCollapsedEvent getGetCollapsedEvent() {
        return new StiGetCollapsedEvent(this);
    }

    public final void setGetCollapsedEvent(StiGetCollapsedEvent value) {
        if (value != null) {
            value.set(this, value.getScript());
        }
    }

    protected void OnBeginRender(StiEventHandlerArgs e) {
        if (this.getReport() == null || this.getReport().getEngineVersion() != StiEngineVersion.EngineV1 || this.getResetPageNumber()) {
            // empty if block
        }
    }

    @StiSerializable
    public final StiBeginRenderEvent getBeginRenderEvent() {
        return new StiBeginRenderEvent(this);
    }

    public final void setBeginRenderEvent(StiBeginRenderEvent value) {
        if (value != null) {
            value.set(this, value.getScript());
        }
    }

    protected void OnRendering(StiEventHandlerArgs e) {
    }

    @StiSerializable
    public final StiRenderingEvent getRenderingEvent() {
        return new StiRenderingEvent(this);
    }

    public final void setRenderingEvent(StiRenderingEvent value) {
        if (value != null) {
            value.set(this, value.getScript());
        }
    }

    protected void OnEndRender(StiEventHandlerArgs e) {
    }

    @StiSerializable
    public final StiEndRenderEvent getEndRenderEvent() {
        return new StiEndRenderEvent(this);
    }

    public final void setEndRenderEvent(StiEndRenderEvent value) {
        if (value != null) {
            value.set(this, value.getScript());
        }
    }

    @Override
    public String GetHeaderText() {
        String str = null;
        str = this.getAlias() == null || this.getAlias().length() == 0 ? this.getName() : (StiOptions.Dictionary.getShowOnlyAliasForVariable() ? this.getAlias() : this.getName() + " [" + this.getAlias() + "]");
        return str + "; " + StiLocalization.Get((String)"PropertyMain", (String)"Condition") + ": " + this.getCondition().getValue();
    }

    @Override
    public StiColor getHeaderStartColor() {
        return StiColor.create((StiColorEnum)StiColorEnum.Bisque);
    }

    @Override
    public StiColor getHeaderEndColor() {
        return StiColor.create((StiColorEnum)StiColorEnum.Orange);
    }

    public void InvokeGetCollapsed(StiValueEventArgs e) {
        block3: {
            try {
                this.OnGetCollapsed(e);
                if (this.getReport() != null && StiValidationUtil.isNotNullOrEmpty((String)this.getCollapsed().getValue())) {
                    e.setValue(StiParser.ParseTextValue(this.getCollapsed().getValue(), this));
                }
            }
            catch (Exception ee) {
                if (StiOptions.Engine.logLevel < 10) break block3;
                ee.printStackTrace();
            }
        }
    }

    public final void InvokeGetSummaryExpression(StiValueEventArgs e) {
        block2: {
            try {
                this.OnGetSummaryExpression(e);
                e.setValue(StiParser.ParseTextValue(this.getSummaryExpression().getValue(), this));
            }
            catch (Exception e1) {
                if (StiOptions.Engine.logLevel < 10) break block2;
                e1.printStackTrace();
            }
        }
    }

    public final void InvokeGetValue(StiValueEventArgs e) {
        block2: {
            try {
                this.OnGetValue(e);
                e.setValue(StiParser.ParseTextValue(this.getCondition().getValue(), this));
            }
            catch (Exception e1) {
                if (StiOptions.Engine.logLevel < 10) break block2;
                e1.printStackTrace();
            }
        }
    }

    public final Object GetCurrentConditionValue() {
        return StiGroupHeaderBandV2Builder.GetCurrentConditionValue(this);
    }

    @Override
    public JSONObject SaveToJsonObject(StiJsonSaveMode mode) throws JSONException {
        JSONObject jObject = super.SaveToJsonObject(mode);
        jObject.AddPropertyBool("CanBreak", this.getCanBreak());
        jObject.AddPropertyBool("KeepGroupHeaderTogether", this.getKeepGroupHeaderTogether(), true);
        jObject.AddPropertyBool("KeepGroupTogether", this.getKeepGroupTogether());
        jObject.AddPropertyBool("StartNewPage", this.getStartNewPage());
        jObject.AddPropertyFloat("StartNewPageIfLessThan", (double)this.getStartNewPageIfLessThan(), 100.0);
        jObject.AddPropertyEnum("SortDirection", (Enum)this.getSortDirection(), (Enum)StiGroupSortDirection.Ascending);
        jObject.AddPropertyEnum("SummarySortDirection", (Enum)this.getSummarySortDirection(), (Enum)StiGroupSortDirection.None);
        jObject.AddPropertyEnum("SummaryType", (Enum)this.getSummaryType(), (Enum)StiGroupSummaryType.Sum);
        jObject.AddPropertyBool("PrintOnAllPages", this.getPrintOnAllPages());
        jObject.AddPropertyJObject("Condition", this.getCondition().SaveToJsonObject(mode));
        jObject.AddPropertyJObject("SummaryExpression", this.getSummaryExpression().SaveToJsonObject(mode));
        jObject.AddPropertyJObject("GetSummaryExpressionEvent", this.getGetSummaryExpressionEvent().SaveToJsonObject(mode));
        jObject.AddPropertyJObject("GetValueEvent", this.getGetValueEvent().SaveToJsonObject(mode));
        jObject.AddPropertyJObject("GetCollapsedEvent", this.getGetCollapsedEvent().SaveToJsonObject(mode));
        jObject.AddPropertyJObject("BeginRenderEvent", this.getBeginRenderEvent().SaveToJsonObject(mode));
        jObject.AddPropertyJObject("RenderingEvent", this.getRenderingEvent().SaveToJsonObject(mode));
        jObject.AddPropertyJObject("EndRenderEvent", this.getEndRenderEvent().SaveToJsonObject(mode));
        if (mode == StiJsonSaveMode.Report) {
            jObject.AddPropertyJObject("Collapsed", this.getCollapsed().SaveToJsonObject(mode));
        }
        return jObject;
    }

    @Override
    public void LoadFromJsonObject(JSONObject jObject) throws JSONException {
        super.LoadFromJsonObject(jObject);
        for (JProperty property : jObject.Properties()) {
            StiEvent _event;
            StiUnifiedExpression _expression;
            if (property.Name.equals("KeepGroupHeaderTogether")) {
                this.keepGroupHeaderTogether = (Boolean)property.Value;
                continue;
            }
            if (property.Name.equals("KeepGroupTogether")) {
                this.keepGroupTogether = (Boolean)property.Value;
                continue;
            }
            if (property.Name.equals("StartNewPage")) {
                this.startNewPage = (Boolean)property.Value;
                continue;
            }
            if (property.Name.equals("StartNewPageIfLessThan")) {
                this.setStartNewPageIfLessThan(property.floatValue().floatValue());
                continue;
            }
            if (property.Name.equals("SortDirection")) {
                this.sortDirection = StiGroupSortDirection.valueOf((String)property.Value);
                continue;
            }
            if (property.Name.equals("SummarySortDirection")) {
                this.summarySortDirection = StiGroupSortDirection.valueOf((String)property.Value);
                continue;
            }
            if (property.Name.equals("SummaryType")) {
                this.summaryType = StiGroupSummaryType.valueOf((String)property.Value);
                continue;
            }
            if (property.Name.equals("PrintOnAllPages")) {
                this.printOnAllPages = (Boolean)property.Value;
                continue;
            }
            if (property.Name.equals("Condition")) {
                _expression = new StiGroupConditionExpression();
                _expression.LoadFromJsonObject((JSONObject)property.Value);
                this.setCondition((StiGroupConditionExpression)_expression);
                continue;
            }
            if (property.Name.equals("SummaryExpression")) {
                _expression = new StiGroupSummaryExpression();
                _expression.LoadFromJsonObject((JSONObject)property.Value);
                this.setSummaryExpression((StiGroupSummaryExpression)_expression);
                continue;
            }
            if (property.Name.equals("Collapsed")) {
                _expression = new StiCollapsedExpression();
                _expression.LoadFromJsonObject((JSONObject)property.Value);
                this.setCollapsed((StiCollapsedExpression)_expression);
                continue;
            }
            if (property.Name.equals("GetSummaryExpressionEvent")) {
                _event = new StiGetSummaryExpressionEvent();
                _event.LoadFromJsonObject((JSONObject)property.Value);
                this.setGetSummaryExpressionEvent((StiGetSummaryExpressionEvent)_event);
                continue;
            }
            if (property.Name.equals("GetValueEvent")) {
                _event = new StiGetGroupConditionEvent();
                _event.LoadFromJsonObject((JSONObject)property.Value);
                this.setGetValueEvent((StiGetGroupConditionEvent)_event);
                continue;
            }
            if (property.Name.equals("GetCollapsedEvent")) {
                _event = new StiGetCollapsedEvent();
                _event.LoadFromJsonObject((JSONObject)property.Value);
                this.setGetCollapsedEvent((StiGetCollapsedEvent)_event);
                continue;
            }
            if (property.Name.equals("BeginRenderEvent")) {
                _event = new StiBeginRenderEvent();
                _event.LoadFromJsonObject((JSONObject)property.Value);
                this.setBeginRenderEvent((StiBeginRenderEvent)_event);
                continue;
            }
            if (property.Name.equals("RenderingEvent")) {
                _event = new StiRenderingEvent();
                _event.LoadFromJsonObject((JSONObject)property.Value);
                this.setRenderingEvent((StiRenderingEvent)_event);
                continue;
            }
            if (!property.Name.equals("EndRenderEvent")) continue;
            _event = new StiEndRenderEvent();
            _event.LoadFromJsonObject((JSONObject)property.Value);
            this.setEndRenderEvent((StiEndRenderEvent)_event);
        }
    }
}

