/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.report.components.conditions;

import com.stimulsoft.base.IStiEnum;
import com.stimulsoft.base.StiEnumSet;
import com.stimulsoft.base.StiJsonReportObjectHelper;
import com.stimulsoft.base.StiJsonSaveMode;
import com.stimulsoft.base.drawing.StiColor;
import com.stimulsoft.base.drawing.StiColorEnum;
import com.stimulsoft.base.json.JProperty;
import com.stimulsoft.base.json.JSONException;
import com.stimulsoft.base.json.JSONObject;
import com.stimulsoft.base.serializing.StiDeserializerControler;
import com.stimulsoft.base.serializing.StiSerializerControler;
import com.stimulsoft.base.serializing.annotations.StiDefaulValue;
import com.stimulsoft.base.serializing.annotations.StiSerializable;
import com.stimulsoft.base.serializing.interfaceobject.IStiSerializable;
import com.stimulsoft.base.system.StiFont;
import com.stimulsoft.report.components.StiFiltersCollection;
import com.stimulsoft.report.components.conditions.StiCondition;
import com.stimulsoft.report.components.conditions.StiFilter;
import com.stimulsoft.report.components.enums.StiConditionBorderSides;
import com.stimulsoft.report.components.enums.StiConditionPermissions;
import com.stimulsoft.report.components.enums.StiFilterCondition;
import com.stimulsoft.report.components.enums.StiFilterDataType;
import com.stimulsoft.report.components.enums.StiFilterItem;
import com.stimulsoft.report.components.enums.StiFilterMode;
import com.stimulsoft.report.components.interfaces.IStiFilter;
import com.stimulsoft.report.events.StiFilterEventHandler;
import com.stimulsoft.report.expressions.StiExpression;
import java.text.MessageFormat;

public class StiMultiCondition
extends StiCondition
implements IStiFilter {
    private static final String ERROR_MESSAGE = "Please, use Filters collection!";
    private StiFilterMode filterMode = StiFilterMode.And;
    public StiFiltersCollection filters = new StiFiltersCollection();

    public StiMultiCondition() {
    }

    public StiMultiCondition(StiColor textColor, StiColor backColor, StiFont font, boolean enabled, StiFilterMode filterMode) {
        this(textColor, backColor, font, enabled, filterMode, false, "");
    }

    public StiMultiCondition(StiColor textColor, StiColor backColor, StiFont font, boolean enabled, StiFilterMode filterMode, boolean canAssignExpression, String assignExpression) {
        this(textColor, backColor, font, enabled, filterMode, null, canAssignExpression, assignExpression);
    }

    public StiMultiCondition(StiColor textColor, StiColor backColor, StiFont font, boolean enabled, StiFilterMode filterMode, StiFilter[] filters) {
        this(textColor, backColor, font, enabled, filterMode, filters, false, "");
    }

    public StiMultiCondition(StiColor textColor, StiColor backColor, StiFont font, boolean enabled, StiFilterMode filterMode, StiFilter[] filters, String style, StiEnumSet<StiConditionBorderSides> borderSides) {
        this(textColor, backColor, font, enabled, filterMode, filters, false, "");
        this.setStyle(style);
        this.setBorderSides(borderSides);
    }

    public StiMultiCondition(StiColor textColor, StiColor backColor, StiFont font, boolean enabled, StiFilterMode filterMode, StiFilter[] filters, boolean canAssignExpression, String assignExpression) {
        this(textColor, backColor, font, enabled, filterMode, filters, canAssignExpression, assignExpression, "", (StiEnumSet<StiConditionBorderSides>)StiEnumSet.of((Enum)StiConditionBorderSides.NotAssigned));
    }

    public StiMultiCondition(StiColor textColor, StiColor backColor, StiFont font, boolean enabled, StiFilterMode filterMode, StiFilter[] filters, boolean canAssignExpression, String assignExpression, String style, StiEnumSet<StiConditionBorderSides> borderSides) {
        super("", textColor, backColor, font, enabled, canAssignExpression, assignExpression);
        this.setStyle(style);
        this.setBorderSides(borderSides);
        this.filterMode = filterMode;
        if (filters != null) {
            for (StiFilter filter : filters) {
                this.filters.add(filter);
            }
        }
    }

    @Override
    public Object clone() {
        StiCondition condition = (StiCondition)super.clone();
        return condition;
    }

    @Override
    @StiDefaulValue(value="And")
    @StiSerializable
    public final StiFilterMode getFilterMode() {
        return this.filterMode;
    }

    @Override
    public final void setFilterMode(StiFilterMode value) {
        this.filterMode = value;
    }

    @Override
    @StiSerializable
    public final StiFiltersCollection getFilters() {
        return this.filters;
    }

    @Override
    public final void setFilters(StiFiltersCollection value) {
        this.filters = value;
    }

    @Override
    @StiSerializable(need=false)
    public final StiFilterEventHandler getFilterMethodHandler() {
        return null;
    }

    @Override
    public final void setFilterMethodHandler(StiFilterEventHandler value) {
    }

    @Override
    @StiSerializable(need=false)
    public final boolean getFilterOn() {
        return true;
    }

    @Override
    public final void setFilterOn(boolean value) {
    }

    @Override
    @StiSerializable(need=false)
    public StiFilterCondition getCondition() {
        throw new RuntimeException(ERROR_MESSAGE);
    }

    @Override
    public void setCondition(StiFilterCondition value) {
        throw new RuntimeException(ERROR_MESSAGE);
    }

    @Override
    @StiSerializable(need=false)
    public StiFilterDataType getDataType() {
        throw new RuntimeException(ERROR_MESSAGE);
    }

    @Override
    public void setDataType(StiFilterDataType value) {
        throw new RuntimeException(ERROR_MESSAGE);
    }

    @Override
    @StiSerializable(need=false)
    public String getColumn() {
        throw new RuntimeException(ERROR_MESSAGE);
    }

    @Override
    public void setColumn(String value) {
        throw new RuntimeException(ERROR_MESSAGE);
    }

    @Override
    @StiSerializable(need=false)
    public StiFilterItem getItem() {
        throw new RuntimeException(ERROR_MESSAGE);
    }

    @Override
    public void setItem(StiFilterItem value) {
        throw new RuntimeException(ERROR_MESSAGE);
    }

    @Override
    @StiSerializable(need=false)
    public String getValue1() {
        throw new RuntimeException(ERROR_MESSAGE);
    }

    @Override
    public void setValue1(String value) {
        throw new RuntimeException(ERROR_MESSAGE);
    }

    @Override
    @StiSerializable(need=false)
    public String getValue2() {
        throw new RuntimeException(ERROR_MESSAGE);
    }

    @Override
    public void setValue2(String value) {
        throw new RuntimeException(ERROR_MESSAGE);
    }

    @Override
    @StiSerializable(need=false)
    public StiExpression getExpression() {
        throw new RuntimeException(ERROR_MESSAGE);
    }

    @Override
    public void setExpression(StiExpression value) {
        throw new RuntimeException(ERROR_MESSAGE);
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        StiMultiCondition condition = (StiMultiCondition)(obj instanceof StiMultiCondition ? obj : null);
        if (condition == null) {
            return false;
        }
        return this.getBackColor().equals(condition.getBackColor()) && this.getTextColor().equals(condition.getTextColor()) && new Boolean(this.getEnabled()).equals(condition.getEnabled()) && this.getFont().equals((Object)condition.getFont()) && this.getFilterMode().equals((Object)condition.getFilterMode()) && this.getFilters().equals(condition.getFilters()) && new Boolean(this.getCanAssignExpression()).equals(condition.getCanAssignExpression()) && this.getAssignExpression().equals(condition.getAssignExpression());
    }

    @Override
    public String serialize() {
        String data = StiSerializerControler.serializedObjectAsString((IStiSerializable)this);
        return MessageFormat.format("Multi{0}", data);
    }

    @Override
    public void deserialize(String strObject) {
        String xmlString = strObject.substring("Multi".length());
        StiDeserializerControler.deserializeFromString((String)xmlString, (IStiSerializable)this);
    }

    @Override
    public JSONObject SaveToJsonObject(StiJsonSaveMode mode) throws JSONException {
        JSONObject jObject = new JSONObject();
        jObject.AddPropertyIdent("Ident", this.getClass().getName());
        jObject.AddPropertyBool("Enabled", this.getEnabled(), true);
        jObject.AddPropertyStringNullOfEmpty("TextColor", StiJsonReportObjectHelper.Serialize.jColor((StiColor)this.getTextColor(), (StiColor)StiColorEnum.Red.color()));
        jObject.AddPropertyStringNullOfEmpty("BackColor", StiJsonReportObjectHelper.Serialize.jColor((StiColor)this.getBackColor(), (StiColor)StiColorEnum.Transparent.color()));
        jObject.AddPropertyStringNullOfEmpty("Font", StiJsonReportObjectHelper.Serialize.fontDefault((StiFont)this.getFont()));
        jObject.AddPropertyBool("CanAssignExpression", this.getCanAssignExpression());
        jObject.AddPropertyStringNullOfEmpty("Style", this.getStyle());
        jObject.AddPropertyEnum("BorderSides", this.getBorderSides(), (IStiEnum)StiConditionBorderSides.NotAssigned);
        jObject.AddPropertyEnum("Permissions", this.getPermissions(), (IStiEnum)StiConditionPermissions.All);
        jObject.AddPropertyEnum("FilterMode", (Enum)this.getFilterMode(), (Enum)StiFilterMode.And);
        jObject.AddPropertyJObject("Filters", this.getFilters().SaveToJsonObject(mode));
        return jObject;
    }

    @Override
    public void LoadFromJsonObject(JSONObject jObject) throws JSONException {
        super.LoadFromJsonObject(jObject);
        for (JProperty property : jObject.Properties()) {
            if (property.Name.equals("FilterMode")) {
                this.filterMode = StiFilterMode.valueOf((String)property.Value);
                continue;
            }
            if (!property.Name.equals("Filters")) continue;
            this.filters.LoadFromJsonObject((JSONObject)property.Value);
        }
    }
}

