/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.report.components.simplecomponents;

import com.stimulsoft.base.StiJsonSaveMode;
import com.stimulsoft.base.drawing.StiBrush;
import com.stimulsoft.base.drawing.StiColor;
import com.stimulsoft.base.drawing.StiColorEnum;
import com.stimulsoft.base.drawing.StiSolidBrush;
import com.stimulsoft.base.drawing.enums.StiBorderSides;
import com.stimulsoft.base.drawing.enums.StiPenStyle;
import com.stimulsoft.base.drawing.enums.StiTextHorAlignment;
import com.stimulsoft.base.drawing.enums.StiVertAlignment;
import com.stimulsoft.base.json.JProperty;
import com.stimulsoft.base.json.JSONException;
import com.stimulsoft.base.json.JSONObject;
import com.stimulsoft.base.localization.StiLocalization;
import com.stimulsoft.base.serializing.annotations.StiDefaulValue;
import com.stimulsoft.base.serializing.annotations.StiSerializable;
import com.stimulsoft.base.system.StiSize;
import com.stimulsoft.base.system.geometry.StiRectangle;
import com.stimulsoft.base.utils.StiMath;
import com.stimulsoft.lib.utils.StiStringUtil;
import com.stimulsoft.lib.utils.StiValidationUtil;
import com.stimulsoft.report.StiDpiHelper;
import com.stimulsoft.report.components.StiComponent;
import com.stimulsoft.report.components.complexcomponents.StiContainer;
import com.stimulsoft.report.components.enums.StiComponentToolboxPosition;
import com.stimulsoft.report.components.enums.StiProcessingDuplicatesType;
import com.stimulsoft.report.components.enums.StiTextQuality;
import com.stimulsoft.report.components.simplecomponents.StiText;
import com.stimulsoft.report.components.simplecomponents.StiTextInCellsHelper;
import com.stimulsoft.report.enums.StiExportFormat;
import com.stimulsoft.report.expressions.StiExcelValueExpression;
import com.stimulsoft.report.units.StiUnit;
import java.util.ArrayList;

public class StiTextInCells
extends StiText {
    protected static Object PropertyCellWidth = new Object();
    protected static Object PropertyCellHeight = new Object();
    protected static Object PropertyHorSpacing = new Object();
    protected static Object PropertyVertSpacing = new Object();
    protected static Object PropertyContinuousText = new Object();

    @Override
    @StiSerializable(need=false)
    public StiVertAlignment getVertAlignment() {
        return super.getVertAlignment();
    }

    @Override
    public void setVertAlignment(StiVertAlignment value) {
        super.setVertAlignment(value);
    }

    @Override
    public boolean isExportAsImage(StiExportFormat format) {
        if (format == StiExportFormat.ImageSvg || format == StiExportFormat.ImagePng) {
            return true;
        }
        return super.isExportAsImage(format);
    }

    @Override
    public void convert(StiUnit oldUnit, StiUnit newUnit) {
        super.convert(oldUnit, newUnit);
        this.setCellWidth((float)newUnit.ConvertFromHInches(oldUnit.ConvertToHInches(this.getCellWidth())));
        this.setCellHeight((float)newUnit.ConvertFromHInches(oldUnit.ConvertToHInches(this.getCellHeight())));
        this.setHorSpacing((float)newUnit.ConvertFromHInches(oldUnit.ConvertToHInches(this.getHorSpacing())));
        this.setVertSpacing((float)newUnit.ConvertFromHInches(oldUnit.ConvertToHInches(this.getVertSpacing())));
    }

    @Override
    @StiSerializable(need=false)
    public boolean getAutoWidth() {
        return super.getAutoWidth();
    }

    @Override
    public void setAutoWidth(boolean value) {
        super.setAutoWidth(value);
    }

    @Override
    @StiSerializable(need=false)
    public boolean getCanGrow() {
        return super.getCanGrow();
    }

    @Override
    public void setCanGrow(boolean value) {
        super.setCanGrow(value);
    }

    @Override
    @StiSerializable(need=false)
    public boolean getCanShrink() {
        return super.getCanShrink();
    }

    @Override
    public void setCanShrink(boolean value) {
        super.setCanShrink(value);
    }

    @Override
    @StiSerializable(need=false)
    public boolean getAllowHtmlTags() {
        return super.getAllowHtmlTags();
    }

    @Override
    public void setAllowHtmlTags(boolean value) {
        super.setAllowHtmlTags(value);
    }

    @Override
    @StiSerializable(need=false)
    public boolean getShrinkFontToFit() {
        return super.getShrinkFontToFit();
    }

    @Override
    public void setShrinkFontToFit(boolean value) {
        super.setShrinkFontToFit(value);
    }

    @Override
    @StiSerializable(need=false)
    public float getShrinkFontToFitMinimumSize() {
        return super.getShrinkFontToFitMinimumSize();
    }

    @Override
    public void setShrinkFontToFitMinimumSize(float value) {
        super.setShrinkFontToFitMinimumSize(value);
    }

    @Override
    @StiSerializable(need=false)
    public float getAngle() {
        return super.getAngle();
    }

    @Override
    public void setAngle(float value) {
        super.setAngle(value);
    }

    @Override
    @StiSerializable(need=false)
    public StiPenStyle getLinesOfUnderline() {
        return super.getLinesOfUnderline();
    }

    @Override
    public void setLinesOfUnderline(StiPenStyle value) {
        super.setLinesOfUnderline(value);
    }

    @Override
    public int getMaxNumberOfLines() {
        return super.getMaxNumberOfLines();
    }

    @Override
    public void setMaxNumberOfLines(int value) {
        super.setMaxNumberOfLines(value);
    }

    @Override
    public StiProcessingDuplicatesType getProcessingDuplicates() {
        return super.getProcessingDuplicates();
    }

    @Override
    public void setProcessingDuplicates(StiProcessingDuplicatesType value) {
        super.setProcessingDuplicates(value);
    }

    @Override
    public String getRenderTo() {
        return super.getRenderTo();
    }

    @Override
    public void setRenderTo(String value) {
        super.setRenderTo(value);
    }

    @Override
    public int getToolboxPosition() {
        return StiComponentToolboxPosition.TextInCells.getValue();
    }

    @Override
    public String getLocalizedCategory() {
        return StiLocalization.get((String)"Report", (String)"Components");
    }

    @Override
    public String getLocalizedName() {
        return StiLocalization.get((String)"Components", (String)"StiTextInCells");
    }

    @StiSerializable
    @StiDefaulValue(value="0.0")
    public float getCellWidth() {
        return this.properties().getFloat(PropertyCellWidth, 0.0f);
    }

    public void setCellWidth(float value) {
        this.properties().setFloat(PropertyCellWidth, value, 0.0f);
    }

    @StiSerializable
    @StiDefaulValue(value="0.0")
    public float getCellHeight() {
        return this.properties().getFloat(PropertyCellHeight, 0.0f);
    }

    public void setCellHeight(float value) {
        this.properties().setFloat(PropertyCellHeight, value, 0.0f);
    }

    @StiSerializable
    @StiDefaulValue(value="0.0")
    public float getHorSpacing() {
        return this.properties().getFloat(PropertyHorSpacing, 0.0f);
    }

    public void setHorSpacing(float value) {
        this.properties().setFloat(PropertyHorSpacing, value, 0.0f);
    }

    @StiSerializable
    @StiDefaulValue(value="0.0")
    public float getVertSpacing() {
        return this.properties().getFloat(PropertyVertSpacing, 0.0f);
    }

    public void setVertSpacing(float value) {
        this.properties().setFloat(PropertyVertSpacing, value, 0.0f);
    }

    @Override
    @StiSerializable(need=false)
    public StiTextQuality getTextQuality() {
        return super.getTextQuality();
    }

    @Override
    public void setTextQuality(StiTextQuality value) {
        super.setTextQuality(value);
    }

    @Override
    @StiSerializable
    @StiDefaulValue(value="false")
    public boolean getWordWrap() {
        return this.getTextOptions().getWordWrap();
    }

    @Override
    public void setWordWrap(boolean value) {
        this.getTextOptions().setWordWrap(value);
    }

    @StiSerializable
    @StiDefaulValue(value="false")
    public final boolean getRightToLeft() {
        return this.getTextOptions().getRightToLeft();
    }

    public final void setRightToLeft(boolean value) {
        this.getTextOptions().setRightToLeft(value);
    }

    @StiSerializable
    @StiDefaulValue(value="true")
    public boolean getContinuousText() {
        return this.properties().getBool(PropertyContinuousText, true);
    }

    public void setContinuousText(boolean value) {
        this.properties().setBool(PropertyContinuousText, value, true);
    }

    @Override
    public StiExcelValueExpression getExcelValue() {
        return super.getExcelValue();
    }

    @Override
    public void setExcelValue(StiExcelValueExpression value) {
        super.setExcelValue(value);
    }

    public StiTextInCells() {
        this(StiRectangle.empty(), "");
    }

    public StiTextInCells(StiRectangle rect) {
        this(rect, "");
    }

    public StiTextInCells(StiRectangle rect, String text) {
        super(rect);
        this.setTextBrush((StiBrush)new StiSolidBrush(StiColorEnum.Black));
        this.setBrush((StiBrush)new StiSolidBrush(StiColorEnum.White));
        this.getBorder().setSide(StiBorderSides.All);
        this.getBorder().setColor(new StiColor(StiColorEnum.Black));
        this.getBorder().setSize(2.0);
        this.SetTextInternal(text);
    }

    public static StiContainer splitByCells(StiTextInCells masterTextInCells, StiComponent renderedComponent, String textString) {
        return StiTextInCells.splitByCells(masterTextInCells, renderedComponent, textString, false);
    }

    public static StiContainer splitByCells(StiTextInCells masterTextInCells, StiComponent renderedComponent, String textString, boolean measure) {
        StiContainer cont = new StiContainer();
        cont.setClientRectangle(renderedComponent.getClientRectangle());
        cont.setName(renderedComponent.getName());
        cont.setCanGrow(renderedComponent.getCanGrow());
        StiRectangle rect = cont.getClientRectangle();
        rect.x = 0.0;
        rect.y = 0.0;
        StiUnit unit = masterTextInCells.getPage().getUnit();
        double borderSize = unit.ConvertFromHInches(masterTextInCells.getBorder().getSize() / 2.0 * masterTextInCells.getPage().getZoom());
        double horSpacing = masterTextInCells.getHorSpacing();
        double vertSpacing = masterTextInCells.getVertSpacing();
        double cellWidth = masterTextInCells.getCellWidth();
        double cellHeight = masterTextInCells.getCellHeight();
        if (masterTextInCells.getCellWidth() == 0.0f) {
            cellWidth = unit.ConvertFromHInches(masterTextInCells.getFont().getHeight() * 1.5 * StiDpiHelper.DeviceCapsScale());
        }
        if (masterTextInCells.getCellHeight() == 0.0f) {
            cellHeight = unit.ConvertFromHInches(masterTextInCells.getFont().getHeight() * 1.5 * StiDpiHelper.DeviceCapsScale());
        }
        if (!masterTextInCells.getContinuousText()) {
            StiSize textSize = new StiSize(1, 1);
            double posX = (float)(rect.x + borderSize + cellWidth);
            while (posX + horSpacing + cellWidth < rect.getRight()) {
                posX += horSpacing + cellWidth;
                textSize.width += 1.0;
            }
            double posY = (float)(rect.y + borderSize + cellHeight);
            while (posY + vertSpacing + cellHeight < rect.getBottom()) {
                posY += vertSpacing + cellHeight;
                textSize.height += 1.0;
            }
            if (!masterTextInCells.getWordWrap()) {
                textSize.height = 1.0;
            }
            ArrayList<String> stringList = new ArrayList<String>();
            String st = "";
            if (textString != null) {
                for (int i = 0; i < textString.length(); ++i) {
                    char ch = textString.charAt(i);
                    if (Character.isISOControl(ch)) {
                        if (ch != '\n') continue;
                        stringList.add(StiTextInCellsHelper.TrimEndWhiteSpace(st));
                        st = "";
                        continue;
                    }
                    st = st + ch;
                }
            }
            if (!StiValidationUtil.isEmpty((String)st)) {
                stringList.add(StiTextInCellsHelper.TrimEndWhiteSpace(st));
            }
            if (stringList.size() == 0) {
                stringList.add(st);
            }
            if (masterTextInCells.getWordWrap()) {
                for (int indexLine = 0; indexLine < stringList.size(); ++indexLine) {
                    String stt = (String)stringList.get(indexLine);
                    if (!((double)stt.length() > textSize.width)) continue;
                    int[] wordarr = new int[stt.length()];
                    int wordCounter = 0;
                    for (int tempIndexSpace = 0; tempIndexSpace < stt.length() && Character.isWhitespace(stt.charAt(tempIndexSpace)); ++tempIndexSpace) {
                        wordarr[tempIndexSpace] = wordCounter;
                    }
                    for (int tempIndex = tempIndexSpace; tempIndex < stt.length(); ++tempIndex) {
                        if (Character.isWhitespace(stt.charAt(tempIndex))) {
                            // empty if block
                        }
                        wordarr[tempIndex] = ++wordCounter;
                    }
                    int index = (int)textSize.width;
                    int index2 = index - 1;
                    if (wordarr[index] > 0) {
                        if (wordarr[index] != wordarr[index2]) {
                            while (Character.isWhitespace(stt.charAt(index))) {
                                ++index;
                            }
                        } else {
                            while (!Character.isWhitespace(stt.charAt(index))) {
                                --index;
                            }
                            index2 = index++;
                            while (Character.isWhitespace(stt.charAt(index))) {
                                --index2;
                            }
                        }
                    }
                    stringList.set(indexLine, stt.substring(0, index2 + 1));
                    stringList.add(indexLine + 1, stt.substring(index, stt.length()));
                }
            }
            if (measure && masterTextInCells.getCanGrow()) {
                textSize.height = stringList.size();
            }
            posY = (float)(rect.y + borderSize);
            int indexY = 0;
            while ((double)indexY < textSize.height) {
                String currentLineText = indexY < stringList.size() ? (String)stringList.get(indexY) : "";
                double textOffset = 0.0;
                if (masterTextInCells.getHorAlignment() == StiTextHorAlignment.Center) {
                    textOffset = (textSize.width - (double)currentLineText.length()) / 2.0;
                }
                if (masterTextInCells.getHorAlignment() == StiTextHorAlignment.Right) {
                    textOffset = textSize.width - (double)currentLineText.length();
                }
                if (textOffset > 0.0) {
                    currentLineText = StiStringUtil.createCopies((char)' ', (int)((int)textOffset)) + currentLineText;
                }
                posX = (float)(rect.x + borderSize);
                int indexX = 0;
                while ((double)indexX < textSize.width) {
                    double cx = StiMath.round((double)posX, (int)2);
                    double cy = StiMath.round((double)posY, (int)2);
                    double cw = StiMath.round((double)(posX + cellWidth), (int)2) - cx;
                    double ch = StiMath.round((double)(posY + cellHeight), (int)2) - cy;
                    StiRectangle sectorRect = new StiRectangle(cx, cy, cw, ch);
                    StiText text = (StiText)renderedComponent.clone();
                    text.setClientRectangle(sectorRect);
                    text.setHorAlignment(StiTextHorAlignment.Center);
                    text.setVertAlignment(StiVertAlignment.Center);
                    text.setWordWrap(false);
                    cont.getComponents().add(text);
                    String cellText = "";
                    int indexText = (int)(masterTextInCells.getRightToLeft() ? textSize.width - (double)indexX - 1.0 : (double)indexX);
                    if (indexText < currentLineText.length()) {
                        cellText = StiStringUtil.createCopies((char)currentLineText.charAt(indexText), (int)1);
                    }
                    text.SetTextInternal(cellText);
                    posX += cellWidth + horSpacing;
                    ++indexX;
                }
                posY += cellHeight + vertSpacing;
                ++indexY;
            }
        } else {
            double posX = rect.x + borderSize;
            double posY = rect.y + borderSize;
            boolean first = true;
            int index = 0;
            while (true) {
                double ch;
                double cw;
                double cy;
                double cx;
                StiRectangle sectorRect;
                if ((sectorRect = new StiRectangle(cx = StiMath.round((double)posX, (int)2), cy = StiMath.round((double)posY, (int)2), cw = StiMath.round((double)(posX + cellWidth), (int)2) - cx, ch = StiMath.round((double)(posY + cellHeight), (int)2) - cy)).getRight() + horSpacing < rect.getRight() || first) {
                    StiText text = (StiText)renderedComponent.clone();
                    text.setClientRectangle(sectorRect);
                    text.setHorAlignment(StiTextHorAlignment.Center);
                    text.setVertAlignment(StiVertAlignment.Center);
                    text.setWordWrap(false);
                    cont.getComponents().add(text);
                    String cellText = "";
                    if (textString != null && index < textString.length()) {
                        cellText = StiStringUtil.createCopies((char)textString.charAt(index), (int)1);
                    }
                    text.SetTextInternal(cellText);
                    posX += cellWidth + horSpacing;
                    ++index;
                    first = false;
                    continue;
                }
                posX = (double)((float)rect.x) + borderSize;
                first = true;
                if (!masterTextInCells.getWordWrap() || (measure && masterTextInCells.canGrow ? index >= textString.length() : rect.getBottom() < (posY += cellHeight + vertSpacing) + cellHeight + vertSpacing)) break;
            }
        }
        return cont;
    }

    public String getTextForPaint() {
        if (this.getReport() == null || this.isDesigning()) {
            // empty if block
        }
        return this.getTextInternal();
    }

    @Override
    public JSONObject SaveToJsonObject(StiJsonSaveMode mode) throws JSONException {
        JSONObject jObject = super.SaveToJsonObject(mode);
        jObject.RemoveProperty("VertAlignment");
        jObject.RemoveProperty("AutoWidth");
        jObject.RemoveProperty("CanShrink");
        jObject.RemoveProperty("AllowHtmlTags");
        jObject.RemoveProperty("ShrinkFontToFit");
        jObject.RemoveProperty("ShrinkFontToFitMinimumSize");
        jObject.RemoveProperty("Angle");
        jObject.RemoveProperty("LinesOfUnderline");
        jObject.RemoveProperty("MaxNumberOfLines");
        jObject.RemoveProperty("ProcessingDuplicates");
        jObject.RemoveProperty("RenderTo");
        jObject.RemoveProperty("TextQuality");
        jObject.RemoveProperty("ExcelValue");
        jObject.AddPropertyFloat("CellWidth", (double)this.getCellWidth(), 0.0);
        jObject.AddPropertyFloat("CellHeight", (double)this.getCellHeight(), 0.0);
        jObject.AddPropertyFloat("HorSpacing", (double)this.getHorSpacing(), 0.0);
        jObject.AddPropertyFloat("VertSpacing", (double)this.getVertSpacing(), 0.0);
        jObject.AddPropertyBool("WordWrap", this.getWordWrap());
        jObject.AddPropertyBool("RightToLeft", this.getRightToLeft());
        jObject.AddPropertyBool("ContinuousText", this.getContinuousText(), true);
        return jObject;
    }

    @Override
    public void LoadFromJsonObject(JSONObject jObject) throws JSONException {
        super.LoadFromJsonObject(jObject);
        for (JProperty property : jObject.Properties()) {
            if (property.Name.equals("CellWidth")) {
                this.setCellWidth(property.floatValue().floatValue());
                continue;
            }
            if (property.Name.equals("CellHeight")) {
                this.setCellHeight(property.floatValue().floatValue());
                continue;
            }
            if (property.Name.equals("HorSpacing")) {
                this.setHorSpacing(property.floatValue().floatValue());
                continue;
            }
            if (property.Name.equals("VertSpacing")) {
                this.setVertSpacing(property.floatValue().floatValue());
                continue;
            }
            if (property.Name.equals("WordWrap")) {
                this.setWordWrap((Boolean)property.Value);
                continue;
            }
            if (property.Name.equals("RightToLeft")) {
                this.setRightToLeft((Boolean)property.Value);
                continue;
            }
            if (!property.Name.equals("ContinuousText")) continue;
            this.setContinuousText((Boolean)property.Value);
        }
    }
}

