/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.report.components.table;

import com.stimulsoft.base.StiEnumSet;
import com.stimulsoft.base.StiJsonReportObjectHelper;
import com.stimulsoft.base.StiJsonSaveMode;
import com.stimulsoft.base.json.JProperty;
import com.stimulsoft.base.json.JSONException;
import com.stimulsoft.base.json.JSONObject;
import com.stimulsoft.base.serializing.annotations.StiDefaulValue;
import com.stimulsoft.base.serializing.annotations.StiSerializable;
import com.stimulsoft.base.system.StiRefObject;
import com.stimulsoft.base.system.StiSize;
import com.stimulsoft.base.system.geometry.StiRectangle;
import com.stimulsoft.lib.utils.StiValidationUtil;
import com.stimulsoft.report.components.StiComponent;
import com.stimulsoft.report.components.enums.StiDockStyle;
import com.stimulsoft.report.components.enums.StiRestrictions;
import com.stimulsoft.report.components.simplecomponents.StiCheckBox;
import com.stimulsoft.report.components.table.IStiTableCell;
import com.stimulsoft.report.components.table.IStiTableComponent;
import com.stimulsoft.report.components.table.StiTable;
import com.stimulsoft.report.components.table.enums.StiTablceCellType;
import java.util.ArrayList;

public class StiTableCellCheckBox
extends StiCheckBox
implements IStiTableCell,
IStiTableComponent {
    private StiDockStyle cellDockStyle = StiDockStyle.None;
    private StiComponent parentJoinCell = null;
    public ArrayList<Integer> joinCells = new ArrayList();
    public int parentJoin = -1;
    public boolean join = false;
    private int id = -1;
    private int joinWidth = 0;
    private int joinHeight = 0;
    private Object tableTag = null;
    private StiTablceCellType cellType = StiTablceCellType.CheckBox;
    private boolean fixedWidth = false;
    private int column = 0;

    @Override
    public Object clone(boolean cloneProperties) {
        StiTableCellCheckBox cloneCell = (StiTableCellCheckBox)super.clone(cloneProperties);
        cloneCell.join = this.join;
        cloneCell.setMinSize(new StiSize(0, 0));
        cloneCell.setMaxSize(new StiSize(0, 0));
        cloneCell.joinWidth = this.joinWidth;
        cloneCell.cellDockStyle = this.cellDockStyle;
        cloneCell.joinHeight = this.joinHeight;
        cloneCell.cellType = this.cellType;
        cloneCell.column = this.column;
        cloneCell.fixedWidth = this.fixedWidth;
        cloneCell.id = this.id;
        cloneCell.joinCells = (ArrayList)this.joinCells.clone();
        cloneCell.parentJoin = this.parentJoin != -1 ? this.parentJoin : -1;
        return cloneCell;
    }

    @Override
    public StiDockStyle getDockStyle() {
        return super.getDockStyle();
    }

    @Override
    public void setDockStyle(StiDockStyle value) {
        super.setDockStyle(value);
    }

    @Override
    public StiEnumSet<StiRestrictions> getRestrictions() {
        return super.getRestrictions();
    }

    @Override
    public void setRestrictions(StiEnumSet<StiRestrictions> value) {
        super.setRestrictions(value);
    }

    @Override
    public double getLeft() {
        return super.getLeft();
    }

    @Override
    public void setLeft(double value) {
        super.setLeft(value);
    }

    @Override
    public double getTop() {
        return super.getTop();
    }

    @Override
    public void setTop(double value) {
        super.setTop(value);
    }

    @Override
    public double getWidth() {
        return super.getWidth();
    }

    @Override
    public void setWidth(double value) {
        super.setWidth(value);
    }

    @Override
    public double getHeight() {
        return super.getHeight();
    }

    @Override
    public void setHeight(double value) {
        super.setHeight(value);
    }

    @Override
    public StiSize getMinSize() {
        return super.getMinSize();
    }

    @Override
    public void setMinSize(StiSize value) {
        super.setMinSize(value);
    }

    @Override
    public StiSize getMaxSize() {
        return super.getMaxSize();
    }

    @Override
    public void setMaxSize(StiSize value) {
        super.setMaxSize(value);
    }

    @Override
    @StiSerializable(need=false)
    public boolean getLocked() {
        return this.getIsDesigning() && !this.getReport().getIsPageDesigner();
    }

    @Override
    public void setLocked(boolean value) {
    }

    @Override
    @StiSerializable(need=false)
    public boolean getLinked() {
        return this.getIsDesigning() && !this.getReport().getIsPageDesigner();
    }

    @Override
    public void setLinked(boolean value) {
    }

    @Override
    public boolean getCanShrink() {
        return false;
    }

    @Override
    public void setCanShrink(boolean value) {
    }

    @Override
    public boolean getGrowToHeight() {
        return super.getGrowToHeight();
    }

    @Override
    public void setGrowToHeight(boolean value) {
        super.setGrowToHeight(value);
    }

    @Override
    @StiSerializable
    @StiDefaulValue(value="None")
    public final StiDockStyle getCellDockStyle() {
        return this.cellDockStyle;
    }

    @Override
    public final void setCellDockStyle(StiDockStyle value) {
        this.cellDockStyle = value;
    }

    @Override
    @StiSerializable(need=false)
    public final StiComponent getParentJoinCell() {
        return this.parentJoinCell;
    }

    @Override
    public final void setParentJoinCell(StiComponent value) {
        this.parentJoinCell = value;
    }

    @Override
    @StiSerializable
    public final ArrayList<Integer> getJoinCells() {
        return this.joinCells;
    }

    @Override
    public final void setJoinCells(ArrayList<Integer> value) {
        this.joinCells = value;
    }

    @Override
    @StiDefaulValue(value="-1")
    @StiSerializable
    public final int getParentJoin() {
        return this.parentJoin;
    }

    @Override
    public final void setParentJoin(int value) {
        this.parentJoin = value;
    }

    @Override
    @StiDefaulValue(value="false")
    @StiSerializable
    public final boolean getJoin() {
        return this.join;
    }

    @Override
    public final void setJoin(boolean value) {
        if (this.join != value) {
            if (value) {
                this.CreateJoin();
                this.join = true;
            } else {
                this.DeleteJoin();
                this.join = false;
            }
        }
    }

    @Override
    @StiDefaulValue(value="-1")
    @StiSerializable
    public final int getID() {
        return this.id;
    }

    @Override
    public final void setID(int value) {
        this.id = value;
    }

    @Override
    @StiDefaulValue(value="0")
    @StiSerializable
    public final int getJoinWidth() {
        return this.joinWidth;
    }

    @Override
    public final void setJoinWidth(int value) {
        this.joinWidth = value;
    }

    @Override
    @StiDefaulValue(value="0")
    @StiSerializable
    public final int getJoinHeight() {
        return this.joinHeight;
    }

    @Override
    public final void setJoinHeight(int value) {
        this.joinHeight = value;
    }

    @Override
    public final boolean getMerged() {
        return this.parentJoin != -1;
    }

    @Override
    public final boolean getChangeTopPosition() {
        if (this.getParent() != null) {
            int index = this.getParent().getComponents().indexOf(this);
            return index >= ((StiTable)this.getParent()).getColumnCount();
        }
        return false;
    }

    @Override
    public final boolean getChangeLeftPosition() {
        if (this.getParent() != null) {
            int index = this.getParent().getComponents().indexOf(this);
            for (int findIndex = 0; findIndex < this.getParent().getComponents().size(); findIndex += ((StiTable)this.getParent()).getColumnCount()) {
                if (findIndex != index) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    public final boolean getChangeRightPosition() {
        int index = this.getParent().getComponents().indexOf(this);
        for (int findIndex = ((StiTable)this.getParent()).getColumnCount() - 1; findIndex < this.getParent().getComponents().size(); findIndex += ((StiTable)this.getParent()).getColumnCount()) {
            if (findIndex != index) continue;
            return false;
        }
        return true;
    }

    @Override
    @StiSerializable(need=false)
    public final Object getTableTag() {
        return this.tableTag;
    }

    @Override
    public final void setTableTag(Object value) {
        this.tableTag = value;
    }

    @Override
    @StiDefaulValue(value="CheckBox")
    @StiSerializable
    public final StiTablceCellType getCellType() {
        return this.cellType;
    }

    @Override
    public final void setCellType(StiTablceCellType value) {
        if (this.cellType != value) {
            this.cellType = value;
            StiTable table = (StiTable)(this.getParent() instanceof StiTable ? this.getParent() : null);
            if (table != null) {
                switch (value) {
                    case Text: {
                        table.ChangeTableCellContentInText(this);
                        break;
                    }
                    case Image: {
                        table.ChangeTableCellContentInImage(this);
                        break;
                    }
                    case RichText: {
                        table.ChangeTableCellContentInRichText(this);
                    }
                }
            }
        }
    }

    @Override
    @StiDefaulValue(value="false")
    @StiSerializable
    public final boolean getFixedWidth() {
        return this.fixedWidth;
    }

    @Override
    public final void setFixedWidth(boolean value) {
        this.fixedWidth = value;
    }

    @Override
    @StiSerializable(need=false)
    public final int getColumn() {
        return this.column;
    }

    @Override
    public final void setColumn(int value) {
        this.column = value;
    }

    @Override
    public final StiComponent GetJoinComponentByGuid(int id) {
        if (this.getParent() == null && this.joinCells.size() == 0) {
            return null;
        }
        for (StiComponent cell : this.getParent().getComponents()) {
            if (((IStiTableCell)((Object)cell)).getID() != id) continue;
            return cell;
        }
        return null;
    }

    @Override
    public final StiComponent GetJoinComponentByIndex(int index) {
        if (index < 0 && this.getParent() == null && this.joinCells.size() == 0 && index >= this.joinCells.size()) {
            return null;
        }
        for (StiComponent cell : this.getParent().getComponents()) {
            if (((IStiTableCell)((Object)cell)).getID() != this.joinCells.get(index).intValue()) continue;
            return cell;
        }
        return null;
    }

    @Override
    public final boolean ContainsGuid(int id) {
        if (this.joinCells.size() == 0) {
            return false;
        }
        for (int index1 = 0; index1 < this.joinCells.size(); ++index1) {
            if (this.joinCells.get(index1) != id) continue;
            return true;
        }
        return false;
    }

    private void CreateJoin() {
        StiTable table = (StiTable)(this.getParent() instanceof StiTable ? this.getParent() : null);
        if (table == null && this.getPage() == null) {
            return;
        }
        double sumWidth = 0.0;
        double sumHeight = 0.0;
        StiRefObject tempRefsumWidth = new StiRefObject((Object)sumWidth);
        StiRefObject tempRefsumHeight = new StiRefObject((Object)sumHeight);
        StiRefObject tempRefjoinWidth = new StiRefObject((Object)this.joinWidth);
        StiRefObject tempRefjoinHeight = new StiRefObject((Object)this.joinHeight);
        this.joinCells = table.createJoin((StiRefObject<Double>)tempRefsumWidth, (StiRefObject<Double>)tempRefsumHeight, (StiRefObject<Integer>)tempRefjoinWidth, (StiRefObject<Integer>)tempRefjoinHeight);
        sumWidth = (Double)tempRefsumWidth.argvalue;
        sumHeight = (Double)tempRefsumHeight.argvalue;
        this.joinWidth = (Integer)tempRefjoinWidth.argvalue;
        this.joinHeight = (Integer)tempRefjoinHeight.argvalue;
        if (StiValidationUtil.isEmpty(this.joinCells)) {
            return;
        }
        double valueLeft = 0.0;
        double valueTop = 0.0;
        for (int index = 0; index < this.joinCells.size() - 1; ++index) {
            StiComponent cell = this.GetJoinComponentByIndex(index);
            if (index == 0) {
                valueLeft = cell.getLeft();
                valueTop = cell.getTop();
            }
            cell.setEnabled(false);
            ((IStiTableCell)((Object)cell)).setParentJoin(this.id);
        }
        this.parentJoin = this.id;
        this.setClientRectangle(new StiRectangle(valueLeft, valueTop, sumWidth, sumHeight));
    }

    private void DeleteJoin() {
        if (this.getPage() == null && this.joinCells.size() == 0) {
            return;
        }
        for (int index = 0; index < this.joinCells.size() - 1; ++index) {
            StiComponent cell = this.GetJoinComponentByIndex(index);
            cell.setEnabled(true);
            ((IStiTableCell)((Object)cell)).setParentJoin(-1);
        }
        this.setClientRectangle(this.GetNewClientRectangle());
        this.joinCells = new ArrayList();
        this.parentJoin = -1;
        this.joinWidth = 0;
        this.joinHeight = 0;
    }

    private StiRectangle GetNewClientRectangle() {
        StiComponent cell = this.GetJoinComponentByIndex(this.joinCells.size() - 2);
        int index = this.getParent().getComponents().indexOf(cell);
        int thisIndex = this.getParent().getComponents().indexOf(this);
        if (thisIndex - index == 1) {
            return new StiRectangle(cell.getRight(), cell.getTop(), this.getRight() - cell.getRight(), cell.getHeight());
        }
        return new StiRectangle(cell.getLeft(), cell.getBottom(), cell.getWidth(), this.getBottom() - cell.getBottom());
    }

    @Override
    public final void SetJoinSize() {
        if (!this.join) {
            return;
        }
        StiComponent cell = this.GetJoinComponentByIndex(0);
        double left = cell.getLeft();
        double top = cell.getTop();
        this.setClientRectangle(new StiRectangle(left, top, this.getRight() - left, this.getBottom() - top));
    }

    @Override
    public final double GetRealHeightAfterInsertRows() {
        if (this.join) {
            if (this.joinHeight == 1) {
                return super.getHeight();
            }
            double sumHeight = 0.0;
            int firstNumberRow = this.getParent().getComponents().indexOf(this.GetJoinComponentByIndex(0)) / ((StiTable)this.getParent()).getColumnCount();
            int lastNumberRow = this.getParent().getComponents().indexOf(this) / ((StiTable)this.getParent()).getColumnCount();
            for (int indexRow = firstNumberRow; indexRow < lastNumberRow; ++indexRow) {
                int indexCell = indexRow * ((StiTable)this.getParent()).getColumnCount();
                sumHeight += ((StiComponent)this.getParent().getComponents().get(indexCell)).getHeight();
            }
            return super.getHeight() - sumHeight;
        }
        return super.getHeight();
    }

    @Override
    public final double GetRealHeight() {
        if (this.join) {
            StiComponent cell = this.GetJoinComponentByIndex(this.joinCells.size() - 2);
            int thisIndex = this.getParent().getComponents().indexOf(this);
            int index = this.getParent().getComponents().indexOf(cell);
            if (((StiTable)this.getParent()).getColumnCount() > 1) {
                if (thisIndex - index == 1) {
                    return cell.getHeight();
                }
                return super.getBottom() - cell.getBottom();
            }
            return super.getBottom() - cell.getBottom();
        }
        return super.getHeight();
    }

    @Override
    public final double GetRealTop() {
        if (this.join) {
            StiComponent cell = this.GetJoinComponentByIndex(this.joinCells.size() - 2);
            int thisIndex = this.getParent().getComponents().indexOf(this);
            int index = this.getParent().getComponents().indexOf(cell);
            if (((StiTable)this.getParent()).getColumnCount() > 1) {
                if (thisIndex - index == 1) {
                    return cell.getTop();
                }
                return cell.getBottom();
            }
            return cell.getBottom();
        }
        return super.getTop();
    }

    @Override
    public final double GetRealWidth() {
        if (this.join) {
            StiComponent cell = this.GetJoinComponentByIndex(this.joinCells.size() - 2);
            int thisIndex = this.getParent().getComponents().indexOf(this);
            int index = this.getParent().getComponents().indexOf(cell);
            if (((StiTable)this.getParent()).getRowCount() > 1) {
                if (thisIndex - index == 1) {
                    return this.getRight() - cell.getRight();
                }
                return cell.getWidth();
            }
            return this.getRight() - cell.getRight();
        }
        return super.getWidth();
    }

    @Override
    public final double GetRealLeft() {
        if (this.join) {
            StiComponent cell = this.GetJoinComponentByIndex(this.joinCells.size() - 2);
            int thisIndex = this.getParent().getComponents().indexOf(this);
            int index = this.getParent().getComponents().indexOf(cell);
            if (((StiTable)this.getParent()).getRowCount() > 1) {
                if (thisIndex - index == 1) {
                    return cell.getRight();
                }
                return cell.getLeft();
            }
            return cell.getRight();
        }
        return this.getLeft();
    }

    @Override
    public JSONObject SaveToJsonObject(StiJsonSaveMode mode) throws JSONException {
        JSONObject jObject = super.SaveToJsonObject(mode);
        jObject.RemoveProperty("Locked");
        jObject.RemoveProperty("Linked");
        jObject.AddPropertyEnum("CellDockStyle", (Enum)this.getCellDockStyle(), (Enum)StiDockStyle.None);
        jObject.AddPropertyJObject("JoinCells", StiJsonReportObjectHelper.Serialize.IntArray(this.getJoinCells()));
        jObject.AddPropertyInt("ParentJoin", this.getParentJoin(), -1);
        jObject.AddPropertyBool("Join", this.getJoin());
        jObject.AddPropertyInt("ID", this.getID(), -1);
        jObject.AddPropertyInt("JoinWidth", this.getJoinWidth());
        jObject.AddPropertyInt("JoinHeight", this.getJoinHeight());
        jObject.AddPropertyEnum("CellType", (Enum)this.getCellType(), (Enum)StiTablceCellType.CheckBox);
        jObject.AddPropertyBool("FixedWidth", this.getFixedWidth());
        return jObject;
    }

    @Override
    public void LoadFromJsonObject(JSONObject jObject) throws JSONException {
        super.LoadFromJsonObject(jObject);
        for (JProperty property : jObject.Properties()) {
            if (property.Name.equals("CellDockStyle")) {
                this.cellDockStyle = StiDockStyle.valueOf((String)property.Value);
                continue;
            }
            if (property.Name.equals("JoinCells")) {
                this.joinCells = StiJsonReportObjectHelper.Deserialize.IntArrayList((JSONObject)((JSONObject)property.Value));
                continue;
            }
            if (property.Name.equals("ParentJoin")) {
                this.parentJoin = (Integer)property.Value;
                continue;
            }
            if (property.Name.equals("Join")) {
                this.join = (Boolean)property.Value;
                continue;
            }
            if (property.Name.equals("ID")) {
                this.id = (Integer)property.Value;
                continue;
            }
            if (property.Name.equals("JoinWidth")) {
                this.joinWidth = (Integer)property.Value;
                continue;
            }
            if (property.Name.equals("JoinHeight")) {
                this.joinHeight = (Integer)property.Value;
                continue;
            }
            if (property.Name.equals("CellType")) {
                this.cellType = StiTablceCellType.valueOf((String)property.Value);
                continue;
            }
            if (!property.Name.equals("FixedWidth")) continue;
            this.fixedWidth = (Boolean)property.Value;
        }
    }
}

