/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.report.components.textFormats;

import com.stimulsoft.base.StiJsonSaveMode;
import com.stimulsoft.base.json.JProperty;
import com.stimulsoft.base.json.JSONException;
import com.stimulsoft.base.json.JSONObject;
import com.stimulsoft.base.localization.StiLocalization;
import com.stimulsoft.base.serializing.annotations.StiDefaulValue;
import com.stimulsoft.base.serializing.annotations.StiSerializable;
import com.stimulsoft.base.system.StiDateTime;
import com.stimulsoft.report.components.textFormats.StiFormatService;
import com.stimulsoft.report.dictionary.data.DBNull;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;

public class StiDateFormatService
extends StiFormatService {
    private String nullDisplay = " ";

    public StiDateFormatService() {
        this("d", " ");
    }

    public StiDateFormatService(String stringFormat, String nullDisplay) {
        this.setStringFormat(stringFormat);
        this.nullDisplay = nullDisplay;
    }

    public String getServiceName() {
        return StiLocalization.Get((String)"FormFormatEditor", (String)"Date");
    }

    @Override
    public int getPosition() {
        return 4;
    }

    @Override
    public Object getSample() {
        return new Date();
    }

    @Override
    @StiDefaulValue(value="d")
    @StiSerializable
    public String getStringFormat() {
        return super.getStringFormat();
    }

    @Override
    public void setStringFormat(String value) {
        super.setStringFormat(value);
    }

    @StiDefaulValue(value=" ")
    @StiSerializable
    public final String getNullDisplay() {
        return this.nullDisplay;
    }

    public final void setNullDisplay(String value) {
        this.nullDisplay = value;
    }

    @Override
    public String getNativeFormatString() {
        return "{0:" + StiLocalization.Get((String)"Formats", (String)"date11") + "}";
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.nullDisplay == null ? 0 : this.nullDisplay.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        StiDateFormatService other = (StiDateFormatService)((Object)obj);
        return !(this.nullDisplay == null ? other.nullDisplay != null : !this.nullDisplay.equals(other.nullDisplay));
    }

    @Override
    public String format(String stringFormat, Object arg, Locale locale) {
        if (arg == null || arg instanceof DBNull) {
            return this.getNullDisplay();
        }
        if (arg instanceof Date) {
            return new StiDateTime((Date)arg).format(stringFormat);
        }
        if (arg instanceof Calendar) {
            return new StiDateTime((Calendar)arg).format(stringFormat);
        }
        if (arg instanceof StiDateTime) {
            return ((StiDateTime)arg).format(stringFormat);
        }
        return arg.toString();
    }

    @Override
    public JSONObject SaveToJsonObject(StiJsonSaveMode mode) throws JSONException {
        JSONObject jObject = super.SaveToJsonObject(mode);
        jObject.AddPropertyString("StringFormat", this.getStringFormat(), "d");
        jObject.AddPropertyString("NullDisplay", this.getNullDisplay(), " ");
        return jObject;
    }

    @Override
    public void LoadFromJsonObject(JSONObject jObject) throws JSONException {
        super.LoadFromJsonObject(jObject);
        for (JProperty property : jObject.Properties()) {
            if (!property.Name.equals("NullDisplay")) continue;
            this.nullDisplay = (String)property.Value;
        }
    }
}

