/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.report.components.textFormats;

import com.stimulsoft.base.StiJsonSaveMode;
import com.stimulsoft.base.json.JSONException;
import com.stimulsoft.base.json.JSONObject;
import com.stimulsoft.base.localization.StiLocalization;
import com.stimulsoft.base.serializing.annotations.StiSerializable;
import com.stimulsoft.report.components.textFormats.StiFormatService;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Locale;

public class StiGeneralFormatService
extends StiFormatService {
    public static StiGeneralFormatService Default = new StiGeneralFormatService();
    private static DecimalFormat DECIMAL_FORMAT = new DecimalFormat("#.###########################");

    public StiGeneralFormatService() {
        this.setStringFormat("");
    }

    public String getServiceName() {
        return StiLocalization.getValue((String)"FormFormatEditor", (String)"General");
    }

    @Override
    public String Format(Object arg, Locale locale) {
        if (arg != null && arg instanceof Number) {
            if (arg instanceof Double || arg instanceof BigDecimal || arg instanceof BigInteger) {
                return super.Format(DECIMAL_FORMAT.format(arg), locale);
            }
            if (arg instanceof Float) {
                return super.Format(new BigDecimal(((Float)arg).floatValue()).toString(), locale);
            }
            if (arg instanceof Integer) {
                return super.Format(new BigDecimal((Integer)arg).toString(), locale);
            }
            if (arg instanceof Long) {
                return super.Format(new BigDecimal((Long)arg).toString(), locale);
            }
            return super.Format(new BigDecimal(((Short)arg).shortValue()).toString(), locale);
        }
        return super.Format(arg, locale);
    }

    @Override
    public int getPosition() {
        return 1;
    }

    @Override
    public Object getSample() {
        return StiLocalization.getValue((String)"FormFormatEditor", (String)"SampleText");
    }

    @Override
    @StiSerializable(need=false)
    public String getStringFormat() {
        return super.getStringFormat();
    }

    @Override
    public void setStringFormat(String value) {
        super.setStringFormat(value);
    }

    @Override
    public boolean equals(Object obj) {
        StiGeneralFormatService format = (StiGeneralFormatService)((Object)(obj instanceof StiGeneralFormatService ? obj : null));
        return format != null;
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }

    @Override
    public JSONObject SaveToJsonObject(StiJsonSaveMode mode) throws JSONException {
        JSONObject jObject = super.SaveToJsonObject(mode);
        jObject.RemoveProperty("StringFormat");
        return jObject;
    }

    static {
        DecimalFormatSymbols dfs = DECIMAL_FORMAT.getDecimalFormatSymbols();
        dfs.setDecimalSeparator('.');
        DECIMAL_FORMAT.setDecimalFormatSymbols(dfs);
    }
}

