/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.report.crossTab;

import com.stimulsoft.base.StiJsonSaveMode;
import com.stimulsoft.base.drawing.StiBrush;
import com.stimulsoft.base.drawing.StiColorEnum;
import com.stimulsoft.base.drawing.StiSolidBrush;
import com.stimulsoft.base.json.JProperty;
import com.stimulsoft.base.json.JSONException;
import com.stimulsoft.base.json.JSONObject;
import com.stimulsoft.base.serializing.annotations.StiDefaulValue;
import com.stimulsoft.base.serializing.annotations.StiSerializable;
import com.stimulsoft.report.components.StiComponent;
import com.stimulsoft.report.crossTab.StiCrossCell;
import com.stimulsoft.report.crossTab.StiCrossTotal;
import com.stimulsoft.report.crossTab.core.enums.StiSortDirection;
import com.stimulsoft.report.crossTab.core.enums.StiSortType;
import com.stimulsoft.report.crossTab.events.StiGetCrossValueEventArgs;
import com.stimulsoft.report.crossTab.events.StiGetDisplayCrossValueEvent;
import com.stimulsoft.report.crossTab.expressions.StiCrossValueExpression;
import com.stimulsoft.report.crossTab.expressions.StiDisplayCrossValueExpression;
import com.stimulsoft.report.engine.parser.StiParser;
import com.stimulsoft.report.expressions.StiExpression;

public abstract class StiCrossHeader
extends StiCrossCell {
    private StiGetDisplayCrossValueEvent getDisplayCrossValueEvent = new StiGetDisplayCrossValueEvent();
    private StiDisplayCrossValueExpression displayValue = new StiDisplayCrossValueExpression();
    private String totalGuid = null;
    private boolean showTotal = true;
    private StiSortDirection sortDirection = StiSortDirection.Asc;
    private StiSortType sortType = StiSortType.ByDisplayValue;
    private boolean printOnAllPages = true;
    private int headerLevel = -1;
    private String headerValue = null;

    protected void OnGetDisplayCrossValue(StiGetCrossValueEventArgs e) {
    }

    public final void InvokeGetDisplayCrossValue(StiGetCrossValueEventArgs e) {
        Object parserResult = StiParser.ParseTextValue(this.getDisplayValue().getValue(), (StiComponent)this);
        if (parserResult != null) {
            e.setValue(parserResult.toString());
        }
    }

    @StiSerializable
    public final StiGetDisplayCrossValueEvent getGetDisplayCrossValueEvent() {
        return this.getDisplayCrossValueEvent;
    }

    public final void setGetDisplayCrossValueEvent(StiGetDisplayCrossValueEvent value) {
        this.getDisplayCrossValueEvent = value;
    }

    @Override
    public void setText(StiExpression value) {
        super.setText(value);
    }

    @Override
    public void setValue(StiCrossValueExpression value) {
        if (super.getValue().getValue() == this.getDisplayValue().getValue()) {
            this.getDisplayValue().setValue(value.getValue());
        }
        super.setValue(value);
    }

    @StiSerializable
    public StiDisplayCrossValueExpression getDisplayValue() {
        return this.displayValue;
    }

    public void setDisplayValue(StiDisplayCrossValueExpression value) {
        this.displayValue = value;
    }

    @Override
    @StiSerializable(need=false)
    public boolean getHideZeros() {
        return super.getHideZeros();
    }

    @Override
    public void setHideZeros(boolean value) {
        super.setHideZeros(value);
    }

    @StiSerializable(need=false)
    public final StiCrossTotal getTotal() {
        if (this.getTotalGuid() == null || this.getParent() == null) {
            return null;
        }
        for (StiComponent component : this.getParent().getComponents()) {
            StiCrossTotal total = (StiCrossTotal)(component instanceof StiCrossTotal ? component : null);
            if (total == null || !this.getTotalGuid().equals(total.getGuid())) continue;
            return total;
        }
        return null;
    }

    public final void setTotal(StiCrossTotal value) {
        if (value == null) {
            this.setTotalGuid(null);
        } else {
            this.setTotalGuid(value.getGuid());
        }
    }

    @StiSerializable
    public final String getTotalGuid() {
        return this.totalGuid;
    }

    public final void setTotalGuid(String value) {
        this.totalGuid = value;
    }

    @StiDefaulValue(value="true")
    @StiSerializable
    public boolean getShowTotal() {
        return this.showTotal;
    }

    public void setShowTotal(boolean value) {
        this.showTotal = value;
    }

    @StiDefaulValue(value="Asc")
    @StiSerializable
    public final StiSortDirection getSortDirection() {
        return this.sortDirection;
    }

    public final void setSortDirection(StiSortDirection value) {
        this.sortDirection = value;
    }

    @StiDefaulValue(value="ByDisplayValue")
    @StiSerializable
    public final StiSortType getSortType() {
        return this.sortType;
    }

    public final void setSortType(StiSortType value) {
        this.sortType = value;
    }

    @StiDefaulValue(value="true")
    @StiSerializable
    public boolean getPrintOnAllPages() {
        return this.printOnAllPages;
    }

    public void setPrintOnAllPages(boolean value) {
        this.printOnAllPages = value;
    }

    public StiCrossHeader() {
        this.setBrush((StiBrush)new StiSolidBrush(StiColorEnum.LightGray));
    }

    public boolean isTotalVisible() {
        return this.showTotal && this.getTotal() != null && this.getTotal().getEnabled();
    }

    public int getHeaderLevel() {
        return this.headerLevel;
    }

    public void setHeaderLevel(int headerLevel) {
        this.headerLevel = headerLevel;
    }

    public String getHeaderValue() {
        return this.headerValue;
    }

    public void setHeaderValue(String headerValue) {
        this.headerValue = headerValue;
    }

    @Override
    public JSONObject SaveToJsonObject(StiJsonSaveMode mode) throws JSONException {
        JSONObject jObject = super.SaveToJsonObject(mode);
        jObject.RemoveProperty("HideZeros");
        jObject.AddPropertyJObject("GetDisplayCrossValueEvent", this.getGetDisplayCrossValueEvent().SaveToJsonObject(mode));
        jObject.AddPropertyJObject("DisplayValue", this.getDisplayValue().SaveToJsonObject(mode));
        jObject.AddPropertyStringNullOfEmpty("TotalGuid", this.getTotalGuid());
        jObject.AddPropertyBool("ShowTotal", this.getShowTotal(), true);
        jObject.AddPropertyEnum("SortDirection", (Enum)this.getSortDirection(), (Enum)StiSortDirection.Asc);
        jObject.AddPropertyEnum("SortType", (Enum)this.getSortType(), (Enum)StiSortType.ByDisplayValue);
        jObject.AddPropertyBool("PrintOnAllPages", this.getPrintOnAllPages(), true);
        return jObject;
    }

    @Override
    public void LoadFromJsonObject(JSONObject jObject) throws JSONException {
        super.LoadFromJsonObject(jObject);
        for (JProperty property : jObject.Properties()) {
            if (property.Name.equals("GetDisplayCrossValueEvent")) {
                StiGetDisplayCrossValueEvent _event = new StiGetDisplayCrossValueEvent();
                _event.LoadFromJsonObject((JSONObject)property.Value);
                this.getDisplayCrossValueEvent = _event;
                continue;
            }
            if (property.Name.equals("DisplayValue")) {
                StiDisplayCrossValueExpression _expression = new StiDisplayCrossValueExpression();
                _expression.LoadFromJsonObject((JSONObject)property.Value);
                this.displayValue = _expression;
                continue;
            }
            if (property.Name.equals("TotalGuid")) {
                this.totalGuid = (String)property.Value;
                continue;
            }
            if (property.Name.equals("ShowTotal")) {
                this.showTotal = (Boolean)property.Value;
                continue;
            }
            if (property.Name.equals("SortDirection")) {
                this.sortDirection = StiSortDirection.valueOf((String)property.Value);
                continue;
            }
            if (property.Name.equals("SortType")) {
                this.sortType = StiSortType.valueOf((String)property.Value);
                continue;
            }
            if (!property.Name.equals("PrintOnAllPages")) continue;
            this.printOnAllPages = (Boolean)property.Value;
        }
    }
}

