/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.report.crossTab.core;

import com.stimulsoft.base.StiAlignValue;
import com.stimulsoft.base.system.StiSize;
import com.stimulsoft.base.system.geometry.StiRectangle;
import com.stimulsoft.lib.utils.StiStringUtil;
import com.stimulsoft.report.StiReport;
import com.stimulsoft.report.crossTab.StiCrossField;
import com.stimulsoft.report.crossTab.StiCrossSummary;
import com.stimulsoft.report.crossTab.core.StiCell;
import com.stimulsoft.report.events.StiValueEventArgs;
import com.stimulsoft.report.expressions.StiExpression;
import com.stimulsoft.report.options.EngineOptions;
import java.awt.Point;
import java.util.HashMap;
import java.util.Hashtable;

public class StiGrid {
    private StiReport report;
    private final Hashtable fields = new Hashtable();
    private boolean designTime;
    private double[] widths;
    private double[] heights;
    private double[] coordX;
    private double[] coordY;
    private StiCell[][] cells;
    public double MaxWidth = 10.0;
    public double MaxHeight = 10.0;

    public StiCell SetCell(int cellX, int cellY, int cellWidth, int cellHeight, Object text, Object value, StiCrossField field, boolean isNumeric, String hyperlink, String toolTip, String tag, HashMap<String, Object> drillDownParameters) {
        return this.SetCell(cellX, cellY, cellWidth, cellHeight, text, value, field, isNumeric, hyperlink, toolTip, tag, drillDownParameters, -1, null, null, false);
    }

    public final StiCell SetCell(int cellX, int cellY, int cellWidth, int cellHeight, Object text, Object value, StiCrossField field, boolean isNumeric, String hyperlink, String toolTip, String tag, HashMap<String, Object> drillDownParameters, int level, String parentGuid, String guid, boolean keepMergedCellsTogether) {
        StiCell parent = this.getCells()[cellX][cellY];
        if (!this.designTime) {
            Object tempVar = field.clone();
            field = (StiCrossField)(tempVar instanceof StiCrossField ? tempVar : null);
        }
        String resTag = field.getTagValue();
        String resToolTip = field.getToolTipValue();
        String resHyperlinkValue = field.getHyperlinkValue();
        String resTextValue = field.getTextValue();
        StiValueEventArgs e = new StiValueEventArgs(value);
        field.setTagValue(tag);
        field.setToolTipValue(toolTip);
        field.setHyperlinkValue(hyperlink);
        if (field instanceof StiCrossSummary) {
            ((StiCrossSummary)field).setCrossRowValue((String)(this.getCells()[0][cellY].getValue() instanceof String ? this.getCells()[0][cellY].getValue() : null));
            ((StiCrossSummary)field).setCrossColumnValue((String)(this.getCells()[cellX][1].getValue() instanceof String ? this.getCells()[cellX][1].getValue() : null));
        }
        field.InvokeTextProcess(field, e);
        field.setTagValue(resTag);
        field.setToolTipValue(resToolTip);
        field.setHyperlinkValue(resHyperlinkValue);
        field.originalValue = value;
        if (field instanceof StiCrossSummary) {
            ((StiCrossSummary)field).setCrossRowValue(null);
            ((StiCrossSummary)field).setCrossColumnValue(null);
        }
        if (!StiStringUtil.stringsEquals((String)resTextValue, (String)field.getTextValue())) {
            text = field.getTextValue();
        }
        for (int x = cellX; x < cellX + cellWidth; ++x) {
            for (int y = cellY; y < cellY + cellHeight; ++y) {
                if (text != null) {
                    this.getCells()[x][y].setText(text.toString());
                }
                this.getCells()[x][y].setParentCell(parent);
                this.getCells()[x][y].setValue(value);
                this.getCells()[x][y].setWidth(cellWidth - (x - cellX));
                this.getCells()[x][y].setHeight(cellHeight - (y - cellY));
                this.getCells()[x][y].setField(field);
                this.getCells()[x][y].setIsNumeric(isNumeric);
                this.getCells()[x][y].setHyperlinkValue(hyperlink);
                this.getCells()[x][y].setToolTipValue(toolTip);
                this.getCells()[x][y].setTagValue(tag);
                this.getCells()[x][y].setDrillDownParameters(drillDownParameters);
                this.getCells()[x][y].setLevel(level);
                this.getCells()[x][y].setKeepMergedCellsTogether(keepMergedCellsTogether);
            }
        }
        if (this.designTime && this.fields.get(field) == null) {
            this.fields.put(field, new Point(cellX, cellY));
        }
        return this.getCells()[cellX][cellY];
    }

    public final void SetCellField(int cellX, int cellY, StiCrossField field) {
        if (this.getCells()[cellX][cellY] != null) {
            this.getCells()[cellX][cellY].setField(field);
        }
    }

    public final void Init(int colCount, int rowCount) {
        int index;
        this.widths = new double[colCount];
        this.heights = new double[rowCount];
        this.coordX = new double[colCount];
        this.coordY = new double[rowCount];
        for (index = 0; index < colCount; ++index) {
            this.widths[index] = 10.0;
        }
        for (index = 0; index < rowCount; ++index) {
            this.heights[index] = 10.0;
        }
        this.cells = new StiCell[colCount][];
        for (int colIndex = 0; colIndex < colCount; ++colIndex) {
            this.cells[colIndex] = new StiCell[rowCount];
            for (int rowIndex = 0; rowIndex < rowCount; ++rowIndex) {
                this.cells[colIndex][rowIndex] = new StiCell();
            }
        }
    }

    private double getgridSize() {
        return this.getReport().getInfo().getGridSize();
    }

    public final StiReport getReport() {
        return this.report;
    }

    public final void setReport(StiReport value) {
        this.report = value;
    }

    public final Hashtable getFields() {
        return this.fields;
    }

    public final boolean getDesignTime() {
        return this.designTime;
    }

    public final void setDesignTime(boolean value) {
        this.designTime = value;
    }

    public final double[] getWidths() {
        return this.widths;
    }

    public final void setWidths(double[] value) {
        this.widths = value;
    }

    public final double[] getHeights() {
        return this.heights;
    }

    public final void setHeights(double[] value) {
        this.heights = value;
    }

    public final double[] getCoordX() {
        return this.coordX;
    }

    public final double[] getCoordY() {
        return this.coordY;
    }

    public final StiCell[][] getCells() {
        return this.cells;
    }

    public final void setCells(StiCell[][] value) {
        this.cells = value;
    }

    public final int getRowCount() {
        return this.getHeights().length;
    }

    public final void setRowCount(int value) {
        this.Init(this.widths.length, value);
    }

    public final int getColCount() {
        return this.widths.length;
    }

    public final void setColCount(int value) {
        this.Init(value, this.getHeights().length);
    }

    public final void SetTextOfCell(int x, int y, String value) {
        this.getCells()[x][y].setText(value);
    }

    private double Align(double value) {
        return StiAlignValue.alignToMaxGrid((double)value, (double)this.getgridSize(), (boolean)true);
    }

    private double GetCellTotalWidth(int cellX, int width) {
        double totalWidth = 0.0;
        for (int x = cellX; x < cellX + width; ++x) {
            if (x >= this.widths.length) continue;
            totalWidth += this.getWidths()[x];
        }
        return totalWidth;
    }

    private double GetCellTotalHeight(int cellY, int height) {
        double totalHeight = 0.0;
        for (int y = cellY; y < cellY + height; ++y) {
            totalHeight += this.getHeights()[y];
        }
        return totalHeight;
    }

    public final void DoAutoSize() {
        this.setSizeInCells();
        this.setWidthInCells();
        this.setHeightInCells();
        this.setTotalsSize();
        for (int colIndex = 0; colIndex < this.getColCount(); ++colIndex) {
            this.getWidths()[colIndex] = StiAlignValue.alignToMaxGrid((double)this.getWidths()[colIndex], (double)this.report.getInfo().getGridSize(), (boolean)true);
        }
        for (int rowIndex = 0; rowIndex < this.getRowCount(); ++rowIndex) {
            this.getHeights()[rowIndex] = StiAlignValue.alignToMaxGrid((double)this.getHeights()[rowIndex], (double)this.report.getInfo().getGridSize(), (boolean)true);
        }
        double posX = 0.0;
        for (int colIndex = 0; colIndex < this.getColCount(); ++colIndex) {
            this.getCoordX()[colIndex] = posX;
            posX += this.getWidths()[colIndex];
        }
        double posY = 0.0;
        for (int rowIndex = 0; rowIndex < this.getRowCount(); ++rowIndex) {
            this.getCoordY()[rowIndex] = posY;
            posY += this.getHeights()[rowIndex];
        }
    }

    private void setTotalsSize() {
        for (int colIndex = 0; colIndex < this.getColCount(); ++colIndex) {
            for (int rowIndex = 0; rowIndex < this.getRowCount(); ++rowIndex) {
                int index;
                double factor;
                StiCell cell = this.cells[colIndex][rowIndex];
                if (cell.getField() == null || cell.getParentCell() != cell || cell.getWidth() <= 1 && cell.getHeight() <= 1) continue;
                double totalWidth = this.GetCellTotalWidth(colIndex, cell.getWidth());
                double totalHeight = this.GetCellTotalHeight(rowIndex, cell.getHeight());
                if (cell.getSize().getWidth() > totalWidth) {
                    factor = cell.getSize().getWidth() / totalWidth;
                    index = colIndex;
                    while ((double)index < (double)colIndex + cell.getSize().getWidth()) {
                        if (index < this.getWidths().length) {
                            double[] dArray = this.getWidths();
                            int n = index;
                            dArray[n] = dArray[n] * factor;
                        }
                        ++index;
                    }
                }
                if (!(cell.getSize().getHeight() > totalHeight)) continue;
                factor = cell.getSize().getHeight() / totalHeight;
                index = rowIndex;
                while ((double)index < (double)rowIndex + cell.getSize().getHeight()) {
                    if (index < this.getHeights().length) {
                        double[] dArray = this.getHeights();
                        int n = index;
                        dArray[n] = dArray[n] * factor;
                    }
                    ++index;
                }
            }
        }
    }

    private void setSizeInCells() {
        for (int colIndex = 0; colIndex < this.getColCount(); ++colIndex) {
            for (int rowIndex = 0; rowIndex < this.getRowCount(); ++rowIndex) {
                StiCell cell = this.cells[colIndex][rowIndex];
                if (cell.getField() != null && cell.getParentCell() == cell) {
                    double strMaxWidth = 10000.0;
                    if (cell.getField().getMaxSize().getWidth() != 0.0) {
                        strMaxWidth = this.getFieldWidth(cell.getField(), cell.getField().getReport().getUnit().ConvertToHInches(cell.getField().getMaxSize().getWidth()));
                    }
                    if (cell.getField().getMaxSize().getHeight() != 0.0 && (cell.getField().getAngle() == 90.0f || cell.getField().getAngle() == 270.0f)) {
                        strMaxWidth = this.getFieldHeight(cell.getField(), cell.getField().getReport().getUnit().ConvertToHInches(cell.getField().getMaxSize().getHeight()));
                    }
                    StiExpression storedText = cell.getField().getText();
                    cell.getField().setText(cell.getText());
                    StiSize size = cell.doAutoSize().getStiSize();
                    cell.getField().setText(storedText);
                    size.setWidth(size.getWidth() + cell.getField().getMargins().getLeft() + cell.getField().getMargins().getRight());
                    size.setHeight(size.getHeight() + cell.getField().getMargins().getTop() + cell.getField().getMargins().getBottom());
                    size.setWidth(this.getReport().getUnit().ConvertFromHInches(size.getWidth()));
                    size.setHeight(this.getReport().getUnit().ConvertFromHInches(size.getHeight()));
                    if (cell.getField().getMaxSize().getWidth() != 0.0 && cell.getField().getMaxSize().getWidth() < size.getWidth()) {
                        size.setWidth(cell.getField().getMaxSize().getWidth());
                    }
                    if (cell.getField().getMinSize().getWidth() != 0.0 && cell.getField().getMinSize().getWidth() > size.getWidth()) {
                        size.setWidth(cell.getField().getMaxSize().getWidth());
                    }
                    cell.setSize(size);
                    continue;
                }
                cell.setSize(StiSize.EMPTY);
                if (colIndex <= 0 || cell.getParentCell() != null || this.cells[colIndex - 1][rowIndex].getWidth() != 1) continue;
                this.cells[colIndex - 1][rowIndex].getWidth();
                this.cells[colIndex - 1][rowIndex].setWidth(this.cells[colIndex - 1][rowIndex].getWidth() + 1);
            }
        }
    }

    private void setHeightInCells() {
        for (int rowIndex = 0; rowIndex < this.getRowCount(); ++rowIndex) {
            double height = this.getReport().getUnit().ConvertFromHInches(EngineOptions.CrossTab.getDefaultHeight());
            for (int colIndex = 0; colIndex < this.getColCount(); ++colIndex) {
                StiCell cell = this.cells[colIndex][rowIndex];
                if (cell.getHeight() > 1) continue;
                double cellHeight = cell.getSize().getHeight();
                if (cell.getField() != null) {
                    if (cell.getField().getMinSize().getHeight() != 0.0) {
                        cellHeight = Math.max(cellHeight, cell.getField().getMinSize().getHeight());
                    }
                    if (cell.getField().getMaxSize().getHeight() != 0.0) {
                        cellHeight = Math.min(cellHeight, cell.getField().getMaxSize().getHeight());
                    }
                }
                height = Math.max(height, cellHeight);
            }
            height = Math.min(height, this.MaxHeight);
            this.getHeights()[rowIndex] = height = this.Align(height);
        }
    }

    private double getFieldWidth(StiCrossField field, double value) {
        StiRectangle rect = new StiRectangle(0.0, 0.0, value, field.getHeight());
        rect = field.convertTextMargins(rect, false);
        rect = field.convertTextBorders(rect, false);
        return rect.getWidth();
    }

    private double getFieldHeight(StiCrossField field, double value) {
        StiRectangle rect = new StiRectangle(0.0, 0.0, field.getHeight(), value);
        rect = field.convertTextMargins(rect, false);
        rect = field.convertTextBorders(rect, false);
        return rect.getHeight();
    }

    private void setWidthInCells() {
        for (int colIndex = 0; colIndex < this.getColCount(); ++colIndex) {
            double width = this.getReport().getUnit().ConvertFromHInches(EngineOptions.CrossTab.getDefaultWidth());
            for (int rowIndex = 0; rowIndex < this.getRowCount(); ++rowIndex) {
                StiCell cell = this.cells[colIndex][rowIndex];
                if (cell.getWidth() > 1) continue;
                double cellWidth = cell.getSize().getWidth();
                if (cell.getField() != null) {
                    if (cell.getField().getMinSize().getWidth() != 0.0) {
                        cellWidth = Math.max(cellWidth, cell.getField().getMinSize().getWidth());
                    }
                    if (cell.getField().getMaxSize().getWidth() != 0.0) {
                        cellWidth = Math.min(cellWidth, cell.getField().getMaxSize().getWidth());
                    }
                }
                width = Math.max(width, cellWidth);
            }
            width = Math.min(width, this.MaxWidth);
            this.getWidths()[colIndex] = width = this.Align(width);
        }
    }
}

