/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.report.dialogs;

import com.stimulsoft.base.StiJsonReportObjectHelper;
import com.stimulsoft.base.StiJsonSaveMode;
import com.stimulsoft.base.drawing.StiColorEnum;
import com.stimulsoft.base.json.JProperty;
import com.stimulsoft.base.json.JSONException;
import com.stimulsoft.base.json.JSONObject;
import com.stimulsoft.base.localization.StiLocalization;
import com.stimulsoft.base.serializing.annotations.StiDefaulValue;
import com.stimulsoft.base.serializing.annotations.StiSerializable;
import com.stimulsoft.base.system.geometry.StiRectangle;
import com.stimulsoft.report.components.enums.StiReportControlToolboxPosition;
import com.stimulsoft.report.dialogs.IStiDateTimePickerControl;
import com.stimulsoft.report.dialogs.StiReportControl;
import com.stimulsoft.report.events.StiEvent;
import com.stimulsoft.report.events.StiEventsCollection;
import com.stimulsoft.report.events.StiValueChangedEvent;
import java.util.Calendar;

public class StiDateTimePickerControl
extends StiReportControl
implements IStiDateTimePickerControl {
    private String valueBinding = "";
    private String maxDateBinding = "";
    private String minDateBinding = "";
    private boolean showUpDown;
    private boolean today = true;
    private String customFormat = "";
    private Calendar maxDate = Calendar.getInstance();
    private Calendar minDate = Calendar.getInstance();
    private Calendar valueDateTime = Calendar.getInstance();
    private String format = "Long";

    public StiDateTimePickerControl() {
        this(StiRectangle.empty());
    }

    public StiDateTimePickerControl(StiRectangle rect) {
        super(rect);
        super.setBackColor(StiColorEnum.Window.color());
        this.valueDateTime = Calendar.getInstance();
        this.setPlaceOnToolbox(true);
    }

    @Override
    public StiEventsCollection getEvents() {
        StiEventsCollection events = super.getEvents();
        if (this.getValueChangedEvent() != null) {
            events.add(this.getValueChangedEvent());
        }
        return events;
    }

    @Override
    public int getToolboxPosition() {
        return StiReportControlToolboxPosition.DateTimePickerControl.getValue();
    }

    @Override
    public String getLocalizedName() {
        return StiLocalization.Get((String)"Dialogs", (String)"StiDateTimePickerControl");
    }

    @StiSerializable
    public StiValueChangedEvent getValueChangedEvent() {
        return new StiValueChangedEvent(this);
    }

    public void setValueChangedEvent(StiValueChangedEvent value) {
        if (value != null) {
            value.Set(this, value.getScript());
        }
    }

    @StiSerializable
    @StiDefaulValue(value="")
    public final String getValueBinding() {
        return this.valueBinding;
    }

    public final void setValueBinding(String value) {
        this.valueBinding = value;
    }

    @StiSerializable
    @StiDefaulValue(value="")
    public final String getMaxDateBinding() {
        return this.maxDateBinding;
    }

    public final void setMaxDateBinding(String value) {
        this.maxDateBinding = value;
    }

    @StiSerializable
    @StiDefaulValue(value="")
    public final String getMinDateBinding() {
        return this.minDateBinding;
    }

    public final void setMinDateBinding(String value) {
        this.minDateBinding = value;
    }

    @Override
    public double getHeight() {
        return 20.0;
    }

    @Override
    public void setHeight(double value) {
        super.setHeight(20.0);
    }

    @StiDefaulValue(value="false")
    @StiSerializable
    public boolean getShowUpDown() {
        return this.showUpDown;
    }

    public void setShowUpDown(boolean value) {
        this.showUpDown = value;
        this.UpdateReportControl("ShowUpDown");
    }

    @StiDefaulValue(value="true")
    @StiSerializable
    public boolean getToday() {
        return this.today;
    }

    public void setToday(boolean value) {
        this.today = value;
        this.UpdateReportControl("Today");
    }

    @StiDefaulValue(value="")
    @StiSerializable
    public String getCustomFormat() {
        return this.customFormat;
    }

    public void setCustomFormat(String value) {
        this.customFormat = value;
        this.UpdateReportControl("CustomFormat");
    }

    @StiSerializable
    public Calendar getMaxDate() {
        return this.maxDate;
    }

    public void setMaxDate(Calendar value) {
        this.maxDate = value;
        this.UpdateReportControl("MaxDate");
    }

    @StiSerializable
    public Calendar getMinDate() {
        return this.minDate;
    }

    public void setMinDate(Calendar value) {
        this.minDate = value;
        this.UpdateReportControl("MinDate");
    }

    @Override
    @StiSerializable
    public Calendar getValue() {
        return this.valueDateTime;
    }

    @Override
    public void setValue(Calendar value) {
        this.valueDateTime = value;
        this.UpdateReportControl("Value");
    }

    @Override
    public StiEvent GetDefaultEvent() {
        return this.getValueChangedEvent();
    }

    @StiSerializable
    @StiDefaulValue(value="Long")
    public String getFormat() {
        return this.format;
    }

    public void setFormat(String format) {
        this.format = format;
    }

    @Override
    public JSONObject SaveToJsonObject(StiJsonSaveMode mode) throws JSONException {
        JSONObject jObject = super.SaveToJsonObject(mode);
        jObject.AddPropertyJObject("ValueChangedEvent", this.getValueChangedEvent().SaveToJsonObject(mode));
        jObject.AddPropertyStringNullOfEmpty("ValueBinding", this.getValueBinding());
        jObject.AddPropertyStringNullOfEmpty("MaxDateBinding", this.getMaxDateBinding());
        jObject.AddPropertyStringNullOfEmpty("MinDateBinding", this.getMinDateBinding());
        jObject.AddPropertyString("Format", this.getFormat(), "");
        jObject.AddPropertyBool("ShowUpDown", this.getShowUpDown());
        jObject.AddPropertyBool("Today", this.getToday(), true);
        jObject.AddPropertyStringNullOfEmpty("CustomFormat", this.getCustomFormat());
        jObject.AddPropertyDateTime("MaxDate", this.getMaxDate());
        jObject.AddPropertyDateTime("MinDate", this.getMinDate());
        jObject.AddPropertyDateTime("Value", this.getValue());
        return jObject;
    }

    @Override
    public void LoadFromJsonObject(JSONObject jObject) throws JSONException {
        super.LoadFromJsonObject(jObject);
        for (JProperty property : jObject.Properties()) {
            if (property.Name.equals("ValueChangedEvent")) {
                StiValueChangedEvent _event = new StiValueChangedEvent();
                _event.LoadFromJsonObject((JSONObject)property.Value);
                this.setValueChangedEvent(_event);
                continue;
            }
            if (property.Name.equals("ValueBinding")) {
                this.valueBinding = (String)property.Value;
                continue;
            }
            if (property.Name.equals("MaxDateBinding")) {
                this.maxDateBinding = (String)property.Value;
                continue;
            }
            if (property.Name.equals("MinDateBinding")) {
                this.minDateBinding = (String)property.Value;
                continue;
            }
            if (property.Name.equals("Format")) {
                this.format = (String)property.Value;
                continue;
            }
            if (property.Name.equals("DropDownAlign")) continue;
            if (property.Name.equals("ShowUpDown")) {
                this.showUpDown = (Boolean)property.Value;
                continue;
            }
            if (property.Name.equals("Today")) {
                this.today = (Boolean)property.Value;
                continue;
            }
            if (property.Name.equals("CustomFormat")) {
                this.customFormat = (String)property.Value;
                continue;
            }
            if (property.Name.equals("MaxDate")) {
                this.maxDate = StiJsonReportObjectHelper.Deserialize.DateTime((JProperty)property).calendar();
                continue;
            }
            if (property.Name.equals("MinDate")) {
                this.minDate = StiJsonReportObjectHelper.Deserialize.DateTime((JProperty)property).calendar();
                continue;
            }
            if (!property.Name.equals("Value")) continue;
            this.valueDateTime = StiJsonReportObjectHelper.Deserialize.DateTime((JProperty)property).calendar();
        }
    }
}

