/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.report.dictionary;

import com.stimulsoft.base.IStiJsonReportObject;
import com.stimulsoft.base.StiJsonReportObjectHelper;
import com.stimulsoft.base.StiJsonSaveMode;
import com.stimulsoft.base.json.JProperty;
import com.stimulsoft.base.json.JSONException;
import com.stimulsoft.base.json.JSONObject;
import com.stimulsoft.base.serializing.StiSerializedObject;
import com.stimulsoft.base.serializing.annotations.StiDefaulValue;
import com.stimulsoft.base.serializing.annotations.StiSerializable;
import com.stimulsoft.lib.commoninterface.IStiName;
import com.stimulsoft.report.IStiInherited;
import com.stimulsoft.report.StiNameValidator;
import com.stimulsoft.report.StiOptions;
import com.stimulsoft.report.dictionary.StiDictionary;
import com.stimulsoft.report.dictionary.data.DataCell;
import com.stimulsoft.report.dictionary.data.DataRow;
import com.stimulsoft.report.dictionary.data.DataRowCollection;
import com.stimulsoft.report.dictionary.dataSources.StiDataSource;
import java.util.ArrayList;

public class StiDataRelation
extends StiSerializedObject
implements Cloneable,
IStiName,
IStiInherited,
IStiJsonReportObject {
    private boolean inherited;
    private String name;
    private StiDictionary dictionary;
    private StiDataSource parentSource;
    private StiDataSource childSource;
    private ArrayList<String> childColumns;
    private ArrayList<String> parentColumns;
    private String nameInSource;
    private String alias;
    private boolean active;

    public StiDataRelation() {
        this("", null, null, new ArrayList<String>(0), new ArrayList<String>(0));
    }

    public StiDataRelation(String nameInSource, StiDataSource parentSource, StiDataSource childSource, ArrayList<String> parentColumns, ArrayList<String> childColumns) {
        this(nameInSource, nameInSource, nameInSource, parentSource, childSource, parentColumns, childColumns);
    }

    public StiDataRelation(String nameInSource, String name, String alias, StiDataSource parentSource, StiDataSource childSource, ArrayList<String> parentColumns, ArrayList<String> childColumns) {
        this.nameInSource = nameInSource;
        this.name = name;
        this.alias = alias;
        this.parentSource = parentSource;
        this.childSource = childSource;
        this.parentColumns = parentColumns;
        this.childColumns = childColumns;
    }

    @Override
    @StiSerializable
    @StiDefaulValue(value="false")
    public final boolean getInherited() {
        return this.inherited;
    }

    @Override
    public final void setInherited(boolean value) {
        this.inherited = value;
    }

    @StiSerializable
    public boolean isActive() {
        return this.active;
    }

    public void setActive(boolean active) {
        this.active = active;
    }

    @StiSerializable
    public String getName() {
        return this.name;
    }

    public void setName(String value) {
        if (this.getDictionary() != null && this.getDictionary().getReport() != null && this.getDictionary().getReport().getIsDesigning() && StiOptions.Designer.getAutoCorrectDataRelationName()) {
            value = StiNameValidator.CorrectName(value);
        }
        this.name = value;
    }

    @StiSerializable(isRef=true)
    public final StiDictionary getDictionary() {
        return this.dictionary;
    }

    public final void setDictionary(StiDictionary value) {
        this.dictionary = value;
    }

    @StiSerializable(isRef=true)
    public final StiDataSource getParentSource() {
        return this.parentSource;
    }

    public final void setParentSource(StiDataSource value) {
        this.parentSource = value;
    }

    @StiSerializable(isRef=true)
    public final StiDataSource getChildSource() {
        return this.childSource;
    }

    public final void setChildSource(StiDataSource value) {
        this.childSource = value;
    }

    @StiSerializable
    public final ArrayList<String> getChildColumns() {
        return this.childColumns;
    }

    public final void setChildColumns(ArrayList<String> value) {
        this.childColumns = StiNameValidator.correctArrayName(value);
    }

    @StiSerializable
    public final ArrayList<String> getParentColumns() {
        return this.parentColumns;
    }

    public final void setParentColumns(ArrayList<String> value) {
        this.parentColumns = value;
    }

    @StiSerializable
    public final String getNameInSource() {
        return this.nameInSource;
    }

    public final void setNameInSource(String value) {
        this.nameInSource = value;
    }

    @StiSerializable
    public final String getAlias() {
        return this.alias;
    }

    public final void setAlias(String value) {
        this.alias = value;
    }

    public int getNumberColumns() {
        this.checkSizeColumns();
        return this.childColumns.size();
    }

    private void checkSizeColumns() {
        if (this.childColumns.size() != this.parentColumns.size()) {
            throw new RuntimeException("\u043a\u043e\u043b\u0438\u0447\u0435\u0441\u0442\u0432\u043e \u043a\u043e\u043b\u043e\u043d\u043e\u043a \u0432 childColumns \u0438 parentColumns \u043d\u0435 \u0441\u043e\u0432\u043f\u0430\u0434\u0430\u0435\u0442");
        }
    }

    public ArrayList<DataRow> getParentRows(DataRow cRow) {
        DataRowCollection pRows = this.getParentSource().getDataTable().getRows();
        ArrayList<DataRow> result = new ArrayList<DataRow>();
        for (DataRow pRow : pRows) {
            boolean belongs = this.belongs(cRow, pRow);
            if (!belongs) continue;
            result.add(pRow);
        }
        return result;
    }

    public DataRow getFirstParentRows(DataRow cRow) {
        if (!cRow.existParent(this.getParentSource(), this.name)) {
            DataRowCollection pRows = this.getParentSource().getDataTable().getRows();
            for (DataRow pRow : pRows) {
                boolean belongs = this.belongs(cRow, pRow);
                if (!belongs) continue;
                cRow.setParentRow(this.getParentSource(), this.name, pRow);
                break;
            }
        }
        return cRow.getParentRow(this.getParentSource(), this.name);
    }

    public ArrayList<DataRow> getChildRows(DataRow pRow, String relationName) {
        if (!pRow.existChildRows(this.getChildSource(), relationName)) {
            ArrayList<DataRow> result = new ArrayList<DataRow>();
            if (this.getChildSource().getDataTable() != null) {
                DataRowCollection cRows = this.getChildSource().getDataTable().getRows();
                for (DataRow cRow : cRows) {
                    boolean belongs = this.belongs(cRow, pRow);
                    if (!belongs) continue;
                    result.add(cRow);
                }
            }
            pRow.setChildRows(this.getChildSource(), result, relationName);
        }
        return pRow.getChildRows(this.getChildSource(), relationName);
    }

    private boolean belongs(DataRow cRow, DataRow pRow) {
        boolean result = true;
        for (int i = 0; i < this.getNumberColumns(); ++i) {
            DataCell pValue;
            DataCell cValue = cRow.getCell(this.childColumns.get(i));
            if (cValue.equals(pValue = pRow.getCell(this.parentColumns.get(i)))) continue;
            result = false;
            break;
        }
        return result;
    }

    public String toString() {
        if (StiOptions.Dictionary.getShowOnlyAliasForDataRelation()) {
            return this.getAlias();
        }
        if (this.getName().equals(this.getAlias())) {
            return this.name;
        }
        return this.getName() + " [" + this.getAlias() + "]";
    }

    public JSONObject SaveToJsonObject(StiJsonSaveMode mode) throws JSONException {
        JSONObject jObject = new JSONObject();
        jObject.AddPropertyBool("Inherited", this.getInherited());
        jObject.AddPropertyStringNullOfEmpty("Name", this.getName());
        jObject.AddPropertyJObject("ChildColumns", StiJsonReportObjectHelper.Serialize.StringArray((String[])this.getChildColumns().toArray(new String[0])));
        jObject.AddPropertyJObject("ParentColumns", StiJsonReportObjectHelper.Serialize.StringArray((String[])this.getParentColumns().toArray(new String[0])));
        jObject.AddPropertyStringNullOfEmpty("NameInSource", this.getNameInSource());
        jObject.AddPropertyStringNullOfEmpty("Alias", this.getAlias());
        if (this.getParentSource() != null) {
            jObject.AddPropertyStringNullOfEmpty("ParentSource", this.getParentSource().getName());
        }
        if (this.getChildSource() != null) {
            jObject.AddPropertyStringNullOfEmpty("ChildSource", this.getChildSource().getName());
        }
        return jObject;
    }

    public void LoadFromJsonObject(JSONObject jObject) throws JSONException {
        for (JProperty property : jObject.Properties()) {
            if (property.Name.equals("Inherited")) {
                this.inherited = (Boolean)property.Value;
                continue;
            }
            if (property.Name.equals("Name")) {
                this.name = (String)property.Value;
                continue;
            }
            if (property.Name.equals("ChildColumns")) {
                this.childColumns = StiJsonReportObjectHelper.Deserialize.stringList((JSONObject)((JSONObject)property.Value));
                continue;
            }
            if (property.Name.equals("ParentColumns")) {
                this.parentColumns = StiJsonReportObjectHelper.Deserialize.stringList((JSONObject)((JSONObject)property.Value));
                continue;
            }
            if (property.Name.equals("NameInSource")) {
                this.nameInSource = (String)property.Value;
                continue;
            }
            if (property.Name.equals("Alias")) {
                this.alias = (String)property.Value;
                continue;
            }
            if (property.Name.equals("IsCloud") || property.Name.equals("Key")) continue;
            if (property.Name.equals("ParentSource")) {
                this.setParentSource(this.getDictionary().getDataSources().get((String)property.Value));
                continue;
            }
            if (!property.Name.equals("ChildSource")) continue;
            this.setChildSource(this.getDictionary().getDataSources().get((String)property.Value));
        }
    }
}

