/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.report.dictionary;

import com.stimulsoft.base.IStiJsonReportObject;
import com.stimulsoft.base.StiJsonSaveMode;
import com.stimulsoft.base.exception.StiException;
import com.stimulsoft.base.json.JProperty;
import com.stimulsoft.base.json.JSONException;
import com.stimulsoft.base.json.JSONObject;
import com.stimulsoft.base.serializing.StiSerializedObject;
import com.stimulsoft.base.serializing.annotations.StiSerializable;
import com.stimulsoft.base.serializing.annotations.StiSerializeTypesEnum;
import com.stimulsoft.report.IStiStateSaveRestore;
import com.stimulsoft.report.StiOptions;
import com.stimulsoft.report.StiReport;
import com.stimulsoft.report.components.StiDataRetrieval;
import com.stimulsoft.report.dictionary.StiDataColumn;
import com.stimulsoft.report.dictionary.StiDataRelation;
import com.stimulsoft.report.dictionary.StiDataRelationsCollection;
import com.stimulsoft.report.dictionary.StiRestrictions;
import com.stimulsoft.report.dictionary.StiVariable;
import com.stimulsoft.report.dictionary.StiVariablesCollection;
import com.stimulsoft.report.dictionary.businessObjects.StiBusinessObjectsCollection;
import com.stimulsoft.report.dictionary.data.DataColumn;
import com.stimulsoft.report.dictionary.data.DataSet;
import com.stimulsoft.report.dictionary.dataSources.StiDataSource;
import com.stimulsoft.report.dictionary.dataSources.StiDataSourceHelper;
import com.stimulsoft.report.dictionary.dataSources.StiDataSourcesCollection;
import com.stimulsoft.report.dictionary.databases.StiDataCollection;
import com.stimulsoft.report.dictionary.databases.StiDatabaseCollection;
import com.stimulsoft.report.dictionary.databases.StiResourcesCollection;
import com.stimulsoft.report.dictionary.enums.StiAutoSynchronizeMode;
import com.stimulsoft.report.dictionary.enums.StiSortOrder;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;

public class StiDictionary
extends StiSerializedObject
implements Cloneable,
IStiStateSaveRestore,
IStiJsonReportObject {
    private static Hashtable cachedUserNamesAndPasswords = null;
    private boolean useInternalData = false;
    private StiRestrictions restrictions = new StiRestrictions();
    private StiReport report;
    private StiDataCollection dataStore = new StiDataCollection();
    public StiVariablesCollection variables = new StiVariablesCollection();
    public StiDataSourcesCollection dataSources = new StiDataSourcesCollection();
    private StiDatabaseCollection databases = new StiDatabaseCollection();
    private StiBusinessObjectsCollection businessObjects;
    private StiDataRelationsCollection relations = new StiDataRelationsCollection();
    private DataSet cacheDataSet;
    private StiResourcesCollection resources = new StiResourcesCollection();

    public StiDictionary() {
        this(null);
    }

    public StiDictionary(StiReport report) {
        this.report = report;
        this.dataSources = new StiDataSourcesCollection(this);
        this.relations = new StiDataRelationsCollection(this);
        this.databases = new StiDatabaseCollection(this);
        this.businessObjects = new StiBusinessObjectsCollection(this, null);
    }

    @Override
    public void saveState(String stateName) {
        Iterator i$ = this.getDataSources().iterator();
        while (i$.hasNext()) {
            StiDataSource data = (StiDataSource)i$.next();
            data.saveState(stateName);
        }
    }

    public void RestoreState(String stateName) {
        Iterator i$ = this.getDataSources().iterator();
        while (i$.hasNext()) {
            StiDataSource data = (StiDataSource)i$.next();
            data.RestoreState(stateName);
        }
    }

    public void ClearAllStates() {
        Iterator i$ = this.getDataSources().iterator();
        while (i$.hasNext()) {
            StiDataSource data = (StiDataSource)i$.next();
            data.ClearAllStates();
        }
    }

    public static Hashtable getCacheUserNamesAndPasswords() {
        return cachedUserNamesAndPasswords;
    }

    public static void setCacheUserNamesAndPasswords(Hashtable value) {
        cachedUserNamesAndPasswords = value;
    }

    public final boolean getUseInternalData() {
        return this.useInternalData;
    }

    public final void setUseInternalData(boolean value) {
        this.useInternalData = value;
    }

    public final StiRestrictions getRestrictions() {
        return this.restrictions;
    }

    public final void setRestrictions(StiRestrictions value) {
        this.restrictions = value;
    }

    public static StiAutoSynchronizeMode getAutoSynchronize() {
        return StiOptions.Dictionary.getAutoSynchronize();
    }

    public static void setAutoSynchronize(StiAutoSynchronizeMode value) {
        StiOptions.Dictionary.setAutoSynchronize(value);
    }

    public static void DoAutoSynchronize(StiReport report) {
        if (report == null) {
            return;
        }
        if (StiDictionary.getAutoSynchronize() == StiAutoSynchronizeMode.Always || StiDictionary.getAutoSynchronize() == StiAutoSynchronizeMode.IfDictionaryEmpty && report.getDictionary().getDataSources().size() == 0) {
            report.getDictionary().Synchronize();
        }
    }

    private void Synchronize() {
    }

    @StiSerializable(isRef=true, type=StiSerializeTypesEnum.SerializeToAll)
    public final StiReport getReport() {
        return this.report;
    }

    public final void setReport(StiReport value) {
        this.report = value;
    }

    public final StiDataCollection getDataStore() {
        return this.dataStore;
    }

    public final void setDataStore(StiDataCollection value) {
        this.dataStore = value;
    }

    @StiSerializable
    public final StiVariablesCollection getVariables() {
        return this.variables;
    }

    public final void setVariables(StiVariablesCollection value) {
        this.variables = value;
    }

    @StiSerializable
    public StiResourcesCollection getResources() {
        return this.resources;
    }

    public void setResources(StiResourcesCollection resources) {
        this.resources = resources;
    }

    @StiSerializable
    public final StiDataSourcesCollection getDataSources() {
        return this.dataSources;
    }

    public final void setDataSources(StiDataSourcesCollection value) {
        this.dataSources = value;
    }

    @StiSerializable
    public final StiDatabaseCollection getDatabases() {
        return this.databases;
    }

    public final void setDatabases(StiDatabaseCollection value) {
        this.databases = value;
    }

    @StiSerializable
    public final StiBusinessObjectsCollection getBusinessObjects() {
        return this.businessObjects;
    }

    public final void setBusinessObjects(StiBusinessObjectsCollection value) {
        this.businessObjects = value;
    }

    @StiSerializable
    public StiDataRelationsCollection getRelations() {
        return this.relations;
    }

    public void setRelations(StiDataRelationsCollection value) {
        this.relations = value;
    }

    public final boolean getisRequestFromUserVariablesPresent() {
        if (this.getVariables() == null) {
            return false;
        }
        Iterator i$ = this.getVariables().iterator();
        while (i$.hasNext()) {
            StiVariable variable = (StiVariable)i$.next();
            if (!variable.getRequestFromUser()) continue;
            return true;
        }
        return false;
    }

    public final void SortItems() {
        this.SortItems(StiSortOrder.Asc);
    }

    public final void SortItems(StiSortOrder order) {
        this.getDataSources().sort(order);
        this.getVariables().Sort(order);
    }

    public final void RetrievalData(Hashtable usedRelations, Hashtable usedDataSources, Hashtable usedColumns) {
        StiDataRetrieval service = new StiDataRetrieval();
        service.Retrieval(this.getReport());
        usedRelations.putAll(service.getUsedRelations());
        usedDataSources.putAll(service.getUsedDataSources());
        usedColumns.putAll(service.getUsedColumns());
    }

    public final void clear() {
        this.variables.clear();
        this.dataSources.clear();
        this.databases.clear();
        this.relations.clear();
        this.dataStore.clear();
        this.resources.clear();
    }

    public final void SynchronizeBusinessObjects(int maxLevel) {
        this.SynchronizeBusinessObjects();
        this.SynchronizeBusinessObjects(this.businessObjects, 0, maxLevel);
    }

    private void SynchronizeBusinessObjects() {
    }

    private void SynchronizeBusinessObjects(StiBusinessObjectsCollection objects, int curLevel, int maxLevel) {
    }

    private String GetRelationName(StiDataRelation relation) {
        String baseName;
        boolean finded = true;
        int index = 2;
        String relationName = baseName = relation.getName();
        Iterator i$ = relation.getChildSource().getColumns().iterator();
        while (i$.hasNext()) {
            StiDataColumn column = (StiDataColumn)i$.next();
            if (!relationName.equals(column.getName())) continue;
            baseName = relationName = "Parent" + relationName;
            break;
        }
        block1: while (finded) {
            finded = false;
            for (StiDataRelation dataRelation : this.getRelations()) {
                if (dataRelation.getChildSource() != relation.getChildSource() || dataRelation == relation || !relationName.equals(dataRelation.getName())) continue;
                relationName = (baseName + "_" + index++).toString();
                finded = true;
                continue block1;
            }
        }
        finded = true;
        block3: while (finded) {
            finded = false;
            i$ = this.getDataSources().iterator();
            while (i$.hasNext()) {
                StiDataSource dataSource = (StiDataSource)i$.next();
                if (!("Parent" + relationName).equals(dataSource.getName())) continue;
                relationName = (baseName + "_" + index++).toString();
                finded = true;
                continue block3;
            }
        }
        return relationName;
    }

    public final void connect() {
        this.connect(true, null);
    }

    public final void connect(boolean loadData, List<StiDataSource> dataSources) {
        try {
            this.getDataSources().prepareData();
            if (dataSources != null) {
                for (StiDataSource source : dataSources) {
                    source.connect(loadData);
                }
            } else if (this.report.getRetrieveOnlyUsedData()) {
                Hashtable<String, Hashtable<String, String>> dataSourceNames = StiDataSourceHelper.getUsedDataSourcesNames(this.report);
                Iterator i$ = this.getDataSources().iterator();
                while (i$.hasNext()) {
                    StiDataSource dataSource = (StiDataSource)i$.next();
                    if (!dataSourceNames.containsKey(dataSource.getName())) continue;
                    dataSource.connect();
                }
            } else {
                this.getDataSources().connect(loadData);
            }
        }
        catch (StiException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    public final void ConnectVirtualDataSources() {
    }

    public final void ConnectCrossTabDataSources() {
    }

    private boolean EqualsColumns(DataColumn[] columns, DataColumn[] cols) {
        return true;
    }

    public boolean ShowOnlyAliasForDataRelation() {
        return false;
    }

    @Override
    public void restoreState(String stateName) {
    }

    @Override
    public void clearAllStates() {
    }

    public StiDataRelation getRelation(String dataRelationName) {
        return this.relations.get(dataRelationName);
    }

    public boolean existRelation(String dataRelationName) {
        return this.relations.exist(dataRelationName);
    }

    public boolean getShowOnlyAliasForVariable() {
        return false;
    }

    public boolean showOnlyAliasForBusinessObject() {
        return false;
    }

    public boolean ShowOnlyAliasForDatabase() {
        return false;
    }

    public boolean ShowOnlyAliasForDataColumn() {
        return false;
    }

    public void RegRelations(boolean b) {
    }

    public void Disconnect() {
        this.getDataSources().disconnect();
    }

    public final DataSet getCacheDataSet() {
        return this.cacheDataSet;
    }

    public final void setCacheDataSet(DataSet value) {
        this.cacheDataSet = value;
    }

    public JSONObject SaveToJsonObject(StiJsonSaveMode mode) throws JSONException {
        JSONObject jObject = new JSONObject();
        jObject.AddPropertyJObject("Resources", this.getResources().SaveToJsonObjectEx(mode));
        if (mode == StiJsonSaveMode.Report) {
            jObject.AddPropertyJObject("Variables", this.getVariables().SaveToJsonObjectEx(mode));
            jObject.AddPropertyJObject("DataSources", this.getDataSources().SaveToJsonObject(mode));
            jObject.AddPropertyJObject("Databases", this.getDatabases().SaveToJsonObject(mode));
            jObject.AddPropertyJObject("Relations", this.getRelations().SaveToJsonObject(mode));
        }
        if (jObject.length() == 0) {
            return null;
        }
        return jObject;
    }

    public void LoadFromJsonObject(JSONObject jObject) throws JSONException {
        for (JProperty property : jObject.Properties()) {
            if (property.Name.equals("Resources")) {
                this.resources.LoadFromJsonObjectEx((JSONObject)property.Value, this.report);
            }
            if (property.Name.equals("Variables")) {
                this.variables.LoadFromJsonObjectEx((JSONObject)property.Value, this.report);
                continue;
            }
            if (property.Name.equals("DataSources")) {
                this.dataSources.LoadFromJsonObject((JSONObject)property.Value);
                continue;
            }
            if (property.Name.equals("Databases")) {
                this.databases.LoadFromJsonObject((JSONObject)property.Value);
                continue;
            }
            if (property.Name.equals("BusinessObjects") || !property.Name.equals("Relations")) continue;
            this.relations.LoadFromJsonObject((JSONObject)property.Value);
        }
    }
}

