/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.report.dictionary;

import com.stimulsoft.base.exception.StiException;
import com.stimulsoft.base.json.JProperty;
import com.stimulsoft.base.json.JSONException;
import com.stimulsoft.base.json.JSONObject;
import com.stimulsoft.base.range.Range;
import com.stimulsoft.base.serializing.StiDeserializerControler;
import com.stimulsoft.base.serializing.StiSerializerControler;
import com.stimulsoft.base.serializing.interfaceobject.IStiSerializable;
import com.stimulsoft.base.serializing.utils.StiSerializTypeConverter;
import com.stimulsoft.base.serializing.utils.StiSerializerUtil;
import com.stimulsoft.base.serializing.utils.StiXMLConvert;
import com.stimulsoft.base.system.type.StiSystemString;
import com.stimulsoft.base.system.type.StiSystemType;
import com.stimulsoft.base.system.type.StiSystemTypeEnum;
import com.stimulsoft.lib.commoninterface.IStiName;
import com.stimulsoft.lib.utils.StiValidationUtil;
import com.stimulsoft.report.IStiInherited;
import com.stimulsoft.report.StiOptions;
import com.stimulsoft.report.StiReport;
import com.stimulsoft.report.components.StiComponent;
import com.stimulsoft.report.components.simplecomponents.StiImage;
import com.stimulsoft.report.components.simplecomponents.StiImageHelper;
import com.stimulsoft.report.components.simplecomponents.StiText;
import com.stimulsoft.report.dictionary.StiDialogInfo;
import com.stimulsoft.report.dictionary.StiVariableItem;
import com.stimulsoft.report.dictionary.enums.StiSelectionMode;
import com.stimulsoft.report.dictionary.enums.StiVariableInitBy;
import com.stimulsoft.report.engine.parser.StiParser;
import com.stimulsoft.report.export.tools.StiImageFormat;
import com.stimulsoft.report.expressions.StiExpression;
import java.util.ArrayList;
import java.util.Date;

public class StiVariable
extends StiExpression
implements IStiName,
IStiInherited,
Comparable<StiVariable> {
    private static String XML_DECLARATION_STR = "<?xml version=\"1.0\" encoding=\"utf-16\" standalone=\"yes\"?>";
    private boolean inherited;
    public String name = "";
    private StiDialogInfo dialogInfo = new StiDialogInfo();
    private String alias = "";
    private StiSystemType systemType;
    private boolean readOnly;
    private boolean requestFromUser;
    private String category = "";
    private String description = "";
    private StiVariableInitBy initBy = StiVariableInitBy.Value;
    private String key = "";
    private boolean allowUseAsSqlParameter;
    private StiSelectionMode selection = StiSelectionMode.FromVariable;
    private boolean needEncode = true;

    public StiVariable() {
        this("", "", StiSystemTypeEnum.SystemString.getSystemType(), "", false);
    }

    public StiVariable(String category) {
        this(category, "", (StiSystemType)new StiSystemString(), "", false);
    }

    public StiVariable(String name, StiSystemType type) {
        this("", name, name, type, "", false);
    }

    public StiVariable(String category, String name, StiSystemType type) {
        this(category, name, name, type, "", false);
    }

    public StiVariable(String name, Object value) {
        this("", name, value);
    }

    public StiVariable(String category, String name, Object value) {
        this(category, name, name, value, false);
    }

    public StiVariable(String category, String name, String alias, Object value) {
        this(category, name, alias, value, false);
    }

    public StiVariable(String category, String name, String alias, Object value, boolean readOnly) {
        this(category, name, alias, (StiSystemType)new StiSystemString(), value.toString(), readOnly);
    }

    public StiVariable(String category, String name, StiSystemType type, String value, boolean readOnly) {
        this(category, name, name, type, value, readOnly);
    }

    public StiVariable(String category, String name, String alias, StiSystemType type, String value, boolean readOnly) {
        this(category, name, alias, type, value, readOnly, StiVariableInitBy.Value);
    }

    public StiVariable(String category, String name, String alias, String description, StiSystemType type, String value, boolean readOnly) {
        this(category, name, alias, description, type, value, readOnly, StiVariableInitBy.Value, false);
    }

    public StiVariable(String category, String name, String alias, StiSystemType type, String value, boolean readOnly, StiVariableInitBy initBy) {
        this(category, name, alias, "", type, value, readOnly, initBy, false);
    }

    public StiVariable(String category, String name, String alias, String description, StiSystemType type, String value, boolean readOnly, StiVariableInitBy initBy) {
        this(category, name, alias, description, type, value, readOnly, initBy, false);
    }

    public StiVariable(String category, String name, String alias, String description, StiSystemType type, String value, boolean readOnly, StiVariableInitBy initBy, boolean requestFromUser) {
        this.category = category;
        this.name = name;
        this.alias = alias;
        this.description = description;
        this.systemType = type;
        this.readOnly = readOnly;
        this.initBy = initBy;
        this.setValue(value);
        this.requestFromUser = requestFromUser;
    }

    public StiVariable(String category, String name, String alias, String description, StiSystemType type, String value, boolean readOnly, StiVariableInitBy initBy, boolean requestFromUser, StiDialogInfo dialogInfo) {
        this.category = category;
        this.name = name;
        this.alias = alias;
        this.description = description;
        this.systemType = type;
        this.readOnly = readOnly;
        this.initBy = initBy;
        this.setValue(value);
        this.requestFromUser = requestFromUser;
        this.dialogInfo = dialogInfo;
    }

    @Override
    public final boolean getInherited() {
        return this.inherited;
    }

    @Override
    public final void setInherited(boolean value) {
        this.inherited = value;
    }

    public final String getName() {
        return this.name;
    }

    public final void setName(String value) {
        this.name = value;
    }

    @Override
    public boolean getApplyFormat() {
        return false;
    }

    public final StiDialogInfo getDialogInfo() {
        return this.dialogInfo;
    }

    public final void setDialogInfo(StiDialogInfo value) {
        this.dialogInfo = value;
    }

    public final String getAlias() {
        return this.alias;
    }

    public final void setAlias(String value) {
        this.alias = value;
    }

    public final StiSystemTypeEnum getType() {
        return this.systemType.getEnumType();
    }

    public final StiSystemType getSystemType() {
        return this.systemType;
    }

    public final boolean getReadOnly() {
        return this.readOnly;
    }

    public final void setReadOnly(boolean value) {
        this.readOnly = value;
        if (value) {
            this.requestFromUser = false;
        }
    }

    public final boolean getRequestFromUser() {
        return this.requestFromUser;
    }

    public final void setRequestFromUser(boolean value) {
        this.requestFromUser = value;
    }

    public final String getCategory() {
        return this.category;
    }

    public final void setCategory(String value) {
        this.category = value;
    }

    public final String getDescription() {
        return this.description;
    }

    public final void setDescription(String value) {
        this.description = value;
    }

    public final boolean getIsCategory() {
        return this.getName() == null || this.getName().length() == 0;
    }

    public final Object getValueObject() {
        String str = this.getValue();
        if (this.getInitBy() == StiVariableInitBy.Expression) {
            return this.getValue();
        }
        return this.systemType.getInstanceValueByString(str);
    }

    public Object getItemObject(String text) {
        return this.systemType.getItemValue(text);
    }

    public final void setValueObject(Object value) {
        if (this.getInitBy() == StiVariableInitBy.Expression) {
            this.setValue((String)(value instanceof String ? value : null));
        }
        if (value == null) {
            this.setValue("");
        } else {
            this.SetValue(value);
        }
    }

    public final String getInitByExpressionFrom() {
        String[] values = this.GetRangeValues();
        if (values == null) {
            return "";
        }
        return values[0];
    }

    public final void setInitByExpressionFrom(String value) {
        String[] values = this.GetRangeValues();
        String rangeTo = "";
        if (values != null) {
            rangeTo = values[1];
        }
        this.setValue(String.format("%s<<|>>%s", value, rangeTo));
    }

    public final String getInitByExpressionTo() {
        String[] values = this.GetRangeValues();
        if (values == null) {
            return "";
        }
        return values[1];
    }

    public final void setInitByExpressionTo(String value) {
        String[] values = this.GetRangeValues();
        String rangeFrom = "";
        if (values != null) {
            rangeFrom = values[0];
        }
        this.setValue(String.format("%s<<|>>%s", rangeFrom, value));
    }

    public final StiVariableInitBy getInitBy() {
        return this.initBy;
    }

    public final void setInitBy(StiVariableInitBy value) {
        this.initBy = value;
    }

    private String[] GetRangeValues() {
        String value = this.getValue();
        if (StiValidationUtil.isNullOrEmpty((String)value)) {
            return null;
        }
        if (!value.contains("<<|>>")) {
            return null;
        }
        String[] values = value.split("<<\\|>>");
        if (values.length != 2) {
            return null;
        }
        return values;
    }

    private void SetValue(Object value) {
        if (value instanceof String) {
            this.setValue(((String)value).trim());
        } else if (value instanceof StiImage) {
            this.setValue(StiImageHelper.imageToBase64(((StiImage)value).getBufferedImage(null), StiImageFormat.Png));
        } else if (value instanceof Range) {
            this.setValue(((Range)value).serialize());
        } else {
            this.setValue(value.toString());
        }
    }

    public final String GetNativeValue() {
        return super.getValue();
    }

    public static Date GetDateTimeFromValue(String value) {
        if (value.equals("null")) {
            return new Date();
        }
        return new Date(Date.parse(value));
    }

    public static String GetExpressionString(StiVariable variable) {
        if (variable != null) {
            return variable.name;
        }
        return "";
    }

    @Override
    public String serialize() {
        String data;
        String variableValue = StiXMLConvert.encodeName((String)super.getValue());
        String variableCategory = StiXMLConvert.encodeName((String)this.category);
        String variableName = StiXMLConvert.encodeName((String)this.name);
        String variableAlias = StiXMLConvert.encodeName((String)this.alias);
        String variableDescription = StiXMLConvert.encodeName((String)this.description);
        if (variableValue == null) {
            variableValue = "";
        }
        if (this.dialogInfo != null) {
            if (this.dialogInfo.getBindingVariable() != null) {
                this.dialogInfo.getBindingVariable().needEncode = false;
            }
            String dialogInfoStr = StiSerializerControler.serializedObjectAsString((IStiSerializable)this.dialogInfo);
            if (this.dialogInfo.getBindingVariable() != null) {
                this.dialogInfo.getBindingVariable().needEncode = true;
            }
            if (this.needEncode) {
                dialogInfoStr = StiXMLConvert.encodeName((String)dialogInfoStr);
            }
            data = StiSerializerUtil.serializFormat((String)"{0},{1},{2},{3},{4},{5},{6},{7},{8},{9},{10},{11},{12},{13}", (Object[])new Object[]{variableCategory, variableName, variableAlias, variableDescription, this.getTypeOrUserType(), variableValue, this.readOnly, this.initBy == StiVariableInitBy.Expression, this.requestFromUser, this.inherited, dialogInfoStr, this.key, this.allowUseAsSqlParameter, this.selection.toString()});
        } else {
            data = this.name == null && this.alias == null || this.name == "" && this.alias == "" ? (this.inherited ? StiSerializerUtil.serializFormat((String)"{0},{1}", (Object[])new Object[]{this.category, this.inherited}) : this.category) : (this.inherited ? (StiValidationUtil.isNullOrEmpty((String)this.description) && !this.requestFromUser ? StiSerializerUtil.serializFormat((String)"{0},{1},{2},{3},{4},{5},{6},{7}", (Object[])new Object[]{variableCategory, variableName, variableAlias, this.getTypeOrUserType(), variableValue, this.readOnly, this.initBy == StiVariableInitBy.Expression, this.inherited}) : StiSerializerUtil.serializFormat((String)"{0},{1},{2},{3},{4},{5},{6},{7},{8},{9}", (Object[])new Object[]{variableCategory, variableName, variableAlias, variableDescription, this.getTypeOrUserType(), variableValue, this.readOnly, this.initBy == StiVariableInitBy.Expression, this.requestFromUser, this.inherited})) : (StiValidationUtil.isNullOrEmpty((String)this.description) && !this.requestFromUser ? StiSerializerUtil.serializFormat((String)"{0},{1},{2},{3},{4},{5},{6}", (Object[])new Object[]{variableCategory, variableName, variableAlias, this.getTypeOrUserType(), variableValue, this.readOnly, this.initBy == StiVariableInitBy.Expression}) : StiSerializerUtil.serializFormat((String)"{0},{1},{2},{3},{4},{5},{6},{7},{8}", (Object[])new Object[]{variableCategory, variableName, variableAlias, variableDescription, this.getTypeOrUserType(), variableValue, this.readOnly, this.initBy == StiVariableInitBy.Expression, this.requestFromUser})));
        }
        return data;
    }

    private String getTypeOrUserType() {
        return this.systemType.getSerializeValue();
    }

    @Override
    public void deserialize(String strObject) {
        String[] values = strObject.split(",");
        if (values.length == 1 && StiXMLConvert.decodeName((String)strObject).split(",").length > 3) {
            values = StiXMLConvert.decodeName((String)strObject).split(",");
        }
        if (values.length == 1) {
            this.category = StiXMLConvert.decodeName((String)values[0]);
            this.readOnly = true;
        } else if (values.length == 2) {
            this.category = StiXMLConvert.decodeName((String)values[0]);
            this.readOnly = true;
            this.inherited = true;
        } else if (values.length == 5) {
            this.category = StiXMLConvert.decodeName((String)values[0]);
            this.name = StiXMLConvert.decodeName((String)values[1]);
            this.alias = StiXMLConvert.decodeName((String)values[1]);
            this.setTypeOrUserType(values[2]);
            this.setValueObject(StiXMLConvert.decodeName((String)values[3]));
            this.readOnly = StiSerializTypeConverter.stringToBoolean((String)values[4]);
        } else if (values.length == 6) {
            this.category = StiXMLConvert.decodeName((String)values[0]);
            this.name = StiXMLConvert.decodeName((String)values[1]);
            this.alias = StiXMLConvert.decodeName((String)values[2]);
            this.setTypeOrUserType(values[3]);
            this.setValueObject(StiXMLConvert.decodeName((String)values[4]));
            this.readOnly = StiSerializTypeConverter.stringToBoolean((String)values[5]);
        } else if (values.length == 7) {
            this.category = StiXMLConvert.decodeName((String)values[0]);
            this.name = StiXMLConvert.decodeName((String)values[1]);
            this.alias = StiXMLConvert.decodeName((String)values[2]);
            this.setTypeOrUserType(values[3]);
            this.setValueObject(StiXMLConvert.decodeName((String)values[4]));
            this.readOnly = StiSerializTypeConverter.stringToBoolean((String)values[5]);
            this.initBy = StiSerializTypeConverter.stringToBoolean((String)values[6]) ? StiVariableInitBy.Expression : StiVariableInitBy.Value;
        } else if (values.length == 8) {
            this.category = StiXMLConvert.decodeName((String)values[0]);
            this.name = StiXMLConvert.decodeName((String)values[1]);
            this.alias = StiXMLConvert.decodeName((String)values[2]);
            this.setTypeOrUserType(values[3]);
            this.setValueObject(StiXMLConvert.decodeName((String)values[4]));
            this.readOnly = StiSerializTypeConverter.stringToBoolean((String)values[5]);
            this.initBy = StiSerializTypeConverter.stringToBoolean((String)values[6]) ? StiVariableInitBy.Expression : StiVariableInitBy.Value;
            this.inherited = true;
        } else if (values.length == 9) {
            this.category = StiXMLConvert.decodeName((String)values[0]);
            this.name = StiXMLConvert.decodeName((String)values[1]);
            this.alias = StiXMLConvert.decodeName((String)values[2]);
            this.description = StiXMLConvert.decodeName((String)values[3]);
            this.setTypeOrUserType(values[4]);
            this.setValueObject(StiXMLConvert.decodeName((String)values[5]));
            this.readOnly = StiSerializTypeConverter.stringToBoolean((String)values[6]);
            this.initBy = StiSerializTypeConverter.stringToBoolean((String)values[7]) ? StiVariableInitBy.Expression : StiVariableInitBy.Value;
            this.requestFromUser = StiSerializTypeConverter.stringToBoolean((String)values[8]);
        } else if (values.length == 10) {
            this.category = StiXMLConvert.decodeName((String)values[0]);
            this.name = StiXMLConvert.decodeName((String)values[1]);
            this.alias = StiXMLConvert.decodeName((String)values[2]);
            this.description = StiXMLConvert.decodeName((String)values[3]);
            this.setTypeOrUserType(values[4]);
            this.setValueObject(StiXMLConvert.decodeName((String)values[5]));
            this.readOnly = StiSerializTypeConverter.stringToBoolean((String)values[6]);
            this.initBy = StiSerializTypeConverter.stringToBoolean((String)values[7]) ? StiVariableInitBy.Expression : StiVariableInitBy.Value;
            this.requestFromUser = StiSerializTypeConverter.stringToBoolean((String)values[8]);
            this.inherited = true;
        } else if (values.length == 11) {
            this.category = StiXMLConvert.decodeName((String)values[0]);
            this.name = StiXMLConvert.decodeName((String)values[1]);
            this.alias = StiXMLConvert.decodeName((String)values[2]);
            this.description = StiXMLConvert.decodeName((String)values[3]);
            this.setTypeOrUserType(values[4]);
            this.setValueObject(StiXMLConvert.decodeName((String)values[5]));
            this.readOnly = StiSerializTypeConverter.stringToBoolean((String)values[6]);
            this.initBy = StiSerializTypeConverter.stringToBoolean((String)values[7]) ? StiVariableInitBy.Expression : StiVariableInitBy.Value;
            this.requestFromUser = StiSerializTypeConverter.stringToBoolean((String)values[8]);
            this.inherited = StiSerializTypeConverter.stringToBoolean((String)values[9]);
            String dialogInfoStr = StiXMLConvert.decodeName((String)values[10]);
            this.deserializeDialogInfo(dialogInfoStr);
        } else if (values.length == 12) {
            this.category = StiXMLConvert.decodeName((String)values[0]);
            this.name = StiXMLConvert.decodeName((String)values[1]);
            this.alias = StiXMLConvert.decodeName((String)values[2]);
            this.description = StiXMLConvert.decodeName((String)values[3]);
            this.setTypeOrUserType(values[4]);
            this.setValueObject(StiXMLConvert.decodeName((String)values[5]));
            this.readOnly = StiSerializTypeConverter.stringToBoolean((String)values[6]);
            this.initBy = StiSerializTypeConverter.stringToBoolean((String)values[7]) ? StiVariableInitBy.Expression : StiVariableInitBy.Value;
            this.requestFromUser = StiSerializTypeConverter.stringToBoolean((String)values[8]);
            this.inherited = StiSerializTypeConverter.stringToBoolean((String)values[9]);
            String dialogInfoStr = StiXMLConvert.decodeName((String)values[10]);
            this.key = StiXMLConvert.decodeName((String)values[11]);
            this.deserializeDialogInfo(dialogInfoStr);
        } else if (values.length == 13) {
            this.category = StiXMLConvert.decodeName((String)values[0]);
            this.name = StiXMLConvert.decodeName((String)values[1]);
            this.alias = StiXMLConvert.decodeName((String)values[2]);
            this.description = StiXMLConvert.decodeName((String)values[3]);
            this.setTypeOrUserType(values[4]);
            this.setValueObject(StiXMLConvert.decodeName((String)values[5]));
            this.readOnly = StiSerializTypeConverter.stringToBoolean((String)values[6]);
            this.initBy = StiSerializTypeConverter.stringToBoolean((String)values[7]) ? StiVariableInitBy.Expression : StiVariableInitBy.Value;
            this.requestFromUser = StiSerializTypeConverter.stringToBoolean((String)values[8]);
            this.inherited = StiSerializTypeConverter.stringToBoolean((String)values[9]);
            String dialogInfoStr = StiXMLConvert.decodeName((String)values[10]);
            this.deserializeDialogInfo(dialogInfoStr);
            this.key = StiXMLConvert.decodeName((String)values[11]);
            this.allowUseAsSqlParameter = Boolean.parseBoolean(StiXMLConvert.decodeName((String)values[12]).toLowerCase());
        } else if (values.length == 14) {
            this.category = StiXMLConvert.decodeName((String)values[0]);
            this.name = StiXMLConvert.decodeName((String)values[1]);
            this.alias = StiXMLConvert.decodeName((String)values[2]);
            this.description = StiXMLConvert.decodeName((String)values[3]);
            this.setTypeOrUserType(values[4]);
            this.setValueObject(StiXMLConvert.decodeName((String)values[5]));
            this.readOnly = StiSerializTypeConverter.stringToBoolean((String)values[6]);
            this.initBy = StiSerializTypeConverter.stringToBoolean((String)values[7]) ? StiVariableInitBy.Expression : StiVariableInitBy.Value;
            this.requestFromUser = StiSerializTypeConverter.stringToBoolean((String)values[8]);
            this.inherited = StiSerializTypeConverter.stringToBoolean((String)values[9]);
            String dialogInfoStr = StiXMLConvert.decodeName((String)values[10]);
            this.deserializeDialogInfo(dialogInfoStr);
            this.key = StiXMLConvert.decodeName((String)values[11]);
            this.allowUseAsSqlParameter = Boolean.parseBoolean(StiXMLConvert.decodeName((String)values[12]).toLowerCase());
            this.selection = StiSelectionMode.valueOf(StiXMLConvert.decodeName((String)values[13]));
        }
    }

    private void deserializeDialogInfo(String dialogInfoStr) {
        int indexBegin = dialogInfoStr.indexOf("<BindingVariable>") + 17;
        int indexEnd = dialogInfoStr.indexOf("</BindingVariable>");
        if (indexBegin > 17) {
            dialogInfoStr = dialogInfoStr.substring(0, indexBegin) + StiXMLConvert.encodeName((String)dialogInfoStr.substring(indexBegin, indexEnd)) + dialogInfoStr.substring(indexEnd);
        }
        if (dialogInfoStr.startsWith("&lt;")) {
            dialogInfoStr = dialogInfoStr.replaceAll("&quot;", "\"").replaceAll("&apos;", "'").replaceAll("&lt;", "<").replaceAll("&gt;", ">").replaceAll("&amp;", "&");
        }
        StiDeserializerControler.deserializeFromString((String)dialogInfoStr, (IStiSerializable)this.dialogInfo);
    }

    public void setTypeOrUserType(String systemTypeName) {
        this.systemType = StiSystemType.getSystemType((String)systemTypeName);
    }

    public boolean isValueType() {
        return this.systemType.isValueType();
    }

    public Object getInstance() {
        return this.systemType.getInstance();
    }

    public boolean isRange() {
        return this.systemType.isRange();
    }

    public boolean isList() {
        return this.systemType.isList();
    }

    public boolean isTime() {
        return this.systemType.isTime();
    }

    public boolean isDecimal() {
        return this.systemType.isDecimal();
    }

    public boolean isInteger() {
        return this.systemType.isInteger();
    }

    public boolean isNullable() {
        return this.systemType.isNullable();
    }

    public Object getInitInstance(StiText tempText) {
        Object obj;
        if (this.isRange() && this.initBy == StiVariableInitBy.Expression) {
            Range range = (Range)this.systemType.getInstance();
            Object strFrom = StiParser.ParseTextValue("{" + this.getInitByExpressionFrom() + "}", (StiComponent)tempText);
            Object strTo = StiParser.ParseTextValue("{" + this.getInitByExpressionTo() + "}", (StiComponent)tempText);
            range.setFromAndTo(strFrom, strTo);
            obj = range;
        } else if (this.isList()) {
            ArrayList<StiVariableItem> items = this.getDialogInfoItems();
            ArrayList<Object> list = new ArrayList<Object>();
            for (StiVariableItem item : items) {
                list.add(item.getKeyObject());
            }
            obj = list;
        } else {
            obj = this.initBy == StiVariableInitBy.Expression ? StiParser.ParseTextValue("{" + this.getValue() + "}", (StiComponent)tempText) : this.systemType.getInstanceValueByString(this.getValue());
        }
        return obj;
    }

    public final void setDialogInfoItems(ArrayList<StiVariableItem> items) {
        if (items == null || items.isEmpty()) {
            this.dialogInfo.setEmptyKeysValue();
            return;
        }
        items = this.filterUniqueValues(items);
        this.dialogInfo.setKeys(new ArrayList<String>());
        this.dialogInfo.setValues(new ArrayList<String>());
        this.dialogInfo.setValuesBinding(new ArrayList<Object>());
        for (StiVariableItem item : items) {
            Object keyObject = null;
            keyObject = this.isRange() ? String.format("%s<<|>>%s", item.getKeyObject(), item.getKeyObjectTo()) : item.getKeyObject();
            if (this.initBy == StiVariableInitBy.Expression) {
                keyObject = String.format("{%s}", keyObject);
            }
            this.dialogInfo.getKeys().add(keyObject == null ? "" : keyObject.toString());
            this.dialogInfo.getValues().add(item.getLabel());
            this.dialogInfo.getValuesBinding().add(item.getValueBinding());
        }
    }

    public ArrayList<StiVariableItem> getDialogInfoItems() {
        ArrayList<StiVariableItem> items = new ArrayList<StiVariableItem>();
        for (int i = 0; i < this.dialogInfo.getKeys().size(); ++i) {
            String key = this.dialogInfo.getKeys().get(i);
            Object value = this.systemType.getItemValue(key);
            String label = this.dialogInfo.getLable(i);
            StiVariableItem item = new StiVariableItem(label, value);
            items.add(item);
        }
        return items;
    }

    private ArrayList<StiVariableItem> filterUniqueValues(ArrayList<StiVariableItem> items) {
        items.addAll(items);
        ArrayList<StiVariableItem> result = new ArrayList<StiVariableItem>();
        for (StiVariableItem item : items) {
            if (result.contains(item)) continue;
            result.add(item);
        }
        return result;
    }

    @Override
    public int compareTo(StiVariable var2) {
        int catFactor = this.getCategory().compareTo(var2.getCategory());
        if (catFactor == 0) {
            if (StiOptions.Designer.getSortDictionaryByAliases()) {
                return this.getAlias().compareTo(var2.getAlias());
            }
            return this.getName().compareTo(var2.getName());
        }
        return catFactor;
    }

    @Override
    public StiVariable clone() {
        StiVariable result = (StiVariable)super.clone();
        result.setDialogInfo(this.dialogInfo.clone());
        return result;
    }

    @Override
    public String toString() {
        if (this.getIsCategory()) {
            return this.getCategory();
        }
        if (StiOptions.Dictionary.getShowOnlyAliasForVariable()) {
            return this.getAlias();
        }
        if (this.getName().equals(this.getAlias())) {
            return this.name;
        }
        return this.getName() + " [" + this.getAlias() + "]";
    }

    public void setSystemType(StiSystemType systemType) {
        this.systemType = systemType;
    }

    public void setValue(Object value) {
        if (value != null) {
            this.setValue(value.toString());
        } else {
            this.setValue(null);
        }
    }

    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public boolean isAllowUseAsSqlParameter() {
        return this.allowUseAsSqlParameter;
    }

    public void setAllowUseAsSqlParameter(boolean allowUseAsSqlParameter) {
        this.allowUseAsSqlParameter = allowUseAsSqlParameter;
    }

    public StiSelectionMode getSelection() {
        return this.selection;
    }

    public void setSelection(StiSelectionMode selection) {
        this.selection = selection;
    }

    public JSONObject SaveToJsonObjectEx() throws JSONException {
        JSONObject jObject = new JSONObject();
        jObject.AddPropertyStringNullOfEmpty("Value", this.getValue());
        jObject.AddPropertyStringNullOfEmpty("Name", this.getName());
        jObject.AddPropertyJObject("DialogInfo", this.getDialogInfo().SaveToJsonObject());
        jObject.AddPropertyStringNullOfEmpty("Alias", this.getAlias());
        jObject.AddPropertyStringNullOfEmpty("Type", this.ConvertTypeToJsonString(this.getSystemType()));
        jObject.AddPropertyBool("ReadOnly", this.getReadOnly());
        jObject.AddPropertyBool("RequestFromUser", this.getRequestFromUser());
        jObject.AddPropertyStringNullOfEmpty("Category", this.getCategory());
        jObject.AddPropertyStringNullOfEmpty("Description", this.getDescription());
        jObject.AddPropertyEnum("InitBy", (Enum)this.getInitBy(), (Enum)StiVariableInitBy.Value);
        jObject.AddPropertyStringNullOfEmpty("Key", this.getKey());
        jObject.AddPropertyBool("AllowUseAsSqlParameter", this.isAllowUseAsSqlParameter());
        jObject.AddPropertyEnum("SelectionMode", (Enum)this.selection, (Enum)StiSelectionMode.FromVariable);
        return jObject;
    }

    public void LoadFromJsonObjectEx(JSONObject jObject, StiReport report) throws JSONException {
        super.LoadFromJsonObject(jObject);
        for (JProperty property : jObject.Properties()) {
            if (property.Name.equals("Name")) {
                this.name = (String)property.Value;
                continue;
            }
            if (property.Name.equals("DialogInfo")) {
                this.dialogInfo.LoadFromJsonObject((JSONObject)property.Value, report);
                continue;
            }
            if (property.Name.equals("Alias")) {
                this.alias = (String)property.Value;
                continue;
            }
            if (property.Name.equals("Type")) {
                this.systemType = this.ConvertJsonStringToType((String)property.Value);
                continue;
            }
            if (property.Name.equals("ReadOnly")) {
                this.readOnly = (Boolean)property.Value;
                continue;
            }
            if (property.Name.equals("RequestFromUser")) {
                this.requestFromUser = (Boolean)property.Value;
                continue;
            }
            if (property.Name.equals("Category")) {
                this.category = (String)property.Value;
                continue;
            }
            if (property.Name.equals("Description")) {
                this.description = (String)property.Value;
                continue;
            }
            if (property.Name.equals("InitBy")) {
                this.initBy = StiVariableInitBy.valueOf((String)property.Value);
                continue;
            }
            if (property.Name.equals("Key")) {
                this.key = (String)property.Value;
                continue;
            }
            if (property.Name.equals("AllowUseAsSqlParameter")) {
                this.setAllowUseAsSqlParameter((Boolean)property.Value);
                continue;
            }
            if (!property.Name.equals("SelectionMode")) continue;
            this.selection = StiSelectionMode.valueOf((String)property.Value);
        }
    }

    public Object eval(StiReport report) throws StiException {
        return StiParser.prepareVariableValue(this, report, null, true);
    }

    private String ConvertTypeToJsonString(StiSystemType type) {
        String typeName = type.getSerializeValue();
        return typeName;
    }

    private StiSystemType ConvertJsonStringToType(String text) {
        return StiSystemType.getSystemType((String)text);
    }

    @Override
    public boolean isDefault() {
        return StiValidationUtil.isNullOrEmpty((String)this.name) && StiValidationUtil.isNullOrEmpty((String)this.alias);
    }
}

