/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.report.dictionary.adapters;

import com.stimulsoft.report.dictionary.adapters.StiAbstractAdapter;
import com.stimulsoft.report.dictionary.adapters.StiJDBCParameters;
import com.stimulsoft.report.dictionary.dataSources.StiDataSource;
import com.stimulsoft.report.dictionary.dataSources.StiJDBCSource;
import java.util.HashMap;
import java.util.Map;

public class StiJdbcAdapter
extends StiAbstractAdapter {
    public StiJdbcAdapter(String connectionString) {
        super(connectionString);
    }

    @Override
    public StiJDBCParameters getJdbcParameters() {
        String validDriverName = this.validation(this.getDriverName(), "driver name");
        String validConnectionURL = this.validation(this.getConnectionURL(), "connection URL");
        String validUser = this.validation(this.getUser(), "user");
        String validPassword = this.validation(this.getPassword(), "password");
        String url = this.completeURL(validConnectionURL);
        HashMap<String, String> other = new HashMap<String, String>();
        return new StiJDBCParameters(validDriverName, url, validUser, validPassword, other);
    }

    private String completeURL(String validConnectionURL) {
        String result = validConnectionURL;
        for (Map.Entry<String, String> element : this.getParams().entrySet()) {
            String originalKey = this.parsedParameters.getOriginalKey(element.getKey());
            String value = element.getValue();
            if (originalKey == null || originalKey.trim().length() <= 0 || value == null || value.trim().length() <= 0) continue;
            result = result + ";" + originalKey + "=" + element.getValue();
        }
        return result;
    }

    @Override
    protected String getConnectionURL() {
        return this.getLeastOne(this.getUrlKeys());
    }

    @Override
    public String getDriverName() {
        return this.getLeastOne(this.getDriverKeys());
    }

    @Override
    protected String getDefaultPort() {
        throw new UnsupportedOperationException("in JdbcAdapter no default port ");
    }

    @Override
    public Class<? extends StiDataSource> getDataSourceClass() {
        return StiJDBCSource.class;
    }
}

