/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.report.dictionary.aggregateFunctions;

import com.stimulsoft.base.StiObjectConverter;
import com.stimulsoft.report.dictionary.aggregateFunctions.StiAggregateFunctionService;
import com.stimulsoft.report.dictionary.data.DBNull;
import java.math.BigDecimal;

public class StiMaxDecimalFunctionService
extends StiAggregateFunctionService {
    private double maximum;

    public StiMaxDecimalFunctionService() {
    }

    public StiMaxDecimalFunctionService(boolean runningTotal) {
        super(runningTotal);
    }

    @Override
    public void CalcItem(Object value) {
        if (value == null || value == DBNull.Value) {
            return;
        }
        long val = StiObjectConverter.ConvertToInt64((Object)value);
        if (this.maximum < (double)val) {
            this.maximum = val;
        }
    }

    @Override
    public boolean getRecureParam() {
        return true;
    }

    @Override
    public Class GetResultType() {
        return BigDecimal.class;
    }

    public String getServiceName() {
        return "Max";
    }

    @Override
    public Object GetValue() {
        return this.maximum;
    }

    @Override
    public void Init() {
        if (!this.getRunningTotal() || this.IsFirstInit) {
            this.maximum = -9.223372036854776E18;
        }
    }

    @Override
    public void SetValue(Object value) {
        this.maximum = ((Long)value).longValue();
    }
}

