/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.report.engine;

import com.stimulsoft.lib.utils.StiValidationUtil;
import com.stimulsoft.report.StiOptions;
import com.stimulsoft.report.StiReport;
import com.stimulsoft.report.components.StiComponent;
import com.stimulsoft.report.components.simplecomponents.StiText;
import com.stimulsoft.report.dictionary.StiDataColumn;
import com.stimulsoft.report.dictionary.StiDataParameter;
import com.stimulsoft.report.dictionary.StiVariable;
import com.stimulsoft.report.dictionary.StiVariableItem;
import com.stimulsoft.report.dictionary.dataSources.StiDataSource;
import com.stimulsoft.report.dictionary.dataSources.StiSqlSource;
import com.stimulsoft.report.dictionary.enums.StiItemsInitializationType;
import com.stimulsoft.report.dictionary.enums.StiSelectionMode;
import com.stimulsoft.report.dictionary.enums.StiVariableInitBy;
import com.stimulsoft.report.engine.parser.StiAsmCommand;
import com.stimulsoft.report.engine.parser.StiParser;
import com.stimulsoft.report.engine.parser.enums.StiAsmCommandType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;

public class StiVariableHelper {
    public static void setDefaultValueForRequestFromUserVariables(StiReport compiledReport) {
        StiSqlSource sql;
        StiDataSource ds;
        Hashtable<String, Boolean> vars = new Hashtable<String, Boolean>();
        StiText tempText = new StiText();
        tempText.setName("**VariableRequestFromUser**");
        tempText.setPage(compiledReport.getPages().get(0));
        Hashtable<String, String> hashSql = new Hashtable<String, String>();
        Iterator i$ = compiledReport.getDictionary().getDataSources().iterator();
        while (i$.hasNext()) {
            ds = (StiDataSource)i$.next();
            sql = ds instanceof StiSqlSource ? (StiSqlSource)ds : null;
            if (sql == null) continue;
            hashSql.put(ds.getName(), sql.getSqlCommand());
        }
        i$ = compiledReport.getDictionary().getVariables().iterator();
        while (i$.hasNext()) {
            StiVariable variable = (StiVariable)i$.next();
            if (!variable.getRequestFromUser() || compiledReport.getModifiedVariables().containsKey(variable.getName())) continue;
            try {
                vars.put(variable.getName(), true);
                if (variable.getSelection() == StiSelectionMode.FromVariable && variable.getInitBy() == StiVariableInitBy.Expression) {
                    compiledReport.setVariable(variable.getName(), StiParser.ParseTextValue("{" + variable.getValue() + "}", (StiComponent)tempText));
                }
                if (variable.getSelection() != StiSelectionMode.First) continue;
                compiledReport.setVariable(variable.getName(), StiReport.changeType(variable.getDialogInfo().getKeys().get(0), variable.getType().getSystemType()));
            }
            catch (Exception e) {
                if (StiOptions.Engine.logLevel < 10) continue;
                e.printStackTrace();
            }
        }
        if (vars.size() == 0) {
            return;
        }
        i$ = compiledReport.getDictionary().getDataSources().iterator();
        while (i$.hasNext()) {
            ds = (StiDataSource)i$.next();
            sql = ds instanceof StiSqlSource ? (StiSqlSource)ds : null;
            if (sql == null) continue;
            try {
                boolean found;
                String oldSql = (String)hashSql.get(ds.getName());
                String newSql = sql.getFinalSqlCommand();
                boolean bl = found = oldSql != newSql;
                if (!found) {
                    found = StiVariableHelper.checkExpressionForVariables(sql.getSqlCommand(), tempText, vars);
                }
                if (!found) {
                    for (StiDataParameter parameter : sql.getParameters()) {
                        if (StiValidationUtil.isNullOrWhiteSpace((String)parameter.getExpression()) || !StiVariableHelper.checkExpressionForVariables(parameter.getExpression(), tempText, vars)) continue;
                        found = true;
                        break;
                    }
                }
                if (!found) continue;
                ds.disconnect();
                ds.connect();
            }
            catch (Exception e) {}
        }
    }

    private static boolean checkExpressionForVariables(String expression, StiComponent component, Hashtable<String, Boolean> vars) {
        block4: {
            try {
                boolean storeToPrint = false;
                Object result = StiParser.ParseTextValue(expression, component, storeToPrint, false, true, false);
                if (result != null && result instanceof List) {
                    for (StiAsmCommand asmCommand : (List)result) {
                        String varName;
                        if (asmCommand.Type != StiAsmCommandType.PushVariable || !vars.containsKey(varName = asmCommand.Parameter1.toString())) continue;
                        return true;
                    }
                }
            }
            catch (Exception e) {
                if (StiOptions.Engine.logLevel < 10) break block4;
                e.printStackTrace();
            }
        }
        return false;
    }

    public static void FillItemsOfVariables(StiReport report) {
        Iterator i$ = report.getDictionary().getVariables().iterator();
        while (i$.hasNext()) {
            StiVariable variable = (StiVariable)i$.next();
            if (!StiVariableHelper.fillItemsOfVariable(variable, report)) continue;
            return;
        }
    }

    public static boolean fillItemsOfVariable(StiVariable variable, StiReport report) {
        if (variable.getDialogInfo() == null) {
            return false;
        }
        if (variable.getDialogInfo().getItemsInitializationType() == StiItemsInitializationType.Items) {
            ArrayList<StiVariableItem> items = variable.getDialogInfoItems();
            if (items != null && items.size() > 0) {
                List list = (List)(report.getVariable(variable.getName()) instanceof List ? report.getVariable(variable.getName()) : null);
                if (list == null) {
                    return false;
                }
                if (list.size() > 0) {
                    return true;
                }
                list.clear();
                for (StiVariableItem item : items) {
                    list.add(item.getKeyObject());
                }
            }
        } else {
            Object[] valuesBinding;
            List list;
            Object[] keys;
            if (variable.getDialogInfo().getKeys() != null && variable.getDialogInfo().getKeys().size() > 0 || variable.getDialogInfo().getValues() != null && variable.getDialogInfo().getValues().size() > 0) {
                return false;
            }
            Object[] objectArray = keys = !StiValidationUtil.isNullOrEmpty((String)variable.getDialogInfo().getKeysColumn()) ? StiDataColumn.GetDatasFromDataColumn(report.getDictionary(), variable.getDialogInfo().getKeysColumn()) : null;
            if (variable.isList() && keys != null && keys.length > 0 && (list = (List)(report.getVariable(variable.getName()) instanceof List ? report.getVariable(variable.getName()) : null)) != null) {
                list.clear();
                for (Object key : keys) {
                    list.add(key);
                }
            }
            Object[] values = !StiValidationUtil.isNullOrEmpty((String)variable.getDialogInfo().getValuesColumn()) ? StiDataColumn.GetDatasFromDataColumn(report.getDictionary(), variable.getDialogInfo().getValuesColumn()) : null;
            Object[] objectArray2 = valuesBinding = !StiValidationUtil.isNullOrEmpty((String)variable.getDialogInfo().getBindingValuesColumn()) ? StiDataColumn.GetDatasFromDataColumn(report.getDictionary(), variable.getDialogInfo().getBindingValuesColumn()) : null;
            if (keys == null) {
                keys = new Object[]{};
            }
            if (values == null) {
                values = new Object[]{};
            }
            if (valuesBinding == null) {
                valuesBinding = new Object[]{};
            }
            int length = Math.max(keys.length, values.length);
            ArrayList<StiVariableItem> items = new ArrayList<StiVariableItem>();
            for (int index = 0; index < length; ++index) {
                Object key = keys.length > index ? keys[index] : null;
                String value = values.length > index ? values[index].toString() : "";
                Object valueBinding = valuesBinding.length > index ? valuesBinding[index] : null;
                StiVariableItem item = new StiVariableItem();
                if (key != null) {
                    item.setKeyObject(key);
                }
                item.setLabel(value);
                item.setValueBinding(valueBinding);
                items.add(item);
            }
            ArrayList<StiVariableItem> itemsFiltered = new ArrayList<StiVariableItem>();
            HashMap<Object, Object> hash = new HashMap<Object, Object>();
            for (StiVariableItem item : items) {
                if (hash.containsKey(item.getKeyObject())) continue;
                hash.put(item.getKeyObject(), item.getKeyObject());
                itemsFiltered.add(item);
            }
            ArrayList<StiVariableItem> resultItem = variable.getDialogInfo().isBindingValue() ? items : itemsFiltered;
            variable.setDialogInfoItems(resultItem);
        }
        return false;
    }
}

