/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.report.engine.engineV2;

import com.stimulsoft.base.drawing.enums.StiVertAlignment;
import com.stimulsoft.base.system.StiGuid;
import com.stimulsoft.base.system.StiSize;
import com.stimulsoft.base.system.geometry.StiRectangle;
import com.stimulsoft.lib.utils.StiValidationUtil;
import com.stimulsoft.report.StiOptions;
import com.stimulsoft.report.chart.StiChart;
import com.stimulsoft.report.components.StiComponent;
import com.stimulsoft.report.components.StiComponentsCollection;
import com.stimulsoft.report.components.StiPage;
import com.stimulsoft.report.components.StiWatermark;
import com.stimulsoft.report.components.bands.StiDataBand;
import com.stimulsoft.report.components.bands.StiOverlayBand;
import com.stimulsoft.report.components.bands.StiReportSummaryBand;
import com.stimulsoft.report.components.bands.StiReportTitleBand;
import com.stimulsoft.report.components.complexcomponents.StiContainer;
import com.stimulsoft.report.components.complexcomponents.StiContainerHelper;
import com.stimulsoft.report.components.complexcomponents.StiPanel;
import com.stimulsoft.report.components.complexcomponents.StiSubReport;
import com.stimulsoft.report.components.enums.StiComponentType;
import com.stimulsoft.report.components.enums.StiDockStyle;
import com.stimulsoft.report.components.simplecomponents.StiCrossLinePrimitive;
import com.stimulsoft.report.components.table.StiTable;
import com.stimulsoft.report.crossTab.StiCrossTab;
import com.stimulsoft.report.crossTab.StiCrossTabHelper;
import com.stimulsoft.report.crossTab.StiCrossTabParams;
import com.stimulsoft.report.crossTab.enums.StiCrossHorAlignment;
import com.stimulsoft.report.dictionary.businessObjects.StiBusinessObject;
import com.stimulsoft.report.engine.engineV2.StiEngine;
import com.stimulsoft.report.engine.engineV2.StiSubReportsHelper;
import com.stimulsoft.report.engine.engineV2.builders.StiCrossTabV2Builder;
import com.stimulsoft.report.engine.engineV2.builders.StiV2Builder;
import com.stimulsoft.report.helpers.StiExpressionHelper;
import com.stimulsoft.report.options.EngineOptions;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Hashtable;
import java.util.Iterator;

public class StiPageHelper {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void CreateListOfDataBands(StiPage page, ArrayList dataBandsOnPage, ArrayList dataBandsInContainers, ArrayList subReportsOnPage, ArrayList crossTabsOnPage) {
        StiDataBand dataBand;
        StiComponentsCollection comps;
        StiComponentsCollection stiComponentsCollection = comps = page.GetComponents();
        synchronized (stiComponentsCollection) {
            for (StiComponent comp : comps) {
                StiCrossTab crossTab;
                StiSubReport subReport;
                dataBand = (StiDataBand)(comp instanceof StiDataBand ? comp : null);
                if (dataBand != null && (dataBand.getMasterComponent() == null || dataBand.getMasterComponent() == page.getPageInfoV2().MasterDataBand)) {
                    if (dataBand instanceof StiTable && !dataBand.getEnabled()) continue;
                    boolean isSubBusinessObject = false;
                    if (!dataBand.getIsBusinessObjectEmpty() && dataBand.getBusinessObject().getParentBusinessObject() != null) {
                        StiDataBand parentDataBand = null;
                        if (dataBand.getParent() instanceof StiPage && dataBandsOnPage.size() > 0) {
                            parentDataBand = dataBandsOnPage.get(dataBandsOnPage.size() - 1) instanceof StiDataBand ? dataBandsOnPage.get(dataBandsOnPage.size() - 1) : null;
                        } else if (dataBandsInContainers.size() > 0) {
                            parentDataBand = dataBandsInContainers.get(dataBandsInContainers.size() - 1) instanceof StiDataBand ? dataBandsInContainers.get(dataBandsInContainers.size() - 1) : null;
                        }
                        if (parentDataBand != null && !parentDataBand.getIsBusinessObjectEmpty() && parentDataBand.getBusinessObjectGuid() == dataBand.getBusinessObject().getParentBusinessObject().getGuid()) {
                            isSubBusinessObject = true;
                        }
                    }
                    if (!isSubBusinessObject) {
                        if (dataBand.getParent() instanceof StiPage) {
                            dataBandsOnPage.add(dataBand);
                        } else if (StiSubReportsHelper.GetParentBand(dataBand) == null) {
                            dataBandsInContainers.add(dataBand);
                        }
                    }
                }
                if ((subReport = (StiSubReport)(comp instanceof StiSubReport ? comp : null)) != null && subReport.getEnabled() && StiSubReportsHelper.GetParentBand(subReport) == null && !page.getPrintOnPreviousPage()) {
                    subReportsOnPage.add(subReport);
                }
                if ((crossTab = (StiCrossTab)(comp instanceof StiCrossTab ? comp : null)) == null || !comp.getEnabled() || StiSubReportsHelper.GetParentBand((StiContainer)(comp instanceof StiContainer ? comp : null)) != null) continue;
                crossTabsOnPage.add(crossTab);
            }
        }
        boolean checkAgain = true;
        while (checkAgain) {
            checkAgain = false;
            Hashtable<StiBusinessObject, StiBusinessObject> list = new Hashtable<StiBusinessObject, StiBusinessObject>();
            for (int index = 0; index < dataBandsOnPage.size(); ++index) {
                dataBand = dataBandsOnPage.get(index) instanceof StiDataBand ? dataBandsOnPage.get(index) : null;
                if (dataBand.getIsBusinessObjectEmpty()) continue;
                StiBusinessObject businessObject = dataBand.getBusinessObject();
                if (businessObject.getParentBusinessObject() != null && list.get((Object)businessObject.getParentBusinessObject()) == null && dataBand.getMasterComponent() == null) {
                    StiDataBand newDataBand = new StiDataBand();
                    newDataBand.setBusinessObjectGuid(businessObject.getParentBusinessObject().getGuid());
                    newDataBand.setHeight(0.0);
                    newDataBand.setPage(page);
                    newDataBand.setParent(dataBand.getParent());
                    newDataBand.Prepare();
                    dataBandsOnPage.set(index, newDataBand);
                    checkAgain = true;
                    continue;
                }
                list.put(businessObject, businessObject);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ArrayList GetReportTitles(StiPage page) {
        ArrayList<StiReportTitleBand> reportTitles = new ArrayList<StiReportTitleBand>();
        if (page.getTitleBeforeHeader()) {
            return reportTitles;
        }
        StiComponentsCollection stiComponentsCollection = page.getComponents();
        synchronized (stiComponentsCollection) {
            for (StiComponent comp : page.getComponents()) {
                StiReportTitleBand titleBand = (StiReportTitleBand)(comp instanceof StiReportTitleBand ? comp : null);
                if (titleBand == null) continue;
                reportTitles.add(titleBand);
            }
        }
        return reportTitles;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ArrayList GetReportSummaries(StiPage page) {
        ArrayList<StiReportSummaryBand> reportSummaries = new ArrayList<StiReportSummaryBand>();
        StiComponentsCollection stiComponentsCollection = page.getComponents();
        synchronized (stiComponentsCollection) {
            for (StiComponent comp : page.getComponents()) {
                StiReportSummaryBand summaryBand = (StiReportSummaryBand)(comp instanceof StiReportSummaryBand ? comp : null);
                if (summaryBand == null) continue;
                reportSummaries.add(summaryBand);
            }
        }
        return reportSummaries;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void RenderSimpleComponents(StiPage page, StiContainer outContainer) {
        StiPage panel;
        int columnsCount = 0;
        double fullColumnWidth = 0.0;
        StiPage stiPage = panel = page instanceof StiPanel ? page : null;
        if (panel != null) {
            columnsCount = panel.getColumns() < 2 ? 1 : panel.getColumns();
            fullColumnWidth = panel.getColumnWidthM() + panel.getColumnGaps();
        }
        for (int index = 0; index < columnsCount; ++index) {
            page.getReport().setColumn(index + 1);
            StiComponentsCollection stiComponentsCollection = page.getComponents();
            synchronized (stiComponentsCollection) {
                for (StiComponent component : page.getComponents()) {
                    StiChart chart;
                    if (component.getComponentType() != StiComponentType.Simple) continue;
                    component.parentBookmark = outContainer.getCurrentBookmark();
                    StiComponent renderedComponent = component.render();
                    if (renderedComponent == null) continue;
                    if (panel != null && panel.getColumns() > 1 && !(renderedComponent instanceof StiCrossLinePrimitive)) {
                        if (panel.getRightToLeft()) {
                            renderedComponent.setLeft(renderedComponent.getLeft() + (page.getWidth() - fullColumnWidth * (double)(index + 1) + panel.getColumnGaps()));
                        } else {
                            renderedComponent.setLeft(renderedComponent.getLeft() + fullColumnWidth * (double)index);
                        }
                    }
                    outContainer.getComponents().add(renderedComponent);
                    if (!StiOptions.Engine.getAllowInteractionInChartWithComponents() || (chart = (StiChart)(renderedComponent instanceof StiChart ? renderedComponent : null)) == null || chart.getChartInfoV2().interactiveComps == null) continue;
                    for (StiComponent stiComponent : chart.getChartInfoV2().interactiveComps) {
                        stiComponent.setLeft(stiComponent.getLeft() + renderedComponent.getLeft());
                        stiComponent.setTop(stiComponent.getTop() + renderedComponent.getTop());
                        outContainer.getComponents().add(stiComponent);
                    }
                }
                continue;
            }
        }
        StiContainerHelper.checkSize(page.getReport().getEngine().getContainerForRender());
        Hashtable compsHash = new Hashtable();
        StiComponentsCollection comps = outContainer.GetComponents();
        Iterator i$ = page.getComponents();
        synchronized (i$) {
            for (StiComponent comp : comps) {
                ArrayList<StiContainer> list;
                StiContainer cont = (StiContainer)(comp instanceof StiContainer ? comp : null);
                if (cont == null) continue;
                ArrayList<StiContainer> arrayList = list = compsHash.get(cont.getName()) instanceof ArrayList ? (ArrayList<StiContainer>)compsHash.get(cont.getName()) : null;
                if (list == null) {
                    list = new ArrayList<StiContainer>();
                    compsHash.put(cont.getName(), list);
                }
                list.add(cont);
            }
        }
        for (ArrayList list : compsHash.values()) {
            int index = 1;
            ArrayList arrayList = list;
            synchronized (arrayList) {
                for (StiContainer stiContainer : list) {
                    stiContainer.getContainerInfoV2().RenderStep = index++;
                }
            }
        }
        page.getReport().setColumn(1);
        outContainer.DockToContainer();
    }

    public static void PrepareBookmark(StiPage page) {
        page.parentBookmark = page.getReport().getBookmark();
        page.doBookmark();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void RenderPage(StiPage page) {
        StiEngine containerEngine;
        ArrayList index2;
        StiEngine containerEngine2;
        page.InvokeBeginRender();
        if (page.getResetPageNumber()) {
            if (page.getPageInfoV2() != null && page.getPageInfoV2().IndexOfStartRenderedPages != -1) {
                page.getReport().engine.getPageNumbers().ResetPageNumber(page.getPageInfoV2().IndexOfStartRenderedPages);
            } else {
                page.getReport().engine.getPageNumbers().ResetPageNumber();
            }
        }
        ArrayList reportTitles = StiPageHelper.GetReportTitles(page);
        ArrayList reportSummaries = StiPageHelper.GetReportSummaries(page);
        ArrayList dataBandsOnPage = new ArrayList();
        ArrayList dataBandsInContainers = new ArrayList();
        ArrayList subReportsOnPage = new ArrayList();
        ArrayList crossTabsOnPage = new ArrayList();
        StiPageHelper.CreateListOfDataBands(page, dataBandsOnPage, dataBandsInContainers, subReportsOnPage, crossTabsOnPage);
        StiEngine masterEngine = page.getReport().engine;
        ArrayList arrayList = dataBandsInContainers;
        synchronized (arrayList) {
            for (StiDataBand dataBand : dataBandsInContainers) {
                containerEngine2 = masterEngine.getThreads().CreateContainerEngine(dataBand.getParent().getName(), page.getReport(), masterEngine, page.getPageInfoV2().IndexOfStartRenderedPages);
                page.getReport().engine.getSlaveEngines().put(dataBand.getParent().getName(), containerEngine2);
            }
        }
        arrayList = subReportsOnPage;
        synchronized (arrayList) {
            for (StiSubReport subReport : subReportsOnPage) {
                containerEngine2 = masterEngine.getThreads().CreateContainerEngine(subReport.getName(), page.getReport(), masterEngine, page.getPageInfoV2().IndexOfStartRenderedPages);
                page.getReport().engine.getSlaveEngines().put(subReport.getName(), containerEngine2);
            }
        }
        arrayList = crossTabsOnPage;
        synchronized (arrayList) {
            for (StiComponent crossTab : crossTabsOnPage) {
                containerEngine2 = masterEngine.getThreads().CreateContainerEngine(crossTab.getName(), page.getReport(), masterEngine, page.getPageInfoV2().IndexOfStartRenderedPages);
                page.getReport().engine.getSlaveEngines().put(crossTab.getName(), containerEngine2);
            }
        }
        if (dataBandsOnPage.size() > 0) {
            int index2 = 1;
            Iterator<Object> i$ = dataBandsOnPage;
            synchronized (i$) {
                for (StiDataBand dataBand : dataBandsOnPage) {
                    if (dataBand instanceof StiTable && !dataBand.getEnabled()) continue;
                    try {
                        if (index2 == 1) {
                            page.getReport().engine.setIsFirstDataBandOnPage(true);
                            dataBand.getDataBandInfoV2().ReportTitles = reportTitles;
                        }
                        if (index2 == dataBandsOnPage.size()) {
                            page.getReport().engine.setIsLastDataBandOnPage(true);
                            dataBand.getDataBandInfoV2().ReportSummaries = reportSummaries;
                        }
                        dataBand.parentBookmark = page.getCurrentBookmark();
                        dataBand.renderMaster();
                    }
                    finally {
                        dataBand.getDataBandInfoV2().ReportTitles = null;
                        dataBand.getDataBandInfoV2().ReportSummaries = null;
                        page.getReport().engine.setIsFirstDataBandOnPage(false);
                        page.getReport().engine.setIsLastDataBandOnPage(false);
                    }
                    ++index2;
                }
            }
        }
        if (reportTitles != null) {
            index2 = reportTitles;
            synchronized (index2) {
                for (StiReportTitleBand title : reportTitles) {
                    if (!title.getPrintIfEmpty()) continue;
                    title.parentBookmark = page.getCurrentBookmark();
                    title.doBookmark();
                    page.getReport().engine.RenderBand(title);
                }
            }
        }
        if (reportSummaries != null) {
            index2 = reportSummaries;
            synchronized (index2) {
                for (StiReportSummaryBand summary : reportSummaries) {
                    if (!summary.getPrintIfEmpty()) continue;
                    summary.parentBookmark = page.getCurrentBookmark();
                    summary.doBookmark();
                    page.getReport().engine.RenderBand(summary);
                }
            }
        }
        try {
            for (StiDataBand dataBand : dataBandsInContainers) {
                containerEngine = masterEngine.getSlaveEngines().get(dataBand.getParent().getName());
                if (containerEngine.getFreeSpace() == 0.0) {
                    containerEngine.setFreeSpace(dataBand.getParent().getHeight());
                }
                double oldHeight = dataBand.getParent().getHeight();
                if (dataBand.getParent() != null && dataBand.getParent().canGrow && dataBand.getParent().getParent() instanceof StiPage && containerEngine.getFreeSpace() < 5.0E10) {
                    containerEngine.setFreeSpace(masterEngine.getPositionBottomY() - dataBand.getParent().top);
                    if (containerEngine.getContainerForRender() != null) {
                        containerEngine.getContainerForRender().setHeight(containerEngine.getFreeSpace());
                    }
                }
                page.getReport().engine = containerEngine;
                if (containerEngine.getContainerForRender() != null) {
                    dataBand.parentBookmark = containerEngine.getContainerForRender().getCurrentBookmark();
                }
                dataBand.renderMaster();
            }
        }
        finally {
            page.getReport().engine = masterEngine;
        }
        try {
            for (StiSubReport subReport : subReportsOnPage) {
                page.getReport().engine = containerEngine = masterEngine.getSlaveEngines().get(subReport.getName());
                StiContainer tempContainer = new StiContainer(subReport.getClientRectangle());
                tempContainer.setName("Temp Container");
                tempContainer.setCanBreak(true);
                StiSubReportsHelper.RenderSubReport(tempContainer, subReport);
                double maxHeight = 0.0;
                for (StiComponent comp : tempContainer.getComponents()) {
                    maxHeight = Math.max(comp.getBottom(), maxHeight);
                }
                tempContainer.setHeight(maxHeight);
                if (containerEngine.getContainerForRender() == null) continue;
                containerEngine.RenderContainer(tempContainer);
            }
        }
        finally {
            page.getReport().engine = masterEngine;
        }
        try {
            for (StiComponent crossTab : crossTabsOnPage) {
                page.getReport().engine = containerEngine = masterEngine.getSlaveEngines().get(crossTab.getName());
                StiCrossTabParams pars = new StiCrossTabParams();
                StiCrossTab crossTabComp = (StiCrossTab)(crossTab instanceof StiCrossTab ? crossTab : null);
                StiCrossTabHelper.CreateCross(crossTabComp);
                while (!pars.getRenderingIsFinished() && containerEngine.getContainerForRender() != null) {
                    if (crossTabComp.getHorAlignment() == StiCrossHorAlignment.None) {
                        containerEngine.getContainerForRender().setWidth(containerEngine.getContainerForRender().getParent().getWidth() - containerEngine.getContainerForRender().getLeft());
                    } else {
                        containerEngine.getContainerForRender().setWidth(containerEngine.getContainerForRender().getParent().getWidth());
                    }
                    boolean doCanShrink = false;
                    if (containerEngine.getContainerForRender().getParent().getCanShrink() && containerEngine.getContainerForRender().getParent().getHeight() == 0.0) {
                        StiComponent parent = page.GetComponents().get(containerEngine.getContainerForRender().getParent().getName());
                        doCanShrink = true;
                        containerEngine.getContainerForRender().getParent().setWidth(parent.getWidth());
                        containerEngine.getContainerForRender().getParent().setHeight(parent.getHeight());
                        containerEngine.getContainerForRender().setWidth(parent.getWidth());
                        containerEngine.getContainerForRender().setHeight(parent.getHeight());
                    } else {
                        containerEngine.getContainerForRender().setHeight(containerEngine.getContainerForRender().getParent().getHeight() - containerEngine.getContainerForRender().top);
                    }
                    StiRectangle rect = containerEngine.getContainerForRender().getClientRectangle();
                    pars.setDestinationRectangle(rect);
                    pars.setDestinationContainer(containerEngine.getContainerForRender());
                    StiV2Builder tempVar4 = StiV2Builder.GetBuilder(StiCrossTab.class);
                    StiCrossTabV2Builder builder = (StiCrossTabV2Builder)(tempVar4 instanceof StiCrossTabV2Builder ? tempVar4 : null);
                    builder.RenderCrossTab(pars, crossTabComp);
                    if (doCanShrink) {
                        StiSize size = containerEngine.getContainerForRender().getParent().getActualSize();
                        containerEngine.getContainerForRender().getParent().setWidth(size.getWidth());
                        containerEngine.getContainerForRender().getParent().setHeight(size.getHeight());
                    }
                    if (pars.getRenderingIsFinished()) continue;
                    containerEngine.NewDestination();
                }
            }
        }
        finally {
            page.getReport().engine = masterEngine;
        }
        page.InvokeEndRender();
        page.setIsRendered(true);
        Collection<StiEngine> collection = masterEngine.getSlaveEngines().values();
        synchronized (collection) {
            for (StiEngine engine : masterEngine.getSlaveEngines().values()) {
                engine.FinalClear();
            }
        }
        page.getReport().engine.getSlaveEngines().clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void RenderOverlays(StiPage masterPage, StiPage renderedPage) {
        ArrayList<StiOverlayBand> overlays = masterPage.getPageInfoV2().overlays;
        if (overlays != null) {
            Object comp22;
            Object renderedComponent;
            ArrayList<Object> overlayTop = new ArrayList<Object>();
            ArrayList<Object> overlayCenter = new ArrayList<Object>();
            ArrayList<Object> overlayBottom = new ArrayList<Object>();
            for (StiOverlayBand overlay : overlays) {
                renderedComponent = overlay.render();
                if (renderedComponent == null) continue;
                ((StiComponent)renderedComponent).setDockStyle(StiDockStyle.None);
                renderedPage.getComponents().add((StiComponent)renderedComponent);
                if (overlay.getVertAlignment() == StiVertAlignment.Top) {
                    overlayTop.add(renderedComponent);
                } else if (overlay.getVertAlignment() == StiVertAlignment.Center) {
                    overlayCenter.add(renderedComponent);
                } else if (overlay.getVertAlignment() == StiVertAlignment.Bottom) {
                    overlayBottom.add(renderedComponent);
                }
                renderedComponent = null;
            }
            double top = -masterPage.getMargins().getTop();
            renderedComponent = overlayTop;
            synchronized (renderedComponent) {
                for (Object comp22 : overlayTop) {
                    ((StiComponent)comp22).top = top;
                    top += ((StiComponent)comp22).getHeight();
                }
            }
            double bottom = masterPage.getHeight() + masterPage.getMargins().getBottom();
            comp22 = overlayBottom;
            synchronized (comp22) {
                for (StiComponent arrayList : overlayBottom) {
                    arrayList.top = bottom - arrayList.getHeight();
                    bottom -= arrayList.getHeight();
                }
            }
            double height = 0.0;
            ArrayList<Object> arrayList = overlayCenter;
            synchronized (arrayList) {
                for (StiComponent stiComponent : overlayCenter) {
                    height += stiComponent.getHeight();
                }
            }
            top = (masterPage.getHeight() - height) / 2.0;
            ArrayList<Object> arrayList2 = overlayCenter;
            synchronized (arrayList2) {
                for (StiComponent stiComponent : overlayCenter) {
                    stiComponent.top = top;
                    top += stiComponent.getHeight();
                }
            }
        }
    }

    public static StiPage GetPageFromTemplate(StiPage templatePage) {
        Object tempVar = templatePage.clone(false, false);
        StiPage page = (StiPage)(tempVar instanceof StiPage ? tempVar : null);
        StiWatermark watermark = page.getWatermark();
        if (watermark != null) {
            if (EngineOptions.Watermark.isAllowExpression()) {
                watermark.setText(StiExpressionHelper.parseText(page, watermark.getText()));
            }
            if (!StiValidationUtil.isNullOrEmpty((String)watermark.getEnabledExpression())) {
                watermark.setEnabled(StiExpressionHelper.parseBool(page, watermark.getEnabledExpression()));
            }
        }
        if (templatePage.getPageInfoV2().RenderedCount > 0) {
            page.setGuid(StiGuid.newGuidString());
        }
        page.invokeEvents();
        StiPageHelper.RenderOverlays(templatePage, page);
        ++templatePage.getPageInfoV2().RenderedCount;
        return page;
    }
}

