/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.report.engine.parser;

import com.stimulsoft.base.StiTokenType;
import com.stimulsoft.base.exception.StiException;
import com.stimulsoft.base.exception.StiParserException;
import com.stimulsoft.base.range.DateTimeRange;
import com.stimulsoft.base.range.Range;
import com.stimulsoft.base.range.TimeSpanRange;
import com.stimulsoft.base.system.StiDateTime;
import com.stimulsoft.base.system.StiTimeSpan;
import com.stimulsoft.base.system.type.ParameterType;
import com.stimulsoft.base.system.type.StiSystemTypeEnum;
import com.stimulsoft.base.utils.StiConvertHelper;
import com.stimulsoft.base.utils.StiLoggingUtil;
import com.stimulsoft.lib.enums.StiTypeCode;
import com.stimulsoft.lib.utils.StiTypeConverter;
import com.stimulsoft.lib.utils.StiValidationUtil;
import com.stimulsoft.report.Func;
import com.stimulsoft.report.StiCustomFunction;
import com.stimulsoft.report.StiNameValidator;
import com.stimulsoft.report.StiOptions;
import com.stimulsoft.report.StiReport;
import com.stimulsoft.report.components.StiComponent;
import com.stimulsoft.report.components.StiComponentsCollection;
import com.stimulsoft.report.components.bands.StiBand;
import com.stimulsoft.report.components.bands.StiDataBand;
import com.stimulsoft.report.components.bands.StiGroupHeaderBand;
import com.stimulsoft.report.components.simplecomponents.StiText;
import com.stimulsoft.report.crossTab.StiCrossCell;
import com.stimulsoft.report.dictionary.StiCalcDataColumn;
import com.stimulsoft.report.dictionary.StiDataColumn;
import com.stimulsoft.report.dictionary.StiDataRelation;
import com.stimulsoft.report.dictionary.StiDataRow;
import com.stimulsoft.report.dictionary.StiVariable;
import com.stimulsoft.report.dictionary.businessObjects.StiBusinessObject;
import com.stimulsoft.report.dictionary.data.DBNull;
import com.stimulsoft.report.dictionary.dataSources.StiDataSource;
import com.stimulsoft.report.dictionary.dataSources.StiDataSourceHelper;
import com.stimulsoft.report.dictionary.dataSources.StiDataSourcesCollection;
import com.stimulsoft.report.dictionary.enums.StiVariableInitBy;
import com.stimulsoft.report.dictionary.functions.StiFunction;
import com.stimulsoft.report.dictionary.functions.StiFunctions;
import com.stimulsoft.report.engine.StiParserParameters;
import com.stimulsoft.report.engine.StiVariableHelper;
import com.stimulsoft.report.engine.engineV2.StiEngine;
import com.stimulsoft.report.engine.operations.StiAddOperation;
import com.stimulsoft.report.engine.operations.StiMultiplyOperation;
import com.stimulsoft.report.engine.operations.StiSubtractOperation;
import com.stimulsoft.report.engine.parser.ParserErrorCode;
import com.stimulsoft.report.engine.parser.StiAsmCommand;
import com.stimulsoft.report.engine.parser.StiCallFunction;
import com.stimulsoft.report.engine.parser.StiParserMethodInfo;
import com.stimulsoft.report.engine.parser.enums.StiAsmCommandType;
import com.stimulsoft.report.engine.parser.enums.StiFunctionType;
import com.stimulsoft.report.engine.parser.enums.StiMethodType;
import com.stimulsoft.report.engine.parser.enums.StiParserDataType;
import com.stimulsoft.report.engine.parser.enums.StiPropertyType;
import com.stimulsoft.report.engine.parser.enums.StiSystemVariableType;
import com.stimulsoft.report.expressions.StiExpression;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.MathContext;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Stack;
import java.util.logging.Logger;

public class StiParser {
    private static final Logger LOGGER = Logger.getLogger("com.stimulsoft.report.engine.parser.StiParser");
    private static Hashtable<StiFunctionType, List<StiParserMethodInfo>> methodsHash = null;
    private static final StiParserMethodInfo[] methods;
    private static Hashtable<String, Object> constantsList;
    private static Object namespaceObj;
    private static Hashtable<String, Object> namespacesList;
    private StiReport report = null;
    private String inputExpression = "";
    private StiComponent component = null;
    private boolean checkSyntaxMode = false;
    private Object sender;
    private int position = 0;
    private ArrayList<StiToken> tokensList = null;
    private StiToken currentToken = null;
    private int tokenPos = 0;
    private ArrayList<StiAsmCommand> asmList = null;
    private Hashtable<String, String> hashAliases = null;
    private Hashtable<String, Object> componentsList = null;
    private int expressionPosition = 0;
    private HashMap<String, Integer> userFunctionsList = null;
    private static String[] errorsList;

    private Hashtable<String, Object> getComponentsList() {
        if (this.componentsList == null) {
            this.componentsList = new Hashtable();
            StiComponentsCollection comps = this.report.getComponents();
            for (StiComponent comp : comps) {
                this.componentsList.put(comp.getName(), comp);
            }
            this.componentsList.put("this", this.report);
        }
        return this.componentsList;
    }

    private void eval_exp() {
        this.tokenPos = 0;
        if (this.tokensList.isEmpty()) {
            this.ThrowError(2);
            return;
        }
        this.eval_exp0();
        if (this.tokenPos <= this.tokensList.size()) {
            this.ThrowError(6);
        }
    }

    private void eval_exp0() {
        this.getToken();
        this.eval_exp01();
    }

    private void eval_exp01() {
        if (this.currentToken.Type == StiTokenType.Variable) {
            StiToken variableToken = this.currentToken;
            this.getToken();
            if (this.currentToken.Type != StiTokenType.Assign) {
                --this.tokenPos;
                this.currentToken = this.tokensList.get(this.tokenPos - 1);
            } else {
                this.getToken();
                this.eval_exp1();
                this.asmList.add(new StiAsmCommand(StiAsmCommandType.CopyToVariable, variableToken.Value));
                return;
            }
        }
        this.eval_exp1();
    }

    private void eval_exp1() {
        this.eval_exp10();
        if (this.currentToken.Type == StiTokenType.Question) {
            if (this.checkSyntaxMode) {
                this.getToken();
                this.eval_exp10();
                if (this.currentToken.Type != StiTokenType.Colon) {
                    this.ThrowError(ParserErrorCode.SyntaxError, this.currentToken);
                }
                this.getToken();
                this.eval_exp10();
                this.asmList.add(new StiAsmCommand(StiAsmCommandType.PushFunction, (Object)StiFunctionType.IIF, 3));
            } else {
                this.getToken();
                StiAsmCommand jump1 = new StiAsmCommand(StiAsmCommandType.JumpFalse, 0, null);
                this.asmList.add(jump1);
                int addr1 = this.asmList.size();
                this.eval_exp10();
                if (this.currentToken.Type != StiTokenType.Colon) {
                    this.ThrowError(ParserErrorCode.SyntaxError, this.currentToken);
                }
                StiAsmCommand jump2 = new StiAsmCommand(StiAsmCommandType.Jump, 0, null);
                this.asmList.add(jump2);
                int addr2 = this.asmList.size();
                this.getToken();
                this.eval_exp10();
                jump1.Parameter1 = addr2 - addr1;
                jump2.Parameter1 = this.asmList.size() - addr2;
            }
        }
    }

    private void eval_exp10() {
        this.eval_exp11();
        while (this.currentToken.Type == StiTokenType.DoubleOr) {
            this.getToken();
            this.eval_exp11();
            this.asmList.add(new StiAsmCommand(StiAsmCommandType.Or2));
        }
    }

    private void eval_exp11() {
        this.eval_exp12();
        while (this.currentToken.Type == StiTokenType.DoubleAnd) {
            this.getToken();
            this.eval_exp12();
            this.asmList.add(new StiAsmCommand(StiAsmCommandType.And2));
        }
    }

    private void eval_exp12() {
        this.eval_exp14();
        if (this.currentToken.Type == StiTokenType.Or) {
            this.getToken();
            this.eval_exp14();
            this.asmList.add(new StiAsmCommand(StiAsmCommandType.Or));
        }
    }

    private void eval_exp14() {
        this.eval_exp15();
        if (this.currentToken.Type == StiTokenType.Xor) {
            this.getToken();
            this.eval_exp15();
            this.asmList.add(new StiAsmCommand(StiAsmCommandType.Xor));
        }
    }

    private void eval_exp15() {
        this.eval_exp16();
        while (this.currentToken.Type == StiTokenType.And) {
            this.getToken();
            this.eval_exp16();
            this.asmList.add(new StiAsmCommand(StiAsmCommandType.And));
        }
    }

    private void eval_exp16() {
        this.eval_exp17();
        if (this.currentToken.Type == StiTokenType.Equal || this.currentToken.Type == StiTokenType.NotEqual) {
            StiAsmCommand command = new StiAsmCommand(StiAsmCommandType.CompareEqual);
            if (this.currentToken.Type == StiTokenType.NotEqual) {
                command.Type = StiAsmCommandType.CompareNotEqual;
            }
            this.getToken();
            this.eval_exp17();
            this.asmList.add(command);
        }
    }

    private void eval_exp17() {
        this.eval_exp18();
        if (this.currentToken.Type == StiTokenType.Left || this.currentToken.Type == StiTokenType.LeftEqual || this.currentToken.Type == StiTokenType.Right || this.currentToken.Type == StiTokenType.RightEqual) {
            StiAsmCommand command = null;
            if (this.currentToken.Type == StiTokenType.Left) {
                command = new StiAsmCommand(StiAsmCommandType.CompareLeft);
            }
            if (this.currentToken.Type == StiTokenType.LeftEqual) {
                command = new StiAsmCommand(StiAsmCommandType.CompareLeftEqual);
            }
            if (this.currentToken.Type == StiTokenType.Right) {
                command = new StiAsmCommand(StiAsmCommandType.CompareRight);
            }
            if (this.currentToken.Type == StiTokenType.RightEqual) {
                command = new StiAsmCommand(StiAsmCommandType.CompareRightEqual);
            }
            this.getToken();
            this.eval_exp18();
            this.asmList.add(command);
        }
    }

    private void eval_exp18() {
        this.eval_exp2();
        if (this.currentToken.Type == StiTokenType.Shl || this.currentToken.Type == StiTokenType.Shr) {
            StiAsmCommand command = new StiAsmCommand(StiAsmCommandType.Shl);
            if (this.currentToken.Type == StiTokenType.Shr) {
                command.Type = StiAsmCommandType.Shr;
            }
            this.getToken();
            this.eval_exp2();
            this.asmList.add(command);
        }
    }

    private void eval_exp2() {
        this.eval_exp3();
        while (this.currentToken.Type == StiTokenType.Plus || this.currentToken.Type == StiTokenType.Minus) {
            StiToken operation = this.currentToken;
            this.getToken();
            this.eval_exp3();
            if (operation.Type == StiTokenType.Minus) {
                this.asmList.add(new StiAsmCommand(StiAsmCommandType.Sub));
                continue;
            }
            if (operation.Type != StiTokenType.Plus) continue;
            this.asmList.add(new StiAsmCommand(StiAsmCommandType.Add));
        }
    }

    private void eval_exp3() {
        this.eval_exp4();
        while (this.currentToken.Type == StiTokenType.Mult || this.currentToken.Type == StiTokenType.Div || this.currentToken.Type == StiTokenType.Percent) {
            StiToken operation = this.currentToken;
            this.getToken();
            this.eval_exp4();
            if (operation.Type == StiTokenType.Mult) {
                this.asmList.add(new StiAsmCommand(StiAsmCommandType.Mult));
            } else if (operation.Type == StiTokenType.Div) {
                this.asmList.add(new StiAsmCommand(StiAsmCommandType.Div));
            }
            if (operation.Type != StiTokenType.Percent) continue;
            this.asmList.add(new StiAsmCommand(StiAsmCommandType.Mod));
        }
    }

    private void eval_exp4() {
        this.eval_exp5();
        if (this.currentToken.Type == StiTokenType.Xor) {
            this.getToken();
            this.eval_exp4();
            this.asmList.add(new StiAsmCommand(StiAsmCommandType.Power));
        }
    }

    private void eval_exp5() {
        StiAsmCommand command = null;
        if (this.currentToken.Type == StiTokenType.Plus || this.currentToken.Type == StiTokenType.Minus || this.currentToken.Type == StiTokenType.Not) {
            if (this.currentToken.Type == StiTokenType.Minus) {
                command = new StiAsmCommand(StiAsmCommandType.Neg);
            }
            if (this.currentToken.Type == StiTokenType.Not) {
                command = new StiAsmCommand(StiAsmCommandType.Not);
            }
            this.getToken();
        }
        this.eval_exp6();
        if (command != null) {
            this.asmList.add(command);
        }
    }

    private void eval_exp6() {
        if (this.currentToken.Type == StiTokenType.LParenthesis) {
            this.getToken();
            if (this.currentToken.Type == StiTokenType.Cast) {
                StiTypeCode typeCode = (StiTypeCode)StiTypeCode.getTypesList().get(this.currentToken.Value);
                this.getToken();
                if (this.currentToken.Type != StiTokenType.RParenthesis) {
                    this.ThrowError(8);
                }
                this.getToken();
                this.eval_exp5();
                this.asmList.add(new StiAsmCommand(StiAsmCommandType.Cast, typeCode));
            } else {
                this.eval_exp1();
                if (this.currentToken.Type != StiTokenType.RParenthesis) {
                    this.ThrowError(8);
                }
                this.getToken();
                if (this.currentToken.Type == StiTokenType.Dot) {
                    this.getToken();
                    this.eval_exp7();
                }
                if (this.currentToken.Type == StiTokenType.LBracket) {
                    this.eval_exp62();
                }
            }
        } else {
            this.eval_exp62();
        }
    }

    private void eval_exp62() {
        if (this.currentToken.Type == StiTokenType.LBracket) {
            int argsCount;
            for (argsCount = 0; argsCount == 0 || this.currentToken.Type == StiTokenType.Comma; ++argsCount) {
                this.getToken();
                this.eval_exp1();
            }
            if (this.currentToken.Type != StiTokenType.RBracket) {
                this.ThrowError(0, this.currentToken);
            }
            this.asmList.add(new StiAsmCommand(StiAsmCommandType.PushArrayElement, argsCount + 1));
            this.getToken();
            if (this.currentToken.Type == StiTokenType.LBracket) {
                this.eval_exp62();
            }
            if (this.currentToken.Type == StiTokenType.Dot) {
                this.getToken();
                this.eval_exp7();
            }
        } else {
            this.eval_exp7();
        }
    }

    private void eval_exp7() {
        this.atom();
        if (this.currentToken.Type == StiTokenType.Dot) {
            this.getToken();
            this.eval_exp7();
        }
        if (this.currentToken.Type == StiTokenType.LBracket) {
            this.eval_exp62();
        }
    }

    private void atom() {
        if (this.currentToken.Type == StiTokenType.Variable) {
            this.asmList.add(new StiAsmCommand(StiAsmCommandType.PushVariable, this.currentToken.Value));
            this.getToken();
            return;
        }
        if (this.currentToken.Type == StiTokenType.SystemVariable) {
            this.asmList.add(new StiAsmCommand(StiAsmCommandType.PushSystemVariable, StiSystemVariableType.getSystemVariablesList().get(this.currentToken.Value)));
            this.getToken();
            return;
        }
        if (this.currentToken.Type == StiTokenType.Function) {
            StiToken function = this.currentToken;
            StiFunctionType functionType = StiFunctionType.getFunctionsList().get(function.Value);
            this.asmList.add(new StiAsmCommand(StiAsmCommandType.PushFunction, (Object)functionType, this.get_args_count((Object)functionType), null, this.expressionPosition + function.Position, function.Length));
            this.getToken();
            return;
        }
        if (this.currentToken.Type == StiTokenType.Method) {
            StiToken method = this.currentToken;
            StiMethodType methodType = StiMethodType.getMethodsList().get(method.Value);
            this.asmList.add(new StiAsmCommand(StiAsmCommandType.PushMethod, (Object)methodType, this.get_args_countForMetod(methodType) + 1));
            this.getToken();
            return;
        }
        if (this.currentToken.Type == StiTokenType.CustomFunction) {
            StiToken function = this.currentToken;
            this.asmList.add(new StiAsmCommand(StiAsmCommandType.PushFunction, (Object)StiFunctionType.CustomFunction, this.get_args_count((Object)StiFunctionType.CustomFunction), function.Value));
            this.getToken();
            return;
        }
        if (this.currentToken.Type == StiTokenType.Property) {
            StiToken function = this.currentToken;
            this.asmList.add(new StiAsmCommand(StiAsmCommandType.PushProperty, (Object)StiPropertyType.getPropertiesList().get(function.Value)));
            this.getToken();
            return;
        }
        if (this.currentToken.Type == StiTokenType.DataSourceField) {
            this.asmList.add(new StiAsmCommand(StiAsmCommandType.PushDataSourceField, this.currentToken.Value, this.currentToken.ValueObject));
            this.getToken();
            return;
        }
        if (this.currentToken.Type == StiTokenType.BusinessObjectField) {
            this.asmList.add(new StiAsmCommand(StiAsmCommandType.PushBusinessObjectField, this.currentToken.Value));
            this.getToken();
            return;
        }
        if (this.currentToken.Type == StiTokenType.Component) {
            this.asmList.add(new StiAsmCommand(StiAsmCommandType.PushComponent, this.getComponentsList().get(this.currentToken.Value), null, null, this.expressionPosition + this.currentToken.Position, this.currentToken.Length));
            this.getToken();
            return;
        }
        if (this.currentToken.Type == StiTokenType.Number) {
            this.asmList.add(new StiAsmCommand(StiAsmCommandType.PushValue, this.currentToken.ValueObject));
            this.getToken();
            return;
        }
        if (this.currentToken.Type == StiTokenType.String) {
            this.asmList.add(new StiAsmCommand(StiAsmCommandType.PushValue, this.currentToken.ValueObject));
            this.getToken();
            return;
        }
        if (this.currentToken.Type == StiTokenType.Empty) {
            this.ThrowError(4);
        }
        this.ThrowError(0, this.currentToken, "Token type: " + this.currentToken.Type + "; value: " + this.currentToken.Value + "; valueObject: " + this.currentToken.ValueObject, "Input expression: " + this.inputExpression, "Position: " + this.position, "Token position" + this.tokenPos);
    }

    private int get_args_count(Object name) {
        ArrayList<StiAsmCommand> arg0;
        ArrayList<StiAsmCommand> newCommand;
        StiComponent aggregateComponent;
        int posFunc = -1;
        if (this.currentToken != null) {
            posFunc = this.currentToken.Position;
        }
        ArrayList<ArrayList<StiAsmCommand>> args = this.get_args();
        StiFunctionType func = (StiFunctionType)((Object)name);
        if (func == StiFunctionType.Count && args.isEmpty() || (func.intValue >= StiFunctionType.CountDistinct.intValue && func.intValue <= StiFunctionType.Last.intValue || func.intValue >= StiFunctionType.cCountDistinct.intValue && func.intValue <= StiFunctionType.cLast.intValue || func.intValue >= StiFunctionType.rCountDistinct.intValue && func.intValue <= StiFunctionType.rLast.intValue) && args.size() == 1 || func == StiFunctionType.iCount && args.size() == 1 || (func.intValue >= StiFunctionType.iCountDistinct.intValue && func.intValue <= StiFunctionType.iLast.intValue || func.intValue >= StiFunctionType.ciCountDistinct.intValue && func.intValue <= StiFunctionType.ciLast.intValue || func.intValue >= StiFunctionType.riCountDistinct.intValue && func.intValue <= StiFunctionType.riLast.intValue) && args.size() == 2) {
            aggregateComponent = this.component.GetGroupHeaderBand();
            if (aggregateComponent == null) {
                aggregateComponent = this.component.GetDataBand();
            }
            newCommand = new ArrayList<StiAsmCommand>();
            newCommand.add(new StiAsmCommand(StiAsmCommandType.PushComponent, aggregateComponent, null, null, this.expressionPosition + posFunc, -1));
            args.add(0, newCommand);
        }
        if ((func.intValue >= StiFunctionType.Count.intValue && func.intValue <= StiFunctionType.Last.intValue || func.intValue >= StiFunctionType.cCount.intValue && func.intValue <= StiFunctionType.cLast.intValue || func.intValue >= StiFunctionType.rCount.intValue && func.intValue <= StiFunctionType.rLast.intValue || func.intValue == StiFunctionType.cCount.intValue || func.intValue >= StiFunctionType.iCount.intValue && func.intValue <= StiFunctionType.iLast.intValue || func.intValue >= StiFunctionType.ciCount.intValue && func.intValue <= StiFunctionType.ciLast.intValue || func.intValue >= StiFunctionType.riCount.intValue && func.intValue <= StiFunctionType.riLast.intValue || func.intValue == StiFunctionType.ciCount.intValue) && (aggregateComponent = this.component.GetGroupHeaderBand()) != null) {
            newCommand = new ArrayList();
            newCommand.add(new StiAsmCommand(StiAsmCommandType.PushComponent, aggregateComponent));
            args.set(0, newCommand);
        }
        if ((func.intValue >= StiFunctionType.cCount.intValue && func.intValue <= StiFunctionType.cLast.intValue || func.intValue >= StiFunctionType.rCount.intValue && func.intValue <= StiFunctionType.rLast.intValue || func.intValue >= StiFunctionType.ciCount.intValue && func.intValue <= StiFunctionType.ciLast.intValue || func.intValue >= StiFunctionType.riCount.intValue && func.intValue <= StiFunctionType.riLast.intValue) && args.size() > 0 && (arg0 = args.get(0)) != null && arg0.size() > 0 && arg0.get((int)0).Type == StiAsmCommandType.PushComponent && arg0.get((int)0).Parameter1 instanceof StiBand) {
            String dataBandName = ((StiBand)(arg0.get((int)0).Parameter1 instanceof StiBand ? arg0.get((int)0).Parameter1 : null)).getName();
            if (this.report.DataBandsUsedInPageTotals == null) {
                this.report.DataBandsUsedInPageTotals = new String[1];
                this.report.DataBandsUsedInPageTotals[0] = dataBandName;
            } else {
                boolean finded3 = false;
                for (String str : this.report.DataBandsUsedInPageTotals) {
                    if (!dataBandName.equals(str)) continue;
                    finded3 = true;
                    break;
                }
                if (!finded3) {
                    String[] strs = new String[this.report.DataBandsUsedInPageTotals.length + 1];
                    for (int indexStr = 0; indexStr < this.report.DataBandsUsedInPageTotals.length; ++indexStr) {
                        strs[indexStr] = this.report.DataBandsUsedInPageTotals[indexStr];
                    }
                    strs[this.report.DataBandsUsedInPageTotals.length] = dataBandName;
                    this.report.DataBandsUsedInPageTotals = strs;
                }
            }
        }
        int bitsValue = 0;
        if (StiFunctionType.getParametersList().containsKey(name)) {
            bitsValue = StiFunctionType.getParametersList().get(name);
        }
        int bitsCounter = 1;
        for (ArrayList<StiAsmCommand> arg : args) {
            if ((bitsValue & bitsCounter) > 0) {
                this.asmList.add(new StiAsmCommand(StiAsmCommandType.PushValue, arg));
            } else {
                this.asmList.addAll(arg);
            }
            bitsCounter <<= 1;
        }
        return args.size();
    }

    private int get_args_countForMetod(StiMethodType methodType) {
        ArrayList<ArrayList<StiAsmCommand>> args = this.get_args();
        int bitsValue = 0;
        if (StiFunctionType.getParametersList().contains((Object)methodType)) {
            bitsValue = StiFunctionType.getParametersList().get((Object)methodType);
        }
        int bitsCounter = 1;
        for (ArrayList<StiAsmCommand> arg : args) {
            if ((bitsValue & bitsCounter) > 0) {
                this.asmList.add(new StiAsmCommand(StiAsmCommandType.PushValue, arg));
            } else {
                this.asmList.addAll(arg);
            }
            bitsCounter <<= 1;
        }
        return args.size();
    }

    private Object call_arrayElement(ArrayList argsList) {
        Object baseValue = argsList.get(0);
        if (argsList.size() < 2) {
            this.ThrowError(11, "get_ArrayElement", argsList.size() - 1);
        }
        if (baseValue instanceof String) {
            if (argsList.size() != 2) {
                this.ThrowError(11, "String.get_Item", argsList.size() - 1);
            }
            int index = Integer.parseInt(argsList.get(1).toString());
            return Character.valueOf(((String)baseValue).charAt(index));
        }
        if (baseValue instanceof StiDataSource) {
            Object result = ((StiDataSource)baseValue).GetData((String)argsList.get(1));
            return result != null ? result : DBNull.Value;
        }
        try {
            Class[] parameterTypes = new Class[argsList.size() - 1];
            Object[] args = new Object[argsList.size() - 1];
            for (int i = 1; i < argsList.size(); ++i) {
                parameterTypes[i - 1] = argsList.get(i).getClass();
                args[i - 1] = argsList.get(i);
            }
            Method method = baseValue.getClass().getMethod("get", parameterTypes);
            return method.invoke(baseValue, args);
        }
        catch (Exception exception) {
            return null;
        }
    }

    private ArrayList<ArrayList<StiAsmCommand>> get_args() {
        ArrayList<ArrayList<StiAsmCommand>> args = new ArrayList<ArrayList<StiAsmCommand>>();
        this.getToken();
        if (this.currentToken.Type != StiTokenType.LParenthesis) {
            this.ThrowError(7);
        }
        this.getToken();
        if (this.currentToken.Type == StiTokenType.RParenthesis) {
            return args;
        }
        --this.tokenPos;
        this.currentToken = this.tokensList.get(this.tokenPos - 1);
        ArrayList<StiAsmCommand> tempAsmList = this.asmList;
        do {
            this.asmList = new ArrayList();
            this.eval_exp0();
            args.add(this.asmList);
        } while (this.currentToken.Type == StiTokenType.Comma);
        this.asmList = tempAsmList;
        if (this.currentToken.Type != StiTokenType.RParenthesis) {
            this.ThrowError(8);
        }
        return args;
    }

    private void getToken() {
        this.currentToken = this.tokenPos < this.tokensList.size() ? this.tokensList.get(this.tokenPos) : new StiToken();
        ++this.tokenPos;
    }

    private void ThrowError(int code) {
        this.ThrowError(code, null, "", "", "", "");
    }

    private void ThrowError(int code, String message1) {
        this.ThrowError(code, null, message1, "", "", "");
    }

    private void ThrowError(int code, String message1, String message2) {
        this.ThrowError(code, null, message1, message2, "", "");
    }

    private void ThrowError(int code, String message1, String message2, String message3) {
        this.ThrowError(code, null, message1, message2, message3, "");
    }

    private void ThrowError(int code, String message1, String message2, String message3, String message4) {
        this.ThrowError(code, null, message1, message2, message3, message4);
    }

    private void ThrowError(int code, StiToken token) {
        this.ThrowError(code, token, "", "", "", "");
    }

    private void ThrowError(int code, StiToken token, String message1) {
        this.ThrowError(code, token, message1, "", "", "");
    }

    private void ThrowError(int code, StiToken token, String message1, String message2) {
        this.ThrowError(code, token, message1, message2, "", "");
    }

    private void ThrowError(int code, StiToken token, String message1, String message2, String message3) {
        this.ThrowError(code, token, message1, message2, message3, "");
    }

    private void ThrowError(int code, StiToken token, String message1, String message2, String message3, String message4) {
        String errorMessage = "Parser error: Unknown error";
        if (code < errorsList.length) {
            errorMessage = "Parser error: " + String.format(errorsList[code], message1, message2, message3, message4);
        }
        StiParserException exception = new StiParserException(errorMessage);
        exception.BaseMessage = errorMessage;
        if (token != null) {
            exception.Position = this.expressionPosition + token.Position;
            exception.Length = token.Length;
        }
        if (this.report != null) {
            this.report.WriteToReportRenderingMessages(errorMessage + (token != null ? "Position: " + exception.Position + " Length: " + token.Length : ""));
        }
        throw exception;
    }

    private StiToken getNextLexem() {
        int pos2;
        while (this.position < this.inputExpression.length() && this.isWhiteSpace(this.inputExpression.charAt(this.position))) {
            ++this.position;
        }
        if (this.position >= this.inputExpression.length()) {
            return null;
        }
        StiToken token = null;
        char ch = this.inputExpression.charAt(this.position);
        if (Character.isLetter(ch) || ch == '_') {
            int pos22;
            for (pos22 = this.position + 1; pos22 < this.inputExpression.length() && (Character.isLetterOrDigit(this.inputExpression.charAt(pos22)) || this.inputExpression.charAt(pos22) == '_'); ++pos22) {
            }
            token = new StiToken();
            token.Value = this.inputExpression.substring(this.position, pos22);
            token.Type = StiTokenType.Identifier;
            token.Position = this.position;
            token.Length = pos22 - this.position;
            this.position = pos22;
            String alias = token.Value;
            if (token.Position > 0 && this.inputExpression.charAt(token.Position - 1) == '.') {
                alias = "." + alias;
            }
            if (this.hashAliases.containsKey(alias)) {
                token.Value = this.hashAliases.get(alias);
            }
            return token;
        }
        if (Character.isDigit(ch)) {
            token = new StiToken();
            token.Type = StiTokenType.Number;
            token.Position = this.position;
            token.ValueObject = this.scanNumber();
            token.Length = this.position - token.Position;
            return token;
        }
        if (ch == '\"') {
            int pos23;
            ++this.position;
            for (pos23 = this.position; pos23 < this.inputExpression.length() && this.inputExpression.charAt(pos23) != '\"'; ++pos23) {
                if (this.inputExpression.charAt(pos23) != '\\') continue;
                ++pos23;
            }
            token = new StiToken();
            token.Type = StiTokenType.String;
            token.ValueObject = this.inputExpression.substring(this.position, pos23);
            token.Position = this.position - 1;
            this.position = pos23 + 1;
            token.Length = this.position - token.Position;
            return token;
        }
        if (ch == '[' && (pos2 = this.inputExpression.indexOf(93, this.position)) != -1) {
            String alias = this.inputExpression.substring(this.position, ++pos2);
            if (this.position > 0 && this.inputExpression.charAt(this.position - 1) == '.') {
                alias = "." + alias;
            }
            if (this.hashAliases.containsKey(alias)) {
                token = new StiToken();
                token.Value = this.hashAliases.get(alias);
                token.Type = StiTokenType.Identifier;
                token.Position = this.position;
                token.Length = pos2 - this.position;
                this.position = pos2;
                return token;
            }
        }
        int tPos = this.position++;
        int ch2 = 32;
        if (this.position < this.inputExpression.length()) {
            ch2 = this.inputExpression.charAt(this.position);
        }
        switch (ch) {
            case '.': {
                return new StiToken(StiTokenType.Dot, tPos, 1);
            }
            case '(': {
                return new StiToken(StiTokenType.LParenthesis, tPos, 1);
            }
            case ')': {
                return new StiToken(StiTokenType.RParenthesis, tPos, 1);
            }
            case '[': {
                return new StiToken(StiTokenType.LBracket, tPos, 1);
            }
            case ']': {
                return new StiToken(StiTokenType.RBracket, tPos, 1);
            }
            case '+': {
                return new StiToken(StiTokenType.Plus, tPos, 1);
            }
            case '-': {
                return new StiToken(StiTokenType.Minus, tPos, 1);
            }
            case '*': {
                return new StiToken(StiTokenType.Mult, tPos, 1);
            }
            case '/': {
                return new StiToken(StiTokenType.Div, tPos, 1);
            }
            case '%': {
                return new StiToken(StiTokenType.Percent, tPos, 1);
            }
            case '^': {
                return new StiToken(StiTokenType.Xor, tPos, 1);
            }
            case ',': {
                return new StiToken(StiTokenType.Comma, tPos, 1);
            }
            case ':': {
                return new StiToken(StiTokenType.Colon, tPos, 1);
            }
            case ';': {
                return new StiToken(StiTokenType.SemiColon, tPos, 1);
            }
            case '?': {
                return new StiToken(StiTokenType.Question, tPos, 1);
            }
            case '|': {
                if (ch2 == 124) {
                    ++this.position;
                    return new StiToken(StiTokenType.DoubleOr, tPos, 2);
                }
                return new StiToken(StiTokenType.Or, tPos, 1);
            }
            case '&': {
                if (ch2 == 38) {
                    ++this.position;
                    return new StiToken(StiTokenType.DoubleAnd, tPos, 2);
                }
                return new StiToken(StiTokenType.And, tPos, 1);
            }
            case '!': {
                if (ch2 == 61) {
                    ++this.position;
                    return new StiToken(StiTokenType.NotEqual, tPos, 2);
                }
                return new StiToken(StiTokenType.Not, tPos, 1);
            }
            case '=': {
                if (ch2 == 61) {
                    ++this.position;
                    return new StiToken(StiTokenType.Equal, tPos, 2);
                }
                return new StiToken(StiTokenType.Assign, tPos, 1);
            }
            case '<': {
                if (ch2 == 60) {
                    ++this.position;
                    return new StiToken(StiTokenType.Shl, tPos, 2);
                }
                if (ch2 == 61) {
                    ++this.position;
                    return new StiToken(StiTokenType.LeftEqual, tPos, 2);
                }
                return new StiToken(StiTokenType.Left, tPos, 1);
            }
            case '>': {
                if (ch2 == 62) {
                    ++this.position;
                    return new StiToken(StiTokenType.Shr, tPos, 2);
                }
                if (ch2 == 61) {
                    ++this.position;
                    return new StiToken(StiTokenType.RightEqual, tPos, 2);
                }
                return new StiToken(StiTokenType.Right, tPos, 1);
            }
        }
        token = new StiToken(StiTokenType.Unknown);
        token.ValueObject = Character.valueOf(ch);
        token.Position = tPos;
        token.Length = 1;
        return token;
    }

    private static boolean isValidName(String name) {
        if (StiValidationUtil.isNullOrEmpty((String)name) || !Character.isLetter(name.charAt(0)) && name.charAt(0) != '_') {
            return false;
        }
        for (int pos = 0; pos < name.length(); ++pos) {
            if (Character.isLetterOrDigit(name.charAt(pos)) || name.charAt(pos) == '_') continue;
            return false;
        }
        return true;
    }

    private static String getCorrectedAlias(String alias) {
        if (StiParser.isValidName(alias)) {
            return alias;
        }
        return String.format("[%s]", alias);
    }

    private void buildAliases() {
        if (this.hashAliases != null) {
            return;
        }
        this.hashAliases = new Hashtable();
        Iterator i$ = this.report.getDictionary().getDataSources().iterator();
        while (i$.hasNext()) {
            StiDataSource dataSource = (StiDataSource)i$.next();
            String dataSourceName = dataSource.getName();
            String dataSourceAlias = StiParser.getCorrectedAlias(dataSource.getAlias());
            if (dataSourceAlias != dataSourceName) {
                this.hashAliases.put(dataSourceAlias, dataSourceName);
            }
            Iterator i$2 = dataSource.getColumns().iterator();
            while (i$2.hasNext()) {
                StiDataColumn dataColumn = (StiDataColumn)i$2.next();
                String dataColumnName = dataColumn.getName();
                String dataColumnAlias = StiParser.getCorrectedAlias(dataColumn.getAlias());
                if (StiValidationUtil.equals((Object)dataColumnAlias, (Object)dataColumnName)) continue;
                this.hashAliases.put("." + dataColumnAlias, dataColumnName);
            }
        }
        for (StiDataRelation dataRelation : this.report.getDictionary().getRelations()) {
            String dataRelationName = dataRelation.getName();
            String dataRelationAlias = StiParser.getCorrectedAlias(dataRelation.getAlias());
            if (StiValidationUtil.equals((Object)dataRelationAlias, (Object)dataRelationName)) continue;
            this.hashAliases.put("." + dataRelationAlias, dataRelationName);
        }
        i$ = this.report.getDictionary().getVariables().iterator();
        while (i$.hasNext()) {
            StiVariable variable = (StiVariable)i$.next();
            String variableName = variable.getName();
            String variableAlias = StiParser.getCorrectedAlias(variable.getAlias());
            if (StiValidationUtil.equals((Object)variableAlias, (Object)variableName)) continue;
            this.hashAliases.put(variableAlias, variableName);
        }
    }

    public final Object scanNumber() {
        Object result;
        block12: {
            StiTypeCode typecode = StiTypeCode.Int32;
            int posBegin = this.position;
            int posBeginAll = this.position;
            while (this.position != this.inputExpression.length() && Character.isDigit(this.inputExpression.charAt(this.position))) {
                ++this.position;
            }
            if (this.position != this.inputExpression.length() && this.inputExpression.charAt(this.position) == '.' && this.position + 1 != this.inputExpression.length() && Character.isDigit(this.inputExpression.charAt(this.position + 1))) {
                ++this.position;
                while (this.position != this.inputExpression.length() && Character.isDigit(this.inputExpression.charAt(this.position))) {
                    ++this.position;
                }
                typecode = StiTypeCode.Double;
            }
            String nm = this.inputExpression.substring(posBegin, this.position);
            nm = nm.replace('.', StiConvertHelper.DECIMAL_SEPARATOR);
            if (this.position != this.inputExpression.length() && Character.isLetter(this.inputExpression.charAt(this.position))) {
                posBegin = this.position;
                while (this.position != this.inputExpression.length() && Character.isLetter(this.inputExpression.charAt(this.position))) {
                    ++this.position;
                }
                String postfix = this.inputExpression.substring(posBegin, this.position).toLowerCase();
                if (postfix.equals("f")) {
                    typecode = StiTypeCode.Single;
                }
                if (postfix.equals("d")) {
                    typecode = StiTypeCode.Double;
                }
                if (postfix.equals("m")) {
                    typecode = StiTypeCode.Decimal;
                }
                if (postfix.equals("l")) {
                    typecode = StiTypeCode.Int64;
                }
                if (postfix.equals("u") || postfix.equals("ul") || postfix.equals("lu")) {
                    typecode = StiTypeCode.UInt64;
                }
            }
            result = null;
            try {
                result = StiTypeConverter.changeType((String)nm, (StiTypeCode)typecode);
            }
            catch (Exception e) {
                if (typecode != StiTypeCode.Int32 && typecode != StiTypeCode.Int64 && typecode != StiTypeCode.UInt32 && typecode != StiTypeCode.UInt64) break block12;
                this.ThrowError(1, new StiToken(StiTokenType.Number, posBeginAll, this.position - posBeginAll));
            }
        }
        return result;
    }

    private ArrayList<StiToken> postProcessTokensList(ArrayList<StiToken> tokensList) {
        ArrayList<StiToken> newList = new ArrayList<StiToken>();
        this.tokenPos = 0;
        while (this.tokenPos < tokensList.size()) {
            StiToken token = tokensList.get(this.tokenPos);
            ++this.tokenPos;
            if (token.Type == StiTokenType.Identifier) {
                StiDataSourcesCollection dataSources;
                StiBusinessObject bos = this.report.getDictionary().getBusinessObjects().get(token.Value);
                String stNameSpace = null;
                if (namespacesList.containsKey(token.Value)) {
                    if (this.tokenPos + 1 >= tokensList.size()) {
                        LOGGER.severe(this.inputExpression);
                        this.ThrowError(4, token);
                    }
                    if (tokensList.get((int)this.tokenPos).Type != StiTokenType.Dot) {
                        LOGGER.severe(this.inputExpression);
                        this.ThrowError(0, token, token.Value);
                    }
                    stNameSpace = token.Value + ".";
                    token = tokensList.get(this.tokenPos + 1);
                    this.tokenPos += 2;
                    while (namespacesList.containsKey(stNameSpace + tokensList.get((int)(this.tokenPos - 1)).Value)) {
                        if (this.tokenPos + 1 >= tokensList.size()) {
                            LOGGER.severe(this.inputExpression);
                            this.ThrowError(4);
                        }
                        if (tokensList.get((int)this.tokenPos).Type != StiTokenType.Dot) {
                            LOGGER.severe(this.inputExpression);
                            this.ThrowError(0, token, token.Value);
                        }
                        stNameSpace = stNameSpace + token.Value + ".";
                        token = tokensList.get(this.tokenPos + 1);
                        this.tokenPos += 2;
                    }
                }
                if ((dataSources = this.report.getDictionary().getDataSources()).exist(token.Value)) {
                    StiDataSource ds = dataSources.get(token.Value);
                    StringBuilder fieldPath = new StringBuilder(StiNameValidator.CorrectName(token.Value));
                    ArrayList<String> fieldList = new ArrayList<String>();
                    fieldList.add(StiNameValidator.CorrectName(token.Value));
                    while (this.tokenPos + 1 < tokensList.size() && tokensList.get((int)this.tokenPos).Type == StiTokenType.Dot) {
                        token = tokensList.get(this.tokenPos + 1);
                        String nextName = StiNameValidator.CorrectName(token.Value);
                        StiDataRelation dr = this.GetDataRelationByName(nextName, ds);
                        if (dr != null) {
                            ds = dr.getParentSource();
                            this.tokenPos += 2;
                            fieldPath.append(".");
                            fieldPath.append(dr.getNameInSource());
                            fieldList.add(dr.getNameInSource());
                            continue;
                        }
                        StiDataColumn dc = this.getDataColumnByName(nextName, ds);
                        if (dc != null) {
                            this.tokenPos += 2;
                            fieldPath.append(".");
                            fieldPath.append(nextName);
                            fieldList.add(dc.getName());
                            break;
                        }
                        token = tokensList.get(this.tokenPos - 1);
                        break;
                    }
                    token.Type = StiTokenType.DataSourceField;
                    token.Value = fieldPath.toString();
                    token.ValueObject = fieldList;
                } else if (bos != null) {
                    StringBuilder fieldPath = new StringBuilder(token.Value);
                    while (this.tokenPos + 1 < tokensList.size() && tokensList.get((int)this.tokenPos).Type == StiTokenType.Dot) {
                        token = tokensList.get(this.tokenPos + 1);
                        String nextName = token.Value;
                        if (bos.getColumns().contains(nextName)) {
                            this.tokenPos += 2;
                            fieldPath.append(".");
                            fieldPath.append(nextName);
                            break;
                        }
                        if ((bos = bos.getBusinessObjects().get(nextName)) == null) break;
                        this.tokenPos += 2;
                        fieldPath.append(".");
                        fieldPath.append(bos.getName());
                    }
                    token.Type = StiTokenType.BusinessObjectField;
                    token.Value = fieldPath.toString();
                } else if (newList.size() > 0 && newList.get((int)(newList.size() - 1)).Type == StiTokenType.Dot) {
                    if (StiMethodType.getMethodsList().containsKey(token.Value)) {
                        token.Type = StiTokenType.Method;
                    } else if (StiPropertyType.getPropertiesList().containsKey(token.Value)) {
                        token.Type = StiTokenType.Property;
                    } else {
                        this.ThrowError(9, token, token.Value);
                    }
                } else if (StiTypeCode.getTypesList().containsKey(token.Value)) {
                    token.Type = StiTokenType.Cast;
                    if (this.tokenPos + 1 < tokensList.size() && tokensList.get((int)this.tokenPos).Type == StiTokenType.Dot) {
                        String tempName = token.Value + "." + tokensList.get((int)(this.tokenPos + 1)).Value;
                        if (StiFunctionType.getFunctionsList().containsKey(tempName)) {
                            token.Type = StiTokenType.Function;
                            token.Value = tempName;
                            this.tokenPos += 2;
                        }
                        if (StiSystemVariableType.getSystemVariablesList().containsKey(tempName)) {
                            token.Type = StiTokenType.SystemVariable;
                            token.Value = tempName;
                            this.tokenPos += 2;
                        }
                        if (constantsList.containsKey(tempName)) {
                            token.Type = StiTokenType.Number;
                            token.ValueObject = constantsList.get(tempName);
                            token.Value = tempName;
                            this.tokenPos += 2;
                        }
                    }
                } else if (this.getComponentsList().containsKey(token.Value)) {
                    StiComponent comp;
                    token.Type = StiTokenType.Component;
                    if (this.tokenPos + 1 < tokensList.size() && tokensList.get((int)this.tokenPos).Type == StiTokenType.Colon && this.getComponentsList().containsKey(tokensList.get((int)(this.tokenPos + 1)).Value) && (comp = (StiComponent)this.getComponentsList().get(tokensList.get((int)(this.tokenPos + 1)).Value)) != null && comp instanceof StiDataBand) {
                        token.Value = ((StiDataBand)(comp instanceof StiDataBand ? comp : null)).getDataSourceName();
                        token.Type = StiTokenType.DataSourceField;
                        this.tokenPos += 2;
                    }
                } else if (StiFunctionType.getFunctionsList().containsKey(token.Value)) {
                    if (StiFunctionType.getFunctionsList().get(token.Value) == StiFunctionType.TotalsNameSpace) {
                        if (this.tokenPos + 1 >= tokensList.size()) {
                            this.ThrowError(4);
                        }
                        token.Value = token.Value + "." + tokensList.get((int)(this.tokenPos + 1)).Value;
                        this.tokenPos += 2;
                        if (!StiFunctionType.getFunctionsList().containsKey(token.Value)) {
                            this.ThrowError(11, token, token.Value);
                        }
                    }
                    token.Type = StiTokenType.Function;
                } else if (StiSystemVariableType.getSystemVariablesList().containsKey(token.Value) && (!token.Value.equals("value") || this.component instanceof StiCrossCell)) {
                    token.Type = StiTokenType.SystemVariable;
                } else if (token.Value.toLowerCase().equals("true") || token.Value.toLowerCase().equals("false")) {
                    token.ValueObject = token.Value.toLowerCase().equals("true") ? Boolean.valueOf(true) : Boolean.valueOf(false);
                    token.Type = StiTokenType.Number;
                } else if (token.Value.toLowerCase().equals("null")) {
                    token.ValueObject = null;
                    token.Type = StiTokenType.Number;
                } else if (this.report.getDictionary().getVariables().contains(token.Value)) {
                    token.Type = StiTokenType.Variable;
                } else if (this.isCustomFunction(token.Value)) {
                    token.Type = StiTokenType.CustomFunction;
                } else if (constantsList.containsKey(token.Value)) {
                    while (constantsList.get(token.Value) == namespaceObj) {
                        if (this.tokenPos + 1 >= tokensList.size()) {
                            this.ThrowError(4);
                        }
                        String oldTokenValue = token.Value;
                        token.Value = token.Value + "." + tokensList.get((int)(this.tokenPos + 1)).Value;
                        this.tokenPos += 2;
                        if (constantsList.containsKey(token.Value)) continue;
                        this.ThrowError(15, token, oldTokenValue, tokensList.get((int)(this.tokenPos + 1)).Value);
                    }
                    token.ValueObject = constantsList.get(token.Value);
                    token.Type = StiTokenType.Number;
                } else if (this.getUserFunctionsList().containsKey(token.Value)) {
                    token.Type = StiTokenType.Function;
                } else {
                    this.ThrowError(5, token, token.Value);
                }
            }
            newList.add(token);
        }
        return newList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private HashMap<String, Integer> getUserFunctionsList() {
        if (this.userFunctionsList == null) {
            HashMap<String, Integer> hashMap = this.userFunctionsList = new HashMap();
            synchronized (hashMap) {
                StiFunction[] functions;
                HashMap<String, ArrayList<StiFunction>> tempUserFunctionsList = new HashMap<String, ArrayList<StiFunction>>();
                for (StiFunction func : functions = StiFunctions.getFunctions(false)) {
                    ArrayList<StiFunction> list = (ArrayList<StiFunction>)tempUserFunctionsList.get(func.getFunctionName());
                    if (list == null) {
                        list = new ArrayList<StiFunction>();
                        tempUserFunctionsList.put(func.getFunctionName(), list);
                        this.userFunctionsList.put(func.getFunctionName(), 3000 + this.userFunctionsList.size());
                    }
                    list.add(func);
                }
            }
        }
        return this.userFunctionsList;
    }

    private boolean isCustomFunction(String name) {
        for (StiCustomFunction func : this.report.getCustomFunctions()) {
            if (!name.equals(func.getFunctionName())) continue;
            return true;
        }
        return false;
    }

    private StiDataColumn getDataColumnByName(String name, StiDataSource ds) {
        int index;
        if (ds.getDataTable() != null && (index = ds.GetColumnIndex(name)) >= 0 && index < ds.getDataTable().getColumns().size()) {
            String nameInSource = ((StiDataColumn)ds.getDataTable().getColumns().get(index)).getNameInSource();
            Iterator i$ = ds.getColumns().iterator();
            while (i$.hasNext()) {
                StiDataColumn dc = (StiDataColumn)i$.next();
                if (!StiValidationUtil.equals((Object)dc.getNameInSource(), (Object)nameInSource)) continue;
                return dc;
            }
        }
        return ds.getColumns().get(name);
    }

    private void MakeTokensList() {
        StiToken token;
        this.buildAliases();
        this.tokensList = new ArrayList();
        this.position = 0;
        while ((token = this.getNextLexem()) != null) {
            this.tokensList.add(token);
        }
        this.tokensList = this.postProcessTokensList(this.tokensList);
    }

    private boolean isWhiteSpace(char ch) {
        return Character.isWhitespace(ch) || ch < ' ';
    }

    private StiDataRelation GetDataRelationByName(String name, StiDataSource ds) {
        StiDataRelation dr = null;
        for (StiDataRelation drTemp : this.report.getDictionary().getRelations()) {
            if (!name.equals(drTemp.getName()) || drTemp.getChildSource() != ds) continue;
            dr = drTemp;
            break;
        }
        return dr;
    }

    private Object op_Div(Object par1, Object par2) {
        int category1 = StiTypeConverter.getCategoryClass((Object)par1);
        int category2 = StiTypeConverter.getCategoryClass((Object)par2);
        if (category1 == 2 || category2 == 2) {
            return StiTypeConverter.ToDouble((Object)par1).divide(StiTypeConverter.ToDouble((Object)par2), MathContext.DECIMAL32);
        }
        if (category1 >= 3 && category1 <= 7 && category2 >= 3 && category2 <= 7) {
            return Double.parseDouble(par1.toString()) / Double.parseDouble(par2.toString());
        }
        LOGGER.warning("Cant divide: " + par1 + "(" + par1.getClass().toString() + ")" + " / " + par2 + "(" + par2.getClass().toString() + ")");
        return null;
    }

    private Object op_Mod(Object par1, Object par2) {
        BigDecimal value1 = new BigDecimal(par1.toString());
        BigDecimal value2 = new BigDecimal(par2.toString());
        return value1.remainder(value2);
    }

    private Object op_Pow(Object par1, Object par2) {
        int category1 = StiTypeConverter.getCategoryClass((Object)par1);
        int category2 = StiTypeConverter.getCategoryClass((Object)par2);
        if (category1 >= 2 && category2 >= 2 && category1 <= 7 && category2 <= 7) {
            return Math.pow(Double.parseDouble((String)par1), Double.parseDouble((String)par2));
        }
        this.ThrowError(10, "^", par1.getClass().toString(), par2.getClass().toString());
        return null;
    }

    private Object op_Neg(Object par1) {
        int category = StiTypeConverter.getCategoryClass((Object)par1);
        if (category <= 1 || category >= 8) {
            this.ThrowError(10, "Negative", par1.getClass().toString());
        }
        return StiMultiplyOperation.multiply(par1, -1);
    }

    private Object op_Not(Object par1) {
        int category = StiTypeConverter.getCategoryClass((Object)par1);
        if (category != 9) {
            this.ThrowError(10, "Not", par1.getClass().toString());
        }
        return !Boolean.parseBoolean(par1.toString());
    }

    private Object op_Cast(Object par1, Object par2) {
        StiTypeCode typecode = (StiTypeCode)par2;
        switch (typecode) {
            case Boolean: {
                return par1 != null ? Boolean.parseBoolean(String.valueOf(par1)) : false;
            }
            case Byte: {
                return par1 != null ? Byte.parseByte(String.valueOf(par1)) : (byte)0;
            }
            case Char: {
                return StiTypeConverter.ToChar((Object)par1);
            }
            case DateTime: {
                return par1 != null ? StiParser.toDateTime(par1) : StiDateTime.minValue;
            }
            case Decimal: {
                return par1 != null ? new BigDecimal(String.valueOf(par1)) : new BigDecimal(0);
            }
            case Double: {
                return par1 != null ? new BigDecimal(String.valueOf(par1)) : new BigDecimal(0);
            }
            case Int16: {
                return par1 != null ? Short.parseShort(String.valueOf(par1)) : (short)0;
            }
            case Int32: {
                return par1 != null ? Integer.parseInt(String.valueOf(par1)) : 0;
            }
            case Int64: {
                return par1 != null ? Long.parseLong(String.valueOf(par1)) : 0L;
            }
            case SByte: {
                return par1 != null ? Byte.parseByte(String.valueOf(par1)) : (byte)0;
            }
            case Single: {
                return Float.valueOf(par1 != null ? Float.parseFloat(String.valueOf(par1)) : 0.0f);
            }
            case String: {
                return par1 != null ? String.valueOf(par1) : "";
            }
            case UInt16: {
                return par1 != null ? Short.parseShort(String.valueOf(par1)) : (short)0;
            }
            case UInt32: {
                return par1 != null ? Integer.parseInt(String.valueOf(par1)) : 0;
            }
            case UInt64: {
                return par1 != null ? Long.parseLong(String.valueOf(par1)) : 0L;
            }
        }
        return par1;
    }

    private int compare(Object par1, Object par2) {
        Object comparable1 = null;
        Object comparable2 = null;
        if (par1 instanceof StiDateTime && par2 instanceof StiDateTime) {
            comparable1 = StiDateTime.valueOf((Object)par1);
            comparable2 = StiDateTime.valueOf((Object)par2);
        } else if (StiValidationUtil.isNumber((Object)par1) && StiValidationUtil.isNumber((Object)par2)) {
            comparable1 = new BigDecimal(par1.toString());
            comparable2 = new BigDecimal(par2.toString());
        } else if (par1 instanceof Comparable && par2 instanceof Comparable) {
            comparable1 = (Comparable)par1;
            comparable2 = (Comparable)par2;
        } else {
            if (par1 == null && par2 != null) {
                return -1;
            }
            if (par1 != null && par2 == null) {
                return 1;
            }
            if (par1 == null && par2 == null) {
                return 0;
            }
        }
        if (par1 instanceof DBNull && !(par2 instanceof DBNull) || par2 instanceof DBNull && !(par1 instanceof DBNull)) {
            return -1;
        }
        if (par1 instanceof DBNull && par2 instanceof DBNull) {
            return 0;
        }
        try {
            String p1 = par1.toString().trim();
            String p2 = par2.toString().trim();
            if (("true".equals(p1) || "false".equals(p1)) && ("true".equals(p2) || "false".equals(p2))) {
                return new Boolean(Boolean.parseBoolean(p1)).compareTo(Boolean.parseBoolean(p2));
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        return comparable1.compareTo(comparable2);
    }

    private Object compareLeft(Object par1, Object par2) {
        return this.compare(par1, par2) < 0;
    }

    private Object compareLeftEqual(Object par1, Object par2) {
        return this.compare(par1, par2) <= 0;
    }

    private Object compareRight(Object par1, Object par2) {
        return this.compare(par1, par2) > 0;
    }

    private Object compareRightEqual(Object par1, Object par2) {
        return this.compare(par1, par2) >= 0;
    }

    private Object compareEqual(Object par1, Object par2) {
        if (par1 == null && par2 == null) {
            return true;
        }
        if (par1 == null || par2 == null) {
            return false;
        }
        return this.compare(par1, par2) == 0;
    }

    private Object compareNotEqual(Object par1, Object par2) {
        return this.compare(par1, par2) != 0;
    }

    private Object op_Shl(Object par1, Object par2) {
        int category1 = StiTypeConverter.getCategoryClass((Object)par1);
        int category2 = StiTypeConverter.getCategoryClass((Object)par2);
        if (category1 < 4 || category1 >= 8 || category2 != 7) {
            this.ThrowError(10, "<<", par1.getClass().toString(), par2.getClass().toString());
        } else {
            if (category1 == 4 || category2 == 4) {
                return StiTypeConverter.parseLong((Object)par1) << StiTypeConverter.parseInt((Object)par2);
            }
            if (category1 == 5 || category2 == 5) {
                return StiTypeConverter.parseLong((Object)par1) << StiTypeConverter.parseInt((Object)par2);
            }
            if (category1 == 6 || category2 == 6) {
                return StiTypeConverter.parseInt((Object)par1) << StiTypeConverter.parseInt((Object)par2);
            }
            if (category1 == 7 || category2 == 7) {
                return StiTypeConverter.parseInt((Object)par1) << StiTypeConverter.parseInt((Object)par2);
            }
        }
        return null;
    }

    private Object op_Shr(Object par1, Object par2) {
        int category1 = StiTypeConverter.getCategoryClass((Object)par1);
        int category2 = StiTypeConverter.getCategoryClass((Object)par2);
        if (category1 < 4 || category1 >= 8 || category2 != 7) {
            this.ThrowError(10, ">>", par1.getClass().toString(), par2.getClass().toString());
        } else {
            if (category1 == 4 || category2 == 4) {
                return StiTypeConverter.parseLong((Object)par1) >> StiTypeConverter.parseInt((Object)par2);
            }
            if (category1 == 5 || category2 == 5) {
                return StiTypeConverter.parseLong((Object)par1) >> StiTypeConverter.parseInt((Object)par2);
            }
            if (category1 == 6 || category2 == 6) {
                return StiTypeConverter.parseInt((Object)par1) >> StiTypeConverter.parseInt((Object)par2);
            }
            if (category1 == 7 || category2 == 7) {
                return StiTypeConverter.parseInt((Object)par1) >> StiTypeConverter.parseInt((Object)par2);
            }
        }
        return null;
    }

    private Object op_And(Object par1, Object par2) {
        int category1 = StiTypeConverter.getCategoryClass((Object)par1);
        int category2 = StiTypeConverter.getCategoryClass((Object)par2);
        if (category1 == 9 || category2 == 9) {
            return StiTypeConverter.parseBoolean((Object)par1) & StiTypeConverter.parseBoolean((Object)par2);
        }
        return new BigInteger(par1.toString()).and(new BigInteger(par2.toString())).intValue();
    }

    private Object op_Or(Object par1, Object par2) {
        int category1 = StiTypeConverter.getCategoryClass((Object)par1);
        int category2 = StiTypeConverter.getCategoryClass((Object)par2);
        if (category1 < 4 || category1 == 8 || category2 < 4 || category2 == 8) {
            this.ThrowError(10, "|", par1.getClass().toString(), par2.getClass().toString());
        } else {
            if (category1 == 4 || category2 == 4) {
                return StiTypeConverter.parseLong((Object)par1) | StiTypeConverter.parseLong((Object)par2);
            }
            if (category1 == 5 || category2 == 5) {
                return StiTypeConverter.parseLong((Object)par1) | StiTypeConverter.parseLong((Object)par2);
            }
            if (category1 == 6 || category2 == 6) {
                return StiTypeConverter.parseInt((Object)par1) | StiTypeConverter.parseInt((Object)par2);
            }
            if (category1 == 7 || category2 == 7) {
                return StiTypeConverter.parseInt((Object)par1) | StiTypeConverter.parseInt((Object)par2);
            }
            if (category1 == 9 || category2 == 9) {
                return StiTypeConverter.parseBoolean((Object)par1) | StiTypeConverter.parseBoolean((Object)par2);
            }
        }
        return null;
    }

    private Object op_Xor(Object par1, Object par2) {
        int category1 = StiTypeConverter.getCategoryClass((Object)par1);
        int category2 = StiTypeConverter.getCategoryClass((Object)par2);
        if (category1 < 4 || category1 == 8 || category2 < 4 || category2 == 8) {
            this.ThrowError(10, "^", par1.getClass().toString(), par2.getClass().toString());
        } else {
            if (category1 == 4 || category2 == 4) {
                return StiTypeConverter.parseLong((Object)par1) ^ StiTypeConverter.parseLong((Object)par2);
            }
            if (category1 == 5 || category2 == 5) {
                return StiTypeConverter.parseLong((Object)par1) ^ StiTypeConverter.parseLong((Object)par2);
            }
            if (category1 == 6 || category2 == 6) {
                return StiTypeConverter.parseInt((Object)par1) ^ StiTypeConverter.parseInt((Object)par2);
            }
            if (category1 == 7 || category2 == 7) {
                return StiTypeConverter.parseInt((Object)par1) ^ StiTypeConverter.parseInt((Object)par2);
            }
            if (category1 == 9 || category2 == 9) {
                return StiTypeConverter.parseBoolean((Object)par1) ^ StiTypeConverter.parseBoolean((Object)par2);
            }
        }
        return null;
    }

    private Object op_And2(Object par1, Object par2) {
        try {
            return StiTypeConverter.parseBoolean((Object)par1) && StiTypeConverter.parseBoolean((Object)par2);
        }
        catch (Exception e) {
            int category1 = StiTypeConverter.getCategoryClass((Object)par1);
            int category2 = StiTypeConverter.getCategoryClass((Object)par2);
            if (category1 != 9 || category2 != 9) {
                this.ThrowError(10, "&&", par1.getClass().toString(), par2.getClass().toString());
            }
            return null;
        }
    }

    private Object op_Or2(Object par1, Object par2) {
        int category1 = StiTypeConverter.getCategoryClass((Object)par1);
        int category2 = StiTypeConverter.getCategoryClass((Object)par2);
        return StiTypeConverter.parseBoolean((Object)par1) || StiTypeConverter.parseBoolean((Object)par2);
    }

    public final Object executeAsm(ArrayList<StiAsmCommand> asmList) {
        if (asmList == null || asmList.size() == 0) {
            return null;
        }
        Stack<Object> stack = new Stack<Object>();
        ArrayList argsList = null;
        Integer par1 = 0;
        Object par2 = 0;
        block38: for (int indexAsm = 0; indexAsm < asmList.size(); ++indexAsm) {
            StiAsmCommand asmCommand = asmList.get(indexAsm);
            switch (asmCommand.Type) {
                case PushValue: {
                    stack.push(asmCommand.Parameter1);
                    continue block38;
                }
                case PushVariable: {
                    stack.push(this.getVariableValue((String)asmCommand.Parameter1));
                    continue block38;
                }
                case PushSystemVariable: {
                    stack.push(this.getSystemVariable(asmCommand.Parameter1));
                    continue block38;
                }
                case PushComponent: {
                    stack.push(asmCommand.Parameter1);
                    continue block38;
                }
                case CopyToVariable: {
                    Object value = stack.peek();
                    this.report.getDictionary().getVariables().get((String)asmCommand.Parameter1).setValueObject(value);
                    this.report.getVariables().put((String)asmCommand.Parameter1, value);
                    continue block38;
                }
                case PushFunction: {
                    argsList = new ArrayList();
                    for (int index = 0; index < (Integer)asmCommand.Parameter2; ++index) {
                        argsList.add(stack.pop());
                    }
                    Collections.reverse(argsList);
                    stack.push(this.callFunc(asmCommand.Parameter1, argsList, asmCommand.getCustomFunctionName()));
                    continue block38;
                }
                case PushMethod: {
                    argsList = new ArrayList();
                    for (int index = 0; index < (Integer)asmCommand.Parameter2; ++index) {
                        argsList.add(stack.pop());
                    }
                    Collections.reverse(argsList);
                    stack.push(this.callMethod(asmCommand.Parameter1, argsList));
                    continue block38;
                }
                case PushProperty: {
                    argsList = new ArrayList();
                    argsList.add(stack.pop());
                    stack.push(this.callProperty(asmCommand.Parameter1, argsList));
                    continue block38;
                }
                case PushDataSourceField: {
                    String[] parts = null;
                    parts = asmCommand.Parameter2 instanceof ArrayList ? ((ArrayList)asmCommand.Parameter2).toArray(new String[0]) : ((String)asmCommand.Parameter1).split("[.]", -1);
                    StiDataSource ds = this.report.getDictionary().getDataSources().get(parts[0]);
                    if (parts.length > 1) {
                        int indexPart;
                        if (parts.length == 2) {
                            StiDataColumn column = ds.getColumns().get(parts[1]);
                            if (column != null && column instanceof StiCalcDataColumn) {
                                stack.push(StiParser.ParseTextValue("{" + ((StiCalcDataColumn)column).getExpression() + "}", this.component));
                                continue block38;
                            }
                            stack.push(StiReport.changeType(ds.GetData(parts[1]), column.getSystemType()));
                            continue block38;
                        }
                        String nameInSource = parts[1];
                        StiDataRow row = ds.GetParentData(nameInSource);
                        ds = ds.GetParentDataSource(nameInSource);
                        for (indexPart = 2; indexPart < parts.length - 1; ++indexPart) {
                            nameInSource = parts[indexPart];
                            row = row.getParentData(nameInSource);
                            ds = ds.GetParentDataSource(nameInSource);
                        }
                        StiDataColumn column = ds.columns.get(parts[indexPart]);
                        if (column != null && column instanceof StiCalcDataColumn) {
                            stack.push(StiParser.ParseTextValue("{" + ((StiCalcDataColumn)column).getExpression() + "}", this.component));
                            continue block38;
                        }
                        Object columnValue = null;
                        if (row != null) {
                            columnValue = row.getValueAsObject(parts[indexPart]);
                        }
                        stack.push(StiReport.changeType(columnValue, column.getSystemType()));
                        continue block38;
                    }
                    stack.push(ds);
                    continue block38;
                }
                case PushBusinessObjectField: {
                    String[] parts2 = ((String)asmCommand.Parameter1).split("[.]", -1);
                    StiBusinessObject bos = this.report.getDictionary().getBusinessObjects().get(parts2[0]);
                    if (parts2.length > 1) {
                        int indexPart;
                        String nextName = null;
                        for (indexPart = 1; indexPart < parts2.length - 1; ++indexPart) {
                            nextName = parts2[indexPart];
                            if (bos.getColumns().contains(nextName)) break;
                            bos = bos.getBusinessObjects().get(nextName);
                        }
                        stack.push(bos.get(parts2[indexPart]));
                        continue block38;
                    }
                    stack.push((Object)bos);
                    continue block38;
                }
                case PushArrayElement: {
                    argsList = new ArrayList();
                    Integer index = 0;
                    while (index < (Integer)asmCommand.Parameter1) {
                        argsList.add(stack.pop());
                        Integer n = index;
                        Integer n2 = index = Integer.valueOf(index + 1);
                    }
                    Collections.reverse(argsList);
                    stack.push(this.call_arrayElement(argsList));
                    continue block38;
                }
                case Jump: {
                    indexAsm += (int)Func.Convert.toInt32(asmCommand.Parameter1);
                    continue block38;
                }
                case JumpTrue: {
                    if (!Func.Convert.toBoolean(stack.pop())) continue block38;
                    indexAsm += (int)Func.Convert.toInt32(asmCommand.Parameter1);
                    continue block38;
                }
                case JumpFalse: {
                    if (Func.Convert.toBoolean(stack.pop())) continue block38;
                    indexAsm += (int)Func.Convert.toInt32(asmCommand.Parameter1);
                    continue block38;
                }
                case Add: {
                    stack.push(new StiAddOperation(stack).doOperation());
                    continue block38;
                }
                case Sub: {
                    stack.push(new StiSubtractOperation(stack).doOperation());
                    continue block38;
                }
                case Mult: {
                    stack.push(new StiMultiplyOperation(stack).doOperation());
                    continue block38;
                }
                case Div: {
                    par2 = stack.pop();
                    par1 = stack.pop();
                    stack.push(this.op_Div(par1, par2));
                    continue block38;
                }
                case Mod: {
                    par2 = stack.pop();
                    par1 = stack.pop();
                    stack.push(this.op_Mod(par1, par2));
                    continue block38;
                }
                case Power: {
                    par2 = stack.pop();
                    par1 = stack.pop();
                    stack.push(this.op_Pow(par1, par2));
                    continue block38;
                }
                case Neg: {
                    par1 = stack.pop();
                    stack.push(this.op_Neg(par1));
                    continue block38;
                }
                case Cast: {
                    par1 = stack.pop();
                    par2 = asmCommand.Parameter1;
                    stack.push(this.op_Cast(par1, par2));
                    continue block38;
                }
                case Not: {
                    par1 = stack.pop();
                    stack.push(this.op_Not(par1));
                    continue block38;
                }
                case CompareLeft: {
                    par2 = stack.pop();
                    par1 = stack.pop();
                    stack.push(this.compareLeft(par1, par2));
                    continue block38;
                }
                case CompareLeftEqual: {
                    par2 = stack.pop();
                    par1 = stack.pop();
                    stack.push(this.compareLeftEqual(par1, par2));
                    continue block38;
                }
                case CompareRight: {
                    par2 = stack.pop();
                    par1 = stack.pop();
                    stack.push(this.compareRight(par1, par2));
                    continue block38;
                }
                case CompareRightEqual: {
                    par2 = stack.pop();
                    par1 = stack.pop();
                    stack.push(this.compareRightEqual(par1, par2));
                    continue block38;
                }
                case CompareEqual: {
                    par2 = stack.pop();
                    par1 = stack.pop();
                    stack.push(this.compareEqual(par1, par2));
                    continue block38;
                }
                case CompareNotEqual: {
                    par2 = stack.pop();
                    par1 = stack.pop();
                    stack.push(this.compareNotEqual(par1, par2));
                    continue block38;
                }
                case Shl: {
                    par2 = stack.pop();
                    par1 = stack.pop();
                    stack.push(this.op_Shl(par1, par2));
                    continue block38;
                }
                case Shr: {
                    par2 = stack.pop();
                    par1 = stack.pop();
                    stack.push(this.op_Shr(par1, par2));
                    continue block38;
                }
                case And: {
                    par2 = stack.pop();
                    par1 = stack.pop();
                    stack.push(this.op_And(par1, par2));
                    continue block38;
                }
                case Or: {
                    par2 = stack.pop();
                    par1 = stack.pop();
                    stack.push(this.op_Or(par1, par2));
                    continue block38;
                }
                case Xor: {
                    par2 = stack.pop();
                    par1 = stack.pop();
                    stack.push(this.op_Xor(par1, par2));
                    continue block38;
                }
                case And2: {
                    par2 = stack.pop();
                    par1 = stack.pop();
                    stack.push(this.op_And2(par1, par2));
                    continue block38;
                }
                case Or2: {
                    par2 = stack.pop();
                    par1 = stack.pop();
                    stack.push(this.op_Or2(par1, par2));
                }
            }
        }
        return stack.pop();
    }

    private Object getVariableValue(String name) {
        StiVariable var = this.report.getDictionary().getVariables().get(name);
        if (var != null && var.getReadOnly() && var.getInitBy() == StiVariableInitBy.Expression) {
            StiText tempText = new StiText();
            tempText.setName("**ReportVariables**");
            tempText.setPage(this.report.getPages().get(0));
            return StiParser.ParseTextValue("{" + var.getValue() + "}", (StiComponent)tempText);
        }
        if (this.report.getVariables() == null || !this.report.getVariables().containsKey(name)) {
            if (var != null) {
                return var.getValueObject();
            }
            return null;
        }
        return this.report.getVariables().get(name);
    }

    private Object callFunc(Object name, ArrayList argsList, String customFunctionName) {
        return StiCallFunction.callFunc(name, argsList, this.report, this, customFunctionName);
    }

    private void ThrowError(int code, String message, int size) {
        throw new RuntimeException("code '" + code + "', message '" + message + "', size '" + size);
    }

    private Object callMethod(Object name, ArrayList argsList) {
        int category2;
        Object baseValue = argsList.get(0);
        StiMethodType methodType = (StiMethodType)((Object)name);
        switch (methodType) {
            case ToString: {
                int category2 = StiTypeConverter.getCategoryClass(argsList.get(0));
                if (baseValue instanceof StiDateTime) {
                    return ((StiDateTime)baseValue).toString(String.valueOf(argsList.get(1)));
                }
                if (category2 == 1) {
                    return String.valueOf(argsList.get(0));
                }
                if (category2 == 2 || category2 == 3) {
                    BigDecimal resDecimal = StiTypeConverter.ToDecimal(argsList.get(0));
                    if (argsList.size() == 1) {
                        return resDecimal.toString();
                    }
                    if (argsList.size() == 2) {
                        return new DecimalFormat(argsList.get(1).toString()).format(resDecimal);
                    }
                    return resDecimal.toString();
                }
                if (category2 == 4 || category2 == 6) {
                    long resUlong = StiTypeConverter.parseLong(argsList.get(0));
                    if (argsList.size() == 1) {
                        return new Long(resUlong).toString();
                    }
                    if (argsList.size() == 2) {
                        return new DecimalFormat(argsList.get(1).toString()).format(resUlong);
                    }
                    return new Long(resUlong).toString();
                }
                if (category2 == 5 || category2 == 7) {
                    long resLong = StiTypeConverter.parseLong(argsList.get(0));
                    if (argsList.size() == 1) {
                        return new Long(resLong).toString();
                    }
                    if (argsList.size() == 2) {
                        return new DecimalFormat(argsList.get(1).toString()).format(resLong);
                    }
                    return new Long(resLong).toString();
                }
                if (category2 == 8) {
                    StiDateTime resDate = StiParser.toDateTime(argsList.get(0));
                    if (argsList.size() == 1) {
                        return resDate.formatEN();
                    }
                    String format = String.valueOf(argsList.get(1));
                    return resDate.format(format);
                }
                if (category2 == 10) {
                    StiTimeSpan resDate = (StiTimeSpan)argsList.get(0);
                    if (argsList.size() == 1) {
                        return resDate.toString();
                    }
                    String format = String.valueOf(argsList.get(1));
                    return resDate.format(format);
                }
                if (category2 == 9) {
                    return StiTypeConverter.parseBoolean(argsList.get(0));
                }
                return argsList.get(0) != null ? argsList.get(0).toString() : "";
            }
        }
        if (baseValue instanceof String) {
            switch (methodType) {
                case Substring: {
                    category2 = StiTypeConverter.getCategoryClass(argsList.get(0));
                    if (category2 != 1) {
                        this.ThrowError(0);
                    }
                    Integer beginIndex = ((Number)argsList.get(1)).intValue();
                    Integer endIndex = beginIndex + ((Number)argsList.get(2)).intValue();
                    if (argsList.size() == 3) {
                        return ((String)argsList.get(0)).substring(beginIndex, endIndex);
                    }
                    if (argsList.size() == 2) {
                        return ((String)argsList.get(0)).substring(beginIndex);
                    }
                    this.ThrowError(12, "Substring", argsList.size() - 1);
                    break;
                }
                case ToLower: {
                    category2 = StiTypeConverter.getCategoryClass(argsList.get(0));
                    if (category2 != 1) {
                        this.ThrowError(0);
                    }
                    if (argsList.size() == 1) {
                        return ((String)argsList.get(0)).toLowerCase();
                    }
                    this.ThrowError(12, "ToLower", argsList.size() - 1);
                    break;
                }
                case ToUpper: {
                    category2 = StiTypeConverter.getCategoryClass(argsList.get(0));
                    if (category2 != 1) {
                        this.ThrowError(0);
                    }
                    if (argsList.size() == 1) {
                        return ((String)argsList.get(0)).toUpperCase();
                    }
                    this.ThrowError(12, "ToUpper", argsList.size() - 1);
                    break;
                }
                case IndexOf: {
                    category2 = StiTypeConverter.getCategoryClass(argsList.get(0));
                    if (category2 != 1) {
                        this.ThrowError(16, argsList.get(0).getClass().toString(), "IndexOf");
                    }
                    if (argsList.size() == 2) {
                        category2 = StiTypeConverter.getCategoryClass(argsList.get(1));
                        if (category2 != 1) {
                            this.ThrowError(15, "IndexOf", "1", argsList.get(0).getClass().toString(), "String");
                        }
                        return ((String)argsList.get(0)).indexOf((String)argsList.get(1));
                    }
                    this.ThrowError(12, "IndexOf", argsList.size() - 1);
                    break;
                }
                case StartsWith: {
                    category2 = StiTypeConverter.getCategoryClass(argsList.get(0));
                    if (category2 != 1) {
                        this.ThrowError(16, argsList.get(0).getClass().toString(), "StartsWith");
                    }
                    if (argsList.size() == 2) {
                        category2 = StiTypeConverter.getCategoryClass(argsList.get(1));
                        if (category2 != 1) {
                            this.ThrowError(15, "StartsWith", "1", argsList.get(0).getClass().toString(), "String");
                        }
                        return ((String)argsList.get(0)).startsWith((String)argsList.get(1));
                    }
                    this.ThrowError(12, "StartsWith", argsList.size() - 1);
                    break;
                }
                case EndsWith: {
                    category2 = StiTypeConverter.getCategoryClass(argsList.get(0));
                    if (category2 != 1) {
                        this.ThrowError(16, argsList.get(0).getClass().toString(), "EndsWith");
                    }
                    if (argsList.size() == 2) {
                        category2 = StiTypeConverter.getCategoryClass(argsList.get(1));
                        if (category2 != 1) {
                            this.ThrowError(15, "EndsWith", "1", argsList.get(0).getClass().toString(), "String");
                        }
                        return ((String)argsList.get(0)).endsWith((String)argsList.get(1));
                    }
                    this.ThrowError(12, "EndsWith", argsList.size() - 1);
                    break;
                }
                case Contains: {
                    category2 = StiTypeConverter.getCategoryClass(argsList.get(0));
                    if (category2 != 1) {
                        this.ThrowError(16, argsList.get(0).getClass().toString(), "Contains");
                    }
                    if (argsList.size() == 2) {
                        category2 = StiTypeConverter.getCategoryClass(argsList.get(1));
                        if (category2 != 1) {
                            this.ThrowError(15, "Contains", "1", argsList.get(0).getClass().toString(), "String");
                        }
                        return ((String)argsList.get(0)).contains((String)argsList.get(1));
                    }
                    this.ThrowError(12, "Contains", argsList.size() - 1);
                    break;
                }
                case Replace: {
                    int category2;
                    if (argsList.size() != 3) {
                        this.ThrowError(12, "Replace", argsList.size());
                    }
                    if ((category2 = StiTypeConverter.getCategoryClass(argsList.get(0))) != 1) {
                        this.ThrowError(13, "Replace", "1", argsList.get(0).getClass().toString(), "string");
                    }
                    if ((category2 = StiTypeConverter.getCategoryClass(argsList.get(1))) != 1) {
                        this.ThrowError(13, "Replace", "2", argsList.get(0).getClass().toString(), "string");
                    }
                    if ((category2 = StiTypeConverter.getCategoryClass(argsList.get(2))) != 1) {
                        this.ThrowError(13, "Replace", "3", argsList.get(0).getClass().toString(), "string");
                    }
                    try {
                        return String.valueOf(argsList.get(0)).replaceAll(String.valueOf(argsList.get(1)), String.valueOf(argsList.get(2)));
                    }
                    catch (Exception e) {
                        if (StiOptions.Engine.logLevel >= 10) {
                            e.printStackTrace();
                        }
                        return "";
                    }
                }
            }
        }
        if (baseValue instanceof StiGroupHeaderBand) {
            switch (methodType) {
                case GetCurrentConditionValue: {
                    StiGroupHeaderBand band = (StiGroupHeaderBand)baseValue;
                    return band.GetCurrentConditionValue();
                }
            }
        }
        if (baseValue instanceof ArrayList) {
            switch (methodType) {
                case Contains: {
                    if (argsList.size() == 2) {
                        ArrayList arrayList = (ArrayList)argsList.get(0);
                        if (arrayList.size() > 0) {
                            Object containsElement;
                            Object firstElement = arrayList.get(0);
                            String containsString = argsList.get(1).toString();
                            if (firstElement instanceof Integer) {
                                containsElement = Integer.valueOf(containsString);
                            } else if (firstElement instanceof Long) {
                                containsElement = Long.valueOf(containsString);
                            } else if (firstElement instanceof Boolean) {
                                containsElement = Boolean.valueOf(containsString);
                            } else if (firstElement instanceof Character) {
                                containsElement = Character.valueOf(containsString.charAt(0));
                            } else if (firstElement instanceof Float) {
                                containsElement = Float.valueOf(containsString);
                            } else if (firstElement instanceof Double) {
                                containsElement = Double.valueOf(containsString);
                            } else if (firstElement instanceof Byte) {
                                containsElement = Byte.valueOf(containsString);
                            } else if (firstElement instanceof Short) {
                                containsElement = Short.valueOf(containsString);
                            } else if (firstElement instanceof String) {
                                containsElement = containsString;
                            } else {
                                throw new RuntimeException("Error Contains by " + firstElement.getClass());
                            }
                            return arrayList.contains(containsElement);
                        }
                        return false;
                    }
                    this.ThrowError(12, "Contains", argsList.size() - 1);
                    break;
                }
                case ToQueryString: {
                    if (argsList.size() == 1) {
                        if (!(baseValue instanceof List)) break;
                        return Func.EngineHelper.toQueryString((List)argsList.get(0), "", "");
                    }
                    if (argsList.size() == 2) {
                        if (!(baseValue instanceof List)) break;
                        return Func.EngineHelper.toQueryString((List)argsList.get(0), argsList.get(1).toString(), "");
                    }
                    if (argsList.size() == 3) {
                        if (!(baseValue instanceof List)) break;
                        return Func.EngineHelper.toQueryString((List)argsList.get(0), argsList.get(1).toString(), argsList.get(2).toString());
                    }
                    this.ThrowError(12, "NoOverloadForMethodTakesNArguments ToQueryString(), " + (argsList.size() - 1));
                    break;
                }
                case Count: {
                    return ((List)argsList.get(0)).size();
                }
            }
        }
        if (baseValue instanceof StiDataSource) {
            switch ((StiMethodType)((Object)name)) {
                case GetData: {
                    category2 = StiTypeConverter.getCategoryClass(argsList.get(1));
                    if (category2 != 1) {
                        this.ThrowError(15, "GetData", "1", argsList.get(0).getClass().toString(), "String");
                    }
                    if (argsList.size() == 3) {
                        category2 = StiTypeConverter.getCategoryClass(argsList.get(2));
                        if (category2 < 4 || category2 > 7) {
                            this.ThrowError(15, "GetData", "2", argsList.get(0).getClass().toString(), "int");
                        }
                        return ((StiDataSource)argsList.get(0)).GetData(StiTypeConverter.parseString(argsList.get(1)), StiTypeConverter.parseInt(argsList.get(2)));
                    }
                    if (argsList.size() == 2) {
                        return ((StiDataSource)argsList.get(0)).GetData(StiTypeConverter.ToString(argsList.get(1)));
                    }
                    this.ThrowError(12, "GetData", argsList.size() - 1);
                }
            }
        }
        if (baseValue instanceof StiDateTime) {
            switch ((StiMethodType)((Object)name)) {
                case AddDays: {
                    category2 = StiTypeConverter.getCategoryClass(argsList.get(1));
                    if (category2 < 2 || category2 > 7) {
                        this.ThrowError(13, "AddDays", "1", argsList.get(1).getClass().toString(), "double");
                    }
                    if (argsList.size() == 2) {
                        return ((StiDateTime)argsList.get(0)).addDays(Double.parseDouble(argsList.get(1).toString()));
                    }
                    this.ThrowError(12, "AddDays", argsList.size() - 1);
                    break;
                }
                case AddHours: {
                    category2 = StiTypeConverter.getCategoryClass(argsList.get(1));
                    if (category2 < 2 || category2 > 7) {
                        this.ThrowError(13, "AddHours", "1", argsList.get(1).getClass().toString(), "double");
                    }
                    if (argsList.size() == 2) {
                        return ((StiDateTime)argsList.get(0)).addHours(Double.parseDouble(argsList.get(1).toString()));
                    }
                    this.ThrowError(12, "AddHours", argsList.size() - 1);
                    break;
                }
                case AddMilliseconds: {
                    category2 = StiTypeConverter.getCategoryClass(argsList.get(1));
                    if (category2 < 2 || category2 > 7) {
                        this.ThrowError(13, "AddMilliseconds", "1", argsList.get(1).getClass().toString(), "double");
                    }
                    if (argsList.size() == 2) {
                        return ((StiDateTime)argsList.get(0)).addMilliseconds(Double.parseDouble(argsList.get(1).toString()));
                    }
                    this.ThrowError(12, "AddMilliseconds", argsList.size() - 1);
                    break;
                }
                case AddMinutes: {
                    category2 = StiTypeConverter.getCategoryClass(argsList.get(1));
                    if (category2 < 2 || category2 > 7) {
                        this.ThrowError(13, "AddMinutes", "1", argsList.get(1).getClass().toString(), "double");
                    }
                    if (argsList.size() == 2) {
                        return ((StiDateTime)argsList.get(0)).addMinutes(Double.parseDouble(argsList.get(1).toString()));
                    }
                    this.ThrowError(12, "AddMinutes", argsList.size() - 1);
                    break;
                }
                case AddMonths: {
                    category2 = StiTypeConverter.getCategoryClass(argsList.get(1));
                    if (category2 < 2 || category2 > 7) {
                        this.ThrowError(13, "AddMonths", "1", argsList.get(1).getClass().toString(), "int");
                    }
                    if (argsList.size() == 2) {
                        return ((StiDateTime)argsList.get(0)).addMonths(Integer.parseInt(argsList.get(1).toString()));
                    }
                    this.ThrowError(12, "AddMonths", argsList.size() - 1);
                    break;
                }
                case AddSeconds: {
                    category2 = StiTypeConverter.getCategoryClass(argsList.get(1));
                    if (category2 < 2 || category2 > 7) {
                        this.ThrowError(13, "AddSeconds", "1", argsList.get(1).getClass().toString(), "double");
                    }
                    if (argsList.size() == 2) {
                        return ((StiDateTime)argsList.get(0)).addSeconds(Double.parseDouble(argsList.get(1).toString()));
                    }
                    this.ThrowError(12, "AddSeconds", argsList.size() - 1);
                    break;
                }
                case AddYears: {
                    category2 = StiTypeConverter.getCategoryClass(argsList.get(1));
                    if (category2 < 2 || category2 > 7) {
                        this.ThrowError(13, "AddYears", "1", argsList.get(1).getClass().toString(), "int");
                    }
                    if (argsList.size() == 2) {
                        return ((StiDateTime)argsList.get(0)).addYears(Integer.parseInt(argsList.get(1).toString()));
                    }
                    this.ThrowError(12, "AddYears", argsList.size() - 1);
                }
            }
        }
        if (baseValue == null && "Length".equals(name)) {
            return 0;
        }
        return null;
    }

    private Object callProperty(Object name, ArrayList argsList) {
        Object baseValue = argsList.get(0);
        if (baseValue instanceof StiDateTime) {
            StiDateTime calendar = (StiDateTime)baseValue;
            switch ((StiPropertyType)((Object)name)) {
                case Year: {
                    int i = calendar.get(1);
                    return i;
                }
                case Month: {
                    int mon = calendar.get(2) + 1;
                    return mon;
                }
                case Day: {
                    return calendar.get(7);
                }
                case Hour: {
                    return calendar.get(7);
                }
                case Minute: {
                    return calendar.get(12);
                }
                case Second: {
                    return calendar.get(13);
                }
                case Date: {
                    return calendar;
                }
            }
            this.ThrowError(16, argsList.get(0).getClass().toString(), StiPropertyType.forValue(name).name());
        }
        if (baseValue instanceof String) {
            switch ((StiPropertyType)((Object)name)) {
                case Length: {
                    return String.valueOf(baseValue).length();
                }
            }
            this.ThrowError(16, argsList.get(0).getClass().toString(), StiPropertyType.forValue(name).name());
        }
        if (baseValue == null) {
            switch ((StiPropertyType)((Object)name)) {
                case Length: {
                    return 0;
                }
            }
        }
        if ((StiPropertyType)((Object)name) == StiPropertyType.Position) {
            try {
                Method method = baseValue.getClass().getMethod("getPosition", new Class[0]);
                return method.invoke(baseValue, new Object[0]);
            }
            catch (Exception e) {
                throw new RuntimeException("'Position' property does not", e);
            }
        }
        if (baseValue instanceof Range) {
            switch ((StiPropertyType)((Object)name)) {
                case From: {
                    return ((Range)(baseValue instanceof Range ? baseValue : null)).getFromObject();
                }
                case To: {
                    return ((Range)(baseValue instanceof Range ? baseValue : null)).getToObject();
                }
                case FromDate: {
                    return ((DateTimeRange)(baseValue instanceof DateTimeRange ? baseValue : null)).getFromDate();
                }
                case ToDate: {
                    return ((DateTimeRange)(baseValue instanceof DateTimeRange ? baseValue : null)).getToDate();
                }
                case FromTime: {
                    return ((TimeSpanRange)(baseValue instanceof TimeSpanRange ? baseValue : null)).getFromTime();
                }
                case ToTime: {
                    return ((TimeSpanRange)(baseValue instanceof TimeSpanRange ? baseValue : null)).getToTime();
                }
            }
            this.ThrowError(16, argsList.get(0).getClass().toString(), StiPropertyType.forValue(name).name());
        }
        if (baseValue instanceof StiTimeSpan) {
            switch ((StiPropertyType)((Object)name)) {
                case Days: {
                    return ((StiTimeSpan)baseValue).getDays();
                }
                case Hours: {
                    return ((StiTimeSpan)baseValue).getHours();
                }
                case Milliseconds: {
                    return ((StiTimeSpan)baseValue).getTotalMilliseconds();
                }
                case Minutes: {
                    return ((StiTimeSpan)baseValue).getMinutes();
                }
                case Seconds: {
                    return ((StiTimeSpan)baseValue).getSeconds();
                }
                case Ticks: {
                    return ((StiTimeSpan)baseValue).getTicks();
                }
                case TotalDays: {
                    return ((StiTimeSpan)baseValue).getTotalDays();
                }
                case TotalHours: {
                    return ((StiTimeSpan)baseValue).getTotalHours();
                }
                case TotalMinutes: {
                    return ((StiTimeSpan)baseValue).getTotalMinutes();
                }
                case TotalSeconds: {
                    return ((StiTimeSpan)baseValue).getTotalSeconds();
                }
                case TotalMilliseconds: {
                    return ((StiTimeSpan)baseValue).getTotalMilliseconds();
                }
            }
            this.ThrowError(ParserErrorCode.ItemDoesNotContainDefinition, argsList.get(0).getClass().toString(), StiPropertyType.forValue(name).name());
        }
        if (baseValue instanceof StiDataBand) {
            switch ((StiPropertyType)((Object)name)) {
                case SelectedLine: {
                    return ((StiDataBand)baseValue).getSelectedLine();
                }
                case Count: {
                    return ((StiDataBand)baseValue).getCount();
                }
            }
            this.ThrowError(16, argsList.get(0).getClass().toString(), StiPropertyType.forValue(name).name());
        }
        if (baseValue instanceof StiComponent) {
            switch ((StiPropertyType)((Object)name)) {
                case Name: {
                    return ((StiComponent)baseValue).getName();
                }
                case TagValue: {
                    return ((StiComponent)baseValue).getTagValue();
                }
            }
        }
        throw new RuntimeException("call_property property does not");
    }

    private Object getSystemVariable(Object name) {
        switch ((StiSystemVariableType)((Object)name)) {
            case Column: {
                return this.report.getColumn();
            }
            case Line: {
                return this.report.getLine();
            }
            case LineThrough: {
                return this.report.LineThrough;
            }
            case LineABC: {
                return this.report.LineABC;
            }
            case LineRoman: {
                return this.report.LineRoman;
            }
            case GroupLine: {
                return this.report.GroupLine;
            }
            case PageNumber: {
                return this.report.getPageNumber();
            }
            case PageNumberThrough: {
                return this.report.getPageNumberThrough();
            }
            case PageNofM: {
                return this.report.getPageNofM();
            }
            case PageNofMThrough: {
                return this.report.getPageNofMThrough();
            }
            case TotalPageCount: {
                return this.report.getTotalPageCount();
            }
            case TotalPageCountThrough: {
                return this.report.getTotalPageCountThrough();
            }
            case IsFirstPage: {
                return this.report.getIsFirstPage();
            }
            case IsFirstPageThrough: {
                return this.report.getIsFirstPageThrough();
            }
            case IsLastPage: {
                return this.report.getIsLastPage();
            }
            case IsLastPageThrough: {
                return this.report.getIsLastPageThrough();
            }
            case ReportAlias: {
                return this.report.getReportAlias();
            }
            case ReportAuthor: {
                return this.report.getReportAuthor();
            }
            case ReportChanged: {
                return new StiDateTime(this.report.getReportChanged());
            }
            case ReportCreated: {
                return new StiDateTime(this.report.getReportCreated());
            }
            case ReportDescription: {
                return this.report.getReportDescription();
            }
            case ReportName: {
                return this.report.getReportName();
            }
            case Time: {
                return StiDateTime.currentDate();
            }
            case Today: {
                return StiDateTime.currentDateOnly();
            }
            case ConditionValue: {
                return this.report.engine.lastInvokeTextProcessValueEventArgsValue != null && this.report.engine.lastInvokeTextProcessValueEventArgsValue instanceof Number ? new BigDecimal(this.report.engine.lastInvokeTextProcessValueEventArgsValue.toString()) : Integer.valueOf(0);
            }
            case ConditionTag: {
                return this.component instanceof StiText ? ((StiText)(this.component instanceof StiText ? this.component : null)).getTagValue() : null;
            }
            case Sender: {
                return this.sender;
            }
        }
        throw new RuntimeException("getSystemVariable" + name);
    }

    public static Object createExpressionAndParse(String textValue, StiComponent component) {
        String inputExpression = StiParser.createExpression(textValue);
        return StiParser.ParseTextValue(inputExpression, component);
    }

    public static Object parseTextValue(String inputExpression, StiComponent component) {
        return StiParser.ParseTextValue(inputExpression, component);
    }

    public static Object ParseTextValue(String inputExpression, StiComponent component) {
        boolean storeToPrint = false;
        Boolean executeIfStoreToPrint = true;
        boolean returnAsmList = false;
        Object tempVar = StiParser.ParseTextValue(inputExpression, component, storeToPrint, executeIfStoreToPrint, returnAsmList, false);
        return tempVar;
    }

    public static Object ParseTextValue(StiExpression inputExpression, StiText component) {
        return StiParser.ParseTextValue(inputExpression.getValue(), (StiComponent)component);
    }

    public static Object ParseTextValue(String inputExpression, StiComponent component, Boolean storeToPrint, boolean executeIfStoreToPrint, boolean returnAsmList, boolean checkSyntaxMode) {
        StiParserParameters parameters = new StiParserParameters(inputExpression, component, component, storeToPrint, executeIfStoreToPrint, returnAsmList, checkSyntaxMode);
        return StiParser.ParseTextValue(parameters);
    }

    public static Object prepareVariableValue(StiVariable var, StiReport report, StiText textBox) throws StiException {
        return StiParser.prepareVariableValue(var, report, textBox, false);
    }

    public static Object prepareVariableValue(StiVariable var, StiReport report, StiText textBox, boolean fillItems) throws StiException {
        if (textBox == null) {
            textBox = new StiText();
            textBox.setName("**ReportVariables**");
            textBox.setPage(report.getPages().get(0));
        }
        Hashtable hashDataSources = null;
        if (fillItems) {
            hashDataSources = new Hashtable();
        }
        Object obj = null;
        if (var.getSystemType().getInterfaceType() == ParameterType.VALUE || var.getSystemType().getInterfaceType() == ParameterType.NULLABLE || var.getType() == StiSystemTypeEnum.SystemString) {
            obj = var.getInitBy() == StiVariableInitBy.Value ? var.getValueObject() : StiParser.getExpressionValue("{" + var.getValue() + "}", textBox, hashDataSources, report);
        } else {
            if (var.getSystemType().getInterfaceType() == ParameterType.LIST) {
                obj = new ArrayList();
            }
            if (var.getSystemType().getInterfaceType() == ParameterType.RANGE) {
                String tp = var.getSystemType().getEnumType().name().replace("System", "");
                try {
                    obj = Class.forName("com.stimulsoft.base.range." + tp + "Range").newInstance();
                }
                catch (Exception e) {
                    LOGGER.warning("Class instance not found: " + var.getSystemType().getEnumType().name());
                }
                if (obj != null) {
                    Range range = (Range)obj;
                    if (var.getInitBy() == StiVariableInitBy.Value) {
                        range.setFromObject(((Range)var.getValueObject()).getFromObject());
                        range.setToObject(((Range)var.getValueObject()).getToObject());
                    } else {
                        range.setFromObject(StiParser.getExpressionValue("{" + var.getInitByExpressionFrom() + "}", textBox, hashDataSources, report));
                        range.setToObject(StiParser.getExpressionValue("{" + var.getInitByExpressionTo() + "}", textBox, hashDataSources, report));
                    }
                }
                if (fillItems) {
                    StiVariableHelper.fillItemsOfVariable(var, report);
                }
            }
        }
        if (fillItems) {
            for (Object de : hashDataSources.keySet()) {
                StiDataSource dataSource = report.getDictionary().getDataSources().get((String)de);
                if (dataSource == null) continue;
                dataSource.disconnect();
            }
        }
        report.setVariable(var.getName(), obj);
        return obj;
    }

    private static Object getExpressionValue(String expr, StiComponent comp, Hashtable hash, StiReport report) throws StiException {
        if (hash != null) {
            Hashtable<String, Hashtable<String, String>> hash2 = new Hashtable<String, Hashtable<String, String>>();
            StiDataSourceHelper.checkExpression(expr, comp, hash2);
            for (String key : hash2.keySet()) {
                Object obj = hash.get(key);
                if (obj != null) continue;
                hash.put(key, true);
                StiDataSource dataSource = report.getDictionary().getDataSources().get(key);
                if (dataSource == null) continue;
                dataSource.connect();
            }
        }
        return StiParser.ParseTextValue(expr, comp);
    }

    public static Object ParseTextValue(StiParserParameters param) {
        try {
            if (param.inputExpression == null || param.inputExpression.length() == 0) {
                return null;
            }
            StiParser parser = new StiParser();
            parser.report = param.component.getReport();
            parser.component = param.component;
            parser.checkSyntaxMode = param.checkSyntaxMode;
            parser.sender = param.sender;
            ArrayList list = null;
            StiEngine engine = param.component.getReport().getEngine();
            String expressionId = param.inputExpression + param.component.getName();
            if (engine != null) {
                if (engine.getparserConversionStore() == null) {
                    engine.setparserConversionStore(new Hashtable());
                }
                if (engine.getparserConversionStore().containsKey(expressionId)) {
                    list = (ArrayList)engine.getparserConversionStore().get(expressionId);
                }
            }
            if (list == null) {
                try {
                    list = new ArrayList();
                    int counter = 0;
                    int pos = 0;
                    while (pos < param.inputExpression.length()) {
                        int posBegin = pos;
                        while (pos < param.inputExpression.length() && param.inputExpression.charAt(pos) != '{') {
                            ++pos;
                        }
                        if (pos != posBegin) {
                            list.add(new StiAsmCommand(StiAsmCommandType.PushValue, param.inputExpression.substring(posBegin, pos)));
                            if (++counter > 1) {
                                list.add(new StiAsmCommand(StiAsmCommandType.Add));
                            }
                        }
                        if (pos >= param.inputExpression.length() || param.inputExpression.charAt(pos) != '{') continue;
                        posBegin = ++pos;
                        boolean flag = false;
                        while (pos < param.inputExpression.length()) {
                            if (param.inputExpression.charAt(pos) == '\"') {
                                int pos2;
                                for (pos2 = ++pos; pos2 < param.inputExpression.length() && param.inputExpression.charAt(pos2) != '\"'; ++pos2) {
                                    if (param.inputExpression.charAt(pos2) != '\\') continue;
                                    ++pos2;
                                }
                                pos = pos2 + 1;
                                continue;
                            }
                            if (param.inputExpression.charAt(pos) == '}') {
                                String currentExpression = param.inputExpression.substring(posBegin, pos);
                                if (StiValidationUtil.isNotNullOrEmpty((String)currentExpression)) {
                                    parser.expressionPosition = posBegin;
                                    list.addAll(parser.ParseToAsm(currentExpression));
                                    if (++counter > 1) {
                                        list.add(new StiAsmCommand(StiAsmCommandType.Cast, StiTypeCode.String));
                                        list.add(new StiAsmCommand(StiAsmCommandType.Add));
                                    }
                                }
                                flag = true;
                                ++pos;
                                break;
                            }
                            ++pos;
                        }
                        if (flag) continue;
                        parser.expressionPosition = posBegin;
                        list.add(new StiAsmCommand(StiAsmCommandType.PushValue, param.inputExpression.substring(posBegin)));
                        if (++counter <= 1) continue;
                        list.add(new StiAsmCommand(StiAsmCommandType.Add));
                    }
                }
                catch (RuntimeException ex) {
                    if (engine != null) {
                        engine.getparserConversionStore().put(expressionId, new ArrayList());
                    }
                    LOGGER.warning(ex.getMessage());
                    if (StiOptions.Engine.logLevel >= 10) {
                        ex.printStackTrace();
                    }
                    throw ex;
                }
                if (engine != null) {
                    engine.getparserConversionStore().put(expressionId, list);
                }
            }
            if (param.returnAsmList) {
                return list;
            }
            if (list.size() > 0) {
                param.storeToPrint = StiParser.CheckForStoreToPrint(list);
                if (param.storeToPrint && !param.executeIfStoreToPrint) {
                    return param.inputExpression;
                }
                return StiConvertHelper.noTrailing((Object)parser.executeAsm(list));
            }
            return null;
        }
        catch (RuntimeException e) {
            StiLoggingUtil.uppendException((Exception)e, (String)param.component.getClass().getName(), (String)("Expression:" + param.inputExpression));
            throw e;
        }
    }

    private ArrayList<StiAsmCommand> ParseToAsm(String inputExpression) {
        this.inputExpression = inputExpression;
        this.MakeTokensList();
        this.asmList = new ArrayList();
        this.eval_exp();
        return this.asmList;
    }

    private static boolean CheckForStoreToPrint(Object objAsmList) {
        boolean result = false;
        ArrayList asmList = (ArrayList)(objAsmList instanceof ArrayList ? objAsmList : null);
        if (asmList != null) {
            for (StiAsmCommand command : asmList) {
                Enum type;
                if (command.Type == StiAsmCommandType.PushSystemVariable && ((type = (StiSystemVariableType)((Object)command.Parameter1)) == StiSystemVariableType.PageNumber || type == StiSystemVariableType.PageNumberThrough || type == StiSystemVariableType.TotalPageCount || type == StiSystemVariableType.TotalPageCountThrough || type == StiSystemVariableType.PageNofM || type == StiSystemVariableType.GetAnchorPageNumber || type == StiSystemVariableType.PageNofMThrough || type == StiSystemVariableType.IsFirstPage || type == StiSystemVariableType.IsFirstPageThrough || type == StiSystemVariableType.IsLastPage || type == StiSystemVariableType.IsLastPageThrough)) {
                    result = true;
                    break;
                }
                if (command.Type != StiAsmCommandType.PushFunction) continue;
                type = (StiFunctionType)((Object)command.Parameter1);
                if (!(((StiFunctionType)type).intValue >= StiFunctionType.cCount.intValue && ((StiFunctionType)type).intValue <= StiFunctionType.cLast.intValue || ((StiFunctionType)type).intValue >= StiFunctionType.rCount.intValue && ((StiFunctionType)type).intValue <= StiFunctionType.rLast.intValue || ((StiFunctionType)type).intValue >= StiFunctionType.ciCount.intValue && ((StiFunctionType)type).intValue <= StiFunctionType.ciLast.intValue || ((StiFunctionType)type).intValue >= StiFunctionType.riCount.intValue && ((StiFunctionType)type).intValue <= StiFunctionType.riLast.intValue || type == StiFunctionType.GetAnchorPageNumber) && type != StiFunctionType.GetAnchorPageNumberThrough) continue;
                result = true;
                break;
            }
        }
        return result;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static StiParserException checkExpression(String inputExpression, StiComponent component) {
        try {
            StiParser parser = new StiParser();
            boolean storeToPrint = false;
            Object result = StiParser.ParseTextValue(inputExpression, component, storeToPrint, false, true, true);
            List list = (List)result;
            if (list == null) return null;
        }
        catch (StiParserException pex) {
            return pex;
        }
        return null;
    }

    public static StiDateTime toDateTime(Object par1) {
        return (StiDateTime)par1;
    }

    public static void checkForDataBandsUsedInPageTotals(StiText stiText) {
        try {
            boolean storeToPrint = false;
            StiParser.ParseTextValue(stiText.getText().getValue(), stiText, storeToPrint, false, true, false);
        }
        catch (Exception e) {
            if (stiText.getReport() != null) {
                stiText.getReport().WriteToReportRenderingMessages(String.format("Expression in Text property of '%s' can't be evaluated! %s", stiText.getName(), e.getMessage()));
            }
            LOGGER.warning(String.format("Expression in Text property of '%s' can't be evaluated! %s", stiText.getName(), e.getMessage()));
        }
    }

    private static String createExpression(String value) {
        return "{" + value + "}";
    }

    public static Hashtable<StiFunctionType, List<StiParserMethodInfo>> getMethodsHash() {
        if (methodsHash == null) {
            methodsHash = new Hashtable();
            for (StiParserMethodInfo methodInfo : methods) {
                List<StiParserMethodInfo> list = methodsHash.get((Object)methodInfo.getName());
                if (list == null) {
                    list = new ArrayList<StiParserMethodInfo>();
                    methodsHash.put(methodInfo.getName(), list);
                }
                list.add(methodInfo);
            }
        }
        return methodsHash;
    }

    private void checkTypes(List<StiAsmCommand> asmList) {
    }

    static {
        constantsList = new Hashtable();
        namespaceObj = new Object();
        namespacesList = new Hashtable();
        methods = new StiParserMethodInfo[]{new StiParserMethodInfo(StiFunctionType.ToWords, 1, new StiParserDataType[]{StiParserDataType.Long}), new StiParserMethodInfo(StiFunctionType.ToWords, 3, new StiParserDataType[]{StiParserDataType.Double}), new StiParserMethodInfo(StiFunctionType.ToWords, 2, new StiParserDataType[]{StiParserDataType.Decimal}), new StiParserMethodInfo(StiFunctionType.ToWords, 4, new StiParserDataType[]{StiParserDataType.Long, StiParserDataType.Bool}), new StiParserMethodInfo(StiFunctionType.ToWords, 6, new StiParserDataType[]{StiParserDataType.Double, StiParserDataType.Bool}), new StiParserMethodInfo(StiFunctionType.ToWords, 5, new StiParserDataType[]{StiParserDataType.Decimal, StiParserDataType.Bool}), new StiParserMethodInfo(StiFunctionType.ToWordsEs, 1, new StiParserDataType[]{StiParserDataType.Long, StiParserDataType.Bool}), new StiParserMethodInfo(StiFunctionType.ToWordsEs, 2, new StiParserDataType[]{StiParserDataType.Long, StiParserDataType.Bool, StiParserDataType.Bool}), new StiParserMethodInfo(StiFunctionType.ToWordsFa, 1, new StiParserDataType[]{StiParserDataType.Long}), new StiParserMethodInfo(StiFunctionType.ToWordsPl, 1, new StiParserDataType[]{StiParserDataType.Long, StiParserDataType.Bool}), new StiParserMethodInfo(StiFunctionType.ToWordsPt, 1, new StiParserDataType[]{StiParserDataType.Long, StiParserDataType.Bool}), new StiParserMethodInfo(StiFunctionType.ToWordsRu, 1, new StiParserDataType[]{StiParserDataType.Long}), new StiParserMethodInfo(StiFunctionType.ToWordsRu, 3, new StiParserDataType[]{StiParserDataType.Double}), new StiParserMethodInfo(StiFunctionType.ToWordsRu, 2, new StiParserDataType[]{StiParserDataType.Decimal}), new StiParserMethodInfo(StiFunctionType.ToWordsRu, 4, new StiParserDataType[]{StiParserDataType.Long, StiParserDataType.Bool}), new StiParserMethodInfo(StiFunctionType.ToWordsRu, 6, new StiParserDataType[]{StiParserDataType.Double, StiParserDataType.Bool}), new StiParserMethodInfo(StiFunctionType.ToWordsRu, 5, new StiParserDataType[]{StiParserDataType.Decimal, StiParserDataType.Bool}), new StiParserMethodInfo(StiFunctionType.ToWordsUa, 1, new StiParserDataType[]{StiParserDataType.Long}), new StiParserMethodInfo(StiFunctionType.ToWordsUa, 3, new StiParserDataType[]{StiParserDataType.Double}), new StiParserMethodInfo(StiFunctionType.ToWordsUa, 2, new StiParserDataType[]{StiParserDataType.Decimal}), new StiParserMethodInfo(StiFunctionType.ToWordsUa, 4, new StiParserDataType[]{StiParserDataType.Long, StiParserDataType.Bool}), new StiParserMethodInfo(StiFunctionType.ToWordsUa, 6, new StiParserDataType[]{StiParserDataType.Double, StiParserDataType.Bool}), new StiParserMethodInfo(StiFunctionType.ToWordsUa, 5, new StiParserDataType[]{StiParserDataType.Decimal, StiParserDataType.Bool}), new StiParserMethodInfo(StiFunctionType.ToCurrencyWords, 1, new StiParserDataType[]{StiParserDataType.Long}), new StiParserMethodInfo(StiFunctionType.ToCurrencyWords, 2, new StiParserDataType[]{StiParserDataType.Double}), new StiParserMethodInfo(StiFunctionType.ToCurrencyWords, 3, new StiParserDataType[]{StiParserDataType.Decimal}), new StiParserMethodInfo(StiFunctionType.ToCurrencyWords, 4, new StiParserDataType[]{StiParserDataType.Long, StiParserDataType.Bool}), new StiParserMethodInfo(StiFunctionType.ToCurrencyWords, 5, new StiParserDataType[]{StiParserDataType.Double, StiParserDataType.Bool}), new StiParserMethodInfo(StiFunctionType.ToCurrencyWords, 6, new StiParserDataType[]{StiParserDataType.Decimal, StiParserDataType.Bool}), new StiParserMethodInfo(StiFunctionType.ToCurrencyWords, 7, new StiParserDataType[]{StiParserDataType.Long, StiParserDataType.Bool, StiParserDataType.Bool}), new StiParserMethodInfo(StiFunctionType.ToCurrencyWords, 8, new StiParserDataType[]{StiParserDataType.Double, StiParserDataType.Bool, StiParserDataType.Bool}), new StiParserMethodInfo(StiFunctionType.ToCurrencyWords, 9, new StiParserDataType[]{StiParserDataType.Decimal, StiParserDataType.Bool, StiParserDataType.Bool}), new StiParserMethodInfo(StiFunctionType.ToCurrencyWords, 10, new StiParserDataType[]{StiParserDataType.Double, StiParserDataType.Bool, StiParserDataType.Bool, StiParserDataType.String, StiParserDataType.String}), new StiParserMethodInfo(StiFunctionType.DateToStr, 1, new StiParserDataType[]{StiParserDataType.DateTime}), new StiParserMethodInfo(StiFunctionType.DateToStr, 2, new StiParserDataType[]{StiParserDataType.DateTime, StiParserDataType.Bool}), new StiParserMethodInfo(StiFunctionType.Left, 1, new StiParserDataType[]{StiParserDataType.Object, StiParserDataType.Int}), new StiParserMethodInfo(StiFunctionType.Right, 1, new StiParserDataType[]{StiParserDataType.Object, StiParserDataType.Int}), new StiParserMethodInfo(StiFunctionType.Mid, 1, new StiParserDataType[]{StiParserDataType.Object, StiParserDataType.Int, StiParserDataType.Int}), new StiParserMethodInfo(StiFunctionType.JoinColumnContent, 1, new StiParserDataType[]{StiParserDataType.StiDataSource, StiParserDataType.String, StiParserDataType.String}, new StiSystemTypeEnum[]{StiSystemTypeEnum.SystemObject, StiSystemTypeEnum.SystemObject, StiSystemTypeEnum.SystemObject}), new StiParserMethodInfo(StiFunctionType.MathRound, 1, new StiParserDataType[]{StiParserDataType.Double}, new StiSystemTypeEnum[]{StiSystemTypeEnum.SystemDouble}), new StiParserMethodInfo(StiFunctionType.MathRound, 2, new StiParserDataType[]{StiParserDataType.Double, StiParserDataType.Int}, new StiSystemTypeEnum[]{StiSystemTypeEnum.SystemDouble}), new StiParserMethodInfo(StiFunctionType.MathRound, 3, new StiParserDataType[]{StiParserDataType.Double, StiParserDataType.Int}, new StiSystemTypeEnum[]{StiSystemTypeEnum.SystemDouble}), new StiParserMethodInfo(StiFunctionType.MathRound, 4, new StiParserDataType[]{StiParserDataType.Double, StiParserDataType.Int, StiParserDataType.Int}, new StiSystemTypeEnum[]{StiSystemTypeEnum.SystemDouble}), new StiParserMethodInfo(StiFunctionType.MathRound, 5, new StiParserDataType[]{StiParserDataType.Decimal}, new StiSystemTypeEnum[]{StiSystemTypeEnum.SystemDecimal}), new StiParserMethodInfo(StiFunctionType.MathRound, 6, new StiParserDataType[]{StiParserDataType.Decimal, StiParserDataType.Int}, new StiSystemTypeEnum[]{StiSystemTypeEnum.SystemDecimal}), new StiParserMethodInfo(StiFunctionType.MathRound, 7, new StiParserDataType[]{StiParserDataType.Decimal, StiParserDataType.Int}, new StiSystemTypeEnum[]{StiSystemTypeEnum.SystemDecimal}), new StiParserMethodInfo(StiFunctionType.MathRound, 8, new StiParserDataType[]{StiParserDataType.Decimal, StiParserDataType.Int, StiParserDataType.Int}, new StiSystemTypeEnum[]{StiSystemTypeEnum.SystemDecimal}), new StiParserMethodInfo(StiFunctionType.SystemConvertToBoolean, 1, new StiParserDataType[]{StiParserDataType.Object}, new StiSystemTypeEnum[]{StiSystemTypeEnum.SystemBoolean}), new StiParserMethodInfo(StiFunctionType.SystemConvertToByte, 2, new StiParserDataType[]{StiParserDataType.Object}, new StiSystemTypeEnum[]{StiSystemTypeEnum.SystemByte}), new StiParserMethodInfo(StiFunctionType.SystemConvertToChar, 3, new StiParserDataType[]{StiParserDataType.Object}, new StiSystemTypeEnum[]{StiSystemTypeEnum.SystemChar}), new StiParserMethodInfo(StiFunctionType.SystemConvertToDateTime, 4, new StiParserDataType[]{StiParserDataType.Object}, new StiSystemTypeEnum[]{StiSystemTypeEnum.SystemDateTime}), new StiParserMethodInfo(StiFunctionType.SystemConvertToDecimal, 5, new StiParserDataType[]{StiParserDataType.Object}, new StiSystemTypeEnum[]{StiSystemTypeEnum.SystemDecimal}), new StiParserMethodInfo(StiFunctionType.SystemConvertToDouble, 6, new StiParserDataType[]{StiParserDataType.Object}, new StiSystemTypeEnum[]{StiSystemTypeEnum.SystemDouble}), new StiParserMethodInfo(StiFunctionType.SystemConvertToInt16, 7, new StiParserDataType[]{StiParserDataType.Object}, new StiSystemTypeEnum[]{StiSystemTypeEnum.SystemInt16}), new StiParserMethodInfo(StiFunctionType.SystemConvertToInt32, 8, new StiParserDataType[]{StiParserDataType.Object}, new StiSystemTypeEnum[]{StiSystemTypeEnum.SystemInt32}), new StiParserMethodInfo(StiFunctionType.SystemConvertToInt64, 9, new StiParserDataType[]{StiParserDataType.Object}, new StiSystemTypeEnum[]{StiSystemTypeEnum.SystemInt64}), new StiParserMethodInfo(StiFunctionType.SystemConvertToSByte, 10, new StiParserDataType[]{StiParserDataType.Object}, new StiSystemTypeEnum[]{StiSystemTypeEnum.SystemByte}), new StiParserMethodInfo(StiFunctionType.SystemConvertToSingle, 11, new StiParserDataType[]{StiParserDataType.Object}, new StiSystemTypeEnum[]{StiSystemTypeEnum.SystemSingle}), new StiParserMethodInfo(StiFunctionType.SystemConvertToString, 12, new StiParserDataType[]{StiParserDataType.Object}, new StiSystemTypeEnum[]{StiSystemTypeEnum.SystemString}), new StiParserMethodInfo(StiFunctionType.SystemConvertToUInt16, 13, new StiParserDataType[]{StiParserDataType.Object}, new StiSystemTypeEnum[]{StiSystemTypeEnum.SystemUInt16}), new StiParserMethodInfo(StiFunctionType.SystemConvertToUInt32, 14, new StiParserDataType[]{StiParserDataType.Object}, new StiSystemTypeEnum[]{StiSystemTypeEnum.SystemUInt32}), new StiParserMethodInfo(StiFunctionType.SystemConvertToUInt64, 15, new StiParserDataType[]{StiParserDataType.Object}, new StiSystemTypeEnum[]{StiSystemTypeEnum.SystemUInt64}), new StiParserMethodInfo(StiFunctionType.MathPow, 1, new StiParserDataType[]{StiParserDataType.Double, StiParserDataType.Double}, new StiSystemTypeEnum[]{StiSystemTypeEnum.SystemDouble}), new StiParserMethodInfo(StiFunctionType.GetAnchorPageNumber, 1, new StiParserDataType[]{StiParserDataType.Object}, new StiSystemTypeEnum[]{StiSystemTypeEnum.SystemInt32}), new StiParserMethodInfo(StiFunctionType.GetAnchorPageNumberThrough, 1, new StiParserDataType[]{StiParserDataType.Object}, new StiSystemTypeEnum[]{StiSystemTypeEnum.SystemInt32}), new StiParserMethodInfo(StiFunctionType.ParseDateTime, 1, new StiParserDataType[]{StiParserDataType.String}, new StiSystemTypeEnum[]{StiSystemTypeEnum.SystemDateTime}), new StiParserMethodInfo(StiFunctionType.ParseDecimal, 1, new StiParserDataType[]{StiParserDataType.String}, new StiSystemTypeEnum[]{StiSystemTypeEnum.SystemDecimal}), new StiParserMethodInfo(StiFunctionType.ParseDouble, 1, new StiParserDataType[]{StiParserDataType.String}, new StiSystemTypeEnum[]{StiSystemTypeEnum.SystemDouble}), new StiParserMethodInfo(StiFunctionType.ParseInt, 1, new StiParserDataType[]{StiParserDataType.String}, new StiSystemTypeEnum[]{StiSystemTypeEnum.SystemInt32}), new StiParserMethodInfo(StiFunctionType.StringIsNullOrEmpty, 1, new StiParserDataType[]{StiParserDataType.String}, new StiSystemTypeEnum[]{StiSystemTypeEnum.SystemBoolean}), new StiParserMethodInfo(StiFunctionType.StringIsNullOrWhiteSpace, 1, new StiParserDataType[]{StiParserDataType.String}, new StiSystemTypeEnum[]{StiSystemTypeEnum.SystemBoolean}), new StiParserMethodInfo(StiFunctionType.IsNull, 1, new StiParserDataType[]{StiParserDataType.Object, StiParserDataType.String}, new StiSystemTypeEnum[]{StiSystemTypeEnum.SystemBoolean}), new StiParserMethodInfo(StiFunctionType.Next, 1, new StiParserDataType[]{StiParserDataType.Object, StiParserDataType.String}, new StiSystemTypeEnum[]{StiSystemTypeEnum.SystemObject}), new StiParserMethodInfo(StiFunctionType.NextIsNull, 1, new StiParserDataType[]{StiParserDataType.Object, StiParserDataType.String}, new StiSystemTypeEnum[]{StiSystemTypeEnum.SystemBoolean}), new StiParserMethodInfo(StiFunctionType.Previous, 1, new StiParserDataType[]{StiParserDataType.Object, StiParserDataType.String}, new StiSystemTypeEnum[]{StiSystemTypeEnum.SystemObject}), new StiParserMethodInfo(StiFunctionType.PreviousIsNull, 1, new StiParserDataType[]{StiParserDataType.Object, StiParserDataType.String}, new StiSystemTypeEnum[]{StiSystemTypeEnum.SystemBoolean}), new StiParserMethodInfo(StiFunctionType.StiNullValuesHelperIsNull, 1, new StiParserDataType[]{StiParserDataType.Object, StiParserDataType.String}, new StiSystemTypeEnum[]{StiSystemTypeEnum.SystemBoolean}), new StiParserMethodInfo(StiFunctionType.TimeSpanFromDays, 1, new StiParserDataType[]{StiParserDataType.Double}, new StiSystemTypeEnum[]{StiSystemTypeEnum.SystemTimeSpan}), new StiParserMethodInfo(StiFunctionType.TimeSpanFromHours, 1, new StiParserDataType[]{StiParserDataType.Double}, new StiSystemTypeEnum[]{StiSystemTypeEnum.SystemTimeSpan}), new StiParserMethodInfo(StiFunctionType.TimeSpanFromMilliseconds, 1, new StiParserDataType[]{StiParserDataType.Double}, new StiSystemTypeEnum[]{StiSystemTypeEnum.SystemTimeSpan}), new StiParserMethodInfo(StiFunctionType.TimeSpanFromMinutes, 1, new StiParserDataType[]{StiParserDataType.Double}, new StiSystemTypeEnum[]{StiSystemTypeEnum.SystemTimeSpan}), new StiParserMethodInfo(StiFunctionType.TimeSpanFromSeconds, 1, new StiParserDataType[]{StiParserDataType.Double}, new StiSystemTypeEnum[]{StiSystemTypeEnum.SystemTimeSpan}), new StiParserMethodInfo(StiFunctionType.TimeSpanFromTicks, 1, new StiParserDataType[]{StiParserDataType.Int64}, new StiSystemTypeEnum[]{StiSystemTypeEnum.SystemTimeSpan}), new StiParserMethodInfo(StiFunctionType.TryParseDateTime, 1, new StiParserDataType[]{StiParserDataType.Object}, new StiSystemTypeEnum[]{StiSystemTypeEnum.SystemBoolean}), new StiParserMethodInfo(StiFunctionType.StrToDateTime, 1, new StiParserDataType[]{StiParserDataType.Object}, new StiSystemTypeEnum[]{StiSystemTypeEnum.SystemDateTime}), new StiParserMethodInfo(StiFunctionType.StrToNullableDateTime, 1, new StiParserDataType[]{StiParserDataType.Object}, new StiSystemTypeEnum[]{StiSystemTypeEnum.SystemDateTime})};
        constantsList.put("DBNull", namespaceObj);
        constantsList.put("DBNull.Value", DBNull.Value);
        constantsList.put("string.Empty", "");
        constantsList.put("MidpointRounding", namespaceObj);
        constantsList.put("MidpointRounding.ToEven", "ToEven");
        constantsList.put("MidpointRounding.AwayFromZero", "AwayFromZero");
        constantsList.put("StiRankOrder", namespaceObj);
        namespacesList.put("Totals", namespaceObj);
        namespacesList.put("System", namespaceObj);
        namespacesList.put("String", namespaceObj);
        namespacesList.put("System.Convert", namespaceObj);
        namespacesList.put("System.Globalization", namespaceObj);
        namespacesList.put("Convert", namespaceObj);
        namespacesList.put("Math", namespaceObj);
        namespacesList.put("Func", namespaceObj);
        namespacesList.put("Func.EngineHelper", namespaceObj);
        errorsList = new String[]{"Syntax error %s %s %s %s", "Integral constant is too large", "The expression is empty", "Division by zero", "Unexpected end of expression", "The name '%s' does not exist in the current context", "Syntax error - unprocessed lexemes remain", "( expected", ") expected", "Field, method, or property is not found: '%s'", "Operator '%s' cannot be applied to operands of type '%s' and type '%s'", "The function is not found: '%s'", "No overload for method '%s' takes '%s' arguments", "The '%s' function has invalid argument '%s': cannot convert from '%s' to '%s'", "The '%s' function is not yet implemented", "The '%s' method has invalid argument '%s': cannot convert from '%s' to '%s'", "'%s' does not contain a definition for '%s'"};
    }

    public static class StiToken {
        public StiTokenType Type = StiTokenType.forValue((int)0);
        public String Value;
        public Object ValueObject;
        public int Position = -1;
        public int Length = -1;

        public StiToken(StiTokenType type) {
            this.Type = type;
        }

        public StiToken() {
            this.Type = StiTokenType.Empty;
        }

        public StiToken(StiTokenType type, int position, int length) {
            this.Type = type;
            this.Position = position;
            this.Length = length;
        }

        public String toString() {
            return String.format("TokenType=%s|value=%s", this.Type, this.Value);
        }
    }

    public static class StiFilterParserData {
        public StiComponent Component;
        public String Expression;

        public StiFilterParserData(StiComponent component, String expression) {
            this.Component = component;
            this.Expression = expression;
        }
    }
}

