/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.report.export.service;

import com.stimulsoft.base.drawing.StiBorderSide;
import com.stimulsoft.base.drawing.StiColor;
import com.stimulsoft.base.drawing.StiColorEnum;
import com.stimulsoft.base.drawing.enums.StiPenStyle;
import com.stimulsoft.base.exception.StiException;
import com.stimulsoft.base.localization.StiLocalization;
import com.stimulsoft.base.system.StiSize;
import com.stimulsoft.base.system.geometry.StiRectangle;
import com.stimulsoft.base.utils.StiByteArrayOutputStream;
import com.stimulsoft.base.utils.StiRtfHelper;
import com.stimulsoft.lib.utils.StiStringUtil;
import com.stimulsoft.lib.utils.StiValidationUtil;
import com.stimulsoft.report.StiReport;
import com.stimulsoft.report.components.StiComponent;
import com.stimulsoft.report.components.StiPage;
import com.stimulsoft.report.components.StiPagesCollection;
import com.stimulsoft.report.components.enums.StiPageOrientation;
import com.stimulsoft.report.components.interfaces.IStiExportImage;
import com.stimulsoft.report.components.interfaces.IStiExportImageExtended;
import com.stimulsoft.report.components.simplecomponents.StiCheckBox;
import com.stimulsoft.report.components.simplecomponents.StiImage;
import com.stimulsoft.report.components.simplecomponents.StiImageHelper;
import com.stimulsoft.report.components.simplecomponents.StiRichText;
import com.stimulsoft.report.components.simplecomponents.StiText;
import com.stimulsoft.report.enums.StiExportFormat;
import com.stimulsoft.report.export.service.StiExportService;
import com.stimulsoft.report.export.settings.StiExcelExportSettings;
import com.stimulsoft.report.export.settings.StiExportSettings;
import com.stimulsoft.report.export.tools.StiCell;
import com.stimulsoft.report.export.tools.StiCellStyle;
import com.stimulsoft.report.export.tools.StiExportUtils;
import com.stimulsoft.report.export.tools.StiImageFormat;
import com.stimulsoft.report.export.tools.StiMapUtil;
import com.stimulsoft.report.export.tools.StiMatrix;
import com.stimulsoft.report.export.tools.StiPagesRange;
import com.stimulsoft.report.options.ExportOptions;
import java.awt.image.BufferedImage;
import java.io.ByteArrayOutputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.Hashtable;

public class StiExcelExportService
extends StiExportService {
    private static final double TWIPS_TO_COL_INFO = 2.239233819960861;
    private StiMatrix matrix = null;
    private ArrayList<DataXF> xfList = null;
    private ArrayList<StiColor> colorList = null;
    private ArrayList<DataFont> fontList = null;
    private ArrayList<String> sstList = null;
    private Hashtable<String, Integer> sstHash = null;
    private ArrayList<String> formatList = null;
    private int sstCounter;
    private byte[] bfHeader = null;
    private int[] bfData = null;
    private StiByteArrayOutputStream memst = null;
    private StiByteArrayOutputStream memStMain = null;
    private ArrayList<BiffImageData> imageList = null;
    private Escher escher = null;
    private final int maxRecordLength = 8224;
    private boolean useOnePageHeaderAndFooter = false;
    private boolean exportDataOnly = false;
    private boolean exportObjectFormatting = true;
    private boolean exportEachPageToSheet = false;
    private ArrayList<ByteArrayOutputStream> pagesList = null;
    private ArrayList<String[][]> bookmarksList = null;
    private ArrayList<ArrayList<HlinkData>> hlinksList = null;
    private ArrayList<Integer> boundsheetsOffsetsList = null;
    private ArrayList<String> boundsheetsNamesList = null;
    private float imageResolution = 1.0f;
    private float imageQuality = 0.75f;
    private boolean exportHorizontalPageBreaks = false;
    private int minRowIndex = 0;
    private int maxRowIndex = 0;
    private int maximumSheetHeight = 65534;
    private static byte percentScaleForFontHeightCorrection = (byte)100;

    private int getLineStyle(StiBorderSide border) {
        StiPenStyle penStyle = StiPenStyle.None;
        double width = 0.0;
        double mediumWidth = 1.5;
        double thickWidth = 3.0;
        if (border != null) {
            penStyle = border.getStyle();
            width = border.getSize();
        }
        switch (penStyle) {
            case Solid: {
                if (width > 3.0) {
                    return 5;
                }
                if (width > 1.5) {
                    return 2;
                }
                return 1;
            }
            case Dot: {
                if (width > 1.5) {
                    return 4;
                }
                return 7;
            }
            case Dash: {
                if (width > 1.5) {
                    return 8;
                }
                return 3;
            }
            case DashDot: {
                if (width > 1.5) {
                    return 10;
                }
                return 9;
            }
            case DashDotDot: {
                if (width > 1.5) {
                    return 12;
                }
                return 11;
            }
            case Double: {
                return 6;
            }
        }
        return 0;
    }

    private boolean compareExcellSheetNames(String name1, String name2) {
        String st2;
        String st1 = name1;
        if (StiValidationUtil.isNullOrEmpty((String)st1)) {
            st1 = "";
        }
        if (StiValidationUtil.isNullOrEmpty((String)(st2 = name2))) {
            st2 = "";
        }
        return st1.equals(st2);
    }

    private String getRefString(int column, int row) {
        int columnHigh = column / 26;
        int columnLow = column % 26;
        StringBuilder output = new StringBuilder();
        if (columnHigh > 0) {
            output.append((char)(65 + columnHigh - 1));
        }
        output.append((char)(65 + columnLow));
        output.append(String.valueOf(row + 1));
        return output.toString();
    }

    private int getXFNumber(DataXF dataIn) {
        if (this.xfList.size() > 16) {
            for (int index = 0; index < this.xfList.size(); ++index) {
                if (!this.xfList.get(index).equals(dataIn)) continue;
                return index;
            }
        }
        this.xfList.add(dataIn);
        int temp = this.xfList.size() - 1;
        return temp;
    }

    private int getColorNumber(StiColor incomingColor) {
        for (int index = 0; index < this.colorList.size(); ++index) {
            if (!this.colorList.get(index).equals(incomingColor)) continue;
            return index + 8;
        }
        this.colorList.add(incomingColor);
        int temp = this.colorList.size() - 1;
        return temp + 8;
    }

    private int getFontNumber(DataFont dataIn) {
        if (this.fontList.size() > 4) {
            for (int index = 4; index < this.fontList.size(); ++index) {
                if (!this.fontList.get(index).equals(dataIn)) continue;
                return index + 1;
            }
        }
        this.fontList.add(dataIn);
        int temp = this.fontList.size() - 1;
        if (temp >= 4) {
            ++temp;
        }
        return temp;
    }

    private int getSSTNumber(String dataIn) {
        ++this.sstCounter;
        if (this.sstHash.containsKey(dataIn)) {
            return this.sstHash.get(dataIn);
        }
        this.sstList.add(dataIn);
        int temp = this.sstList.size() - 1;
        this.sstHash.put(dataIn, temp);
        return temp;
    }

    private int getFormatNumber(String dataIn) {
        for (int index = 0; index < this.formatList.size(); ++index) {
            if (!this.formatList.get(index).equals(dataIn)) continue;
            return index + 164;
        }
        this.formatList.add(dataIn);
        int temp = this.formatList.size() - 1;
        return temp + 164;
    }

    private void addRec(int com, int len) {
        this.bfHeader[0] = (byte)(com & 0xFF);
        this.bfHeader[1] = (byte)(com >> 8 & 0xFF);
        this.bfHeader[2] = (byte)(len & 0xFF);
        this.bfHeader[3] = (byte)(len >> 8 & 0xFF);
        this.memst.write(this.bfHeader, 0, 4);
        for (int i = 0; i < len; ++i) {
            this.memst.write((int)((byte)this.bfData[i]));
        }
    }

    private void dwByte(int position, int dataValue) {
        this.bfData[position] = dataValue;
    }

    private void dwShort(int position, int dataValue) {
        this.bfData[position + 0] = (byte)(dataValue & 0xFF);
        this.bfData[position + 1] = (byte)(dataValue >> 8 & 0xFF);
    }

    private void dwInt(int position, int dataValue) {
        this.bfData[position + 0] = (byte)(dataValue & 0xFF);
        this.bfData[position + 1] = (byte)(dataValue >> 8 & 0xFF);
        this.bfData[position + 2] = (byte)(dataValue >> 16 & 0xFF);
        this.bfData[position + 3] = (byte)(dataValue >> 24 & 0xFF);
    }

    private void dwByte(int position, int dv1, int dv2) {
        this.dwByte(position, dv1);
        this.dwByte(position + 1, dv2);
    }

    private void dwByte(int position, int dv1, int dv2, int dv3) {
        this.dwByte(position, dv1, dv2);
        this.dwByte(position + 2, dv3);
    }

    private void dwByte(int position, int dv1, int dv2, int dv3, int dv4) {
        this.dwByte(position, dv1, dv2, dv3);
        this.dwByte(position + 3, dv4);
    }

    private void dwFill(int position, int dataValue, int count) {
        for (int index = 0; index < count; ++index) {
            this.bfData[position + index] = dataValue;
        }
    }

    private boolean stringMayBePacked(String data) {
        boolean mayBePacked = true;
        for (int index = 0; index < data.length(); ++index) {
            if (data.charAt(index) < '\u0080') continue;
            mayBePacked = false;
        }
        return mayBePacked;
    }

    private int dwString(int position, String dataValue, int bytesLen, int offset, boolean pack) {
        int len = dataValue.length();
        boolean isStringPacked = this.stringMayBePacked(dataValue);
        if (!pack) {
            isStringPacked = false;
        }
        if (bytesLen != 0) {
            this.dwShort(position, len);
            position += 2;
            if (bytesLen == 1) {
                --position;
            }
            this.dwByte(position, (byte)(!isStringPacked ? 1 : 0));
            ++position;
        }
        for (int index = 0; index < len; ++index) {
            if (isStringPacked) {
                this.dwByte(position, (byte)dataValue.charAt(index));
                ++position;
                continue;
            }
            this.dwShort(position, (short)dataValue.charAt(index));
            position += 2;
        }
        offset = position;
        return offset;
    }

    private void dwDouble(int pos, double valueDouble) {
        long value = Double.doubleToRawLongBits(valueDouble);
        this.bfData[pos + 0] = (byte)(value & 0xFFL);
        this.bfData[pos + 1] = (byte)(value >> 8 & 0xFFL);
        this.bfData[pos + 2] = (byte)(value >> 16 & 0xFFL);
        this.bfData[pos + 3] = (byte)(value >> 24 & 0xFFL);
        this.bfData[pos + 4] = (byte)(value >> 32 & 0xFFL);
        this.bfData[pos + 5] = (byte)(value >> 40 & 0xFFL);
        this.bfData[pos + 6] = (byte)(value >> 48 & 0xFFL);
        this.bfData[pos + 7] = (byte)(value >> 56 & 0xFFL);
    }

    private int convert(double x) {
        return (int)(x * StiExcelExportService.getHiToTwips());
    }

    private void prepareData() {
        this.xfList = new ArrayList();
        this.colorList = new ArrayList();
        this.fontList = new ArrayList();
        this.sstList = new ArrayList();
        this.sstHash = new Hashtable();
        this.formatList = new ArrayList();
        this.imageList = new ArrayList();
        this.sstCounter = 0;
        this.pagesList = new ArrayList();
        this.bookmarksList = new ArrayList();
        this.hlinksList = new ArrayList();
        this.boundsheetsOffsetsList = new ArrayList();
        this.boundsheetsNamesList = new ArrayList();
        this.escher = new Escher();
        DataXF tempXF = new DataXF(0, 0, 1, 4095, 0, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 64, 65);
        this.getXFNumber(tempXF);
        tempXF = new DataXF(1, 0, 1, 4095, 0, 2, 0, 0, 0, 61, 0, 0, 0, 0, 0, 0, 0, 0, 0, 64, 65);
        this.getXFNumber(tempXF);
        tempXF = new DataXF(1, 0, 1, 4095, 0, 2, 0, 0, 0, 61, 0, 0, 0, 0, 0, 0, 0, 0, 0, 64, 65);
        this.getXFNumber(tempXF);
        tempXF = new DataXF(2, 0, 1, 4095, 0, 2, 0, 0, 0, 61, 0, 0, 0, 0, 0, 0, 0, 0, 0, 64, 65);
        this.getXFNumber(tempXF);
        tempXF = new DataXF(2, 0, 1, 4095, 0, 2, 0, 0, 0, 61, 0, 0, 0, 0, 0, 0, 0, 0, 0, 64, 65);
        this.getXFNumber(tempXF);
        tempXF = new DataXF(0, 0, 1, 4095, 0, 2, 0, 0, 0, 61, 0, 0, 0, 0, 0, 0, 0, 0, 0, 64, 65);
        this.getXFNumber(tempXF);
        tempXF = new DataXF(0, 0, 1, 4095, 0, 2, 0, 0, 0, 61, 0, 0, 0, 0, 0, 0, 0, 0, 0, 64, 65);
        this.getXFNumber(tempXF);
        tempXF = new DataXF(0, 0, 1, 4095, 0, 2, 0, 0, 0, 61, 0, 0, 0, 0, 0, 0, 0, 0, 0, 64, 65);
        this.getXFNumber(tempXF);
        tempXF = new DataXF(0, 0, 1, 4095, 0, 2, 0, 0, 0, 61, 0, 0, 0, 0, 0, 0, 0, 0, 0, 64, 65);
        this.getXFNumber(tempXF);
        tempXF = new DataXF(0, 0, 1, 4095, 0, 2, 0, 0, 0, 61, 0, 0, 0, 0, 0, 0, 0, 0, 0, 64, 65);
        this.getXFNumber(tempXF);
        tempXF = new DataXF(0, 0, 1, 4095, 0, 2, 0, 0, 0, 61, 0, 0, 0, 0, 0, 0, 0, 0, 0, 64, 65);
        this.getXFNumber(tempXF);
        tempXF = new DataXF(0, 0, 1, 4095, 0, 2, 0, 0, 0, 61, 0, 0, 0, 0, 0, 0, 0, 0, 0, 64, 65);
        this.getXFNumber(tempXF);
        tempXF = new DataXF(0, 0, 1, 4095, 0, 2, 0, 0, 0, 61, 0, 0, 0, 0, 0, 0, 0, 0, 0, 64, 65);
        this.getXFNumber(tempXF);
        tempXF = new DataXF(0, 0, 1, 4095, 0, 2, 0, 0, 0, 61, 0, 0, 0, 0, 0, 0, 0, 0, 0, 64, 65);
        this.getXFNumber(tempXF);
        tempXF = new DataXF(0, 0, 1, 4095, 0, 2, 0, 0, 0, 61, 0, 0, 0, 0, 0, 0, 0, 0, 0, 64, 65);
        this.getXFNumber(tempXF);
        tempXF = new DataXF(0, 0, 0, 0, 0, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 64, 65);
        this.getXFNumber(tempXF);
        tempXF = new DataXF(1, 44, 1, 4095, 0, 2, 0, 0, 0, 62, 0, 0, 0, 0, 0, 0, 0, 0, 0, 64, 65);
        this.getXFNumber(tempXF);
        tempXF = new DataXF(1, 42, 1, 4095, 0, 2, 0, 0, 0, 62, 0, 0, 0, 0, 0, 0, 0, 0, 0, 64, 65);
        this.getXFNumber(tempXF);
        tempXF = new DataXF(1, 9, 1, 4095, 0, 2, 0, 0, 0, 62, 0, 0, 0, 0, 0, 0, 0, 0, 0, 64, 65);
        this.getXFNumber(tempXF);
        tempXF = new DataXF(1, 43, 1, 4095, 0, 2, 0, 0, 0, 62, 0, 0, 0, 0, 0, 0, 0, 0, 0, 64, 65);
        this.getXFNumber(tempXF);
        tempXF = new DataXF(1, 41, 1, 4095, 0, 2, 0, 0, 0, 62, 0, 0, 0, 0, 0, 0, 0, 0, 0, 64, 65);
        this.getXFNumber(tempXF);
        DataFont tempFont = new DataFont("Arial", false, false, false, false, 200, Short.MAX_VALUE, 1);
        this.getFontNumber(tempFont);
        this.getFontNumber(tempFont);
        this.getFontNumber(tempFont);
        this.getFontNumber(tempFont);
    }

    private StiSize makeWorksheetStream(StiPagesCollection pages) throws IOException {
        int pos;
        CellRangeAddress tempCellRange;
        ArrayList<CellRangeAddress> mergedCells = new ArrayList<CellRangeAddress>();
        ArrayList<int[]> hlinks = new ArrayList<int[]>();
        ArrayList<HlinkData> hlinkLocal = new ArrayList<HlinkData>();
        int startImageIndex = this.imageList.size();
        StiPage page = pages.get(0);
        if (this.matrix == null) {
            this.matrix = new StiMatrix(pages, ExportOptions.Excel.getDivideBigCells(), this);
            if (this.isStoped()) {
                return new StiSize(0, 0);
            }
            if (this.useOnePageHeaderAndFooter) {
                int tempOffset;
                this.matrix.scanComponentsPlacement(true, this.exportObjectFormatting);
                for (tempOffset = 0; this.matrix.getLinePlacement()[tempOffset] != StiMatrix.StiTableLineInfo.PageHeader && tempOffset < this.matrix.getCoordY().size() - 1; ++tempOffset) {
                }
                if (this.matrix.getLinePlacement()[tempOffset] == StiMatrix.StiTableLineInfo.PageHeader) {
                    while (this.matrix.getLinePlacement()[tempOffset] == StiMatrix.StiTableLineInfo.PageHeader && tempOffset < this.matrix.getCoordY().size() - 1) {
                        ++tempOffset;
                    }
                    while (tempOffset < this.matrix.getCoordY().size() - 1) {
                        if (this.matrix.getLinePlacement()[tempOffset] == StiMatrix.StiTableLineInfo.PageHeader) {
                            this.matrix.getLinePlacement()[tempOffset] = StiMatrix.StiTableLineInfo.Trash;
                        }
                        ++tempOffset;
                    }
                }
                for (tempOffset = this.matrix.getCoordY().size() - 1; this.matrix.getLinePlacement()[tempOffset] != StiMatrix.StiTableLineInfo.PageFooter && tempOffset > 0; --tempOffset) {
                }
                if (this.matrix.getLinePlacement()[tempOffset] == StiMatrix.StiTableLineInfo.PageFooter) {
                    while (this.matrix.getLinePlacement()[tempOffset] == StiMatrix.StiTableLineInfo.PageFooter && tempOffset > 0) {
                        --tempOffset;
                    }
                    while (tempOffset > 0) {
                        if (this.matrix.getLinePlacement()[tempOffset] == StiMatrix.StiTableLineInfo.PageFooter) {
                            this.matrix.getLinePlacement()[tempOffset] = StiMatrix.StiTableLineInfo.Trash;
                        }
                        --tempOffset;
                    }
                }
                int linesCount = 0;
                for (int rowIndex = 0; rowIndex < this.matrix.getCoordY().size() - 1; ++rowIndex) {
                    if (this.matrix.getLinePlacement()[rowIndex] == StiMatrix.StiTableLineInfo.Trash) continue;
                    for (int columnIndex = 0; columnIndex < this.matrix.getCoordX().size() - 1; ++columnIndex) {
                        this.matrix.getCells()[linesCount][columnIndex] = this.matrix.getCells()[rowIndex][columnIndex];
                        StiCell cell = this.matrix.getCells()[linesCount][columnIndex];
                        if (cell != null) {
                            cell.setTop(linesCount);
                            if (cell.getExportImage() != null) {
                                StiComponent component = cell.getComponent();
                                StiRectangle rect = this.matrix.getImagesBaseRect().get(component);
                                if (rect != null) {
                                    double offset = (Double)StiMapUtil.getByIndex(this.matrix.getCoordY(), rowIndex) - (Double)StiMapUtil.getByIndex(this.matrix.getCoordY(), linesCount);
                                    rect.setY(rect.getY() - offset);
                                    this.matrix.getImagesBaseRect().put(component, rect);
                                }
                            }
                        }
                        this.matrix.getBordersX()[linesCount][columnIndex] = this.matrix.getBordersX()[rowIndex][columnIndex];
                        this.matrix.getBordersY()[linesCount][columnIndex] = this.matrix.getBordersY()[rowIndex][columnIndex];
                        this.matrix.getBookmarks()[linesCount][columnIndex] = this.matrix.getBookmarks()[rowIndex][columnIndex];
                    }
                    this.matrix.getBordersY()[linesCount][this.matrix.getCoordX().size() - 1] = this.matrix.getBordersY()[rowIndex][this.matrix.getCoordX().size() - 1];
                    double lineHeight = (Double)StiMapUtil.getByIndex(this.matrix.getCoordY(), rowIndex + 1) - (Double)StiMapUtil.getByIndex(this.matrix.getCoordY(), rowIndex);
                    StiMapUtil.setByIndex(this.matrix.getCoordY(), linesCount + 1, (Double)StiMapUtil.getByIndex(this.matrix.getCoordY(), linesCount) + lineHeight);
                    ++linesCount;
                }
                for (int columnIndex = 0; columnIndex < this.matrix.getCoordX().size() - 1; ++columnIndex) {
                    this.matrix.getBordersX()[linesCount][columnIndex] = this.matrix.getBordersX()[this.matrix.getCoordY().size() - 1][columnIndex];
                }
                int numAbove = this.matrix.getCoordY().size() - 1 - linesCount;
                if (numAbove > 0) {
                    for (int tempIndex = 0; tempIndex < numAbove; ++tempIndex) {
                        StiMapUtil.removeAt(this.matrix.getCoordY(), linesCount + 1);
                    }
                }
            }
            if (this.exportDataOnly) {
                this.matrix.scanComponentsPlacement(true, this.exportObjectFormatting);
                int linesCount = 0;
                Hashtable<String, String> headerNames = new Hashtable<String, String>();
                String lastParentBandName = null;
                boolean allowExportFooters = ExportOptions.Excel.isAllowExportFootersInDataOnlyMode();
                for (int rowIndex = 0; rowIndex < this.matrix.getCoordY().size() - 1; ++rowIndex) {
                    boolean isHeader = false;
                    if (this.matrix.getLinePlacement()[rowIndex] == StiMatrix.StiTableLineInfo.HeaderD || this.matrix.getLinePlacement()[rowIndex] == StiMatrix.StiTableLineInfo.HeaderAP) {
                        String parentBandName;
                        String tempSt = this.matrix.getParentBandName()[rowIndex];
                        int symPos = tempSt.indexOf(31);
                        if (symPos != -1 && (parentBandName = tempSt.substring(0, symPos)) != lastParentBandName) {
                            lastParentBandName = parentBandName;
                            headerNames.clear();
                        }
                        if (!headerNames.containsKey(tempSt)) {
                            isHeader = true;
                            headerNames.put(tempSt, tempSt);
                        }
                    }
                    if (this.matrix.getLinePlacement()[rowIndex] != StiMatrix.StiTableLineInfo.Data && (!allowExportFooters || this.matrix.getLinePlacement()[rowIndex] != StiMatrix.StiTableLineInfo.FooterD) && !isHeader) continue;
                    for (int columnIndex = 0; columnIndex < this.matrix.getCoordX().size() - 1; ++columnIndex) {
                        this.matrix.getCells()[linesCount][columnIndex] = this.matrix.getCells()[rowIndex][columnIndex];
                        StiCell cell = this.matrix.getCells()[linesCount][columnIndex];
                        if (cell != null) {
                            cell.setTop(linesCount);
                            if (cell.getExportImage() != null) {
                                StiComponent component = cell.getComponent();
                                StiRectangle rect = this.matrix.getImagesBaseRect().get(component);
                                if (rect != null) {
                                    double offset = (Double)StiMapUtil.getByIndex(this.matrix.getCoordY(), rowIndex) - (Double)StiMapUtil.getByIndex(this.matrix.getCoordY(), linesCount);
                                    rect.setY(rect.getY() - offset);
                                    this.matrix.getImagesBaseRect().put(component, rect);
                                }
                            }
                        }
                        if (linesCount == 0 || this.matrix.getBordersX()[rowIndex][columnIndex] != null) {
                            this.matrix.getBordersX()[linesCount][columnIndex] = this.matrix.getBordersX()[rowIndex][columnIndex];
                        }
                        this.matrix.getBordersX()[linesCount + 1][columnIndex] = this.matrix.getBordersX()[rowIndex + 1][columnIndex];
                        this.matrix.getBordersY()[linesCount][columnIndex] = this.matrix.getBordersY()[rowIndex][columnIndex];
                        this.matrix.getBookmarks()[linesCount][columnIndex] = this.matrix.getBookmarks()[rowIndex][columnIndex];
                    }
                    this.matrix.getBordersY()[linesCount][this.matrix.getCoordX().size() - 1] = this.matrix.getBordersY()[rowIndex][this.matrix.getCoordX().size() - 1];
                    double lineHeight = (Double)StiMapUtil.getByIndex(this.matrix.getCoordY(), rowIndex + 1) - (Double)StiMapUtil.getByIndex(this.matrix.getCoordY(), rowIndex);
                    StiMapUtil.setByIndex(this.matrix.getCoordY(), linesCount + 1, (Double)StiMapUtil.getByIndex(this.matrix.getCoordY(), linesCount) + lineHeight);
                    ++linesCount;
                }
                int numAbove = this.matrix.getCoordY().size() - 1 - linesCount;
                if (numAbove > 0) {
                    for (int tempIndex = 0; tempIndex < numAbove; ++tempIndex) {
                        StiMapUtil.removeAt(this.matrix.getCoordY(), linesCount + 1);
                    }
                }
            }
            this.minRowIndex = 1;
        }
        this.maxRowIndex = this.matrix.getCoordY().size();
        if (this.maxRowIndex - this.minRowIndex > this.maximumSheetHeight) {
            this.maxRowIndex = this.minRowIndex + this.maximumSheetHeight;
        }
        this.dwFill(0, 0, 16);
        this.dwShort(0, 1536);
        this.dwShort(2, 16);
        this.dwShort(4, 3910);
        this.dwShort(6, 1996);
        this.dwInt(8, 32969);
        this.dwInt(12, 6);
        this.addRec(2057, 16);
        this.dwShort(0, 1);
        this.addRec(13, 2);
        this.dwShort(0, 100);
        this.addRec(12, 2);
        this.dwShort(0, 1);
        this.addRec(15, 2);
        this.dwShort(0, 0);
        this.addRec(17, 2);
        this.dwDouble(0, 0.001);
        this.addRec(16, 8);
        this.dwShort(0, 0);
        this.addRec(95, 2);
        this.dwShort(0, 0);
        this.addRec(42, 2);
        this.dwShort(0, 0);
        this.addRec(43, 2);
        this.dwShort(0, 1);
        this.addRec(130, 2);
        this.dwShort(0, 0);
        this.dwShort(2, 0);
        this.dwShort(4, 0);
        this.dwShort(6, 0);
        this.addRec(128, 8);
        this.dwShort(0, 0);
        this.dwShort(2, 255);
        this.addRec(549, 4);
        this.dwShort(0, 1217);
        this.addRec(129, 2);
        int horizontalPageBreaksCount = this.matrix.getHorizontalPageBreaks().size();
        if (this.exportHorizontalPageBreaks && horizontalPageBreaksCount > 0) {
            if (horizontalPageBreaksCount > 320) {
                horizontalPageBreaksCount = 320;
            }
            int firstColumn = 0;
            short lastColumn = (short)(this.matrix.getCoordX().size() - 2);
            this.dwShort(0, (short)horizontalPageBreaksCount);
            for (int indexBreak = 0; indexBreak < horizontalPageBreaksCount; indexBreak = (int)((short)(indexBreak + 1))) {
                this.dwShort(2 + indexBreak * 6 + 0, (short)this.matrix.getHorizontalPageBreaks().get(indexBreak).intValue());
                this.dwShort(2 + indexBreak * 6 + 2, firstColumn);
                this.dwShort(2 + indexBreak * 6 + 4, lastColumn);
            }
            this.addRec(27, horizontalPageBreaksCount * 6 + 2);
        }
        this.addRec(20, 0);
        this.addRec(21, 0);
        this.dwShort(0, 0);
        this.addRec(131, 2);
        this.dwShort(0, 0);
        this.addRec(132, 2);
        this.dwDouble(0, page.getUnit().ConvertToHInches(page.getMargins().getTop()) / 100.0);
        this.addRec(40, 8);
        this.dwDouble(0, page.getUnit().ConvertToHInches(page.getMargins().getBottom()) / 100.0);
        this.addRec(41, 8);
        this.dwDouble(0, page.getUnit().ConvertToHInches(page.getMargins().getLeft()) / 100.0);
        this.addRec(38, 8);
        this.dwDouble(0, page.getUnit().ConvertToHInches(page.getMargins().getRight()) / 100.0);
        this.addRec(39, 8);
        this.dwShort(0, (short)page.getPaperSize().getValue());
        this.dwShort(2, percentScaleForFontHeightCorrection);
        this.dwShort(4, 1);
        this.dwShort(6, 1);
        this.dwShort(8, 1);
        int option = 0 | (page.getOrientation() == StiPageOrientation.Portrait ? 2 : 0);
        this.dwShort(10, (short)option);
        this.dwShort(12, 0);
        this.dwShort(14, 0);
        this.dwDouble(16, 0.0);
        this.dwDouble(24, 0.0);
        this.dwShort(32, 1);
        this.addRec(161, 34);
        this.dwShort(0, 8);
        this.addRec(85, 2);
        if (this.exportObjectFormatting) {
            double value0 = (Double)StiMapUtil.getByIndex(this.matrix.getCoordX(), 0);
            int sum2 = 0;
            for (int columnIndex = 1; columnIndex < this.matrix.getCoordX().size(); ++columnIndex) {
                double value2 = (Double)StiMapUtil.getByIndex(this.matrix.getCoordX(), columnIndex);
                double offsetX = (value2 - value0) * StiExcelExportService.getHiToTwips() * 2.239233819960861;
                short colWidth2 = (short)(Math.round(offsetX) - (long)sum2);
                sum2 += colWidth2;
                this.dwShort(0, (short)(columnIndex - 1));
                this.dwShort(2, (short)(columnIndex - 1));
                this.dwShort(4, colWidth2);
                this.dwShort(6, 15);
                this.dwShort(8, 0);
                this.dwShort(10, 0);
                this.addRec(125, 12);
            }
        }
        this.dwFill(0, 0, 14);
        this.dwInt(0, 0);
        this.dwInt(4, this.maxRowIndex - this.minRowIndex);
        this.dwShort(8, 0);
        this.dwShort(10, (short)this.matrix.getCoordX().size());
        this.addRec(512, 14);
        boolean[][] readyCells = new boolean[this.maxRowIndex][this.matrix.getCoordX().size()];
        int[][] mergedCellsStyle = new int[this.maxRowIndex + 1][this.matrix.getCoordX().size()];
        for (int rowIndex = this.minRowIndex; rowIndex < this.maxRowIndex; ++rowIndex) {
            this.invokeExporting(rowIndex, this.matrix.getCoordY().size());
            if ((rowIndex - this.minRowIndex) % 32 == 0) {
                for (int tempIndex1 = 0; tempIndex1 < 32; ++tempIndex1) {
                    int tempRowIndex = rowIndex - 1 + tempIndex1;
                    if (tempRowIndex >= this.maxRowIndex - 1) continue;
                    double height = (Double)StiMapUtil.getByIndex(this.matrix.getCoordY(), tempRowIndex + 1) - (Double)StiMapUtil.getByIndex(this.matrix.getCoordY(), tempRowIndex);
                    this.dwFill(0, 0, 16);
                    this.dwShort(0, (short)(tempRowIndex - (this.minRowIndex - 1)));
                    this.dwShort(2, 0);
                    this.dwShort(4, (short)this.matrix.getCoordX().size());
                    if (this.exportObjectFormatting) {
                        this.dwShort(6, (short)this.convert(height));
                        this.dwInt(12, 983360);
                    } else {
                        this.dwInt(6, 255);
                        this.dwInt(12, 983296);
                    }
                    this.addRec(520, 16);
                }
            }
            for (int columnIndex = 1; columnIndex < this.matrix.getCoordX().size(); ++columnIndex) {
                DataXF tempXF;
                StiCell cell = this.matrix.getCells()[rowIndex - 1][columnIndex - 1];
                if (!readyCells[rowIndex - 1][columnIndex - 1] && cell != null) {
                    int VertAlign;
                    int HorAlign;
                    IStiExportImage exportImage;
                    String hyperlink;
                    readyCells[rowIndex - 1][columnIndex - 1] = true;
                    StiRichText rtf = cell.getComponent() instanceof StiRichText ? (StiRichText)cell.getComponent() : null;
                    StiText textComp = cell.getComponent() instanceof StiText ? (StiText)cell.getComponent() : null;
                    String str = cell.getText();
                    if (rtf != null && !"".equals(rtf.unpackRTF())) {
                        str = StiRtfHelper.rtfToPlain((String)rtf.unpackRTF());
                    }
                    StiCheckBox checkComp = cell.getComponent() instanceof StiCheckBox ? (StiCheckBox)cell.getComponent() : null;
                    boolean hasCheckBoxExcelDataValue = false;
                    if (checkComp != null && checkComp.getExcelDataValue() != null && checkComp.getExcelDataValue().length() > 0) {
                        hasCheckBoxExcelDataValue = true;
                        str = checkComp.getExcelDataValue();
                    }
                    if (cell.getComponent().getHyperlinkValue() != null && (hyperlink = cell.getComponent().getHyperlinkValue().trim()).length() > 0 && !hyperlink.startsWith("javascript:")) {
                        String description = str;
                        if (description == null || description.length() == 0) {
                            description = hyperlink;
                        }
                        if (hyperlink.startsWith("#")) {
                            hyperlink = hyperlink.substring(1);
                            CellRangeAddress range = new CellRangeAddress(rowIndex - this.minRowIndex, rowIndex - this.minRowIndex + cell.getHeight(), columnIndex - 1, columnIndex - 1 + cell.getWidth());
                            HlinkData hl = new HlinkData(range, description, hyperlink);
                            hlinkLocal.add(hl);
                        } else {
                            int indexChar;
                            this.dwShort(0, (short)(rowIndex - this.minRowIndex));
                            this.dwShort(2, (short)(rowIndex - this.minRowIndex + cell.getHeight()));
                            this.dwShort(4, (short)(columnIndex - 1));
                            this.dwShort(6, (short)(columnIndex - 1 + cell.getWidth()));
                            this.dwByte(8, 208, 201, 234, 121);
                            this.dwByte(12, 249, 186, 206, 17);
                            this.dwByte(16, 140, 130, 0, 170);
                            this.dwByte(20, 0, 75, 169, 11);
                            this.dwInt(24, 2);
                            this.dwInt(28, 23);
                            int hpos = 32;
                            this.dwInt(hpos, description.length() + 1);
                            hpos += 4;
                            for (indexChar = 0; indexChar < description.length(); ++indexChar) {
                                this.dwShort(hpos, description.charAt(indexChar));
                                hpos += 2;
                            }
                            this.dwShort(hpos, 0);
                            this.dwByte(hpos += 2, 224, 201, 234, 121);
                            this.dwByte(hpos + 4, 249, 186, 206, 17);
                            this.dwByte(hpos + 8, 140, 130, 0, 170);
                            this.dwByte(hpos + 12, 0, 75, 169, 11);
                            this.dwInt(hpos += 16, (hyperlink.length() + 1) * 2);
                            hpos += 4;
                            for (indexChar = 0; indexChar < hyperlink.length(); ++indexChar) {
                                this.dwShort(hpos, hyperlink.charAt(indexChar));
                                hpos += 2;
                            }
                            this.dwShort(hpos, 0);
                            int[] buf = new int[hpos += 2];
                            System.arraycopy(this.bfData, 0, buf, 0, hpos);
                            hlinks.add(buf);
                        }
                    }
                    IStiExportImage iStiExportImage = exportImage = cell.getComponent() instanceof IStiExportImage ? (IStiExportImage)((Object)cell.getComponent()) : null;
                    if (exportImage != null && this.imageList.size() < 1024) {
                        IStiExportImageExtended exportImageExtended = exportImage instanceof IStiExportImageExtended ? (IStiExportImageExtended)exportImage : null;
                        float zoom = this.imageResolution;
                        if (!ExportOptions.Excel.getUseImageResolution() || !(exportImage instanceof StiImage) || ((StiImage)exportImage).getImageBytesToDraw() != null) {
                            // empty if block
                        }
                        BufferedImage image = null;
                        if (cell.getComponent().isExportAsImage(StiExportFormat.Excel)) {
                            image = exportImageExtended != null && exportImageExtended.isExportAsImage(StiExportFormat.Excel) ? exportImageExtended.getImage(Double.valueOf(zoom), StiExportFormat.Excel) : exportImage.getImage(Double.valueOf(zoom));
                        }
                        if (image != null) {
                            BufferedImage img = this.matrix.getRealImageData(cell, image);
                            if (img != null) {
                                image = img;
                            }
                            ByteArrayOutputStream memw = new ByteArrayOutputStream();
                            StiImageHelper.saveWithDPI(image, memw, StiImageFormat.Jpeg, (Integer)((int)this.imageResolution * 100), this.imageQuality);
                            byte[] bytes = memw.toByteArray();
                            BiffImageData imageData = new BiffImageData((short)(rowIndex - this.minRowIndex), 0, (short)(columnIndex - 1), 0, (short)(rowIndex - (this.minRowIndex - 1) + cell.getHeight()), 0, (short)(columnIndex + cell.getWidth()), 0, bytes);
                            this.imageList.add(imageData);
                        }
                    }
                    boolean isExcelText = false;
                    if (cell.getComponent() != null && cell.getComponent().getTagValue() != null) {
                        String cellTag = cell.getComponent().getTagValue().toLowerCase();
                        isExcelText = cellTag.contains("exceltext");
                    }
                    String inputFormat = "";
                    if (textComp != null) {
                        inputFormat = textComp.getFormat();
                    }
                    boolean isFormatCurrency = false;
                    boolean isFormatNumeric = false;
                    boolean isFormatPercent = false;
                    boolean isFormatDate = false;
                    boolean isFormatTime = false;
                    boolean isDefaultFormat = false;
                    String outputFormat = "";
                    int decimalDigits = 2;
                    int groupDigits = 0;
                    String currencySymbol = "$";
                    boolean currencyPositionBefore = false;
                    boolean negativeBraces = false;
                    if (inputFormat != null && inputFormat.length() > 0) {
                        if (inputFormat.charAt(0) == 'C') {
                            isFormatCurrency = true;
                        }
                        if (inputFormat.charAt(0) == 'N') {
                            isFormatNumeric = true;
                        }
                        if (inputFormat.charAt(0) == 'P') {
                            isFormatPercent = true;
                        }
                        if (inputFormat.charAt(0) == 'D') {
                            isFormatDate = true;
                        }
                        if (inputFormat.charAt(0) == 'T') {
                            isFormatTime = true;
                        }
                        if (inputFormat.length() == 1) {
                            isDefaultFormat = true;
                        } else if (isFormatCurrency || isFormatNumeric || isFormatPercent) {
                            int indexPos = 1;
                            if (Character.isDigit(inputFormat.charAt(indexPos))) {
                                StringBuilder decimalSB = new StringBuilder();
                                while (indexPos < inputFormat.length() && Character.isDigit(inputFormat.charAt(indexPos))) {
                                    decimalSB.append(inputFormat.charAt(indexPos));
                                    ++indexPos;
                                }
                                decimalDigits = Integer.parseInt(decimalSB.toString());
                            }
                            if (indexPos < inputFormat.length() && inputFormat.charAt(indexPos) == 'G') {
                                ++indexPos;
                                groupDigits = 3;
                            }
                            if (indexPos < inputFormat.length() && inputFormat.charAt(indexPos) == '(') {
                                ++indexPos;
                                negativeBraces = true;
                            }
                            if (indexPos < inputFormat.length() && (inputFormat.charAt(indexPos) == '+' || inputFormat.charAt(indexPos) == '-')) {
                                if (inputFormat.charAt(indexPos) == '+') {
                                    currencyPositionBefore = true;
                                }
                                if (++indexPos < inputFormat.length()) {
                                    currencySymbol = inputFormat.substring(indexPos);
                                }
                            }
                        }
                    }
                    if (!(isFormatCurrency || isFormatNumeric || isFormatPercent)) {
                        isDefaultFormat = true;
                    }
                    if (textComp != null && textComp.getHideZeros() && inputFormat != null && inputFormat.length() > 0) {
                        isDefaultFormat = false;
                    }
                    if (isExcelText) {
                        isDefaultFormat = true;
                    }
                    if (!isDefaultFormat) {
                        StringBuilder outputSB = new StringBuilder();
                        if (isFormatCurrency && currencyPositionBefore) {
                            outputSB.append("\"");
                            outputSB.append(currencySymbol);
                            outputSB.append("\"");
                        }
                        if (groupDigits > 1) {
                            outputSB.append("#,");
                            outputSB.append(StiStringUtil.repeatString((String)"#", (int)(groupDigits - 1)));
                        }
                        outputSB.append('0');
                        if (decimalDigits > 0) {
                            outputSB.append(".");
                            outputSB.append(StiStringUtil.repeatString((String)"0", (int)decimalDigits));
                        }
                        if (isFormatCurrency && !currencyPositionBefore) {
                            outputSB.append("\"");
                            outputSB.append(currencySymbol);
                            outputSB.append("\"");
                        }
                        if (isFormatPercent) {
                            outputSB.append("%");
                        }
                        outputFormat = outputSB.toString();
                        String negativePattern = (negativeBraces ? "(" : "-") + outputFormat + (negativeBraces ? ")" : "");
                        if (textComp != null && textComp.getHideZeros()) {
                            outputFormat = outputFormat + ";" + negativePattern + ";";
                        } else if (negativeBraces) {
                            outputFormat = outputFormat + ";" + negativePattern;
                        }
                    }
                    int formatIndex = 0;
                    if (isDefaultFormat) {
                        if (isFormatNumeric) {
                            formatIndex = 4;
                        }
                        if (isFormatCurrency) {
                            formatIndex = 7;
                        }
                        if (isFormatPercent) {
                            formatIndex = 10;
                        }
                        if (isFormatDate) {
                            formatIndex = 14;
                        }
                        if (isFormatTime) {
                            formatIndex = 21;
                        }
                        if (isExcelText) {
                            formatIndex = 49;
                        }
                    } else {
                        formatIndex = this.getFormatNumber(outputFormat);
                    }
                    StiCellStyle style = cell.getCellStyle();
                    DataFont tempFont = new DataFont(style.getFont().getName(), style.getFont().bold(), style.getFont().italic(), style.getFont().underline(), style.getFont().strikeout(), (int)(style.getFont().getSize() * 20.0), this.getColorNumber(style.getTextColor()), 1);
                    if (hasCheckBoxExcelDataValue) {
                        tempFont = new DataFont(ExportOptions.StiCheckBoxExcelValueParameters.getFont().getName(), ExportOptions.StiCheckBoxExcelValueParameters.getFont().bold(), ExportOptions.StiCheckBoxExcelValueParameters.getFont().italic(), ExportOptions.StiCheckBoxExcelValueParameters.getFont().underline(), ExportOptions.StiCheckBoxExcelValueParameters.getFont().strikeout(), (int)(ExportOptions.StiCheckBoxExcelValueParameters.getFont().getSize() * 20.0), this.getColorNumber(style.getTextColor()), 1);
                    }
                    boolean rightToLeft = false;
                    if (style.getTextOptions() != null) {
                        rightToLeft = style.getTextOptions().getRightToLeft();
                    }
                    switch (hasCheckBoxExcelDataValue ? ExportOptions.StiCheckBoxExcelValueParameters.getHorAlignment() : style.getHorAlignment()) {
                        case Left: {
                            HorAlign = !rightToLeft ? 1 : 3;
                            break;
                        }
                        case Right: {
                            HorAlign = rightToLeft ? 1 : 3;
                            break;
                        }
                        case Center: {
                            HorAlign = 2;
                            break;
                        }
                        case Width: {
                            HorAlign = 7;
                            break;
                        }
                        default: {
                            HorAlign = 0;
                        }
                    }
                    switch (hasCheckBoxExcelDataValue ? ExportOptions.StiCheckBoxExcelValueParameters.getVertAlignment() : style.getVertAlignment()) {
                        case Top: {
                            VertAlign = 0;
                            break;
                        }
                        case Center: {
                            VertAlign = 1;
                            break;
                        }
                        case Bottom: {
                            VertAlign = 2;
                            break;
                        }
                        default: {
                            VertAlign = 0;
                        }
                    }
                    int textWordWrap = 0;
                    boolean tempWordWrap = false;
                    if (style.getTextOptions() != null) {
                        tempWordWrap = style.getTextOptions().getWordWrap();
                    }
                    if (str != null && str.length() > 0 && (str.indexOf("\r") != -1 || str.indexOf("\n") != -1)) {
                        tempWordWrap = true;
                    }
                    if (tempWordWrap) {
                        textWordWrap = 1;
                    }
                    int rotationAngle = 0;
                    if (style.getTextOptions() != null) {
                        int tempAngle = (int)style.getTextOptions().getAngle();
                        if (tempAngle >= 0 && tempAngle <= 90) {
                            rotationAngle = tempAngle;
                        }
                        if (tempAngle >= 270 && tempAngle < 360) {
                            rotationAngle = 360 - tempAngle + 90;
                        }
                    }
                    boolean needBorderLeft = true;
                    boolean needBorderRight = true;
                    for (int index = 0; index < cell.getHeight() + 1; ++index) {
                        if (this.matrix.getBordersY()[cell.getTop() + index][cell.getLeft()] == null) {
                            needBorderLeft = false;
                        }
                        if (this.matrix.getBordersY()[cell.getTop() + index][cell.getLeft() + cell.getWidth() + 1] != null) continue;
                        needBorderRight = false;
                    }
                    boolean needBorderTop = true;
                    boolean needBorderBottom = true;
                    for (int index = 0; index < cell.getWidth() + 1; ++index) {
                        if (this.matrix.getBordersX()[cell.getTop()][cell.getLeft() + index] == null) {
                            needBorderTop = false;
                        }
                        if (this.matrix.getBordersX()[cell.getTop() + cell.getHeight() + 1][cell.getLeft() + index] != null) continue;
                        needBorderBottom = false;
                    }
                    tempXF = new DataXF(this.getFontNumber(tempFont), formatIndex, 0, 0, HorAlign, VertAlign, textWordWrap, rotationAngle, rightToLeft ? 2 : 1, 63, this.getLineStyle(needBorderLeft ? this.matrix.getBordersY()[rowIndex - 1][columnIndex - 1] : null), this.getLineStyle(needBorderRight ? this.matrix.getBordersY()[rowIndex - 1][columnIndex - 1 + cell.getWidth() + 1] : null), this.getLineStyle(needBorderTop ? this.matrix.getBordersX()[rowIndex - 1][columnIndex - 1] : null), this.getLineStyle(needBorderBottom ? this.matrix.getBordersX()[rowIndex - 1 + cell.getHeight() + 1][columnIndex - 1] : null), needBorderLeft ? this.getColorNumber(this.matrix.getBordersY()[rowIndex - 1][columnIndex - 1].getColor()) : 0, needBorderRight ? this.getColorNumber(this.matrix.getBordersY()[rowIndex - 1][columnIndex - 1 + cell.getWidth() + 1].getColor()) : 0, needBorderTop ? this.getColorNumber(this.matrix.getBordersX()[rowIndex - 1][columnIndex - 1].getColor()) : 0, needBorderBottom ? this.getColorNumber(this.matrix.getBordersX()[rowIndex - 1 + cell.getHeight() + 1][columnIndex - 1].getColor()) : 0, style.getColor().getA() != 0 && !style.getColor().equals(StiColorEnum.White.color()) ? 1 : 0, this.getColorNumber(style.getColor()), this.getColorNumber(style.getColor()));
                    int indexStyle = this.getXFNumber(tempXF);
                    if (!this.exportObjectFormatting) {
                        indexStyle = 15;
                    }
                    if (this.exportObjectFormatting) {
                        for (int xx = 0; xx <= cell.getWidth(); ++xx) {
                            for (int yy = 0; yy <= cell.getHeight(); ++yy) {
                                readyCells[rowIndex - 1 + yy][columnIndex - 1 + xx] = true;
                                mergedCellsStyle[rowIndex + yy][columnIndex + xx] = indexStyle;
                            }
                        }
                        mergedCellsStyle[rowIndex][columnIndex] = 0;
                        if (cell.getWidth() > 0 || cell.getHeight() > 0) {
                            tempCellRange = new CellRangeAddress(rowIndex - this.minRowIndex, rowIndex + cell.getHeight() - this.minRowIndex, columnIndex - 1, columnIndex + cell.getWidth() - 1);
                            mergedCells.add(tempCellRange);
                        }
                    } else {
                        readyCells[rowIndex - 1][columnIndex - 1] = true;
                        mergedCellsStyle[rowIndex][columnIndex] = 0;
                    }
                    if (!cell.getComponent().isExportAsImage(StiExportFormat.Excel) && (str != null && str.length() > 0 || textComp != null && textComp.getExcelDataValue() != null && !"-".equals(textComp.getExcelDataValue()))) {
                        boolean isNumber = false;
                        double Number2 = 0.0;
                        if (textComp != null && textComp.getExcelDataValue() != null && !"-".equals(textComp.getExcelDataValue())) {
                            String value = textComp.getExcelDataValue();
                            String value2 = value.replace(',', '.');
                            if (value2 != null && value2.length() > 0) {
                                isNumber = true;
                                try {
                                    if (isFormatDate || isFormatTime) {
                                        if (ExportOptions.Excel.getAllowExportDateTime()) {
                                            DateFormat dateFormat = DateFormat.getDateTimeInstance();
                                            dateFormat.setLenient(false);
                                            Date date = dateFormat.parse(value);
                                            SimpleDateFormat sdf = new SimpleDateFormat(((SimpleDateFormat)dateFormat).toPattern());
                                            if (sdf.format(date).trim().equals(value.trim())) {
                                                double days = (double)((date.getTime() + 3600000L + 2208972528000L) / 86400000L) + 2.0;
                                                Calendar calendar = Calendar.getInstance();
                                                calendar.setTime(date);
                                                double seconds = (double)(calendar.get(11) * 60 * 60 + calendar.get(12) * 60 + calendar.get(13)) / 86400.0;
                                                Number2 = days + seconds;
                                            } else {
                                                isNumber = false;
                                            }
                                        } else {
                                            isNumber = false;
                                        }
                                    } else {
                                        Number2 = Double.parseDouble(value2);
                                    }
                                }
                                catch (Exception e) {
                                    isNumber = false;
                                }
                            }
                            if (!isNumber && str == null) {
                                str = value;
                            }
                        }
                        if (isNumber) {
                            this.dwShort(0, (short)(rowIndex - this.minRowIndex));
                            this.dwShort(2, (short)(columnIndex - 1));
                            this.dwShort(4, (short)indexStyle);
                            this.dwDouble(6, Number2);
                            this.addRec(515, 14);
                            continue;
                        }
                        String strs = str.replaceAll("\\r", "").replace('\t', ' ');
                        if (ExportOptions.Excel.getTrimTrailingSpaces()) {
                            strs = StiExportUtils.trimEndWhiteSpace(strs);
                        }
                        int indexSST = this.getSSTNumber(strs);
                        this.dwFill(0, 0, 10);
                        this.dwShort(0, (short)(rowIndex - this.minRowIndex));
                        this.dwShort(2, (short)(columnIndex - 1));
                        this.dwShort(4, (short)indexStyle);
                        this.dwInt(6, indexSST);
                        this.addRec(253, 10);
                        continue;
                    }
                    this.dwFill(0, 0, 6);
                    this.dwShort(0, (short)(rowIndex - this.minRowIndex));
                    this.dwShort(2, (short)(columnIndex - 1));
                    this.dwShort(4, (short)indexStyle);
                    this.addRec(513, 6);
                    continue;
                }
                if (mergedCellsStyle[rowIndex][columnIndex] != 0) {
                    int indexStyle = mergedCellsStyle[rowIndex][columnIndex];
                    this.dwFill(0, 0, 6);
                    this.dwShort(0, (short)(rowIndex - this.minRowIndex));
                    this.dwShort(2, (short)(columnIndex - 1));
                    this.dwShort(4, (short)indexStyle);
                    this.addRec(513, 6);
                    continue;
                }
                boolean needBorderLeft = true;
                boolean needBorderRight = true;
                boolean needBorderTop = true;
                boolean needBorderBottom = true;
                if (this.matrix.getBordersY()[rowIndex - 1][columnIndex - 1] == null) {
                    needBorderLeft = false;
                }
                if (this.matrix.getBordersY()[rowIndex - 1][columnIndex - 0] == null) {
                    needBorderRight = false;
                }
                if (this.matrix.getBordersX()[rowIndex - 1][columnIndex - 1] == null) {
                    needBorderTop = false;
                }
                if (this.matrix.getBordersX()[rowIndex - 0][columnIndex - 1] == null) {
                    needBorderBottom = false;
                }
                if (!needBorderLeft && !needBorderRight && !needBorderTop && !needBorderBottom) continue;
                tempXF = new DataXF(0, 0, 0, 0, 0, 0, 0, 0, 0, 63, this.getLineStyle(needBorderLeft ? this.matrix.getBordersY()[rowIndex - 1][columnIndex - 1] : null), this.getLineStyle(needBorderRight ? this.matrix.getBordersY()[rowIndex - 1][columnIndex - 0] : null), this.getLineStyle(needBorderTop ? this.matrix.getBordersX()[rowIndex - 1][columnIndex - 1] : null), this.getLineStyle(needBorderBottom ? this.matrix.getBordersX()[rowIndex - 0][columnIndex - 1] : null), needBorderLeft ? this.getColorNumber(this.matrix.getBordersY()[rowIndex - 1][columnIndex - 1].getColor()) : 0, needBorderRight ? this.getColorNumber(this.matrix.getBordersY()[rowIndex - 1][columnIndex - 0].getColor()) : 0, needBorderTop ? this.getColorNumber(this.matrix.getBordersX()[rowIndex - 1][columnIndex - 1].getColor()) : 0, needBorderBottom ? this.getColorNumber(this.matrix.getBordersX()[rowIndex - 0][columnIndex - 1].getColor()) : 0, 0, 0, 0);
                int indexStyle = this.getXFNumber(tempXF);
                if (!this.exportObjectFormatting) {
                    indexStyle = 15;
                }
                this.dwFill(0, 0, 6);
                this.dwShort(0, (short)(rowIndex - this.minRowIndex));
                this.dwShort(2, (short)(columnIndex - 1));
                this.dwShort(4, (short)indexStyle);
                this.addRec(513, 6);
            }
        }
        if (mergedCells.size() > 0 && (!this.exportDataOnly || this.exportObjectFormatting)) {
            pos = 0;
            for (int index = 0; index < mergedCells.size(); ++index) {
                if (pos >= 1027) {
                    this.dwShort(0, (short)pos);
                    this.addRec(229, pos * 8 + 2);
                    pos = 0;
                }
                tempCellRange = (CellRangeAddress)mergedCells.get(index);
                this.dwShort(2 + pos * 8 + 0, (short)tempCellRange.FirstRow);
                this.dwShort(2 + pos * 8 + 2, (short)tempCellRange.LastRow);
                this.dwShort(2 + pos * 8 + 4, (short)tempCellRange.FirstColumn);
                this.dwShort(2 + pos * 8 + 6, (short)tempCellRange.LastColumn);
                ++pos;
            }
            this.dwShort(0, (short)pos);
            this.addRec(229, pos * 8 + 2);
        }
        this.escher.writeDG(this.imageList, startImageIndex);
        pos = 0;
        int[] srcArr = StiExcelExportService.toIntArray(this.escher.mem.toByteArray());
        for (int index = startImageIndex; index < this.imageList.size(); ++index) {
            int recordLength = this.escher.memBookmarks[index + 1 - startImageIndex] - this.escher.memBookmarks[index - startImageIndex];
            System.arraycopy(srcArr, pos, this.bfData, 0, recordLength);
            pos += recordLength;
            this.addRec(236, recordLength);
            this.dwShort(0, 21);
            this.dwShort(2, 18);
            this.dwShort(4, 8);
            this.dwShort(6, (short)(index + 1));
            this.dwShort(8, 24593);
            this.dwInt(10, 0);
            this.dwInt(14, 0);
            this.dwInt(18, 0);
            this.dwShort(22, 7);
            this.dwShort(24, 2);
            this.dwShort(26, -1);
            this.dwShort(28, 8);
            this.dwShort(30, 2);
            this.dwShort(32, 0);
            this.dwShort(34, 0);
            this.dwShort(36, 0);
            this.addRec(93, 38);
        }
        this.escher.mem.close();
        int window2OptionFlags = 1716;
        if (ExportOptions.Excel.getColumnsRightToLeft()) {
            window2OptionFlags = (short)(window2OptionFlags | 0x40);
        }
        if (ExportOptions.Excel.getShowGridLines()) {
            window2OptionFlags = (short)(window2OptionFlags | 2);
        }
        this.dwFill(0, 0, 18);
        this.dwShort(0, window2OptionFlags);
        this.dwShort(2, 0);
        this.dwShort(4, 0);
        this.dwShort(6, 64);
        this.dwShort(8, 0);
        this.dwShort(10, 0);
        this.dwShort(12, 0);
        this.addRec(574, 18);
        this.dwByte(0, 3);
        this.dwShort(1, 0);
        this.dwShort(3, 0);
        this.dwShort(5, 0);
        this.dwShort(7, 1);
        this.dwShort(9, 0);
        this.dwShort(11, 0);
        this.dwByte(13, 0);
        this.dwByte(14, 0);
        this.addRec(29, 15);
        if (hlinks.size() > 0) {
            for (int indexLink = 0; indexLink < hlinks.size(); ++indexLink) {
                int[] buf = (int[])hlinks.get(indexLink);
                System.arraycopy(buf, 0, this.bfData, 0, buf.length);
                this.addRec(440, buf.length);
            }
        }
        if (this.maxRowIndex < this.matrix.getCoordY().size()) {
            String[][] tempBookmark = new String[this.maxRowIndex - this.minRowIndex][this.matrix.getCoordX().size()];
            System.arraycopy(this.matrix.getBookmarks(), this.minRowIndex, tempBookmark, 0, this.maxRowIndex - this.minRowIndex);
            this.bookmarksList.add(tempBookmark);
        } else {
            this.bookmarksList.add(this.matrix.getBookmarks());
        }
        this.hlinksList.add(hlinkLocal);
        StiSize printArea = new StiSize(this.matrix.getCoordX().size() - 2, this.maxRowIndex - this.minRowIndex - 1);
        if (this.matrix.getCoordY().size() > this.maxRowIndex) {
            this.minRowIndex = this.maxRowIndex;
        } else {
            this.matrix = null;
        }
        return printArea;
    }

    private void makeMainStream(StiReport report, StiPagesCollection allPages) throws IOException {
        int index;
        int index2;
        int lenRec = 0;
        ArrayList<StiSize> printAreasList = new ArrayList<StiSize>();
        for (int indexPage = 0; indexPage < allPages.size(); ++indexPage) {
            String sheetName;
            StiPagesCollection pages = new StiPagesCollection(report);
            pages.addV2Internal(allPages.getPageWithoutCache(indexPage));
            if (!this.exportEachPageToSheet) {
                String pageName = allPages.getPageWithoutCache(indexPage).getExcelSheetValue();
                while (indexPage < allPages.size() - 1 && this.compareExcellSheetNames(allPages.getPageWithoutCache(indexPage + 1).getExcelSheetValue(), pageName)) {
                    pages.addV2Internal(allPages.getPageWithoutCache(++indexPage));
                }
            }
            if ((sheetName = pages.get(0).getExcelSheetValue()) == null || "".equals(sheetName)) {
                sheetName = String.format("Page %s", this.boundsheetsNamesList.size() + 1);
            }
            String sheetSuffix = "";
            int sheetIndex = 1;
            do {
                this.memst = new StiByteArrayOutputStream();
                printAreasList.add(this.makeWorksheetStream(pages));
                if (this.isStoped()) {
                    return;
                }
                this.pagesList.add((ByteArrayOutputStream)this.memst);
                if (this.matrix != null || sheetSuffix.length() > 0) {
                    sheetSuffix = String.format(" part%s", sheetIndex++);
                }
                this.boundsheetsNamesList.add(sheetName + sheetSuffix);
            } while (this.matrix != null);
        }
        Hashtable<String, String> ht = new Hashtable<String, String>();
        for (index2 = 0; index2 < this.boundsheetsNamesList.size(); ++index2) {
            String titleString = this.boundsheetsNamesList.remove(index2);
            if (ht.contains(titleString = titleString.replace('*', '_').replace('\\', '_').replace('/', '_').replace('[', '_').replace(']', '_').replace(':', '_').replace('?', '_'))) {
                Integer numVariant = 1;
                while (ht.contains(titleString + "-" + numVariant.toString())) {
                    Integer n = numVariant;
                    Integer n2 = numVariant = Integer.valueOf(numVariant + 1);
                }
                titleString = titleString + "-" + numVariant.toString();
            }
            ht.put(titleString, titleString);
            this.boundsheetsNamesList.add(index2, titleString);
        }
        this.memst = new StiByteArrayOutputStream();
        this.dwFill(0, 0, 16);
        this.dwShort(0, 1536);
        this.dwShort(2, 5);
        this.dwShort(4, 6301);
        this.dwShort(6, 1997);
        this.dwInt(8, 32969);
        this.dwInt(12, 518);
        this.addRec(2057, 16);
        this.dwFill(0, 32, 128);
        lenRec = this.dwString(0, StiStringUtil.repeatString((String)" ", (int)34) + StiExportUtils.getReportVersion(), 2, lenRec, true);
        this.addRec(92, 112);
        this.dwShort(0, 1200);
        this.addRec(66, 2);
        this.dwShort(0, 0);
        this.addRec(353, 2);
        this.dwShort(0, 0);
        this.addRec(25, 2);
        this.dwShort(0, 0);
        this.addRec(18, 2);
        this.dwShort(0, 0);
        this.addRec(19, 2);
        this.dwShort(0, 480);
        this.dwShort(2, 30);
        this.dwShort(4, 14235);
        this.dwShort(6, 8700);
        this.dwShort(8, 56);
        this.dwShort(10, 0);
        this.dwShort(12, 0);
        this.dwShort(14, 1);
        this.dwShort(16, 600);
        this.addRec(61, 18);
        this.dwShort(0, 0);
        this.addRec(64, 2);
        this.dwShort(0, 0);
        this.addRec(141, 2);
        this.dwShort(0, 0);
        this.addRec(34, 2);
        this.dwShort(0, 1);
        this.addRec(14, 2);
        this.dwShort(0, 0);
        this.addRec(218, 2);
        for (index2 = 0; index2 < this.fontList.size(); ++index2) {
            DataFont dFont = this.fontList.get(index2);
            this.dwFill(0, 0, 14);
            this.dwShort(0, (short)dFont.Height);
            int styleFlags = 0;
            if (dFont.Italic) {
                styleFlags |= 2;
            }
            if (dFont.Strikeout) {
                styleFlags |= 8;
            }
            this.dwShort(2, (short)styleFlags);
            this.dwShort(4, (short)dFont.Color);
            if (dFont.Bold) {
                this.dwShort(6, 700);
            } else {
                this.dwShort(6, 400);
            }
            this.dwShort(8, 0);
            if (dFont.Underlined) {
                this.dwByte(10, 1);
            } else {
                this.dwByte(10, 0);
            }
            this.dwByte(11, 0);
            this.dwByte(12, (byte)dFont.Charset);
            lenRec = this.dwString(14, dFont.Name, 1, lenRec, false);
            this.addRec(49, lenRec);
        }
        if (this.formatList.size() > 0) {
            for (int indexFormat = 0; indexFormat < this.formatList.size(); ++indexFormat) {
                this.dwShort(0, (short)(indexFormat + 164));
                lenRec = this.dwString(2, this.formatList.get(indexFormat), 2, lenRec, false);
                this.addRec(1054, lenRec);
            }
        }
        for (index2 = 0; index2 < this.xfList.size(); ++index2) {
            DataXF tempXF = this.xfList.get(index2);
            this.dwFill(0, 0, 20);
            this.dwShort(0, (short)tempXF.FontIndex);
            this.dwShort(2, (short)tempXF.FormatIndex);
            int tempValue = tempXF.XFType << 2 & 4 | tempXF.ParentStyleXF << 4 & 0xFFF0;
            this.dwShort(4, (short)(tempValue | 1));
            tempValue = tempXF.HorAlign | tempXF.TextWrapped << 3 & 8 | tempXF.VertAlign << 4 & 0x70;
            this.dwByte(6, (byte)tempValue);
            this.dwByte(7, (byte)tempXF.TextRotationAngle);
            this.dwByte(8, (byte)(tempXF.TextDirection << 6));
            this.dwByte(9, (byte)(tempXF.UsedAttrib << 2));
            tempValue = tempXF.LineStyleLeft & 0xF | tempXF.LineStyleRight << 4 & 0xF0 | tempXF.LineStyleTop << 8 & 0xF00 | tempXF.LineStyleBottom << 12 & 0xF000 | tempXF.ColorIndexLeft << 16 & 0x7F0000 | tempXF.ColorIndexRight << 23 & 0x3F800000;
            this.dwInt(10, tempValue);
            tempValue = tempXF.ColorIndexTop & 0x7F | tempXF.ColorIndexBottom << 7 & 0x3F80 | tempXF.FillPatern << 26 & 0xFC000000;
            this.dwInt(14, tempValue);
            tempValue = tempXF.ColorIndexPattern & 0x7F | tempXF.ColorIndexBackground << 7 & 0x3F80;
            this.dwShort(18, (short)tempValue);
            this.addRec(224, 20);
        }
        this.dwInt(0, 32784);
        this.dwByte(2, 4);
        this.dwByte(3, 255);
        this.addRec(659, 4);
        this.dwInt(0, 32785);
        this.dwByte(2, 7);
        this.dwByte(3, 255);
        this.addRec(659, 4);
        this.dwInt(0, 32768);
        this.dwByte(2, 0);
        this.dwByte(3, 255);
        this.addRec(659, 4);
        this.dwInt(0, 32786);
        this.dwByte(2, 5);
        this.dwByte(3, 255);
        this.addRec(659, 4);
        this.dwInt(0, 32787);
        this.dwByte(2, 3);
        this.dwByte(3, 255);
        this.addRec(659, 4);
        this.dwInt(0, 32788);
        this.dwByte(2, 6);
        this.dwByte(3, 255);
        this.addRec(659, 4);
        if (this.colorList.size() > 0) {
            int paletteCount = this.colorList.size();
            if (paletteCount > 56) {
                paletteCount = 56;
            }
            this.dwShort(0, (short)paletteCount);
            for (int index3 = 0; index3 < paletteCount; ++index3) {
                StiColor tempColor = this.colorList.get(index3);
                this.dwByte(2 + index3 * 4 + 0, tempColor.getR());
                this.dwByte(2 + index3 * 4 + 1, tempColor.getG());
                this.dwByte(2 + index3 * 4 + 2, tempColor.getB());
                this.dwByte(2 + index3 * 4 + 3, 0);
            }
            this.addRec(146, 2 + paletteCount * 4);
        }
        this.dwShort(0, 0);
        this.addRec(352, 2);
        for (index2 = 0; index2 < this.pagesList.size(); ++index2) {
            String titleString = this.boundsheetsNamesList.get(index2);
            Integer boundsheetOffset = this.memst.size() + 4;
            this.boundsheetsOffsetsList.add(boundsheetOffset);
            this.dwInt(0, 0);
            this.dwByte(4, 0);
            this.dwByte(5, 0);
            lenRec = this.dwString(6, titleString, 1, lenRec, false);
            this.addRec(133, lenRec);
        }
        this.dwShort(0, (short)this.pagesList.size());
        this.dwShort(2, 1025);
        this.addRec(430, 4);
        this.dwShort(0, (short)this.pagesList.size());
        for (index2 = 0; index2 < this.pagesList.size(); ++index2) {
            this.dwShort(2 + index2 * 6, 0);
            this.dwShort(4 + index2 * 6, (short)index2);
            this.dwShort(6 + index2 * 6, (short)index2);
        }
        this.addRec(23, 2 + this.pagesList.size() * 6);
        for (index2 = 0; index2 < this.pagesList.size(); ++index2) {
            StiSize area = (StiSize)printAreasList.get(index2);
            if (area.getHeight() > 65535.0) {
                area.setHeight(65535.0);
            }
            if (area.getWidth() > 255.0) {
                area.setWidth(255.0);
            }
            this.dwShort(0, 32);
            this.dwByte(2, 0);
            this.dwByte(3, 1);
            this.dwShort(4, 11);
            this.dwShort(6, 0);
            this.dwShort(8, (short)(index2 + 1));
            this.dwByte(10, 0);
            this.dwByte(11, 0);
            this.dwByte(12, 0);
            this.dwByte(13, 0);
            this.dwByte(14, 0);
            this.dwByte(15, 6);
            this.dwByte(16, 59);
            this.dwShort(17, (short)index2);
            this.dwShort(19, 0);
            this.dwShort(21, (short)area.getHeight());
            this.dwShort(23, 0);
            this.dwShort(25, (short)area.getWidth());
            this.addRec(24, 27);
        }
        this.escher.writeDGG(this.imageList);
        int posMem = 0;
        int tempDGGCommand = 235;
        int[] srcArr = StiExcelExportService.toIntArray(this.escher.mem.toByteArray());
        while (posMem + 8224 < this.escher.mem.size()) {
            System.arraycopy(srcArr, posMem, this.bfData, 0, 8224);
            this.addRec(tempDGGCommand, 8224);
            tempDGGCommand = 60;
            posMem += 8224;
        }
        System.arraycopy(srcArr, posMem, this.bfData, 0, this.escher.mem.size() - posMem);
        this.addRec(tempDGGCommand, this.escher.mem.size() - posMem);
        this.escher.mem.close();
        this.dwInt(0, this.sstCounter);
        this.dwInt(4, this.sstList.size());
        int extSstPortionSize = this.sstList.size() / 1020 + 1;
        if (extSstPortionSize < 8) {
            extSstPortionSize = 8;
        }
        int extSstPos = 0;
        int extSstSize = this.sstList.size() / extSstPortionSize;
        if (this.sstList.size() % extSstPortionSize > 0) {
            ++extSstSize;
        }
        int[][] extSstTable = new int[extSstSize][2];
        int tempCommand = 252;
        int tempPos = 8;
        if (this.sstList.size() > 0) {
            for (index = 0; index < this.sstList.size(); ++index) {
                if (index % extSstPortionSize == 0) {
                    extSstTable[extSstPos][0] = this.memst.size() + tempPos + 4;
                    extSstTable[extSstPos][1] = tempPos + 4;
                    ++extSstPos;
                }
                String tempString = this.sstList.get(index);
                lenRec = this.dwString(tempPos, tempString, 2, lenRec, true);
                int flagByte = this.bfData[tempPos + 2];
                tempPos = lenRec;
                int recSize = 8192 + (tempPos & 1);
                while (tempPos > recSize) {
                    this.addRec(tempCommand, recSize);
                    this.bfData[0] = flagByte;
                    System.arraycopy(this.bfData, recSize, this.bfData, 1, tempPos);
                    recSize = 8192 + ((tempPos -= recSize - 1) & 1);
                    tempCommand = 60;
                }
                if (tempPos <= recSize - 10) continue;
                this.addRec(tempCommand, tempPos);
                tempCommand = 60;
                tempPos = 0;
            }
        }
        if (tempPos != 0) {
            this.addRec(tempCommand, tempPos);
        }
        this.dwShort(0, (short)extSstPortionSize);
        tempPos = 2;
        if (this.sstList.size() > 0) {
            for (index = 0; index < extSstSize; ++index) {
                this.dwInt(tempPos + 0, extSstTable[index][0]);
                this.dwInt(tempPos + 4, extSstTable[index][1]);
                this.dwShort(tempPos + 6, 0);
                tempPos += 8;
            }
        }
        this.addRec(255, tempPos);
        this.addRec(10, 0);
        for (index = 0; index < this.pagesList.size(); ++index) {
            int temppos = this.memst.size();
            this.dwInt(0, temppos);
            this.memst.writeOffset(this.boundsheetsOffsetsList.get(index).intValue(), this.bfData, 0, 4);
            ByteArrayOutputStream memst2 = this.pagesList.get(index);
            memst2.writeTo((OutputStream)this.memst);
            memst2.close();
            ArrayList<HlinkData> hlinks = this.hlinksList.get(index);
            for (int indexHlink = 0; indexHlink < hlinks.size(); ++indexHlink) {
                int indexChar;
                HlinkData hl = hlinks.get(indexHlink);
                String hyperlink = hl.Bookmark;
                boolean isFounded = false;
                for (int indexSheet = 0; indexSheet < this.bookmarksList.size(); ++indexSheet) {
                    String[][] bookmarks = this.bookmarksList.get(indexSheet);
                    int sizeRow = bookmarks.length;
                    int sizeColumn = bookmarks[1].length;
                    for (int indexRow = 0; indexRow < sizeRow; ++indexRow) {
                        for (int indexColumn = 0; indexColumn < sizeColumn; ++indexColumn) {
                            if (!StiStringUtil.stringsEquals((String)bookmarks[indexRow][indexColumn], (String)hyperlink)) continue;
                            hyperlink = String.format("'%s'!%s", this.boundsheetsNamesList.get(indexSheet), this.getRefString(indexColumn, indexRow));
                            isFounded = true;
                            break;
                        }
                        if (isFounded) break;
                    }
                    if (isFounded) break;
                }
                if (!isFounded) continue;
                this.dwShort(0, (short)hl.Range.FirstRow);
                this.dwShort(2, (short)hl.Range.LastRow);
                this.dwShort(4, (short)hl.Range.FirstColumn);
                this.dwShort(6, (short)hl.Range.LastColumn);
                this.dwByte(8, 208, 201, 234, 121);
                this.dwByte(12, 249, 186, 206, 17);
                this.dwByte(16, 140, 130, 0, 170);
                this.dwByte(20, 0, 75, 169, 11);
                this.dwInt(24, 2);
                this.dwInt(28, 28);
                int hpos = 32;
                this.dwInt(hpos, hl.Description.length() + 1);
                hpos += 4;
                for (indexChar = 0; indexChar < hl.Description.length(); ++indexChar) {
                    this.dwShort(hpos, (short)hl.Description.charAt(indexChar));
                    hpos += 2;
                }
                this.dwShort(hpos, 0);
                this.dwInt(hpos += 2, hyperlink.length() + 1);
                hpos += 4;
                for (indexChar = 0; indexChar < hyperlink.length(); ++indexChar) {
                    this.dwShort(hpos, (short)hyperlink.charAt(indexChar));
                    hpos += 2;
                }
                this.dwShort(hpos, 0);
                this.addRec(440, hpos += 2);
            }
            this.addRec(10, 0);
        }
    }

    private void writeToOLEContainer() throws IOException {
        int index;
        int SatLenSecOld;
        int lenRec = 0;
        int DirLenSec = 1;
        int memLenSec = this.memst.size() / 512;
        if (this.memst.size() % 512 != 0) {
            ++memLenSec;
        }
        if (memLenSec < 8) {
            memLenSec = 8;
        }
        int SatLenSec = 0;
        int MSatLenSec = 0;
        do {
            SatLenSecOld = SatLenSec;
            if (SatLenSec >= 109) {
                MSatLenSec = (SatLenSec - 109) / 127;
                if ((SatLenSec - 109) % 127 != 0) {
                    ++MSatLenSec;
                }
            } else {
                MSatLenSec = 0;
            }
            SatLenSec = (memLenSec + DirLenSec + SatLenSecOld + MSatLenSec) / 128;
            if ((memLenSec + DirLenSec + SatLenSecOld + MSatLenSec) % 128 == 0) continue;
            ++SatLenSec;
        } while (SatLenSec != SatLenSecOld);
        this.memStMain = new StiByteArrayOutputStream();
        this.dwFill(0, 0, 512);
        this.dwByte(0, 208, 207, 17, 224);
        this.dwByte(4, 161, 177, 26, 225);
        this.dwShort(24, 62);
        this.dwShort(26, 3);
        this.dwShort(28, -2);
        this.dwShort(30, 9);
        this.dwShort(32, 6);
        this.dwInt(44, SatLenSec);
        this.dwInt(48, MSatLenSec + SatLenSec + memLenSec);
        this.dwInt(56, 4096);
        this.dwInt(60, -2);
        this.dwInt(64, 0);
        this.dwInt(68, MSatLenSec == 0 ? -2 : 0);
        this.dwInt(72, MSatLenSec);
        this.dwFill(76, 255, 436 + MSatLenSec * 512);
        int SatLenIndex = 0;
        int SatLenOffset = 0;
        while (SatLenIndex < SatLenSec) {
            if (SatLenOffset % 128 == 108 && SatLenOffset > 108) {
                this.dwInt(76 + SatLenOffset * 4, SatLenOffset / 128);
            } else {
                this.dwInt(76 + SatLenOffset * 4, MSatLenSec + SatLenIndex);
                ++SatLenIndex;
            }
            ++SatLenOffset;
        }
        if (MSatLenSec > 0) {
            this.dwInt(512 + MSatLenSec * 512 - 2, -2);
        }
        this.memStMain.write(this.bfData, 0, 512 + MSatLenSec * 512);
        this.dwFill(0, 255, SatLenSec * 512);
        for (index = 0; index < MSatLenSec; ++index) {
            this.dwInt(index * 4, -4);
        }
        for (index = 0; index < SatLenSec; ++index) {
            this.dwInt((MSatLenSec + index) * 4, -3);
        }
        for (index = 0; index < memLenSec; ++index) {
            this.dwInt((MSatLenSec + SatLenSec + index) * 4, MSatLenSec + SatLenSec + index + 1);
        }
        this.dwInt((MSatLenSec + SatLenSec + memLenSec - 1) * 4, -2);
        this.dwInt((MSatLenSec + SatLenSec + memLenSec) * 4, -2);
        this.memStMain.write(this.bfData, 0, SatLenSec * 512);
        int lenAppend = memLenSec * 512 - this.memst.size();
        this.memst.writeTo((OutputStream)this.memStMain);
        this.dwFill(0, 0, lenAppend);
        this.memStMain.write(this.bfData, 0, lenAppend);
        this.dwFill(0, 0, 512);
        lenRec = this.dwString(0, "Root Entry", 0, lenRec, false);
        this.dwShort(64, 22);
        this.dwByte(66, 5);
        this.dwByte(67, 1);
        this.dwInt(68, -1);
        this.dwInt(72, -1);
        this.dwInt(76, 1);
        this.dwInt(116, -2);
        this.dwInt(120, 0);
        lenRec = this.dwString(128, "Workbook", 0, lenRec, false);
        this.dwShort(192, 18);
        this.dwByte(194, 2);
        this.dwByte(195, 1);
        this.dwInt(196, -1);
        this.dwInt(200, -1);
        this.dwInt(204, -1);
        this.dwInt(244, MSatLenSec + SatLenSec);
        this.dwInt(248, memLenSec * 512);
        this.memStMain.write(this.bfData, 0, 512);
        this.memst.close();
    }

    @Override
    public void export(StiReport report, OutputStream outputStream, StiExportSettings exportSettings) throws StiException {
        this.exportExcel(report, outputStream, exportSettings);
    }

    public void exportExcel(StiReport report, OutputStream outputStream, StiExportSettings exportSettings) throws StiException {
        try {
            this.exportExcelException(report, outputStream, exportSettings);
        }
        catch (Exception e) {
            throw new StiException((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void exportExcelException(StiReport report, OutputStream outputStream, StiExportSettings exportSettings) throws FileNotFoundException, IOException {
        StiExcelExportSettings settings = (StiExcelExportSettings)exportSettings;
        if (settings == null) {
            throw new IllegalArgumentException("The 'settings' argument cannot be equal in null.");
        }
        StiPagesRange pageRange = settings.getPageRange();
        this.useOnePageHeaderAndFooter = settings.isUseOnePageHeaderAndFooter();
        this.exportDataOnly = settings.isExportDataOnly();
        this.exportObjectFormatting = settings.isExportObjectFormatting();
        this.exportEachPageToSheet = settings.isExportEachPageToSheet();
        this.exportHorizontalPageBreaks = settings.isExportPageBreaks();
        this.imageResolution = settings.getImageResolution();
        this.imageQuality = settings.getImageQuality();
        this.bfHeader = new byte[4];
        this.bfData = new int[262144];
        if (this.imageResolution < 10.0f) {
            this.imageResolution = 10.0f;
        }
        this.imageResolution /= 100.0f;
        this.maximumSheetHeight = ExportOptions.Excel.getMaximumSheetHeight();
        if (this.maximumSheetHeight < 1) {
            this.maximumSheetHeight = 1;
        }
        if (this.maximumSheetHeight > 65535) {
            this.maximumSheetHeight = 65535;
        }
        if (this.exportDataOnly) {
            this.useOnePageHeaderAndFooter = false;
        } else {
            this.exportObjectFormatting = true;
        }
        try {
            StiPagesCollection pages = pageRange.getSelectedPages(report.getRenderedPages());
            if (this.isStoped()) {
                return;
            }
            this.setStatusString(StiLocalization.getValue((String)"Export", (String)"ExportingCreatingDocument"));
            this.prepareData();
            this.makeMainStream(report, pages);
            this.writeToOLEContainer();
            this.memStMain.writeTo(outputStream);
            this.memStMain.close();
        }
        finally {
            if (this.matrix != null) {
                this.matrix.clear();
                this.matrix = null;
            }
            this.xfList = null;
            this.colorList = null;
            this.fontList = null;
            this.sstList = null;
            this.sstHash = null;
            this.formatList = null;
            if (this.memst != null) {
                this.memst.close();
            }
            this.memst = null;
            if (this.memStMain != null) {
                this.memStMain.close();
            }
            this.memStMain = null;
            this.imageList = null;
            this.escher = null;
            this.pagesList = null;
            this.bookmarksList = null;
            this.hlinksList = null;
            this.boundsheetsOffsetsList = null;
            this.boundsheetsNamesList = null;
            this.closeProgress();
        }
    }

    public static int[] toIntArray(byte[] array) {
        int[] result = new int[array.length];
        for (int i = 0; i < array.length; ++i) {
            result[i] = array[i];
        }
        return result;
    }

    @Override
    public StiExportFormat getExportFormat() {
        return StiExportFormat.Excel;
    }

    @Override
    public boolean getMultipleFiles() {
        return false;
    }

    public static void setPercentScaleForFontHeightCorrection(byte value) {
        if (value >= 10) {
            percentScaleForFontHeightCorrection = value;
        }
    }

    private static double getHiToTwips() {
        return 1471.68 / (double)percentScaleForFontHeightCorrection;
    }

    public class Escher {
        public StiByteArrayOutputStream mem = new StiByteArrayOutputStream();
        public int[] memBookmarks = null;
        private int[] containerPos = new int[10];
        private int containerNum = 0;
        private byte[] buf = new byte[64];

        public void writeToStream(OutputStream stream) throws IOException {
            this.mem.writeTo(stream);
            this.mem.close();
            stream.flush();
        }

        private void dwByte(int position, int dataValue) {
            this.buf[position] = (byte)dataValue;
        }

        private void dwShort(int position, int dataValue) {
            this.buf[position + 0] = (byte)(dataValue & 0xFF);
            this.buf[position + 1] = (byte)(dataValue >> 8 & 0xFF);
        }

        private void dwInt(int position, int dataValue) {
            this.buf[position + 0] = (byte)(dataValue & 0xFF);
            this.buf[position + 1] = (byte)(dataValue >> 8 & 0xFF);
            this.buf[position + 2] = (byte)(dataValue >> 16 & 0xFF);
            this.buf[position + 3] = (byte)(dataValue >> 24 & 0xFF);
        }

        private void dwFill(int position, int dataValue, int count) {
            for (int index = 0; index < count; ++index) {
                this.buf[position + index] = (byte)dataValue;
            }
        }

        private void writeRecordHeader(int recordId, int ver, int inst) {
            short options = (short)(inst << 4 | ver & 0xF);
            this.dwShort(0, options);
            this.dwShort(2, recordId);
            this.dwInt(4, 0);
            this.mem.write(this.buf, 0, 8);
            this.containerPos[this.containerNum] = this.mem.size();
            ++this.containerNum;
        }

        private void closeRecord() {
            long endPos = this.mem.size();
            --this.containerNum;
            long beginPos = this.containerPos[this.containerNum];
            this.dwInt(0, (int)(endPos - beginPos));
            this.mem.writeOffset((int)(beginPos - 4L), this.buf, 0, 4);
        }

        public void writeDGG(ArrayList<BiffImageData> imageList) {
            this.mem = new StiByteArrayOutputStream();
            this.containerNum = 0;
            int imageCount = imageList.size();
            this.writeRecordHeader(61440, 15, 0);
            this.writeRecordHeader(61446, 0, 0);
            this.dwInt(0, 1024 + imageCount + 1024);
            this.dwInt(4, 2);
            this.dwInt(8, imageCount + 1);
            this.dwInt(12, 1);
            this.dwInt(16, 1);
            this.dwInt(20, imageCount + 1);
            this.mem.write(this.buf, 0, 24);
            this.closeRecord();
            this.writeRecordHeader(61441, 15, (short)imageCount);
            for (int index = 0; index < imageCount; ++index) {
                BiffImageData image = imageList.get(index);
                byte[] bufBLIP = image.ImageData;
                int checksum = (int)StiExportUtils.getAdler32Checksum(bufBLIP);
                this.writeRecordHeader(61447, 2, 5);
                this.dwByte(0, 5);
                this.dwByte(1, 5);
                this.dwFill(2, 0, 16);
                this.dwInt(2, checksum);
                this.dwInt(6, checksum);
                this.dwInt(10, checksum);
                this.dwInt(14, checksum);
                this.dwShort(18, 255);
                this.dwInt(20, bufBLIP.length + 25);
                this.dwInt(24, 1);
                this.dwInt(28, 0);
                this.dwByte(32, 0);
                this.dwByte(33, 0);
                this.dwByte(34, 0);
                this.dwByte(35, 0);
                this.mem.write(this.buf, 0, 36);
                this.writeRecordHeader(61469, 0, 1130);
                this.dwFill(0, 0, 16);
                this.dwInt(0, checksum);
                this.dwInt(4, checksum);
                this.dwInt(8, checksum);
                this.dwInt(12, checksum);
                this.dwByte(16, 255);
                this.mem.write(this.buf, 0, 17);
                this.mem.write(bufBLIP, 0, bufBLIP.length);
                this.closeRecord();
                this.closeRecord();
            }
            this.closeRecord();
            this.writeRecordHeader(61451, 3, 3);
            this.dwShort(0, 191);
            this.dwInt(2, 524296);
            this.dwShort(6, 385);
            this.dwInt(8, 134217793);
            this.dwShort(12, 448);
            this.dwInt(14, 0x8000040);
            this.mem.write(this.buf, 0, 18);
            this.closeRecord();
            this.writeRecordHeader(61726, 0, 4);
            this.dwInt(0, 0x800000D);
            this.dwInt(4, 0x800000C);
            this.dwInt(8, 134217751);
            this.dwInt(12, 268435703);
            this.mem.write(this.buf, 0, 16);
            this.closeRecord();
            this.closeRecord();
        }

        public void writeDG(ArrayList<BiffImageData> imageList, int startImageIndex) {
            this.mem = new StiByteArrayOutputStream();
            this.containerNum = 0;
            int imageCount = imageList.size() - startImageIndex;
            this.memBookmarks = new int[imageCount + 1];
            this.writeRecordHeader(61442, 15, 0);
            this.writeRecordHeader(61448, 0, 1);
            this.dwInt(0, imageCount + 1);
            this.dwInt(4, (short)(1024 + imageCount));
            this.mem.write(this.buf, 0, 8);
            this.closeRecord();
            this.writeRecordHeader(61443, 15, 0);
            this.writeRecordHeader(61444, 15, 0);
            this.writeRecordHeader(61449, 1, 0);
            this.dwFill(0, 0, 16);
            this.mem.write(this.buf, 0, 16);
            this.closeRecord();
            this.writeRecordHeader(61450, 2, 0);
            this.dwInt(0, 1024);
            this.dwInt(4, 5);
            this.mem.write(this.buf, 0, 8);
            this.closeRecord();
            this.closeRecord();
            for (int index = 0; index < imageCount; ++index) {
                this.memBookmarks[index] = this.mem.size();
                this.writeRecordHeader(61444, 15, 0);
                this.writeRecordHeader(61450, 2, 75);
                this.dwInt(0, (short)(1024 + startImageIndex + index + 1));
                this.dwInt(4, 2560);
                this.mem.write(this.buf, 0, 8);
                this.closeRecord();
                this.writeRecordHeader(61451, 3, 2);
                this.dwShort(0, 16644);
                this.dwInt(2, startImageIndex + index + 1);
                String st = String.format("graph%04x", startImageIndex + index + 1).toUpperCase() + '\u0000';
                this.dwShort(6, 49413);
                this.dwInt(8, st.length() * 2);
                for (int tempIndex = 0; tempIndex < st.length(); ++tempIndex) {
                    this.dwShort(12 + tempIndex * 2, (short)st.charAt(tempIndex));
                }
                this.mem.write(this.buf, 0, 12 + st.length() * 2);
                this.closeRecord();
                BiffImageData image = imageList.get(startImageIndex + index);
                this.writeRecordHeader(61456, 0, 0);
                this.dwShort(0, 2);
                this.dwShort(2, image.FirstColumnIndex);
                this.dwShort(4, image.FirstColumnOffset);
                this.dwShort(6, image.FirstRowIndex);
                this.dwShort(8, image.FirstRowOffset);
                this.dwShort(10, image.LastColumnIndex);
                this.dwShort(12, image.LastColumnOffset);
                this.dwShort(14, image.LastRowIndex);
                this.dwShort(16, image.LastRowOffset);
                this.mem.write(this.buf, 0, 18);
                this.closeRecord();
                this.writeRecordHeader(61457, 0, 0);
                this.closeRecord();
                this.closeRecord();
            }
            this.closeRecord();
            this.closeRecord();
            this.memBookmarks[0] = 0;
            this.memBookmarks[imageCount] = this.mem.size();
        }
    }

    public class BiffImageData {
        public short FirstRowIndex;
        public short FirstRowOffset;
        public short FirstColumnIndex;
        public short FirstColumnOffset;
        public short LastRowIndex;
        public short LastRowOffset;
        public short LastColumnIndex;
        public short LastColumnOffset;
        public byte[] ImageData;

        public BiffImageData(short FirstRowIndex, short FirstRowOffset, short FirstColumnIndex, short FirstColumnOffset, short LastRowIndex, short LastRowOffset, short LastColumnIndex, short LastColumnOffset, byte[] ImageData) {
            this.FirstRowIndex = FirstRowIndex;
            this.FirstRowOffset = FirstRowOffset;
            this.FirstColumnIndex = FirstColumnIndex;
            this.FirstColumnOffset = FirstColumnOffset;
            this.LastRowIndex = LastRowIndex;
            this.LastRowOffset = LastRowOffset;
            this.LastColumnIndex = LastColumnIndex;
            this.LastColumnOffset = LastColumnOffset;
            this.ImageData = ImageData;
        }
    }

    private class HlinkData {
        public CellRangeAddress Range;
        public String Description;
        public String Bookmark;

        public HlinkData(CellRangeAddress Range2, String Description, String Bookmark) {
            this.Range = Range2;
            this.Description = Description;
            this.Bookmark = Bookmark;
        }
    }

    private class CellRangeAddress {
        public int FirstRow;
        public int LastRow;
        public int FirstColumn;
        public int LastColumn;

        public CellRangeAddress(int FirstRow, int LastRow, int FirstColumn, int LastColumn) {
            this.FirstRow = FirstRow;
            this.LastRow = LastRow;
            this.FirstColumn = FirstColumn;
            this.LastColumn = LastColumn;
        }
    }

    private class DataFont {
        public String Name;
        public boolean Bold;
        public boolean Italic;
        public boolean Underlined;
        public boolean Strikeout;
        public int Height;
        public int Color;
        public int Charset;

        public DataFont(String Name, boolean Bold, boolean Italic, boolean Underlined, boolean Strikeout, int Height, int Color2, int Charset2) {
            this.Name = Name;
            this.Bold = Bold;
            this.Italic = Italic;
            this.Underlined = Underlined;
            this.Strikeout = Strikeout;
            this.Height = Height;
            this.Color = Color2;
            this.Charset = Charset2;
        }

        public boolean equals(DataFont obj) {
            return this.Name.equals(obj.Name) && this.Bold == obj.Bold && this.Italic == obj.Italic && this.Underlined == obj.Underlined && this.Strikeout == obj.Strikeout && this.Height == obj.Height && this.Color == obj.Color && this.Charset == obj.Charset;
        }
    }

    private class DataXF {
        public int FontIndex;
        public int FormatIndex;
        public int XFType;
        public int ParentStyleXF;
        public int HorAlign;
        public int VertAlign;
        public int TextWrapped;
        public int TextRotationAngle;
        public int TextDirection;
        public int UsedAttrib;
        public int LineStyleLeft;
        public int LineStyleRight;
        public int LineStyleTop;
        public int LineStyleBottom;
        public int ColorIndexLeft;
        public int ColorIndexRight;
        public int ColorIndexTop;
        public int ColorIndexBottom;
        public int FillPatern;
        public int ColorIndexPattern;
        public int ColorIndexBackground;

        public DataXF(int FontIndex, int FormatIndex, int XFType, int ParentStyleXF, int HorAlign, int VertAlign, int TextWrapped, int TextRotationAngle, int TextDirection, int UsedAttrib, int LineStyleLeft, int LineStyleRight, int LineStyleTop, int LineStyleBottom, int ColorIndexLeft, int ColorIndexRight, int ColorIndexTop, int ColorIndexBottom, int FillPatern, int ColorIndexPattern, int ColorIndexBackground) {
            this.FontIndex = FontIndex;
            this.FormatIndex = FormatIndex;
            this.XFType = XFType;
            this.ParentStyleXF = ParentStyleXF;
            this.HorAlign = HorAlign;
            this.VertAlign = VertAlign;
            this.TextWrapped = TextWrapped;
            this.TextRotationAngle = TextRotationAngle;
            this.TextDirection = TextDirection;
            this.UsedAttrib = UsedAttrib;
            this.LineStyleLeft = LineStyleLeft;
            this.LineStyleRight = LineStyleRight;
            this.LineStyleTop = LineStyleTop;
            this.LineStyleBottom = LineStyleBottom;
            this.ColorIndexLeft = ColorIndexLeft;
            this.ColorIndexRight = ColorIndexRight;
            this.ColorIndexTop = ColorIndexTop;
            this.ColorIndexBottom = ColorIndexBottom;
            this.FillPatern = FillPatern;
            this.ColorIndexPattern = ColorIndexPattern;
            this.ColorIndexBackground = ColorIndexBackground;
        }

        public boolean equals(DataXF obj) {
            return this.FontIndex == obj.FontIndex && this.FormatIndex == obj.FormatIndex && this.XFType == obj.XFType && this.ParentStyleXF == obj.ParentStyleXF && this.HorAlign == obj.HorAlign && this.VertAlign == obj.VertAlign && this.TextWrapped == obj.TextWrapped && this.TextRotationAngle == obj.TextRotationAngle && this.TextDirection == obj.TextDirection && this.UsedAttrib == obj.UsedAttrib && this.LineStyleLeft == obj.LineStyleLeft && this.LineStyleRight == obj.LineStyleRight && this.LineStyleTop == obj.LineStyleTop && this.LineStyleBottom == obj.LineStyleBottom && this.ColorIndexLeft == obj.ColorIndexLeft && this.ColorIndexRight == obj.ColorIndexRight && this.ColorIndexTop == obj.ColorIndexTop && this.ColorIndexBottom == obj.ColorIndexBottom && this.FillPatern == obj.FillPatern && this.ColorIndexPattern == obj.ColorIndexPattern && this.ColorIndexBackground == obj.ColorIndexBackground;
        }
    }
}

