/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.report.export.service;

import com.stimulsoft.base.IStiEnum;
import com.stimulsoft.base.drawing.StiAdvancedBorder;
import com.stimulsoft.base.drawing.StiBorder;
import com.stimulsoft.base.drawing.StiBorderSide;
import com.stimulsoft.base.drawing.StiBrush;
import com.stimulsoft.base.drawing.StiColor;
import com.stimulsoft.base.drawing.StiColorEnum;
import com.stimulsoft.base.drawing.StiHtmlState;
import com.stimulsoft.base.drawing.StiHtmlTagsState;
import com.stimulsoft.base.drawing.StiLineInfo;
import com.stimulsoft.base.drawing.StiSolidBrush;
import com.stimulsoft.base.drawing.StiTextOptions;
import com.stimulsoft.base.drawing.StiTextRendererParseHtml;
import com.stimulsoft.base.drawing.enums.StiBorderSides;
import com.stimulsoft.base.drawing.enums.StiHorAlignment;
import com.stimulsoft.base.drawing.enums.StiPenStyle;
import com.stimulsoft.base.drawing.enums.StiTextHorAlignment;
import com.stimulsoft.base.drawing.enums.StiVertAlignment;
import com.stimulsoft.base.enums.StiArabicDigitsType;
import com.stimulsoft.base.exception.StiException;
import com.stimulsoft.base.licenses.StiLicenseKeyValidator;
import com.stimulsoft.base.localization.StiLocalization;
import com.stimulsoft.base.system.StiFont;
import com.stimulsoft.base.system.StiGuid;
import com.stimulsoft.base.system.geometry.StiRectangle;
import com.stimulsoft.base.utils.StiBidirectionalConvert;
import com.stimulsoft.base.utils.StiMath;
import com.stimulsoft.base.utils.StiResourceUtil;
import com.stimulsoft.base.utils.StiXmlHelper;
import com.stimulsoft.base.utils.StiXmlTextWriter;
import com.stimulsoft.lib.io.StiCloseUtil;
import com.stimulsoft.lib.io.StiIOUtil;
import com.stimulsoft.lib.utils.StiValidationUtil;
import com.stimulsoft.report.StiImageCache;
import com.stimulsoft.report.StiReport;
import com.stimulsoft.report.chart.StiChart;
import com.stimulsoft.report.components.StiBookmark;
import com.stimulsoft.report.components.StiComponent;
import com.stimulsoft.report.components.StiComponentsCollection;
import com.stimulsoft.report.components.StiPage;
import com.stimulsoft.report.components.StiPagesCollection;
import com.stimulsoft.report.components.StiWatermark;
import com.stimulsoft.report.components.enums.StiTextQuality;
import com.stimulsoft.report.components.interfaces.IStiBorder;
import com.stimulsoft.report.components.interfaces.IStiExportImage;
import com.stimulsoft.report.components.interfaces.IStiExportImageExtended;
import com.stimulsoft.report.components.interfaces.IStiFont;
import com.stimulsoft.report.components.interfaces.IStiIgnoreBorderWhenExport;
import com.stimulsoft.report.components.interfaces.IStiText;
import com.stimulsoft.report.components.interfaces.IStiTextBrush;
import com.stimulsoft.report.components.interfaces.IStiTextOptions;
import com.stimulsoft.report.components.simplecomponents.StiImage;
import com.stimulsoft.report.components.simplecomponents.StiPointPrimitive;
import com.stimulsoft.report.components.simplecomponents.StiRichText;
import com.stimulsoft.report.components.simplecomponents.StiShape;
import com.stimulsoft.report.components.simplecomponents.StiText;
import com.stimulsoft.report.enums.StiExportFormat;
import com.stimulsoft.report.enums.StiHtmlChartType;
import com.stimulsoft.report.export.service.StiExportService;
import com.stimulsoft.report.export.service.StiSvgExportService;
import com.stimulsoft.report.export.service.helper.StiChartSvgHelper;
import com.stimulsoft.report.export.service.helper.StiGaugeSvgHelper;
import com.stimulsoft.report.export.service.helper.StiMapSvgHelper;
import com.stimulsoft.report.export.settings.StiExportSettings;
import com.stimulsoft.report.export.settings.StiHtmlExportSettings;
import com.stimulsoft.report.export.tools.StiCell;
import com.stimulsoft.report.export.tools.StiCellStyle;
import com.stimulsoft.report.export.tools.StiImageFormat;
import com.stimulsoft.report.export.tools.StiMatrix;
import com.stimulsoft.report.export.tools.StiTextRenderer;
import com.stimulsoft.report.export.tools.html.StiHtmlExportBookmarksMode;
import com.stimulsoft.report.export.tools.html.StiHtmlExportMode;
import com.stimulsoft.report.export.tools.html.StiHtmlExportQuality;
import com.stimulsoft.report.export.tools.html.StiHtmlImageHost;
import com.stimulsoft.report.export.tools.html.StiHtmlTableCell;
import com.stimulsoft.report.export.tools.html.StiHtmlTableRender;
import com.stimulsoft.report.export.tools.html.StiHtmlTextWriter;
import com.stimulsoft.report.export.tools.html.StiHtmlUnit;
import com.stimulsoft.report.infographics.gauge.StiGauge;
import com.stimulsoft.report.maps.StiMap;
import com.stimulsoft.report.options.ExportOptions;
import com.stimulsoft.report.painters.StiPainter;
import com.stimulsoft.report.painters.components.StiPagePainter;
import java.awt.image.BufferedImage;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringWriter;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.imageio.ImageIO;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class StiHtmlExportService
extends StiExportService {
    public static double LINE_HEIGHT_CORRECTION = 1.12;
    private static final String HTML_BEGIN_PATTERN = "<table width='100%%' height='100%%'><tr><td height='%s' align='%s' valign='%s' style=\"font-family: '%s'; font-size: %s;  color: %s\" >";
    private static final Pattern FONT_SIZE_PATTERN = Pattern.compile("font-size:(.[^;]+)");
    private static final Pattern LINE_HEIGHT_PATTERN = Pattern.compile("line-height:(.[^;]+)");
    private boolean clearOnFinish = true;
    private StiHtmlTableRender tableRender = null;
    private StiReport report;
    private String fileName = "";
    private double startPage = 0.0;
    private double zoom = 0.75;
    private StiImageFormat imageFormat;
    private StiHtmlTextWriter htmlWriter;
    private StiHtmlExportQuality exportQuality;
    private boolean useStylesTable = true;
    private boolean fileStreamMode = true;
    private float imageQuality = 0.75f;
    private float imageResolution = 96.0f;
    private SortedMap<Double, Double> coordX = new TreeMap<Double, Double>();
    private SortedMap<Double, Double> coordY = new TreeMap<Double, Double>();
    private String strSpanDiv = "span";
    private boolean renderStyles = true;
    private ArrayList<StiCellStyle> styles = new ArrayList();
    private Hashtable<Object, Object> interactionComponents = null;
    private StiHtmlImageHost htmlImageHost;
    private double totalPageWidth = 0.0;
    private double totalPageHeight = 0.0;
    private boolean renderAsDocument = true;
    private boolean removeEmptySpaceAtBottom = ExportOptions.Html.isRemoveEmptySpaceAtBottom();
    private StiHorAlignment pageHorAlignment = StiHorAlignment.Center;
    private HashMap<StiComponent, String> chartData = new HashMap();
    public Hashtable<String, String> hashBookmarkGuid = null;
    public String openLinksTarget = null;
    public StiHtmlChartType chartType = StiHtmlChartType.Image;
    private boolean renderWebViewer = false;
    private boolean renderWebInteractions = false;

    public boolean isRenderWebInteractions() {
        return this.renderWebInteractions;
    }

    public void setRenderWebInteractions(boolean renderWebInteractions) {
        this.renderWebInteractions = renderWebInteractions;
    }

    public boolean isRenderWebViewer() {
        return this.renderWebViewer;
    }

    public void setRenderWebViewer(boolean renderWebViewer) {
        this.renderWebViewer = renderWebViewer;
    }

    public HashMap<StiComponent, String> getChartData() {
        return this.chartData;
    }

    public void setChartData(HashMap<StiComponent, String> chartData) {
        this.chartData = chartData;
    }

    public void addCoord(StiRectangle rect) {
        this.addCoord(rect.getLeft(), rect.getTop());
        this.addCoord(rect.getRight(), rect.getBottom());
    }

    private void addCoord(double x, double y) {
        this.coordX.put(x, x);
        this.coordY.put(y, y);
    }

    private void formatCoords(StiReport report) {
        TreeMap<Double, Double> newCoordX = new TreeMap<Double, Double>();
        for (double key : this.coordX.keySet()) {
            newCoordX.put(key, StiMath.round((Double)(report.convertToHInches(report.getUnit(), (Double)this.coordX.get(key)) * this.zoom * 0.75), (Double)2.0));
        }
        this.coordX.clear();
        this.coordX.putAll(newCoordX);
        TreeMap<Double, Double> newCoordY = new TreeMap<Double, Double>();
        for (double key : this.coordY.keySet()) {
            newCoordY.put(key, StiMath.round((Double)(report.convertToHInches(report.getUnit(), (Double)this.coordY.get(key)) * this.zoom * 0.75), (Double)2.0));
        }
        this.coordY.clear();
        this.coordY.putAll(newCoordY);
    }

    private String formatCoord(double value) {
        return StiMath.round((Double)value, (Double)2.0) + "pt";
    }

    public String formatColor(StiColor color) {
        return color.toRGBAhtml();
    }

    private String getBorderStyle(StiPenStyle style) {
        switch (style) {
            case Dot: {
                return " dotted";
            }
            case Dash: 
            case DashDot: 
            case DashDotDot: {
                return " dashed";
            }
            case Double: {
                return " double";
            }
        }
        return " solid";
    }

    public void renderFont(StiHtmlTableCell cell, StiFont font) throws IOException {
        String fontStr = "";
        if (font.bold()) {
            fontStr = fontStr + "bold ";
        }
        if (font.italic()) {
            fontStr = fontStr + "italic ";
        }
        fontStr = fontStr + new Double(Math.round(font.getSize() * this.zoom)).toString();
        fontStr = fontStr + "pt " + font.getName();
        if (cell == null) {
            this.htmlWriter.writeStyleAttribute("Font", fontStr);
            if (font.underline()) {
                this.htmlWriter.writeStyleAttribute("text-decoration", "underline");
            } else if (font.strikeout()) {
                this.htmlWriter.writeStyleAttribute("text-decoration", "line-through");
            }
        } else {
            cell.getStyle().put("Font", fontStr);
            if (font.underline()) {
                cell.getStyle().put("text-decoration", "underline");
            } else if (font.strikeout()) {
                cell.getStyle().put("text-decoration", "line-through");
            }
        }
    }

    public void renderTextHorAlignment(StiHtmlTableCell cell, StiCellStyle style) throws IOException {
        boolean rightToLeft = style.getTextOptions() != null && style.getTextOptions().getRightToLeft();
        StiTextHorAlignment textHorAlignment = style.getHorAlignment();
        String align = "";
        if (textHorAlignment == StiTextHorAlignment.Left) {
            String string = align = !rightToLeft ? "left" : "right";
        }
        if (textHorAlignment == StiTextHorAlignment.Right) {
            String string = align = rightToLeft ? "left" : "right";
        }
        if (textHorAlignment == StiTextHorAlignment.Center) {
            align = "center";
        }
        if (textHorAlignment == StiTextHorAlignment.Width) {
            align = "justify";
        }
        if (!"".equals(align)) {
            if (cell == null) {
                this.htmlWriter.writeStyleAttribute("text-align", align);
            } else {
                cell.getStyle().put("text-align", align);
            }
        }
    }

    public void renderVertAlignment(StiHtmlTableCell cell, StiVertAlignment textVertAlignment) throws IOException {
        String align = "";
        if (textVertAlignment == StiVertAlignment.Top) {
            align = "top";
        }
        if (textVertAlignment == StiVertAlignment.Center) {
            align = "middle";
        }
        if (textVertAlignment == StiVertAlignment.Bottom) {
            align = "bottom";
        }
        if (!"".equals(align)) {
            if (cell == null) {
                this.htmlWriter.writeStyleAttribute("vertical-align", align);
            } else {
                cell.getStyle().put("vertical-align", align);
            }
        }
    }

    public void renderTextAngle(StiTextOptions textOptions) throws IOException {
        if (textOptions != null && (textOptions.getAngle() == 90.0f || textOptions.getAngle() == 270.0f)) {
            this.htmlWriter.writeStyleAttribute("writing-mode", "tb-rl");
        }
    }

    public void renderTextDirection(StiHtmlTableCell cell, StiTextOptions textOptions) throws IOException {
        if (textOptions != null && textOptions.getRightToLeft()) {
            if (cell == null) {
                this.htmlWriter.writeStyleAttribute("direction", "rtl");
            } else {
                cell.getStyle().put("direction", "rtl");
            }
        }
    }

    public void renderBackColor(StiHtmlTableCell cell, StiColor color) throws IOException {
        if (cell == null) {
            this.htmlWriter.writeStyleAttribute("background-color", this.formatColor(color));
        } else {
            cell.getStyle().put("background-color", this.formatColor(color));
        }
    }

    public void renderTextColor(StiHtmlTableCell cell, StiColor color) throws IOException {
        if (!StiColorEnum.Black.color().equals(color)) {
            if (cell == null) {
                this.htmlWriter.writeStyleAttribute("color", this.formatColor(color));
            } else {
                cell.getStyle().put("color", this.formatColor(color));
            }
        }
    }

    public void renderBorder(StiComponent comp) throws IOException {
        if (comp instanceof IStiBorder && !(comp instanceof IStiIgnoreBorderWhenExport)) {
            IStiBorder border = (IStiBorder)((Object)comp);
            this.renderBorder(border.getBorder());
        }
    }

    public void renderBorder(StiBorder border) throws IOException {
        if (border != null) {
            StiAdvancedBorder advBorder;
            StiBorderSide borderL = null;
            StiBorderSide borderR = null;
            StiBorderSide borderT = null;
            StiBorderSide borderB = null;
            StiAdvancedBorder stiAdvancedBorder = advBorder = border instanceof StiAdvancedBorder ? (StiAdvancedBorder)border : null;
            if (advBorder != null) {
                borderL = advBorder.getLeftSide();
                borderR = advBorder.getRightSide();
                borderT = advBorder.getTopSide();
                borderB = advBorder.getBottomSide();
            } else {
                borderL = new StiBorderSide(border.getColor(), border.getSize(), border.getStyle());
                if (border.isRightBorderSidePresent()) {
                    borderR = borderL;
                }
                if (border.isTopBorderSidePresent()) {
                    borderT = borderL;
                }
                if (border.isBottomBorderSidePresent()) {
                    borderB = borderL;
                }
                if (!border.isLeftBorderSidePresent()) {
                    borderL = null;
                }
            }
            this.renderBorder(null, borderL, "left");
            this.renderBorder(null, borderR, "right");
            this.renderBorder(null, borderT, "top");
            this.renderBorder(null, borderB, "bottom");
        }
    }

    public void renderBorder(StiHtmlTableCell cell, StiBorderSide border, String side) throws IOException {
        if (border != null && border.getStyle() != StiPenStyle.None) {
            String color = this.formatColor(border.getColor());
            String style = this.getBorderStyle(border.getStyle());
            double sizeD = border.getSize();
            if (sizeD > 0.0 && sizeD < 1.0) {
                sizeD = 1.0;
            }
            if (sizeD < 1.0 && (border.getStyle() == StiPenStyle.Dash || border.getStyle() == StiPenStyle.DashDot || border.getStyle() == StiPenStyle.DashDotDot || border.getStyle() == StiPenStyle.Dot)) {
                sizeD = 1.0;
            }
            if (border.getStyle() == StiPenStyle.Double) {
                sizeD = 2.5;
            }
            String size = StiMath.roundUp((Double)sizeD) + "px";
            if (cell == null) {
                this.htmlWriter.writeStyleAttribute(String.format("border-%s-color", side), color);
                this.htmlWriter.writeStyleAttribute(String.format("border-%s-style", side), style);
                this.htmlWriter.writeStyleAttribute(String.format("border-%s-width", side), size);
            } else {
                cell.getStyle().put(String.format("border-%s-color", side), color);
                cell.getStyle().put(String.format("border-%s-style", side), style);
                cell.getStyle().put(String.format("border-%s-width", side), size);
            }
        } else if (ExportOptions.Html.isUseStrictTableCellSize() && cell == null) {
            this.htmlWriter.writeStyleAttribute(String.format("border-%s-color", side), "transparent");
            this.htmlWriter.writeStyleAttribute(String.format("border-%s-style", side), "solid");
            this.htmlWriter.writeStyleAttribute(String.format("border-%s-width", side), "1px");
        }
    }

    public void renderPosition(StiComponent comp) throws IOException {
        StiText text;
        IStiBorder bord;
        StiRectangle rect = new StiRectangle(comp.ComponentToPage(comp.getClientRectangle()));
        String left = this.formatCoord((Double)this.coordX.get(rect.getLeft()));
        String top = this.formatCoord((Double)this.coordY.get(rect.getTop()) + this.startPage * this.zoom * 0.75);
        double widthD = (Double)this.coordX.get(rect.getRight()) - (Double)this.coordX.get(rect.getLeft());
        double heightD = (Double)this.coordY.get(rect.getBottom()) - (Double)this.coordY.get(rect.getTop());
        IStiBorder iStiBorder = bord = comp instanceof IStiBorder ? (IStiBorder)((Object)comp) : null;
        if (bord != null && bord.getBorder() != null && !(bord.getBorder() instanceof StiAdvancedBorder) && bord.getBorder().getStyle() != StiPenStyle.None && bord.getBorder().getSize() > 0.0 && bord.getBorder().getSide().notContains((IStiEnum)StiBorderSides.None)) {
            if (bord.getBorder().getSide().contains((IStiEnum)StiBorderSides.Left)) {
                widthD -= bord.getBorder().getSize() * 0.375;
            }
            if (bord.getBorder().getSide().contains((IStiEnum)StiBorderSides.Right)) {
                widthD -= bord.getBorder().getSize() * 0.375;
            }
            if (bord.getBorder().getSide().contains((IStiEnum)StiBorderSides.Top)) {
                heightD -= bord.getBorder().getSize() * 0.375;
            }
            if (bord.getBorder().getSide().contains((IStiEnum)StiBorderSides.Bottom)) {
                heightD -= bord.getBorder().getSize() * 0.375;
            }
        }
        StiText stiText = text = comp instanceof StiText ? (StiText)comp : null;
        if (text != null && !text.getMargins().isEmpty()) {
            widthD -= (double)((int)text.getMargins().getLeft() + (int)text.getMargins().getRight()) * 0.75;
            heightD -= (double)((int)text.getMargins().getTop() + (int)text.getMargins().getBottom()) * 0.75;
        }
        if (widthD < 0.0) {
            widthD = 0.0;
        }
        if (heightD < 0.0) {
            heightD = 0.0;
        }
        String width = this.formatCoord(widthD);
        String height = this.formatCoord(heightD);
        this.htmlWriter.writeStyleAttribute("left", left);
        this.htmlWriter.writeStyleAttribute("top", top);
        this.htmlWriter.writeStyleAttribute("width", width);
        this.htmlWriter.writeStyleAttribute("height", height);
        if (text != null && !text.getMargins().isEmpty()) {
            this.htmlWriter.writeStyleAttribute("padding", String.format("%s %s %s %s", StiHtmlUnit.pixel((int)text.getMargins().getTop()).toString(), StiHtmlUnit.pixel((int)text.getMargins().getRight()).toString(), StiHtmlUnit.pixel((int)text.getMargins().getBottom()).toString(), StiHtmlUnit.pixel((int)text.getMargins().getLeft()).toString()));
        }
        if (comp instanceof StiShape) {
            this.htmlWriter.writeStyleAttribute("overflow", "visible");
        }
    }

    public void renderImage(StiComponent comp) throws IOException {
        String imageURL = null;
        if (comp instanceof StiImage) {
            imageURL = (String)((StiImage)comp).getImageURLValue();
        }
        this.renderImage((IStiExportImage)((Object)comp), imageURL);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void renderImage(IStiExportImage exportImage, String imageURL) throws IOException {
        float dpix;
        if (exportImage == null) return;
        IStiExportImageExtended exportImageExtended = exportImage instanceof IStiExportImageExtended ? (IStiExportImageExtended)exportImage : null;
        double zoom = this.zoom;
        float resolution = this.imageResolution;
        if (ExportOptions.Html.getUseImageResolution() && exportImage instanceof StiImage && ((StiImage)exportImage).getImageBytesToDraw() != null && (dpix = 100.0f) >= 50.0f && dpix <= 1250.0f) {
            resolution = dpix;
        }
        if (resolution != 100.0f) {
            zoom *= (double)(resolution / 100.0f);
        }
        BufferedImage image = null;
        boolean isForceExportAsImage = this.forceExportAsImage(exportImage);
        if (exportImageExtended != null || isForceExportAsImage) {
            if (!exportImageExtended.isExportAsImage(StiExportFormat.Html) && !isForceExportAsImage) return;
            image = this.imageFormat == StiImageFormat.Png ? exportImageExtended.getImage(zoom, StiExportFormat.ImagePng) : (this.strSpanDiv.equals("span") ? exportImageExtended.getImage(zoom, StiExportFormat.HtmlSpan) : exportImageExtended.getImage(zoom, StiExportFormat.HtmlDiv));
        } else {
            image = exportImage.getImage(zoom);
        }
        StiShape shape = exportImage instanceof StiShape ? (StiShape)exportImage : null;
        this.renderImage(image, imageURL, zoom, shape != null ? -((int)Math.round(shape.getSize() * zoom / 2.0)) : 0);
        if (image == null) return;
        image.flush();
    }

    private boolean forceExportAsImage(Object exportImage) {
        return exportImage instanceof IStiTextOptions && ((IStiTextOptions)exportImage).getTextOptions().getAngle() != 0.0f;
    }

    public void renderImage(BufferedImage image, String imageURL, double zoom, int margin) throws IOException {
        if (image != null) {
            if (!(StiValidationUtil.isNullOrEmpty((String)imageURL) || imageURL.startsWith("http") || imageURL.startsWith("ftp"))) {
                imageURL = null;
            }
            String imageString = imageURL;
            if (StiValidationUtil.isNullOrEmpty((String)imageURL)) {
                if (this.htmlImageHost != null) {
                    imageString = this.htmlImageHost.getImageString(image);
                }
                if (imageString == null) {
                    imageString = "";
                }
            }
            this.htmlWriter.writeBeginTag("img ");
            this.htmlWriter.write("style=\"width:" + new Double(Math.round((double)image.getWidth() / zoom * this.zoom)).toString() + "px;");
            if (margin != 0) {
                this.htmlWriter.write("margin:" + margin + "px;");
            }
            this.htmlWriter.write("height:" + new Double(Math.round((double)image.getHeight() / zoom * this.zoom)).toString() + "px;border:0px\"");
            this.htmlWriter.writeAttribute("src", imageString);
            this.htmlWriter.write(">");
            this.htmlWriter.writeEndTag("img");
        }
    }

    private boolean renderHyperlink(StiComponent comp) throws IOException {
        String hyperlinkValue = comp.getHyperlinkValue();
        if (hyperlinkValue == null) {
            hyperlinkValue = "";
        }
        String bookmarkValue = comp.getBookmarkValue();
        String bookmarkGuid = null;
        if (bookmarkValue == null) {
            bookmarkValue = "";
        }
        if (!StiValidationUtil.isNullOrWhiteSpace((String)comp.getGuid()) && this.hashBookmarkGuid.containsKey(comp.getGuid())) {
            bookmarkGuid = comp.getGuid();
        }
        if (!"".equals(hyperlinkValue)) {
            StiRectangle rect = new StiRectangle(comp.ComponentToPage(comp.getClientRectangle()));
            String height = this.formatCoord((Double)this.coordY.get(rect.getBottom()) - (Double)this.coordY.get(rect.getTop()));
            StringBuilder style = new StringBuilder();
            style.append("display:block;height:" + height + ";text-decoration:none;");
            if (comp instanceof IStiTextBrush) {
                IStiTextBrush textBrush = (IStiTextBrush)((Object)comp);
                StiColor color = StiBrush.ToColor((StiBrush)textBrush.getTextBrush());
                style.append("color:" + this.formatColor(color) + ";");
            }
            if (comp instanceof IStiFont) {
                IStiFont font = (IStiFont)((Object)comp);
                if (font.getFont().underline()) {
                    style.append("text-decoration:underline;");
                } else {
                    style.append("text-decoration:none;");
                }
            }
            this.htmlWriter.writeBeginTag("a");
            if (!"".equals(bookmarkValue)) {
                this.htmlWriter.writeAttribute("name", bookmarkValue.replace("'", ""));
            }
            if (!StiValidationUtil.isNullOrWhiteSpace((String)bookmarkGuid)) {
                this.htmlWriter.writeAttribute("guid", bookmarkGuid);
            }
            this.htmlWriter.writeAttribute("style", style.toString());
            this.htmlWriter.writeAttribute("href", hyperlinkValue);
            this.htmlWriter.write(">");
            return true;
        }
        if (!"".equals(bookmarkValue) || !StiValidationUtil.isNullOrWhiteSpace((String)bookmarkGuid)) {
            this.htmlWriter.writeBeginTag("a");
            if (!StiValidationUtil.isNullOrWhiteSpace((String)bookmarkValue)) {
                this.htmlWriter.writeAttribute("name", bookmarkValue.replace("'", ""));
            }
            if (!StiValidationUtil.isNullOrWhiteSpace((String)bookmarkGuid)) {
                this.htmlWriter.writeAttribute("guid", bookmarkGuid);
            }
            this.htmlWriter.write(">");
            return true;
        }
        return false;
    }

    public void renderPage(StiPagesCollection pages, boolean useBookmarksTree, int bookmarkWidth, StiHtmlExportSettings settings) throws IOException {
        if (this.pageHorAlignment != StiHorAlignment.Left) {
            this.htmlWriter.writeBeginTag(this.strSpanDiv + " style=\"");
            this.htmlWriter.writeStyleAttribute("text-align", this.pageHorAlignment == StiHorAlignment.Center ? "center" : "right");
            if (useBookmarksTree) {
                this.htmlWriter.writeStyleAttribute("margin-left", String.format("%px", bookmarkWidth + 4));
            }
            this.htmlWriter.write("\">");
            this.htmlWriter.incIndent();
            this.htmlWriter.writeLine();
        }
        this.htmlWriter.writeBeginTag(this.strSpanDiv + " class=\"StiPageContainer\" style=\"");
        if (this.renderAsDocument) {
            if (this.pageHorAlignment != StiHorAlignment.Left) {
                this.htmlWriter.writeStyleAttribute("display", "inline-block");
            } else if (useBookmarksTree) {
                this.htmlWriter.writeStyleAttribute("left", String.format("%px", bookmarkWidth + 4));
            }
            this.htmlWriter.writeStyleAttribute("width", this.formatCoord(this.totalPageWidth * this.zoom * 0.75));
            this.htmlWriter.writeStyleAttribute("height", this.formatCoord(this.totalPageHeight * this.zoom * 0.75));
            this.htmlWriter.writeStyleAttribute("position", "relative");
            StiColor backColor = StiColorEnum.Transparent.color();
            if (pages != null && pages.size() > 0) {
                if (pages.get(0).getBrush() != null) {
                    backColor = StiBrush.ToColor((StiBrush)pages.get(0).getBrush());
                }
                if (StiColorEnum.Transparent.color().equals(backColor)) {
                    backColor = StiColorEnum.White.color();
                }
                if (pages.get(0).getBorder() != null) {
                    this.renderBorder(pages.get(0));
                }
            }
            this.htmlWriter.writeStyleAttribute("background-color", this.formatColor(backColor));
            String imagePath = this.getBackgroundImagePath(pages, this.zoom, settings);
            if (!"".equals(imagePath)) {
                this.htmlWriter.writeStyleAttribute("background-image", String.format("url('%s')", imagePath));
            }
        }
        this.htmlWriter.write("\">");
        this.htmlWriter.incIndent();
        this.htmlWriter.writeLine();
    }

    private void renderEndPage() throws IOException {
        this.htmlWriter.decIndent();
        this.htmlWriter.writeEndTag(this.strSpanDiv);
        this.htmlWriter.writeLine();
        if (this.pageHorAlignment != StiHorAlignment.Left) {
            this.htmlWriter.decIndent();
            this.htmlWriter.writeEndTag(this.strSpanDiv);
            this.htmlWriter.writeLine();
        }
    }

    public void renderStartDoc(StiHtmlTableRender render, boolean asTable, boolean useBookmarks, boolean exportBookmarksOnly, Hashtable<String, String> cssStyles, StiPagesCollection pages, Charset charset) throws IOException {
        StiColor backColor;
        this.htmlWriter.writeLine("<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.01//EN\" \"http://www.w3.org/TR/html4/strict.dtd\">");
        this.htmlWriter.write("<html xmlns=\"http://www.w3.org/1999/xhtml\">");
        this.htmlWriter.writeLine();
        this.htmlWriter.incIndent();
        this.htmlWriter.writeFullBeginTag("head");
        this.htmlWriter.writeLine();
        this.htmlWriter.incIndent();
        this.htmlWriter.writeFullBeginTag("title");
        this.htmlWriter.write(this.report.getReportAlias());
        this.htmlWriter.writeEndTag("title");
        this.htmlWriter.writeLine();
        this.htmlWriter.writeBeginTag("meta");
        this.htmlWriter.writeAttribute("http-equiv", "Content-Type");
        this.htmlWriter.writeAttribute("content", String.format("text/html; charset=%s", charset.name()));
        this.htmlWriter.writeEndTag("meta");
        this.htmlWriter.writeLine();
        if (render != null) {
            if (asTable) {
                render.renderStylesTable(useBookmarks, exportBookmarksOnly, cssStyles);
            } else {
                render.renderStyles(useBookmarks, exportBookmarksOnly, cssStyles);
            }
        }
        if (useBookmarks) {
            this.renderBookmarkScript();
        }
        this.htmlWriter.decIndent();
        this.htmlWriter.writeLine();
        this.htmlWriter.writeEndTag("head");
        this.htmlWriter.writeLine();
        this.htmlWriter.writeBeginTag("body");
        if (pages != null && pages.size() > 0 && pages.get(0).getBrush() != null && (backColor = StiBrush.ToColor((StiBrush)pages.get(0).getBrush())).getA() > 0) {
            this.htmlWriter.writeAttribute("bgcolor", this.formatColor(backColor));
        }
        this.htmlWriter.write(">");
        this.htmlWriter.incIndent();
        this.htmlWriter.writeLine();
    }

    private BufferedImage fillBitmapBackground(BufferedImage bmp, StiColor fillColor) {
        StiColor transparentColor = StiColorEnum.LightGray.color();
        if (bmp.getHeight() > 0 && bmp.getWidth() > 0) {
            transparentColor = StiColor.parseIntARGB((int)bmp.getRGB(0, bmp.getHeight() - 1));
        }
        if (transparentColor.getA() != 255) {
            BufferedImage image = new BufferedImage(bmp.getWidth(), bmp.getHeight(), 2);
            image.createGraphics().drawImage(bmp, 0, 0, bmp.getWidth(), bmp.getHeight(), fillColor.getAwtColor(), null);
            return image;
        }
        return bmp;
    }

    public void renderBookmarkScript() throws IOException {
        this.htmlWriter.writeBeginTag("script");
        this.htmlWriter.writeAttribute("type", "text/javascript");
        this.htmlWriter.writeLine(">");
        String buf = new String(this.getFile("/dtree/DtreeScript.js"));
        String[][] fileList = new String[][]{{"img/base.gif", "/dtree/DtreeBase.png"}, {"img/page.gif", "/dtree/DtreePage.png"}, {"img/folder.gif", "/dtree/DtreeFolder.png"}, {"img/folderopen.gif", "/dtree/DtreeFolderopen.png"}, {"img/empty.gif", "/dtree/DtreeEmpty.png"}, {"img/line.gif", "/dtree/DtreeLine.png"}, {"img/join.gif", "/dtree/DtreeJoin.png"}, {"img/joinbottom.gif", "/dtree/DtreeJoinbottom.png"}, {"img/plus.gif", "/dtree/DtreePlus.png"}, {"img/plusbottom.gif", "/dtree/DtreePlusbottom.png"}, {"img/minus.gif", "/dtree/DtreeMinus.png"}, {"img/minusbottom.gif", "/dtree/DtreeMinusbottom.png"}};
        this.htmlImageHost.setForcePng(true);
        for (int index = 0; index < fileList.length; ++index) {
            try {
                BufferedImage bmp = ImageIO.read(StiResourceUtil.getStream((String)fileList[index][1]));
                bmp = this.fillBitmapBackground(bmp, StiColor.fromArgb((int)240, (int)240, (int)240));
                String bmpPath = this.htmlImageHost.getImageString(bmp).replaceAll("\\\\", "/");
                buf = buf.replaceAll(fileList[index][0], bmpPath);
                continue;
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        this.htmlImageHost.setForcePng(false);
        String[] lineList = buf.split("\r");
        for (int index = 0; index < lineList.length; ++index) {
            this.htmlWriter.writeLine(lineList[index]);
        }
        this.htmlWriter.writeEndTag("script");
        this.htmlWriter.writeLine();
    }

    private void renderChartScripts(Boolean writeScriptTag) throws IOException {
        if (this.chartData.size() == 0) {
            return;
        }
        if (writeScriptTag.booleanValue()) {
            this.htmlWriter.writeBeginTag("script");
            this.htmlWriter.writeAttribute("type", "text/javascript");
            this.htmlWriter.writeLine(">");
        }
        String guid = StiGuid.newGuidStringPlain();
        InputStream is = StiResourceUtil.getStream((String)"/animation/stianimation.js");
        String script = StiIOUtil.toString((InputStream)is);
        this.htmlWriter.writeLine(script.replace("animateSti", "animateSti" + guid) + ";");
        this.htmlWriter.writeLine("setTimeout(function() {");
        for (StiComponent key : this.chartData.keySet()) {
            this.htmlWriter.writeLine("animateSti" + guid + "(\"" + this.chartData.get(key) + "\");");
        }
        this.htmlWriter.writeLine("}, 300);");
        if (writeScriptTag.booleanValue()) {
            this.htmlWriter.writeEndTag("script");
            this.htmlWriter.writeLine();
        }
    }

    public String getGuid(StiComponent comp) {
        if (!this.chartData.containsKey(comp)) {
            this.chartData.put(comp, StiGuid.newGuidStringPlain());
        }
        return this.chartData.get(comp);
    }

    public void renderEndDoc() throws IOException {
        this.htmlWriter.decIndent();
        this.htmlWriter.writeEndTag("body");
        this.htmlWriter.decIndent();
        this.htmlWriter.writeLine();
        this.htmlWriter.writeEndTag("html");
    }

    private void renderBookmarkTree(StiBookmark root, int bookmarkWidth, Hashtable<String, Integer> bookmarksPageIndex) throws IOException {
        ArrayList<StiBookmarkTreeNode> bookmarksTree = new ArrayList<StiBookmarkTreeNode>();
        this.addBookmarkNode(root, -1, bookmarksTree);
        this.htmlWriter.writeStyleAttribute("width", String.format("%spx", bookmarkWidth));
        this.htmlWriter.writeStyleAttribute("background-color", "#f0f0f0");
        this.htmlWriter.write("\">");
        this.htmlWriter.incIndent();
        this.htmlWriter.writeLine();
        this.htmlWriter.incIndent();
        this.htmlWriter.writeFullBeginTag("frame");
        this.htmlWriter.writeLine();
        this.htmlWriter.writeBeginTag("script");
        this.htmlWriter.writeAttribute("type", "text/javascript");
        this.htmlWriter.writeLine(">");
        this.htmlWriter.incIndent();
        this.htmlWriter.writeLine("<!--");
        this.htmlWriter.writeLine("bmrk = new dTree('bmrk');");
        for (int index = 0; index < bookmarksTree.size(); ++index) {
            StiBookmarkTreeNode node = bookmarksTree.get(index);
            String pageIndex = "";
            pageIndex = bookmarksPageIndex.containsKey(node.Title) ? String.format("Page %s", bookmarksPageIndex.get(node.Title) + 1) : "Page 0";
            this.htmlWriter.writeLine(String.format("bmrk.add(%s, %s, '%s', '%s', '%s');", index, node.Parent, node.Title, node.Url, pageIndex));
        }
        this.htmlWriter.writeLine("document.write(bmrk);");
        this.htmlWriter.writeLine("//-->");
        this.htmlWriter.decIndent();
        this.htmlWriter.writeEndTag("script");
        this.htmlWriter.decIndent();
        this.htmlWriter.writeLine();
        this.htmlWriter.decIndent();
    }

    private void addBookmarkNode(StiBookmark bkm, int parentNode, ArrayList<StiBookmarkTreeNode> bookmarksTree) {
        StiBookmarkTreeNode tn = new StiBookmarkTreeNode();
        tn.Parent = parentNode;
        String st = bkm.getText().replace("'", "").replaceAll("\r", "").replaceAll("\n", "");
        tn.Title = st;
        tn.Url = "#" + st;
        bookmarksTree.add(tn);
        int currentNode = bookmarksTree.size() - 1;
        if (bkm.getBookmarks().size() != 0) {
            for (int tempCount = 0; tempCount < bkm.getBookmarks().size(); ++tempCount) {
                this.addBookmarkNode((StiBookmark)((Object)bkm.getBookmarks().get(tempCount)), currentNode, bookmarksTree);
            }
        }
    }

    public String prepareTextForHtml(String text, boolean processWhiteSpaces) {
        if (text == null) {
            return null;
        }
        text = text.replace("\r", "");
        String[] txt = text.split("\n");
        StringBuilder sbFull = new StringBuilder();
        if (processWhiteSpaces) {
            for (int index = 0; index < txt.length; ++index) {
                int pos;
                String st = txt[index];
                for (pos = 0; pos < st.length() && st.charAt(pos) == ' '; ++pos) {
                }
                if (pos > 0) {
                    for (int indexSp = 0; indexSp < pos; ++indexSp) {
                        sbFull.append("&nbsp;");
                    }
                    sbFull.append(st.substring(pos));
                } else {
                    sbFull.append(st);
                }
                if (index >= txt.length - 1) continue;
                sbFull.append("<br>");
            }
        } else {
            sbFull.append(text.replaceAll("\n", "<br>"));
        }
        return sbFull.toString();
    }

    public static String convertTextWithHtmlTagsToHtmlText(StiText stiText, String text, double zoom) {
        String inputText = text;
        StiHtmlTagsState baseTagsState = new StiHtmlTagsState(stiText.font.bold(), stiText.font.italic(), stiText.font.underline(), stiText.font.strikeout(), (float)stiText.font.size, stiText.font.getName(), StiBrush.ToColor((StiBrush)stiText.getTextBrush()), StiBrush.ToColor((StiBrush)stiText.getBrush()), false, false, 0.0, 0.0, 1.0, stiText.getHorAlignment());
        StiHtmlState baseState = new StiHtmlState(baseTagsState.clone(), 0);
        List statesList = StiTextRendererParseHtml.parseHtmlToStates((String)inputText, (StiHtmlState)baseState.clone());
        StringBuilder finalText = new StringBuilder();
        StiTextHorAlignment textAlign = StiTextHorAlignment.Left;
        double lineHeight = 1.0;
        boolean needNbsp = true;
        boolean needCloseFont = false;
        StringBuilder outputText = new StringBuilder();
        StiHtmlTagsState prevState = baseTagsState;
        for (int index = 0; index < statesList.size(); ++index) {
            StiHtmlState htmlState = (StiHtmlState)statesList.get(index);
            StiHtmlTagsState state = htmlState.ts;
            if (state.bold != prevState.bold && !state.bold) {
                outputText.append("</b>");
            }
            if (state.italic != prevState.italic && !state.italic) {
                outputText.append("</i>");
            }
            if (state.underline != prevState.underline && !state.underline) {
                outputText.append("</u>");
            }
            if (state.strikeout != prevState.strikeout && !state.strikeout) {
                outputText.append("</s>");
            }
            if (state.superscript != prevState.superscript && !state.superscript) {
                outputText.append("</sup>");
            }
            if (state.subscript != prevState.subscript && !state.subscript) {
                outputText.append("</sub>");
            }
            if (state.bold != prevState.bold && state.bold) {
                outputText.append("<b>");
            }
            if (state.italic != prevState.italic && state.italic) {
                outputText.append("<i>");
            }
            if (state.underline != prevState.underline && state.underline) {
                outputText.append("<u>");
            }
            if (state.strikeout != prevState.strikeout && state.strikeout) {
                outputText.append("<s>");
            }
            if (state.superscript != prevState.superscript && state.superscript) {
                outputText.append("<sup>");
            }
            if (state.subscript != prevState.subscript && state.subscript) {
                outputText.append("<sub>");
            }
            if (!(state.fontColor.equals(prevState.fontColor) && state.backColor.equals(prevState.backColor) && state.fontName.equals(prevState.fontName) && state.fontSize == prevState.fontSize && state.letterSpacing == prevState.letterSpacing && state.wordSpacing == prevState.wordSpacing && StiValidationUtil.equals((Object)state.htmlStyle, (Object)prevState.htmlStyle))) {
                Matcher matcher;
                String fontStyle = "";
                if (!StiValidationUtil.equals((Object)state.htmlStyle, (Object)baseTagsState.htmlStyle)) {
                    fontStyle = fontStyle + state.htmlStyle + ";";
                }
                if (!state.fontColor.equals(baseTagsState.fontColor) && !fontStyle.contains("color:") && state.fontColor.a > 0) {
                    fontStyle = fontStyle + String.format("color:%s;", state.fontColor.toRGBAhtml());
                }
                if (!state.backColor.equals(baseTagsState.backColor) && !fontStyle.contains("background-color:") && state.backColor.a > 0) {
                    fontStyle = fontStyle + String.format("background-color:%s;", state.backColor.toRGBAhtml());
                }
                if (!StiValidationUtil.equals((Object)state.fontName, (Object)baseTagsState.fontName) && !fontStyle.contains("font-family:")) {
                    fontStyle = fontStyle + String.format("font-family:%s;", state.fontName);
                }
                boolean changed = false;
                if (state.fontSize != baseTagsState.fontSize && !fontStyle.contains("font-size:")) {
                    double fontSize = (double)state.fontSize * zoom;
                    fontStyle = fontStyle + String.format("font-size:%spt;", fontSize);
                    fontStyle = fontStyle + String.format("line-height:%sem;", StiMath.round((double)(state.lineHeight * LINE_HEIGHT_CORRECTION), (int)2));
                    changed = true;
                }
                if (zoom != 1.0 && !changed && fontStyle.contains("font-size:") && (matcher = FONT_SIZE_PATTERN.matcher(fontStyle)).find()) {
                    String fontSize = matcher.group(1);
                    String postfix = "";
                    double size = 0.0;
                    boolean parsed = false;
                    while (!parsed && fontSize.length() > 0) {
                        try {
                            size = Double.parseDouble(fontSize);
                            parsed = true;
                        }
                        catch (Exception e) {
                            postfix = fontSize.substring(fontSize.length() - 1) + postfix;
                            fontSize = fontSize.substring(0, fontSize.length() - 1);
                        }
                    }
                    fontStyle = fontStyle.replace(matcher.group(0), "font-size:" + size * zoom + postfix + ";");
                    Matcher matcherLineHeight = LINE_HEIGHT_PATTERN.matcher(fontStyle);
                    String lineH = String.format("line-height:%sem;", StiMath.round((double)(state.lineHeight * LINE_HEIGHT_CORRECTION), (int)2));
                    fontStyle = matcherLineHeight.find() ? fontStyle.replace(matcherLineHeight.group(0), lineH) : fontStyle + lineH;
                }
                if (state.letterSpacing != baseTagsState.letterSpacing && !fontStyle.contains("letter-spacing:")) {
                    fontStyle = fontStyle + String.format("letter-spacing:%sem;", state.letterSpacing);
                }
                if (state.wordSpacing != baseTagsState.wordSpacing && !fontStyle.contains("word-spacing:")) {
                    fontStyle = fontStyle + String.format("word-spacing:%sem;", state.wordSpacing);
                }
                if (needCloseFont) {
                    outputText.append("</font>");
                }
                needCloseFont = false;
                if (fontStyle.length() > 0) {
                    needCloseFont = true;
                    outputText.append(String.format("<font style=\"%s\">", fontStyle));
                }
            }
            textAlign = state.textAlign;
            double lastLineHeight = state.lineHeight;
            if ("\n".equals(htmlState.text.toString())) {
                if (needNbsp) {
                    outputText.append("&nbsp;");
                }
                finalText.append(StiHtmlExportService.getParagraphString(outputText, textAlign, lastLineHeight));
                outputText = new StringBuilder();
                needNbsp = true;
                lineHeight = lastLineHeight;
            } else {
                outputText.append((CharSequence)htmlState.text);
                if (htmlState.text.toString().trim().length() > 0) {
                    needNbsp = false;
                }
            }
            prevState = state;
        }
        if (outputText.length() > 0) {
            finalText.append(StiHtmlExportService.getParagraphString(outputText, textAlign, lineHeight));
        }
        if (needCloseFont) {
            finalText.append("</font>");
        }
        if (prevState.bold != baseTagsState.bold) {
            finalText.append(baseTagsState.bold ? "<b>" : "</b>");
        }
        if (prevState.italic != baseTagsState.italic) {
            finalText.append(baseTagsState.italic ? "<i>" : "</i>");
        }
        if (prevState.underline != baseTagsState.underline) {
            finalText.append(baseTagsState.underline ? "<u>" : "</u>");
        }
        if (prevState.strikeout != baseTagsState.strikeout) {
            finalText.append(baseTagsState.strikeout ? "<s>" : "</s>");
        }
        if (prevState.superscript != baseTagsState.superscript) {
            finalText.append(baseTagsState.superscript ? "<sup>" : "</sup>");
        }
        if (prevState.subscript != baseTagsState.subscript) {
            finalText.append(baseTagsState.subscript ? "<sub>" : "</sub>");
        }
        return finalText.toString();
    }

    private static String getParagraphString(StringBuilder text, StiTextHorAlignment textAlign, double lineHeight) {
        StringBuilder outputText = new StringBuilder();
        outputText.append("<p ");
        outputText.append("style=\"margin:0px;");
        String align = "left";
        if (textAlign == StiTextHorAlignment.Center) {
            align = "center";
        }
        if (textAlign == StiTextHorAlignment.Right) {
            align = "right";
        }
        if (textAlign == StiTextHorAlignment.Width) {
            align = "justify";
        }
        outputText.append(String.format("text-align:%s;", align));
        if (lineHeight != 1.0) {
            outputText.append(String.format("line-height:%sem;", StiMath.round((double)(lineHeight * LINE_HEIGHT_CORRECTION), (int)2)));
        }
        outputText.append("\">");
        outputText.append((CharSequence)text);
        outputText.append("</p>");
        return outputText.toString();
    }

    private String getBackgroundImagePath(StiPagesCollection pages, double zoomBase, StiHtmlExportSettings settings) {
        StiPage page;
        StiWatermark watermark;
        String backGroundImageString = "";
        if (!(pages.size() <= 0 || (watermark = (page = pages.get(0)).getWatermark()) == null || !watermark.getEnabled() || watermark.getImageBytes() == null && StiValidationUtil.isNullOrWhiteSpace((String)watermark.getImageHyperlink()) && StiValidationUtil.isNullOrEmpty((String)watermark.getText()))) {
            StiPagePainter painter = (StiPagePainter)StiPainter.getPainter(page);
            double zoom = ExportOptions.Html.isPrintLayoutOptimization() ? zoomBase * 0.96 : zoomBase;
            BufferedImage image = painter.getWatermarkImage(page, zoom, settings.isUseWatermarkMargins(), 1);
            if (this.htmlImageHost != null) {
                backGroundImageString = this.htmlImageHost.getImageString(image);
            }
            if (backGroundImageString == null) {
                backGroundImageString = "";
            }
        }
        return backGroundImageString.replaceAll("\\\\", "/");
    }

    public byte[] getFile(String filePath) {
        byte[] result = new byte[1];
        try {
            InputStream fis;
            File file = new File(filePath);
            if (file.exists()) {
                fis = new FileInputStream(file);
                result = new byte[(int)file.length()];
            } else {
                fis = StiResourceUtil.getStream((String)filePath);
                result = new byte[fis.available()];
            }
            fis.read(result);
            fis.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    private void assembleGuidUsedInBookmark(StiBookmark node, Hashtable<String, String> hash) {
        if (node != null && !StiValidationUtil.isNullOrWhiteSpace((String)node.getComponentGuid())) {
            hash.put(node.getComponentGuid(), node.getText());
        }
        if (node != null && node.getBookmarks() != null && node.getBookmarks().size() > 0) {
            for (StiBookmark bookmark : node.getBookmarks()) {
                this.assembleGuidUsedInBookmark(bookmark, hash);
            }
        }
    }

    private Element prepareSvg(Document doc, double width, double height, StiXmlTextWriter writer) throws IOException {
        Element svg = null;
        if (writer != null) {
            svg = writer.writeStartElement("svg");
        } else {
            svg = doc.createElement("svg");
            doc.appendChild(svg);
        }
        svg.setAttribute("version", "1.1");
        svg.setAttribute("baseProfile", "full");
        svg.setAttribute("xmlns", "http://www.w3.org/2000/svg");
        svg.setAttribute("xmlns:xlink", "http://www.w3.org/1999/xlink");
        svg.setAttribute("xmlns:ev", "http://www.w3.org/2001/xml-events");
        svg.setAttribute("height", String.valueOf(width).replace(",", "."));
        svg.setAttribute("width", String.valueOf(height).replace(",", "."));
        return svg;
    }

    public String prepareChartData(StiHtmlTextWriter writer, StiChart chart, double width, double height) throws ParserConfigurationException, IOException, TransformerException {
        float scale = 0.96f;
        DocumentBuilderFactory docFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder docBuilder = docFactory.newDocumentBuilder();
        Document doc = docBuilder.newDocument();
        Element svg = this.prepareSvg(doc, StiMath.round((double)(height * (double)scale), (int)2), StiMath.round((double)(width * (double)scale), (int)2), null);
        StiSvgExportService.StiSvgHelper.StiSvgData pp = new StiSvgExportService.StiSvgHelper.StiSvgData();
        pp.X = 0.0;
        pp.Y = 0.0;
        pp.Width = (float)(width * (double)scale);
        pp.Height = (float)(height * (double)scale);
        pp.Component = chart;
        StiChartSvgHelper.writeChart(svg, pp, this.zoom, this.chartType == StiHtmlChartType.AnimatedVector, doc);
        this.getGuid(chart);
        if (writer == null) {
            return StiXmlHelper.serialize((Document)doc);
        }
        writer.write(StiXmlHelper.serialize((Document)doc));
        return null;
    }

    public String prepareGaugeData(StiHtmlTextWriter writer, StiGauge gauge, double width, double height) throws ParserConfigurationException, IOException, TransformerException {
        float scale = 0.96f;
        StiXmlTextWriter xmlTextWriter = new StiXmlTextWriter();
        xmlTextWriter.writeStartDocument();
        this.prepareSvg(xmlTextWriter.getDocument(), StiMath.round((double)(height * (double)scale), (int)2), StiMath.round((double)(width * (double)scale), (int)2), xmlTextWriter);
        StiSvgExportService.StiSvgHelper.StiSvgData pp = new StiSvgExportService.StiSvgHelper.StiSvgData();
        pp.X = 0.0;
        pp.Y = 0.0;
        pp.Width = (float)(width * (double)scale);
        pp.Height = (float)(height * (double)scale);
        pp.Component = gauge;
        StiGaugeSvgHelper.writeGauge(xmlTextWriter, pp, this.zoom, this.chartType == StiHtmlChartType.AnimatedVector);
        this.getGuid(gauge);
        if (writer == null) {
            return StiXmlHelper.serialize((Document)xmlTextWriter.getDocument());
        }
        writer.write(StiXmlHelper.serialize((Document)xmlTextWriter.getDocument()));
        return null;
    }

    public String prepareMapData(StiHtmlTextWriter writer, StiMap map, double width, double height) throws Exception {
        StiXmlTextWriter xmlTextWriter = new StiXmlTextWriter();
        xmlTextWriter.writeStartDocument();
        float scale = 1.0f;
        this.prepareSvg(xmlTextWriter.getDocument(), StiMath.round((double)(height * (double)scale), (int)2), StiMath.round((double)(width * (double)scale), (int)2), xmlTextWriter);
        StiMapSvgHelper.drawMap(xmlTextWriter, map, width, height, this.chartType == StiHtmlChartType.AnimatedVector);
        this.getGuid(map);
        if (writer == null) {
            return StiXmlHelper.serialize((Document)xmlTextWriter.getDocument());
        }
        writer.write(StiXmlHelper.serialize((Document)xmlTextWriter.getDocument()));
        return null;
    }

    public String getChartScript() throws IOException {
        StiHtmlTextWriter tempHtmlWriter = this.htmlWriter;
        StringWriter sw = new StringWriter();
        BufferedWriter bw = new BufferedWriter(sw);
        this.htmlWriter = new StiHtmlTextWriter(bw);
        this.renderChartScripts(false);
        this.htmlWriter.flush();
        this.htmlWriter = tempHtmlWriter;
        sw.flush();
        sw.close();
        return sw.toString();
    }

    public void clear() {
        if (this.tableRender != null && this.tableRender.getMatrix() != null) {
            this.tableRender.getMatrix().clear();
            this.tableRender.setMatrix(null);
        }
        this.tableRender = null;
        this.coordX = null;
        this.coordY = null;
        this.styles = null;
    }

    @Override
    public void export(StiReport report, OutputStream outputStream, StiExportSettings exportSettings) throws StiException {
        this.exportHtml(report, outputStream, (StiHtmlExportSettings)exportSettings);
    }

    public void exportHtml(StiReport report, OutputStream stream, StiHtmlExportSettings settings) throws StiException {
        if (this.exFile != null) {
            this.fileName = this.exFile.getAbsolutePath();
        }
        BufferedWriter bufferedWriter = null;
        try {
            bufferedWriter = new BufferedWriter(new OutputStreamWriter(stream, settings.getEncoding()));
            this.htmlWriter = new StiHtmlTextWriter(bufferedWriter);
            StiPagesCollection pages = settings.getPageRange().getSelectedPages(report.getRenderedPages());
            this.exportHtml(report, this.htmlWriter, settings, pages);
            bufferedWriter.flush();
        }
        catch (Exception e) {
            try {
                throw new StiException("Error export Html", (Throwable)e);
            }
            catch (Throwable throwable) {
                StiCloseUtil.close(bufferedWriter);
                this.closeProgress();
                throw throwable;
            }
        }
        StiCloseUtil.close((Closeable)bufferedWriter);
        this.closeProgress();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void exportHtml(StiReport report, StiHtmlTextWriter writer, StiHtmlExportSettings settings, StiPagesCollection pages) throws Exception {
        if (settings == null) {
            throw new IllegalArgumentException("The 'settings' argument cannot be equal in null.");
        }
        this.zoom = settings.getZoom();
        this.imageFormat = settings.getImageFormat();
        this.exportQuality = settings.getExportQuality();
        StiHtmlExportMode exportMode = settings.getExportMode();
        boolean useBookmarks = settings.getExportBookmarksMode() != StiHtmlExportBookmarksMode.ReportOnly;
        int bookmarksWidth = settings.getBookmarksTreeWidth();
        boolean exportBookmarksOnly = settings.getExportBookmarksMode() == StiHtmlExportBookmarksMode.BookmarksOnly;
        this.useStylesTable = settings.isUseStylesTable();
        this.imageResolution = settings.getImageResolution();
        this.imageQuality = settings.getImageQuality();
        this.removeEmptySpaceAtBottom = settings.isRemoveEmptySpaceAtBottom();
        this.pageHorAlignment = settings.getPageHorAlignment();
        this.openLinksTarget = settings.getOpenLinksTarget();
        this.chartType = settings.getChartType();
        boolean modifyGradient = true;
        useBookmarks &= report.getBookmark() != null && report.getBookmark().getBookmarks().size() != 0;
        if (exportMode == StiHtmlExportMode.Span) {
            this.strSpanDiv = "span";
        } else if (exportMode == StiHtmlExportMode.Div) {
            this.strSpanDiv = "div";
        }
        this.fileStreamMode = StiValidationUtil.isNotNullOrEmpty((String)this.fileName);
        try {
            StiComponentsCollection components;
            if (this.htmlImageHost == null) {
                this.htmlImageHost = new StiHtmlImageHost(this);
            }
            this.htmlImageHost.setImageCache(new StiImageCache(ExportOptions.Html.getAllowImageComparer(), this.imageFormat, this.imageQuality));
            this.htmlWriter = writer;
            this.report = report;
            this.hashBookmarkGuid = new Hashtable();
            this.assembleGuidUsedInBookmark(report.getBookmark(), this.hashBookmarkGuid);
            this.totalPageWidth = 0.0;
            this.totalPageHeight = 0.0;
            this.startPage = 0.0;
            Hashtable<String, Integer> bookmarksPageIndex = new Hashtable<String, Integer>();
            if (useBookmarks) {
                int tempPageNumber = 0;
                for (StiPage page : pages) {
                    pages.GetPage(page);
                    components = page.getComponents();
                    for (StiComponent comp : components) {
                        if (!comp.getEnabled()) continue;
                        String bookmarkValue = comp.getBookmarkValue();
                        if (bookmarkValue == null) {
                            bookmarkValue = "";
                        }
                        if ("".equals(bookmarkValue = bookmarkValue.replace("'", "")) || bookmarksPageIndex.containsKey(bookmarkValue)) continue;
                        bookmarksPageIndex.put(bookmarkValue, tempPageNumber);
                    }
                    ++tempPageNumber;
                }
            }
            if (exportMode == StiHtmlExportMode.Span || exportMode == StiHtmlExportMode.Div) {
                boolean isDemo;
                StiComponentsCollection components2;
                StiHtmlTableRender tableRender = new StiHtmlTableRender(this, settings, new StiPagesCollection(report));
                if (this.isStoped()) {
                    return;
                }
                this.coordX = new TreeMap<Double, Double>();
                this.coordY = new TreeMap<Double, Double>();
                for (StiPage page : pages) {
                    this.totalPageWidth = Math.max(this.totalPageWidth, page.getUnit().ConvertToHInches(page.getWidth()));
                    this.totalPageHeight += page.getUnit().ConvertToHInches(page.getHeight());
                }
                for (StiPage page : pages) {
                    pages.GetPage(page);
                    components = page.getComponents();
                    StiRectangle pageRect = page.getUnit().ConvertToHInches(page.getClientRectangle());
                    for (StiComponent comp : components) {
                        StiRectangle rect = page.getUnit().ConvertToHInches(comp.getDisplayRectangle());
                        boolean needAdd = true;
                        if (comp instanceof StiPointPrimitive) {
                            needAdd = false;
                        }
                        if (rect.getRight() < pageRect.getLeft() || rect.getLeft() > pageRect.getRight() || rect.getBottom() < pageRect.getTop() || rect.getTop() > pageRect.getBottom()) {
                            needAdd = false;
                        }
                        if (!comp.getEnabled() || !needAdd) continue;
                        this.addCoord(new StiRectangle(comp.getDisplayRectangle()));
                    }
                }
                this.formatCoords(report);
                Hashtable<StiComponent, Object> styles = new Hashtable<StiComponent, Object>();
                Hashtable<String, String> cssStyles = new Hashtable<String, String>();
                for (StiPage page : pages) {
                    pages.GetPage(page);
                    components2 = page.getComponents();
                    block13: for (StiComponent compp : components2) {
                        String sTag;
                        StiComponent comp = compp;
                        if (!comp.getEnabled()) continue;
                        if (modifyGradient && !this.forceExportAsImage(comp)) {
                            StiText txt;
                            StiText stiText = txt = comp instanceof StiText ? (StiText)comp : null;
                            if (txt != null && txt.getBrush() != null && !(txt.getBrush() instanceof StiSolidBrush)) {
                                comp = (StiComponent)compp.clone();
                                ((StiText)comp).setBrush((StiBrush)new StiSolidBrush(StiColorEnum.Transparent.color()));
                            }
                        }
                        StiCellStyle cellStyle = tableRender.getMatrix().getStyleFromComponent(comp, -1, -1);
                        cellStyle.setAbsolutePosition(true);
                        if (!pages.getCacheMode()) {
                            styles.put(compp, cellStyle);
                        }
                        if (!StiValidationUtil.isNotNullOrEmpty((String)(sTag = comp.getTagValue()))) continue;
                        String[] sTagArray = StiMatrix.splitTag(sTag);
                        for (int index = 0; index < sTagArray.length; ++index) {
                            String[] stArr;
                            if (!sTagArray[index].toLowerCase().startsWith("css") || (stArr = StiMatrix.getStringsFromTag(sTagArray[index], 3)).length <= 1) continue;
                            String styleName = stArr[0].trim();
                            cssStyles.put(styleName, stArr[1].trim() + ";position:absolute;");
                            styles.put(compp, styleName);
                            continue block13;
                        }
                    }
                }
                tableRender.getMatrix().checkStylesNames();
                if (this.renderAsDocument) {
                    this.renderStartDoc(tableRender, false, useBookmarks, exportBookmarksOnly, cssStyles, pages, settings.getEncoding());
                }
                if (!this.renderAsDocument && useBookmarks) {
                    this.renderBookmarkScript();
                }
                if (useBookmarks) {
                    this.htmlWriter.writeBeginTag(this.strSpanDiv + " class=\"dtreeframe\" style=\"");
                    this.htmlWriter.writeStyleAttribute("position", "absolute");
                    if (!exportBookmarksOnly) {
                        this.htmlWriter.writeStyleAttribute("height", this.formatCoord(this.totalPageHeight * this.zoom * 0.75));
                    }
                    this.renderBookmarkTree(report.getBookmark(), bookmarksWidth, bookmarksPageIndex);
                    this.htmlWriter.writeEndTag(this.strSpanDiv);
                    this.htmlWriter.writeLine();
                }
                if (!exportBookmarksOnly) {
                    this.renderPage(pages, useBookmarks, bookmarksWidth, settings);
                }
                if (!this.renderAsDocument) {
                    tableRender.renderStyles(useBookmarks, exportBookmarksOnly, cssStyles);
                }
                this.setStatusString(StiLocalization.getValue((String)"Export", (String)"ExportingCreatingDocument"));
                if (!exportBookmarksOnly) {
                    for (StiPage page : pages) {
                        pages.GetPage(page);
                        this.invokeExporting(page, pages);
                        if (this.isStoped()) {
                            return;
                        }
                        components2 = page.getComponents();
                        StiRectangle pageRect = page.getUnit().ConvertToHInches(page.getClientRectangle());
                        Iterator i$ = components2.iterator();
                        while (i$.hasNext()) {
                            StiMap map;
                            String styleName;
                            int styleIndex;
                            StiCellStyle cellStyle;
                            StiComponent compp;
                            StiComponent comp = compp = (StiComponent)i$.next();
                            StiRectangle rect = page.getUnit().ConvertToHInches(comp.getDisplayRectangle());
                            boolean needAdd = true;
                            if (comp instanceof StiPointPrimitive) {
                                needAdd = false;
                            }
                            if (rect.getRight() < pageRect.getLeft() || rect.getLeft() > pageRect.getRight() || rect.getBottom() < pageRect.getTop() || rect.getTop() > pageRect.getBottom()) {
                                needAdd = false;
                            }
                            if (!comp.getEnabled() || !needAdd) continue;
                            if (modifyGradient && !this.forceExportAsImage(comp)) {
                                StiText txt;
                                StiText stiText = txt = comp instanceof StiText ? (StiText)comp : null;
                                if (txt != null && txt.getBrush() != null && !(txt.getBrush() instanceof StiSolidBrush)) {
                                    writer.writeBeginTag(this.strSpanDiv);
                                    writer.write(" style=\"");
                                    writer.write("");
                                    this.renderPosition(comp);
                                    writer.write("position:absolute;\">");
                                    StiText cont = new StiText();
                                    cont.setPage(page);
                                    cont.setClientRectangle(comp.getClientRectangle());
                                    cont.setBrush(((StiText)comp).getBrush());
                                    this.renderImage(cont);
                                    writer.writeEndTag(this.strSpanDiv);
                                    writer.writeLine("");
                                    comp = (StiComponent)compp.clone();
                                    ((StiText)comp).setBrush((StiBrush)new StiSolidBrush(StiColorEnum.Transparent.color()));
                                }
                            }
                            boolean isExportAsImage = comp.isExportAsImage(StiExportFormat.Html) || this.forceExportAsImage(comp);
                            boolean needHyperlink = false;
                            writer.writeBeginTag(this.strSpanDiv);
                            StiCellStyle stiCellStyle = cellStyle = styles.get(compp) instanceof StiCellStyle ? (StiCellStyle)styles.get(compp) : null;
                            if (cellStyle == null && pages.getCacheMode()) {
                                cellStyle = tableRender.getMatrix().getStyleFromComponent(compp, -1, -1);
                                cellStyle.setAbsolutePosition(true);
                            }
                            if ((styleIndex = tableRender.getMatrix().getStyles().indexOf(cellStyle)) != -1 && this.useStylesTable) {
                                writer.writeAttribute("class", "s" + cellStyle.getStyleName());
                            }
                            String string = styleName = styles.get(compp) instanceof String ? (String)styles.get(compp) : null;
                            if (StiValidationUtil.isNotNullOrEmpty((String)styleName) && this.useStylesTable) {
                                writer.writeAttribute("class", styleName);
                            }
                            if (exportMode == StiHtmlExportMode.Div) {
                                if (comp.getToolTipValue() != null) {
                                    writer.writeAttribute("title", comp.getToolTipValue());
                                }
                                if (cellStyle != null && cellStyle.getTextOptions() != null && !cellStyle.getTextOptions().getWordWrap()) {
                                    writer.write(" nowrap");
                                }
                            }
                            writer.write(" style=\"");
                            writer.write("");
                            this.renderPosition(comp);
                            if (!this.useStylesTable) {
                                if (styleIndex != -1) {
                                    tableRender.renderStyle(cellStyle);
                                }
                                if (StiValidationUtil.isNotNullOrEmpty((String)styleName)) {
                                    writer.writeLine(cssStyles.get(styleName) + ";overflow:hidden;");
                                }
                            }
                            StiChart chart = comp instanceof StiChart ? (StiChart)comp : null;
                            StiGauge gauge = comp instanceof StiGauge ? (StiGauge)comp : null;
                            StiMap stiMap = map = comp instanceof StiMap ? (StiMap)comp : null;
                            if (chart != null && this.chartType != StiHtmlChartType.Image) {
                                writer.write("\" ");
                                writer.writeAttribute("id", this.getGuid(chart));
                                writer.write(">");
                                this.prepareChartData(writer, chart, rect.width, rect.height);
                                needHyperlink = this.renderHyperlink(comp);
                                if (needHyperlink) {
                                    writer.writeEndTag("a");
                                }
                            } else if (gauge != null) {
                                writer.write("\" ");
                                writer.writeAttribute("id", this.getGuid(chart));
                                writer.write(">");
                                this.prepareGaugeData(writer, gauge, rect.width, rect.height);
                                needHyperlink = this.renderHyperlink(comp);
                                if (needHyperlink) {
                                    writer.writeEndTag("a");
                                }
                            } else if (map != null) {
                                writer.write("\" ");
                                writer.writeAttribute("id", this.getGuid(map));
                                writer.write(">");
                                this.prepareMapData(writer, map, rect.width, rect.height);
                                needHyperlink = this.renderHyperlink(comp);
                                if (needHyperlink) {
                                    writer.writeEndTag("a");
                                }
                            } else if (isExportAsImage) {
                                writer.write("\">");
                                needHyperlink = this.renderHyperlink(comp);
                                this.renderImage(comp);
                                if (needHyperlink) {
                                    writer.writeEndTag("a");
                                }
                            } else {
                                StiText stiText;
                                IStiTextOptions textOptions;
                                IStiTextOptions iStiTextOptions = textOptions = comp instanceof IStiTextOptions ? (IStiTextOptions)((Object)comp) : null;
                                if (textOptions != null) {
                                    this.renderTextDirection(null, textOptions.getTextOptions());
                                }
                                boolean isText = comp instanceof IStiText && !(comp instanceof StiRichText);
                                String text = null;
                                boolean needProcessPreserveWhiteSpaces = true;
                                if (isText) {
                                    text = ((IStiText)((Object)comp)).getTextInternal();
                                    if (ExportOptions.Html.isPreserveWhiteSpaces() && !StiValidationUtil.isNullOrWhiteSpace((String)text) && text.contains("  ")) {
                                        writer.write("white-space:pre-wrap;");
                                        needProcessPreserveWhiteSpaces = false;
                                    }
                                }
                                writer.write("\">");
                                needHyperlink = this.renderHyperlink(comp);
                                boolean needBr = true;
                                if (textOptions != null && !textOptions.getTextOptions().getWordWrap()) {
                                    if (isText) {
                                        if (text != null) {
                                            StiText stiText2 = stiText = comp instanceof StiText ? (StiText)comp : null;
                                            if (stiText != null && stiText.getTextQuality() == StiTextQuality.Wysiwyg && !StiValidationUtil.isNullOrEmpty((String)text) && text.endsWith(StiTextRenderer.StiForceWidthAlignTag)) {
                                                text = text.substring(0, text.length() - StiTextRenderer.StiForceWidthAlignTag.length());
                                            }
                                            if (stiText != null && stiText.getAllowHtmlTags()) {
                                                text = StiHtmlExportService.convertTextWithHtmlTagsToHtmlText(stiText, text, this.zoom);
                                            } else if (ExportOptions.Html.getReplaceSpecialCharacters()) {
                                                text = text.replace("&", "&amp;").replace("\"", "&quot;").replace("<", "&lt;").replace(">", "&gt;").replace("\\xA0", "&nbsp;");
                                            }
                                            if (ExportOptions.Html.getConvertDigitsToArabic() && textOptions.getTextOptions().getRightToLeft()) {
                                                text = StiBidirectionalConvert.convertDigitsToArabic((String)text, (StiArabicDigitsType)ExportOptions.Html.getArabicDigitsType());
                                            }
                                            writer.write(text);
                                        }
                                        needBr = false;
                                    }
                                } else if (comp instanceof IStiText && !(comp instanceof StiRichText)) {
                                    if (text != null) {
                                        StiText stiText3 = stiText = comp instanceof StiText ? (StiText)comp : null;
                                        if (stiText != null && stiText.getTextQuality() == StiTextQuality.Wysiwyg && !StiValidationUtil.isNullOrEmpty((String)text) && text.endsWith(StiTextRenderer.StiForceWidthAlignTag)) {
                                            text = text.substring(0, text.length() - StiTextRenderer.StiForceWidthAlignTag.length());
                                        }
                                        if (stiText != null && stiText.getAllowHtmlTags()) {
                                            text = StiHtmlExportService.convertTextWithHtmlTagsToHtmlText(stiText, text, this.zoom);
                                        } else {
                                            if (stiText != null && ExportOptions.Html.getForceWysiwygWordwrap() && !stiText.getAllowHtmlTags() && stiText.getTextQuality() == StiTextQuality.Wysiwyg && textOptions != null && textOptions.getTextOptions().getWordWrap()) {
                                                List<StiLineInfo> newTextLines = StiTextRenderer.getTextLines(text, stiText.getFont(), page.getUnit().ConvertToHInches(comp.ComponentToPage(comp.getClientRectangle())), textOptions.getTextOptions().getWordWrap());
                                                String delimiter = "\n";
                                                StringBuilder sb = new StringBuilder();
                                                for (int index = 0; index < newTextLines.size(); ++index) {
                                                    String st = newTextLines.get(index).getText();
                                                    sb.append(st);
                                                    if (index >= newTextLines.size() - 1) continue;
                                                    sb.append(delimiter);
                                                }
                                                text = sb.toString();
                                            }
                                            if (ExportOptions.Html.getReplaceSpecialCharacters()) {
                                                text = text.replace("&", "&amp;").replace("\"", "&quot;").replace("<", "&lt;").replace(">", "&gt;").replace(String.valueOf('\u00a0'), "&nbsp;");
                                            }
                                        }
                                        writer.write(this.prepareTextForHtml(text, needProcessPreserveWhiteSpaces));
                                    }
                                    needBr = false;
                                }
                                if (needHyperlink) {
                                    if (needBr) {
                                        writer.write("<br>");
                                    }
                                    writer.writeEndTag("a");
                                }
                            }
                            writer.writeEndTag(this.strSpanDiv);
                            writer.writeLine("");
                        }
                        writer.writeLine("<!-- end page -->");
                        this.startPage += (double)((int)page.getUnit().ConvertToHInches(page.getHeight()));
                    }
                }
                boolean bl = isDemo = !StiLicenseKeyValidator.isValidOnJavaFramework(null);
                if (pages.size() > 0 && isDemo) {
                    StiRectangle rectPage = pages.get(0).getUnit().ConvertToHInches(pages.get(0).getClientRectangle());
                    double fontSize = (int)(100.0 * this.zoom);
                    writer.writeLine(String.format("<div style=\"position: absolute; pointer-events: none; filter: alpha(Opacity=30); opacity: 0.3;-moz-opacity: 0.3; -khtml-opacity: 0.3; font-size: %spx; font-weight: bold; width: %s; margin-top: %s; text-align: center;font-family: Arial; color: black; z-index: 9999; -ms-transform: rotate(-45deg); -webkit-transform: rotate(-45deg); transform: rotate(-45deg);\">%s</div>", fontSize, StiHtmlUnit.newUnit(rectPage.width * this.zoom, ExportOptions.Html.isPrintLayoutOptimization()), StiHtmlUnit.newUnit(rectPage.height * this.zoom / 2.0 - fontSize, ExportOptions.Html.isPrintLayoutOptimization()), "Trial"));
                }
                this.renderEndPage();
                if (this.renderAsDocument) {
                    this.renderChartScripts(true);
                }
                if (this.renderAsDocument) {
                    this.renderEndDoc();
                }
            }
            if (exportMode == StiHtmlExportMode.Table) {
                this.tableRender = new StiHtmlTableRender(this, settings, pages);
                if (this.isStoped()) {
                    return;
                }
                Hashtable<String, String> cssStyles = new Hashtable<String, String>();
                boolean[][] readyCells = new boolean[this.tableRender.getMatrix().getCoordY().size()][this.tableRender.getMatrix().getCoordX().size()];
                for (int rowIndex = 1; rowIndex < this.tableRender.getMatrix().getCoordY().size(); ++rowIndex) {
                    block19: for (int columnIndex = 1; columnIndex < this.tableRender.getMatrix().getCoordX().size(); ++columnIndex) {
                        String sTag;
                        StiCell cell;
                        if (readyCells[rowIndex - 1][columnIndex - 1] || (cell = this.tableRender.getMatrix().getCells()[rowIndex - 1][columnIndex - 1]) == null) continue;
                        for (int yy = 0; yy <= cell.getHeight(); ++yy) {
                            for (int xx = 0; xx <= cell.getWidth(); ++xx) {
                                readyCells[rowIndex - 1 + yy][columnIndex - 1 + xx] = true;
                            }
                        }
                        if (cell.getComponent() == null || !StiValidationUtil.isNotNullOrEmpty((String)(sTag = cell.getComponent().getTagValue()))) continue;
                        String[] sTagArray = StiMatrix.splitTag(sTag);
                        for (int index = 0; index < sTagArray.length; ++index) {
                            String[] stArr;
                            if (!sTagArray[index].toLowerCase().startsWith("css") || (stArr = StiMatrix.getStringsFromTag(sTagArray[index], 3)).length <= 1) continue;
                            String styleName = stArr[0].trim();
                            cssStyles.put(styleName, stArr[1].trim());
                            continue block19;
                        }
                    }
                }
                if (this.renderAsDocument) {
                    this.renderStartDoc(this.tableRender, true, useBookmarks, exportBookmarksOnly, cssStyles, pages, settings.getEncoding());
                }
                if (!this.renderAsDocument && useBookmarks) {
                    this.renderBookmarkScript();
                }
                if (useBookmarks) {
                    this.htmlWriter.writeBeginTag("table");
                    if (this.pageHorAlignment != StiHorAlignment.Left) {
                        this.htmlWriter.writeAttribute("width", "100%");
                    }
                    this.htmlWriter.write(">");
                    this.htmlWriter.writeBeginTag("tr");
                    this.htmlWriter.write(">");
                    this.htmlWriter.writeBeginTag("td class=\"dtreeframe\" style=\"");
                    this.htmlWriter.writeStyleAttribute("vertical-align", "top");
                    this.renderBookmarkTree(report.getBookmark(), bookmarksWidth, bookmarksPageIndex);
                    this.htmlWriter.writeEndTag("td");
                    this.htmlWriter.writeLine();
                    this.htmlWriter.writeBeginTag("td");
                    this.htmlWriter.writeLine(">");
                    this.htmlWriter.incIndent();
                }
                if (pages.size() > 0 && !StiLicenseKeyValidator.isValidOnJavaFramework(null)) {
                    StiRectangle rectPage = pages.get(0).getUnit().ConvertToHInches(pages.get(0).getClientRectangle());
                    double fontSize = (int)(100.0 * this.zoom);
                    writer.writeLine(String.format("<div style=\"position: absolute; pointer-events: none; filter: alpha(Opacity=30); opacity: 0.3; -moz-opacity: 0.3; -khtml-opacity: 0.3; font-size: %spx; font-weight: bold; width: %s; margin-top: %s; text-align: center; font-family: Arial; color: black; z-index: 9999; -ms-transform: rotate(-45deg); -webkit-transform: rotate(-45deg); transform: rotate(-45deg);\">%s</div>", fontSize, StiHtmlUnit.newUnit(rectPage.width * this.zoom, ExportOptions.Html.isPrintLayoutOptimization()), StiHtmlUnit.newUnit(rectPage.height * this.zoom / 2.0 - fontSize, ExportOptions.Html.isPrintLayoutOptimization()), "Trial"));
                }
                if (!exportBookmarksOnly) {
                    this.tableRender.renderTable(!this.renderAsDocument && this.renderStyles, this.getBackgroundImagePath(pages, this.zoom, settings), useBookmarks, exportBookmarksOnly, cssStyles);
                }
                if (this.isStoped()) {
                    return;
                }
                if (useBookmarks) {
                    this.htmlWriter.decIndent();
                    this.htmlWriter.writeEndTag("td");
                    this.htmlWriter.writeEndTag("tr");
                    this.htmlWriter.writeEndTag("table");
                    this.htmlWriter.writeLine();
                }
                if (this.renderAsDocument) {
                    this.renderChartScripts(true);
                }
                if (this.renderAsDocument) {
                    this.renderEndDoc();
                }
            }
        }
        finally {
            writer.flush();
            if (this.clearOnFinish) {
                this.clear();
            }
        }
    }

    public boolean isUseStylesTable() {
        return this.useStylesTable;
    }

    public void setUseStylesTable(boolean useStylesTable) {
        this.useStylesTable = useStylesTable;
    }

    public double getZoom() {
        return this.zoom;
    }

    public void setZoom(double zoom) {
        this.zoom = zoom;
    }

    public StiHtmlExportQuality getExportQuality() {
        return this.exportQuality;
    }

    public void setExportQuality(StiHtmlExportQuality exportQuality) {
        this.exportQuality = exportQuality;
    }

    public Hashtable<Object, Object> getInteractionComponents() {
        return this.interactionComponents;
    }

    public void setInteractionComponents(Hashtable<Object, Object> interactionComponents) {
        this.interactionComponents = interactionComponents;
    }

    public float getImageQuality() {
        return this.imageQuality;
    }

    public void setImageQuality(float imageQuality) {
        this.imageQuality = imageQuality;
    }

    public float getImageResolution() {
        return this.imageResolution;
    }

    public void setImageResolution(float imageResolution) {
        this.imageResolution = imageResolution;
    }

    public StiHtmlImageHost getHtmlImageHost() {
        return this.htmlImageHost;
    }

    public void setHtmlImageHost(StiHtmlImageHost htmlImageHost) {
        this.htmlImageHost = htmlImageHost;
    }

    public StiReport getReport() {
        return this.report;
    }

    public void setReport(StiReport report) {
        this.report = report;
    }

    public StiHtmlTextWriter getHtmlWriter() {
        return this.htmlWriter;
    }

    public void setHtmlWriter(StiHtmlTextWriter htmlWriter) {
        this.htmlWriter = htmlWriter;
    }

    public ArrayList<StiCellStyle> getStyles() {
        return this.styles;
    }

    public void setStyles(ArrayList<StiCellStyle> styles) {
        this.styles = styles;
    }

    public StiImageFormat getImageFormat() {
        return this.imageFormat;
    }

    public boolean isFileStreamMode() {
        return this.fileStreamMode;
    }

    public void setFileStreamMode(boolean fileStreamMode) {
        this.fileStreamMode = fileStreamMode;
    }

    public String getFileName() {
        return this.fileName;
    }

    @Override
    public StiExportFormat getExportFormat() {
        return StiExportFormat.Html;
    }

    public StiHtmlTableRender getTableRender() {
        return this.tableRender;
    }

    public boolean isRenderAsDocument() {
        return this.renderAsDocument;
    }

    public void setRenderAsDocument(boolean renderAsDocument) {
        this.renderAsDocument = renderAsDocument;
    }

    public boolean isClearOnFinish() {
        return this.clearOnFinish;
    }

    public void setClearOnFinish(boolean clearOnFinish) {
        this.clearOnFinish = clearOnFinish;
    }

    public boolean isRenderStyles() {
        return this.renderStyles;
    }

    public void setRenderStyles(boolean renderStyles) {
        this.renderStyles = renderStyles;
    }

    public boolean isRemoveEmptySpaceAtBottom() {
        return this.removeEmptySpaceAtBottom;
    }

    public StiHorAlignment getPageHorAlignment() {
        return this.pageHorAlignment;
    }

    @Override
    public boolean getMultipleFiles() {
        return false;
    }

    private class StiBookmarkTreeNode {
        private int Parent;
        private String Title;
        private String Url;

        private StiBookmarkTreeNode() {
        }
    }
}

