/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.report.export.service;

import com.stimulsoft.base.IStiEnum;
import com.stimulsoft.base.StiEnumSet;
import com.stimulsoft.base.drawing.StiAdvancedBorder;
import com.stimulsoft.base.drawing.StiBorder;
import com.stimulsoft.base.drawing.StiBorderSide;
import com.stimulsoft.base.drawing.StiBrush;
import com.stimulsoft.base.drawing.StiColor;
import com.stimulsoft.base.drawing.StiColorEnum;
import com.stimulsoft.base.drawing.StiHtmlState;
import com.stimulsoft.base.drawing.StiHtmlTagsState;
import com.stimulsoft.base.drawing.StiTextRendererParseHtml;
import com.stimulsoft.base.drawing.enums.StiBorderSides;
import com.stimulsoft.base.drawing.enums.StiPenStyle;
import com.stimulsoft.base.drawing.enums.StiTextHorAlignment;
import com.stimulsoft.base.drawing.enums.StiVertAlignment;
import com.stimulsoft.base.enums.StiArabicDigitsType;
import com.stimulsoft.base.exception.StiException;
import com.stimulsoft.base.localization.StiLocalization;
import com.stimulsoft.base.system.StiFont;
import com.stimulsoft.base.utils.StiBidirectionalConvert;
import com.stimulsoft.base.utils.StiCharsetHelper;
import com.stimulsoft.base.utils.StiMath;
import com.stimulsoft.lib.utils.StiStringUtil;
import com.stimulsoft.lib.utils.StiValidationUtil;
import com.stimulsoft.report.StiReport;
import com.stimulsoft.report.components.StiComponent;
import com.stimulsoft.report.components.StiMargins;
import com.stimulsoft.report.components.StiPage;
import com.stimulsoft.report.components.StiPagesCollection;
import com.stimulsoft.report.components.enums.StiPageOrientation;
import com.stimulsoft.report.components.enums.StiPrintOnType;
import com.stimulsoft.report.components.enums.StiTextQuality;
import com.stimulsoft.report.components.interfaces.IStiBorder;
import com.stimulsoft.report.components.interfaces.IStiBreakable;
import com.stimulsoft.report.components.interfaces.IStiBrush;
import com.stimulsoft.report.components.interfaces.IStiExportImage;
import com.stimulsoft.report.components.interfaces.IStiExportImageExtended;
import com.stimulsoft.report.components.interfaces.IStiFont;
import com.stimulsoft.report.components.interfaces.IStiHorAlignment;
import com.stimulsoft.report.components.interfaces.IStiIgnoreBorderWhenExport;
import com.stimulsoft.report.components.interfaces.IStiText;
import com.stimulsoft.report.components.interfaces.IStiTextBrush;
import com.stimulsoft.report.components.interfaces.IStiTextHorAlignment;
import com.stimulsoft.report.components.interfaces.IStiTextOptions;
import com.stimulsoft.report.components.interfaces.IStiVertAlignment;
import com.stimulsoft.report.components.shapeTypes.StiDiagonalDownLineShapeType;
import com.stimulsoft.report.components.shapeTypes.StiDiagonalUpLineShapeType;
import com.stimulsoft.report.components.shapeTypes.StiHorizontalLineShapeType;
import com.stimulsoft.report.components.shapeTypes.StiLeftAndRightLineShapeType;
import com.stimulsoft.report.components.shapeTypes.StiOvalShapeType;
import com.stimulsoft.report.components.shapeTypes.StiRectangleShapeType;
import com.stimulsoft.report.components.shapeTypes.StiTopAndBottomLineShapeType;
import com.stimulsoft.report.components.shapeTypes.StiVerticalLineShapeType;
import com.stimulsoft.report.components.simplecomponents.StiImageHelper;
import com.stimulsoft.report.components.simplecomponents.StiRichText;
import com.stimulsoft.report.components.simplecomponents.StiShape;
import com.stimulsoft.report.components.simplecomponents.StiText;
import com.stimulsoft.report.enums.StiExportFormat;
import com.stimulsoft.report.export.StiSegmentPagesDivider;
import com.stimulsoft.report.export.service.StiExportService;
import com.stimulsoft.report.export.settings.StiExportSettings;
import com.stimulsoft.report.export.settings.StiRtfExportSettings;
import com.stimulsoft.report.export.tools.StiCell;
import com.stimulsoft.report.export.tools.StiCellStyle;
import com.stimulsoft.report.export.tools.StiEncode;
import com.stimulsoft.report.export.tools.StiExportUtils;
import com.stimulsoft.report.export.tools.StiImageFormat;
import com.stimulsoft.report.export.tools.StiMapUtil;
import com.stimulsoft.report.export.tools.StiMatrix;
import com.stimulsoft.report.export.tools.StiPagesRange;
import com.stimulsoft.report.export.tools.StiRtfExportMode;
import com.stimulsoft.report.export.tools.StiTextRenderer;
import com.stimulsoft.report.expressions.StiExpression;
import com.stimulsoft.report.options.ExportOptions;
import java.awt.image.BufferedImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.SortedMap;
import java.util.TreeMap;

public class StiRtfExportService
extends StiExportService {
    final double HI_TO_TWIPS = 14.4;
    private Writer sw = null;
    private ArrayList<StiColor> colorList = null;
    private ArrayList<StiFont> fontList = null;
    private ArrayList<StiRtfStyleInfo> styleList = null;
    private int[] unicodeMapArray = null;
    private byte[] codePageToFont = null;
    private byte charsetCount = 0;
    private int[] fontToCodePages = null;
    private int baseFontNumber = 0;
    private OutputStream sw2 = null;
    private Boolean usePageHeadersAndFooters = false;
    private float imageResolution = 0.96f;
    private float imageQuality = 0.75f;
    private StiExportFormat imageFormat = StiExportFormat.Rtf;
    private Boolean useStyles = false;
    private Hashtable<String, String> bookmarkList = null;
    private Hashtable<String, String> usedBookmarks = null;
    private Boolean removeEmptySpaceAtBottom = ExportOptions.Rtf.getRemoveEmptySpaceAtBottom();
    final int frameCorrectValue = 38;
    private int pageHeight;
    private int pageWidth;
    private StiMatrix matrix = null;

    private Integer getColorNumberInt(ArrayList<StiColor> tmpColorList, StiColor incomingColor) {
        if (tmpColorList.size() > 0) {
            for (int index = 0; index < tmpColorList.size(); ++index) {
                if (!tmpColorList.get(index).equals(incomingColor)) continue;
                return index;
            }
        }
        tmpColorList.add(incomingColor);
        int temp = tmpColorList.size() - 1;
        return temp;
    }

    private String getColorNumber(ArrayList<StiColor> tmpColorList, StiColor incomingColor) {
        return this.getColorNumberInt(tmpColorList, incomingColor).toString();
    }

    private Integer getFontNumber(ArrayList<StiFont> tmpFontList, StiFont incomingFont) {
        if (tmpFontList.size() > 0) {
            for (int index = 0; index < tmpFontList.size(); ++index) {
                StiFont tmpFont = tmpFontList.get(index);
                if (!tmpFont.getName().equals(incomingFont.getName())) continue;
                return index * (this.charsetCount == 0 ? (byte)1 : this.charsetCount);
            }
        }
        tmpFontList.add(incomingFont);
        int temp = tmpFontList.size() - 1;
        return temp * (this.charsetCount == 0 ? (byte)1 : this.charsetCount);
    }

    private Integer getFontNumber(ArrayList<StiFont> tmpFontList, StiFont incomingFont, int charset) {
        if (tmpFontList.size() > 0) {
            for (int index = 0; index < tmpFontList.size(); ++index) {
                StiFont tmpFont = tmpFontList.get(index);
                if (!tmpFont.getName().equals(incomingFont.getName())) continue;
                return index * (this.charsetCount == 0 ? (byte)1 : this.charsetCount) + this.getCharsetIndex(charset);
            }
        }
        tmpFontList.add(incomingFont);
        int temp = tmpFontList.size() - 1;
        return temp * (this.charsetCount == 0 ? (byte)1 : this.charsetCount) + this.getCharsetIndex(charset);
    }

    private int getCharsetIndex(int charset) {
        int charsetIndex = 0;
        for (int index = 0; index < StiEncode.codePagesTableSize; ++index) {
            if (StiEncode.codePagesTable[index][2] != charset) continue;
            charsetIndex = index + 1;
            break;
        }
        if (this.charsetCount == 0) {
            this.codePageToFont[charsetIndex] = 1;
            return 0;
        }
        return this.codePageToFont[charsetIndex];
    }

    private int getFontNumber(ArrayList<StiFont> tmpFontList, String fontName) {
        if (tmpFontList.size() > 0) {
            for (int index = 0; index < tmpFontList.size(); ++index) {
                StiFont tmpFont = tmpFontList.get(index);
                if (!tmpFont.getName().equals(fontName)) continue;
                return index * (this.charsetCount == 0 ? (byte)1 : this.charsetCount);
            }
        }
        tmpFontList.add(new StiFont(fontName, 8.0));
        int temp = tmpFontList.size() - 1;
        return temp * (this.charsetCount == 0 ? (byte)1 : this.charsetCount);
    }

    private int getStyleNumber(ArrayList<StiRtfStyleInfo> tmpStyleList, StiRtfStyleInfo styleInfo) {
        if (tmpStyleList.size() > 0) {
            for (int index = 0; index < tmpStyleList.size(); ++index) {
                StiRtfStyleInfo tmpStyle = tmpStyleList.get(index);
                if (tmpStyle.alignment != styleInfo.alignment || !tmpStyle.name.equals(styleInfo.name) || tmpStyle.fontNumber != styleInfo.fontNumber || tmpStyle.fontSize != styleInfo.fontSize || tmpStyle.bold != styleInfo.bold || tmpStyle.italic != styleInfo.italic || tmpStyle.underline != styleInfo.underline || tmpStyle.textColor != styleInfo.textColor || tmpStyle.rightToLeft != styleInfo.rightToLeft) continue;
                return index + 1;
            }
        }
        tmpStyleList.add(styleInfo);
        int temp = tmpStyleList.size() - 1;
        return temp + 1;
    }

    private String getLineStyle(StiBorderSide border, ArrayList<StiColor> colorList) {
        StringBuilder sb = new StringBuilder();
        if (border != null && border.getStyle() != StiPenStyle.None) {
            switch (border.getStyle()) {
                case Solid: {
                    sb.append("\\brdrs");
                    break;
                }
                case Dot: {
                    sb.append("\\brdrdot");
                    break;
                }
                case Dash: {
                    sb.append("\\brdrdash");
                    break;
                }
                case DashDot: {
                    sb.append("\\brdrdashd");
                    break;
                }
                case DashDotDot: {
                    sb.append("\\brdrdashdd");
                    break;
                }
                case Double: {
                    sb.append("\\brdrdb");
                }
            }
            sb.append("\\brdrw");
            sb.append((int)(border.getSize() * 15.0));
            sb.append(String.format("\\brdrcf%s", this.getColorNumber(colorList, border.getColor())));
        }
        return sb.toString();
    }

    private String convertStringToBookmark(String inputString) {
        StringBuilder sbOutput = new StringBuilder();
        for (char ch : inputString.toCharArray()) {
            if (!Character.isLetterOrDigit(ch)) continue;
            sbOutput.append(ch);
        }
        return sbOutput.toString();
    }

    private Boolean compareExcellSheetNames(String name1, String name2) {
        String st2;
        String st1 = name1;
        if (st1 == null || st1.length() == 0) {
            st1 = "";
        }
        if ((st2 = name2) == null || st2.length() == 0) {
            st2 = "";
        }
        return st1.equals(st2);
    }

    private String convertTextWithHtmlTagsToRtfText(StiText stiText, String text) {
        return this.convertTextWithHtmlTagsToRtfText(stiText.getFont(), stiText.getTextBrush(), stiText.getHorAlignment(), text);
    }

    public String convertTextWithHtmlTagsToRtfText(StiFont font, StiBrush textBrush, StiTextHorAlignment horAlignment, String text) {
        String inputText = text;
        StiHtmlTagsState baseTagsState = new StiHtmlTagsState(font.bold(), font.italic(), font.underline(), font.strikeout(), (float)font.getSize(), font.getName(), StiBrush.ToColor((StiBrush)textBrush), StiBrush.ToColor((StiBrush)textBrush), false, false, 0.0, 0.0, 1.0, horAlignment);
        StiHtmlState baseState = new StiHtmlState(baseTagsState, 0);
        List statesList = StiTextRendererParseHtml.parseHtmlToStates((String)inputText, (StiHtmlState)baseState.clone());
        this.baseFontNumber = this.getFontNumber(this.fontList, font);
        StringBuilder finalText = new StringBuilder(StiRtfExportService.getLineHeightInTwips(1.0));
        StiHtmlTagsState prevState = baseTagsState;
        for (int index = 0; index < statesList.size(); ++index) {
            StiHtmlState htmlState = (StiHtmlState)statesList.get(index);
            StiHtmlTagsState state = htmlState.ts;
            StringBuilder outputText = new StringBuilder();
            String storedTextAlign = null;
            if (state.isBold() != prevState.isBold()) {
                outputText.append(state.isBold() ? "\\b" : "\\b0");
            }
            if (state.isItalic() != prevState.isItalic()) {
                outputText.append(state.isItalic() ? "\\i" : "\\i0");
            }
            if (state.isUnderline() != prevState.isUnderline()) {
                outputText.append(state.isUnderline() ? "\\ul" : "\\ul0");
            }
            if (state.isStrikeout() != prevState.isStrikeout()) {
                outputText.append(state.isStrikeout() ? "\\strike" : "\\strike0");
            }
            if (state.isSuperscript() != prevState.isSuperscript()) {
                outputText.append(state.isSuperscript() ? "\\super" : "\\nosupersub");
            }
            if (state.isSubscript() != prevState.isSubscript()) {
                outputText.append(state.isSubscript() ? "\\sub" : "\\nosupersub");
            }
            if (!state.getFontColor().equals(prevState.getFontColor())) {
                outputText.append(String.format("\\cf%s", this.getColorNumberInt(this.colorList, state.getFontColor())));
            }
            if (!state.getBackColor().equals(prevState.getBackColor())) {
                outputText.append(String.format("\\highlight%s", this.getColorNumber(this.colorList, state.getBackColor())));
            }
            if (state.getFontSize() != prevState.getFontSize()) {
                outputText.append(String.format("\\fs%s", (int)(state.getFontSize() * 2.0f)));
            }
            if (state.getLetterSpacing() != prevState.getLetterSpacing()) {
                outputText.append(String.format("\\expnd%s", (int)(state.getLetterSpacing() * (double)state.getFontSize() * 3.8 + (double)ExportOptions.Rtf.getSpaceBetweenCharacters())));
            }
            if (state.getLineHeight() != prevState.getLineHeight()) {
                outputText.append(StiRtfExportService.getLineHeightInTwips(state.getLineHeight()));
            }
            if (state.getTextAlign() != prevState.getTextAlign()) {
                String textAlign = "\\ql";
                if (state.getTextAlign() == StiTextHorAlignment.Center) {
                    textAlign = "\\qc";
                }
                if (state.getTextAlign() == StiTextHorAlignment.Right) {
                    textAlign = "\\qr";
                }
                if (state.getTextAlign() == StiTextHorAlignment.Width) {
                    textAlign = "\\qj";
                }
                if ("\n".equals(htmlState.getText().toString())) {
                    storedTextAlign = textAlign;
                } else {
                    outputText.append(textAlign);
                }
            }
            if (!state.getFontName().equals(prevState.getFontName())) {
                this.baseFontNumber = this.getFontNumber(this.fontList, state.getFontName());
                outputText.append(String.format("%s%s", "\u0010", Character.valueOf((char)(256 + this.baseFontNumber))));
            }
            if (outputText.length() > 0) {
                finalText.append(outputText.toString().replaceAll("\\\\", "\u0017"));
                finalText.append(" ");
            }
            if ("\n".equals(htmlState.getText().toString())) {
                finalText.append("\n");
                if (storedTextAlign != null) {
                    finalText.append(storedTextAlign.replaceAll("\\", "\u0017"));
                }
            } else {
                if (finalText.charAt(finalText.length() - 1) != ' ' && finalText.charAt(finalText.length() - 1) != '\n') {
                    finalText.append(" ");
                }
                finalText.append((CharSequence)htmlState.getText());
            }
            prevState = state;
        }
        return finalText.toString().replaceAll("&nbsp;", "\u00a0").replaceAll("&lt;", "<").replaceAll("&gt;", ">").replaceAll("&quot;", "\"").replaceAll("&amp;", "&");
    }

    private static String getLineHeightInTwips(double lineHeightScale) {
        double correctLineHeight = ExportOptions.Rtf.getLineSpacing();
        return String.format("%ssl%s%sslmult1", "\u0017", Math.round(240.0 * correctLineHeight * lineHeightScale), "\u0017");
    }

    public static String getRtfFileFromHtmlTags(StiText stiText, String text) throws StiException, IOException {
        StiText clone = (StiText)stiText.clone();
        clone.setBorder(new StiBorder());
        clone.setLeft(0.0);
        clone.setTop(0.0);
        clone.setText(new StiExpression(text));
        clone.setTagValue("rtfparagraph");
        ByteArrayOutputStream ms = new ByteArrayOutputStream();
        StiReport tempReport = new StiReport();
        StiPage page = new StiPage(tempReport);
        page.getComponents().add(clone);
        tempReport.getRenderedPages().clear();
        tempReport.getRenderedPages().add(page);
        StiRtfExportService service = new StiRtfExportService();
        StiRtfExportSettings settings = new StiRtfExportSettings();
        settings.setExportMode(StiRtfExportMode.Table);
        service.exportRtf(tempReport, ms, settings);
        return ms.toString(StiCharsetHelper.WINDOWS_1252.name());
    }

    private String replacePardInRtf(String st) {
        StringBuilder sb = new StringBuilder();
        int counter = 0;
        int limit = 0;
        Boolean waitLimit = false;
        int pos = 0;
        while (pos < st.length()) {
            char ch = st.charAt(pos++);
            sb.append(ch);
            if (ch == '{') {
                ++counter;
                continue;
            }
            if (ch == '}') {
                if (--counter >= limit) continue;
                waitLimit = false;
                continue;
            }
            if (ch != '\\') continue;
            if (pos < st.length() && (st.charAt(pos) == '{' || st.charAt(pos) == '}')) {
                ++pos;
                continue;
            }
            if (pos + 2 < st.length() && st.charAt(pos) == 's' && st.charAt(pos + 1) == 'h' && st.charAt(pos + 2) == 'p' && st.charAt(pos - 2) == '{') {
                waitLimit = true;
                limit = counter;
            }
            if (waitLimit.booleanValue() || pos + 3 >= st.length() || st.charAt(pos) != 'p' || st.charAt(pos + 1) != 'a' || st.charAt(pos + 2) != 'r' || st.charAt(pos + 3) != 'd') continue;
            pos += 4;
            sb.append("pard\\intbl");
        }
        return sb.toString();
    }

    private String getImageString(BufferedImage image, float zoom, int absw, int absh) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        String blipName = "jpeg";
        if (this.imageFormat == StiExportFormat.ImagePng) {
            blipName = "png";
            StiImageHelper.saveWithDPI(image, out, StiImageFormat.Png, (Integer)72, this.imageQuality);
        } else {
            StiImageHelper.saveWithDPI(image, out, StiImageFormat.Jpeg, (Integer)72, this.imageQuality);
        }
        byte[] bytes = out.toByteArray();
        out.close();
        StringBuilder sb = new StringBuilder(bytes.length * 2 + 200);
        sb.append("{" + String.format("\\pict\\picscalex%s\\picscaley%s\\picwgoal%s\\pichgoal%s\\%blip ", 100, 100, absw, absh, blipName));
        for (int index = 0; index < bytes.length; ++index) {
            String hex = Integer.toHexString(0xFF & bytes[index]);
            sb.append(hex.length() == 1 ? "0" + hex : hex);
        }
        sb.append("}");
        return sb.toString();
    }

    private void drawLine(int tX1, int tY1, int tX2, int tY2, StiColor tColor, String stBorderWidth) throws IOException {
        if (tColor.getA() != 0) {
            this.sw.write("{\\shp{\\*");
            this.sw.write(String.format("\\shpinst\\shpleft%s\\shptop%s\\shpright%s\\shpbottom%s", tX1 < tX2 ? tX1 : tX2, tY1 < tY2 ? tY1 : tY2, tX1 > tX2 ? tX1 : tX2, tY1 > tY2 ? tY1 : tY2));
            this.sw.write("\\shpwr3");
            this.sw.write("{\\sp{\\sn shapeType}{\\sv 20}}");
            this.sw.write("{\\sp{\\sn fFlipH}{\\sv " + (tX1 < tX2 ? "0" : "1") + "}}");
            this.sw.write("{\\sp{\\sn fFlipV}{\\sv " + (tY1 < tY2 ? "0" : "1") + "}}");
            this.sw.write("{\\sp{\\sn fFilled}{\\sv 0}}");
            this.sw.write("{\\sp{\\sn lineColor}{\\sv " + String.format("%s", tColor.getB() * 65536 + tColor.getG() * 256 + tColor.getR()) + "}}");
            this.sw.write("{\\sp{\\sn lineWidth}{\\sv " + stBorderWidth + "}}");
            this.sw.write("{\\sp{\\sn fLine}{\\sv 1}}");
            this.sw.write("}}\r\n");
        }
    }

    private void fillRect(StiRtfData pp, StiColor tColor) throws IOException {
        if (tColor.getA() != 0) {
            this.sw.write("{\\shp{\\*");
            this.sw.write(String.format("\\shpinst\\shpleft%s\\shptop%s\\shpright%s\\shpbottom%s", pp.x, pp.y, pp.x + pp.width, pp.y + pp.height));
            this.sw.write("\\shpwr3");
            this.sw.write("{\\sp{\\sn shapeType}{\\sv 1}}");
            this.sw.write("{\\sp{\\sn fFlipH}{\\sv 0}}");
            this.sw.write("{\\sp{\\sn fFlipV}{\\sv 0}}");
            this.sw.write("{\\sp{\\sn fillColor}{\\sv " + String.format("%s", tColor.getB() * 65536 + tColor.getG() * 256 + tColor.getR()) + "}}");
            this.sw.write("{\\sp{\\sn fFilled}{\\sv 1}}");
            this.sw.write("{\\sp{\\sn fLine}{\\sv 0}}");
            this.sw.write("}}\r\n");
        }
    }

    private Boolean checkShape1(StiShape shape) {
        if (shape.getShapeType() instanceof StiVerticalLineShapeType || shape.getShapeType() instanceof StiHorizontalLineShapeType || shape.getShapeType() instanceof StiTopAndBottomLineShapeType || shape.getShapeType() instanceof StiLeftAndRightLineShapeType || shape.getShapeType() instanceof StiRectangleShapeType) {
            return true;
        }
        return false;
    }

    private void renderShape1(StiRtfData pp, int correctX, int correctW) throws IOException {
        StiShape shape;
        StiComponent component = pp.component;
        StiShape stiShape = shape = component instanceof StiShape ? (StiShape)component : null;
        if (shape != null) {
            if (this.checkShape1(shape).booleanValue()) {
                IStiBrush mBrush = component instanceof IStiBrush ? (IStiBrush)((Object)component) : null;
                String stBrush = "";
                StiColor tempColor = StiColorEnum.Transparent.color();
                if (mBrush != null) {
                    tempColor = StiBrush.ToColor((StiBrush)mBrush.getBrush());
                }
                if (tempColor.getA() != 0) {
                    String tempColorSt = this.getColorNumber(this.colorList, tempColor);
                    stBrush = String.format("\\cbpat%s", tempColorSt);
                }
                String stBorder = "";
                StiColor tempColor2 = shape.getBorderColor();
                if (tempColor2.getA() != 0) {
                    String tempColor2St = this.getColorNumber(this.colorList, tempColor2);
                    stBorder = String.format("\\brdrcf%s", tempColor2St);
                }
                int borderWidth = (int)(shape.getSize() * 14.0);
                String stBorderWidth = String.format("\\brdrs\\brdrw%s", borderWidth);
                this.sw.write("\\fs1");
                if (shape.getShapeType() instanceof StiVerticalLineShapeType) {
                    if (tempColor.getA() != 0) {
                        this.sw.write(stBrush);
                    }
                    if (tempColor2.getA() != 0) {
                        this.sw.write(" \\par}\r\n");
                        this.sw.write("{");
                        this.sw.write(String.format("\\nowrap\\posx%s\\posy%s\\absw%s\\absh%s", pp.x + correctX, pp.y, (pp.width - 76 - borderWidth) / 2, pp.height));
                        this.sw.write("\\brdrr" + stBorderWidth + stBorder + "\\fs1");
                    }
                }
                if (shape.getShapeType() instanceof StiHorizontalLineShapeType) {
                    if (tempColor.getA() != 0) {
                        this.sw.write(stBrush);
                    }
                    if (tempColor2.getA() != 0) {
                        this.sw.write(" \\par}\r\n");
                        this.sw.write("{");
                        this.sw.write(String.format("\\nowrap\\posx%s\\posy%s\\absw%s\\absh%s", pp.x + correctX, pp.y, pp.width - correctW, (pp.height + borderWidth) / 2));
                        this.sw.write("\\brdrb" + stBorderWidth + stBorder + "\\fs1");
                    }
                }
                if (shape.getShapeType() instanceof StiTopAndBottomLineShapeType) {
                    if (tempColor.getA() != 0) {
                        this.sw.write(stBrush);
                    }
                    this.sw.write("\\brdrt" + stBorderWidth + stBorder);
                    this.sw.write("\\brdrb" + stBorderWidth + stBorder);
                    this.sw.write("\\fs1\r\n");
                }
                if (shape.getShapeType() instanceof StiLeftAndRightLineShapeType) {
                    if (tempColor.getA() != 0) {
                        this.sw.write(stBrush);
                    }
                    this.sw.write("\\brdrl" + stBorderWidth + stBorder);
                    this.sw.write("\\brdrr" + stBorderWidth + stBorder);
                    this.sw.write("\\fs1\r\n");
                }
                if (shape.getShapeType() instanceof StiRectangleShapeType) {
                    if (tempColor.getA() != 0) {
                        this.sw.write(stBrush);
                    }
                    this.sw.write("\\box" + stBorderWidth + stBorder);
                    this.sw.write("\\fs1\r\n");
                }
            } else {
                this.renderImage12(component, pp.width - correctW, pp.height);
            }
        }
    }

    private Boolean checkShape2(StiShape shape) {
        if (shape.getShapeType() instanceof StiVerticalLineShapeType || shape.getShapeType() instanceof StiHorizontalLineShapeType || shape.getShapeType() instanceof StiTopAndBottomLineShapeType || shape.getShapeType() instanceof StiLeftAndRightLineShapeType || shape.getShapeType() instanceof StiRectangleShapeType || shape.getShapeType() instanceof StiDiagonalDownLineShapeType || shape.getShapeType() instanceof StiDiagonalUpLineShapeType || shape.getShapeType() instanceof StiOvalShapeType) {
            return true;
        }
        return false;
    }

    private void renderShape2(StiRtfData pp) throws IOException {
        StiShape shape;
        StiComponent component = pp.component;
        StiShape stiShape = shape = component instanceof StiShape ? (StiShape)component : null;
        if (shape != null) {
            if (this.checkShape2(shape).booleanValue()) {
                IStiBrush mBrush = component instanceof IStiBrush ? (IStiBrush)((Object)component) : null;
                StiColor tempColor = StiColorEnum.Transparent.color();
                if (mBrush != null) {
                    tempColor = StiBrush.ToColor((StiBrush)mBrush.getBrush());
                }
                StiColor tempColor2 = shape.getBorderColor();
                int borderWidth = (int)(shape.getSize() * 8400.0);
                String stBorderWidth = String.format("%s", borderWidth);
                if (shape.getShapeType() instanceof StiVerticalLineShapeType) {
                    this.fillRect(pp, tempColor);
                    this.drawLine(pp.x + pp.width / 2, pp.y, pp.x + pp.width / 2, pp.y + pp.height, tempColor2, stBorderWidth);
                }
                if (shape.getShapeType() instanceof StiHorizontalLineShapeType) {
                    this.fillRect(pp, tempColor);
                    this.drawLine(pp.x, pp.y + pp.height / 2, pp.x + pp.width, pp.y + pp.height / 2, tempColor2, stBorderWidth);
                }
                if (shape.getShapeType() instanceof StiTopAndBottomLineShapeType) {
                    this.fillRect(pp, tempColor);
                    this.drawLine(pp.x, pp.y, pp.x + pp.width, pp.y, tempColor2, stBorderWidth);
                    this.drawLine(pp.x, pp.y + pp.height, pp.x + pp.width, pp.y + pp.height, tempColor2, stBorderWidth);
                }
                if (shape.getShapeType() instanceof StiLeftAndRightLineShapeType) {
                    this.fillRect(pp, tempColor);
                    this.drawLine(pp.x, pp.y, pp.x, pp.y + pp.height, tempColor2, stBorderWidth);
                    this.drawLine(pp.x + pp.width, pp.y, pp.x + pp.width, pp.y + pp.height, tempColor2, stBorderWidth);
                }
                if (shape.getShapeType() instanceof StiRectangleShapeType) {
                    this.sw.write("{\\shp{\\*");
                    this.sw.write(String.format("\\shpinst\\shpleft%s\\shptop%s\\shpright%s\\shpbottom%s", pp.x, pp.y, pp.x + pp.width, pp.y + pp.height));
                    this.sw.write("\\shpwr3");
                    this.sw.write("{\\sp{\\sn shapeType}{\\sv 1}}");
                    this.sw.write("{\\sp{\\sn fFlipH}{\\sv 0}}");
                    this.sw.write("{\\sp{\\sn fFlipV}{\\sv 0}}");
                    if (tempColor.getA() != 0) {
                        this.sw.write("{\\sp{\\sn fillColor}{\\sv " + String.format("%s", tempColor.getB() * 65536 + tempColor.getG() * 256 + tempColor.getR()) + "}}");
                        this.sw.write("{\\sp{\\sn fFilled}{\\sv 1}}");
                    } else {
                        this.sw.write("{\\sp{\\sn fFilled}{\\sv 0}}");
                    }
                    if (tempColor2.getA() != 0) {
                        this.sw.write("{\\sp{\\sn lineColor}{\\sv " + String.format("%s", tempColor2.getB() * 65536 + tempColor2.getG() * 256 + tempColor2.getR()) + "}}");
                        this.sw.write("{\\sp{\\sn lineWidth}{\\sv " + stBorderWidth + "}}");
                        this.sw.write("{\\sp{\\sn fLine}{\\sv 1}}");
                    } else {
                        this.sw.write("{\\sp{\\sn fLine}{\\sv 0}}");
                    }
                    this.sw.write("}}\r\n");
                }
                if (shape.getShapeType() instanceof StiOvalShapeType) {
                    this.sw.write("{\\shp{\\*");
                    this.sw.write(String.format("\\shpinst\\shpleft%s\\shptop%s\\shpright%s\\shpbottom%s", pp.x, pp.y, pp.x + pp.width, pp.y + pp.height));
                    this.sw.write("\\shpwr3");
                    this.sw.write("{\\sp{\\sn shapeType}{\\sv 3}}");
                    this.sw.write("{\\sp{\\sn fFlipH}{\\sv 0}}");
                    this.sw.write("{\\sp{\\sn fFlipV}{\\sv 0}}");
                    if (tempColor.getA() != 0) {
                        this.sw.write("{\\sp{\\sn fillColor}{\\sv " + String.format("%s", tempColor.getB() * 65536 + tempColor.getG() * 256 + tempColor.getR()) + "}}");
                        this.sw.write("{\\sp{\\sn fFilled}{\\sv 1}}");
                    } else {
                        this.sw.write("{\\sp{\\sn fFilled}{\\sv 0}}");
                    }
                    if (tempColor2.getA() != 0) {
                        this.sw.write("{\\sp{\\sn lineColor}{\\sv " + String.format("%s", tempColor2.getB() * 65536 + tempColor2.getG() * 256 + tempColor2.getR()) + "}}");
                        this.sw.write("{\\sp{\\sn lineWidth}{\\sv " + stBorderWidth + "}}");
                        this.sw.write("{\\sp{\\sn fLine}{\\sv 1}}");
                    } else {
                        this.sw.write("{\\sp{\\sn fLine}{\\sv 0}}");
                    }
                    this.sw.write("}}\r\n");
                }
                if (shape.getShapeType() instanceof StiDiagonalDownLineShapeType) {
                    this.fillRect(pp, tempColor);
                    this.drawLine(pp.x, pp.y, pp.x + pp.width, pp.y + pp.height, tempColor2, stBorderWidth);
                }
                if (shape.getShapeType() instanceof StiDiagonalUpLineShapeType) {
                    this.fillRect(pp, tempColor);
                    this.drawLine(pp.x, pp.y + pp.height, pp.x + pp.width, pp.y, tempColor2, stBorderWidth);
                }
            } else {
                this.renderImage12(component, pp.width, pp.height);
            }
        }
    }

    private StringBuilder checkArabic(StringBuilder inputString) {
        if (ExportOptions.Rtf.getConvertDigitsToArabic()) {
            return StiBidirectionalConvert.convertDigitsToArabic((StringBuilder)inputString, (StiArabicDigitsType)ExportOptions.Rtf.getArabicDigitsType());
        }
        return inputString;
    }

    private StringBuilder unicodeToRtfString(StringBuilder stInput, Boolean useRightToLeft) {
        if (useRightToLeft.booleanValue()) {
            stInput = this.checkArabic(stInput);
        }
        String stTemp = stInput.toString();
        if ((stTemp = stTemp.replaceAll("\\\\", "\\\\\\\\").replaceAll("\\{", "\\\\{").replaceAll("}", "\\\\}")).length() > 1 && stTemp.charAt(0) == '\t') {
            stTemp = "\t\t" + stTemp;
        }
        stTemp = stTemp.replaceAll("\n\t", "\n\t\t\t").replaceAll("\n", "\\\\par ").replaceAll("\u0017", "\\\\").replaceAll("\u0018", "{\\\\field{\\\\*\\\\fldinst {PAGE}}}").replaceAll("\u0019", "{\\\\field{\\\\*\\\\fldinst {NUMPAGES}}}").replaceAll("\u001a", "{\\\\field{\\\\*\\\\fldinst {").replaceAll("\u001b", " }}{\\\\fldrslt {").replaceAll("\u001c", "{\\\\*\\\\bkmkstart ").replaceAll("\u001d", "}{\\\\*\\\\bkmkend ").replaceAll("\u001e", "}");
        String[] stArray = null;
        stArray = stTemp.indexOf(16) == -1 ? new String[]{stTemp} : stTemp.split("\u0010");
        StringBuilder sbOutput = new StringBuilder();
        for (int indexString = 0; indexString < stArray.length; ++indexString) {
            String stCurrent = stArray[indexString];
            if (indexString != 0) {
                this.baseFontNumber = stCurrent.charAt(0) - 256;
                if (this.baseFontNumber < 0) {
                    this.baseFontNumber = 0;
                }
                stCurrent = stCurrent.substring(2);
            }
            int stIndex = 0;
            while (stIndex < stCurrent.length()) {
                int stIndexBegin = stIndex;
                StringBuilder tempsb = new StringBuilder();
                byte cpValue = 1;
                while (stIndex < stCurrent.length() && StiEncode.unicodeToCodePageArray[stCurrent.charAt(stIndex)] == 0) {
                    tempsb.append(stCurrent.charAt(stIndex));
                    ++stIndex;
                }
                if (stIndex < stCurrent.length()) {
                    cpValue = StiEncode.unicodeToCodePageArray[stCurrent.charAt(stIndex)];
                    tempsb.append(stCurrent.charAt(stIndex));
                    ++stIndex;
                    while (stIndex < stCurrent.length() && (StiEncode.unicodeToCodePageArray[stCurrent.charAt(stIndex)] == 0 || StiEncode.unicodeToCodePageArray[stCurrent.charAt(stIndex)] == cpValue)) {
                        tempsb.append(stCurrent.charAt(stIndex));
                        ++stIndex;
                    }
                }
                StringBuilder tempbb = StiEncode.encode(tempsb, cpValue);
                sbOutput.append("\\f" + (this.baseFontNumber + this.codePageToFont[cpValue]) + " ");
                for (int tempIndex = 0; tempIndex < tempbb.length(); ++tempIndex) {
                    char curSym = stCurrent.charAt(stIndexBegin + tempIndex);
                    if (tempbb.charAt(tempIndex) == '?' && StiEncode.unicodeToCodePageArray[curSym] < 2) {
                        sbOutput.append("\\u" + curSym + "?");
                        continue;
                    }
                    sbOutput.append(tempbb.charAt(tempIndex));
                }
            }
        }
        return sbOutput;
    }

    private String deleteToken(String inputString, String token) {
        int offset;
        do {
            if ((offset = inputString.indexOf(token)) <= -1) continue;
            int offset2 = offset + token.length();
            while (Character.isDigit(inputString.charAt(offset2))) {
                ++offset2;
            }
            inputString = inputString.substring(0, offset > 0 ? offset - 1 : offset) + inputString.substring(offset2, inputString.length());
        } while (offset != -1);
        return inputString;
    }

    private String getRtfString(StiComponent component) {
        StiRichText rtf;
        String st = "";
        StiRichText stiRichText = rtf = component instanceof StiRichText ? (StiRichText)component : null;
        if (rtf != null && StiValidationUtil.isNotNullOrEmpty((String)rtf.unpackRTF())) {
            String stt2;
            int tempi;
            int tempIndex;
            int kolSkob;
            ArrayList<String> arrFont = new ArrayList<String>();
            ArrayList<String> arrFont2 = new ArrayList<String>();
            ArrayList<String> arrColor = new ArrayList<String>();
            st = rtf.unpackRTF();
            if (st.replaceAll("^\\s+", "").toLowerCase().indexOf("rtf") == -1) {
                return st;
            }
            int index = st.indexOf("{\\fonttbl");
            if (index != -1) {
                index += 9;
                while (index < st.length() && st.charAt(index) != '}') {
                    while (index < st.length() && st.charAt(index) != '{') {
                        ++index;
                    }
                    kolSkob = 0;
                    int index2 = index;
                    do {
                        if (st.charAt(index2) == '{') {
                            ++kolSkob;
                        }
                        if (st.charAt(index2) == '}') {
                            --kolSkob;
                        }
                        ++index2;
                    } while (kolSkob > 0);
                    arrFont.add(st.substring(index, index2));
                    for (index = index2; index < st.length() && st.charAt(index) != '{' && st.charAt(index) != '}'; ++index) {
                    }
                }
                st = st.substring(index + 1);
            }
            for (tempIndex = 0; tempIndex < arrFont.size(); ++tempIndex) {
                int tempLen;
                String stt = (String)arrFont.remove(tempIndex);
                do {
                    if ((tempi = stt.indexOf("{\\*")) == -1) continue;
                    int kolSkob2 = 0;
                    int index2 = tempi;
                    do {
                        if (stt.charAt(index2) == '{') {
                            ++kolSkob2;
                        }
                        if (stt.charAt(index2) == '}') {
                            --kolSkob2;
                        }
                        ++index2;
                    } while (kolSkob2 > 0);
                    if ((stt = stt.substring(0, tempi > 0 ? tempi - 1 : 0) + stt.substring(index2, stt.length())).charAt(tempi - 1) == ' ' || stt.charAt(tempi) == ' ') continue;
                    stt = stt.substring(0, tempi - 1) + " " + stt.substring(tempi);
                } while (tempi != -1);
                tempi = stt.indexOf(" ");
                if (stt.charAt(tempi + 1 + (tempLen = stt.length() - tempi - 2) - 1) == ';') {
                    --tempLen;
                }
                stt2 = stt.substring(tempi + 1, tempi + 1 + tempLen);
                StiFont tmpFont = new StiFont(stt2, 10.0);
                int charset = 0;
                tempi = stt.indexOf("\\fcharset");
                if (tempi > 0) {
                    tempi += 9;
                    StringBuilder stbCharset = new StringBuilder();
                    while (Character.isDigit(stt.charAt(tempi))) {
                        stbCharset.append(stt.charAt(tempi));
                        ++tempi;
                    }
                    try {
                        charset = Integer.parseInt(stbCharset.toString());
                    }
                    catch (Exception e) {
                        charset = 0;
                    }
                }
                String stt3 = this.getFontNumber(this.fontList, tmpFont, charset).toString();
                arrFont2.add(stt3);
                StringBuilder stb = new StringBuilder();
                tempi = stt.indexOf("\\f");
                tempi += 2;
                while (Character.isDigit(stt.charAt(tempi))) {
                    stb.append(stt.charAt(tempi));
                    ++tempi;
                }
                arrFont.add(tempIndex, stb.toString());
            }
            index = st.indexOf("{\\colortbl");
            if (index != -1) {
                index += 10;
                while (index < st.length() && st.charAt(index) != '}') {
                    int index2;
                    while (index < st.length() && st.charAt(index) != ';' && st.charAt(index) != '\\') {
                        ++index;
                    }
                    for (index2 = index; index2 < st.length() && st.charAt(index2) != ';' && st.charAt(index2) != '}'; ++index2) {
                    }
                    arrColor.add(st.substring(index, index2 + 1));
                    if (st.charAt(index2) == ';') {
                        // empty if block
                    }
                    for (index = ++index2; index < st.length() && st.charAt(index) != ';' && st.charAt(index) != '\\' && st.charAt(index) != '}'; ++index) {
                    }
                }
                st = st.substring(index + 1);
            }
            for (tempIndex = 0; tempIndex < arrColor.size(); ++tempIndex) {
                String stt = (String)arrColor.remove(tempIndex);
                if (!stt.equals(";")) {
                    tempi = stt.indexOf("\\red") + 4;
                    StringBuilder stb = new StringBuilder();
                    while (Character.isDigit(stt.charAt(tempi))) {
                        stb.append(stt.charAt(tempi));
                        ++tempi;
                    }
                    String stt1 = stb.toString();
                    tempi = stt.indexOf("\\green") + 6;
                    stb = new StringBuilder();
                    while (Character.isDigit(stt.charAt(tempi))) {
                        stb.append(stt.charAt(tempi));
                        ++tempi;
                    }
                    stt2 = stb.toString();
                    tempi = stt.indexOf("\\blue") + 5;
                    stb = new StringBuilder();
                    while (Character.isDigit(stt.charAt(tempi))) {
                        stb.append(stt.charAt(tempi));
                        ++tempi;
                    }
                    String stt3 = stb.toString();
                    StiColor tmpColor = StiColor.fromArgb((int)Integer.parseInt(stt1), (int)Integer.parseInt(stt2), (int)Integer.parseInt(stt3));
                    arrColor.add(tempIndex, this.getColorNumber(this.colorList, tmpColor));
                    continue;
                }
                arrColor.add(tempIndex, this.getColorNumber(this.colorList, StiColorEnum.Transparent.color()));
            }
            index = st.indexOf("{\\stylesheet");
            if (index != -1) {
                kolSkob = 0;
                int index2 = index;
                do {
                    if (st.charAt(index2) == '{') {
                        ++kolSkob;
                    }
                    if (st.charAt(index2) == '}') {
                        --kolSkob;
                    }
                    ++index2;
                } while (kolSkob > 0);
                st = st.substring(index2);
            }
            if ((index = st.indexOf("{\\*\\generator")) != -1) {
                kolSkob = 0;
                int index2 = index;
                do {
                    if (st.charAt(index2) == '{') {
                        ++kolSkob;
                    }
                    if (st.charAt(index2) == '}') {
                        --kolSkob;
                    }
                    ++index2;
                } while (kolSkob > 0);
                st = st.substring(index2);
            }
            int tempix = 0;
            do {
                if ((tempix = st.indexOf("\\f", tempix)) == -1) continue;
                if (Character.isDigit(st.charAt(tempix + 2))) {
                    int tempi2 = tempix += 2;
                    StringBuilder stbb = new StringBuilder();
                    while (Character.isDigit(st.charAt(tempi2))) {
                        stbb.append(st.charAt(tempi2));
                        ++tempi2;
                    }
                    String stt = stbb.toString();
                    for (int tempIndex2 = 0; tempIndex2 < arrFont.size(); ++tempIndex2) {
                        if (!((String)arrFont.get(tempIndex2)).equals(stt)) continue;
                        st = st.substring(0, tempix) + (String)arrFont2.get(tempIndex2) + st.substring(tempi2);
                    }
                    tempix = tempi2;
                    continue;
                }
                tempix += 2;
            } while (tempix != -1);
            if (arrColor.size() > 0) {
                tempix = 0;
                int tokenLength = 3;
                do {
                    if ((tempix = st.indexOf("\\cf", tempix)) == -1) continue;
                    if (Character.isDigit(st.charAt(tempix + tokenLength))) {
                        int tempi2 = tempix += tokenLength;
                        StringBuilder stbb = new StringBuilder();
                        while (Character.isDigit(st.charAt(tempi2))) {
                            stbb.append(st.charAt(tempi2));
                            ++tempi2;
                        }
                        int tempv = Integer.parseInt(stbb.toString());
                        if (tempv < arrColor.size()) {
                            st = st.substring(0, tempix) + (String)arrColor.get(tempv) + st.substring(tempi2);
                        }
                        tempix = tempi2;
                        continue;
                    }
                    tempix += tokenLength;
                } while (tempix != -1);
                tempix = 0;
                tokenLength = 6;
                do {
                    if ((tempix = st.indexOf("\\cbpat", tempix)) == -1) continue;
                    if (Character.isDigit(st.charAt(tempix + tokenLength))) {
                        int tempi2 = tempix += tokenLength;
                        StringBuilder stbb = new StringBuilder();
                        while (Character.isDigit(st.charAt(tempi2))) {
                            stbb.append(st.charAt(tempi2));
                            ++tempi2;
                        }
                        int tempv = Integer.parseInt(stbb.toString());
                        if (tempv < arrColor.size()) {
                            st = st.substring(0, tempix) + (String)arrColor.get(tempv) + st.substring(tempi2);
                        }
                        tempix = tempi2;
                        continue;
                    }
                    tempix += tokenLength;
                } while (tempix != -1);
                tempix = 0;
                tokenLength = 10;
                do {
                    if ((tempix = st.indexOf("\\highlight", tempix)) == -1) continue;
                    if (Character.isDigit(st.charAt(tempix + tokenLength))) {
                        int tempi2 = tempix += tokenLength;
                        StringBuilder stbb = new StringBuilder();
                        while (Character.isDigit(st.charAt(tempi2))) {
                            stbb.append(st.charAt(tempi2));
                            ++tempi2;
                        }
                        int tempv = Integer.parseInt(stbb.toString());
                        if (tempv < arrColor.size()) {
                            st = st.substring(0, tempix) + (String)arrColor.get(tempv) + st.substring(tempi2);
                        }
                        tempix = tempi2;
                        continue;
                    }
                    tempix += tokenLength;
                } while (tempix != -1);
            }
            index = st.length() - 1;
            while (st.charAt(index) != '}') {
                --index;
            }
            --index;
            while (st.charAt(index) == '\r' || st.charAt(index) == '\n' || st.charAt(index) == ' ') {
                --index;
            }
            if ((st = st.substring(0, index + 1)).endsWith("\\par")) {
                st = st.substring(0, st.length() - "\\par".length());
            }
            if (st.endsWith("\\par }")) {
                st = st.substring(0, st.length() - "\\par }".length()) + '}';
            }
            st = this.deleteToken(st, "\\viewkind");
            st = this.deleteToken(st, "\\uc");
            while (st.charAt(0) == '\r' || st.charAt(0) == '\n') {
                st = st.substring(1);
            }
            if (st.substring(0, 5).equals("\\pard")) {
                st = st.substring(5);
            }
            st = this.deleteToken(st, "\\formprot");
            st = this.deleteToken(st, "\\pagebb");
            StringBuilder sb = new StringBuilder();
            for (int indexChar = 0; indexChar < st.length(); ++indexChar) {
                char bt = st.charAt(indexChar);
                if (bt > '\u00ff') {
                    sb.append(String.format("\\u%s%s", bt, "?"));
                    continue;
                }
                sb.append(st.charAt(indexChar));
            }
            st = sb.toString();
        }
        int counter = 0;
        int pos = 0;
        while (pos < st.length()) {
            char ch;
            if ((ch = st.charAt(pos++)) == '{') {
                ++counter;
                continue;
            }
            if (ch == '}') {
                --counter;
                continue;
            }
            if (ch != '\\' || pos >= st.length() || st.charAt(pos) != '{' && st.charAt(pos) != '}') continue;
            ++pos;
        }
        if (counter < 0) {
            st = StiStringUtil.repeatString((String)"{", (int)(-counter)) + st;
        }
        if (counter > 0) {
            st = st + StiStringUtil.repeatString((String)"}", (int)counter);
        }
        return st;
    }

    private String makeHorAlignString(StiTextHorAlignment alignment, Boolean rightToLeft) {
        int indent = 0;
        String stAlignment = "\\ql" + (indent != 0 ? String.format("\\ri%s", indent) : "");
        if (alignment == StiTextHorAlignment.Left && rightToLeft.booleanValue() || alignment == StiTextHorAlignment.Right && !rightToLeft.booleanValue()) {
            stAlignment = "\\qr" + (indent != 0 ? String.format("\\li%s", indent) : "");
        }
        if (alignment == StiTextHorAlignment.Center) {
            stAlignment = "\\qc" + (indent != 0 ? String.format("\\ri%s", indent) : "");
        }
        if (alignment == StiTextHorAlignment.Width) {
            stAlignment = "\\qj";
        }
        return stAlignment;
    }

    private int getRtfStyleFromComponent(StiComponent component) {
        if (component != null) {
            IStiFont mFont = component instanceof IStiFont ? (IStiFont)((Object)component) : null;
            IStiTextBrush mTextBrush = component instanceof IStiTextBrush ? (IStiTextBrush)((Object)component) : null;
            IStiTextHorAlignment mTextHorAlign = component instanceof IStiTextHorAlignment ? (IStiTextHorAlignment)((Object)component) : null;
            IStiTextOptions textOpt = component instanceof IStiTextOptions ? (IStiTextOptions)((Object)component) : null;
            StiRtfStyleInfo style = new StiRtfStyleInfo();
            style.name = component.getName();
            if (component.getComponentStyle() != null && component.getComponentStyle().length() > 0) {
                style.name = component.getComponentStyle();
            }
            if (mFont != null) {
                style.fontNumber = this.getFontNumber(this.fontList, mFont.getFont());
                style.fontSize = (int)StiMath.round((double)(mFont.getFont().getSize() * 2.0), (int)0);
                style.bold = mFont.getFont().bold();
                style.italic = mFont.getFont().italic();
                style.underline = mFont.getFont().underline();
            }
            if (mTextBrush != null) {
                style.textColor = this.getColorNumberInt(this.colorList, StiBrush.ToColor((StiBrush)mTextBrush.getTextBrush()));
            }
            if (mTextHorAlign != null) {
                style.alignment = mTextHorAlign.getHorAlignment();
            }
            if (textOpt != null) {
                style.rightToLeft = textOpt.getTextOptions().getRightToLeft();
            }
            return this.getStyleNumber(this.styleList, style);
        }
        return 0;
    }

    private void renderStartDoc() throws IOException {
        int index;
        this.sw.write("{\\rtf1");
        this.sw.write(String.format("\\ansi\\ansicpg%s", 1252) + "\r\n");
        this.sw.write("{\\fonttbl\r\n");
        for (index = 0; index < this.fontList.size(); ++index) {
            StiFont tmpFont = this.fontList.get(index);
            for (int index2 = 0; index2 < this.charsetCount; ++index2) {
                int charset = StiEncode.codePagesTable[this.fontToCodePages[index2]][2];
                this.sw.write("{");
                this.sw.write(String.format("\\f%s\\fcharset%s %s;", index * this.charsetCount + index2, charset == 1 ? 0 : charset, tmpFont.getName()));
                this.sw.write("}\r\n");
            }
        }
        this.sw.write("}\r\n");
        this.sw.write("{\\colortbl\r\n");
        for (index = 0; index < this.colorList.size(); ++index) {
            StiColor tmpColor = this.colorList.get(index);
            if (StiColorEnum.Transparent.color().equals(tmpColor)) {
                this.sw.write(";\r\n");
                continue;
            }
            this.sw.write(String.format("\\red%s\\green%s\\blue%s;", tmpColor.getR(), tmpColor.getG(), tmpColor.getB()) + "\r\n");
        }
        this.sw.write("}\r\n");
        if (this.useStyles.booleanValue()) {
            this.sw.write("{\\stylesheet\r\n");
            for (index = 0; index < this.styleList.size(); ++index) {
                this.sw.write("{");
                StiRtfStyleInfo tmpStyle = this.styleList.get(index);
                this.sw.write(String.format("\\s%s\\sbasedon0\\snext%s ", index + 1, index + 1));
                if (tmpStyle.fontNumber != -1) {
                    this.sw.write(String.format("\\f%s", tmpStyle.fontNumber));
                    this.sw.write(String.format("\\fs%s", tmpStyle.fontSize));
                    if (tmpStyle.bold.booleanValue()) {
                        this.sw.write("\\b");
                    }
                    if (tmpStyle.italic.booleanValue()) {
                        this.sw.write("\\i");
                    }
                    if (tmpStyle.underline.booleanValue()) {
                        this.sw.write("\\ul");
                    }
                }
                if (tmpStyle.textColor != -1) {
                    this.sw.write(String.format("\\cf%s", tmpStyle.textColor));
                }
                this.sw.write(this.makeHorAlignString(tmpStyle.alignment, tmpStyle.rightToLeft));
                if (tmpStyle.rightToLeft.booleanValue()) {
                    this.sw.write("\\rtlpar");
                } else {
                    this.sw.write("\\ltrpar");
                }
                this.sw.write(String.format(" %s;", tmpStyle.name));
                this.sw.write("}\r\n");
            }
            this.sw.write("}\r\n");
        }
        this.sw.write("{\\info{\\doccomm " + StiExportUtils.getReportVersion() + "}}\r\n");
        this.sw.write("\\viewkind1");
        this.sw.write(String.format("\\deftab%s", (int)Math.round(288.0)));
        this.sw.write("\\nouicompat");
    }

    private void renderEndDoc() throws IOException {
        this.sw.write("\r\n");
        this.sw.write("}\r\n");
    }

    private void renderPageHeader(StiPage page) throws IOException {
        Boolean useTemplatePageSize = ExportOptions.Rtf.getUseTemplatePageSize();
        this.pageHeight = (int)Math.round(14.4 * page.getUnit().ConvertToHInches(page.getPageHeight() * (double)(useTemplatePageSize != false ? 1 : page.getSegmentPerHeight())));
        this.pageWidth = (int)Math.round(14.4 * page.getUnit().ConvertToHInches(page.getPageWidth() * (double)(useTemplatePageSize != false ? 1 : page.getSegmentPerWidth())));
        int mgLeft = (int)Math.round(14.4 * page.getUnit().ConvertToHInches(page.getMargins().getLeft()));
        int mgRight = (int)Math.round(14.4 * page.getUnit().ConvertToHInches(page.getMargins().getRight()));
        int mgTop = (int)Math.round(14.4 * page.getUnit().ConvertToHInches(page.getMargins().getTop()));
        int mgBottom = (int)Math.round(14.4 * page.getUnit().ConvertToHInches(page.getMargins().getBottom())) - ExportOptions.Rtf.getBottomMarginCorrection();
        if (mgBottom < 0) {
            mgBottom = 0;
        }
        if (this.pageWidth > 31500) {
            this.pageWidth = 31500;
        }
        if (this.pageHeight > 31500) {
            this.pageHeight = 31500;
        }
        this.sw.write("\\sectd");
        if (page.getOrientation() == StiPageOrientation.Landscape) {
            this.sw.write("\\lndscpsxn");
        }
        this.sw.write(String.format("\\paperw%s\\paperh%s", this.pageWidth, this.pageHeight));
        this.sw.write(String.format("\\margl%s\\margr%s\\margt%s\\margb%s\\headery%s\\footery%s", mgLeft, mgRight, mgTop, mgBottom, mgTop, mgBottom) + "\r\n");
    }

    private void renderPageFooter() throws IOException {
        if (ExportOptions.Rtf.isUseNewPageCommandInsteadOfNewSection()) {
            this.sw.write("\\page\\par\r\n");
        } else {
            this.sw.write("\\sect\r\n");
        }
    }

    private void renderTextAngle1(StiComponent component) throws IOException {
        IStiTextOptions textOpt;
        IStiTextOptions iStiTextOptions = textOpt = component instanceof IStiTextOptions ? (IStiTextOptions)((Object)component) : null;
        if (textOpt != null) {
            float textAngle = textOpt.getTextOptions().getAngle();
            int textAngleNum = 0;
            if (textAngle > 45.0f && textAngle < 135.0f) {
                textAngleNum = 1;
            }
            if (textAngle > 225.0f && textAngle < 315.0f) {
                textAngleNum = 2;
            }
            switch (textAngleNum) {
                case 1: {
                    this.sw.write("\\frmtxbtlr");
                    break;
                }
                case 2: {
                    this.sw.write("\\frmtxtbrl");
                    break;
                }
                default: {
                    this.sw.write("\\frmtxlrtb");
                }
            }
        }
    }

    private void renderTextAngle2(StiComponent component) throws IOException {
        IStiTextOptions textOpt;
        IStiTextOptions iStiTextOptions = textOpt = component instanceof IStiTextOptions ? (IStiTextOptions)((Object)component) : null;
        if (textOpt != null) {
            float textAngle = textOpt.getTextOptions().getAngle();
            int textAngleNum = 0;
            if (textAngle > 45.0f && textAngle < 135.0f) {
                textAngleNum = 1;
            }
            if (textAngle > 225.0f && textAngle < 315.0f) {
                textAngleNum = 2;
            }
            switch (textAngleNum) {
                case 1: {
                    this.sw.write("\\cltxbtlr");
                    break;
                }
                case 2: {
                    this.sw.write("\\cltxtbrl");
                    break;
                }
                default: {
                    this.sw.write("\\cltxlrtb");
                }
            }
        }
    }

    private void renderHorAlign12(StiComponent component) throws IOException {
        IStiTextOptions textOpt;
        IStiTextHorAlignment mTextHorAlign = component instanceof IStiTextHorAlignment ? (IStiTextHorAlignment)((Object)component) : null;
        IStiTextOptions iStiTextOptions = textOpt = component instanceof IStiTextOptions ? (IStiTextOptions)((Object)component) : null;
        if (mTextHorAlign != null) {
            String alignment = this.makeHorAlignString(mTextHorAlign.getHorAlignment(), textOpt.getTextOptions().getRightToLeft());
            this.sw.write(String.format("%s", alignment));
        }
    }

    private void renderVerAlign2(StiComponent component) throws IOException {
        IStiVertAlignment mVertAlign;
        IStiVertAlignment iStiVertAlignment = mVertAlign = component instanceof IStiVertAlignment ? (IStiVertAlignment)((Object)component) : null;
        if (mVertAlign != null) {
            if (mVertAlign.getVertAlignment() == StiVertAlignment.Top) {
                this.sw.write("\\clvertalt");
            }
            if (mVertAlign.getVertAlignment() == StiVertAlignment.Center) {
                this.sw.write("\\clvertalc");
            }
            if (mVertAlign.getVertAlignment() == StiVertAlignment.Bottom) {
                this.sw.write("\\clvertalb");
            }
        }
    }

    private void renderBorder1(StiComponent component) throws IOException {
        IStiBorder mBorder;
        IStiBorder iStiBorder = mBorder = component instanceof IStiBorder ? (IStiBorder)((Object)component) : null;
        if (mBorder != null && !(component instanceof IStiIgnoreBorderWhenExport)) {
            if (mBorder.getBorder() instanceof StiAdvancedBorder) {
                StiAdvancedBorder advBorder = (StiAdvancedBorder)mBorder.getBorder();
                if (advBorder.isLeftBorderSidePresent() && advBorder.getLeftSide().getColor().getA() != 0) {
                    this.sw.write("\\brdrl" + this.getLineStyle(advBorder.getLeftSide(), this.colorList));
                }
                if (advBorder.isRightBorderSidePresent() && advBorder.getRightSide().getColor().getA() != 0) {
                    this.sw.write("\\brdrr" + this.getLineStyle(advBorder.getRightSide(), this.colorList));
                }
                if (advBorder.isTopBorderSidePresent() && advBorder.getTopSide().getColor().getA() != 0) {
                    this.sw.write("\\brdrt" + this.getLineStyle(advBorder.getTopSide(), this.colorList));
                }
                if (advBorder.isBottomBorderSidePresent() && advBorder.getBottomSide().getColor().getA() != 0) {
                    this.sw.write("\\brdrb" + this.getLineStyle(advBorder.getBottomSide(), this.colorList));
                }
            } else {
                StiColor tempColor = mBorder.getBorder().getColor();
                if (tempColor.getA() != 0) {
                    String sb = this.getLineStyle(new StiBorderSide(mBorder.getBorder().getColor(), mBorder.getBorder().getSize(), mBorder.getBorder().getStyle()), this.colorList);
                    if (mBorder.getBorder().getSide().contains((IStiEnum)StiBorderSides.Left)) {
                        this.sw.write("\\brdrl" + sb);
                    }
                    if (mBorder.getBorder().getSide().contains((IStiEnum)StiBorderSides.Right)) {
                        this.sw.write("\\brdrr" + sb);
                    }
                    if (mBorder.getBorder().getSide().contains((IStiEnum)StiBorderSides.Top)) {
                        this.sw.write("\\brdrt" + sb);
                    }
                    if (mBorder.getBorder().getSide().contains((IStiEnum)StiBorderSides.Bottom)) {
                        this.sw.write("\\brdrb" + sb);
                    }
                }
            }
        }
    }

    private void renderBorder2(StiComponent component) throws IOException {
        IStiBorder mBorder;
        IStiBorder iStiBorder = mBorder = component instanceof IStiBorder ? (IStiBorder)((Object)component) : null;
        if (mBorder != null && !(component instanceof IStiIgnoreBorderWhenExport)) {
            if (mBorder.getBorder() instanceof StiAdvancedBorder) {
                StiAdvancedBorder advBorder = (StiAdvancedBorder)mBorder.getBorder();
                if (advBorder.isLeftBorderSidePresent() && advBorder.getLeftSide().getColor().getA() != 0) {
                    this.sw.write("\\clbrdrl" + this.getLineStyle(advBorder.getLeftSide(), this.colorList));
                }
                if (advBorder.isRightBorderSidePresent() && advBorder.getRightSide().getColor().getA() != 0) {
                    this.sw.write("\\clbrdrr" + this.getLineStyle(advBorder.getRightSide(), this.colorList));
                }
                if (advBorder.isTopBorderSidePresent() && advBorder.getTopSide().getColor().getA() != 0) {
                    this.sw.write("\\clbrdrt" + this.getLineStyle(advBorder.getTopSide(), this.colorList));
                }
                if (advBorder.isBottomBorderSidePresent() && advBorder.getBottomSide().getColor().getA() != 0) {
                    this.sw.write("\\clbrdrb" + this.getLineStyle(advBorder.getBottomSide(), this.colorList));
                }
            } else {
                StiColor tempColor = mBorder.getBorder().getColor();
                if (tempColor.getA() != 0) {
                    String sb = this.getLineStyle(new StiBorderSide(mBorder.getBorder().getColor(), mBorder.getBorder().getSize(), mBorder.getBorder().getStyle()), this.colorList);
                    if (mBorder.getBorder().getSide().contains((IStiEnum)StiBorderSides.Left)) {
                        this.sw.write("\\clbrdrl" + sb);
                    }
                    if (mBorder.getBorder().getSide().contains((IStiEnum)StiBorderSides.Right)) {
                        this.sw.write("\\clbrdrr" + sb);
                    }
                    if (mBorder.getBorder().getSide().contains((IStiEnum)StiBorderSides.Top)) {
                        this.sw.write("\\clbrdrt" + sb);
                    }
                    if (mBorder.getBorder().getSide().contains((IStiEnum)StiBorderSides.Bottom)) {
                        this.sw.write("\\clbrdrb" + sb);
                    }
                }
            }
        }
    }

    private String renderBorder2Table(int rowIndex, int columnIndex, int height, int width, Boolean returnValue) throws IOException {
        Boolean needBorderLeft = true;
        Boolean needBorderRight = true;
        for (int index = 0; index < height + 1; ++index) {
            if (this.matrix.getBordersY()[rowIndex - 1 + index][columnIndex - 1] == null) {
                needBorderLeft = false;
            }
            if (this.matrix.getBordersY()[rowIndex - 1 + index][columnIndex - 1 + width + 1] != null) continue;
            needBorderRight = false;
        }
        Boolean needBorderTop = true;
        Boolean needBorderBottom = true;
        for (int index = 0; index < width + 1; ++index) {
            if (this.matrix.getBordersX()[rowIndex - 1][columnIndex - 1 + index] == null) {
                needBorderTop = false;
            }
            if (this.matrix.getBordersX()[rowIndex - 1 + height + 1][columnIndex - 1 + index] != null) continue;
            needBorderBottom = false;
        }
        StringBuilder sb = new StringBuilder();
        if (needBorderLeft.booleanValue()) {
            sb.append("\\clbrdrl" + this.getLineStyle(this.matrix.getBordersY()[rowIndex - 1][columnIndex - 1], this.colorList));
        }
        if (needBorderRight.booleanValue()) {
            sb.append("\\clbrdrr" + this.getLineStyle(this.matrix.getBordersY()[rowIndex - 1][columnIndex - 1 + width + 1], this.colorList));
        }
        if (needBorderTop.booleanValue()) {
            sb.append("\\clbrdrt" + this.getLineStyle(this.matrix.getBordersX()[rowIndex - 1][columnIndex - 1], this.colorList));
        }
        if (needBorderBottom.booleanValue()) {
            sb.append("\\clbrdrb" + this.getLineStyle(this.matrix.getBordersX()[rowIndex - 1 + height + 1][columnIndex - 1], this.colorList));
        }
        if (returnValue.booleanValue()) {
            return sb.toString();
        }
        if (sb.length() > 0) {
            this.sw.write(sb.toString());
        }
        return null;
    }

    private StiEnumSet<StiBorderSides> renderBorder2TableGetValues(int rowIndex, int columnIndex, StringBuilder sb) {
        StiEnumSet sides = StiEnumSet.of((Enum)StiBorderSides.None);
        if (this.matrix.getBordersY()[rowIndex - 1][columnIndex - 1] != null) {
            sides.add((IStiEnum)StiBorderSides.Left);
        }
        if (this.matrix.getBordersY()[rowIndex - 1][columnIndex - 1 + 1] != null) {
            sides.add((IStiEnum)StiBorderSides.Right);
        }
        if (this.matrix.getBordersX()[rowIndex - 1][columnIndex - 1] != null) {
            sb.append("\\clbrdrt" + this.getLineStyle(this.matrix.getBordersX()[rowIndex - 1][columnIndex - 1], this.colorList));
            sides.add((IStiEnum)StiBorderSides.Top);
        }
        if (this.matrix.getBordersX()[rowIndex - 1 + 1][columnIndex - 1] != null) {
            sb.append("\\clbrdrb" + this.getLineStyle(this.matrix.getBordersX()[rowIndex - 1 + 1][columnIndex - 1], this.colorList));
            sides.add((IStiEnum)StiBorderSides.Bottom);
        }
        return sides;
    }

    private void renderBrush1(StiComponent component) throws IOException {
        StiColor tempColor;
        IStiBrush mBrush;
        IStiBrush iStiBrush = mBrush = component instanceof IStiBrush ? (IStiBrush)((Object)component) : null;
        if (mBrush != null && !component.isExportAsImage(StiExportFormat.Rtf) && (tempColor = StiBrush.ToColor((StiBrush)mBrush.getBrush())).getA() != 0) {
            String tempColorSt = this.getColorNumber(this.colorList, tempColor);
            this.sw.write(String.format("\\cbpat%s", tempColorSt));
        }
    }

    private void renderBrush2(StiComponent component) throws IOException {
        IStiBrush mBrush;
        IStiBrush iStiBrush = mBrush = component instanceof IStiBrush ? (IStiBrush)((Object)component) : null;
        if (mBrush != null && !component.isExportAsImage(StiExportFormat.Rtf)) {
            StiColor tempColor = StiBrush.ToColor((StiBrush)mBrush.getBrush());
            this.sw.write("{\\sp{\\sn fillColor}{\\sv ");
            this.sw.write(String.format("%s", tempColor.getB() * 65536 + tempColor.getG() * 256 + tempColor.getR()));
            this.sw.write("}}");
            if (tempColor.getA() != 0) {
                this.sw.write("{\\sp{\\sn fFilled}{\\sv 1}} ");
            } else {
                this.sw.write("{\\sp{\\sn fFilled}{\\sv 0}} ");
            }
        }
    }

    private void renderTextBrush12(StiComponent component) throws IOException {
        IStiTextBrush mTextBrush;
        IStiTextBrush iStiTextBrush = mTextBrush = component instanceof IStiTextBrush ? (IStiTextBrush)((Object)component) : null;
        if (mTextBrush != null) {
            String tempColor = this.getColorNumber(this.colorList, StiBrush.ToColor((StiBrush)mTextBrush.getTextBrush()));
            this.sw.write(String.format("\\cf%s", tempColor));
        }
    }

    private void renderTextFont12(StiComponent component) throws IOException {
        IStiFont mFont;
        IStiFont iStiFont = mFont = component instanceof IStiFont ? (IStiFont)((Object)component) : null;
        if (mFont != null) {
            this.baseFontNumber = this.getFontNumber(this.fontList, mFont.getFont());
            this.sw.write(String.format("\\f%s", this.baseFontNumber));
            this.sw.write(String.format("\\fs%s", Math.round(mFont.getFont().getSize() * 2.0)));
            if (mFont.getFont().bold()) {
                this.sw.write("\\b");
            }
            if (mFont.getFont().italic()) {
                this.sw.write("\\i");
            }
            if (mFont.getFont().underline()) {
                this.sw.write("\\ul");
            }
            this.sw.write(String.format("\\sl%s\\slmult1", Math.round(240.0 * ExportOptions.Rtf.getLineSpacing())));
            if (ExportOptions.Rtf.getSpaceBetweenCharacters() != 0) {
                this.sw.write(String.format("\\expndtw%s", ExportOptions.Rtf.getSpaceBetweenCharacters()));
            }
        }
    }

    private void renderText12(StiComponent component) throws IOException {
        IStiTextOptions textOpt;
        IStiText text = component instanceof IStiText ? (IStiText)((Object)component) : null;
        IStiTextOptions iStiTextOptions = textOpt = component instanceof IStiTextOptions ? (IStiTextOptions)((Object)component) : null;
        if (text != null && !component.isExportAsImage(StiExportFormat.Rtf)) {
            StiText stiText;
            String st = text.getTextInternal() != null ? text.getTextInternal() : "";
            StiText stiText2 = stiText = component instanceof StiText ? (StiText)component : null;
            if (stiText != null && stiText.getAllowHtmlTags()) {
                st = this.convertTextWithHtmlTagsToRtfText(stiText, st);
            }
            if (component instanceof StiText && ((StiText)component).getTextQuality() == StiTextQuality.Wysiwyg && !StiValidationUtil.isNullOrEmpty((String)st) && st.endsWith(StiTextRenderer.StiForceWidthAlignTag)) {
                st = st.substring(0, st.length() - StiTextRenderer.StiForceWidthAlignTag.length());
            }
            StringBuilder stInput = new StringBuilder(st);
            Boolean useRightToLeft = textOpt != null && textOpt.getTextOptions() != null && textOpt.getTextOptions().getRightToLeft();
            StringBuilder sbOutput = this.unicodeToRtfString(stInput, useRightToLeft);
            this.sw.flush();
            for (int i = 0; i < sbOutput.length(); ++i) {
                this.sw2.write(sbOutput.charAt(i));
            }
            this.sw2.flush();
        }
    }

    private void renderImage12(StiComponent component, int absw, int absh) throws IOException {
        IStiExportImage exportImage;
        IStiExportImage iStiExportImage = exportImage = component instanceof IStiExportImage ? (IStiExportImage)((Object)component) : null;
        if (exportImage != null) {
            float zoom = this.imageResolution;
            IStiExportImageExtended exportImageExtended = exportImage instanceof IStiExportImageExtended ? (IStiExportImageExtended)exportImage : null;
            BufferedImage image = null;
            if (component.isExportAsImage(StiExportFormat.Rtf)) {
                image = exportImageExtended != null && exportImageExtended.isExportAsImage(StiExportFormat.Rtf) ? exportImageExtended.getImage(Double.valueOf(zoom), this.imageFormat) : exportImage.getImage(Double.valueOf(zoom));
            }
            if (image != null) {
                this.sw.write(this.getImageString(image, zoom, absw, absh));
            }
        }
    }

    private void renderRtf12(StiComponent component) throws IOException {
        if (component instanceof StiRichText) {
            String st = this.getRtfString(component).replaceAll("\\\\pard", "");
            this.sw.write(st);
        }
    }

    private void renderImage3(StiComponent component, StringBuilder dataStr, int absw, int absh) throws IOException {
        IStiExportImageExtended exportImage;
        IStiExportImageExtended iStiExportImageExtended = exportImage = component instanceof IStiExportImageExtended ? (IStiExportImageExtended)((Object)component) : null;
        if (exportImage != null) {
            float zoom = this.imageResolution;
            IStiExportImageExtended exportImageExtended = exportImage;
            BufferedImage image = null;
            if (component.isExportAsImage(StiExportFormat.Rtf)) {
                image = exportImageExtended != null && exportImageExtended.isExportAsImage(StiExportFormat.Rtf) ? exportImage.getImage(Double.valueOf(zoom), this.imageFormat) : exportImage.getImage(Double.valueOf(zoom));
            }
            if (image != null) {
                dataStr.append(this.getImageString(image, zoom, absw, absh));
            }
        }
    }

    private void renderRtf3(StiComponent component, StringBuilder dataStr) {
        if (component instanceof StiRichText) {
            String st = this.getRtfString(component).replaceAll("\\\\pard", "\\\\par");
            dataStr.append(st);
        }
    }

    private void renderText3(StiComponent component, StringBuilder dataStr) {
        IStiTextOptions textOpt;
        IStiText text = component instanceof IStiText ? (IStiText)((Object)component) : null;
        IStiTextOptions iStiTextOptions = textOpt = component instanceof IStiTextOptions ? (IStiTextOptions)((Object)component) : null;
        if (text != null && !component.isExportAsImage(StiExportFormat.Rtf)) {
            String st = text.getTextInternal();
            if (component instanceof StiText && ((StiText)component).getTextQuality() == StiTextQuality.Wysiwyg && !StiValidationUtil.isNullOrEmpty((String)st) && st.endsWith(StiTextRenderer.StiForceWidthAlignTag)) {
                st = st.substring(0, st.length() - StiTextRenderer.StiForceWidthAlignTag.length());
            }
            StringBuilder stInput = new StringBuilder(st);
            Boolean useRightToLeft = textOpt != null && textOpt.getTextOptions() != null && textOpt.getTextOptions().getRightToLeft();
            StringBuilder sbOutput = this.unicodeToRtfString(stInput, useRightToLeft);
            dataStr.append((CharSequence)sbOutput);
        }
    }

    private void renderTextFont3(StiComponent component, StringBuilder dataStr) {
        IStiFont mFont;
        IStiFont iStiFont = mFont = component instanceof IStiFont ? (IStiFont)((Object)component) : null;
        if (mFont != null) {
            dataStr.append("\\f");
            this.baseFontNumber = this.getFontNumber(this.fontList, mFont.getFont());
            dataStr.append(this.baseFontNumber);
            dataStr.append("\\fs");
            dataStr.append(Math.round(mFont.getFont().getSize() * 2.0));
            if (mFont.getFont().bold()) {
                dataStr.append("\\b");
            }
            if (mFont.getFont().italic()) {
                dataStr.append("\\i");
            }
            if (mFont.getFont().underline()) {
                dataStr.append("\\ul");
            }
            dataStr.append(String.format("\\sl%s\\slmult1", Math.round(240.0 * ExportOptions.Rtf.getLineSpacing())));
            if (ExportOptions.Rtf.getSpaceBetweenCharacters() != 0) {
                dataStr.append(String.format("\\expndtw%s", ExportOptions.Rtf.getSpaceBetweenCharacters()));
            }
        }
    }

    private void renderTextBrush3(StiComponent component, StringBuilder dataStr) {
        IStiTextBrush mTextBrush;
        IStiTextBrush iStiTextBrush = mTextBrush = component instanceof IStiTextBrush ? (IStiTextBrush)((Object)component) : null;
        if (mTextBrush != null) {
            String tempColor = this.getColorNumber(this.colorList, StiBrush.ToColor((StiBrush)mTextBrush.getTextBrush()));
            dataStr.append("\\cf");
            dataStr.append(tempColor);
        }
    }

    private void renderBrush3(StiComponent component, StringBuilder dataStr) {
        IStiBrush mBrush;
        IStiBrush iStiBrush = mBrush = component instanceof IStiBrush ? (IStiBrush)((Object)component) : null;
        if (mBrush != null && !component.isExportAsImage(StiExportFormat.Rtf)) {
            String tempColor = this.getColorNumber(this.colorList, StiBrush.ToColor((StiBrush)mBrush.getBrush()));
            dataStr.append("\\cbpat");
            dataStr.append(tempColor);
        }
    }

    private void renderBorder3(StiComponent component, StringBuilder dataStr) {
        IStiBorder mBorder;
        IStiBorder iStiBorder = mBorder = component instanceof IStiBorder ? (IStiBorder)((Object)component) : null;
        if (mBorder != null && !(component instanceof IStiIgnoreBorderWhenExport)) {
            if (mBorder.getBorder() instanceof StiAdvancedBorder) {
                StiAdvancedBorder advBorder = (StiAdvancedBorder)mBorder.getBorder();
                if (advBorder.isLeftBorderSidePresent() && advBorder.getLeftSide().getColor().getA() != 0) {
                    dataStr.append("\\brdrl" + this.getLineStyle(advBorder.getLeftSide(), this.colorList));
                }
                if (advBorder.isRightBorderSidePresent() && advBorder.getRightSide().getColor().getA() != 0) {
                    dataStr.append("\\brdrr" + this.getLineStyle(advBorder.getRightSide(), this.colorList));
                }
                if (advBorder.isTopBorderSidePresent() && advBorder.getTopSide().getColor().getA() != 0) {
                    dataStr.append("\\brdrt" + this.getLineStyle(advBorder.getTopSide(), this.colorList));
                }
                if (advBorder.isBottomBorderSidePresent() && advBorder.getBottomSide().getColor().getA() != 0) {
                    dataStr.append("\\brdrb" + this.getLineStyle(advBorder.getBottomSide(), this.colorList));
                }
            } else {
                StiColor tempColor = mBorder.getBorder().getColor();
                if (tempColor.getA() != 0) {
                    String sb = this.getLineStyle(new StiBorderSide(mBorder.getBorder().getColor(), mBorder.getBorder().getSize(), mBorder.getBorder().getStyle()), this.colorList);
                    if (mBorder.getBorder().getSide().contains((IStiEnum)StiBorderSides.Left)) {
                        dataStr.append("\\brdrl" + sb);
                    }
                    if (mBorder.getBorder().getSide().contains((IStiEnum)StiBorderSides.Right)) {
                        dataStr.append("\\brdrr" + sb);
                    }
                    if (mBorder.getBorder().getSide().contains((IStiEnum)StiBorderSides.Top)) {
                        dataStr.append("\\brdrt" + sb);
                    }
                    if (mBorder.getBorder().getSide().contains((IStiEnum)StiBorderSides.Bottom)) {
                        dataStr.append("\\brdrb" + sb);
                    }
                }
            }
        }
    }

    private void renderStyle12(StiComponent component) throws IOException {
        if (this.useStyles.booleanValue() && component instanceof StiText) {
            int styleNumber = this.getRtfStyleFromComponent(component);
            this.sw.write(String.format("\\s%s", styleNumber));
        }
    }

    private void writeFromMatrix(int beginLine, int endLine, Boolean outHeadersAndFooters) throws IOException {
        int maxCoordX = this.matrix.getCoordX().size();
        int[] rtfCoordX = new int[this.matrix.getCoordX().size()];
        for (int columnIndex = 1; columnIndex < this.matrix.getCoordX().size(); ++columnIndex) {
            double value = (Double)StiMapUtil.getByIndex(this.matrix.getCoordX(), columnIndex);
            rtfCoordX[columnIndex] = (int)Math.round(value * 14.4);
        }
        int[][] readyCells = new int[this.matrix.getCoordY().size()][this.matrix.getCoordX().size()];
        int[][] readyCellsVert = new int[this.matrix.getCoordY().size()][this.matrix.getCoordX().size()];
        String lastHeaderParentBandName = "";
        int counterParagraphLines = 0;
        this.setStatusString(StiLocalization.getValue((String)"Export", (String)"ExportingCreatingDocument"));
        for (int rowIndex = 1; rowIndex < this.matrix.getCoordY().size(); ++rowIndex) {
            String description;
            StiCellStyle style;
            StiCell cell;
            int columnIndex;
            this.invokeExporting(rowIndex, this.matrix.getCoordY().size());
            int rowHeight = (int)Math.round(((Double)StiMapUtil.getByIndex(this.matrix.getCoordY(), rowIndex) - (Double)StiMapUtil.getByIndex(this.matrix.getCoordY(), rowIndex - 1)) * 14.4);
            Boolean needOutLine = rowIndex - 1 >= beginLine && rowIndex - 1 <= endLine && counterParagraphLines == 0;
            if (counterParagraphLines > 0) {
                --counterParagraphLines;
            }
            if (!(outHeadersAndFooters.booleanValue() || this.matrix.getLinePlacement()[rowIndex - 1] != StiMatrix.StiTableLineInfo.PageHeader && this.matrix.getLinePlacement()[rowIndex - 1] != StiMatrix.StiTableLineInfo.PageFooter && this.matrix.getLinePlacement()[rowIndex - 1] != StiMatrix.StiTableLineInfo.Trash)) {
                needOutLine = false;
            }
            double maxTopMargin = 100005.0;
            ArrayList<StiCell> paragraphList = new ArrayList<StiCell>();
            Boolean needNewPage = false;
            Boolean needBreak = ExportOptions.Rtf.getUseCanBreakProperty();
            if (needOutLine.booleanValue()) {
                for (int columnIndex2 = 1; columnIndex2 < maxCoordX; ++columnIndex2) {
                    IStiBreakable breakable;
                    StiCell cell2 = this.matrix.getCells()[rowIndex - 1][columnIndex2 - 1];
                    if (readyCells[rowIndex][columnIndex2] < 0 || cell2 == null || cell2.getComponent() == null) continue;
                    if (cell2.getComponent().getTagValue() != null) {
                        String cellTag = cell2.getComponent().getTagValue().toString().toLowerCase();
                        if (cellTag.indexOf("rtfparagraph") != -1) {
                            paragraphList.add(cell2);
                            needOutLine = false;
                        }
                        if (cellTag.indexOf("rtfnewpage") != -1) {
                            needNewPage = true;
                        }
                    }
                    IStiBreakable iStiBreakable = breakable = cell2.getComponent() instanceof IStiBreakable ? (IStiBreakable)((Object)cell2.getComponent()) : null;
                    if (breakable != null && !breakable.getCanBreak()) {
                        needBreak = false;
                    }
                    StiMargins margins = null;
                    if (cell2.getComponent() instanceof StiText) {
                        margins = ((StiText)cell2.getComponent()).getMargins();
                    }
                    if (cell2.getComponent() instanceof StiRichText) {
                        margins = ((StiRichText)cell2.getComponent()).getMargins();
                    }
                    if (margins == null) continue;
                    if (margins.getTop() < maxTopMargin) {
                        maxTopMargin = margins.getTop();
                    }
                    if (cell2.getHeight() <= 0) continue;
                    maxTopMargin = 0.0;
                }
            }
            if (needNewPage.booleanValue()) {
                this.sw.write("}\\fs2\\page\\par{\r\n");
            }
            if (!this.usePageHeadersAndFooters.booleanValue()) {
                needBreak = false;
            }
            int maxTopMarginInt = (int)Math.round(maxTopMargin *= 14.4);
            if (needOutLine.booleanValue()) {
                if (this.usePageHeadersAndFooters.booleanValue() && this.matrix.getLinePlacement()[rowIndex - 1] == StiMatrix.StiTableLineInfo.HeaderAP) {
                    String headerName = this.matrix.getParentBandName()[rowIndex - 1];
                    int symPos = headerName.indexOf(31);
                    if (symPos != -1) {
                        headerName = headerName.substring(0, symPos);
                    }
                    if (headerName != lastHeaderParentBandName) {
                        lastHeaderParentBandName = headerName;
                        this.sw.write("}\\fs2\\par{\r\n");
                    }
                }
                Boolean notNeedLineHeightExactly = this.usePageHeadersAndFooters != false && this.matrix.getLinePlacement()[rowIndex - 1] != StiMatrix.StiTableLineInfo.Empty || !ExportOptions.Rtf.getLineHeightExactly();
                this.sw.write("\\trowd");
                if (!this.usePageHeadersAndFooters.booleanValue() || ExportOptions.Rtf.getForceLineHeight()) {
                    this.sw.write(String.format("\\trrh%s%s", notNeedLineHeightExactly != false ? "" : "-", rowHeight));
                }
                if (!needBreak.booleanValue()) {
                    this.sw.write("\\trkeep");
                }
                this.sw.write("\\ltrrow");
                if (this.usePageHeadersAndFooters.booleanValue() && this.matrix.getLinePlacement()[rowIndex - 1] == StiMatrix.StiTableLineInfo.HeaderAP) {
                    this.sw.write("\\trhdr");
                }
            }
            StringBuilder sbt = new StringBuilder();
            int curCoordX = 0;
            for (columnIndex = 1; columnIndex < maxCoordX; ++columnIndex) {
                cell = this.matrix.getCells()[rowIndex - 1][columnIndex - 1];
                if (readyCells[rowIndex][columnIndex] >= 0) {
                    StringBuilder baseSt;
                    StiEnumSet<StiBorderSides> baseSides;
                    ++curCoordX;
                    sbt.append("{");
                    if (cell != null) {
                        String text;
                        String bkm;
                        style = cell.getCellStyle();
                        Boolean mRightToLeft = false;
                        if (style.getTextOptions() != null) {
                            mRightToLeft = style.getTextOptions().getRightToLeft();
                        }
                        StiFont mFont = style.getFont();
                        this.baseFontNumber = this.getFontNumber(this.fontList, mFont);
                        if (this.useStyles.booleanValue()) {
                            int styleNumber = this.getRtfStyleFromComponent(cell.getComponent());
                            sbt.append(String.format("\\s%s", styleNumber));
                        }
                        if (mRightToLeft.booleanValue()) {
                            sbt.append("\\rtlpar");
                        } else {
                            sbt.append("\\ltrpar");
                        }
                        sbt.append(this.makeHorAlignString(style.getHorAlignment(), mRightToLeft));
                        String tempColor = this.getColorNumber(this.colorList, style.getTextColor());
                        sbt.append(String.format("\\cf%s", tempColor));
                        sbt.append(String.format("\\f%s", this.baseFontNumber));
                        sbt.append(String.format("\\fs%s", Math.round(mFont.getSize() * 2.0)));
                        if (mFont.bold()) {
                            sbt.append("\\b");
                        }
                        if (mFont.italic()) {
                            sbt.append("\\i");
                        }
                        if (mFont.underline()) {
                            sbt.append("\\ul");
                        }
                        sbt.append(String.format("\\sl%s\\slmult1", Math.round(240.0 * ExportOptions.Rtf.getLineSpacing())));
                        if (ExportOptions.Rtf.getSpaceBetweenCharacters() != 0) {
                            sbt.append(String.format("\\expndtw%s", ExportOptions.Rtf.getSpaceBetweenCharacters()));
                        }
                        if ((bkm = this.matrix.getBookmarks()[rowIndex - 1][columnIndex - 1]) != null && needOutLine.booleanValue() && !this.usedBookmarks.containsKey(bkm)) {
                            this.usedBookmarks.put(bkm, bkm);
                            String stRef = this.convertStringToBookmark(bkm);
                            sbt.append((CharSequence)this.unicodeToRtfString(new StringBuilder('\u001c' + stRef + '\u001d' + stRef + '\u001e'), false));
                        }
                        if (!(cell.getComponent() instanceof StiRichText) && (text = cell.getText()) != null && text.length() > 0 && !cell.getComponent().isExportAsImage(StiExportFormat.Rtf)) {
                            String hyperlink;
                            String expr;
                            StiText stiText = cell.getComponent() instanceof StiText ? (StiText)cell.getComponent() : null;
                            StringBuilder stInput = new StringBuilder(text);
                            if (stiText != null && stiText.getAllowHtmlTags()) {
                                stInput = new StringBuilder(this.convertTextWithHtmlTagsToRtfText(stiText, text));
                            }
                            if (this.usePageHeadersAndFooters.booleanValue() && (expr = cell.getComponent().getTagValue()) != null && expr.length() > 0) {
                                if (ExportOptions.Rtf.getUsePageRefField() && this.bookmarkList.containsKey(expr)) {
                                    stInput = new StringBuilder("\u001aPAGEREF " + this.convertStringToBookmark(expr) + '\u001b' + cell.getText() + "\u001e\u001e\u001e");
                                } else if (expr.toLowerCase().indexOf("rtfnewpage") == -1 && (expr.indexOf("#PageNumber#") != -1 || expr.indexOf("#TotalPageCount#") != -1 || expr.indexOf("#PageRef") != -1)) {
                                    stInput = new StringBuilder(expr.replaceAll("#PageNumber#", "\u0018").replaceAll("#TotalPageCount#", "\u0019"));
                                    int pos = 0;
                                    while ((pos = expr.indexOf("#PageRef", pos)) != -1) {
                                        int pos2;
                                        for (pos2 = pos + 8; pos2 < expr.length() && expr.charAt(pos2) != '#'; ++pos2) {
                                        }
                                        stInput = new StringBuilder(stInput.toString().replaceAll(expr.substring(pos, pos2 + 1), "\u001aPAGEREF " + expr + '\u001b' + cell.getText() + "\u001e\u001e\u001e"));
                                        pos += 8;
                                    }
                                }
                            }
                            if (cell.getComponent().getHyperlinkValue() != null && (hyperlink = cell.getComponent().getHyperlinkValue().trim()).length() > 0 && !hyperlink.startsWith("javascript:")) {
                                String description2 = stInput.toString();
                                if (description2.length() == 0) {
                                    description2 = hyperlink;
                                }
                                if (hyperlink.startsWith("#")) {
                                    hyperlink = hyperlink.substring(1);
                                    stInput = new StringBuilder("\u001aHYPERLINK \\\\l \"" + this.convertStringToBookmark(hyperlink) + '\"' + '\u001b' + description2 + "\u001e\u001e\u001e");
                                } else {
                                    stInput = new StringBuilder("\u001aHYPERLINK \"" + hyperlink + '\"' + '\u001b' + description2 + "\u001e\u001e\u001e");
                                }
                            }
                            StringBuilder sbOutput = this.unicodeToRtfString(stInput, mRightToLeft);
                            sbt.append(String.format(" %s", sbOutput));
                        }
                        if (cell.getComponent() instanceof StiRichText) {
                            StiRichText rtf = (StiRichText)cell.getComponent();
                            if (rtf != null) {
                                String hyperlink;
                                StringBuilder stInput = new StringBuilder(this.replacePardInRtf(this.getRtfString(cell.getComponent())));
                                if (cell.getComponent().getHyperlinkValue() != null && (hyperlink = cell.getComponent().getHyperlinkValue().trim()).length() > 0 && !hyperlink.startsWith("javascript:")) {
                                    description = stInput.toString();
                                    if (description.length() == 0) {
                                        description = hyperlink;
                                    }
                                    if (hyperlink.startsWith("#")) {
                                        hyperlink = hyperlink.substring(1);
                                        stInput = new StringBuilder("\u001aHYPERLINK \\\\l \"" + this.convertStringToBookmark(hyperlink) + '\"' + '\u001b' + description + "\u001e\u001e\u001e");
                                    } else {
                                        stInput = new StringBuilder("\u001aHYPERLINK \"" + hyperlink + '\"' + '\u001b' + description + "\u001e\u001e\u001e");
                                    }
                                }
                                String sttInput = stInput.toString().replaceAll("\u0017", "\\").replaceAll("\u0018", "{\\field{\\*\\fldinst {PAGE}}}").replaceAll("\u0019", "{\\field{\\*\\fldinst {NUMPAGES}}}").replaceAll("\u001a", "{\\field{\\*\\fldinst {").replaceAll("\u001b", " }}{\\fldrslt {").replaceAll("\u001c", "{\\*\\bkmkstart ").replaceAll("\u001d", "}{\\*\\bkmkend ").replaceAll("\u001e", "}");
                                sbt.append(sttInput);
                            }
                        } else {
                            IStiExportImage exportImage;
                            IStiExportImage iStiExportImage = exportImage = cell.getComponent() instanceof IStiExportImage ? (IStiExportImage)((Object)cell.getComponent()) : null;
                            if (exportImage != null) {
                                float zoom = this.imageResolution;
                                IStiExportImageExtended exportImageExtended = exportImage instanceof IStiExportImageExtended ? (IStiExportImageExtended)exportImage : null;
                                BufferedImage image = null;
                                if (cell.getComponent().isExportAsImage(StiExportFormat.Rtf)) {
                                    image = exportImageExtended != null && exportImageExtended.isExportAsImage(StiExportFormat.Rtf) ? exportImageExtended.getImage(Double.valueOf(zoom), this.imageFormat) : exportImage.getImage(Double.valueOf(zoom));
                                }
                                if (image != null) {
                                    String hyperlink;
                                    BufferedImage img = this.matrix.getRealImageData(cell, image);
                                    if (img != null) {
                                        image = img;
                                    }
                                    String stImage = this.getImageString(image, zoom, (int)Math.round(((Double)StiMapUtil.getByIndex(this.matrix.getCoordX(), columnIndex + cell.getWidth()) - (Double)StiMapUtil.getByIndex(this.matrix.getCoordX(), columnIndex - 1)) * 14.4), (int)Math.round(((Double)StiMapUtil.getByIndex(this.matrix.getCoordY(), rowIndex + cell.getHeight()) - (Double)StiMapUtil.getByIndex(this.matrix.getCoordY(), rowIndex - 1)) * 14.4));
                                    if (cell.getComponent().getHyperlinkValue() != null && (hyperlink = cell.getComponent().getHyperlinkValue().trim()).length() > 0 && !hyperlink.startsWith("javascript:")) {
                                        String description3 = stImage;
                                        if (hyperlink.startsWith("#")) {
                                            hyperlink = hyperlink.substring(1);
                                            stImage = "{\\field{\\*\\fldinst {HYPERLINK \\\\l \"" + this.convertStringToBookmark(hyperlink) + '\"' + " }}{\\fldrslt {" + description3 + "}}}";
                                        } else {
                                            stImage = "{\\field{\\*\\fldinst {HYPERLINK \"" + hyperlink + '\"' + " }}{\\fldrslt {" + description3 + "}}}";
                                        }
                                    }
                                    sbt.append(stImage);
                                    sbt.append("\\f0\\fs2");
                                }
                            }
                        }
                        if (readyCellsVert[rowIndex][columnIndex] != 2) {
                            int yy;
                            for (yy = 0; yy <= cell.getHeight(); ++yy) {
                                for (int xx = 0; xx <= cell.getWidth(); ++xx) {
                                    readyCells[rowIndex + yy][columnIndex + xx] = -1;
                                }
                                readyCells[rowIndex + yy][columnIndex] = cell.getWidth();
                            }
                            if (cell.getHeight() > 0) {
                                readyCellsVert[rowIndex][columnIndex] = 1;
                                for (yy = 1; yy <= cell.getHeight(); ++yy) {
                                    readyCellsVert[rowIndex + yy][columnIndex] = 2;
                                }
                            }
                        }
                    } else if (readyCellsVert[rowIndex][columnIndex] == 0 && ExportOptions.Rtf.getForceEmptyCellsOptimization() && !(baseSides = this.renderBorder2TableGetValues(rowIndex, columnIndex, baseSt = new StringBuilder())).contains((IStiEnum)StiBorderSides.Right)) {
                        StringBuilder newSt;
                        StiEnumSet<StiBorderSides> newSides;
                        int newWidth = 0;
                        while (columnIndex + newWidth + 1 < maxCoordX && this.matrix.getCells()[rowIndex - 1][columnIndex + newWidth + 1 - 1] == null && readyCells[rowIndex][columnIndex + newWidth + 1] == 0 && readyCellsVert[rowIndex][columnIndex + newWidth + 1] == 0 && !(newSides = this.renderBorder2TableGetValues(rowIndex, columnIndex + newWidth + 1, newSt = new StringBuilder())).contains((IStiEnum)StiBorderSides.Left) && (newSides.contains((IStiEnum)StiBorderSides.Top) | newSides.contains((IStiEnum)StiBorderSides.Bottom)) == (baseSides.contains((IStiEnum)StiBorderSides.Top) | baseSides.contains((IStiEnum)StiBorderSides.Bottom)) && baseSt.toString().equals(newSt.toString())) {
                            ++newWidth;
                            if (!newSides.contains((IStiEnum)StiBorderSides.Right)) continue;
                            break;
                        }
                        if (newWidth > 0) {
                            for (int xx = 1; xx <= newWidth; ++xx) {
                                readyCells[rowIndex][columnIndex + xx] = -1;
                            }
                            readyCells[rowIndex][columnIndex] = newWidth;
                        }
                    }
                    sbt.append("\\cell}");
                }
                if (curCoordX >= 64) break;
            }
            if (needOutLine.booleanValue()) {
                curCoordX = 0;
                for (columnIndex = 1; columnIndex < maxCoordX; ++columnIndex) {
                    if (readyCellsVert[rowIndex][columnIndex] == 1) {
                        this.sw.write("\\clvmgf");
                    }
                    if (readyCellsVert[rowIndex][columnIndex] == 2) {
                        this.sw.write("\\clvmrg");
                    }
                    if (readyCells[rowIndex][columnIndex] >= 0) {
                        ++curCoordX;
                        if (readyCellsVert[rowIndex][columnIndex] == 2) {
                            int tempRowIndex = rowIndex;
                            while (readyCellsVert[tempRowIndex][columnIndex] == 2) {
                                --tempRowIndex;
                            }
                            StiCell cell3 = this.matrix.getCells()[tempRowIndex - 1][columnIndex - 1];
                            this.renderBorder2Table(tempRowIndex, columnIndex, cell3.getHeight(), cell3.getWidth(), false);
                        } else {
                            cell = this.matrix.getCells()[rowIndex - 1][columnIndex - 1];
                            if (cell != null) {
                                style = cell.getCellStyle();
                                this.renderVerAlign2(cell.getComponent());
                                this.renderBorder2Table(rowIndex, columnIndex, cell.getHeight(), cell.getWidth(), false);
                                this.renderTextAngle2(cell.getComponent());
                                if (!cell.getComponent().isExportAsImage(StiExportFormat.Rtf)) {
                                    StiRichText mRichText;
                                    StiColor tempColor = style.getColor();
                                    if (tempColor.getA() != 0) {
                                        String tempColorSt = this.getColorNumber(this.colorList, tempColor);
                                        this.sw.write(String.format("\\clcbpat%s", tempColorSt));
                                    }
                                    StiText mText = cell.getComponent() instanceof StiText ? (StiText)cell.getComponent() : null;
                                    StiRichText stiRichText = mRichText = cell.getComponent() instanceof StiRichText ? (StiRichText)cell.getComponent() : null;
                                    if (mText != null || mRichText != null) {
                                        int corr = ExportOptions.Rtf.getRightMarginCorrection();
                                        int mLeft = 0;
                                        int mRight = 0;
                                        int mTop = 0;
                                        if (mText != null) {
                                            mLeft = (int)Math.round(mText.getMargins().getLeft() * 14.4);
                                            mRight = (int)Math.round((mText.getMargins().getRight() - (double)corr) * 14.4);
                                            mTop = (int)Math.round(mText.getMargins().getTop() * 14.4);
                                        }
                                        if (mRichText != null) {
                                            mLeft = (int)Math.round(mRichText.getMargins().getLeft() * 14.4);
                                            mRight = (int)Math.round((mRichText.getMargins().getRight() - (double)corr) * 14.4);
                                            mTop = (int)Math.round(mRichText.getMargins().getTop() * 14.4);
                                        }
                                        if (mTop > maxTopMarginInt) {
                                            mTop = maxTopMarginInt;
                                        }
                                        if (mLeft > 0) {
                                            this.sw.write(String.format("\\clpadt%s\\clpadft3", mLeft));
                                        }
                                        if (mRight > 0) {
                                            this.sw.write(String.format("\\clpadr%s\\clpadfr3", mRight));
                                        }
                                        if (mTop > 0) {
                                            this.sw.write(String.format("\\clpadl%s\\clpadfl3", mTop));
                                        }
                                    }
                                }
                            } else {
                                this.renderBorder2Table(rowIndex, columnIndex, 0, readyCells[rowIndex][columnIndex], false);
                            }
                        }
                    }
                    if (readyCells[rowIndex][columnIndex] >= 0) {
                        this.sw.write(String.format("\\cellx%s", rtfCoordX[columnIndex + readyCells[rowIndex][columnIndex]]));
                    }
                    if (curCoordX >= 64) break;
                }
                this.sw.write("\\pard\\intbl ");
                this.sw.flush();
                for (int i = 0; i < sbt.length(); ++i) {
                    this.sw2.write(sbt.charAt(i));
                }
                this.sw2.flush();
                this.sw.write("\\row\r\n");
            }
            for (StiCell paragraphCell : paragraphList) {
                this.sw.write("\\pard{");
                sbt = new StringBuilder();
                counterParagraphLines = paragraphCell.getHeight();
                String text = paragraphCell.getText();
                if (!(paragraphCell.getComponent() instanceof StiRichText) && text != null && text.length() > 0 && !paragraphCell.getComponent().isExportAsImage(StiExportFormat.Rtf)) {
                    String hyperlink;
                    StiText stiText;
                    StiCellStyle style2 = paragraphCell.getCellStyle();
                    Boolean mRightToLeft = false;
                    if (style2.getTextOptions() != null) {
                        mRightToLeft = style2.getTextOptions().getRightToLeft();
                    }
                    StiFont mFont = style2.getFont();
                    this.baseFontNumber = this.getFontNumber(this.fontList, mFont);
                    if (this.useStyles.booleanValue()) {
                        int styleNumber = this.getRtfStyleFromComponent(paragraphCell.getComponent());
                        sbt.append(String.format("\\s%s", styleNumber));
                    }
                    if (mRightToLeft.booleanValue()) {
                        sbt.append("\\rtlpar");
                    } else {
                        sbt.append("\\ltrpar");
                    }
                    sbt.append(this.makeHorAlignString(style2.getHorAlignment(), mRightToLeft));
                    String tempColor = this.getColorNumber(this.colorList, style2.getTextColor());
                    sbt.append(String.format("\\cf%s", tempColor));
                    sbt.append(String.format("\\f%s", this.baseFontNumber));
                    sbt.append(String.format("\\fs%s", Math.round(mFont.getSize() * 2.0)));
                    if (mFont.bold()) {
                        sbt.append("\\b");
                    }
                    if (mFont.italic()) {
                        sbt.append("\\i");
                    }
                    if (mFont.underline()) {
                        sbt.append("\\ul");
                    }
                    sbt.append(String.format("\\sl%s\\slmult1", Math.round(240.0 * ExportOptions.Rtf.getLineSpacing())));
                    if (ExportOptions.Rtf.getSpaceBetweenCharacters() != 0) {
                        sbt.append(String.format("\\expndtw%s", ExportOptions.Rtf.getSpaceBetweenCharacters()));
                    }
                    StringBuilder stInput = new StringBuilder(text);
                    StiText stiText2 = stiText = paragraphCell.getComponent() instanceof StiText ? (StiText)paragraphCell.getComponent() : null;
                    if (stiText != null && stiText.getAllowHtmlTags()) {
                        stInput = new StringBuilder(this.convertTextWithHtmlTagsToRtfText(stiText, text));
                    }
                    if (paragraphCell.getComponent().getHyperlinkValue() != null && (hyperlink = paragraphCell.getComponent().getHyperlinkValue().trim()).length() > 0 && !hyperlink.startsWith("javascript:")) {
                        description = stInput.toString();
                        if (description.length() == 0) {
                            description = hyperlink;
                        }
                        if (hyperlink.startsWith("#")) {
                            hyperlink = hyperlink.substring(1);
                            stInput = new StringBuilder("\u001aHYPERLINK \\\\l \"" + this.convertStringToBookmark(hyperlink) + '\"' + '\u001b' + description + "\u001e\u001e\u001e");
                        } else {
                            stInput = new StringBuilder("\u001aHYPERLINK \"" + hyperlink + '\"' + '\u001b' + description + "\u001e\u001e\u001e");
                        }
                    }
                    StringBuilder sbOutput = this.unicodeToRtfString(stInput, mRightToLeft);
                    sbt.append(String.format(" %s", sbOutput));
                }
                if (paragraphCell.getComponent() instanceof StiRichText) {
                    StiRichText rtf = (StiRichText)paragraphCell.getComponent();
                    if (rtf != null) {
                        String hyperlink;
                        StringBuilder stInput = new StringBuilder(this.getRtfString(paragraphCell.getComponent()));
                        if (paragraphCell.getComponent().getHyperlinkValue() != null && (hyperlink = paragraphCell.getComponent().getHyperlinkValue().trim()).length() > 0 && !hyperlink.startsWith("javascript:")) {
                            String description4 = stInput.toString();
                            if (description4.length() == 0) {
                                description4 = hyperlink;
                            }
                            if (hyperlink.startsWith("#")) {
                                hyperlink = hyperlink.substring(1);
                                stInput = new StringBuilder("\u001aHYPERLINK \\\\l \"" + this.convertStringToBookmark(hyperlink) + '\"' + '\u001b' + description4 + "\u001e\u001e\u001e");
                            } else {
                                stInput = new StringBuilder("\u001aHYPERLINK \"" + hyperlink + '\"' + '\u001b' + description4 + "\u001e\u001e\u001e");
                            }
                        }
                        String sttInput = stInput.toString().replaceAll("\u0017", "\\").replaceAll("\u0018", "{\\field{\\*\\fldinst {PAGE}}}").replaceAll("\u0019", "{\\field{\\*\\fldinst {NUMPAGES}}}").replaceAll("\u001a", "{\\field{\\*\\fldinst {").replaceAll("\u001b", " }}{\\fldrslt {").replaceAll("\u001c", "{\\*\\bkmkstart ").replaceAll("\u001d", "}{\\*\\bkmkend ").replaceAll("\u001e", "}");
                        sbt.append(sttInput);
                    }
                } else {
                    IStiExportImage exportImage;
                    IStiExportImage iStiExportImage = exportImage = paragraphCell.getComponent() instanceof IStiExportImage ? (IStiExportImage)((Object)paragraphCell.getComponent()) : null;
                    if (exportImage != null) {
                        float zoom = this.imageResolution;
                        IStiExportImageExtended exportImageExtended = exportImage instanceof IStiExportImageExtended ? (IStiExportImageExtended)exportImage : null;
                        BufferedImage image = null;
                        if (paragraphCell.getComponent().isExportAsImage(StiExportFormat.Rtf)) {
                            image = exportImageExtended != null && exportImageExtended.isExportAsImage(StiExportFormat.Rtf) ? exportImageExtended.getImage(Double.valueOf(zoom), this.imageFormat) : exportImage.getImage(Double.valueOf(zoom));
                        }
                        if (image != null) {
                            String hyperlink;
                            BufferedImage img = this.matrix.getRealImageData(paragraphCell, image);
                            if (img != null) {
                                image = img;
                            }
                            String stImage = this.getImageString(image, zoom, (int)Math.round(((Double)StiMapUtil.getByIndex(this.matrix.getCoordX(), paragraphCell.getLeft() + 1 + paragraphCell.getWidth()) - (Double)StiMapUtil.getByIndex(this.matrix.getCoordX(), paragraphCell.getLeft())) * 14.4), (int)Math.round(((Double)StiMapUtil.getByIndex(this.matrix.getCoordY(), paragraphCell.getTop() + 1 + paragraphCell.getHeight()) - (Double)StiMapUtil.getByIndex(this.matrix.getCoordY(), paragraphCell.getTop())) * 14.4));
                            if (paragraphCell.getComponent().getHyperlinkValue() != null && (hyperlink = paragraphCell.getComponent().getHyperlinkValue().trim()).length() > 0 && !hyperlink.startsWith("javascript:")) {
                                description = stImage;
                                if (hyperlink.startsWith("#")) {
                                    hyperlink = hyperlink.substring(1);
                                    stImage = "{\\field{\\*\\fldinst {HYPERLINK \\\\l \"" + this.convertStringToBookmark(hyperlink) + '\"' + " }}{\\fldrslt {" + description + "}}}";
                                } else {
                                    stImage = "{\\field{\\*\\fldinst {HYPERLINK \"" + hyperlink + '\"' + " }}{\\fldrslt {" + description + "}}}";
                                }
                            }
                            StiTextHorAlignment horAlignment = paragraphCell.getCellStyle().getHorAlignment();
                            if (!(paragraphCell.getComponent() instanceof IStiTextHorAlignment)) {
                                IStiHorAlignment horAlignComp;
                                IStiHorAlignment iStiHorAlignment = horAlignComp = paragraphCell.getComponent() instanceof IStiHorAlignment ? (IStiHorAlignment)((Object)paragraphCell.getComponent()) : null;
                                if (horAlignComp != null) {
                                    horAlignment = horAlignComp.getHorAlignment().toTextHorAlignment();
                                }
                            }
                            Boolean mRightToLeft = false;
                            if (paragraphCell.getCellStyle().getTextOptions() != null) {
                                mRightToLeft = paragraphCell.getCellStyle().getTextOptions().getRightToLeft();
                            }
                            sbt.append(this.makeHorAlignString(horAlignment, mRightToLeft));
                            sbt.append(stImage);
                        }
                    }
                    sbt.append("\\f0\\fs2");
                }
                this.sw.flush();
                for (int i = 0; i < sbt.length(); ++i) {
                    this.sw2.write(sbt.charAt(i));
                }
                this.sw2.flush();
                if (!sbt.toString().trim().endsWith("\\par")) {
                    this.sw.write("\\par");
                }
                this.sw.write("}\r\n");
            }
        }
    }

    @Override
    public void export(StiReport report, OutputStream outputStream, StiExportSettings exportSettings) throws StiException {
        this.exportRtf(report, outputStream, (StiRtfExportSettings)exportSettings);
    }

    public void exportRtf(StiReport report, OutputStream outputStream, StiRtfExportSettings settings) throws StiException {
        try {
            this.exportRtfException(report, outputStream, settings);
        }
        catch (Exception e) {
            throw new StiException((Throwable)e);
        }
    }

    private void exportRtfException(StiReport report, OutputStream outputStream, StiRtfExportSettings settings) throws IOException {
        int index;
        if (settings == null) {
            throw new IllegalArgumentException("The 'settings' argument cannot be equal in null.");
        }
        StiRtfExportMode exportMode = settings.getExportMode();
        StiPagesRange pageRange = settings.getPageRange();
        this.usePageHeadersAndFooters = settings.isUsePageHeadersAndFooters();
        this.removeEmptySpaceAtBottom = settings.isRemoveEmptySpaceAtBottom();
        this.imageResolution = settings.getImageResolution();
        this.imageQuality = settings.getImageQuality();
        boolean storeImagesAsPng = settings.isStoreImagesAsPng();
        this.unicodeMapArray = new int[65536];
        this.codePageToFont = new byte[StiEncode.codePagesTableSize + 1];
        this.fontToCodePages = new int[StiEncode.codePagesTableSize + 1];
        this.charsetCount = 0;
        this.useStyles = true;
        if (this.imageQuality < 0.0f) {
            this.imageQuality = 0.0f;
        }
        if (this.imageQuality > 1.0f) {
            this.imageQuality = 1.0f;
        }
        if (this.imageResolution < 10.0f) {
            this.imageResolution = 10.0f;
        }
        this.imageResolution /= 100.0f;
        this.imageFormat = storeImagesAsPng ? StiExportFormat.ImagePng : StiExportFormat.Rtf;
        double insideScaleY = 12.0;
        double scaleX = 1.0;
        double scaleY = 1.0;
        this.colorList = new ArrayList();
        this.fontList = new ArrayList();
        this.styleList = new ArrayList();
        this.sw2 = outputStream;
        this.sw = new OutputStreamWriter(this.sw2, StiCharsetHelper.WINDOWS_1251);
        for (int index2 = 0; index2 < 65536; ++index2) {
            this.unicodeMapArray[index2] = 0;
        }
        this.bookmarkList = new Hashtable();
        this.usedBookmarks = new Hashtable();
        StiPagesCollection pages = pageRange.getSelectedPages(report.getRenderedPages());
        if (ExportOptions.Rtf.getDivideSegmentPages()) {
            pages = StiSegmentPagesDivider.divide(pages, this);
        }
        this.setStatusString(StiLocalization.getValue((String)"Export", (String)"PreparingReport"));
        for (StiPage page : pages) {
            pages.GetPage(page);
            this.invokeExporting(page, pages);
            for (StiComponent component : page.getComponents()) {
                String bkm;
                StiText text;
                StiRichText rtf;
                IStiFont mFont;
                StiShape shape;
                IStiBorder mBorder;
                IStiBrush mBrush;
                IStiTextBrush mTextBrush;
                if (!component.getEnabled()) continue;
                IStiTextBrush iStiTextBrush = mTextBrush = component instanceof IStiTextBrush ? (IStiTextBrush)((Object)component) : null;
                if (mTextBrush != null) {
                    this.getColorNumberInt(this.colorList, StiBrush.ToColor((StiBrush)mTextBrush.getTextBrush()));
                }
                IStiBrush iStiBrush = mBrush = component instanceof IStiBrush ? (IStiBrush)((Object)component) : null;
                if (mBrush != null) {
                    this.getColorNumber(this.colorList, StiBrush.ToColor((StiBrush)mBrush.getBrush()));
                }
                IStiBorder iStiBorder = mBorder = component instanceof IStiBorder ? (IStiBorder)((Object)component) : null;
                if (mBorder != null && !(component instanceof IStiIgnoreBorderWhenExport)) {
                    StiAdvancedBorder advBorder;
                    StiAdvancedBorder stiAdvancedBorder = advBorder = mBorder.getBorder() instanceof StiAdvancedBorder ? (StiAdvancedBorder)mBorder.getBorder() : null;
                    if (advBorder != null) {
                        this.getColorNumber(this.colorList, advBorder.getLeftSide().getColor());
                        this.getColorNumber(this.colorList, advBorder.getRightSide().getColor());
                        this.getColorNumber(this.colorList, advBorder.getTopSide().getColor());
                        this.getColorNumber(this.colorList, advBorder.getBottomSide().getColor());
                    } else {
                        this.getColorNumber(this.colorList, mBorder.getBorder().getColor());
                    }
                }
                StiShape stiShape = shape = component instanceof StiShape ? (StiShape)component : null;
                if (shape != null) {
                    this.getColorNumber(this.colorList, shape.getBorderColor());
                }
                IStiFont iStiFont = mFont = component instanceof IStiFont ? (IStiFont)((Object)component) : null;
                if (mFont != null) {
                    this.getFontNumber(this.fontList, mFont.getFont());
                }
                StiRichText stiRichText = rtf = component instanceof StiRichText ? (StiRichText)component : null;
                if (rtf != null) {
                    this.getRtfString(component);
                    this.getColorNumber(this.colorList, rtf.getBackColor());
                }
                StiText stiText = text = component instanceof StiText ? (StiText)component : null;
                if (text != null) {
                    StringBuilder sbbb = new StringBuilder(text.getTextInternal() != null ? text.getTextInternal() : "");
                    if (text.getAllowHtmlTags()) {
                        sbbb = new StringBuilder(this.convertTextWithHtmlTagsToRtfText(text, text.getTextInternal()));
                    }
                    StringBuilder sb = this.checkArabic(sbbb);
                    for (int indexChar = 0; indexChar < sb.length(); ++indexChar) {
                        this.unicodeMapArray[sb.charAt((int)indexChar)] = 1;
                    }
                    this.getRtfStyleFromComponent(component);
                }
                if (!ExportOptions.Rtf.getUsePageRefField() || component.getBookmarkValue() == null || (bkm = component.getBookmarkValue()) == null || bkm.length() <= 0 || this.bookmarkList.containsKey(bkm)) continue;
                this.bookmarkList.put(bkm, bkm);
            }
        }
        if (exportMode == StiRtfExportMode.Table) {
            this.getFontNumber(this.fontList, "Arial");
        }
        for (index = 0; index < 65536; ++index) {
            if (this.unicodeMapArray[index] == 0) continue;
            this.codePageToFont[StiEncode.unicodeToCodePageArray[index]] = 1;
        }
        this.codePageToFont[1] = 1;
        for (index = 1; index < StiEncode.codePagesTableSize + 1; ++index) {
            if (this.codePageToFont[index] == 0) continue;
            this.codePageToFont[index] = this.charsetCount;
            this.fontToCodePages[this.charsetCount] = index - 1;
            this.charsetCount = (byte)(this.charsetCount + 1);
        }
        this.codePageToFont[0] = this.codePageToFont[1];
        for (index = 0; index < this.styleList.size(); ++index) {
            StiRtfStyleInfo style = this.styleList.get(index);
            style.fontNumber *= this.charsetCount;
        }
        this.renderStartDoc();
        if (exportMode == StiRtfExportMode.Table) {
            this.sw.write("\\nolead\r\n");
            this.sw.write("\\afs16\r\n");
            StiPagesCollection allPages = pages;
            pages = null;
            Boolean headersAndFootersFounded = false;
            for (int indexPage = 0; indexPage < allPages.size(); ++indexPage) {
                pages = new StiPagesCollection(report);
                pages.setCacheMode(report.getRenderedPages().getCacheMode());
                pages.addV2Internal(allPages.getPageWithoutCache(indexPage));
                String sheetName = allPages.getPageWithoutCache(indexPage).getExcelSheetValue();
                while (indexPage < allPages.size() - 1 && this.compareExcellSheetNames(allPages.getPageWithoutCache(indexPage + 1).getExcelSheetValue(), sheetName).booleanValue() && allPages.getPageWithoutCache(indexPage + 1).getOrientation() == allPages.getPageWithoutCache(indexPage).getOrientation()) {
                    pages.addV2Internal(allPages.getPageWithoutCache(++indexPage));
                }
                StiPage firstPage = pages.get(0);
                if (firstPage != null) {
                    pages.GetPage(firstPage);
                    if (!ExportOptions.Rtf.isUseNewPageCommandInsteadOfNewSection() || indexPage == 0) {
                        this.renderPageHeader(firstPage);
                    }
                    Boolean divideBigCells = ExportOptions.Rtf.getDivideBigCells() && !ExportOptions.Rtf.getUseCanBreakProperty();
                    if (this.usePageHeadersAndFooters.booleanValue()) {
                        int startLine;
                        int startLine2;
                        int endLine;
                        StiPagesCollection pages2 = new StiPagesCollection(report);
                        pages2.setCacheMode(report.getRenderedPages().getCacheMode());
                        pages2.add(pages.get(0));
                        this.matrix = new StiMatrix(pages2, divideBigCells, this);
                        if (this.isStoped()) {
                            return;
                        }
                        this.matrix.scanComponentsPlacement(false);
                        Boolean foundedPageHeaderExceptFirstPage = false;
                        for (endLine = this.matrix.getCoordY().size() - 1 - 1; this.matrix.getLinePlacement()[endLine] != StiMatrix.StiTableLineInfo.PageHeader && endLine > 0; --endLine) {
                        }
                        if (this.matrix.getLinePlacement()[endLine] == StiMatrix.StiTableLineInfo.PageHeader) {
                            startLine2 = 0;
                            while (this.matrix.getLinePlacement()[startLine2] != StiMatrix.StiTableLineInfo.PageHeader) {
                                ++startLine2;
                            }
                            this.sw.write("{\r\n");
                            this.sw.write("{\\header \r\n");
                            this.writeFromMatrix(startLine2, endLine, true);
                            this.sw.write("}\r\n");
                            headersAndFootersFounded = true;
                        } else {
                            Boolean isHeaderFounded = false;
                            if (pages.size() > 1 && pages.get(1) != null) {
                                StiMatrix tempMatrix = this.matrix;
                                pages2 = new StiPagesCollection(report);
                                pages2.setCacheMode(report.getRenderedPages().getCacheMode());
                                pages2.add(pages.get(1));
                                this.matrix = new StiMatrix(pages2, divideBigCells, this);
                                if (this.isStoped()) {
                                    return;
                                }
                                this.matrix.scanComponentsPlacement(false);
                                for (endLine = this.matrix.getCoordY().size() - 1 - 1; this.matrix.getLinePlacement()[endLine] != StiMatrix.StiTableLineInfo.PageHeader && endLine > 0; --endLine) {
                                }
                                if (this.matrix.getLinePlacement()[endLine] == StiMatrix.StiTableLineInfo.PageHeader) {
                                    startLine2 = 0;
                                    while (this.matrix.getLinePlacement()[startLine2] != StiMatrix.StiTableLineInfo.PageHeader) {
                                        ++startLine2;
                                    }
                                    StiPrintOnType printOn = StiPrintOnType.AllPages;
                                    Boolean founded = false;
                                    for (int rowIndex = startLine2; rowIndex < endLine; ++rowIndex) {
                                        for (int columnIndex = 0; columnIndex < this.matrix.getCoordX().size() - 1; ++columnIndex) {
                                            StiCell cell = this.matrix.getCells()[rowIndex][columnIndex];
                                            if (cell == null || cell.getComponent() == null) continue;
                                            printOn = cell.getComponent().getPrintOn();
                                            founded = true;
                                            break;
                                        }
                                        if (founded.booleanValue()) break;
                                    }
                                    if ((founded = Boolean.valueOf(founded & (printOn == StiPrintOnType.ExceptFirstAndLastPage || printOn == StiPrintOnType.ExceptFirstPage))).booleanValue()) {
                                        this.sw.write("\\titlepg \r\n");
                                        foundedPageHeaderExceptFirstPage = true;
                                    }
                                    this.sw.write("{\r\n");
                                    this.sw.write("{\\header \r\n");
                                    this.writeFromMatrix(startLine2, endLine, true);
                                    this.sw.write("}\r\n");
                                    headersAndFootersFounded = true;
                                    isHeaderFounded = true;
                                } else {
                                    this.sw.write("{\r\n");
                                }
                                this.matrix = tempMatrix;
                            } else {
                                this.sw.write("{\r\n");
                            }
                            if (!isHeaderFounded.booleanValue() && headersAndFootersFounded.booleanValue()) {
                                this.sw.write("{\\header \\fs2 }\r\n");
                            }
                        }
                        for (startLine = 0; this.matrix.getLinePlacement()[startLine] != StiMatrix.StiTableLineInfo.PageFooter && startLine < this.matrix.getCoordY().size() - 1 - 1; ++startLine) {
                        }
                        if (this.matrix.getLinePlacement()[startLine] == StiMatrix.StiTableLineInfo.PageFooter) {
                            endLine = this.matrix.getCoordY().size() - 1 - 1;
                            while (this.matrix.getLinePlacement()[endLine] != StiMatrix.StiTableLineInfo.PageFooter) {
                                --endLine;
                            }
                            if (foundedPageHeaderExceptFirstPage.booleanValue()) {
                                this.sw.write("{\\footerf \r\n");
                                this.writeFromMatrix(startLine, endLine, true);
                                this.sw.write("}\r\n");
                            }
                            this.sw.write("{\\footer \r\n");
                            this.writeFromMatrix(startLine, endLine, true);
                            this.sw.write("}\r\n");
                            headersAndFootersFounded = true;
                        } else if (headersAndFootersFounded.booleanValue()) {
                            this.sw.write("{\\footer \\fs2 }\r\n");
                        }
                        this.matrix = new StiMatrix(pages, divideBigCells, this);
                        this.matrix.scanComponentsPlacement(true);
                        endLine = this.matrix.getCoordY().size() - 1 - 1;
                        this.writeFromMatrix(0, endLine, false);
                    } else {
                        this.matrix = new StiMatrix(pages, divideBigCells, this);
                        if (this.isStoped()) {
                            return;
                        }
                        this.sw.write("{\r\n");
                        this.writeFromMatrix(0, this.matrix.getCoordY().size() - 1 - 1, true);
                    }
                    this.sw.write("\\pard\\fs2 \\par\r\n");
                    this.sw.write("}\r\n");
                }
                if (indexPage >= allPages.size() - 1) continue;
                this.renderPageFooter();
            }
        } else {
            this.setStatusString(StiLocalization.getValue((String)"Export", (String)"ExportingCreatingDocument"));
            this.sw.write("\\nolead\r\n");
            for (StiPage page : pages) {
                pages.GetPage(page);
                this.invokeExporting(page, pages);
                if (this.isStoped()) {
                    return;
                }
                this.renderPageHeader(page);
                this.sw.write("{\r\n");
                int pageLines = (int)Math.round((double)this.pageHeight / (insideScaleY / scaleY)) + 2;
                SortedMap[] list = new SortedMap[pageLines];
                for (int indexLine = 0; indexLine < pageLines; ++indexLine) {
                    list[indexLine] = new TreeMap();
                }
                Hashtable<String, String> hashCoordinates = new Hashtable<String, String>();
                for (StiComponent component : page.getComponents()) {
                    String coordsSt;
                    if (!component.getEnabled()) continue;
                    double x1 = page.getUnit().ConvertToHInches(component.getLeft());
                    double y1 = page.getUnit().ConvertToHInches(component.getTop());
                    double x2 = page.getUnit().ConvertToHInches(component.getRight());
                    double y2 = page.getUnit().ConvertToHInches(component.getBottom());
                    StiRtfData pp = new StiRtfData();
                    pp.x = (int)Math.round(x1 * 14.4 * scaleX);
                    pp.y = (int)Math.round(y1 * 14.4 * scaleY);
                    pp.width = (int)Math.round(x2 * 14.4 * scaleX) - pp.x;
                    pp.height = (int)Math.round(y2 * 14.4 * scaleY) - pp.y;
                    pp.component = component;
                    ++pp.x;
                    ++pp.y;
                    while (true) {
                        if (!hashCoordinates.contains(coordsSt = String.format("%s:%s:%s:%s", pp.x, pp.y, pp.width, pp.height))) break;
                        ++pp.width;
                    }
                    hashCoordinates.put(coordsSt, coordsSt);
                    Integer tempX = pp.x;
                    Integer tempY = (int)Math.round(y1 / (insideScaleY / scaleY));
                    if (tempY < 0) {
                        tempY = 0;
                    }
                    while (list[tempY].containsKey(tempX)) {
                        Integer n = tempX;
                        Integer n2 = tempX = Integer.valueOf(tempX + 1);
                    }
                    list[tempY].put(tempX, pp);
                }
                switch (exportMode) {
                    case Frame: {
                        this.sw.write("\\nowidctlpar\\phmrg\\pvmrg\\nowrap\r\n");
                        for (int indexLine = 0; indexLine < list.length; ++indexLine) {
                            if (list[indexLine].size() <= 0) continue;
                            this.sw.write("\\pard");
                            for (int indexObj = 0; indexObj < list[indexLine].size(); ++indexObj) {
                                IStiBorder mBorder;
                                StiRtfData pp = (StiRtfData)StiMapUtil.getByIndex(list[indexLine], indexObj);
                                StiComponent component = pp.component;
                                int correctX = 0;
                                int correctW = 0;
                                IStiBorder iStiBorder = mBorder = component instanceof IStiBorder ? (IStiBorder)((Object)component) : null;
                                if (mBorder != null && !(component instanceof IStiIgnoreBorderWhenExport)) {
                                    if (mBorder.getBorder().getSide().contains((IStiEnum)StiBorderSides.Left)) {
                                        correctX += 38;
                                        correctW += 38;
                                    }
                                    if (mBorder.getBorder().getSide().contains((IStiEnum)StiBorderSides.Right)) {
                                        correctW += 38;
                                    }
                                }
                                this.sw.write("{");
                                this.sw.write(String.format("\\nowrap\\posx%s\\posy%s\\absw%s\\absh%s", pp.x + correctX, pp.y, pp.width - correctW, pp.height));
                                this.renderTextAngle1(component);
                                this.renderBorder1(component);
                                this.renderBrush1(component);
                                this.renderStyle12(component);
                                this.renderHorAlign12(component);
                                this.renderTextBrush12(component);
                                this.renderTextFont12(component);
                                if (component instanceof StiText) {
                                    this.renderText12(component);
                                }
                                if (component instanceof StiRichText) {
                                    this.renderRtf12(component);
                                } else if (component instanceof StiShape) {
                                    this.renderShape1(pp, correctX, correctW);
                                } else {
                                    this.renderImage12(component, pp.width - correctW, pp.height);
                                }
                                this.sw.write(" \\par}\r\n");
                            }
                        }
                        break;
                    }
                    case WinWord: {
                        for (int indexLine = 0; indexLine < list.length; ++indexLine) {
                            if (list[indexLine].size() <= 0) continue;
                            for (int indexObj = 0; indexObj < list[indexLine].size(); ++indexObj) {
                                StiShape shape;
                                StiRtfData pp = (StiRtfData)StiMapUtil.getByIndex(list[indexLine], indexObj);
                                StiComponent component = pp.component;
                                StiShape stiShape = shape = component instanceof StiShape ? (StiShape)component : null;
                                if (component instanceof StiShape && shape != null && this.checkShape2(shape).booleanValue()) {
                                    this.renderShape2(pp);
                                    continue;
                                }
                                this.sw.write("{\\shp{\\*");
                                this.sw.write(String.format("\\shpinst\\shpleft%s\\shptop%s\\shpright%s\\shpbottom%s", pp.x, pp.y, pp.x + pp.width, pp.y + pp.height));
                                this.sw.write("\\shpwr3");
                                this.sw.write("{\\sp{\\sn dxTextLeft}{\\sv 0}}");
                                this.sw.write("{\\sp{\\sn dyTextTop}{\\sv 0}}");
                                this.sw.write("{\\sp{\\sn dxTextRight}{\\sv 0}}");
                                this.sw.write("{\\sp{\\sn dyTextBottom}{\\sv 0}}");
                                this.renderBrush2(component);
                                this.sw.write("{\\sp{\\sn fLine}{\\sv 0}}");
                                this.sw.write("{\\shptxt\\trowd\\trqc");
                                this.sw.write(String.format("\\trrh-%s", pp.height));
                                this.renderVerAlign2(component);
                                this.renderBorder2(component);
                                this.renderTextAngle2(component);
                                this.sw.write(String.format("\\cellx%s\\intbl", pp.width));
                                this.renderHorAlign12(component);
                                this.renderTextBrush12(component);
                                this.renderTextFont12(component);
                                if (!(component instanceof StiRichText)) {
                                    this.renderText12(component);
                                }
                                if (component instanceof StiRichText) {
                                    this.renderRtf12(component);
                                } else {
                                    this.renderImage12(component, pp.width, pp.height);
                                }
                                this.sw.write("\\cell\\row\\pard\\par}}}\r\n");
                            }
                        }
                        break;
                    }
                    case TabbedText: {
                        for (int index1 = 0; index1 < list.length; ++index1) {
                            if (list[index1].size() > 0) {
                                this.sw.write("\\pard{");
                            }
                            if (list[index1].size() > 0) {
                                StringBuilder codeStr = new StringBuilder();
                                StringBuilder dataStr = new StringBuilder();
                                for (int index2 = 0; index2 < list[index1].size(); ++index2) {
                                    IStiTextHorAlignment mTextHorAlign;
                                    StiRtfData pp = (StiRtfData)StiMapUtil.getByIndex(list[index1], index2);
                                    StiComponent component = pp.component;
                                    int coordTX = pp.x;
                                    IStiTextHorAlignment iStiTextHorAlignment = mTextHorAlign = component instanceof IStiTextHorAlignment ? (IStiTextHorAlignment)((Object)component) : null;
                                    if (mTextHorAlign != null) {
                                        if (mTextHorAlign.getHorAlignment() == StiTextHorAlignment.Center) {
                                            coordTX = pp.x + (int)Math.round((double)pp.width / 2.0) - 1;
                                            codeStr.append("\\tqc");
                                        }
                                        if (mTextHorAlign.getHorAlignment() == StiTextHorAlignment.Right) {
                                            coordTX = pp.x + pp.width - 28;
                                            codeStr.append("\\tqr");
                                        }
                                    }
                                    codeStr.append("\\tx");
                                    codeStr.append(coordTX);
                                    dataStr.append("\\tab");
                                    this.renderBorder3(component, dataStr);
                                    this.renderBrush3(component, dataStr);
                                    this.renderTextFont3(component, dataStr);
                                    this.renderTextBrush3(component, dataStr);
                                    if (!(component instanceof StiRichText)) {
                                        this.renderText3(component, dataStr);
                                    }
                                    if (component instanceof StiRichText) {
                                        this.renderRtf3(component, dataStr);
                                        continue;
                                    }
                                    this.renderImage3(component, dataStr, pp.width, pp.height);
                                }
                                this.sw.write(codeStr.toString());
                                this.sw.flush();
                                for (int i = 0; i < dataStr.length(); ++i) {
                                    this.sw2.write(dataStr.charAt(i));
                                }
                                this.sw2.flush();
                            }
                            if (list[index1].size() <= 0) continue;
                            this.sw.write("\\par}\r\n");
                        }
                        break;
                    }
                }
                this.sw.write("}\r\n");
                if (page == pages.get(pages.size() - 1)) continue;
                this.renderPageFooter();
            }
        }
        this.renderEndDoc();
        this.sw.flush();
        this.sw.close();
        this.sw2.flush();
        this.sw2.close();
        if (this.matrix != null) {
            this.matrix.clear();
            this.matrix = null;
        }
        this.colorList = null;
        this.fontList = null;
        this.styleList = null;
        this.unicodeMapArray = null;
        this.codePageToFont = null;
        this.fontToCodePages = null;
        this.bookmarkList = null;
        this.usedBookmarks = null;
        this.closeProgress();
    }

    @Override
    public StiExportFormat getExportFormat() {
        return StiExportFormat.Rtf;
    }

    @Override
    public boolean getMultipleFiles() {
        return false;
    }

    public Boolean getRemoveEmptySpaceAtBottom() {
        return this.removeEmptySpaceAtBottom;
    }

    private class StiRtfStyleInfo {
        public String name;
        public StiTextHorAlignment alignment;
        public Boolean rightToLeft;
        public int fontNumber;
        public int fontSize;
        public Boolean bold;
        public Boolean italic;
        public Boolean underline;
        public int textColor;

        private StiRtfStyleInfo() {
        }
    }

    private class StiRtfData {
        public int x;
        public int y;
        public int width;
        public int height;
        public StiComponent component;

        private StiRtfData() {
        }
    }
}

