/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.report.export.service.helper;

import com.stimulsoft.base.drawing.StiBrush;
import com.stimulsoft.base.drawing.StiColor;
import com.stimulsoft.base.drawing.StiColorUtils;
import com.stimulsoft.base.drawing.StiSolidBrush;
import com.stimulsoft.report.maps.StiMap;
import com.stimulsoft.report.maps.StiMapData;
import java.util.HashMap;
import java.util.List;

public class HeatmapWithGroupInfo {
    private StiBrush defaultBrush;
    private StiBrush defaultBrush1;
    private HashMap<String, double[]> hash = new HashMap();
    private HashMap<String, StiColor> hashColors = new HashMap();

    public StiBrush getBrush(StiMapData data) {
        if (data.getGroup() == null) {
            return null;
        }
        if (!this.hash.containsKey(data.getGroup())) {
            return this.defaultBrush;
        }
        double[] values = this.hash.get(data.getGroup());
        StiColor color = this.hashColors.get(data.getGroup());
        if (values[0] == values[1]) {
            return new StiSolidBrush(color);
        }
        double value = 0.0;
        if (data.getValue() == null) {
            return this.defaultBrush;
        }
        try {
            value = Double.parseDouble(data.getValue());
        }
        catch (Exception e) {
            return this.defaultBrush;
        }
        return new StiSolidBrush(StiColorUtils.changeLightness((StiColor)color, (float)((float)((double)0.85f * (values[1] - value) / (values[1] - values[0])))));
    }

    public StiBrush getBrush1(StiMapData data) {
        if (data.getGroup() == null) {
            return null;
        }
        if (!this.hash.containsKey(data.getGroup())) {
            return this.defaultBrush1;
        }
        double[] values = this.hash.get(data.getGroup());
        StiColor color = this.hashColors.get(data.getGroup());
        if (values[0] == values[1]) {
            return new StiSolidBrush(color);
        }
        double value = 0.0;
        if (data.getValue() == null) {
            return this.defaultBrush1;
        }
        try {
            value = Double.parseDouble(data.getValue());
        }
        catch (Exception e) {
            return this.defaultBrush1;
        }
        return new StiSolidBrush(StiColorUtils.changeLightness((StiColor)color, (float)((float)((double)0.85f * (values[1] - value) / (values[1] - values[0])))));
    }

    public HeatmapWithGroupInfo(StiBrush defaultBrush, StiBrush defaultBrush1, StiMap map, List<StiMapData> mapData) {
        this.defaultBrush = defaultBrush;
        this.defaultBrush1 = defaultBrush1;
        List<StiColor> colors = StiMap.getMapStyle(map).getHeatmapColors();
        int index = 0;
        for (StiMapData data : mapData) {
            double[] values;
            String key = data.getGroup();
            if (key == null || data.getValue() == null) continue;
            double value = 0.0;
            if (data.getValue() == null) continue;
            try {
                value = Double.parseDouble(data.getValue());
            }
            catch (Exception e) {
                continue;
            }
            if (!this.hash.containsKey(key)) {
                values = new double[]{value, value};
                this.hash.put(key, values);
            } else {
                values = this.hash.get(key);
                if (value < values[0]) {
                    values[0] = value;
                } else if (value > values[1]) {
                    values[1] = value;
                }
            }
            if (this.hashColors.containsKey(key)) continue;
            StiColor color = colors.get(index);
            if (++index >= colors.size()) {
                index = 0;
            }
            this.hashColors.put(key, color);
        }
    }
}

