/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.report.export.service.helper;

import com.stimulsoft.base.drawing.StiColor;
import com.stimulsoft.base.drawing.StiGlareBrush;
import com.stimulsoft.base.drawing.StiGlassBrush;
import com.stimulsoft.base.drawing.StiGradientBrush;
import com.stimulsoft.base.drawing.StiHatchBrush;
import com.stimulsoft.base.system.StiGuid;
import com.stimulsoft.base.system.geometry.StiRectangle;
import com.stimulsoft.base.utils.StiMath;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class StiBrushSvgHelper {
    private static String[] HATCH_DATA = new String[]{"000000FF00000000", "1010101010101010", "8040201008040201", "0102040810204080", "101010FF10101010", "8142241818244281", "8000000008000000", "0010000100100001", "2200880022008800", "2288228822882288", "2255885522558855", "AA558A55AA55A855", "AA55AA55AA55AA55", "BB55EE55BB55EE55", "DD77DD77DD77DD77", "FFDDFF77FFDDFF77", "FF7FFFF7FF7FFFF7", "FF7FFFFFFFF7FFFF", "8844221188442211", "1122448811224488", "CC663399CC663399", "993366CC993366CC", "E070381C0E0783C1", "C183070E1C3870E0", "4040404040404040", "00FF000000FF0000", "AAAAAAAAAAAAAAAA", "FF00FF00FF00FF00", "CCCCCCCCCCCCCCCC", "FFFF0000FFFF0000", "8844221100000000", "1122448800000000", "F00000000F000000", "8080808008080808", "0240088004200110", "0C8DB130031BD8C0", "8403304884033048", "00304A8100304A81", "0102040818244281", "202020FF020202FF", "1422518854224588", "F0F0F0F0AA55AA55", "0100201020000102", "AA00800080008000", "0020008800020088", "8448300C02010103", "33FFCCFF33FFCCFF", "98F8F877898F8F77", "111111FF111111FF", "3333CCCC3333CCCC", "0F0F0F0FF0F0F0F0", "0502058850205088", "10387CFE7C381000", "0000000000000000"};

    public static String writeGlassBrush(Element el, Object brush, StiRectangle rect, Document doc) {
        StiGlassBrush gb = (StiGlassBrush)brush;
        StiColor topColor = gb.getTopColor();
        StiRectangle topRect = gb.getTopRectangle(rect);
        StiColor bottomColor = gb.getBottomColor();
        String brushId = String.format("glass%s", StiGuid.newGuid());
        Element pattern = doc.createElement("pattern");
        el.appendChild(pattern);
        pattern.setAttribute("id", brushId);
        pattern.setAttribute("x", String.valueOf(rect.x).replace(',', '.'));
        pattern.setAttribute("y", String.valueOf(rect.y).replace(',', '.'));
        pattern.setAttribute("width", String.valueOf(rect.width).replace(',', '.'));
        pattern.setAttribute("height", String.valueOf(rect.height).replace(',', '.'));
        pattern.setAttribute("patternUnits", "userSpaceOnUse");
        Element rectE = doc.createElement("rect");
        pattern.appendChild(rectE);
        rectE.setAttribute("x", "0");
        rectE.setAttribute("y", "0");
        pattern.setAttribute("width", String.valueOf(rect.width).replace(',', '.'));
        pattern.setAttribute("height", String.valueOf(rect.height).replace(',', '.'));
        rectE.setAttribute("style", String.format("fill:rgb(%s,%s,%s);fill-opacity:%s;", bottomColor.getR(), bottomColor.getG(), bottomColor.getB(), String.valueOf(StiMath.round((float)((float)bottomColor.getA() / 255.0f), (int)3)).replace(',', '.')));
        rectE = doc.createElement("rect");
        pattern.appendChild(rectE);
        rectE.setAttribute("x", "0");
        rectE.setAttribute("y", "0");
        pattern.setAttribute("width", String.valueOf(topRect.width).replace(',', '.'));
        pattern.setAttribute("height", String.valueOf(topRect.height).replace(',', '.'));
        rectE.setAttribute("style", String.format("fill:rgb(%s,%s,%s);fill-opacity:%s;", topColor.getR(), topColor.getG(), topColor.getB(), String.valueOf(StiMath.round((float)((float)topColor.getA() / 255.0f), (int)3)).replace(',', '.')));
        return brushId;
    }

    public static String writeGlareBrush(Element el, Object brush, StiRectangle rect, Document doc) {
        StiGlareBrush gb = (StiGlareBrush)brush;
        double xs = 1.0;
        double ys = 1.0;
        double angle = gb.angle;
        if (angle < 0.0) {
            angle += 360.0;
        }
        if (angle >= 270.0 && angle < 360.0) {
            angle = 360.0 - angle;
            ys = -1.0;
        }
        if (angle >= 180.0 && angle < 270.0) {
            angle -= 180.0;
            ys = -1.0;
            xs = -1.0;
        }
        if (angle >= 90.0 && angle < 180.0) {
            angle = 180.0 - angle;
            xs = -1.0;
        }
        angle = angle * Math.PI / 180.0;
        double x0 = rect.x + rect.width / 2.0;
        double y0 = rect.y + rect.height / 2.0;
        double r = Math.sqrt(rect.width * rect.width + rect.height * rect.height) / 2.0;
        double a2 = Math.atan2(rect.height, rect.width);
        double st = 1.5707963267948966 - angle + a2;
        double b = r * Math.sin(st);
        double xr = b * Math.cos(angle) * xs;
        double yr = b * Math.sin(angle) * -ys;
        double x1 = x0 - xr;
        double x2 = x0 + xr;
        double y1 = y0 + yr;
        double y2 = y0 - yr;
        String gradientId = String.format("gradient%s", StiGuid.newGuid());
        Element linearGradient = doc.createElement("linearGradient");
        el.appendChild(linearGradient);
        linearGradient.setAttribute("id", gradientId);
        linearGradient.setAttribute("gradientUnits", "userSpaceOnUse");
        linearGradient.setAttribute("x1", String.valueOf(x1).replace(',', '.'));
        linearGradient.setAttribute("y1", String.valueOf(y1).replace(',', '.'));
        linearGradient.setAttribute("x2", String.valueOf(x2).replace(',', '.'));
        linearGradient.setAttribute("y2", String.valueOf(y2).replace(',', '.'));
        Element stop = doc.createElement("stop");
        linearGradient.appendChild(stop);
        stop.setAttribute("offset", "0%");
        stop.setAttribute("stop-color", gb.getStartColor().toHTML());
        if (gb.getStartColor().getA() != 255) {
            stop.setAttribute("stop-opacity", String.valueOf(StiMath.round((float)((float)gb.getStartColor().getA() / 255.0f), (int)3)).replace(',', '.'));
        }
        stop = doc.createElement("stop");
        linearGradient.appendChild(stop);
        stop.setAttribute("offset", "50%");
        stop.setAttribute("stop-color", gb.getEndColor().toHTML());
        if (gb.getEndColor().getA() != 255) {
            stop.setAttribute("stop-opacity", String.valueOf(StiMath.round((float)((float)gb.getEndColor().getA() / 255.0f), (int)3)).replace(',', '.'));
        }
        stop = doc.createElement("stop");
        linearGradient.appendChild(stop);
        stop.setAttribute("offset", "100%");
        stop.setAttribute("stop-color", gb.getStartColor().toHTML());
        if (gb.getStartColor().getA() != 255) {
            stop.setAttribute("stop-opacity", String.valueOf(StiMath.round((float)((float)gb.getStartColor().getA() / 255.0f), (int)3)).replace(',', '.'));
        }
        return gradientId;
    }

    public static String writeGradientBrush(Element el, Object brush, StiRectangle rect, Document doc) {
        StiGradientBrush gb = (StiGradientBrush)brush;
        double xs = 1.0;
        double ys = 1.0;
        double angle = gb.getAngle();
        if (angle < 0.0) {
            angle += 360.0;
        }
        if (angle >= 270.0 && angle < 360.0) {
            angle = 360.0 - angle;
            ys = -1.0;
        }
        if (angle >= 180.0 && angle < 270.0) {
            angle -= 180.0;
            ys = -1.0;
            xs = -1.0;
        }
        if (angle >= 90.0 && angle < 180.0) {
            angle = 180.0 - angle;
            xs = -1.0;
        }
        angle = angle * Math.PI / 180.0;
        double x0 = rect.x + rect.width / 2.0;
        double y0 = rect.y + rect.height / 2.0;
        double r = Math.sqrt(rect.width * rect.width + rect.height * rect.height) / 2.0;
        double a2 = Math.atan2(rect.height, rect.width);
        double st = 1.5707963267948966 - angle + a2;
        double b = r * Math.sin(st);
        double xr = b * Math.cos(angle) * xs;
        double yr = b * Math.sin(angle) * -ys;
        double x1 = x0 - xr;
        double x2 = x0 + xr;
        double y1 = y0 + yr;
        double y2 = y0 - yr;
        String gradientId = String.format("gradient%s", StiGuid.newGuid());
        Element linearGradient = doc.createElement("linearGradient");
        el.appendChild(linearGradient);
        linearGradient.setAttribute("id", gradientId);
        linearGradient.setAttribute("gradientUnits", "userSpaceOnUse");
        linearGradient.setAttribute("x1", String.valueOf(x1).replace(',', '.'));
        linearGradient.setAttribute("y1", String.valueOf(y1).replace(',', '.'));
        linearGradient.setAttribute("x2", String.valueOf(x2).replace(',', '.'));
        linearGradient.setAttribute("y2", String.valueOf(y2).replace(',', '.'));
        Element stop = doc.createElement("stop");
        linearGradient.appendChild(stop);
        stop.setAttribute("offset", "0%");
        stop.setAttribute("stop-color", gb.getStartColor().toHTML());
        if (gb.getStartColor().getA() != 255) {
            stop.setAttribute("stop-opacity", String.valueOf(StiMath.round((float)((float)gb.getStartColor().getA() / 255.0f), (int)3)).replace(',', '.'));
        }
        stop = doc.createElement("stop");
        linearGradient.appendChild(stop);
        stop.setAttribute("offset", "100%");
        stop.setAttribute("stop-color", gb.getEndColor().toHTML());
        if (gb.getEndColor().getA() != 255) {
            stop.setAttribute("stop-opacity", String.valueOf(StiMath.round((float)((float)gb.getEndColor().getA() / 255.0f), (int)3)).replace(',', '.'));
        }
        return gradientId;
    }

    public static String writeHatchBrush(Element el, Object brush, Document doc) {
        StiHatchBrush hatch = (StiHatchBrush)brush;
        StiColor foreColor = hatch.getForeColor();
        StiColor backColor = hatch.getBackColor();
        int hatchNumber = hatch.getStyle().getValue();
        if (hatchNumber > 53) {
            hatchNumber = 53;
        }
        String brushId = String.format("hatch%s", StiGuid.newGuid());
        Element pattern = doc.createElement("pattern");
        el.appendChild(pattern);
        pattern.setAttribute("id", brushId);
        pattern.setAttribute("x", "0");
        pattern.setAttribute("y", "0");
        pattern.setAttribute("width", "8");
        pattern.setAttribute("height", "8");
        pattern.setAttribute("patternUnits", "userSpaceOnUse");
        StringBuilder sb = new StringBuilder();
        String hatchHex = HATCH_DATA[hatchNumber];
        for (int index = 0; index < 16; ++index) {
            sb.append(StiBrushSvgHelper.hexToByteString(hatchHex.substring(index, index + 1)));
        }
        Element rect = doc.createElement("rect");
        pattern.appendChild(rect);
        rect.setAttribute("x", "0");
        rect.setAttribute("y", "0");
        rect.setAttribute("width", "8");
        rect.setAttribute("height", "8");
        rect.setAttribute("fill", backColor.toHTML());
        for (int indexRow = 0; indexRow < 8; ++indexRow) {
            for (int indexColumn = 0; indexColumn < 8; ++indexColumn) {
                Character indexChar = Character.valueOf(sb.charAt(indexRow * 8 + indexColumn));
                if (indexChar.charValue() != '1') continue;
                rect = doc.createElement("rect");
                pattern.appendChild(rect);
                rect.setAttribute("x", String.valueOf(indexColumn));
                rect.setAttribute("y", String.valueOf(indexRow));
                rect.setAttribute("width", "1");
                rect.setAttribute("height", "1");
                rect.setAttribute("fill", foreColor.toHTML());
            }
        }
        return brushId;
    }

    private static String hexToByteString(String hex) {
        String result = "0000";
        if ("1".equals(hex)) {
            result = "0001";
        } else if ("2".equals(hex)) {
            result = "0010";
        } else if ("3".equals(hex)) {
            result = "0011";
        } else if ("4".equals(hex)) {
            result = "0100";
        } else if ("5".equals(hex)) {
            result = "0101";
        } else if ("6".equals(hex)) {
            result = "0110";
        } else if ("7".equals(hex)) {
            result = "0111";
        } else if ("8".equals(hex)) {
            result = "1000";
        } else if ("9".equals(hex)) {
            result = "1001";
        } else if ("A".equals(hex)) {
            result = "1010";
        } else if ("B".equals(hex)) {
            result = "1011";
        } else if ("C".equals(hex)) {
            result = "1100";
        } else if ("D".equals(hex)) {
            result = "1101";
        } else if ("E".equals(hex)) {
            result = "1110";
        } else if ("F".equals(hex)) {
            result = "1111";
        }
        return result;
    }
}

