/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.report.export.tools;

import com.stimulsoft.base.drawing.StiBrush;
import com.stimulsoft.base.drawing.StiColor;
import com.stimulsoft.base.drawing.StiPen;
import com.stimulsoft.base.drawing.enums.StiTextHorAlignment;
import com.stimulsoft.base.drawing.enums.StiVertAlignment;
import com.stimulsoft.base.system.StiFont;
import com.stimulsoft.base.system.StiSize;
import com.stimulsoft.base.system.geometry.StiPoint;
import com.stimulsoft.base.system.geometry.StiRectangle;
import com.stimulsoft.report.StiReport;
import com.stimulsoft.report.components.simplecomponents.StiImage;
import com.stimulsoft.report.export.tools.IStiExportGeomWriter;
import java.io.IOException;

public class StiBarCodeExportPainter {
    private IStiExportGeomWriter geomWriter = null;

    public void baseTransform(Object context, double x, double y, double angle, double dx, double dy) throws IOException {
        this.geomWriter.translateTransform(x, y);
        this.geomWriter.rotateTransform(angle);
        this.geomWriter.translateTransform(dx, dy);
    }

    public void baseRollbackTransform(Object context) {
    }

    public void baseFillRectangle(Object context, StiBrush brush, double x, double y, double width, double height) throws Exception {
        StiRectangle rectF = new StiRectangle(x, y, width, height);
        this.geomWriter.fillRectangle(rectF, StiBrush.getBrush((StiBrush)brush, (StiRectangle)rectF));
    }

    public void baseFillPolygon(Object context, StiBrush brush, StiPoint[] points) throws Exception {
        this.geomWriter.fillPolygon(points, brush);
    }

    public void baseFillRectangle2D(Object context, StiBrush brush, double x, double y, double width, double height) throws Exception {
        StiRectangle rectF = new StiRectangle(x, y, width, height);
        this.geomWriter.fillRectangle(rectF, StiBrush.getBrush((StiBrush)brush, (StiRectangle)rectF));
    }

    public void baseFillEllipse(Object context, StiBrush brush, double x, double y, double width, double height) throws Exception {
        this.geomWriter.fillEllipse(new StiRectangle(x, y, width, height), brush);
    }

    public void baseDrawRectangle(Object context, StiColor penColor, double penSize, double x, double y, double width, double height) throws Exception {
        StiRectangle rectF = new StiRectangle(x, y, width, height);
        this.geomWriter.drawRectangle(rectF, new StiPen(penSize, penColor));
    }

    public void baseDrawImage(Object context, StiImage image, StiReport report, double x, double y, double width, double height) throws IOException {
        if (image != null) {
            StiRectangle rectF = new StiRectangle(x, y, width, height);
            this.geomWriter.drawImage(image, rectF);
        }
    }

    public void baseDrawString(Object context, String st, StiFont font, StiBrush brush, StiRectangle rect, StiTextHorAlignment horAlignment, StiVertAlignment vertAlignment) throws IOException {
        this.geomWriter.drawString(st, font, brush, rect, horAlignment, vertAlignment);
    }

    public StiSize baseMeasureString(Object context, String st, StiFont font) {
        return this.geomWriter.measureString(st, font);
    }

    public StiBarCodeExportPainter(IStiExportGeomWriter geomWriter) {
        this.geomWriter = geomWriter;
    }
}

