/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.report.export.tools;

import com.stimulsoft.base.drawing.StiBrush;
import com.stimulsoft.base.drawing.StiColor;
import com.stimulsoft.base.drawing.StiColorEnum;
import com.stimulsoft.base.drawing.StiGlareBrush;
import com.stimulsoft.base.drawing.StiGlassBrush;
import com.stimulsoft.base.drawing.StiGradientBrush;
import com.stimulsoft.base.drawing.StiHatchBrush;
import com.stimulsoft.base.drawing.StiPen;
import com.stimulsoft.base.drawing.StiSolidBrush;
import com.stimulsoft.base.drawing.enums.StiTextHorAlignment;
import com.stimulsoft.base.drawing.enums.StiVertAlignment;
import com.stimulsoft.base.system.StiFont;
import com.stimulsoft.base.system.StiRefObject;
import com.stimulsoft.base.system.StiSize;
import com.stimulsoft.base.system.geometry.StiPoint;
import com.stimulsoft.base.system.geometry.StiRectangle;
import com.stimulsoft.base.utils.StiMath;
import com.stimulsoft.base.utils.StiOutputStreamWriter;
import com.stimulsoft.report.components.simplecomponents.StiImage;
import com.stimulsoft.report.components.simplecomponents.StiText;
import com.stimulsoft.report.export.EmfTextAlignmentMode;
import com.stimulsoft.report.export.service.StiPdfExportService;
import com.stimulsoft.report.export.tools.IStiExportGeomWriter;
import com.stimulsoft.report.export.tools.StiPdfData;
import java.io.IOException;

public class StiPdfGeomWriter
implements IStiExportGeomWriter {
    private final double penWidthDefault = 0.1;
    private final int precision_digits = 3;
    private final double hiToTwips = 0.72;
    private final float pdfCKT = 0.55228f;
    private StiPoint lastPoint;
    private boolean makePath = false;
    private boolean pathClosed = false;
    private StringBuilder path = null;
    private int currentNumberFormat = 0;
    private int pageNumber = 0;
    private Double xmin = null;
    private Double xmax = null;
    private Double ymin = null;
    private Double ymax = null;
    private StiOutputStreamWriter pageStream = null;
    private StiPdfExportService pdfService = null;
    public boolean assembleData = false;

    public StiPdfGeomWriter() {
    }

    public StiPdfGeomWriter(StiOutputStreamWriter stream, StiPdfExportService service) {
        this(stream, service, false);
    }

    public StiPdfGeomWriter(StiOutputStreamWriter stream, StiPdfExportService service, boolean assembleData) {
        this.pageStream = stream;
        this.pdfService = service;
        this.assembleData = assembleData;
    }

    private void calculateMinMax(StiPoint pt) {
        this.xmin = this.xmin == null ? Double.valueOf(pt.x) : Double.valueOf(Math.min(this.xmin, pt.x));
        this.xmax = this.xmax == null ? Double.valueOf(pt.x) : Double.valueOf(Math.max(this.xmax, pt.x));
        this.ymin = this.ymin == null ? Double.valueOf(pt.y) : Double.valueOf(Math.min(this.ymin, pt.y));
        this.ymax = this.ymax == null ? Double.valueOf(pt.y) : Double.valueOf(Math.max(this.ymax, pt.y));
    }

    private String convertToString(double value) {
        Double numValue = StiMath.round((double)value, (int)3);
        return numValue.toString();
    }

    private void setStrokeColor(StiPen pen) throws IOException {
        this.pdfService.setStrokeColor(pen.getColor());
        double penWidth = pen.getWidth();
        if (penWidth == 0.0) {
            penWidth = 0.1;
        }
        this.pageStream.writeLine("%s w", new Object[]{this.convertToString(penWidth)});
    }

    private void setNonStrokeColor(StiBrush brush) throws IOException {
        this.pdfService.setNonStrokeColor(((StiSolidBrush)brush).getColor());
    }

    private String getPointString(StiPoint point) {
        return String.format("%s %s m ", this.convertToString(point.x), this.convertToString(point.y));
    }

    private String getLineToString(StiPoint pointTo) {
        return String.format("%s %s l ", this.convertToString(pointTo.x), this.convertToString(pointTo.y));
    }

    private String getRectString(StiRectangle rect) {
        return String.format("%s %s %s %s re ", this.convertToString(rect.x), this.convertToString(rect.getTop()), this.convertToString(rect.getRight() - rect.x), this.convertToString(rect.getBottom() - rect.y));
    }

    private String getBezierString(double p1x, double p1y, double p2x, double p2y, double p3x, double p3y) {
        this.calculateMinMax(new StiPoint(p1x, p1y));
        this.calculateMinMax(new StiPoint(p2x, p2y));
        this.calculateMinMax(new StiPoint(p3x, p3y));
        return String.format("%s %s %s %s %s %s c ", this.convertToString(p1x), this.convertToString(p1y), this.convertToString(p2x), this.convertToString(p2y), this.convertToString(p3x), this.convertToString(p3y));
    }

    private String getPolylineString(StiPoint[] points, boolean close, boolean drawTo) {
        int index;
        StringBuilder sb = new StringBuilder();
        if (!drawTo) {
            sb.append(this.getPointString(points[0]));
        }
        int n = index = drawTo ? 0 : 1;
        while (index < points.length) {
            sb.append(this.getLineToString(points[index]));
            ++index;
        }
        if (close) {
            sb.append("h ");
        }
        return sb.toString();
    }

    private String getEllipseString(StiRectangle rect) {
        double tmpX = rect.width / 2.0 * (double)0.44772f;
        double tmpY = rect.height / 2.0 * (double)0.44772f;
        StringBuilder sb = new StringBuilder();
        sb.append(String.format("%s %s m ", this.convertToString(rect.x), this.convertToString(rect.y + rect.height / 2.0)));
        sb.append(this.getBezierString(rect.x, rect.y + rect.height - tmpY, rect.x + tmpX, rect.y + rect.height, rect.x + rect.width / 2.0, rect.y + rect.height));
        sb.append(this.getBezierString(rect.x + rect.width - tmpX, rect.y + rect.height, rect.x + rect.width, rect.y + rect.height - tmpY, rect.x + rect.width, rect.y + rect.height / 2.0));
        sb.append(this.getBezierString(rect.x + rect.width, rect.y + tmpY, rect.x + rect.width - tmpX, rect.y, rect.x + rect.width / 2.0, rect.y));
        sb.append(this.getBezierString(rect.x + tmpX, rect.y, rect.x, rect.y + tmpY, rect.x, rect.y + rect.height / 2.0));
        return sb.toString();
    }

    @Override
    public void beginPath() {
        if (this.assembleData) {
            return;
        }
        this.path = new StringBuilder();
        this.makePath = true;
        this.pathClosed = false;
    }

    @Override
    public void closeFigure() {
        if (this.assembleData) {
            return;
        }
        this.path.append("h ");
        this.pathClosed = true;
    }

    @Override
    public void endPath() {
        if (this.assembleData) {
            return;
        }
        this.makePath = false;
    }

    @Override
    public void fillPath(StiBrush brush) throws IOException {
        if (this.assembleData) {
            return;
        }
        if (!this.pathClosed) {
            this.endPath();
        }
        this.setNonStrokeColor(brush);
        this.pageStream.write(this.path.toString());
        this.pageStream.writeLine("f");
    }

    @Override
    public void strokePath(StiPen pen) throws IOException {
        if (this.assembleData) {
            return;
        }
        this.setStrokeColor(pen);
        this.pageStream.write(this.path.toString());
        this.pageStream.writeLine("S");
    }

    @Override
    public void moveTo(StiPoint point) throws IOException {
        if (this.assembleData) {
            return;
        }
        this.lastPoint = point;
        String stPoint = this.getPointString(point);
        if (this.makePath) {
            this.path.append(stPoint + "\\n");
        } else {
            this.pageStream.writeLine(stPoint);
        }
    }

    @Override
    public void drawLine(StiPoint pointFrom, StiPoint pointTo, StiPen pen) throws IOException {
        if (this.assembleData) {
            return;
        }
        String stLine = this.getPointString(pointFrom) + this.getLineToString(pointTo) + "S";
        if (this.makePath) {
            this.path.append(stLine + "\\n");
        } else if (pen != null) {
            this.setStrokeColor(pen);
            this.pageStream.writeLine(stLine);
        }
        this.lastPoint = pointTo;
    }

    @Override
    public void drawLineTo(StiPoint pointTo, StiPen pen) throws IOException {
        if (this.assembleData) {
            return;
        }
        String stLine = this.getLineToString(pointTo) + "S";
        if (this.makePath) {
            this.path.append(stLine + "\\n");
        } else if (pen != null) {
            this.setStrokeColor(pen);
            this.pageStream.writeLine(stLine);
        }
        this.lastPoint = pointTo;
    }

    @Override
    public void drawRectangle(StiRectangle rect, StiPen pen) throws Exception {
        if (this.assembleData) {
            return;
        }
        if (this.makePath) {
            throw new Exception();
        }
        if (pen != null) {
            this.setStrokeColor(pen);
            this.pageStream.writeLine(this.getRectString(rect) + "S");
        }
    }

    @Override
    public void fillRectangle(StiRectangle rect, StiColor color) throws Exception {
        if (color.getA() != 0) {
            this.fillRectangle(rect, (StiBrush)new StiSolidBrush(color));
        }
    }

    @Override
    public void fillRectangle(StiRectangle rect, StiBrush brush) throws Exception {
        if (this.assembleData) {
            return;
        }
        if (this.makePath) {
            throw new Exception();
        }
        if (brush != null) {
            this.setNonStrokeColor(brush);
            this.pageStream.writeLine(this.getRectString(rect) + "f");
        }
    }

    @Override
    public void drawPolyline(StiPoint[] points, StiPen pen) throws IOException {
        this.drawPolyline(points, pen, false, false);
    }

    @Override
    public void drawPolygon(StiPoint[] points, StiPen pen) throws Exception {
        if (this.makePath) {
            throw new Exception();
        }
        this.drawPolyline(points, pen, true, false);
    }

    public void drawPolyline(StiPoint[] points, StiPen pen, boolean close, boolean drawTo) throws IOException {
        if (this.assembleData) {
            return;
        }
        String stPolyline = this.getPolylineString(points, close, drawTo);
        if (this.makePath) {
            this.path.append(stPolyline);
        } else if (pen != null) {
            this.setStrokeColor(pen);
            this.pageStream.writeLine(stPolyline + "S");
        }
        this.lastPoint = points[points.length - 1];
    }

    @Override
    public void drawPolylineTo(StiPoint[] points, StiPen pen) throws IOException {
        this.drawPolyline(points, pen, false, true);
    }

    @Override
    public void fillPolygon(StiPoint[] points, StiBrush brush) throws Exception {
        if (this.assembleData) {
            return;
        }
        if (this.makePath) {
            throw new Exception();
        }
        if (brush != null) {
            String stPolygon = this.getPolylineString(points, true, false);
            this.setNonStrokeColor(brush);
            this.pageStream.writeLine(stPolygon + "f");
        }
    }

    @Override
    public void drawBezier(StiPoint p1, StiPoint p2, StiPoint p3, StiPoint p4, StiPen pen) {
        if (this.assembleData) {
            return;
        }
    }

    @Override
    public void drawBezierTo(StiPoint p2, StiPoint p3, StiPoint p4, StiPen pen) {
        if (this.assembleData) {
            return;
        }
    }

    @Override
    public void drawArc(StiRectangle rect, StiPoint p1, StiPoint p2, StiPen pen) {
        if (this.assembleData) {
            return;
        }
        this.lastPoint = p2;
    }

    public void drawEllipse(StiRectangle rect, StiPen pen) {
        if (this.assembleData) {
            return;
        }
    }

    @Override
    public void fillEllipse(StiRectangle rect, StiBrush brush) throws Exception {
        StiRefObject isTransparent = new StiRefObject((Object)false);
        boolean needRestore = this.setBrush(brush, rect, (StiRefObject<Boolean>)isTransparent, true);
        if (this.assembleData) {
            return;
        }
        if (this.makePath) {
            throw new Exception();
        }
        if (brush != null && !((Boolean)isTransparent.argvalue).booleanValue()) {
            this.pageStream.writeLine(this.getEllipseString(rect) + "f");
        }
        if (needRestore) {
            this.pageStream.writeLine("Q");
        }
    }

    @Override
    public void setPixel(StiPoint point, StiColor color) {
        if (this.assembleData) {
            return;
        }
    }

    public boolean setBrush(Object brush, StiRectangle rect, StiRefObject<Boolean> isTransparent, boolean saveState) throws IOException {
        isTransparent.argvalue = false;
        if (this.assembleData) {
            if (brush instanceof StiGradientBrush || brush instanceof StiGlareBrush || brush instanceof StiHatchBrush || brush instanceof StiGlassBrush) {
                this.pdfService.storeShadingData1((StiBrush)brush, this.pageNumber);
                this.pdfService.storeHatchData((StiBrush)brush);
            }
            return false;
        }
        boolean needSaveState = false;
        StiColor tempColor = StiColorEnum.Transparent.color();
        if (brush instanceof StiColor) {
            tempColor = (StiColor)brush;
        }
        if (brush instanceof StiBrush) {
            tempColor = StiBrush.ToColor((StiBrush)((StiBrush)brush));
        }
        this.pdfService.setNonStrokeColor(tempColor);
        if (tempColor.a == 0) {
            isTransparent.argvalue = true;
        }
        if (brush instanceof StiGradientBrush || brush instanceof StiGlareBrush || brush instanceof StiHatchBrush || brush instanceof StiGlassBrush) {
            StiPoint p1 = new StiPoint(rect.x, rect.getBottom());
            StiPoint p2 = new StiPoint(rect.getRight(), rect.y);
            StiPoint[] points = new StiPoint[]{p1, p2};
            StiRectangle rect2 = new StiRectangle(points[0].x, points[0].y, points[1].x - points[0].x, points[1].y - points[0].y);
            int shadingCurrent = this.pdfService.storeShadingData2(rect2.x, rect2.y, rect2.width, rect2.height, (StiBrush)brush);
            if (brush instanceof StiGradientBrush || brush instanceof StiGlareBrush) {
                this.pageStream.writeLine("/Pattern cs /P{0} scn", new Object[]{1 + shadingCurrent});
            }
            if (brush instanceof StiHatchBrush) {
                StiHatchBrush hBrush = (StiHatchBrush)brush;
                this.pageStream.writeLine("/Cs1 cs /PH{0} scn", new Object[]{this.pdfService.getHatchNumber(hBrush) + 1});
            }
            needSaveState = true;
        }
        boolean bl = needSaveState = needSaveState && saveState;
        if (needSaveState) {
            this.pageStream.writeLine("q");
        }
        return needSaveState;
    }

    @Override
    public void drawImage(StiImage img, StiRectangle rect) throws IOException {
        StiImage image = new StiImage();
        image.setClientRectangle(rect.clone());
        image.setImage(img);
        image.setSmoothing(true);
        image.setStretch(true);
        if (this.assembleData) {
            this.pdfService.storeImageDataForGeom(image);
            return;
        }
        StiPdfData pp = new StiPdfData();
        pp.Component = image;
        pp.Width = rect.width;
        pp.Height = rect.height;
        this.pageStream.writeLine("q");
        this.pdfService.pushColorToStack();
        this.pageStream.writeLine("1 0 0 1 %s %s cm", new Object[]{this.convertToString(rect.x), this.convertToString(rect.y + rect.height)});
        this.pageStream.writeLine("1 0 0 -1 0 0 cm");
        this.pdfService.renderImage(pp, 100.0f);
        this.pageStream.writeLine("Q");
        this.pdfService.popColorFromStack();
    }

    @Override
    public void drawText(StiPoint basePoint, String text, int[] charsOffset, StiFont font, StiColor textColor, double angle, EmfTextAlignmentMode textAlign) throws Exception {
        if (this.assembleData) {
            return;
        }
        if (this.makePath) {
            throw new Exception();
        }
    }

    @Override
    public void drawString(String st, StiFont font, StiBrush brush, StiRectangle rect, StiTextHorAlignment horAlignment, StiVertAlignment vertAlignment) throws IOException {
        if (this.assembleData) {
            if (font != null) {
                int fnt = this.pdfService.pdfFont.getFontNumber(font);
            }
            StringBuilder sb = new StringBuilder(st);
            this.pdfService.pdfFont.storeUnicodeSymbolsInMap(sb);
            return;
        }
        StiText txt = new StiText();
        txt.setClientRectangle(rect.clone());
        txt.setText(st);
        txt.setFont(font);
        txt.setTextBrush(brush);
        txt.setHorAlignment(horAlignment);
        txt.setVertAlignment(vertAlignment);
        StiPdfData pp = new StiPdfData();
        pp.Component = txt;
        pp.Width = rect.width * 0.72;
        pp.Height = rect.height * 0.72;
        this.pageStream.writeLine("q");
        this.pdfService.pushColorToStack();
        this.pageStream.writeLine("1 0 0 1 %s %s cm", new Object[]{this.convertToString(rect.x), this.convertToString(rect.y + rect.height)});
        this.pageStream.writeLine("1 0 0 -1 0 0 cm");
        this.pageStream.writeLine("1.39 0 0 1.39 0 0 cm");
        this.pdfService.renderTextFont(pp);
        this.pdfService.renderText(pp);
        this.pageStream.writeLine("Q");
        this.pdfService.popColorFromStack();
    }

    @Override
    public void saveState() throws IOException {
        if (this.assembleData) {
            return;
        }
        this.pageStream.writeLine("q");
        this.pdfService.pushColorToStack();
    }

    @Override
    public void restoreState() throws IOException {
        if (this.assembleData) {
            return;
        }
        this.pageStream.writeLine("Q");
        this.pdfService.popColorFromStack();
    }

    @Override
    public void translateTransform(double x, double y) throws IOException {
        if (this.assembleData) {
            return;
        }
        this.pageStream.writeLine("1 0 0 1 %s %s cm", new Object[]{this.convertToString(x), this.convertToString(y)});
    }

    @Override
    public void rotateTransform(double angle) throws IOException {
        if (this.assembleData) {
            return;
        }
        double AngleInRadians = angle * Math.PI / 180.0;
        this.pageStream.writeLine("%s %s %s %s 0 0 cm", new Object[]{this.convertToString(Math.cos(AngleInRadians)), this.convertToString(Math.sin(AngleInRadians)), this.convertToString(-Math.sin(AngleInRadians)), this.convertToString(Math.cos(AngleInRadians))});
    }

    @Override
    public StiSize measureString(String st, StiFont font) {
        return new StiSize();
    }
}

