/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.report.export.tools.html;

import com.stimulsoft.base.drawing.enums.StiHorAlignment;
import com.stimulsoft.lib.utils.StiValidationUtil;
import com.stimulsoft.report.export.tools.html.StiHtmlHyperlink;
import com.stimulsoft.report.export.tools.html.StiHtmlImage;
import com.stimulsoft.report.export.tools.html.StiHtmlTableCell;
import com.stimulsoft.report.export.tools.html.StiHtmlTableRow;
import com.stimulsoft.report.export.tools.html.StiHtmlTextWriter;
import com.stimulsoft.report.export.tools.html.StiHtmlUnit;
import com.stimulsoft.report.options.ExportOptions;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;

public class StiHtmlTable {
    public String backImageUrl;
    public StiHtmlUnit width;
    public Integer borderWidth;
    public Integer cellPadding;
    public Integer cellSpacing;
    public ArrayList<StiHtmlTableRow> rows = new ArrayList();
    private static String wrongUrlSymbols = "\"&<";
    private StiHorAlignment Align = StiHorAlignment.Left;
    public static final String MarginsKey = "padding";
    public static final String PageBreakBeforeKey = "page-break-before";
    public static final String VertAlignKey = "div:vertical-align";
    public static final String HorAlignKey = "div:text-align";
    public static final String WordwrapKey = "div:wordwrap";

    public static String stringToUrl(String input) {
        try {
            byte[] buf = input.getBytes("UTF8");
            StringBuilder output = new StringBuilder();
            for (byte byt : buf) {
                if (byt <= 32 || byt > 127 || wrongUrlSymbols.indexOf((char)byt) != -1) {
                    if (byt <= 32 || byt > 127) {
                        output.append("%" + Integer.toString((byt & 0xFF) + 256, 16).substring(1));
                    }
                    if (byt == 34) {
                        output.append("&quot;");
                    }
                    if (byt == 38) {
                        output.append("&amp;");
                    }
                    if (byt != 60) continue;
                    output.append("&lt;");
                    continue;
                }
                output.append((char)byt);
            }
            return output.toString();
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            return null;
        }
    }

    public void renderControl(StiHtmlTextWriter writer) throws IOException {
        this.writeTableBegin(writer, false);
        for (StiHtmlTableRow row : this.rows) {
            if (row.getStyle().containsKey(PageBreakBeforeKey)) {
                row.getStyle().remove(PageBreakBeforeKey);
                this.writeTableEnd(writer);
                writer.writeLine();
                this.writeTableBegin(writer, true);
            }
            writer.writeBeginTag("tr");
            if (ExportOptions.Html.isUseExtendedStyle()) {
                writer.writeStyleAttribute("class", "sBaseStyleFix");
            }
            if (!StiHtmlUnit.isNullOrZero(row.getHeight())) {
                row.getStyle().put("height", row.getHeight().toString());
            }
            if (row.getStyle().size() > 0) {
                writer.write(" style=\"");
                for (String key : row.getStyle().keySet()) {
                    writer.writeStyleAttribute(key, row.getStyle().get(key));
                }
                writer.write("\"");
            }
            writer.writeLine(">");
            writer.incIndent();
            for (StiHtmlTableCell cell : row.getCells()) {
                boolean isCellNotEmpty;
                writer.writeBeginTag("td");
                if (StiValidationUtil.isNotNullOrEmpty((String)cell.getToolTip())) {
                    writer.writeAttribute("title", cell.getToolTip());
                }
                if (StiValidationUtil.isNotNullOrEmpty((String)cell.getCssClass())) {
                    writer.writeAttribute("class", cell.getCssClass());
                }
                if (!StiValidationUtil.isNullOrEmpty((String)cell.id)) {
                    writer.writeAttribute("id", cell.id);
                }
                if (!StiValidationUtil.isNullOrEmpty((String)cell.getEditable())) {
                    writer.writeAttribute("editable", cell.getEditable());
                }
                if (cell.getColumnSpan() > 0) {
                    writer.writeAttribute("colspan", cell.getColumnSpan().toString());
                }
                if (cell.getRowSpan() > 0) {
                    writer.writeAttribute("rowspan", cell.getRowSpan().toString());
                }
                if (StiValidationUtil.isNotNullOrEmpty((String)cell.getInteraction())) {
                    writer.writeAttribute("interaction", cell.getInteraction());
                }
                if (!StiValidationUtil.isNullOrEmpty((String)cell.getCollapsed())) {
                    writer.writeAttribute("collapsed", cell.getCollapsed());
                }
                if (StiValidationUtil.isNotNullOrEmpty((String)cell.getSortDirection())) {
                    writer.writeAttribute("sort", cell.getSortDirection());
                }
                if (!StiValidationUtil.isNullOrEmpty((String)cell.getDataBandSort())) {
                    writer.writeAttribute("databandsort", cell.getDataBandSort());
                }
                if (!StiValidationUtil.isNullOrEmpty((String)cell.getPageGuid())) {
                    writer.writeAttribute("pageguid", cell.getPageGuid());
                }
                if (!StiValidationUtil.isNullOrEmpty((String)cell.getPageIndex())) {
                    writer.writeAttribute("pageindex", cell.getPageIndex());
                }
                if (!StiValidationUtil.isNullOrEmpty((String)cell.getComponentIndex())) {
                    writer.writeAttribute("compindex", cell.getComponentIndex());
                }
                if (!StiHtmlUnit.isNullOrZero(cell.getHeight())) {
                    cell.getStyle().put("height", cell.getHeight().toString());
                }
                if (!StiHtmlUnit.isNullOrZero(cell.getWidth())) {
                    cell.getStyle().put("width", cell.getWidth().toString());
                }
                String marginsEntry = null;
                String cellVertAlign = null;
                String cellHorAlign = null;
                if (ExportOptions.Html.isUseStrictTableCellSize() && cell.getStyle().size() > 0) {
                    if (cell.getStyle().containsKey(MarginsKey)) {
                        marginsEntry = cell.getStyle().get(MarginsKey);
                        cell.getStyle().remove(MarginsKey);
                    }
                    if (cell.getStyle().containsKey(VertAlignKey) && cell.getStyle().containsKey("height")) {
                        cellVertAlign = cell.getStyle().get(VertAlignKey);
                        cell.getStyle().remove(VertAlignKey);
                    }
                    if (cell.getStyle().containsKey(HorAlignKey) && cell.getStyle().containsKey("width")) {
                        cellHorAlign = cell.getStyle().get(HorAlignKey);
                        cell.getStyle().remove(HorAlignKey);
                    }
                }
                boolean cellWordwrap = false;
                if (cell.getStyle().containsKey(WordwrapKey) && cell.getStyle().containsKey("width")) {
                    cellWordwrap = true;
                    cell.getStyle().remove(WordwrapKey);
                }
                StiHtmlHyperlink hyperLink = null;
                StiHtmlImage image = null;
                if (cell.getControls().size() > 0) {
                    hyperLink = cell.getControls().get(0) instanceof StiHtmlHyperlink ? (StiHtmlHyperlink)cell.getControls().get(0) : null;
                    StiHtmlImage stiHtmlImage = image = cell.getControls().get(0) instanceof StiHtmlImage ? (StiHtmlImage)cell.getControls().get(0) : null;
                }
                if (image != null && !ExportOptions.Html.isUseStrictTableCellSize()) {
                    cell.getStyle().put("line-height", "0");
                }
                if (cell.getStyle().size() > 0) {
                    writer.write(" style=\"");
                    for (String key : cell.getStyle().keySet()) {
                        writer.writeStyleAttribute(key, cell.getStyle().get(key));
                    }
                    writer.write("\"");
                }
                writer.write(">");
                String stFixStyle = null;
                boolean bl = isCellNotEmpty = cell.getControls().size() > 0 || !StiValidationUtil.isNullOrEmpty((String)cell.getText());
                if (isCellNotEmpty && ExportOptions.Html.isUseStrictTableCellSize()) {
                    writer.write("<div");
                    if (ExportOptions.Html.isUseExtendedStyle()) {
                        String stColor;
                        writer.writeStyleAttribute("class", "sBaseStyleFix");
                        String stFont = cell.getStyle().containsKey("Font") ? cell.getStyle().get("Font") : null;
                        String stDecor = cell.getStyle().containsKey("text-decoration") ? cell.getStyle().get("text-decoration") : null;
                        String string = stColor = cell.getStyle().containsKey("color") ? cell.getStyle().get("color") : null;
                        if (!StiValidationUtil.isNullOrEmpty((String)stFont)) {
                            stFixStyle = "Font:" + stFont + ";";
                        }
                        if (!StiValidationUtil.isNullOrEmpty((String)stDecor)) {
                            stFixStyle = stFixStyle + "text-decoration:" + stDecor + ";";
                        }
                        if (!StiValidationUtil.isNullOrEmpty((String)stColor)) {
                            stFixStyle = stFixStyle + "color:" + stColor + ";";
                        }
                    }
                    if (cell.getStyle().containsKey("width") || cell.getStyle().containsKey("height") || stFixStyle != null) {
                        writer.write(" style=\"");
                        if (cell.getStyle().containsKey("width")) {
                            writer.writeStyleAttribute("width", cell.getStyle().get("width"));
                        }
                        if (cell.getStyle().containsKey("height")) {
                            writer.writeStyleAttribute("height", cell.getStyle().get("height"));
                        }
                        if (!StiValidationUtil.isNullOrEmpty(stFixStyle)) {
                            writer.write(stFixStyle);
                        }
                        writer.write("\"");
                    }
                    writer.write(">");
                    if (cellVertAlign != null || cellHorAlign != null) {
                        writer.write("<div ");
                        if (ExportOptions.Html.isUseExtendedStyle()) {
                            writer.write("class=\"sBaseStyleFix\" ");
                        }
                        writer.write("style=\"");
                        writer.writeStyleAttribute("display", "table-cell");
                        if (cellVertAlign != null) {
                            writer.writeStyleAttribute("height", cell.getStyle().get("height"));
                            writer.writeStyleAttribute("vertical-align", cellVertAlign);
                        }
                        if (cellHorAlign != null) {
                            writer.writeStyleAttribute("width", cell.getStyle().get("width"));
                            writer.writeStyleAttribute("text-align", cellHorAlign);
                        }
                        if (!StiValidationUtil.isNullOrEmpty(stFixStyle)) {
                            writer.write(stFixStyle);
                        }
                        writer.write("\">");
                    }
                    if (marginsEntry != null || cellWordwrap) {
                        writer.write("<div ");
                        if (ExportOptions.Html.isUseExtendedStyle()) {
                            writer.write("class=\"sBaseStyleFix\" ");
                        }
                        writer.write("style=\"");
                        if (marginsEntry != null) {
                            writer.writeStyleAttribute("margin", marginsEntry);
                        }
                        if (cellWordwrap) {
                            writer.writeStyleAttribute("width", cell.getStyle().get("width"));
                        }
                        if (!StiValidationUtil.isNullOrEmpty(stFixStyle)) {
                            writer.write(stFixStyle);
                        }
                        writer.write("\">");
                    }
                }
                if (image != null) {
                    writer.writeBeginTag("img");
                    if (StiValidationUtil.isNotNullOrEmpty((String)image.getToolTip())) {
                        writer.writeAttribute("title", image.getToolTip());
                    }
                    if (StiValidationUtil.isNotNullOrEmpty((String)image.getImageUrl())) {
                        writer.writeAttribute("src", StiHtmlTable.stringToUrl(image.getImageUrl()));
                    }
                    writer.write(" style=\"");
                    if (image.getMargin() == null) {
                        writer.writeStyleAttribute("height", cell.getHeight().toString());
                        writer.writeStyleAttribute("width", cell.getWidth().toString());
                    } else {
                        writer.writeStyleAttribute("height", StiHtmlUnit.newUnit(cell.getHeight().getValue() + Math.abs(image.getMargin().getValue() * 2.0), false).toString());
                        writer.writeStyleAttribute("width", StiHtmlUnit.newUnit(cell.getWidth().getValue() + Math.abs(image.getMargin().getValue() * 2.0), false).toString());
                        writer.writeStyleAttribute("margin", image.getMargin().toString());
                    }
                    writer.writeStyleAttribute("border-width", StiHtmlUnit.toPixelString(0));
                    writer.write("\" />");
                } else if (hyperLink != null) {
                    writer.writeBeginTag("a");
                    if (StiValidationUtil.isNotNullOrEmpty((String)hyperLink.getOpenLinksTarget())) {
                        writer.writeAttribute("target", hyperLink.getOpenLinksTarget());
                    }
                    if (StiValidationUtil.isNotNullOrEmpty((String)hyperLink.getToolTip())) {
                        writer.writeAttribute("title", hyperLink.getToolTip());
                    }
                    if (StiValidationUtil.isNotNullOrEmpty((String)hyperLink.getCssClass())) {
                        writer.writeAttribute("class", hyperLink.getCssClass());
                    }
                    if (hyperLink.getAttributes().containsKey("name")) {
                        writer.writeAttribute("name", hyperLink.getAttributes().get("name").replaceAll("'", ""));
                    }
                    if (hyperLink.getAttributes().containsKey("guid")) {
                        writer.writeAttribute("guid", hyperLink.getAttributes().get("guid"));
                    }
                    if (StiValidationUtil.isNotNullOrEmpty((String)hyperLink.getNavigateUrl())) {
                        writer.writeAttribute("href", StiHtmlTable.stringToUrl(hyperLink.getNavigateUrl()));
                    }
                    if (StiValidationUtil.isNotNullOrEmpty((String)hyperLink.getImageUrl())) {
                        hyperLink.getStyle().put("display", "inline-block");
                        hyperLink.getStyle().put("height", hyperLink.getHeight().toString());
                        hyperLink.getStyle().put("width", hyperLink.getWidth().toString());
                    }
                    if (ExportOptions.Html.isUseExtendedStyle()) {
                        hyperLink.getStyle().put("border", "0");
                    }
                    if (hyperLink.getStyle().size() > 0) {
                        writer.write(" style=\"");
                        for (String key : hyperLink.getStyle().keySet()) {
                            writer.writeStyleAttribute(key, hyperLink.getStyle().get(key));
                        }
                        if (!StiValidationUtil.isNullOrEmpty((String)stFixStyle)) {
                            writer.write(stFixStyle);
                        }
                        writer.write("\"");
                    }
                    writer.write(">");
                    if (StiValidationUtil.isNotNullOrEmpty((String)hyperLink.getImageUrl())) {
                        writer.writeBeginTag("img");
                        if (StiValidationUtil.isNotNullOrEmpty((String)hyperLink.getToolTip())) {
                            writer.writeAttribute("title", hyperLink.getToolTip());
                        }
                        writer.writeAttribute("src", StiHtmlTable.stringToUrl(hyperLink.getImageUrl()));
                        writer.write(" style=\"");
                        writer.writeStyleAttribute("height", hyperLink.getHeight().toString());
                        writer.writeStyleAttribute("width", hyperLink.getWidth().toString());
                        writer.writeStyleAttribute("border-width", StiHtmlUnit.toPixelString(0));
                        writer.write("\" />");
                    }
                    writer.write(hyperLink.getText() != null ? hyperLink.getText() : cell.getText());
                    writer.writeFullEndTag("a");
                } else {
                    writer.write(cell.getText());
                }
                if (isCellNotEmpty && ExportOptions.Html.isUseStrictTableCellSize()) {
                    if (marginsEntry != null || cellWordwrap) {
                        writer.write("</div>");
                    }
                    if (cellVertAlign != null || cellHorAlign != null) {
                        writer.write("</div>");
                    }
                    writer.write("</div>");
                }
                writer.writeFullEndTag("td");
            }
            writer.writeLine();
            writer.decIndent();
            writer.writeFullEndTag("tr");
        }
        this.writeTableEnd(writer);
    }

    private void writeTableBegin(StiHtmlTextWriter writer, boolean writePageBreak) throws IOException {
        writer.writeBeginTag("table");
        writer.writeAttribute("cellspacing", String.valueOf(this.cellSpacing));
        writer.writeAttribute("cellpadding", String.valueOf(this.cellPadding));
        writer.writeAttribute("border", "0");
        if (this.Align != StiHorAlignment.Left) {
            writer.writeAttribute("align", this.Align == StiHorAlignment.Center ? "center" : "right");
        }
        writer.write(" style=\"");
        writer.writeStyleAttribute("border-width", StiHtmlUnit.toPixelString(this.borderWidth));
        writer.writeStyleAttribute("width", String.valueOf(this.width));
        if (!StiValidationUtil.isNullOrEmpty((String)this.backImageUrl)) {
            writer.writeStyleAttribute("background-image", String.format("url('%s')", StiHtmlTable.stringToUrl(this.backImageUrl)));
        }
        writer.writeStyleAttribute("border-collapse", "collapse");
        if (writePageBreak) {
            writer.writeStyleAttribute(PageBreakBeforeKey, "always");
        }
        writer.write("\">");
        writer.writeLine();
        writer.incIndent();
    }

    private void writeTableEnd(StiHtmlTextWriter writer) throws IOException {
        writer.writeLine();
        writer.decIndent();
        writer.writeFullEndTag("table");
    }

    public String getBackImageUrl() {
        return this.backImageUrl;
    }

    public void setBackImageUrl(String backImageUrl) {
        this.backImageUrl = backImageUrl;
    }

    public StiHtmlUnit getWidth() {
        return this.width;
    }

    public void setWidth(StiHtmlUnit width) {
        this.width = width;
    }

    public Integer getBorderWidth() {
        return this.borderWidth;
    }

    public void setBorderWidth(Integer borderWidth) {
        this.borderWidth = borderWidth;
    }

    public Integer getCellPadding() {
        return this.cellPadding;
    }

    public void setCellPadding(Integer cellPadding) {
        this.cellPadding = cellPadding;
    }

    public Integer getCellSpacing() {
        return this.cellSpacing;
    }

    public void setCellSpacing(Integer cellSpacing) {
        this.cellSpacing = cellSpacing;
    }

    public ArrayList<StiHtmlTableRow> getRows() {
        return this.rows;
    }

    public void setRows(ArrayList<StiHtmlTableRow> rows) {
        this.rows = rows;
    }

    public StiHorAlignment getAlign() {
        return this.Align;
    }

    public void setAlign(StiHorAlignment align) {
        this.Align = align;
    }
}

