/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.report.export.tools.html;

import java.io.BufferedWriter;
import java.io.IOException;

public class StiHtmlTextWriter {
    private WriterMode mode = WriterMode.None;
    private int indent = 0;
    private BufferedWriter stream = null;

    public StiHtmlTextWriter(BufferedWriter baseStream) {
        this.stream = baseStream;
        this.mode = WriterMode.None;
        this.indent = 0;
    }

    public void write(String st) throws IOException {
        this.checkIndent();
        if (st != null) {
            this.stream.write(st);
        }
        this.mode = WriterMode.Data;
    }

    public void writeLine() throws IOException {
        this.stream.newLine();
        this.mode = WriterMode.None;
    }

    public void writeLine(String st) throws IOException {
        if (st == null || st.length() == 0) {
            this.stream.newLine();
        } else {
            this.checkIndent();
            this.stream.write(st);
            this.stream.newLine();
        }
        this.mode = WriterMode.None;
    }

    public void writeBeginTag(String st) throws IOException {
        this.closeTag();
        this.checkIndent();
        this.stream.write("<" + st);
        this.mode = WriterMode.BeginTag;
    }

    public void writeFullBeginTag(String st) throws IOException {
        this.closeTag();
        this.checkIndent();
        this.stream.write("<" + st + ">");
        this.mode = WriterMode.Data;
    }

    public void writeEndTag(String st) throws IOException {
        if (this.mode == WriterMode.BeginTag) {
            this.stream.write("/>");
        } else {
            this.closeTag();
            this.checkIndent();
            this.stream.write("</" + st + ">");
        }
        this.mode = WriterMode.Data;
    }

    public void writeFullEndTag(String st) throws IOException {
        this.closeTag();
        this.checkIndent();
        this.stream.write("</" + st + ">");
        this.mode = WriterMode.Data;
    }

    public void writeAttribute(String attr, String value) throws IOException {
        this.stream.write(" " + attr);
        if (value != null) {
            this.stream.write("=\"" + value + "\"");
        }
        this.mode = WriterMode.Attribute;
    }

    public void writeStyleAttribute(String attr, String value) throws IOException {
        this.stream.write(attr + ":" + value + ";");
        this.mode = WriterMode.Attribute;
    }

    public void flush() throws IOException {
        this.stream.flush();
    }

    private void closeTag() throws IOException {
        if (this.mode == WriterMode.Attribute || this.mode == WriterMode.BeginTag) {
            this.stream.write(">");
        }
    }

    private void checkIndent() throws IOException {
        if (this.mode == WriterMode.None) {
            for (int index = 0; index < this.indent; ++index) {
                this.stream.write("\t");
            }
        }
    }

    public void incIndent() {
        ++this.indent;
    }

    public void decIndent() {
        --this.indent;
    }

    public WriterMode getMode() {
        return this.mode;
    }

    public void setMode(WriterMode mode) {
        this.mode = mode;
    }

    public int getIndent() {
        return this.indent;
    }

    public void setIndent(int indent) {
        this.indent = indent;
    }

    public BufferedWriter getStream() {
        return this.stream;
    }

    public void setStream(BufferedWriter stream) {
        this.stream = stream;
    }

    public static enum WriterMode {
        None,
        BeginTag,
        Attribute,
        Data;

    }
}

