/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.report.globalization;

import com.stimulsoft.base.IStiJsonReportObject;
import com.stimulsoft.base.StiJsonSaveMode;
import com.stimulsoft.base.exception.StiException;
import com.stimulsoft.base.json.JProperty;
import com.stimulsoft.base.json.JSONException;
import com.stimulsoft.base.json.JSONObject;
import com.stimulsoft.report.StiReport;
import com.stimulsoft.report.components.StiComponent;
import com.stimulsoft.report.globalization.IStiGlobalizationProvider;
import com.stimulsoft.report.globalization.StiGlobalizationContainer;
import com.stimulsoft.report.globalization.StiGlobalizationItem;
import java.util.ArrayList;

public class StiGlobalizationContainerCollection
extends ArrayList<StiGlobalizationContainer>
implements IStiJsonReportObject {
    private static final long serialVersionUID = -3881677882211527836L;
    private StiReport report;

    public StiGlobalizationContainerCollection() {
    }

    public StiGlobalizationContainerCollection(StiReport report) {
        this.report = report;
    }

    public StiGlobalizationContainer get(String name) {
        name = name.toLowerCase();
        for (StiGlobalizationContainer container : this) {
            if (!name.equals(container.getCultureName().toLowerCase())) continue;
            return container;
        }
        return null;
    }

    public void add(StiGlobalizationContainer value, String name) {
        name = name.toLowerCase();
        for (int index = 0; index < this.size(); ++index) {
            StiGlobalizationContainer container = (StiGlobalizationContainer)((Object)this.get(index));
            if (!name.equals(container.getCultureName().toLowerCase())) continue;
            this.add(index, value);
            return;
        }
        this.add(value);
    }

    public void localizeReport(String cultureName) throws StiException {
        StiGlobalizationContainer container = this.get(cultureName);
        if (container == null) {
            throw new StiException(String.format("Can't find globalized strings for culture %s", cultureName));
        }
        if (container != null) {
            container.localizeReport(this.report);
        }
    }

    public void fillItemsFromReport() {
        for (StiGlobalizationContainer container : this) {
            container.fillItemsFromReport(this.report);
        }
    }

    public void removeUnlocalizedItemsFromReport() {
        for (StiGlobalizationContainer container : this) {
            container.removeUnlocalizedItemsFromReport(this.report);
        }
    }

    public void removeComponent(StiComponent comp) {
        IStiGlobalizationProvider provider;
        IStiGlobalizationProvider iStiGlobalizationProvider = provider = comp instanceof IStiGlobalizationProvider ? (IStiGlobalizationProvider)((Object)comp) : null;
        if (provider != null) {
            String[] strs;
            for (String str : strs = provider.getAllStrings()) {
                String data = String.format("%s.%s", comp.getName(), str);
                for (StiGlobalizationContainer container : this) {
                    int index = 0;
                    while (index < container.getItems().size()) {
                        StiGlobalizationItem item = (StiGlobalizationItem)container.getItems().get(index);
                        if (data.equals(item.getPropertyName())) {
                            container.getItems().remove(index);
                            continue;
                        }
                        ++index;
                    }
                }
            }
        }
    }

    public void renameComponent(StiComponent comp, String oldName, String newName) {
        IStiGlobalizationProvider provider;
        IStiGlobalizationProvider iStiGlobalizationProvider = provider = comp instanceof IStiGlobalizationProvider ? (IStiGlobalizationProvider)((Object)comp) : null;
        if (provider != null) {
            String[] strs;
            for (String str : strs = provider.getAllStrings()) {
                String oldData = String.format("%s.%s", oldName, str);
                String newData = String.format("%s.%s", newName, str);
                for (StiGlobalizationContainer container : this) {
                    for (StiGlobalizationItem item : container.getItems()) {
                        if (!oldData.equals(item.getPropertyName())) continue;
                        item.setPropertyName(newData);
                    }
                }
            }
        }
    }

    public void setReport(StiReport report) {
        this.report = report;
    }

    public JSONObject SaveToJsonObject(StiJsonSaveMode mode) throws JSONException {
        if (this.size() == 0) {
            return null;
        }
        JSONObject jObject = new JSONObject();
        Integer index = 0;
        for (StiGlobalizationContainer container : this) {
            jObject.AddPropertyJObject(index.toString(), container.SaveToJsonObject(mode));
            Integer n = index;
            Integer n2 = index = Integer.valueOf(index + 1);
        }
        return jObject;
    }

    public void LoadFromJsonObject(JSONObject jObject) throws JSONException {
        for (JProperty property : jObject.Properties()) {
            StiGlobalizationContainer container = new StiGlobalizationContainer();
            container.LoadFromJsonObject((JSONObject)property.Value);
            this.add(container);
        }
    }
}

