/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.report.infographics.gauge.collections;

import com.stimulsoft.base.IStiJsonReportObject;
import com.stimulsoft.base.StiJsonSaveMode;
import com.stimulsoft.base.json.JProperty;
import com.stimulsoft.base.json.JSONException;
import com.stimulsoft.base.json.JSONObject;
import com.stimulsoft.report.StiOptions;
import com.stimulsoft.report.infographics.gauge.StiGaugeElemenType;
import com.stimulsoft.report.infographics.gauge.primitives.base.StiGaugeElement;
import com.stimulsoft.report.infographics.gauge.primitives.scales.StiScaleBase;
import java.util.ArrayList;
import java.util.Collection;

public class StiGaugeElementCollection
extends ArrayList<StiGaugeElement>
implements Cloneable,
IStiJsonReportObject {
    private static final long serialVersionUID = 964093708288022491L;
    private StiScaleBase scale;
    private StiGaugeElemenType scaleType;

    public JSONObject SaveToJsonObject(StiJsonSaveMode mode) throws JSONException {
        if (this.size() == 0) {
            return null;
        }
        JSONObject jObject = new JSONObject();
        Integer index = 0;
        for (StiGaugeElement component : this) {
            jObject.AddPropertyJObject(index.toString(), component.SaveToJsonObject(mode));
            Integer n = index;
            Integer n2 = index = Integer.valueOf(index + 1);
        }
        return jObject;
    }

    public void LoadFromJsonObject(JSONObject jObject) throws JSONException {
        for (JProperty property : jObject.Properties()) {
            JSONObject propJObject = (JSONObject)property.Value;
            String ident = "";
            for (JProperty prop : propJObject.Properties()) {
                if (!"Ident".equals(prop.Name)) continue;
                ident = prop.Value.toString();
            }
            StiGaugeElement element = null;
            for (StiGaugeElement el : StiOptions.Services.getGaugeElements()) {
                String name = el.getClass().getName();
                if (!name.substring(name.lastIndexOf(46) + 1).equals(ident)) continue;
                element = el;
            }
            if (element == null) {
                throw new RuntimeException(String.format("Type %s is not found!", ident));
            }
            StiGaugeElement elementClone = element.createNew();
            elementClone.setScale(element.getScale());
            this.add(elementClone);
            elementClone.LoadFromJsonObject((JSONObject)property.Value);
        }
    }

    @Override
    public Object clone() {
        StiGaugeElementCollection clone = new StiGaugeElementCollection(this.scale);
        for (StiGaugeElement element : this) {
            clone.add((StiGaugeElement)element.clone());
        }
        return clone;
    }

    public boolean getIsReadOnly() {
        return false;
    }

    @Override
    public void add(int index, StiGaugeElement element) {
        if (element.getElementType() == this.scaleType || element.getElementType() == StiGaugeElemenType.All) {
            element.setScale(this.scale);
        }
        super.add(index, element);
    }

    @Override
    public StiGaugeElement set(int index, StiGaugeElement value) {
        value.setScale(this.scale);
        return this.setItemInternal(index, value);
    }

    private boolean addCore(StiGaugeElement element) {
        if (element.getElementType() == this.scaleType || element.getElementType() == StiGaugeElemenType.All) {
            element.setScale(this.scale);
        }
        return super.add(element);
    }

    @Override
    public boolean add(StiGaugeElement element) {
        return this.addCore(element);
    }

    public void addAll(StiGaugeElement[] elements) {
        for (StiGaugeElement element : elements) {
            this.addCore(element);
        }
    }

    public boolean remove(StiGaugeElement element) {
        int index = this.indexOf(element);
        if (index != -1) {
            element.setScale(null);
        }
        return super.remove(element);
    }

    StiGaugeElement setItemInternal(int index, StiGaugeElement element) {
        if (element.getElementType() == this.scaleType || element.getElementType() == StiGaugeElemenType.All) {
            element.setScale(this.scale);
        }
        return this.set(index, element);
    }

    public boolean moveUp(StiGaugeElement element) {
        int index = this.indexOf(element);
        if (index > 0) {
            this.remove(index);
            this.add(--index, element);
            return true;
        }
        return false;
    }

    public boolean moveDown(StiGaugeElement element) {
        int index = this.indexOf(element);
        if (index != -1 && this.size() > 1 && index < this.size() - 1) {
            this.remove(index);
            this.add(++index, element);
            return true;
        }
        return false;
    }

    @Override
    public boolean addAll(Collection<? extends StiGaugeElement> c) {
        boolean res = true;
        for (StiGaugeElement stiGaugeElement : c) {
            if (this.addCore(stiGaugeElement)) continue;
            res = false;
        }
        return res;
    }

    public StiGaugeElementCollection(StiScaleBase scale) {
        this.scaleType = scale.getScaleType();
        this.scale = scale;
    }

    public StiGaugeElementCollection() {
    }
}

