/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.report.infographics.gauge.helpers;

import com.stimulsoft.base.drawing.path.StiPathArc;
import com.stimulsoft.base.drawing.path.StiPathClose;
import com.stimulsoft.base.drawing.path.StiPathCommand;
import com.stimulsoft.base.drawing.path.StiPathCubicBezier;
import com.stimulsoft.base.drawing.path.StiPathLine;
import com.stimulsoft.base.system.geometry.StiPoint;
import com.stimulsoft.base.system.geometry.StiRectangle;
import com.stimulsoft.report.infographics.gauge.helpers.StiRectangleHelper;
import java.util.ArrayList;
import java.util.List;

public class StiDrawingHelper {
    static final double PiDiv180 = Math.PI / 180;
    private static final double FourDivThree = 1.3333333730697632;

    public static List<StiPathCommand> getRoundedPath(StiRectangle rect, int offset, int leftTop, int rightTop, int rightBottom, int leftBottom) {
        ArrayList<StiPathCommand> gp = new ArrayList<StiPathCommand>();
        double right = rect.x + rect.width - (double)offset;
        double bottom = rect.y + rect.height - (double)offset;
        if (rightTop != 0) {
            gp.add((StiPathCommand)new StiPathLine(rect.x + (double)leftTop, rect.y, right - (double)(leftTop * 2), rect.y));
            gp.add((StiPathCommand)new StiPathArc(right - (double)(leftTop * 2), rect.y, (double)(leftTop * 2), (double)(leftTop * 2), 270.0, 90.0));
        } else {
            gp.add((StiPathCommand)new StiPathLine(rect.x + (double)leftTop, rect.y, right, rect.y));
        }
        if (rightBottom != 0) {
            gp.add((StiPathCommand)new StiPathLine(right, rect.y + (double)rightTop, right, bottom - (double)(rightTop * 2)));
            gp.add((StiPathCommand)new StiPathArc(right - (double)(rightTop * 2), bottom - (double)(rightTop * 2), (double)(rightTop * 2), (double)(rightTop * 2), 0.0, 90.0));
        } else {
            gp.add((StiPathCommand)new StiPathLine(right, rect.y + (double)rightTop, right, bottom));
        }
        if (leftBottom != 0) {
            gp.add((StiPathCommand)new StiPathLine(right - (double)(rightBottom * 2), bottom, rect.x + (double)rightBottom, bottom));
            gp.add((StiPathCommand)new StiPathArc(rect.x, bottom - (double)(rightBottom * 2), (double)(rightBottom * 2), (double)(rightBottom * 2), 90.0, 90.0));
        } else {
            gp.add((StiPathCommand)new StiPathLine(right - (double)rightBottom, bottom, rect.x, bottom));
        }
        if (leftTop != 0) {
            gp.add((StiPathCommand)new StiPathLine(rect.x, bottom - (double)(leftTop * 2), rect.x, rect.y + (double)leftTop));
            gp.add((StiPathCommand)new StiPathArc(rect.x, rect.y, (double)(leftTop * 2), (double)(leftTop * 2), 180.0, 90.0));
        } else {
            gp.add((StiPathCommand)new StiPathLine(rect.x, bottom - (double)leftTop, rect.x, rect.y));
        }
        gp.add((StiPathCommand)new StiPathClose());
        return gp;
    }

    public static List<StiPathCommand> getArcGeometry(StiRectangle rect, double startAngle, double sweepAngle, double startWidth, double endWidth) {
        StiPoint lastPoint;
        ArrayList<StiPathCommand> path = new ArrayList<StiPathCommand>();
        StiPoint centerPoint = new StiPoint(StiRectangleHelper.centerX(rect), StiRectangleHelper.centerY(rect));
        double radius = Math.min(rect.width / 2.0, rect.height / 2.0);
        double currentStartAngle = startAngle * (Math.PI / 180);
        double x1 = centerPoint.x + radius * Math.cos(currentStartAngle);
        double y1 = centerPoint.y + radius * Math.sin(currentStartAngle);
        StiPoint firstPoint = lastPoint = new StiPoint(x1, y1);
        double steps = StiDrawingHelper.round(Math.abs(sweepAngle / 90.0));
        double stepAngle = sweepAngle / steps;
        currentStartAngle = startAngle;
        int indexStep = 0;
        while ((double)indexStep < steps) {
            List<StiPoint> points = StiDrawingHelper.convertArcToCubicBezier(centerPoint, radius, currentStartAngle, stepAngle);
            path.add((StiPathCommand)new StiPathCubicBezier(lastPoint.x, lastPoint.y, points.get((int)1).x, points.get((int)1).y, points.get((int)2).x, points.get((int)2).y, points.get((int)3).x, points.get((int)3).y));
            lastPoint = points.get(3);
            currentStartAngle += stepAngle;
            ++indexStep;
        }
        StiPoint lastFirstPoint = lastPoint;
        steps = StiDrawingHelper.round(Math.abs(sweepAngle / 90.0));
        stepAngle = sweepAngle / steps;
        double secondStartRadius = radius - rect.width * startWidth;
        double secondEndRadius = radius - rect.width * endWidth;
        if (secondStartRadius <= 0.0 || secondEndRadius <= 0.0) {
            return null;
        }
        double offsetSecondRadius = secondStartRadius - secondEndRadius;
        double offsetStep = 1.0 / steps;
        double offset = offsetSecondRadius;
        boolean isFirst = false;
        currentStartAngle = sweepAngle + startAngle;
        int indexStep2 = 0;
        while ((double)indexStep2 < steps) {
            double startRadius = secondStartRadius - offsetSecondRadius * offset;
            double endRadius = secondStartRadius - offsetSecondRadius * (offset + offsetStep);
            List<StiPoint> points = StiDrawingHelper.convertArcToCubicBezier(centerPoint, startRadius, endRadius, currentStartAngle, -stepAngle);
            if (!isFirst) {
                lastPoint = points.get(0);
                isFirst = true;
            }
            path.add((StiPathCommand)new StiPathCubicBezier(lastPoint.x, lastPoint.y, points.get((int)1).x, points.get((int)1).y, points.get((int)2).x, points.get((int)2).y, points.get((int)3).x, points.get((int)3).y));
            lastPoint = points.get(3);
            currentStartAngle -= stepAngle;
            offset += offsetStep;
            ++indexStep2;
        }
        if (path.size() > 0) {
            path.add((StiPathCommand)new StiPathClose());
        }
        return path;
    }

    public static List<StiPathCommand> getRadialRangeGeometry(StiPoint centerPoint, double startAngle, double sweepAngle, double radius1, double radius2, double radius3, double radius4) {
        StiPoint lastPoint;
        ArrayList<StiPathCommand> path = new ArrayList<StiPathCommand>();
        double currentStartAngle = startAngle * (Math.PI / 180);
        double x1 = centerPoint.x + radius1 * Math.cos(currentStartAngle);
        double y1 = centerPoint.y + radius1 * Math.sin(currentStartAngle);
        StiPoint firstPoint = lastPoint = new StiPoint(x1, y1);
        double steps = StiDrawingHelper.round(Math.abs(sweepAngle / 90.0));
        double stepAngle = sweepAngle / steps;
        currentStartAngle = startAngle;
        double restRadius = radius1 - radius2;
        double offsetStep = 1.0 / steps;
        double offset = 0.0;
        currentStartAngle = startAngle;
        int indexStep = 0;
        while ((double)indexStep < steps) {
            double startRadius = radius1 - restRadius * offset;
            double endRadius = radius1 - restRadius * (offset + offsetStep);
            List<StiPoint> points = StiDrawingHelper.convertArcToCubicBezier(centerPoint, startRadius, endRadius, currentStartAngle, stepAngle);
            path.add((StiPathCommand)new StiPathCubicBezier(lastPoint.x, lastPoint.y, points.get((int)1).x, points.get((int)1).y, points.get((int)2).x, points.get((int)2).y, points.get((int)3).x, points.get((int)3).y));
            lastPoint = points.get(3);
            currentStartAngle += stepAngle;
            offset += offsetStep;
            ++indexStep;
        }
        StiPoint lastFirstPoint = lastPoint;
        stepAngle = sweepAngle / steps;
        restRadius = radius3 - radius4;
        offsetStep = 1.0 / steps;
        offset = 0.0;
        boolean isFirst = false;
        currentStartAngle = sweepAngle + startAngle;
        int indexStep2 = 0;
        while ((double)indexStep2 < steps) {
            double startRadius = radius3 - restRadius * offset;
            double endRadius = radius3 - restRadius * (offset + offsetStep);
            List<StiPoint> points = StiDrawingHelper.convertArcToCubicBezier(centerPoint, startRadius, endRadius, currentStartAngle, -stepAngle);
            if (!isFirst) {
                lastPoint = points.get(0);
                isFirst = true;
            }
            path.add((StiPathCommand)new StiPathCubicBezier(lastPoint.x, lastPoint.y, points.get((int)1).x, points.get((int)1).y, points.get((int)2).x, points.get((int)2).y, points.get((int)3).x, points.get((int)3).y));
            lastPoint = points.get(3);
            currentStartAngle -= stepAngle;
            offset += offsetStep;
            ++indexStep2;
        }
        if (path.size() > 0) {
            path.add((StiPathCommand)new StiPathClose());
        }
        return path;
    }

    private static double round(double value) {
        int value1 = (int)value;
        double rest = value - (double)value1;
        return rest > 0.0 ? (double)(value1 + 1) : (double)value1;
    }

    private static List<StiPoint> convertArcToCubicBezier(StiPoint centerPoint, double radius, double startAngle, double sweepAngle) {
        double startAngle1 = startAngle * (Math.PI / 180);
        double sweepAngle1 = sweepAngle * (Math.PI / 180);
        double endAngle1 = startAngle1 + sweepAngle1;
        double x1 = centerPoint.x + radius * Math.cos(startAngle1);
        double y1 = centerPoint.y + radius * Math.sin(startAngle1);
        double x2 = centerPoint.x + radius * Math.cos(endAngle1);
        double y2 = centerPoint.y + radius * Math.sin(endAngle1);
        double l = radius * 1.3333333730697632 * Math.tan(0.25 * sweepAngle1);
        double aL = Math.atan(l / radius);
        double radL = radius / Math.cos(aL);
        double ax1 = centerPoint.x + radL * Math.cos(aL += startAngle1);
        double ay1 = centerPoint.y + radL * Math.sin(aL);
        aL = Math.atan(-l / radius);
        double ax2 = centerPoint.x + radL * Math.cos(aL += endAngle1);
        double ay2 = centerPoint.y + radL * Math.sin(aL);
        ArrayList<StiPoint> points = new ArrayList<StiPoint>(4);
        points.add(new StiPoint(x1, y1));
        points.add(new StiPoint(ax1, ay1));
        points.add(new StiPoint(ax2, ay2));
        points.add(new StiPoint(x2, y2));
        return points;
    }

    private static List<StiPoint> convertArcToCubicBezier(StiPoint centerPoint, double radius1, double radius2, double startAngle, double sweepAngle) {
        double startAngle1 = startAngle * (Math.PI / 180);
        double sweepAngle1 = sweepAngle * (Math.PI / 180);
        double endAngle = startAngle1 + sweepAngle1;
        double x1 = centerPoint.x + radius1 * Math.cos(startAngle1);
        double y1 = centerPoint.y + radius1 * Math.sin(startAngle1);
        double x2 = centerPoint.x + radius2 * Math.cos(endAngle);
        double y2 = centerPoint.y + radius2 * Math.sin(endAngle);
        double rest = (radius1 - radius2) / 3.0;
        radius2 += rest;
        double l = (radius1 -= rest) * 1.3333333730697632 * Math.tan(0.25 * sweepAngle1);
        double aL = Math.atan(l / radius1);
        double radL = radius1 / Math.cos(aL);
        double ax1 = centerPoint.x + radL * Math.cos(aL += startAngle1);
        double ay1 = centerPoint.y + radL * Math.sin(aL);
        aL = Math.atan(-l / radius1);
        double ax2 = centerPoint.x + radL * Math.cos(aL += endAngle);
        double ay2 = centerPoint.y + radL * Math.sin(aL);
        ArrayList<StiPoint> points = new ArrayList<StiPoint>(4);
        points.add(new StiPoint(x1, y1));
        points.add(new StiPoint(ax1, ay1));
        points.add(new StiPoint(ax2, ay2));
        points.add(new StiPoint(x2, y2));
        return points;
    }
}

