/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.report.infographics.gauge.primitives.range;

import com.stimulsoft.base.StiJsonReportObjectHelper;
import com.stimulsoft.base.StiJsonSaveMode;
import com.stimulsoft.base.drawing.StiBrush;
import com.stimulsoft.base.drawing.StiColorEnum;
import com.stimulsoft.base.drawing.StiEmptyBrush;
import com.stimulsoft.base.drawing.StiSolidBrush;
import com.stimulsoft.base.json.JProperty;
import com.stimulsoft.base.json.JSONException;
import com.stimulsoft.base.json.JSONObject;
import com.stimulsoft.base.serializing.annotations.StiSerializable;
import com.stimulsoft.base.serializing.interfaceobject.IStiSerializableRef;
import com.stimulsoft.report.infographics.gauge.StiPlacement;
import com.stimulsoft.report.infographics.gauge.primitives.range.StiScaleRangeList;
import com.stimulsoft.report.infographics.gauge.primitives.scales.StiScaleBase;
import com.stimulsoft.report.painters.StiGaugeContextPainter;

public abstract class StiRangeBase
implements IStiSerializableRef {
    private int reference = -1;
    private StiBrush brush = new StiSolidBrush(StiColorEnum.White.color());
    private StiBrush borderBrush = new StiEmptyBrush();
    private double borderWidth = 1.0;
    private double startValue = 0.0;
    private double endValue = 0.0;
    private double startWidth = 0.0;
    private double endWidth = 0.0;
    private StiPlacement placement = StiPlacement.Overlay;
    private double offset = 0.0;
    private StiScaleRangeList rangeList;

    public void setReference(int reference) {
        this.reference = reference;
    }

    public int getReference() {
        return this.reference;
    }

    public void cleanReference() {
        this.reference = -1;
    }

    public JSONObject SaveToJsonObject(StiJsonSaveMode mode) throws JSONException {
        JSONObject jObject = new JSONObject();
        jObject.AddPropertyStringNullOfEmpty("Brush", StiJsonReportObjectHelper.Serialize.JBrush((StiBrush)this.brush));
        jObject.AddPropertyStringNullOfEmpty("BorderBrush", StiJsonReportObjectHelper.Serialize.JBrush((StiBrush)this.borderBrush));
        jObject.AddPropertyFloat("BorderWidth", this.borderWidth, 1.0);
        jObject.AddPropertyFloat("StartValue", this.startValue, 0.0);
        jObject.AddPropertyFloat("EndValue", this.endValue, 0.0);
        jObject.AddPropertyFloat("StartWidth", this.startWidth, 0.0);
        jObject.AddPropertyFloat("EndWidth", this.endWidth, 0.0);
        jObject.AddPropertyEnum("Placement", (Enum)this.placement);
        jObject.AddPropertyFloat("Offset", this.offset, 0.0);
        return jObject;
    }

    public void LoadFromJsonObject(JSONObject jObject) throws JSONException {
        for (JProperty property : jObject.Properties()) {
            if ("Brush".equals(property.Name)) {
                this.setBrush(StiJsonReportObjectHelper.Deserialize.Brush((JProperty)property));
                continue;
            }
            if ("BorderBrush".equals(property.Name)) {
                this.setBorderBrush(StiJsonReportObjectHelper.Deserialize.Brush((JProperty)property));
                continue;
            }
            if ("BorderWidth".equals(property.Name)) {
                this.setBorderWidth(Double.parseDouble(property.Value.toString()));
                continue;
            }
            if ("StartValue".equals(property.Name)) {
                this.setStartValue(Double.parseDouble(property.Value.toString()));
                continue;
            }
            if ("EndValue".equals(property.Name)) {
                this.setEndValue(Double.parseDouble(property.Value.toString()));
                continue;
            }
            if ("StartWidth".equals(property.Name)) {
                this.setStartWidth(Double.parseDouble(property.Value.toString()));
                continue;
            }
            if ("EndWidth".equals(property.Name)) {
                this.setEndWidth(Double.parseDouble(property.Value.toString()));
                continue;
            }
            if ("Placement".equals(property.Name)) {
                this.setPlacement(StiPlacement.valueOf(property.Value.toString()));
                continue;
            }
            if (!"Offset".equals(property.Name)) continue;
            this.setOffset(Double.parseDouble(property.Value.toString()));
        }
    }

    public Object clone() {
        StiRangeBase range = null;
        try {
            range = (StiRangeBase)this.getClass().newInstance();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        range.brush = this.brush != null ? (StiBrush)this.brush.clone() : null;
        range.borderBrush = this.borderBrush != null ? (StiBrush)this.borderBrush.clone() : null;
        range.borderWidth = this.borderWidth;
        range.endValue = this.endValue;
        range.offset = this.offset;
        range.endWidth = this.endWidth;
        range.placement = this.placement;
        range.startValue = this.startValue;
        range.startWidth = this.startWidth;
        return range;
    }

    @StiSerializable
    public StiBrush getBrush() {
        return this.brush;
    }

    public void setBrush(StiBrush brush) {
        this.brush = brush;
    }

    @StiSerializable
    public StiBrush getBorderBrush() {
        return this.borderBrush;
    }

    public void setBorderBrush(StiBrush borderBrush) {
        this.borderBrush = borderBrush;
    }

    @StiSerializable
    public double getBorderWidth() {
        return this.borderWidth;
    }

    public void setBorderWidth(double borderWidth) {
        this.borderWidth = borderWidth;
    }

    @StiSerializable
    public double getStartValue() {
        return this.startValue;
    }

    public void setStartValue(double startValue) {
        this.startValue = startValue;
    }

    @StiSerializable
    public double getEndValue() {
        return this.endValue;
    }

    public void setEndValue(double endValue) {
        this.endValue = endValue;
    }

    @StiSerializable
    public double getStartWidth() {
        return this.startWidth;
    }

    public void setStartWidth(double startWidth) {
        this.startWidth = startWidth;
    }

    @StiSerializable
    public double getEndWidth() {
        return this.endWidth;
    }

    public void setEndWidth(double endWidth) {
        this.endWidth = endWidth;
    }

    @StiSerializable
    public StiPlacement getPlacement() {
        return this.placement;
    }

    public void setPlacement(StiPlacement placement) {
        this.placement = placement;
    }

    @StiSerializable
    public double getOffset() {
        return this.offset;
    }

    public void setOffset(double offset) {
        this.offset = offset;
    }

    public StiScaleRangeList getRangeList() {
        return this.rangeList;
    }

    public void setRangeList(StiScaleRangeList rangeList) {
        this.rangeList = rangeList;
    }

    public abstract String getLocalizeName();

    protected abstract void drawRange(StiGaugeContextPainter var1, StiScaleBase var2);

    public StiRangeBase createNew() {
        throw new RuntimeException(" NotImplemented");
    }
}

