/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.report.infographics.gauge.primitives.tick;

import com.stimulsoft.base.StiJsonReportObjectHelper;
import com.stimulsoft.base.StiJsonSaveMode;
import com.stimulsoft.base.drawing.StiBrush;
import com.stimulsoft.base.drawing.StiColorEnum;
import com.stimulsoft.base.drawing.StiSolidBrush;
import com.stimulsoft.base.json.JProperty;
import com.stimulsoft.base.json.JSONException;
import com.stimulsoft.base.json.JSONObject;
import com.stimulsoft.base.serializing.annotations.StiSerializable;
import com.stimulsoft.base.system.StiFont;
import com.stimulsoft.lib.utils.StiStringUtil;
import com.stimulsoft.lib.utils.StiValidationUtil;
import com.stimulsoft.report.infographics.gauge.primitives.tick.StiTickBase;

public abstract class StiTickLabelBase
extends StiTickBase {
    private String textFormat = null;
    private StiBrush textBrush = new StiSolidBrush(StiColorEnum.Black.color());
    private StiFont font = new StiFont("Arial", 10.0);

    @Override
    public JSONObject SaveToJsonObject(StiJsonSaveMode mode) throws JSONException {
        JSONObject jObject = super.SaveToJsonObject(mode);
        jObject.AddPropertyString("TextFormat", this.textFormat);
        jObject.AddPropertyStringNullOfEmpty("TextBrush", StiJsonReportObjectHelper.Serialize.JBrush((StiBrush)this.textBrush));
        jObject.AddPropertyStringNullOfEmpty("Font", StiJsonReportObjectHelper.Serialize.font((StiFont)this.font, (String)"Arial", (float)10.0f));
        return jObject;
    }

    @Override
    public void LoadFromJsonObject(JSONObject jObject) throws JSONException {
        super.LoadFromJsonObject(jObject);
        for (JProperty property : jObject.Properties()) {
            if ("TextFormat".equals(property.Name)) {
                this.setTextFormat(property.Value.toString());
                continue;
            }
            if ("TextBrush".equals(property.Name)) {
                this.setTextBrush(StiJsonReportObjectHelper.Deserialize.Brush((JProperty)property));
                continue;
            }
            if (!"Font".equals(property.Name)) continue;
            this.setFont(StiJsonReportObjectHelper.Deserialize.Font((JProperty)property, (StiFont)this.font));
        }
    }

    @Override
    public Object clone() {
        StiTickLabelBase tickLabel = (StiTickLabelBase)super.clone();
        tickLabel.textBrush = (StiBrush)this.textBrush.clone();
        tickLabel.textFormat = this.getTextFormat();
        tickLabel.font = (StiFont)this.font.clone();
        return tickLabel;
    }

    @StiSerializable
    public String getTextFormat() {
        return this.textFormat;
    }

    public void setTextFormat(String textFormat) {
        this.textFormat = textFormat;
    }

    @StiSerializable
    public StiBrush getTextBrush() {
        return this.textBrush;
    }

    public void setTextBrush(StiBrush textBrush) {
        this.textBrush = textBrush;
    }

    @StiSerializable
    public StiFont getFont() {
        return this.font;
    }

    public void setFont(StiFont font) {
        this.font = font;
    }

    protected String getTextForRender(Double value, String format) {
        if (StiValidationUtil.isNullOrEmpty((String)format)) {
            double d = value;
            if (d == (double)((long)d)) {
                return String.format("%d", (long)d);
            }
            return String.format("%s", d);
        }
        return StiStringUtil.format((String)format, (Object)value);
    }

    protected String getTextForRender(String value) {
        return this.getTextForRender(value, this.getTextFormat());
    }

    protected String getTextForRender(String value, String format) {
        if (StiValidationUtil.isNullOrEmpty((String)format)) {
            return value;
        }
        return StiStringUtil.format((String)format, (Object)value);
    }
}

